// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chimesdkmediapipelines

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateMediaCapturePipeline = "CreateMediaCapturePipeline"

// CreateMediaCapturePipelineRequest generates a "aws/request.Request" representing the
// client's request for the CreateMediaCapturePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMediaCapturePipeline for more information on using the CreateMediaCapturePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMediaCapturePipelineRequest method.
//	req, resp := client.CreateMediaCapturePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaCapturePipeline
func (c *ChimeSDKMediaPipelines) CreateMediaCapturePipelineRequest(input *CreateMediaCapturePipelineInput) (req *request.Request, output *CreateMediaCapturePipelineOutput) {
	op := &request.Operation{
		Name:       opCreateMediaCapturePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/sdk-media-capture-pipelines",
	}

	if input == nil {
		input = &CreateMediaCapturePipelineInput{}
	}

	output = &CreateMediaCapturePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMediaCapturePipeline API operation for Amazon Chime SDK Media Pipelines.
//
// Creates a media pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation CreateMediaCapturePipeline for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaCapturePipeline
func (c *ChimeSDKMediaPipelines) CreateMediaCapturePipeline(input *CreateMediaCapturePipelineInput) (*CreateMediaCapturePipelineOutput, error) {
	req, out := c.CreateMediaCapturePipelineRequest(input)
	return out, req.Send()
}

// CreateMediaCapturePipelineWithContext is the same as CreateMediaCapturePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMediaCapturePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) CreateMediaCapturePipelineWithContext(ctx aws.Context, input *CreateMediaCapturePipelineInput, opts ...request.Option) (*CreateMediaCapturePipelineOutput, error) {
	req, out := c.CreateMediaCapturePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMediaConcatenationPipeline = "CreateMediaConcatenationPipeline"

// CreateMediaConcatenationPipelineRequest generates a "aws/request.Request" representing the
// client's request for the CreateMediaConcatenationPipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMediaConcatenationPipeline for more information on using the CreateMediaConcatenationPipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMediaConcatenationPipelineRequest method.
//	req, resp := client.CreateMediaConcatenationPipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaConcatenationPipeline
func (c *ChimeSDKMediaPipelines) CreateMediaConcatenationPipelineRequest(input *CreateMediaConcatenationPipelineInput) (req *request.Request, output *CreateMediaConcatenationPipelineOutput) {
	op := &request.Operation{
		Name:       opCreateMediaConcatenationPipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/sdk-media-concatenation-pipelines",
	}

	if input == nil {
		input = &CreateMediaConcatenationPipelineInput{}
	}

	output = &CreateMediaConcatenationPipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMediaConcatenationPipeline API operation for Amazon Chime SDK Media Pipelines.
//
// Creates a media concatenation pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation CreateMediaConcatenationPipeline for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaConcatenationPipeline
func (c *ChimeSDKMediaPipelines) CreateMediaConcatenationPipeline(input *CreateMediaConcatenationPipelineInput) (*CreateMediaConcatenationPipelineOutput, error) {
	req, out := c.CreateMediaConcatenationPipelineRequest(input)
	return out, req.Send()
}

// CreateMediaConcatenationPipelineWithContext is the same as CreateMediaConcatenationPipeline with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMediaConcatenationPipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) CreateMediaConcatenationPipelineWithContext(ctx aws.Context, input *CreateMediaConcatenationPipelineInput, opts ...request.Option) (*CreateMediaConcatenationPipelineOutput, error) {
	req, out := c.CreateMediaConcatenationPipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMediaLiveConnectorPipeline = "CreateMediaLiveConnectorPipeline"

// CreateMediaLiveConnectorPipelineRequest generates a "aws/request.Request" representing the
// client's request for the CreateMediaLiveConnectorPipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMediaLiveConnectorPipeline for more information on using the CreateMediaLiveConnectorPipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMediaLiveConnectorPipelineRequest method.
//	req, resp := client.CreateMediaLiveConnectorPipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaLiveConnectorPipeline
func (c *ChimeSDKMediaPipelines) CreateMediaLiveConnectorPipelineRequest(input *CreateMediaLiveConnectorPipelineInput) (req *request.Request, output *CreateMediaLiveConnectorPipelineOutput) {
	op := &request.Operation{
		Name:       opCreateMediaLiveConnectorPipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/sdk-media-live-connector-pipelines",
	}

	if input == nil {
		input = &CreateMediaLiveConnectorPipelineInput{}
	}

	output = &CreateMediaLiveConnectorPipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMediaLiveConnectorPipeline API operation for Amazon Chime SDK Media Pipelines.
//
// Creates a streaming media pipeline in an Amazon Chime SDK meeting.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation CreateMediaLiveConnectorPipeline for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaLiveConnectorPipeline
func (c *ChimeSDKMediaPipelines) CreateMediaLiveConnectorPipeline(input *CreateMediaLiveConnectorPipelineInput) (*CreateMediaLiveConnectorPipelineOutput, error) {
	req, out := c.CreateMediaLiveConnectorPipelineRequest(input)
	return out, req.Send()
}

// CreateMediaLiveConnectorPipelineWithContext is the same as CreateMediaLiveConnectorPipeline with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMediaLiveConnectorPipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) CreateMediaLiveConnectorPipelineWithContext(ctx aws.Context, input *CreateMediaLiveConnectorPipelineInput, opts ...request.Option) (*CreateMediaLiveConnectorPipelineOutput, error) {
	req, out := c.CreateMediaLiveConnectorPipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMediaCapturePipeline = "DeleteMediaCapturePipeline"

// DeleteMediaCapturePipelineRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMediaCapturePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMediaCapturePipeline for more information on using the DeleteMediaCapturePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMediaCapturePipelineRequest method.
//	req, resp := client.DeleteMediaCapturePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/DeleteMediaCapturePipeline
func (c *ChimeSDKMediaPipelines) DeleteMediaCapturePipelineRequest(input *DeleteMediaCapturePipelineInput) (req *request.Request, output *DeleteMediaCapturePipelineOutput) {
	op := &request.Operation{
		Name:       opDeleteMediaCapturePipeline,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sdk-media-capture-pipelines/{mediaPipelineId}",
	}

	if input == nil {
		input = &DeleteMediaCapturePipelineInput{}
	}

	output = &DeleteMediaCapturePipelineOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMediaCapturePipeline API operation for Amazon Chime SDK Media Pipelines.
//
// Deletes the media pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation DeleteMediaCapturePipeline for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/DeleteMediaCapturePipeline
func (c *ChimeSDKMediaPipelines) DeleteMediaCapturePipeline(input *DeleteMediaCapturePipelineInput) (*DeleteMediaCapturePipelineOutput, error) {
	req, out := c.DeleteMediaCapturePipelineRequest(input)
	return out, req.Send()
}

// DeleteMediaCapturePipelineWithContext is the same as DeleteMediaCapturePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMediaCapturePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) DeleteMediaCapturePipelineWithContext(ctx aws.Context, input *DeleteMediaCapturePipelineInput, opts ...request.Option) (*DeleteMediaCapturePipelineOutput, error) {
	req, out := c.DeleteMediaCapturePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMediaPipeline = "DeleteMediaPipeline"

// DeleteMediaPipelineRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMediaPipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMediaPipeline for more information on using the DeleteMediaPipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMediaPipelineRequest method.
//	req, resp := client.DeleteMediaPipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/DeleteMediaPipeline
func (c *ChimeSDKMediaPipelines) DeleteMediaPipelineRequest(input *DeleteMediaPipelineInput) (req *request.Request, output *DeleteMediaPipelineOutput) {
	op := &request.Operation{
		Name:       opDeleteMediaPipeline,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sdk-media-pipelines/{mediaPipelineId}",
	}

	if input == nil {
		input = &DeleteMediaPipelineInput{}
	}

	output = &DeleteMediaPipelineOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMediaPipeline API operation for Amazon Chime SDK Media Pipelines.
//
// Deletes the media pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation DeleteMediaPipeline for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/DeleteMediaPipeline
func (c *ChimeSDKMediaPipelines) DeleteMediaPipeline(input *DeleteMediaPipelineInput) (*DeleteMediaPipelineOutput, error) {
	req, out := c.DeleteMediaPipelineRequest(input)
	return out, req.Send()
}

// DeleteMediaPipelineWithContext is the same as DeleteMediaPipeline with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMediaPipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) DeleteMediaPipelineWithContext(ctx aws.Context, input *DeleteMediaPipelineInput, opts ...request.Option) (*DeleteMediaPipelineOutput, error) {
	req, out := c.DeleteMediaPipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMediaCapturePipeline = "GetMediaCapturePipeline"

// GetMediaCapturePipelineRequest generates a "aws/request.Request" representing the
// client's request for the GetMediaCapturePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMediaCapturePipeline for more information on using the GetMediaCapturePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMediaCapturePipelineRequest method.
//	req, resp := client.GetMediaCapturePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetMediaCapturePipeline
func (c *ChimeSDKMediaPipelines) GetMediaCapturePipelineRequest(input *GetMediaCapturePipelineInput) (req *request.Request, output *GetMediaCapturePipelineOutput) {
	op := &request.Operation{
		Name:       opGetMediaCapturePipeline,
		HTTPMethod: "GET",
		HTTPPath:   "/sdk-media-capture-pipelines/{mediaPipelineId}",
	}

	if input == nil {
		input = &GetMediaCapturePipelineInput{}
	}

	output = &GetMediaCapturePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMediaCapturePipeline API operation for Amazon Chime SDK Media Pipelines.
//
// Gets an existing media pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation GetMediaCapturePipeline for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetMediaCapturePipeline
func (c *ChimeSDKMediaPipelines) GetMediaCapturePipeline(input *GetMediaCapturePipelineInput) (*GetMediaCapturePipelineOutput, error) {
	req, out := c.GetMediaCapturePipelineRequest(input)
	return out, req.Send()
}

// GetMediaCapturePipelineWithContext is the same as GetMediaCapturePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See GetMediaCapturePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) GetMediaCapturePipelineWithContext(ctx aws.Context, input *GetMediaCapturePipelineInput, opts ...request.Option) (*GetMediaCapturePipelineOutput, error) {
	req, out := c.GetMediaCapturePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMediaPipeline = "GetMediaPipeline"

// GetMediaPipelineRequest generates a "aws/request.Request" representing the
// client's request for the GetMediaPipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMediaPipeline for more information on using the GetMediaPipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMediaPipelineRequest method.
//	req, resp := client.GetMediaPipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetMediaPipeline
func (c *ChimeSDKMediaPipelines) GetMediaPipelineRequest(input *GetMediaPipelineInput) (req *request.Request, output *GetMediaPipelineOutput) {
	op := &request.Operation{
		Name:       opGetMediaPipeline,
		HTTPMethod: "GET",
		HTTPPath:   "/sdk-media-pipelines/{mediaPipelineId}",
	}

	if input == nil {
		input = &GetMediaPipelineInput{}
	}

	output = &GetMediaPipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMediaPipeline API operation for Amazon Chime SDK Media Pipelines.
//
// Gets an existing media pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation GetMediaPipeline for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetMediaPipeline
func (c *ChimeSDKMediaPipelines) GetMediaPipeline(input *GetMediaPipelineInput) (*GetMediaPipelineOutput, error) {
	req, out := c.GetMediaPipelineRequest(input)
	return out, req.Send()
}

// GetMediaPipelineWithContext is the same as GetMediaPipeline with the addition of
// the ability to pass a context and additional request options.
//
// See GetMediaPipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) GetMediaPipelineWithContext(ctx aws.Context, input *GetMediaPipelineInput, opts ...request.Option) (*GetMediaPipelineOutput, error) {
	req, out := c.GetMediaPipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMediaCapturePipelines = "ListMediaCapturePipelines"

// ListMediaCapturePipelinesRequest generates a "aws/request.Request" representing the
// client's request for the ListMediaCapturePipelines operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMediaCapturePipelines for more information on using the ListMediaCapturePipelines
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMediaCapturePipelinesRequest method.
//	req, resp := client.ListMediaCapturePipelinesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListMediaCapturePipelines
func (c *ChimeSDKMediaPipelines) ListMediaCapturePipelinesRequest(input *ListMediaCapturePipelinesInput) (req *request.Request, output *ListMediaCapturePipelinesOutput) {
	op := &request.Operation{
		Name:       opListMediaCapturePipelines,
		HTTPMethod: "GET",
		HTTPPath:   "/sdk-media-capture-pipelines",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMediaCapturePipelinesInput{}
	}

	output = &ListMediaCapturePipelinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMediaCapturePipelines API operation for Amazon Chime SDK Media Pipelines.
//
// Returns a list of media pipelines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation ListMediaCapturePipelines for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListMediaCapturePipelines
func (c *ChimeSDKMediaPipelines) ListMediaCapturePipelines(input *ListMediaCapturePipelinesInput) (*ListMediaCapturePipelinesOutput, error) {
	req, out := c.ListMediaCapturePipelinesRequest(input)
	return out, req.Send()
}

// ListMediaCapturePipelinesWithContext is the same as ListMediaCapturePipelines with the addition of
// the ability to pass a context and additional request options.
//
// See ListMediaCapturePipelines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) ListMediaCapturePipelinesWithContext(ctx aws.Context, input *ListMediaCapturePipelinesInput, opts ...request.Option) (*ListMediaCapturePipelinesOutput, error) {
	req, out := c.ListMediaCapturePipelinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMediaCapturePipelinesPages iterates over the pages of a ListMediaCapturePipelines operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMediaCapturePipelines method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMediaCapturePipelines operation.
//	pageNum := 0
//	err := client.ListMediaCapturePipelinesPages(params,
//	    func(page *chimesdkmediapipelines.ListMediaCapturePipelinesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKMediaPipelines) ListMediaCapturePipelinesPages(input *ListMediaCapturePipelinesInput, fn func(*ListMediaCapturePipelinesOutput, bool) bool) error {
	return c.ListMediaCapturePipelinesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMediaCapturePipelinesPagesWithContext same as ListMediaCapturePipelinesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) ListMediaCapturePipelinesPagesWithContext(ctx aws.Context, input *ListMediaCapturePipelinesInput, fn func(*ListMediaCapturePipelinesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMediaCapturePipelinesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMediaCapturePipelinesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMediaCapturePipelinesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMediaPipelines = "ListMediaPipelines"

// ListMediaPipelinesRequest generates a "aws/request.Request" representing the
// client's request for the ListMediaPipelines operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMediaPipelines for more information on using the ListMediaPipelines
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMediaPipelinesRequest method.
//	req, resp := client.ListMediaPipelinesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListMediaPipelines
func (c *ChimeSDKMediaPipelines) ListMediaPipelinesRequest(input *ListMediaPipelinesInput) (req *request.Request, output *ListMediaPipelinesOutput) {
	op := &request.Operation{
		Name:       opListMediaPipelines,
		HTTPMethod: "GET",
		HTTPPath:   "/sdk-media-pipelines",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMediaPipelinesInput{}
	}

	output = &ListMediaPipelinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMediaPipelines API operation for Amazon Chime SDK Media Pipelines.
//
// Returns a list of media pipelines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation ListMediaPipelines for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListMediaPipelines
func (c *ChimeSDKMediaPipelines) ListMediaPipelines(input *ListMediaPipelinesInput) (*ListMediaPipelinesOutput, error) {
	req, out := c.ListMediaPipelinesRequest(input)
	return out, req.Send()
}

// ListMediaPipelinesWithContext is the same as ListMediaPipelines with the addition of
// the ability to pass a context and additional request options.
//
// See ListMediaPipelines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) ListMediaPipelinesWithContext(ctx aws.Context, input *ListMediaPipelinesInput, opts ...request.Option) (*ListMediaPipelinesOutput, error) {
	req, out := c.ListMediaPipelinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMediaPipelinesPages iterates over the pages of a ListMediaPipelines operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMediaPipelines method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMediaPipelines operation.
//	pageNum := 0
//	err := client.ListMediaPipelinesPages(params,
//	    func(page *chimesdkmediapipelines.ListMediaPipelinesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKMediaPipelines) ListMediaPipelinesPages(input *ListMediaPipelinesInput, fn func(*ListMediaPipelinesOutput, bool) bool) error {
	return c.ListMediaPipelinesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMediaPipelinesPagesWithContext same as ListMediaPipelinesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) ListMediaPipelinesPagesWithContext(ctx aws.Context, input *ListMediaPipelinesInput, fn func(*ListMediaPipelinesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMediaPipelinesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMediaPipelinesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMediaPipelinesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListTagsForResource
func (c *ChimeSDKMediaPipelines) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Chime SDK Media Pipelines.
//
// Lists the tags available for a media pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListTagsForResource
func (c *ChimeSDKMediaPipelines) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/TagResource
func (c *ChimeSDKMediaPipelines) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags?operation=tag-resource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Chime SDK Media Pipelines.
//
// The ARN of the media pipeline that you want to tag. Consists of he pipeline's
// endpoint region, resource ID, and pipeline ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/TagResource
func (c *ChimeSDKMediaPipelines) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/UntagResource
func (c *ChimeSDKMediaPipelines) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags?operation=untag-resource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Chime SDK Media Pipelines.
//
// Removes any tags from a media pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/UntagResource
func (c *ChimeSDKMediaPipelines) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The configuration for the artifacts concatenation.
type ArtifactsConcatenationConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration for the audio artifacts concatenation.
	//
	// Audio is a required field
	Audio *AudioConcatenationConfiguration `type:"structure" required:"true"`

	// The configuration for the composited video artifacts concatenation.
	//
	// CompositedVideo is a required field
	CompositedVideo *CompositedVideoConcatenationConfiguration `type:"structure" required:"true"`

	// The configuration for the content artifacts concatenation.
	//
	// Content is a required field
	Content *ContentConcatenationConfiguration `type:"structure" required:"true"`

	// The configuration for the data channel artifacts concatenation.
	//
	// DataChannel is a required field
	DataChannel *DataChannelConcatenationConfiguration `type:"structure" required:"true"`

	// The configuration for the meeting events artifacts concatenation.
	//
	// MeetingEvents is a required field
	MeetingEvents *MeetingEventsConcatenationConfiguration `type:"structure" required:"true"`

	// The configuration for the transcription messages artifacts concatenation.
	//
	// TranscriptionMessages is a required field
	TranscriptionMessages *TranscriptionMessagesConcatenationConfiguration `type:"structure" required:"true"`

	// The configuration for the video artifacts concatenation.
	//
	// Video is a required field
	Video *VideoConcatenationConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactsConcatenationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactsConcatenationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArtifactsConcatenationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArtifactsConcatenationConfiguration"}
	if s.Audio == nil {
		invalidParams.Add(request.NewErrParamRequired("Audio"))
	}
	if s.CompositedVideo == nil {
		invalidParams.Add(request.NewErrParamRequired("CompositedVideo"))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.DataChannel == nil {
		invalidParams.Add(request.NewErrParamRequired("DataChannel"))
	}
	if s.MeetingEvents == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingEvents"))
	}
	if s.TranscriptionMessages == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptionMessages"))
	}
	if s.Video == nil {
		invalidParams.Add(request.NewErrParamRequired("Video"))
	}
	if s.Audio != nil {
		if err := s.Audio.Validate(); err != nil {
			invalidParams.AddNested("Audio", err.(request.ErrInvalidParams))
		}
	}
	if s.CompositedVideo != nil {
		if err := s.CompositedVideo.Validate(); err != nil {
			invalidParams.AddNested("CompositedVideo", err.(request.ErrInvalidParams))
		}
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}
	if s.DataChannel != nil {
		if err := s.DataChannel.Validate(); err != nil {
			invalidParams.AddNested("DataChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.MeetingEvents != nil {
		if err := s.MeetingEvents.Validate(); err != nil {
			invalidParams.AddNested("MeetingEvents", err.(request.ErrInvalidParams))
		}
	}
	if s.TranscriptionMessages != nil {
		if err := s.TranscriptionMessages.Validate(); err != nil {
			invalidParams.AddNested("TranscriptionMessages", err.(request.ErrInvalidParams))
		}
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudio sets the Audio field's value.
func (s *ArtifactsConcatenationConfiguration) SetAudio(v *AudioConcatenationConfiguration) *ArtifactsConcatenationConfiguration {
	s.Audio = v
	return s
}

// SetCompositedVideo sets the CompositedVideo field's value.
func (s *ArtifactsConcatenationConfiguration) SetCompositedVideo(v *CompositedVideoConcatenationConfiguration) *ArtifactsConcatenationConfiguration {
	s.CompositedVideo = v
	return s
}

// SetContent sets the Content field's value.
func (s *ArtifactsConcatenationConfiguration) SetContent(v *ContentConcatenationConfiguration) *ArtifactsConcatenationConfiguration {
	s.Content = v
	return s
}

// SetDataChannel sets the DataChannel field's value.
func (s *ArtifactsConcatenationConfiguration) SetDataChannel(v *DataChannelConcatenationConfiguration) *ArtifactsConcatenationConfiguration {
	s.DataChannel = v
	return s
}

// SetMeetingEvents sets the MeetingEvents field's value.
func (s *ArtifactsConcatenationConfiguration) SetMeetingEvents(v *MeetingEventsConcatenationConfiguration) *ArtifactsConcatenationConfiguration {
	s.MeetingEvents = v
	return s
}

// SetTranscriptionMessages sets the TranscriptionMessages field's value.
func (s *ArtifactsConcatenationConfiguration) SetTranscriptionMessages(v *TranscriptionMessagesConcatenationConfiguration) *ArtifactsConcatenationConfiguration {
	s.TranscriptionMessages = v
	return s
}

// SetVideo sets the Video field's value.
func (s *ArtifactsConcatenationConfiguration) SetVideo(v *VideoConcatenationConfiguration) *ArtifactsConcatenationConfiguration {
	s.Video = v
	return s
}

// The configuration for the artifacts.
type ArtifactsConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration for the audio artifacts.
	//
	// Audio is a required field
	Audio *AudioArtifactsConfiguration `type:"structure" required:"true"`

	// Enables video compositing.
	CompositedVideo *CompositedVideoArtifactsConfiguration `type:"structure"`

	// The configuration for the content artifacts.
	//
	// Content is a required field
	Content *ContentArtifactsConfiguration `type:"structure" required:"true"`

	// The configuration for the video artifacts.
	//
	// Video is a required field
	Video *VideoArtifactsConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArtifactsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArtifactsConfiguration"}
	if s.Audio == nil {
		invalidParams.Add(request.NewErrParamRequired("Audio"))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Video == nil {
		invalidParams.Add(request.NewErrParamRequired("Video"))
	}
	if s.Audio != nil {
		if err := s.Audio.Validate(); err != nil {
			invalidParams.AddNested("Audio", err.(request.ErrInvalidParams))
		}
	}
	if s.CompositedVideo != nil {
		if err := s.CompositedVideo.Validate(); err != nil {
			invalidParams.AddNested("CompositedVideo", err.(request.ErrInvalidParams))
		}
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudio sets the Audio field's value.
func (s *ArtifactsConfiguration) SetAudio(v *AudioArtifactsConfiguration) *ArtifactsConfiguration {
	s.Audio = v
	return s
}

// SetCompositedVideo sets the CompositedVideo field's value.
func (s *ArtifactsConfiguration) SetCompositedVideo(v *CompositedVideoArtifactsConfiguration) *ArtifactsConfiguration {
	s.CompositedVideo = v
	return s
}

// SetContent sets the Content field's value.
func (s *ArtifactsConfiguration) SetContent(v *ContentArtifactsConfiguration) *ArtifactsConfiguration {
	s.Content = v
	return s
}

// SetVideo sets the Video field's value.
func (s *ArtifactsConfiguration) SetVideo(v *VideoArtifactsConfiguration) *ArtifactsConfiguration {
	s.Video = v
	return s
}

// The audio artifact configuration object.
type AudioArtifactsConfiguration struct {
	_ struct{} `type:"structure"`

	// The MUX type of the audio artifact configuration object.
	//
	// MuxType is a required field
	MuxType *string `type:"string" required:"true" enum:"AudioMuxType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioArtifactsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioArtifactsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioArtifactsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioArtifactsConfiguration"}
	if s.MuxType == nil {
		invalidParams.Add(request.NewErrParamRequired("MuxType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMuxType sets the MuxType field's value.
func (s *AudioArtifactsConfiguration) SetMuxType(v string) *AudioArtifactsConfiguration {
	s.MuxType = &v
	return s
}

// The audio artifact concatenation configuration object.
type AudioConcatenationConfiguration struct {
	_ struct{} `type:"structure"`

	// Enables the name object, where name is the name of the configuration object,
	// such as AudioConcatenation.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"AudioArtifactsConcatenationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioConcatenationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioConcatenationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioConcatenationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioConcatenationConfiguration"}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetState sets the State field's value.
func (s *AudioConcatenationConfiguration) SetState(v string) *AudioConcatenationConfiguration {
	s.State = &v
	return s
}

// The input parameters don't match the service's restrictions.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration object of the Amazon Chime SDK meeting concatenation for
// a specified media pipeline.
type ChimeSdkMeetingConcatenationConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration for the artifacts in an Amazon Chime SDK meeting concatenation.
	//
	// ArtifactsConfiguration is a required field
	ArtifactsConfiguration *ArtifactsConcatenationConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChimeSdkMeetingConcatenationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChimeSdkMeetingConcatenationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChimeSdkMeetingConcatenationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChimeSdkMeetingConcatenationConfiguration"}
	if s.ArtifactsConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ArtifactsConfiguration"))
	}
	if s.ArtifactsConfiguration != nil {
		if err := s.ArtifactsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ArtifactsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifactsConfiguration sets the ArtifactsConfiguration field's value.
func (s *ChimeSdkMeetingConcatenationConfiguration) SetArtifactsConfiguration(v *ArtifactsConcatenationConfiguration) *ChimeSdkMeetingConcatenationConfiguration {
	s.ArtifactsConfiguration = v
	return s
}

// The configuration object of the Amazon Chime SDK meeting for a specified
// media pipeline. SourceType must be ChimeSdkMeeting.
type ChimeSdkMeetingConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration for the artifacts in an Amazon Chime SDK meeting.
	ArtifactsConfiguration *ArtifactsConfiguration `type:"structure"`

	// The source configuration for a specified media pipline.
	SourceConfiguration *SourceConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChimeSdkMeetingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChimeSdkMeetingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChimeSdkMeetingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChimeSdkMeetingConfiguration"}
	if s.ArtifactsConfiguration != nil {
		if err := s.ArtifactsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ArtifactsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceConfiguration != nil {
		if err := s.SourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SourceConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifactsConfiguration sets the ArtifactsConfiguration field's value.
func (s *ChimeSdkMeetingConfiguration) SetArtifactsConfiguration(v *ArtifactsConfiguration) *ChimeSdkMeetingConfiguration {
	s.ArtifactsConfiguration = v
	return s
}

// SetSourceConfiguration sets the SourceConfiguration field's value.
func (s *ChimeSdkMeetingConfiguration) SetSourceConfiguration(v *SourceConfiguration) *ChimeSdkMeetingConfiguration {
	s.SourceConfiguration = v
	return s
}

// The media pipeline's configuration object.
type ChimeSdkMeetingLiveConnectorConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration object's Chime SDK meeting ARN.
	//
	// Arn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChimeSdkMeetingLiveConnectorConfiguration's
	// String and GoString methods.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The media pipeline's composited video.
	CompositedVideo *CompositedVideoArtifactsConfiguration `type:"structure"`

	// The configuration object's multiplex type.
	//
	// MuxType is a required field
	MuxType *string `type:"string" required:"true" enum:"LiveConnectorMuxType"`

	// The source configuration settings of the media pipeline's configuration object.
	SourceConfiguration *SourceConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChimeSdkMeetingLiveConnectorConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChimeSdkMeetingLiveConnectorConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChimeSdkMeetingLiveConnectorConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChimeSdkMeetingLiveConnectorConfiguration"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.MuxType == nil {
		invalidParams.Add(request.NewErrParamRequired("MuxType"))
	}
	if s.CompositedVideo != nil {
		if err := s.CompositedVideo.Validate(); err != nil {
			invalidParams.AddNested("CompositedVideo", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceConfiguration != nil {
		if err := s.SourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SourceConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ChimeSdkMeetingLiveConnectorConfiguration) SetArn(v string) *ChimeSdkMeetingLiveConnectorConfiguration {
	s.Arn = &v
	return s
}

// SetCompositedVideo sets the CompositedVideo field's value.
func (s *ChimeSdkMeetingLiveConnectorConfiguration) SetCompositedVideo(v *CompositedVideoArtifactsConfiguration) *ChimeSdkMeetingLiveConnectorConfiguration {
	s.CompositedVideo = v
	return s
}

// SetMuxType sets the MuxType field's value.
func (s *ChimeSdkMeetingLiveConnectorConfiguration) SetMuxType(v string) *ChimeSdkMeetingLiveConnectorConfiguration {
	s.MuxType = &v
	return s
}

// SetSourceConfiguration sets the SourceConfiguration field's value.
func (s *ChimeSdkMeetingLiveConnectorConfiguration) SetSourceConfiguration(v *SourceConfiguration) *ChimeSdkMeetingLiveConnectorConfiguration {
	s.SourceConfiguration = v
	return s
}

// Describes the configuration for the composited video artifacts.
type CompositedVideoArtifactsConfiguration struct {
	_ struct{} `type:"structure"`

	// The GridView configuration setting.
	//
	// GridViewConfiguration is a required field
	GridViewConfiguration *GridViewConfiguration `type:"structure" required:"true"`

	// The layout setting, such as GridView in the configuration object.
	Layout *string `type:"string" enum:"LayoutOption"`

	// The video resolution setting in the configuration object. Default: HD at
	// 1280 x 720. FHD resolution: 1920 x 1080.
	Resolution *string `type:"string" enum:"ResolutionOption"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompositedVideoArtifactsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompositedVideoArtifactsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompositedVideoArtifactsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompositedVideoArtifactsConfiguration"}
	if s.GridViewConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("GridViewConfiguration"))
	}
	if s.GridViewConfiguration != nil {
		if err := s.GridViewConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GridViewConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGridViewConfiguration sets the GridViewConfiguration field's value.
func (s *CompositedVideoArtifactsConfiguration) SetGridViewConfiguration(v *GridViewConfiguration) *CompositedVideoArtifactsConfiguration {
	s.GridViewConfiguration = v
	return s
}

// SetLayout sets the Layout field's value.
func (s *CompositedVideoArtifactsConfiguration) SetLayout(v string) *CompositedVideoArtifactsConfiguration {
	s.Layout = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *CompositedVideoArtifactsConfiguration) SetResolution(v string) *CompositedVideoArtifactsConfiguration {
	s.Resolution = &v
	return s
}

// The composited video configuration object for a specified media pipeline.
// SourceType must be ChimeSdkMeeting.
type CompositedVideoConcatenationConfiguration struct {
	_ struct{} `type:"structure"`

	// Enables or disables the configuration object.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"ArtifactsConcatenationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompositedVideoConcatenationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompositedVideoConcatenationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompositedVideoConcatenationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompositedVideoConcatenationConfiguration"}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetState sets the State field's value.
func (s *CompositedVideoConcatenationConfiguration) SetState(v string) *CompositedVideoConcatenationConfiguration {
	s.State = &v
	return s
}

// The data sink of the configuration object.
type ConcatenationSink struct {
	_ struct{} `type:"structure"`

	// The configuration settings for an Amazon S3 bucket sink.
	//
	// S3BucketSinkConfiguration is a required field
	S3BucketSinkConfiguration *S3BucketSinkConfiguration `type:"structure" required:"true"`

	// The type of data sink in the configuration object.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ConcatenationSinkType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcatenationSink) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcatenationSink) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConcatenationSink) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConcatenationSink"}
	if s.S3BucketSinkConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketSinkConfiguration"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.S3BucketSinkConfiguration != nil {
		if err := s.S3BucketSinkConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3BucketSinkConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3BucketSinkConfiguration sets the S3BucketSinkConfiguration field's value.
func (s *ConcatenationSink) SetS3BucketSinkConfiguration(v *S3BucketSinkConfiguration) *ConcatenationSink {
	s.S3BucketSinkConfiguration = v
	return s
}

// SetType sets the Type field's value.
func (s *ConcatenationSink) SetType(v string) *ConcatenationSink {
	s.Type = &v
	return s
}

// The source type and media pipeline configuration settings in a configuration
// object.
type ConcatenationSource struct {
	_ struct{} `type:"structure"`

	// The concatenation settings for the media pipeline in a configuration object.
	//
	// MediaCapturePipelineSourceConfiguration is a required field
	MediaCapturePipelineSourceConfiguration *MediaCapturePipelineSourceConfiguration `type:"structure" required:"true"`

	// The type of concatenation source in a configuration object.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ConcatenationSourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcatenationSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcatenationSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConcatenationSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConcatenationSource"}
	if s.MediaCapturePipelineSourceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaCapturePipelineSourceConfiguration"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.MediaCapturePipelineSourceConfiguration != nil {
		if err := s.MediaCapturePipelineSourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MediaCapturePipelineSourceConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMediaCapturePipelineSourceConfiguration sets the MediaCapturePipelineSourceConfiguration field's value.
func (s *ConcatenationSource) SetMediaCapturePipelineSourceConfiguration(v *MediaCapturePipelineSourceConfiguration) *ConcatenationSource {
	s.MediaCapturePipelineSourceConfiguration = v
	return s
}

// SetType sets the Type field's value.
func (s *ConcatenationSource) SetType(v string) *ConcatenationSource {
	s.Type = &v
	return s
}

// The content artifact object.
type ContentArtifactsConfiguration struct {
	_ struct{} `type:"structure"`

	// The MUX type of the artifact configuration.
	MuxType *string `type:"string" enum:"ContentMuxType"`

	// Indicates whether the content artifact is enabled or disabled.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"ArtifactsState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentArtifactsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentArtifactsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentArtifactsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContentArtifactsConfiguration"}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMuxType sets the MuxType field's value.
func (s *ContentArtifactsConfiguration) SetMuxType(v string) *ContentArtifactsConfiguration {
	s.MuxType = &v
	return s
}

// SetState sets the State field's value.
func (s *ContentArtifactsConfiguration) SetState(v string) *ContentArtifactsConfiguration {
	s.State = &v
	return s
}

// The composited content configuration object for a specified media pipeline.
type ContentConcatenationConfiguration struct {
	_ struct{} `type:"structure"`

	// Enables or disables the configuration object.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"ArtifactsConcatenationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentConcatenationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentConcatenationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentConcatenationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContentConcatenationConfiguration"}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetState sets the State field's value.
func (s *ContentConcatenationConfiguration) SetState(v string) *ContentConcatenationConfiguration {
	s.State = &v
	return s
}

type CreateMediaCapturePipelineInput struct {
	_ struct{} `type:"structure"`

	// The configuration for a specified media pipeline. SourceType must be ChimeSdkMeeting.
	ChimeSdkMeetingConfiguration *ChimeSdkMeetingConfiguration `type:"structure"`

	// The unique identifier for the client request. The token makes the API request
	// idempotent. Use a unique token for each media pipeline request.
	//
	// ClientRequestToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMediaCapturePipelineInput's
	// String and GoString methods.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The ARN of the sink type.
	//
	// SinkArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMediaCapturePipelineInput's
	// String and GoString methods.
	//
	// SinkArn is a required field
	SinkArn *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Destination type to which the media artifacts are saved. You must use an
	// S3 bucket.
	//
	// SinkType is a required field
	SinkType *string `type:"string" required:"true" enum:"MediaPipelineSinkType"`

	// ARN of the source from which the media artifacts are captured.
	//
	// SourceArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMediaCapturePipelineInput's
	// String and GoString methods.
	//
	// SourceArn is a required field
	SourceArn *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Source type from which the media artifacts are captured. A Chime SDK Meeting
	// is the only supported source.
	//
	// SourceType is a required field
	SourceType *string `type:"string" required:"true" enum:"MediaPipelineSourceType"`

	// The tag key-value pairs.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaCapturePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaCapturePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMediaCapturePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMediaCapturePipelineInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.SinkArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SinkArn"))
	}
	if s.SinkArn != nil && len(*s.SinkArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SinkArn", 1))
	}
	if s.SinkType == nil {
		invalidParams.Add(request.NewErrParamRequired("SinkType"))
	}
	if s.SourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceArn"))
	}
	if s.SourceArn != nil && len(*s.SourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceArn", 1))
	}
	if s.SourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceType"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ChimeSdkMeetingConfiguration != nil {
		if err := s.ChimeSdkMeetingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ChimeSdkMeetingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChimeSdkMeetingConfiguration sets the ChimeSdkMeetingConfiguration field's value.
func (s *CreateMediaCapturePipelineInput) SetChimeSdkMeetingConfiguration(v *ChimeSdkMeetingConfiguration) *CreateMediaCapturePipelineInput {
	s.ChimeSdkMeetingConfiguration = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateMediaCapturePipelineInput) SetClientRequestToken(v string) *CreateMediaCapturePipelineInput {
	s.ClientRequestToken = &v
	return s
}

// SetSinkArn sets the SinkArn field's value.
func (s *CreateMediaCapturePipelineInput) SetSinkArn(v string) *CreateMediaCapturePipelineInput {
	s.SinkArn = &v
	return s
}

// SetSinkType sets the SinkType field's value.
func (s *CreateMediaCapturePipelineInput) SetSinkType(v string) *CreateMediaCapturePipelineInput {
	s.SinkType = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *CreateMediaCapturePipelineInput) SetSourceArn(v string) *CreateMediaCapturePipelineInput {
	s.SourceArn = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *CreateMediaCapturePipelineInput) SetSourceType(v string) *CreateMediaCapturePipelineInput {
	s.SourceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMediaCapturePipelineInput) SetTags(v []*Tag) *CreateMediaCapturePipelineInput {
	s.Tags = v
	return s
}

type CreateMediaCapturePipelineOutput struct {
	_ struct{} `type:"structure"`

	// A media pipeline object, the ID, source type, source ARN, sink type, and
	// sink ARN of a media pipeline object.
	MediaCapturePipeline *MediaCapturePipeline `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaCapturePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaCapturePipelineOutput) GoString() string {
	return s.String()
}

// SetMediaCapturePipeline sets the MediaCapturePipeline field's value.
func (s *CreateMediaCapturePipelineOutput) SetMediaCapturePipeline(v *MediaCapturePipeline) *CreateMediaCapturePipelineOutput {
	s.MediaCapturePipeline = v
	return s
}

type CreateMediaConcatenationPipelineInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the client request. The token makes the API request
	// idempotent. Use a unique token for each media concatenation pipeline request.
	//
	// ClientRequestToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMediaConcatenationPipelineInput's
	// String and GoString methods.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// An object that specifies the data sinks for the media concatenation pipeline.
	//
	// Sinks is a required field
	Sinks []*ConcatenationSink `min:"1" type:"list" required:"true"`

	// An object that specifies the sources for the media concatenation pipeline.
	//
	// Sources is a required field
	Sources []*ConcatenationSource `min:"1" type:"list" required:"true"`

	// The tags associated with the media concatenation pipeline.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaConcatenationPipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaConcatenationPipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMediaConcatenationPipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMediaConcatenationPipelineInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.Sinks == nil {
		invalidParams.Add(request.NewErrParamRequired("Sinks"))
	}
	if s.Sinks != nil && len(s.Sinks) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sinks", 1))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil && len(s.Sources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sources", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Sinks != nil {
		for i, v := range s.Sinks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sinks", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateMediaConcatenationPipelineInput) SetClientRequestToken(v string) *CreateMediaConcatenationPipelineInput {
	s.ClientRequestToken = &v
	return s
}

// SetSinks sets the Sinks field's value.
func (s *CreateMediaConcatenationPipelineInput) SetSinks(v []*ConcatenationSink) *CreateMediaConcatenationPipelineInput {
	s.Sinks = v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreateMediaConcatenationPipelineInput) SetSources(v []*ConcatenationSource) *CreateMediaConcatenationPipelineInput {
	s.Sources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMediaConcatenationPipelineInput) SetTags(v []*Tag) *CreateMediaConcatenationPipelineInput {
	s.Tags = v
	return s
}

type CreateMediaConcatenationPipelineOutput struct {
	_ struct{} `type:"structure"`

	// A media concatenation pipeline object, the ID, source type, MediaPipelineARN,
	// and sink of a media concatenation pipeline object.
	MediaConcatenationPipeline *MediaConcatenationPipeline `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaConcatenationPipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaConcatenationPipelineOutput) GoString() string {
	return s.String()
}

// SetMediaConcatenationPipeline sets the MediaConcatenationPipeline field's value.
func (s *CreateMediaConcatenationPipelineOutput) SetMediaConcatenationPipeline(v *MediaConcatenationPipeline) *CreateMediaConcatenationPipelineOutput {
	s.MediaConcatenationPipeline = v
	return s
}

type CreateMediaLiveConnectorPipelineInput struct {
	_ struct{} `type:"structure"`

	// The token assigned to the client making the request.
	//
	// ClientRequestToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMediaLiveConnectorPipelineInput's
	// String and GoString methods.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The media pipeline's data sinks.
	//
	// Sinks is a required field
	Sinks []*LiveConnectorSinkConfiguration `min:"1" type:"list" required:"true"`

	// The media pipeline's data sources.
	//
	// Sources is a required field
	Sources []*LiveConnectorSourceConfiguration `min:"1" type:"list" required:"true"`

	// The tags associated with the media pipeline.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaLiveConnectorPipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaLiveConnectorPipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMediaLiveConnectorPipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMediaLiveConnectorPipelineInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.Sinks == nil {
		invalidParams.Add(request.NewErrParamRequired("Sinks"))
	}
	if s.Sinks != nil && len(s.Sinks) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sinks", 1))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil && len(s.Sources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sources", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Sinks != nil {
		for i, v := range s.Sinks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sinks", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateMediaLiveConnectorPipelineInput) SetClientRequestToken(v string) *CreateMediaLiveConnectorPipelineInput {
	s.ClientRequestToken = &v
	return s
}

// SetSinks sets the Sinks field's value.
func (s *CreateMediaLiveConnectorPipelineInput) SetSinks(v []*LiveConnectorSinkConfiguration) *CreateMediaLiveConnectorPipelineInput {
	s.Sinks = v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreateMediaLiveConnectorPipelineInput) SetSources(v []*LiveConnectorSourceConfiguration) *CreateMediaLiveConnectorPipelineInput {
	s.Sources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMediaLiveConnectorPipelineInput) SetTags(v []*Tag) *CreateMediaLiveConnectorPipelineInput {
	s.Tags = v
	return s
}

type CreateMediaLiveConnectorPipelineOutput struct {
	_ struct{} `type:"structure"`

	// The new media pipeline.
	MediaLiveConnectorPipeline *MediaLiveConnectorPipeline `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaLiveConnectorPipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaLiveConnectorPipelineOutput) GoString() string {
	return s.String()
}

// SetMediaLiveConnectorPipeline sets the MediaLiveConnectorPipeline field's value.
func (s *CreateMediaLiveConnectorPipelineOutput) SetMediaLiveConnectorPipeline(v *MediaLiveConnectorPipeline) *CreateMediaLiveConnectorPipelineOutput {
	s.MediaLiveConnectorPipeline = v
	return s
}

// The content configuration object's data channel.
type DataChannelConcatenationConfiguration struct {
	_ struct{} `type:"structure"`

	// Enables or disables the configuration object.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"ArtifactsConcatenationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataChannelConcatenationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataChannelConcatenationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataChannelConcatenationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataChannelConcatenationConfiguration"}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetState sets the State field's value.
func (s *DataChannelConcatenationConfiguration) SetState(v string) *DataChannelConcatenationConfiguration {
	s.State = &v
	return s
}

type DeleteMediaCapturePipelineInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the media pipeline being deleted.
	//
	// MediaPipelineId is a required field
	MediaPipelineId *string `location:"uri" locationName:"mediaPipelineId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMediaCapturePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMediaCapturePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMediaCapturePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMediaCapturePipelineInput"}
	if s.MediaPipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaPipelineId"))
	}
	if s.MediaPipelineId != nil && len(*s.MediaPipelineId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MediaPipelineId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMediaPipelineId sets the MediaPipelineId field's value.
func (s *DeleteMediaCapturePipelineInput) SetMediaPipelineId(v string) *DeleteMediaCapturePipelineInput {
	s.MediaPipelineId = &v
	return s
}

type DeleteMediaCapturePipelineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMediaCapturePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMediaCapturePipelineOutput) GoString() string {
	return s.String()
}

type DeleteMediaPipelineInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the media pipeline to delete.
	//
	// MediaPipelineId is a required field
	MediaPipelineId *string `location:"uri" locationName:"mediaPipelineId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMediaPipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMediaPipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMediaPipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMediaPipelineInput"}
	if s.MediaPipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaPipelineId"))
	}
	if s.MediaPipelineId != nil && len(*s.MediaPipelineId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MediaPipelineId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMediaPipelineId sets the MediaPipelineId field's value.
func (s *DeleteMediaPipelineInput) SetMediaPipelineId(v string) *DeleteMediaPipelineInput {
	s.MediaPipelineId = &v
	return s
}

type DeleteMediaPipelineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMediaPipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMediaPipelineOutput) GoString() string {
	return s.String()
}

// The client is permanently forbidden from making the request.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetMediaCapturePipelineInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the pipeline that you want to get.
	//
	// MediaPipelineId is a required field
	MediaPipelineId *string `location:"uri" locationName:"mediaPipelineId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMediaCapturePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMediaCapturePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMediaCapturePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMediaCapturePipelineInput"}
	if s.MediaPipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaPipelineId"))
	}
	if s.MediaPipelineId != nil && len(*s.MediaPipelineId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MediaPipelineId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMediaPipelineId sets the MediaPipelineId field's value.
func (s *GetMediaCapturePipelineInput) SetMediaPipelineId(v string) *GetMediaCapturePipelineInput {
	s.MediaPipelineId = &v
	return s
}

type GetMediaCapturePipelineOutput struct {
	_ struct{} `type:"structure"`

	// The media pipeline object.
	MediaCapturePipeline *MediaCapturePipeline `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMediaCapturePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMediaCapturePipelineOutput) GoString() string {
	return s.String()
}

// SetMediaCapturePipeline sets the MediaCapturePipeline field's value.
func (s *GetMediaCapturePipelineOutput) SetMediaCapturePipeline(v *MediaCapturePipeline) *GetMediaCapturePipelineOutput {
	s.MediaCapturePipeline = v
	return s
}

type GetMediaPipelineInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the pipeline that you want to get.
	//
	// MediaPipelineId is a required field
	MediaPipelineId *string `location:"uri" locationName:"mediaPipelineId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMediaPipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMediaPipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMediaPipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMediaPipelineInput"}
	if s.MediaPipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaPipelineId"))
	}
	if s.MediaPipelineId != nil && len(*s.MediaPipelineId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MediaPipelineId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMediaPipelineId sets the MediaPipelineId field's value.
func (s *GetMediaPipelineInput) SetMediaPipelineId(v string) *GetMediaPipelineInput {
	s.MediaPipelineId = &v
	return s
}

type GetMediaPipelineOutput struct {
	_ struct{} `type:"structure"`

	// The media pipeline object.
	MediaPipeline *MediaPipeline `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMediaPipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMediaPipelineOutput) GoString() string {
	return s.String()
}

// SetMediaPipeline sets the MediaPipeline field's value.
func (s *GetMediaPipelineOutput) SetMediaPipeline(v *MediaPipeline) *GetMediaPipelineOutput {
	s.MediaPipeline = v
	return s
}

// Specifies the type of grid layout.
type GridViewConfiguration struct {
	_ struct{} `type:"structure"`

	// Defines the layout of the video tiles when content sharing is enabled.
	//
	// ContentShareLayout is a required field
	ContentShareLayout *string `type:"string" required:"true" enum:"ContentShareLayoutOption"`

	// Defines the configuration options for a presenter only video tile.
	PresenterOnlyConfiguration *PresenterOnlyConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GridViewConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GridViewConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GridViewConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GridViewConfiguration"}
	if s.ContentShareLayout == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentShareLayout"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentShareLayout sets the ContentShareLayout field's value.
func (s *GridViewConfiguration) SetContentShareLayout(v string) *GridViewConfiguration {
	s.ContentShareLayout = &v
	return s
}

// SetPresenterOnlyConfiguration sets the PresenterOnlyConfiguration field's value.
func (s *GridViewConfiguration) SetPresenterOnlyConfiguration(v *PresenterOnlyConfiguration) *GridViewConfiguration {
	s.PresenterOnlyConfiguration = v
	return s
}

type ListMediaCapturePipelinesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in a single call. Valid Range: 1
	// - 99.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token used to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMediaCapturePipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMediaCapturePipelinesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMediaCapturePipelinesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMediaCapturePipelinesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMediaCapturePipelinesInput) SetMaxResults(v int64) *ListMediaCapturePipelinesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMediaCapturePipelinesInput) SetNextToken(v string) *ListMediaCapturePipelinesInput {
	s.NextToken = &v
	return s
}

type ListMediaCapturePipelinesOutput struct {
	_ struct{} `type:"structure"`

	// The media pipeline objects in the list.
	MediaCapturePipelines []*MediaCapturePipelineSummary `type:"list"`

	// The token used to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMediaCapturePipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMediaCapturePipelinesOutput) GoString() string {
	return s.String()
}

// SetMediaCapturePipelines sets the MediaCapturePipelines field's value.
func (s *ListMediaCapturePipelinesOutput) SetMediaCapturePipelines(v []*MediaCapturePipelineSummary) *ListMediaCapturePipelinesOutput {
	s.MediaCapturePipelines = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMediaCapturePipelinesOutput) SetNextToken(v string) *ListMediaCapturePipelinesOutput {
	s.NextToken = &v
	return s
}

type ListMediaPipelinesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in a single call. Valid Range: 1
	// - 99.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token used to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMediaPipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMediaPipelinesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMediaPipelinesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMediaPipelinesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMediaPipelinesInput) SetMaxResults(v int64) *ListMediaPipelinesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMediaPipelinesInput) SetNextToken(v string) *ListMediaPipelinesInput {
	s.NextToken = &v
	return s
}

type ListMediaPipelinesOutput struct {
	_ struct{} `type:"structure"`

	// The media pipeline objects in the list.
	MediaPipelines []*MediaPipelineSummary `type:"list"`

	// The token used to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMediaPipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMediaPipelinesOutput) GoString() string {
	return s.String()
}

// SetMediaPipelines sets the MediaPipelines field's value.
func (s *ListMediaPipelinesOutput) SetMediaPipelines(v []*MediaPipelineSummary) *ListMediaPipelinesOutput {
	s.MediaPipelines = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMediaPipelinesOutput) SetNextToken(v string) *ListMediaPipelinesOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the media pipeline associated with any tags. The ARN consists
	// of the pipeline's region, resource ID, and pipeline ID.
	//
	// ResourceARN is a required field
	ResourceARN *string `location:"querystring" locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags associated with the specified media pipeline.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The media pipeline's RTMP configuration object.
type LiveConnectorRTMPConfiguration struct {
	_ struct{} `type:"structure"`

	// The audio channels set for the RTMP configuration
	AudioChannels *string `type:"string" enum:"AudioChannelsOption"`

	// The audio sample rate set for the RTMP configuration. Default: 48000.
	AudioSampleRate *string `type:"string"`

	// The URL of the RTMP configuration.
	//
	// Url is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by LiveConnectorRTMPConfiguration's
	// String and GoString methods.
	//
	// Url is a required field
	Url *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LiveConnectorRTMPConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LiveConnectorRTMPConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LiveConnectorRTMPConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LiveConnectorRTMPConfiguration"}
	if s.Url == nil {
		invalidParams.Add(request.NewErrParamRequired("Url"))
	}
	if s.Url != nil && len(*s.Url) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Url", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioChannels sets the AudioChannels field's value.
func (s *LiveConnectorRTMPConfiguration) SetAudioChannels(v string) *LiveConnectorRTMPConfiguration {
	s.AudioChannels = &v
	return s
}

// SetAudioSampleRate sets the AudioSampleRate field's value.
func (s *LiveConnectorRTMPConfiguration) SetAudioSampleRate(v string) *LiveConnectorRTMPConfiguration {
	s.AudioSampleRate = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *LiveConnectorRTMPConfiguration) SetUrl(v string) *LiveConnectorRTMPConfiguration {
	s.Url = &v
	return s
}

// The media pipeline's sink configuration settings.
type LiveConnectorSinkConfiguration struct {
	_ struct{} `type:"structure"`

	// The sink configuration's RTMP configuration setttings.
	//
	// RTMPConfiguration is a required field
	RTMPConfiguration *LiveConnectorRTMPConfiguration `type:"structure" required:"true"`

	// The sink configuration's sink type.
	//
	// SinkType is a required field
	SinkType *string `type:"string" required:"true" enum:"LiveConnectorSinkType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LiveConnectorSinkConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LiveConnectorSinkConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LiveConnectorSinkConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LiveConnectorSinkConfiguration"}
	if s.RTMPConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("RTMPConfiguration"))
	}
	if s.SinkType == nil {
		invalidParams.Add(request.NewErrParamRequired("SinkType"))
	}
	if s.RTMPConfiguration != nil {
		if err := s.RTMPConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RTMPConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRTMPConfiguration sets the RTMPConfiguration field's value.
func (s *LiveConnectorSinkConfiguration) SetRTMPConfiguration(v *LiveConnectorRTMPConfiguration) *LiveConnectorSinkConfiguration {
	s.RTMPConfiguration = v
	return s
}

// SetSinkType sets the SinkType field's value.
func (s *LiveConnectorSinkConfiguration) SetSinkType(v string) *LiveConnectorSinkConfiguration {
	s.SinkType = &v
	return s
}

// The data source configuration object of a streaming media pipeline.
type LiveConnectorSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration settings of the connector pipeline.
	//
	// ChimeSdkMeetingLiveConnectorConfiguration is a required field
	ChimeSdkMeetingLiveConnectorConfiguration *ChimeSdkMeetingLiveConnectorConfiguration `type:"structure" required:"true"`

	// The source configuration's media source type.
	//
	// SourceType is a required field
	SourceType *string `type:"string" required:"true" enum:"LiveConnectorSourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LiveConnectorSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LiveConnectorSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LiveConnectorSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LiveConnectorSourceConfiguration"}
	if s.ChimeSdkMeetingLiveConnectorConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeSdkMeetingLiveConnectorConfiguration"))
	}
	if s.SourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceType"))
	}
	if s.ChimeSdkMeetingLiveConnectorConfiguration != nil {
		if err := s.ChimeSdkMeetingLiveConnectorConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ChimeSdkMeetingLiveConnectorConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChimeSdkMeetingLiveConnectorConfiguration sets the ChimeSdkMeetingLiveConnectorConfiguration field's value.
func (s *LiveConnectorSourceConfiguration) SetChimeSdkMeetingLiveConnectorConfiguration(v *ChimeSdkMeetingLiveConnectorConfiguration) *LiveConnectorSourceConfiguration {
	s.ChimeSdkMeetingLiveConnectorConfiguration = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *LiveConnectorSourceConfiguration) SetSourceType(v string) *LiveConnectorSourceConfiguration {
	s.SourceType = &v
	return s
}

// A media pipeline object consisting of an ID, source type, source ARN, a sink
// type, a sink ARN, and a configuration object.
type MediaCapturePipeline struct {
	_ struct{} `type:"structure"`

	// The configuration for a specified media pipeline. SourceType must be ChimeSdkMeeting.
	ChimeSdkMeetingConfiguration *ChimeSdkMeetingConfiguration `type:"structure"`

	// The time at which the pipeline was created, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The ARN of the media capture pipeline
	MediaPipelineArn *string `min:"1" type:"string"`

	// The ID of a media pipeline.
	MediaPipelineId *string `min:"36" type:"string"`

	// ARN of the destination to which the media artifacts are saved.
	//
	// SinkArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by MediaCapturePipeline's
	// String and GoString methods.
	SinkArn *string `min:"1" type:"string" sensitive:"true"`

	// Destination type to which the media artifacts are saved. You must use an
	// S3 Bucket.
	SinkType *string `type:"string" enum:"MediaPipelineSinkType"`

	// ARN of the source from which the media artifacts are saved.
	//
	// SourceArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by MediaCapturePipeline's
	// String and GoString methods.
	SourceArn *string `min:"1" type:"string" sensitive:"true"`

	// Source type from which media artifacts are saved. You must use ChimeMeeting.
	SourceType *string `type:"string" enum:"MediaPipelineSourceType"`

	// The status of the media pipeline.
	Status *string `type:"string" enum:"MediaPipelineStatus"`

	// The time at which the pipeline was updated, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaCapturePipeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaCapturePipeline) GoString() string {
	return s.String()
}

// SetChimeSdkMeetingConfiguration sets the ChimeSdkMeetingConfiguration field's value.
func (s *MediaCapturePipeline) SetChimeSdkMeetingConfiguration(v *ChimeSdkMeetingConfiguration) *MediaCapturePipeline {
	s.ChimeSdkMeetingConfiguration = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *MediaCapturePipeline) SetCreatedTimestamp(v time.Time) *MediaCapturePipeline {
	s.CreatedTimestamp = &v
	return s
}

// SetMediaPipelineArn sets the MediaPipelineArn field's value.
func (s *MediaCapturePipeline) SetMediaPipelineArn(v string) *MediaCapturePipeline {
	s.MediaPipelineArn = &v
	return s
}

// SetMediaPipelineId sets the MediaPipelineId field's value.
func (s *MediaCapturePipeline) SetMediaPipelineId(v string) *MediaCapturePipeline {
	s.MediaPipelineId = &v
	return s
}

// SetSinkArn sets the SinkArn field's value.
func (s *MediaCapturePipeline) SetSinkArn(v string) *MediaCapturePipeline {
	s.SinkArn = &v
	return s
}

// SetSinkType sets the SinkType field's value.
func (s *MediaCapturePipeline) SetSinkType(v string) *MediaCapturePipeline {
	s.SinkType = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *MediaCapturePipeline) SetSourceArn(v string) *MediaCapturePipeline {
	s.SourceArn = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *MediaCapturePipeline) SetSourceType(v string) *MediaCapturePipeline {
	s.SourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MediaCapturePipeline) SetStatus(v string) *MediaCapturePipeline {
	s.Status = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *MediaCapturePipeline) SetUpdatedTimestamp(v time.Time) *MediaCapturePipeline {
	s.UpdatedTimestamp = &v
	return s
}

// The source configuration object of a media capture pipeline.
type MediaCapturePipelineSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The meeting configuration settings in a media capture pipeline configuration
	// object.
	//
	// ChimeSdkMeetingConfiguration is a required field
	ChimeSdkMeetingConfiguration *ChimeSdkMeetingConcatenationConfiguration `type:"structure" required:"true"`

	// The media pipeline ARN in the configuration object of a media capture pipeline.
	//
	// MediaPipelineArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by MediaCapturePipelineSourceConfiguration's
	// String and GoString methods.
	//
	// MediaPipelineArn is a required field
	MediaPipelineArn *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaCapturePipelineSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaCapturePipelineSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MediaCapturePipelineSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MediaCapturePipelineSourceConfiguration"}
	if s.ChimeSdkMeetingConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ChimeSdkMeetingConfiguration"))
	}
	if s.MediaPipelineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaPipelineArn"))
	}
	if s.MediaPipelineArn != nil && len(*s.MediaPipelineArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MediaPipelineArn", 1))
	}
	if s.ChimeSdkMeetingConfiguration != nil {
		if err := s.ChimeSdkMeetingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ChimeSdkMeetingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChimeSdkMeetingConfiguration sets the ChimeSdkMeetingConfiguration field's value.
func (s *MediaCapturePipelineSourceConfiguration) SetChimeSdkMeetingConfiguration(v *ChimeSdkMeetingConcatenationConfiguration) *MediaCapturePipelineSourceConfiguration {
	s.ChimeSdkMeetingConfiguration = v
	return s
}

// SetMediaPipelineArn sets the MediaPipelineArn field's value.
func (s *MediaCapturePipelineSourceConfiguration) SetMediaPipelineArn(v string) *MediaCapturePipelineSourceConfiguration {
	s.MediaPipelineArn = &v
	return s
}

// The summary data of a media capture pipeline.
type MediaCapturePipelineSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the media pipeline in the summary.
	MediaPipelineArn *string `min:"1" type:"string"`

	// The ID of the media pipeline in the summary.
	MediaPipelineId *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaCapturePipelineSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaCapturePipelineSummary) GoString() string {
	return s.String()
}

// SetMediaPipelineArn sets the MediaPipelineArn field's value.
func (s *MediaCapturePipelineSummary) SetMediaPipelineArn(v string) *MediaCapturePipelineSummary {
	s.MediaPipelineArn = &v
	return s
}

// SetMediaPipelineId sets the MediaPipelineId field's value.
func (s *MediaCapturePipelineSummary) SetMediaPipelineId(v string) *MediaCapturePipelineSummary {
	s.MediaPipelineId = &v
	return s
}

// Concatenates audio and video data from one or more data streams.
type MediaConcatenationPipeline struct {
	_ struct{} `type:"structure"`

	// The time at which the concatenation pipeline was created.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The ARN of the media pipeline that you specify in the SourceConfiguration
	// object.
	MediaPipelineArn *string `min:"1" type:"string"`

	// The ID of the media pipeline being concatenated.
	MediaPipelineId *string `min:"36" type:"string"`

	// The data sinks of the concatenation pipeline.
	Sinks []*ConcatenationSink `min:"1" type:"list"`

	// The data sources being concatnated.
	Sources []*ConcatenationSource `min:"1" type:"list"`

	// The status of the concatenation pipeline.
	Status *string `type:"string" enum:"MediaPipelineStatus"`

	// The time at which the concatenation pipeline was last updated.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaConcatenationPipeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaConcatenationPipeline) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *MediaConcatenationPipeline) SetCreatedTimestamp(v time.Time) *MediaConcatenationPipeline {
	s.CreatedTimestamp = &v
	return s
}

// SetMediaPipelineArn sets the MediaPipelineArn field's value.
func (s *MediaConcatenationPipeline) SetMediaPipelineArn(v string) *MediaConcatenationPipeline {
	s.MediaPipelineArn = &v
	return s
}

// SetMediaPipelineId sets the MediaPipelineId field's value.
func (s *MediaConcatenationPipeline) SetMediaPipelineId(v string) *MediaConcatenationPipeline {
	s.MediaPipelineId = &v
	return s
}

// SetSinks sets the Sinks field's value.
func (s *MediaConcatenationPipeline) SetSinks(v []*ConcatenationSink) *MediaConcatenationPipeline {
	s.Sinks = v
	return s
}

// SetSources sets the Sources field's value.
func (s *MediaConcatenationPipeline) SetSources(v []*ConcatenationSource) *MediaConcatenationPipeline {
	s.Sources = v
	return s
}

// SetStatus sets the Status field's value.
func (s *MediaConcatenationPipeline) SetStatus(v string) *MediaConcatenationPipeline {
	s.Status = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *MediaConcatenationPipeline) SetUpdatedTimestamp(v time.Time) *MediaConcatenationPipeline {
	s.UpdatedTimestamp = &v
	return s
}

// The connector pipeline.
type MediaLiveConnectorPipeline struct {
	_ struct{} `type:"structure"`

	// Thetime at which the connector pipeline was created.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The connector pipeline's ARN.
	MediaPipelineArn *string `min:"1" type:"string"`

	// The connector pipeline's ID.
	MediaPipelineId *string `min:"36" type:"string"`

	// The connector pipeline's data sinks.
	Sinks []*LiveConnectorSinkConfiguration `min:"1" type:"list"`

	// The connector pipeline's data sources.
	Sources []*LiveConnectorSourceConfiguration `min:"1" type:"list"`

	// The connector pipeline's status.
	Status *string `type:"string" enum:"MediaPipelineStatus"`

	// The time at which the connector pipeline was last updated.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaLiveConnectorPipeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaLiveConnectorPipeline) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *MediaLiveConnectorPipeline) SetCreatedTimestamp(v time.Time) *MediaLiveConnectorPipeline {
	s.CreatedTimestamp = &v
	return s
}

// SetMediaPipelineArn sets the MediaPipelineArn field's value.
func (s *MediaLiveConnectorPipeline) SetMediaPipelineArn(v string) *MediaLiveConnectorPipeline {
	s.MediaPipelineArn = &v
	return s
}

// SetMediaPipelineId sets the MediaPipelineId field's value.
func (s *MediaLiveConnectorPipeline) SetMediaPipelineId(v string) *MediaLiveConnectorPipeline {
	s.MediaPipelineId = &v
	return s
}

// SetSinks sets the Sinks field's value.
func (s *MediaLiveConnectorPipeline) SetSinks(v []*LiveConnectorSinkConfiguration) *MediaLiveConnectorPipeline {
	s.Sinks = v
	return s
}

// SetSources sets the Sources field's value.
func (s *MediaLiveConnectorPipeline) SetSources(v []*LiveConnectorSourceConfiguration) *MediaLiveConnectorPipeline {
	s.Sources = v
	return s
}

// SetStatus sets the Status field's value.
func (s *MediaLiveConnectorPipeline) SetStatus(v string) *MediaLiveConnectorPipeline {
	s.Status = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *MediaLiveConnectorPipeline) SetUpdatedTimestamp(v time.Time) *MediaLiveConnectorPipeline {
	s.UpdatedTimestamp = &v
	return s
}

// A pipeline consisting of a media capture, media concatenation, or live-streaming
// pipeline.
type MediaPipeline struct {
	_ struct{} `type:"structure"`

	// A pipeline that enables users to capture audio and video.
	MediaCapturePipeline *MediaCapturePipeline `type:"structure"`

	// The media concatenation pipeline in a media pipeline.
	MediaConcatenationPipeline *MediaConcatenationPipeline `type:"structure"`

	// The connector pipeline of the media pipeline.
	MediaLiveConnectorPipeline *MediaLiveConnectorPipeline `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaPipeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaPipeline) GoString() string {
	return s.String()
}

// SetMediaCapturePipeline sets the MediaCapturePipeline field's value.
func (s *MediaPipeline) SetMediaCapturePipeline(v *MediaCapturePipeline) *MediaPipeline {
	s.MediaCapturePipeline = v
	return s
}

// SetMediaConcatenationPipeline sets the MediaConcatenationPipeline field's value.
func (s *MediaPipeline) SetMediaConcatenationPipeline(v *MediaConcatenationPipeline) *MediaPipeline {
	s.MediaConcatenationPipeline = v
	return s
}

// SetMediaLiveConnectorPipeline sets the MediaLiveConnectorPipeline field's value.
func (s *MediaPipeline) SetMediaLiveConnectorPipeline(v *MediaLiveConnectorPipeline) *MediaPipeline {
	s.MediaLiveConnectorPipeline = v
	return s
}

// The summary of the media pipeline.
type MediaPipelineSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the media pipeline in the summary.
	MediaPipelineArn *string `min:"1" type:"string"`

	// The ID of the media pipeline in the summary.
	MediaPipelineId *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaPipelineSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaPipelineSummary) GoString() string {
	return s.String()
}

// SetMediaPipelineArn sets the MediaPipelineArn field's value.
func (s *MediaPipelineSummary) SetMediaPipelineArn(v string) *MediaPipelineSummary {
	s.MediaPipelineArn = &v
	return s
}

// SetMediaPipelineId sets the MediaPipelineId field's value.
func (s *MediaPipelineSummary) SetMediaPipelineId(v string) *MediaPipelineSummary {
	s.MediaPipelineId = &v
	return s
}

// The configuration object for an event concatenation pipeline.
type MeetingEventsConcatenationConfiguration struct {
	_ struct{} `type:"structure"`

	// Enables or disables the configuration object.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"ArtifactsConcatenationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeetingEventsConcatenationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeetingEventsConcatenationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MeetingEventsConcatenationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MeetingEventsConcatenationConfiguration"}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetState sets the State field's value.
func (s *MeetingEventsConcatenationConfiguration) SetState(v string) *MeetingEventsConcatenationConfiguration {
	s.State = &v
	return s
}

// One or more of the resources in the request does not exist in the system.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Defines the configuration for a presenter only video tile.
type PresenterOnlyConfiguration struct {
	_ struct{} `type:"structure"`

	// Defines the position of the presenter video tile. Default: TopRight.
	PresenterPosition *string `type:"string" enum:"PresenterPosition"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PresenterOnlyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PresenterOnlyConfiguration) GoString() string {
	return s.String()
}

// SetPresenterPosition sets the PresenterPosition field's value.
func (s *PresenterOnlyConfiguration) SetPresenterPosition(v string) *PresenterOnlyConfiguration {
	s.PresenterPosition = &v
	return s
}

// The request exceeds the resource limit.
type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration settings for the S3 bucket.
type S3BucketSinkConfiguration struct {
	_ struct{} `type:"structure"`

	// The destination URL of the S3 bucket.
	//
	// Destination is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by S3BucketSinkConfiguration's
	// String and GoString methods.
	//
	// Destination is a required field
	Destination *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3BucketSinkConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3BucketSinkConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3BucketSinkConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3BucketSinkConfiguration"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Destination != nil && len(*s.Destination) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Destination", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *S3BucketSinkConfiguration) SetDestination(v string) *S3BucketSinkConfiguration {
	s.Destination = &v
	return s
}

// The video streams for a specified media pipeline. The total number of video
// streams can't exceed 25.
type SelectedVideoStreams struct {
	_ struct{} `type:"structure"`

	// The attendee IDs of the streams selected for a media pipeline.
	AttendeeIds []*string `min:"1" type:"list"`

	// The external user IDs of the streams selected for a media pipeline.
	ExternalUserIds []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelectedVideoStreams) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelectedVideoStreams) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelectedVideoStreams) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SelectedVideoStreams"}
	if s.AttendeeIds != nil && len(s.AttendeeIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttendeeIds", 1))
	}
	if s.ExternalUserIds != nil && len(s.ExternalUserIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalUserIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendeeIds sets the AttendeeIds field's value.
func (s *SelectedVideoStreams) SetAttendeeIds(v []*string) *SelectedVideoStreams {
	s.AttendeeIds = v
	return s
}

// SetExternalUserIds sets the ExternalUserIds field's value.
func (s *SelectedVideoStreams) SetExternalUserIds(v []*string) *SelectedVideoStreams {
	s.ExternalUserIds = v
	return s
}

// The service encountered an unexpected error.
type ServiceFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceFailureException) GoString() string {
	return s.String()
}

func newErrorServiceFailureException(v protocol.ResponseMetadata) error {
	return &ServiceFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceFailureException) Code() string {
	return "ServiceFailureException"
}

// Message returns the exception's message.
func (s *ServiceFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceFailureException) OrigErr() error {
	return nil
}

func (s *ServiceFailureException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is currently unavailable.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Source configuration for a specified media pipeline.
type SourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The selected video streams for a specified media pipeline. The number of
	// video streams can't exceed 25.
	SelectedVideoStreams *SelectedVideoStreams `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceConfiguration"}
	if s.SelectedVideoStreams != nil {
		if err := s.SelectedVideoStreams.Validate(); err != nil {
			invalidParams.AddNested("SelectedVideoStreams", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSelectedVideoStreams sets the SelectedVideoStreams field's value.
func (s *SourceConfiguration) SetSelectedVideoStreams(v *SelectedVideoStreams) *SourceConfiguration {
	s.SelectedVideoStreams = v
	return s
}

// A key/value pair that grants users access to meeting resources.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key half of a tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value half of a tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the media pipeline associated with any tags. The ARN consists
	// of the pipeline's endpoint region, resource ID, and pipeline ID.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The tags associated with the specified media pipeline.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The client exceeded its request rate limit.
type ThrottledClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottledClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottledClientException) GoString() string {
	return s.String()
}

func newErrorThrottledClientException(v protocol.ResponseMetadata) error {
	return &ThrottledClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottledClientException) Code() string {
	return "ThrottledClientException"
}

// Message returns the exception's message.
func (s *ThrottledClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottledClientException) OrigErr() error {
	return nil
}

func (s *ThrottledClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottledClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottledClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration object for concatenating transcription messages.
type TranscriptionMessagesConcatenationConfiguration struct {
	_ struct{} `type:"structure"`

	// Enables or disables the configuration object.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"ArtifactsConcatenationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptionMessagesConcatenationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptionMessagesConcatenationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TranscriptionMessagesConcatenationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TranscriptionMessagesConcatenationConfiguration"}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetState sets the State field's value.
func (s *TranscriptionMessagesConcatenationConfiguration) SetState(v string) *TranscriptionMessagesConcatenationConfiguration {
	s.State = &v
	return s
}

// The client is not currently authorized to make the request.
type UnauthorizedClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedClientException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedClientException(v protocol.ResponseMetadata) error {
	return &UnauthorizedClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedClientException) Code() string {
	return "UnauthorizedClientException"
}

// Message returns the exception's message.
func (s *UnauthorizedClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedClientException) OrigErr() error {
	return nil
}

func (s *UnauthorizedClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the pipeline that you want to untag.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The key/value pairs in the tag that you want to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// The video artifact configuration object.
type VideoArtifactsConfiguration struct {
	_ struct{} `type:"structure"`

	// The MUX type of the video artifact configuration object.
	MuxType *string `type:"string" enum:"VideoMuxType"`

	// Indicates whether the video artifact is enabled or disabled.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"ArtifactsState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VideoArtifactsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VideoArtifactsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VideoArtifactsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VideoArtifactsConfiguration"}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMuxType sets the MuxType field's value.
func (s *VideoArtifactsConfiguration) SetMuxType(v string) *VideoArtifactsConfiguration {
	s.MuxType = &v
	return s
}

// SetState sets the State field's value.
func (s *VideoArtifactsConfiguration) SetState(v string) *VideoArtifactsConfiguration {
	s.State = &v
	return s
}

// The configuration object of a video contacatentation pipeline.
type VideoConcatenationConfiguration struct {
	_ struct{} `type:"structure"`

	// Enables or disables the configuration object.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"ArtifactsConcatenationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VideoConcatenationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VideoConcatenationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VideoConcatenationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VideoConcatenationConfiguration"}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetState sets the State field's value.
func (s *VideoConcatenationConfiguration) SetState(v string) *VideoConcatenationConfiguration {
	s.State = &v
	return s
}

const (
	// ArtifactsConcatenationStateEnabled is a ArtifactsConcatenationState enum value
	ArtifactsConcatenationStateEnabled = "Enabled"

	// ArtifactsConcatenationStateDisabled is a ArtifactsConcatenationState enum value
	ArtifactsConcatenationStateDisabled = "Disabled"
)

// ArtifactsConcatenationState_Values returns all elements of the ArtifactsConcatenationState enum
func ArtifactsConcatenationState_Values() []string {
	return []string{
		ArtifactsConcatenationStateEnabled,
		ArtifactsConcatenationStateDisabled,
	}
}

const (
	// ArtifactsStateEnabled is a ArtifactsState enum value
	ArtifactsStateEnabled = "Enabled"

	// ArtifactsStateDisabled is a ArtifactsState enum value
	ArtifactsStateDisabled = "Disabled"
)

// ArtifactsState_Values returns all elements of the ArtifactsState enum
func ArtifactsState_Values() []string {
	return []string{
		ArtifactsStateEnabled,
		ArtifactsStateDisabled,
	}
}

const (
	// AudioArtifactsConcatenationStateEnabled is a AudioArtifactsConcatenationState enum value
	AudioArtifactsConcatenationStateEnabled = "Enabled"
)

// AudioArtifactsConcatenationState_Values returns all elements of the AudioArtifactsConcatenationState enum
func AudioArtifactsConcatenationState_Values() []string {
	return []string{
		AudioArtifactsConcatenationStateEnabled,
	}
}

const (
	// AudioChannelsOptionStereo is a AudioChannelsOption enum value
	AudioChannelsOptionStereo = "Stereo"

	// AudioChannelsOptionMono is a AudioChannelsOption enum value
	AudioChannelsOptionMono = "Mono"
)

// AudioChannelsOption_Values returns all elements of the AudioChannelsOption enum
func AudioChannelsOption_Values() []string {
	return []string{
		AudioChannelsOptionStereo,
		AudioChannelsOptionMono,
	}
}

const (
	// AudioMuxTypeAudioOnly is a AudioMuxType enum value
	AudioMuxTypeAudioOnly = "AudioOnly"

	// AudioMuxTypeAudioWithActiveSpeakerVideo is a AudioMuxType enum value
	AudioMuxTypeAudioWithActiveSpeakerVideo = "AudioWithActiveSpeakerVideo"

	// AudioMuxTypeAudioWithCompositedVideo is a AudioMuxType enum value
	AudioMuxTypeAudioWithCompositedVideo = "AudioWithCompositedVideo"
)

// AudioMuxType_Values returns all elements of the AudioMuxType enum
func AudioMuxType_Values() []string {
	return []string{
		AudioMuxTypeAudioOnly,
		AudioMuxTypeAudioWithActiveSpeakerVideo,
		AudioMuxTypeAudioWithCompositedVideo,
	}
}

const (
	// ConcatenationSinkTypeS3bucket is a ConcatenationSinkType enum value
	ConcatenationSinkTypeS3bucket = "S3Bucket"
)

// ConcatenationSinkType_Values returns all elements of the ConcatenationSinkType enum
func ConcatenationSinkType_Values() []string {
	return []string{
		ConcatenationSinkTypeS3bucket,
	}
}

const (
	// ConcatenationSourceTypeMediaCapturePipeline is a ConcatenationSourceType enum value
	ConcatenationSourceTypeMediaCapturePipeline = "MediaCapturePipeline"
)

// ConcatenationSourceType_Values returns all elements of the ConcatenationSourceType enum
func ConcatenationSourceType_Values() []string {
	return []string{
		ConcatenationSourceTypeMediaCapturePipeline,
	}
}

const (
	// ContentMuxTypeContentOnly is a ContentMuxType enum value
	ContentMuxTypeContentOnly = "ContentOnly"
)

// ContentMuxType_Values returns all elements of the ContentMuxType enum
func ContentMuxType_Values() []string {
	return []string{
		ContentMuxTypeContentOnly,
	}
}

const (
	// ContentShareLayoutOptionPresenterOnly is a ContentShareLayoutOption enum value
	ContentShareLayoutOptionPresenterOnly = "PresenterOnly"

	// ContentShareLayoutOptionHorizontal is a ContentShareLayoutOption enum value
	ContentShareLayoutOptionHorizontal = "Horizontal"

	// ContentShareLayoutOptionVertical is a ContentShareLayoutOption enum value
	ContentShareLayoutOptionVertical = "Vertical"
)

// ContentShareLayoutOption_Values returns all elements of the ContentShareLayoutOption enum
func ContentShareLayoutOption_Values() []string {
	return []string{
		ContentShareLayoutOptionPresenterOnly,
		ContentShareLayoutOptionHorizontal,
		ContentShareLayoutOptionVertical,
	}
}

const (
	// ErrorCodeBadRequest is a ErrorCode enum value
	ErrorCodeBadRequest = "BadRequest"

	// ErrorCodeForbidden is a ErrorCode enum value
	ErrorCodeForbidden = "Forbidden"

	// ErrorCodeNotFound is a ErrorCode enum value
	ErrorCodeNotFound = "NotFound"

	// ErrorCodeResourceLimitExceeded is a ErrorCode enum value
	ErrorCodeResourceLimitExceeded = "ResourceLimitExceeded"

	// ErrorCodeServiceFailure is a ErrorCode enum value
	ErrorCodeServiceFailure = "ServiceFailure"

	// ErrorCodeServiceUnavailable is a ErrorCode enum value
	ErrorCodeServiceUnavailable = "ServiceUnavailable"

	// ErrorCodeThrottling is a ErrorCode enum value
	ErrorCodeThrottling = "Throttling"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeBadRequest,
		ErrorCodeForbidden,
		ErrorCodeNotFound,
		ErrorCodeResourceLimitExceeded,
		ErrorCodeServiceFailure,
		ErrorCodeServiceUnavailable,
		ErrorCodeThrottling,
	}
}

const (
	// LayoutOptionGridView is a LayoutOption enum value
	LayoutOptionGridView = "GridView"
)

// LayoutOption_Values returns all elements of the LayoutOption enum
func LayoutOption_Values() []string {
	return []string{
		LayoutOptionGridView,
	}
}

const (
	// LiveConnectorMuxTypeAudioWithCompositedVideo is a LiveConnectorMuxType enum value
	LiveConnectorMuxTypeAudioWithCompositedVideo = "AudioWithCompositedVideo"

	// LiveConnectorMuxTypeAudioWithActiveSpeakerVideo is a LiveConnectorMuxType enum value
	LiveConnectorMuxTypeAudioWithActiveSpeakerVideo = "AudioWithActiveSpeakerVideo"
)

// LiveConnectorMuxType_Values returns all elements of the LiveConnectorMuxType enum
func LiveConnectorMuxType_Values() []string {
	return []string{
		LiveConnectorMuxTypeAudioWithCompositedVideo,
		LiveConnectorMuxTypeAudioWithActiveSpeakerVideo,
	}
}

const (
	// LiveConnectorSinkTypeRtmp is a LiveConnectorSinkType enum value
	LiveConnectorSinkTypeRtmp = "RTMP"
)

// LiveConnectorSinkType_Values returns all elements of the LiveConnectorSinkType enum
func LiveConnectorSinkType_Values() []string {
	return []string{
		LiveConnectorSinkTypeRtmp,
	}
}

const (
	// LiveConnectorSourceTypeChimeSdkMeeting is a LiveConnectorSourceType enum value
	LiveConnectorSourceTypeChimeSdkMeeting = "ChimeSdkMeeting"
)

// LiveConnectorSourceType_Values returns all elements of the LiveConnectorSourceType enum
func LiveConnectorSourceType_Values() []string {
	return []string{
		LiveConnectorSourceTypeChimeSdkMeeting,
	}
}

const (
	// MediaPipelineSinkTypeS3bucket is a MediaPipelineSinkType enum value
	MediaPipelineSinkTypeS3bucket = "S3Bucket"
)

// MediaPipelineSinkType_Values returns all elements of the MediaPipelineSinkType enum
func MediaPipelineSinkType_Values() []string {
	return []string{
		MediaPipelineSinkTypeS3bucket,
	}
}

const (
	// MediaPipelineSourceTypeChimeSdkMeeting is a MediaPipelineSourceType enum value
	MediaPipelineSourceTypeChimeSdkMeeting = "ChimeSdkMeeting"
)

// MediaPipelineSourceType_Values returns all elements of the MediaPipelineSourceType enum
func MediaPipelineSourceType_Values() []string {
	return []string{
		MediaPipelineSourceTypeChimeSdkMeeting,
	}
}

const (
	// MediaPipelineStatusInitializing is a MediaPipelineStatus enum value
	MediaPipelineStatusInitializing = "Initializing"

	// MediaPipelineStatusInProgress is a MediaPipelineStatus enum value
	MediaPipelineStatusInProgress = "InProgress"

	// MediaPipelineStatusFailed is a MediaPipelineStatus enum value
	MediaPipelineStatusFailed = "Failed"

	// MediaPipelineStatusStopping is a MediaPipelineStatus enum value
	MediaPipelineStatusStopping = "Stopping"

	// MediaPipelineStatusStopped is a MediaPipelineStatus enum value
	MediaPipelineStatusStopped = "Stopped"
)

// MediaPipelineStatus_Values returns all elements of the MediaPipelineStatus enum
func MediaPipelineStatus_Values() []string {
	return []string{
		MediaPipelineStatusInitializing,
		MediaPipelineStatusInProgress,
		MediaPipelineStatusFailed,
		MediaPipelineStatusStopping,
		MediaPipelineStatusStopped,
	}
}

const (
	// PresenterPositionTopLeft is a PresenterPosition enum value
	PresenterPositionTopLeft = "TopLeft"

	// PresenterPositionTopRight is a PresenterPosition enum value
	PresenterPositionTopRight = "TopRight"

	// PresenterPositionBottomLeft is a PresenterPosition enum value
	PresenterPositionBottomLeft = "BottomLeft"

	// PresenterPositionBottomRight is a PresenterPosition enum value
	PresenterPositionBottomRight = "BottomRight"
)

// PresenterPosition_Values returns all elements of the PresenterPosition enum
func PresenterPosition_Values() []string {
	return []string{
		PresenterPositionTopLeft,
		PresenterPositionTopRight,
		PresenterPositionBottomLeft,
		PresenterPositionBottomRight,
	}
}

const (
	// ResolutionOptionHd is a ResolutionOption enum value
	ResolutionOptionHd = "HD"

	// ResolutionOptionFhd is a ResolutionOption enum value
	ResolutionOptionFhd = "FHD"
)

// ResolutionOption_Values returns all elements of the ResolutionOption enum
func ResolutionOption_Values() []string {
	return []string{
		ResolutionOptionHd,
		ResolutionOptionFhd,
	}
}

const (
	// VideoMuxTypeVideoOnly is a VideoMuxType enum value
	VideoMuxTypeVideoOnly = "VideoOnly"
)

// VideoMuxType_Values returns all elements of the VideoMuxType enum
func VideoMuxType_Values() []string {
	return []string{
		VideoMuxTypeVideoOnly,
	}
}
