// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package directoryservice provides a client for AWS Directory Service.
package directoryservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddIpRoutes = "AddIpRoutes"

// AddIpRoutesRequest generates a "aws/request.Request" representing the
// client's request for the AddIpRoutes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddIpRoutes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddIpRoutes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddIpRoutesRequest method.
//    req, resp := client.AddIpRoutesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) AddIpRoutesRequest(input *AddIpRoutesInput) (req *request.Request, output *AddIpRoutesOutput) {
	op := &request.Operation{
		Name:       opAddIpRoutes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddIpRoutesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddIpRoutesOutput{}
	req.Data = output
	return
}

// AddIpRoutes API operation for AWS Directory Service.
//
// If the DNS server for your on-premises domain uses a publicly addressable
// IP address, you must add a CIDR address block to correctly route traffic
// to and from your Microsoft AD on Amazon Web Services. AddIpRoutes adds this
// address block. You can also use AddIpRoutes to facilitate routing traffic
// that uses public IP ranges from your Microsoft AD on AWS to a peer VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation AddIpRoutes for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * EntityAlreadyExistsException
//   The specified entity already exists.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * IpRouteLimitExceededException
//   The maximum allowed number of IP addresses was exceeded. The default limit
//   is 100 IP address blocks.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) AddIpRoutes(input *AddIpRoutesInput) (*AddIpRoutesOutput, error) {
	req, out := c.AddIpRoutesRequest(input)
	err := req.Send()
	return out, err
}

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddTagsToResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddTagsToResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddTagsToResourceOutput{}
	req.Data = output
	return
}

// AddTagsToResource API operation for AWS Directory Service.
//
// Adds or overwrites one or more tags for the specified Amazon Directory Services
// directory. Each directory can have a maximum of 10 tags. Each tag consists
// of a key and optional value. Tag keys must be unique to each resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * TagLimitExceededException
//   The maximum allowed number of tags was exceeded.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	err := req.Send()
	return out, err
}

const opConnectDirectory = "ConnectDirectory"

// ConnectDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the ConnectDirectory operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ConnectDirectory for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ConnectDirectory method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ConnectDirectoryRequest method.
//    req, resp := client.ConnectDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) ConnectDirectoryRequest(input *ConnectDirectoryInput) (req *request.Request, output *ConnectDirectoryOutput) {
	op := &request.Operation{
		Name:       opConnectDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConnectDirectoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ConnectDirectoryOutput{}
	req.Data = output
	return
}

// ConnectDirectory API operation for AWS Directory Service.
//
// Creates an AD Connector to connect to an on-premises directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation ConnectDirectory for usage and error information.
//
// Returned Error Codes:
//   * DirectoryLimitExceededException
//   The maximum number of directories in the region has been reached. You can
//   use the GetDirectoryLimits operation to determine your directory limits in
//   the region.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) ConnectDirectory(input *ConnectDirectoryInput) (*ConnectDirectoryOutput, error) {
	req, out := c.ConnectDirectoryRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlias operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateAlias for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateAlias method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateAliasRequest method.
//    req, resp := client.CreateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *CreateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAliasOutput{}
	req.Data = output
	return
}

// CreateAlias API operation for AWS Directory Service.
//
// Creates an alias for a directory and assigns the alias to the directory.
// The alias is used to construct the access URL for the directory, such as
// http://<alias>.awsapps.com.
//
// After an alias has been created, it cannot be deleted or reused, so this
// operation should only be used when absolutely necessary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CreateAlias for usage and error information.
//
// Returned Error Codes:
//   * EntityAlreadyExistsException
//   The specified entity already exists.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) CreateAlias(input *CreateAliasInput) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	err := req.Send()
	return out, err
}

const opCreateComputer = "CreateComputer"

// CreateComputerRequest generates a "aws/request.Request" representing the
// client's request for the CreateComputer operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateComputer for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateComputer method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateComputerRequest method.
//    req, resp := client.CreateComputerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) CreateComputerRequest(input *CreateComputerInput) (req *request.Request, output *CreateComputerOutput) {
	op := &request.Operation{
		Name:       opCreateComputer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateComputerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateComputerOutput{}
	req.Data = output
	return
}

// CreateComputer API operation for AWS Directory Service.
//
// Creates a computer account in the specified directory, and joins the computer
// to the directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CreateComputer for usage and error information.
//
// Returned Error Codes:
//   * AuthenticationFailedException
//   An authentication error occurred.
//
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * EntityAlreadyExistsException
//   The specified entity already exists.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) CreateComputer(input *CreateComputerInput) (*CreateComputerOutput, error) {
	req, out := c.CreateComputerRequest(input)
	err := req.Send()
	return out, err
}

const opCreateConditionalForwarder = "CreateConditionalForwarder"

// CreateConditionalForwarderRequest generates a "aws/request.Request" representing the
// client's request for the CreateConditionalForwarder operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateConditionalForwarder for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateConditionalForwarder method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateConditionalForwarderRequest method.
//    req, resp := client.CreateConditionalForwarderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) CreateConditionalForwarderRequest(input *CreateConditionalForwarderInput) (req *request.Request, output *CreateConditionalForwarderOutput) {
	op := &request.Operation{
		Name:       opCreateConditionalForwarder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConditionalForwarderInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateConditionalForwarderOutput{}
	req.Data = output
	return
}

// CreateConditionalForwarder API operation for AWS Directory Service.
//
// Creates a conditional forwarder associated with your AWS directory. Conditional
// forwarders are required in order to set up a trust relationship with another
// domain. The conditional forwarder points to the trusted domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CreateConditionalForwarder for usage and error information.
//
// Returned Error Codes:
//   * EntityAlreadyExistsException
//   The specified entity already exists.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) CreateConditionalForwarder(input *CreateConditionalForwarderInput) (*CreateConditionalForwarderOutput, error) {
	req, out := c.CreateConditionalForwarderRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDirectory = "CreateDirectory"

// CreateDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the CreateDirectory operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateDirectory for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateDirectory method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateDirectoryRequest method.
//    req, resp := client.CreateDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) CreateDirectoryRequest(input *CreateDirectoryInput) (req *request.Request, output *CreateDirectoryOutput) {
	op := &request.Operation{
		Name:       opCreateDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDirectoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDirectoryOutput{}
	req.Data = output
	return
}

// CreateDirectory API operation for AWS Directory Service.
//
// Creates a Simple AD directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CreateDirectory for usage and error information.
//
// Returned Error Codes:
//   * DirectoryLimitExceededException
//   The maximum number of directories in the region has been reached. You can
//   use the GetDirectoryLimits operation to determine your directory limits in
//   the region.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) CreateDirectory(input *CreateDirectoryInput) (*CreateDirectoryOutput, error) {
	req, out := c.CreateDirectoryRequest(input)
	err := req.Send()
	return out, err
}

const opCreateMicrosoftAD = "CreateMicrosoftAD"

// CreateMicrosoftADRequest generates a "aws/request.Request" representing the
// client's request for the CreateMicrosoftAD operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateMicrosoftAD for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateMicrosoftAD method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateMicrosoftADRequest method.
//    req, resp := client.CreateMicrosoftADRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) CreateMicrosoftADRequest(input *CreateMicrosoftADInput) (req *request.Request, output *CreateMicrosoftADOutput) {
	op := &request.Operation{
		Name:       opCreateMicrosoftAD,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMicrosoftADInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateMicrosoftADOutput{}
	req.Data = output
	return
}

// CreateMicrosoftAD API operation for AWS Directory Service.
//
// Creates a Microsoft AD in the AWS cloud.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CreateMicrosoftAD for usage and error information.
//
// Returned Error Codes:
//   * DirectoryLimitExceededException
//   The maximum number of directories in the region has been reached. You can
//   use the GetDirectoryLimits operation to determine your directory limits in
//   the region.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
func (c *DirectoryService) CreateMicrosoftAD(input *CreateMicrosoftADInput) (*CreateMicrosoftADOutput, error) {
	req, out := c.CreateMicrosoftADRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshot operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSnapshot for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSnapshot method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSnapshotRequest method.
//    req, resp := client.CreateSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) CreateSnapshotRequest(input *CreateSnapshotInput) (req *request.Request, output *CreateSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateSnapshotOutput{}
	req.Data = output
	return
}

// CreateSnapshot API operation for AWS Directory Service.
//
// Creates a snapshot of a Simple AD or Microsoft AD directory in the AWS cloud.
//
// You cannot take snapshots of AD Connector directories.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CreateSnapshot for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * SnapshotLimitExceededException
//   The maximum number of manual snapshots for the directory has been reached.
//   You can use the GetSnapshotLimits operation to determine the snapshot limits
//   for a directory.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) CreateSnapshot(input *CreateSnapshotInput) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTrust = "CreateTrust"

// CreateTrustRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrust operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateTrust for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateTrust method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateTrustRequest method.
//    req, resp := client.CreateTrustRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) CreateTrustRequest(input *CreateTrustInput) (req *request.Request, output *CreateTrustOutput) {
	op := &request.Operation{
		Name:       opCreateTrust,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrustInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateTrustOutput{}
	req.Data = output
	return
}

// CreateTrust API operation for AWS Directory Service.
//
// AWS Directory Service for Microsoft Active Directory allows you to configure
// trust relationships. For example, you can establish a trust between your
// Microsoft AD in the AWS cloud, and your existing on-premises Microsoft Active
// Directory. This would allow you to provide users and groups access to resources
// in either domain, with a single set of credentials.
//
// This action initiates the creation of the AWS side of a trust relationship
// between a Microsoft AD in the AWS cloud and an external domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CreateTrust for usage and error information.
//
// Returned Error Codes:
//   * EntityAlreadyExistsException
//   The specified entity already exists.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
func (c *DirectoryService) CreateTrust(input *CreateTrustInput) (*CreateTrustOutput, error) {
	req, out := c.CreateTrustRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteConditionalForwarder = "DeleteConditionalForwarder"

// DeleteConditionalForwarderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConditionalForwarder operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteConditionalForwarder for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteConditionalForwarder method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteConditionalForwarderRequest method.
//    req, resp := client.DeleteConditionalForwarderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) DeleteConditionalForwarderRequest(input *DeleteConditionalForwarderInput) (req *request.Request, output *DeleteConditionalForwarderOutput) {
	op := &request.Operation{
		Name:       opDeleteConditionalForwarder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConditionalForwarderInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteConditionalForwarderOutput{}
	req.Data = output
	return
}

// DeleteConditionalForwarder API operation for AWS Directory Service.
//
// Deletes a conditional forwarder that has been set up for your AWS directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DeleteConditionalForwarder for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) DeleteConditionalForwarder(input *DeleteConditionalForwarderInput) (*DeleteConditionalForwarderOutput, error) {
	req, out := c.DeleteConditionalForwarderRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDirectory = "DeleteDirectory"

// DeleteDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDirectory operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteDirectory for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteDirectory method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteDirectoryRequest method.
//    req, resp := client.DeleteDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) DeleteDirectoryRequest(input *DeleteDirectoryInput) (req *request.Request, output *DeleteDirectoryOutput) {
	op := &request.Operation{
		Name:       opDeleteDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDirectoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDirectoryOutput{}
	req.Data = output
	return
}

// DeleteDirectory API operation for AWS Directory Service.
//
// Deletes an AWS Directory Service directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DeleteDirectory for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) DeleteDirectory(input *DeleteDirectoryInput) (*DeleteDirectoryOutput, error) {
	req, out := c.DeleteDirectoryRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSnapshot = "DeleteSnapshot"

// DeleteSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSnapshot operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSnapshot for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSnapshot method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSnapshotRequest method.
//    req, resp := client.DeleteSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) DeleteSnapshotRequest(input *DeleteSnapshotInput) (req *request.Request, output *DeleteSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteSnapshotOutput{}
	req.Data = output
	return
}

// DeleteSnapshot API operation for AWS Directory Service.
//
// Deletes a directory snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DeleteSnapshot for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) DeleteSnapshot(input *DeleteSnapshotInput) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTrust = "DeleteTrust"

// DeleteTrustRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrust operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTrust for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTrust method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTrustRequest method.
//    req, resp := client.DeleteTrustRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) DeleteTrustRequest(input *DeleteTrustInput) (req *request.Request, output *DeleteTrustOutput) {
	op := &request.Operation{
		Name:       opDeleteTrust,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrustInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTrustOutput{}
	req.Data = output
	return
}

// DeleteTrust API operation for AWS Directory Service.
//
// Deletes an existing trust relationship between your Microsoft AD in the AWS
// cloud and an external domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DeleteTrust for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
func (c *DirectoryService) DeleteTrust(input *DeleteTrustInput) (*DeleteTrustOutput, error) {
	req, out := c.DeleteTrustRequest(input)
	err := req.Send()
	return out, err
}

const opDeregisterEventTopic = "DeregisterEventTopic"

// DeregisterEventTopicRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterEventTopic operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeregisterEventTopic for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeregisterEventTopic method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeregisterEventTopicRequest method.
//    req, resp := client.DeregisterEventTopicRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) DeregisterEventTopicRequest(input *DeregisterEventTopicInput) (req *request.Request, output *DeregisterEventTopicOutput) {
	op := &request.Operation{
		Name:       opDeregisterEventTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterEventTopicInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeregisterEventTopicOutput{}
	req.Data = output
	return
}

// DeregisterEventTopic API operation for AWS Directory Service.
//
// Removes the specified directory as a publisher to the specified SNS topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DeregisterEventTopic for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) DeregisterEventTopic(input *DeregisterEventTopicInput) (*DeregisterEventTopicOutput, error) {
	req, out := c.DeregisterEventTopicRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeConditionalForwarders = "DescribeConditionalForwarders"

// DescribeConditionalForwardersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConditionalForwarders operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeConditionalForwarders for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeConditionalForwarders method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeConditionalForwardersRequest method.
//    req, resp := client.DescribeConditionalForwardersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) DescribeConditionalForwardersRequest(input *DescribeConditionalForwardersInput) (req *request.Request, output *DescribeConditionalForwardersOutput) {
	op := &request.Operation{
		Name:       opDescribeConditionalForwarders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConditionalForwardersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeConditionalForwardersOutput{}
	req.Data = output
	return
}

// DescribeConditionalForwarders API operation for AWS Directory Service.
//
// Obtains information about the conditional forwarders for this account.
//
// If no input parameters are provided for RemoteDomainNames, this request describes
// all conditional forwarders for the specified directory ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DescribeConditionalForwarders for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) DescribeConditionalForwarders(input *DescribeConditionalForwardersInput) (*DescribeConditionalForwardersOutput, error) {
	req, out := c.DescribeConditionalForwardersRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDirectories = "DescribeDirectories"

// DescribeDirectoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDirectories operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeDirectories for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeDirectories method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeDirectoriesRequest method.
//    req, resp := client.DescribeDirectoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) DescribeDirectoriesRequest(input *DescribeDirectoriesInput) (req *request.Request, output *DescribeDirectoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeDirectories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectoriesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDirectoriesOutput{}
	req.Data = output
	return
}

// DescribeDirectories API operation for AWS Directory Service.
//
// Obtains information about the directories that belong to this account.
//
// You can retrieve information about specific directories by passing the directory
// identifiers in the DirectoryIds parameter. Otherwise, all directories that
// belong to the current account are returned.
//
// This operation supports pagination with the use of the NextToken request
// and response parameters. If more results are available, the DescribeDirectoriesResult.NextToken
// member contains a token that you pass in the next call to DescribeDirectories
// to retrieve the next set of items.
//
// You can also specify a maximum number of return results with the Limit parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DescribeDirectories for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) DescribeDirectories(input *DescribeDirectoriesInput) (*DescribeDirectoriesOutput, error) {
	req, out := c.DescribeDirectoriesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeEventTopics = "DescribeEventTopics"

// DescribeEventTopicsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventTopics operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeEventTopics for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeEventTopics method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeEventTopicsRequest method.
//    req, resp := client.DescribeEventTopicsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) DescribeEventTopicsRequest(input *DescribeEventTopicsInput) (req *request.Request, output *DescribeEventTopicsOutput) {
	op := &request.Operation{
		Name:       opDescribeEventTopics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventTopicsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEventTopicsOutput{}
	req.Data = output
	return
}

// DescribeEventTopics API operation for AWS Directory Service.
//
// Obtains information about which SNS topics receive status messages from the
// specified directory.
//
// If no input parameters are provided, such as DirectoryId or TopicName, this
// request describes all of the associations in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DescribeEventTopics for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) DescribeEventTopics(input *DescribeEventTopicsInput) (*DescribeEventTopicsOutput, error) {
	req, out := c.DescribeEventTopicsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSnapshots = "DescribeSnapshots"

// DescribeSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSnapshots operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSnapshots for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSnapshots method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSnapshotsRequest method.
//    req, resp := client.DescribeSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) DescribeSnapshotsRequest(input *DescribeSnapshotsInput) (req *request.Request, output *DescribeSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSnapshotsOutput{}
	req.Data = output
	return
}

// DescribeSnapshots API operation for AWS Directory Service.
//
// Obtains information about the directory snapshots that belong to this account.
//
// This operation supports pagination with the use of the NextToken request
// and response parameters. If more results are available, the DescribeSnapshots.NextToken
// member contains a token that you pass in the next call to DescribeSnapshots
// to retrieve the next set of items.
//
// You can also specify a maximum number of return results with the Limit parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DescribeSnapshots for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) DescribeSnapshots(input *DescribeSnapshotsInput) (*DescribeSnapshotsOutput, error) {
	req, out := c.DescribeSnapshotsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTrusts = "DescribeTrusts"

// DescribeTrustsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrusts operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTrusts for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTrusts method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTrustsRequest method.
//    req, resp := client.DescribeTrustsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) DescribeTrustsRequest(input *DescribeTrustsInput) (req *request.Request, output *DescribeTrustsOutput) {
	op := &request.Operation{
		Name:       opDescribeTrusts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTrustsOutput{}
	req.Data = output
	return
}

// DescribeTrusts API operation for AWS Directory Service.
//
// Obtains information about the trust relationships for this account.
//
// If no input parameters are provided, such as DirectoryId or TrustIds, this
// request describes all the trust relationships belonging to the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DescribeTrusts for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
func (c *DirectoryService) DescribeTrusts(input *DescribeTrustsInput) (*DescribeTrustsOutput, error) {
	req, out := c.DescribeTrustsRequest(input)
	err := req.Send()
	return out, err
}

const opDisableRadius = "DisableRadius"

// DisableRadiusRequest generates a "aws/request.Request" representing the
// client's request for the DisableRadius operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableRadius for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableRadius method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableRadiusRequest method.
//    req, resp := client.DisableRadiusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) DisableRadiusRequest(input *DisableRadiusInput) (req *request.Request, output *DisableRadiusOutput) {
	op := &request.Operation{
		Name:       opDisableRadius,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableRadiusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableRadiusOutput{}
	req.Data = output
	return
}

// DisableRadius API operation for AWS Directory Service.
//
// Disables multi-factor authentication (MFA) with the Remote Authentication
// Dial In User Service (RADIUS) server for an AD Connector directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DisableRadius for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) DisableRadius(input *DisableRadiusInput) (*DisableRadiusOutput, error) {
	req, out := c.DisableRadiusRequest(input)
	err := req.Send()
	return out, err
}

const opDisableSso = "DisableSso"

// DisableSsoRequest generates a "aws/request.Request" representing the
// client's request for the DisableSso operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableSso for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableSso method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableSsoRequest method.
//    req, resp := client.DisableSsoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) DisableSsoRequest(input *DisableSsoInput) (req *request.Request, output *DisableSsoOutput) {
	op := &request.Operation{
		Name:       opDisableSso,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableSsoInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableSsoOutput{}
	req.Data = output
	return
}

// DisableSso API operation for AWS Directory Service.
//
// Disables single-sign on for a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DisableSso for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InsufficientPermissionsException
//   The account does not have sufficient permission to perform the operation.
//
//   * AuthenticationFailedException
//   An authentication error occurred.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) DisableSso(input *DisableSsoInput) (*DisableSsoOutput, error) {
	req, out := c.DisableSsoRequest(input)
	err := req.Send()
	return out, err
}

const opEnableRadius = "EnableRadius"

// EnableRadiusRequest generates a "aws/request.Request" representing the
// client's request for the EnableRadius operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableRadius for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableRadius method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableRadiusRequest method.
//    req, resp := client.EnableRadiusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) EnableRadiusRequest(input *EnableRadiusInput) (req *request.Request, output *EnableRadiusOutput) {
	op := &request.Operation{
		Name:       opEnableRadius,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableRadiusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableRadiusOutput{}
	req.Data = output
	return
}

// EnableRadius API operation for AWS Directory Service.
//
// Enables multi-factor authentication (MFA) with the Remote Authentication
// Dial In User Service (RADIUS) server for an AD Connector directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation EnableRadius for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * EntityAlreadyExistsException
//   The specified entity already exists.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) EnableRadius(input *EnableRadiusInput) (*EnableRadiusOutput, error) {
	req, out := c.EnableRadiusRequest(input)
	err := req.Send()
	return out, err
}

const opEnableSso = "EnableSso"

// EnableSsoRequest generates a "aws/request.Request" representing the
// client's request for the EnableSso operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableSso for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableSso method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableSsoRequest method.
//    req, resp := client.EnableSsoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) EnableSsoRequest(input *EnableSsoInput) (req *request.Request, output *EnableSsoOutput) {
	op := &request.Operation{
		Name:       opEnableSso,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableSsoInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableSsoOutput{}
	req.Data = output
	return
}

// EnableSso API operation for AWS Directory Service.
//
// Enables single-sign on for a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation EnableSso for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InsufficientPermissionsException
//   The account does not have sufficient permission to perform the operation.
//
//   * AuthenticationFailedException
//   An authentication error occurred.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) EnableSso(input *EnableSsoInput) (*EnableSsoOutput, error) {
	req, out := c.EnableSsoRequest(input)
	err := req.Send()
	return out, err
}

const opGetDirectoryLimits = "GetDirectoryLimits"

// GetDirectoryLimitsRequest generates a "aws/request.Request" representing the
// client's request for the GetDirectoryLimits operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetDirectoryLimits for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetDirectoryLimits method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetDirectoryLimitsRequest method.
//    req, resp := client.GetDirectoryLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) GetDirectoryLimitsRequest(input *GetDirectoryLimitsInput) (req *request.Request, output *GetDirectoryLimitsOutput) {
	op := &request.Operation{
		Name:       opGetDirectoryLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDirectoryLimitsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDirectoryLimitsOutput{}
	req.Data = output
	return
}

// GetDirectoryLimits API operation for AWS Directory Service.
//
// Obtains directory limit information for the current region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation GetDirectoryLimits for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) GetDirectoryLimits(input *GetDirectoryLimitsInput) (*GetDirectoryLimitsOutput, error) {
	req, out := c.GetDirectoryLimitsRequest(input)
	err := req.Send()
	return out, err
}

const opGetSnapshotLimits = "GetSnapshotLimits"

// GetSnapshotLimitsRequest generates a "aws/request.Request" representing the
// client's request for the GetSnapshotLimits operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSnapshotLimits for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSnapshotLimits method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSnapshotLimitsRequest method.
//    req, resp := client.GetSnapshotLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) GetSnapshotLimitsRequest(input *GetSnapshotLimitsInput) (req *request.Request, output *GetSnapshotLimitsOutput) {
	op := &request.Operation{
		Name:       opGetSnapshotLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSnapshotLimitsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSnapshotLimitsOutput{}
	req.Data = output
	return
}

// GetSnapshotLimits API operation for AWS Directory Service.
//
// Obtains the manual snapshot limits for a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation GetSnapshotLimits for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) GetSnapshotLimits(input *GetSnapshotLimitsInput) (*GetSnapshotLimitsOutput, error) {
	req, out := c.GetSnapshotLimitsRequest(input)
	err := req.Send()
	return out, err
}

const opListIpRoutes = "ListIpRoutes"

// ListIpRoutesRequest generates a "aws/request.Request" representing the
// client's request for the ListIpRoutes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListIpRoutes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListIpRoutes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListIpRoutesRequest method.
//    req, resp := client.ListIpRoutesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) ListIpRoutesRequest(input *ListIpRoutesInput) (req *request.Request, output *ListIpRoutesOutput) {
	op := &request.Operation{
		Name:       opListIpRoutes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIpRoutesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListIpRoutesOutput{}
	req.Data = output
	return
}

// ListIpRoutes API operation for AWS Directory Service.
//
// Lists the address blocks that you have added to a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation ListIpRoutes for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) ListIpRoutes(input *ListIpRoutesInput) (*ListIpRoutesOutput, error) {
	req, out := c.ListIpRoutesRequest(input)
	err := req.Send()
	return out, err
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTagsForResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTagsForResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForResourceOutput{}
	req.Data = output
	return
}

// ListTagsForResource API operation for AWS Directory Service.
//
// Lists all tags on an Amazon Directory Services directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterEventTopic = "RegisterEventTopic"

// RegisterEventTopicRequest generates a "aws/request.Request" representing the
// client's request for the RegisterEventTopic operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RegisterEventTopic for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RegisterEventTopic method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RegisterEventTopicRequest method.
//    req, resp := client.RegisterEventTopicRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) RegisterEventTopicRequest(input *RegisterEventTopicInput) (req *request.Request, output *RegisterEventTopicOutput) {
	op := &request.Operation{
		Name:       opRegisterEventTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterEventTopicInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterEventTopicOutput{}
	req.Data = output
	return
}

// RegisterEventTopic API operation for AWS Directory Service.
//
// Associates a directory with an SNS topic. This establishes the directory
// as a publisher to the specified SNS topic. You can then receive email or
// text (SMS) messages when the status of your directory changes. You get notified
// if your directory goes from an Active status to an Impaired or Inoperable
// status. You also receive a notification when the directory returns to an
// Active status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation RegisterEventTopic for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) RegisterEventTopic(input *RegisterEventTopicInput) (*RegisterEventTopicOutput, error) {
	req, out := c.RegisterEventTopicRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveIpRoutes = "RemoveIpRoutes"

// RemoveIpRoutesRequest generates a "aws/request.Request" representing the
// client's request for the RemoveIpRoutes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveIpRoutes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveIpRoutes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveIpRoutesRequest method.
//    req, resp := client.RemoveIpRoutesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) RemoveIpRoutesRequest(input *RemoveIpRoutesInput) (req *request.Request, output *RemoveIpRoutesOutput) {
	op := &request.Operation{
		Name:       opRemoveIpRoutes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveIpRoutesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveIpRoutesOutput{}
	req.Data = output
	return
}

// RemoveIpRoutes API operation for AWS Directory Service.
//
// Removes IP address blocks from a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation RemoveIpRoutes for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) RemoveIpRoutes(input *RemoveIpRoutesInput) (*RemoveIpRoutesOutput, error) {
	req, out := c.RemoveIpRoutesRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveTagsFromResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveTagsFromResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveTagsFromResourceOutput{}
	req.Data = output
	return
}

// RemoveTagsFromResource API operation for AWS Directory Service.
//
// Removes tags from an Amazon Directory Services directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	err := req.Send()
	return out, err
}

const opRestoreFromSnapshot = "RestoreFromSnapshot"

// RestoreFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the RestoreFromSnapshot operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RestoreFromSnapshot for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RestoreFromSnapshot method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RestoreFromSnapshotRequest method.
//    req, resp := client.RestoreFromSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) RestoreFromSnapshotRequest(input *RestoreFromSnapshotInput) (req *request.Request, output *RestoreFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreFromSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RestoreFromSnapshotOutput{}
	req.Data = output
	return
}

// RestoreFromSnapshot API operation for AWS Directory Service.
//
// Restores a directory using an existing directory snapshot.
//
// When you restore a directory from a snapshot, any changes made to the directory
// after the snapshot date are overwritten.
//
// This action returns as soon as the restore operation is initiated. You can
// monitor the progress of the restore operation by calling the DescribeDirectories
// operation with the directory identifier. When the DirectoryDescription.Stage
// value changes to Active, the restore operation is complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation RestoreFromSnapshot for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) RestoreFromSnapshot(input *RestoreFromSnapshotInput) (*RestoreFromSnapshotOutput, error) {
	req, out := c.RestoreFromSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateConditionalForwarder = "UpdateConditionalForwarder"

// UpdateConditionalForwarderRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConditionalForwarder operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateConditionalForwarder for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateConditionalForwarder method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateConditionalForwarderRequest method.
//    req, resp := client.UpdateConditionalForwarderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) UpdateConditionalForwarderRequest(input *UpdateConditionalForwarderInput) (req *request.Request, output *UpdateConditionalForwarderOutput) {
	op := &request.Operation{
		Name:       opUpdateConditionalForwarder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConditionalForwarderInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateConditionalForwarderOutput{}
	req.Data = output
	return
}

// UpdateConditionalForwarder API operation for AWS Directory Service.
//
// Updates a conditional forwarder that has been set up for your AWS directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation UpdateConditionalForwarder for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) UpdateConditionalForwarder(input *UpdateConditionalForwarderInput) (*UpdateConditionalForwarderOutput, error) {
	req, out := c.UpdateConditionalForwarderRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateRadius = "UpdateRadius"

// UpdateRadiusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRadius operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateRadius for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateRadius method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateRadiusRequest method.
//    req, resp := client.UpdateRadiusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) UpdateRadiusRequest(input *UpdateRadiusInput) (req *request.Request, output *UpdateRadiusOutput) {
	op := &request.Operation{
		Name:       opUpdateRadius,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRadiusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateRadiusOutput{}
	req.Data = output
	return
}

// UpdateRadius API operation for AWS Directory Service.
//
// Updates the Remote Authentication Dial In User Service (RADIUS) server information
// for an AD Connector directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation UpdateRadius for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
func (c *DirectoryService) UpdateRadius(input *UpdateRadiusInput) (*UpdateRadiusOutput, error) {
	req, out := c.UpdateRadiusRequest(input)
	err := req.Send()
	return out, err
}

const opVerifyTrust = "VerifyTrust"

// VerifyTrustRequest generates a "aws/request.Request" representing the
// client's request for the VerifyTrust operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See VerifyTrust for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the VerifyTrust method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the VerifyTrustRequest method.
//    req, resp := client.VerifyTrustRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *DirectoryService) VerifyTrustRequest(input *VerifyTrustInput) (req *request.Request, output *VerifyTrustOutput) {
	op := &request.Operation{
		Name:       opVerifyTrust,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyTrustInput{}
	}

	req = c.newRequest(op, input, output)
	output = &VerifyTrustOutput{}
	req.Data = output
	return
}

// VerifyTrust API operation for AWS Directory Service.
//
// AWS Directory Service for Microsoft Active Directory allows you to configure
// and verify trust relationships.
//
// This action verifies a trust relationship between your Microsoft AD in the
// AWS cloud and an external domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation VerifyTrust for usage and error information.
//
// Returned Error Codes:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
func (c *DirectoryService) VerifyTrust(input *VerifyTrustInput) (*VerifyTrustOutput, error) {
	req, out := c.VerifyTrustRequest(input)
	err := req.Send()
	return out, err
}

type AddIpRoutesInput struct {
	_ struct{} `type:"structure"`

	// Identifier (ID) of the directory to which to add the address block.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// IP address blocks, using CIDR format, of the traffic to route. This is often
	// the IP address block of the DNS server used for your on-premises domain.
	//
	// IpRoutes is a required field
	IpRoutes []*IpRoute `type:"list" required:"true"`

	// If set to true, updates the inbound and outbound rules of the security group
	// that has the description: "AWS created security group for directory ID directory
	// controllers." Following are the new rules:
	//
	// Inbound:
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source: 0.0.0.0/0
	//
	//    * Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0
	//
	//    * Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0
	//
	//    * Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0
	//
	//    * Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0
	//
	// Outbound:
	//
	// Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0
	UpdateSecurityGroupForDirectoryControllers *bool `type:"boolean"`
}

// String returns the string representation
func (s AddIpRoutesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddIpRoutesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddIpRoutesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddIpRoutesInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.IpRoutes == nil {
		invalidParams.Add(request.NewErrParamRequired("IpRoutes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AddIpRoutesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddIpRoutesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddIpRoutesOutput) GoString() string {
	return s.String()
}

type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// Identifier (ID) for the directory to which to add the tag.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The tags to be assigned to the Amazon Directory Services directory.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

// Represents a named directory attribute.
type Attribute struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	Name *string `min:"1" type:"string"`

	// The value of the attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Attribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Attribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Attribute"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about a computer account in a directory.
type Computer struct {
	_ struct{} `type:"structure"`

	// An array of Attribute objects containing the LDAP attributes that belong
	// to the computer account.
	ComputerAttributes []*Attribute `type:"list"`

	// The identifier of the computer.
	ComputerId *string `min:"1" type:"string"`

	// The computer name.
	ComputerName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Computer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Computer) GoString() string {
	return s.String()
}

// Points to a remote domain with which you are setting up a trust relationship.
// Conditional forwarders are required in order to set up a trust relationship
// with another domain.
type ConditionalForwarder struct {
	_ struct{} `type:"structure"`

	// The IP addresses of the remote DNS server associated with RemoteDomainName.
	// This is the IP address of the DNS server that your conditional forwarder
	// points to.
	DnsIpAddrs []*string `type:"list"`

	// The fully qualified domain name (FQDN) of the remote domains pointed to by
	// the conditional forwarder.
	RemoteDomainName *string `type:"string"`

	// The replication scope of the conditional forwarder. The only allowed value
	// is Domain, which will replicate the conditional forwarder to all of the domain
	// controllers for your AWS directory.
	ReplicationScope *string `type:"string" enum:"ReplicationScope"`
}

// String returns the string representation
func (s ConditionalForwarder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionalForwarder) GoString() string {
	return s.String()
}

// Contains the inputs for the ConnectDirectory operation.
type ConnectDirectoryInput struct {
	_ struct{} `type:"structure"`

	// A DirectoryConnectSettings object that contains additional information for
	// the operation.
	//
	// ConnectSettings is a required field
	ConnectSettings *DirectoryConnectSettings `type:"structure" required:"true"`

	// A textual description for the directory.
	Description *string `type:"string"`

	// The fully-qualified name of the on-premises directory, such as corp.example.com.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The password for the on-premises user account.
	//
	// Password is a required field
	Password *string `min:"1" type:"string" required:"true"`

	// The NetBIOS name of the on-premises directory, such as CORP.
	ShortName *string `type:"string"`

	// The size of the directory.
	//
	// Size is a required field
	Size *string `type:"string" required:"true" enum:"DirectorySize"`
}

// String returns the string representation
func (s ConnectDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectDirectoryInput"}
	if s.ConnectSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectSettings"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.Size == nil {
		invalidParams.Add(request.NewErrParamRequired("Size"))
	}
	if s.ConnectSettings != nil {
		if err := s.ConnectSettings.Validate(); err != nil {
			invalidParams.AddNested("ConnectSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the ConnectDirectory operation.
type ConnectDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the new directory.
	DirectoryId *string `type:"string"`
}

// String returns the string representation
func (s ConnectDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectDirectoryOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the CreateAlias operation.
type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// The requested alias.
	//
	// The alias must be unique amongst all aliases in AWS. This operation throws
	// an EntityAlreadyExistsException error if the alias already exists.
	//
	// Alias is a required field
	Alias *string `min:"1" type:"string" required:"true"`

	// The identifier of the directory for which to create the alias.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAliasInput"}
	if s.Alias == nil {
		invalidParams.Add(request.NewErrParamRequired("Alias"))
	}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the CreateAlias operation.
type CreateAliasOutput struct {
	_ struct{} `type:"structure"`

	// The alias for the directory.
	Alias *string `min:"1" type:"string"`

	// The identifier of the directory.
	DirectoryId *string `type:"string"`
}

// String returns the string representation
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the CreateComputer operation.
type CreateComputerInput struct {
	_ struct{} `type:"structure"`

	// An array of Attribute objects that contain any LDAP attributes to apply to
	// the computer account.
	ComputerAttributes []*Attribute `type:"list"`

	// The name of the computer account.
	//
	// ComputerName is a required field
	ComputerName *string `min:"1" type:"string" required:"true"`

	// The identifier of the directory in which to create the computer account.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The fully-qualified distinguished name of the organizational unit to place
	// the computer account in.
	OrganizationalUnitDistinguishedName *string `min:"1" type:"string"`

	// A one-time password that is used to join the computer to the directory. You
	// should generate a random, strong password to use for this parameter.
	//
	// Password is a required field
	Password *string `min:"8" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateComputerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateComputerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateComputerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateComputerInput"}
	if s.ComputerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputerName"))
	}
	if s.ComputerName != nil && len(*s.ComputerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComputerName", 1))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.OrganizationalUnitDistinguishedName != nil && len(*s.OrganizationalUnitDistinguishedName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationalUnitDistinguishedName", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 8))
	}
	if s.ComputerAttributes != nil {
		for i, v := range s.ComputerAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ComputerAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results for the CreateComputer operation.
type CreateComputerOutput struct {
	_ struct{} `type:"structure"`

	// A Computer object that represents the computer account.
	Computer *Computer `type:"structure"`
}

// String returns the string representation
func (s CreateComputerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateComputerOutput) GoString() string {
	return s.String()
}

// Initiates the creation of a conditional forwarder for your AWS Directory
// Service for Microsoft Active Directory. Conditional forwarders are required
// in order to set up a trust relationship with another domain.
type CreateConditionalForwarderInput struct {
	_ struct{} `type:"structure"`

	// The directory ID of the AWS directory for which you are creating the conditional
	// forwarder.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The IP addresses of the remote DNS server associated with RemoteDomainName.
	//
	// DnsIpAddrs is a required field
	DnsIpAddrs []*string `type:"list" required:"true"`

	// The fully qualified domain name (FQDN) of the remote domain with which you
	// will set up a trust relationship.
	//
	// RemoteDomainName is a required field
	RemoteDomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateConditionalForwarderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConditionalForwarderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConditionalForwarderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConditionalForwarderInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.DnsIpAddrs == nil {
		invalidParams.Add(request.NewErrParamRequired("DnsIpAddrs"))
	}
	if s.RemoteDomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoteDomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a CreateConditinalForwarder request.
type CreateConditionalForwarderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateConditionalForwarderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConditionalForwarderOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the CreateDirectory operation.
type CreateDirectoryInput struct {
	_ struct{} `type:"structure"`

	// A textual description for the directory.
	Description *string `type:"string"`

	// The fully qualified name for the directory, such as corp.example.com.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The password for the directory administrator. The directory creation process
	// creates a directory administrator account with the username Administrator
	// and this password.
	//
	// Password is a required field
	Password *string `type:"string" required:"true"`

	// The short name of the directory, such as CORP.
	ShortName *string `type:"string"`

	// The size of the directory.
	//
	// Size is a required field
	Size *string `type:"string" required:"true" enum:"DirectorySize"`

	// A DirectoryVpcSettings object that contains additional information for the
	// operation.
	VpcSettings *DirectoryVpcSettings `type:"structure"`
}

// String returns the string representation
func (s CreateDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDirectoryInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Size == nil {
		invalidParams.Add(request.NewErrParamRequired("Size"))
	}
	if s.VpcSettings != nil {
		if err := s.VpcSettings.Validate(); err != nil {
			invalidParams.AddNested("VpcSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the CreateDirectory operation.
type CreateDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory that was created.
	DirectoryId *string `type:"string"`
}

// String returns the string representation
func (s CreateDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectoryOutput) GoString() string {
	return s.String()
}

// Creates a Microsoft AD in the AWS cloud.
type CreateMicrosoftADInput struct {
	_ struct{} `type:"structure"`

	// A textual description for the directory. This label will appear on the AWS
	// console Directory Details page after the directory is created.
	Description *string `type:"string"`

	// The fully qualified domain name for the directory, such as corp.example.com.
	// This name will resolve inside your VPC only. It does not need to be publicly
	// resolvable.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The password for the default administrative user named Admin.
	//
	// Password is a required field
	Password *string `type:"string" required:"true"`

	// The NetBIOS name for your domain. A short identifier for your domain, such
	// as CORP. If you don't specify a NetBIOS name, it will default to the first
	// part of your directory DNS. For example, CORP for the directory DNS corp.example.com.
	ShortName *string `type:"string"`

	// Contains VPC information for the CreateDirectory or CreateMicrosoftAD operation.
	//
	// VpcSettings is a required field
	VpcSettings *DirectoryVpcSettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateMicrosoftADInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMicrosoftADInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMicrosoftADInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMicrosoftADInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.VpcSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcSettings"))
	}
	if s.VpcSettings != nil {
		if err := s.VpcSettings.Validate(); err != nil {
			invalidParams.AddNested("VpcSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Result of a CreateMicrosoftAD request.
type CreateMicrosoftADOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory that was created.
	DirectoryId *string `type:"string"`
}

// String returns the string representation
func (s CreateMicrosoftADOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMicrosoftADOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the CreateSnapshot operation.
type CreateSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory of which to take a snapshot.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The descriptive name to apply to the snapshot.
	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the CreateSnapshot operation.
type CreateSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the snapshot that was created.
	SnapshotId *string `type:"string"`
}

// String returns the string representation
func (s CreateSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotOutput) GoString() string {
	return s.String()
}

// AWS Directory Service for Microsoft Active Directory allows you to configure
// trust relationships. For example, you can establish a trust between your
// Microsoft AD in the AWS cloud, and your existing on-premises Microsoft Active
// Directory. This would allow you to provide users and groups access to resources
// in either domain, with a single set of credentials.
//
// This action initiates the creation of the AWS side of a trust relationship
// between a Microsoft AD in the AWS cloud and an external domain.
type CreateTrustInput struct {
	_ struct{} `type:"structure"`

	// The IP addresses of the remote DNS server associated with RemoteDomainName.
	ConditionalForwarderIpAddrs []*string `type:"list"`

	// The Directory ID of the Microsoft AD in the AWS cloud for which to establish
	// the trust relationship.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The Fully Qualified Domain Name (FQDN) of the external domain for which to
	// create the trust relationship.
	//
	// RemoteDomainName is a required field
	RemoteDomainName *string `type:"string" required:"true"`

	// The direction of the trust relationship.
	//
	// TrustDirection is a required field
	TrustDirection *string `type:"string" required:"true" enum:"TrustDirection"`

	// The trust password. The must be the same password that was used when creating
	// the trust relationship on the external domain.
	//
	// TrustPassword is a required field
	TrustPassword *string `min:"1" type:"string" required:"true"`

	// The trust relationship type.
	TrustType *string `type:"string" enum:"TrustType"`
}

// String returns the string representation
func (s CreateTrustInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrustInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrustInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrustInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.RemoteDomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoteDomainName"))
	}
	if s.TrustDirection == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustDirection"))
	}
	if s.TrustPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustPassword"))
	}
	if s.TrustPassword != nil && len(*s.TrustPassword) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrustPassword", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a CreateTrust request.
type CreateTrustOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the trust relationship that was created.
	TrustId *string `type:"string"`
}

// String returns the string representation
func (s CreateTrustOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrustOutput) GoString() string {
	return s.String()
}

// Deletes a conditional forwarder.
type DeleteConditionalForwarderInput struct {
	_ struct{} `type:"structure"`

	// The directory ID for which you are deleting the conditional forwarder.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The fully qualified domain name (FQDN) of the remote domain with which you
	// are deleting the conditional forwarder.
	//
	// RemoteDomainName is a required field
	RemoteDomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConditionalForwarderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConditionalForwarderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConditionalForwarderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConditionalForwarderInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.RemoteDomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoteDomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DeleteConditionalForwarder request.
type DeleteConditionalForwarderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConditionalForwarderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConditionalForwarderOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DeleteDirectory operation.
type DeleteDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory to delete.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDirectoryInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the DeleteDirectory operation.
type DeleteDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The directory identifier.
	DirectoryId *string `type:"string"`
}

// String returns the string representation
func (s DeleteDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectoryOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DeleteSnapshot operation.
type DeleteSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory snapshot to be deleted.
	//
	// SnapshotId is a required field
	SnapshotId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSnapshotInput"}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the DeleteSnapshot operation.
type DeleteSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory snapshot that was deleted.
	SnapshotId *string `type:"string"`
}

// String returns the string representation
func (s DeleteSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotOutput) GoString() string {
	return s.String()
}

// Deletes the local side of an existing trust relationship between the Microsoft
// AD in the AWS cloud and the external domain.
type DeleteTrustInput struct {
	_ struct{} `type:"structure"`

	// Delete a conditional forwarder as part of a DeleteTrustRequest.
	DeleteAssociatedConditionalForwarder *bool `type:"boolean"`

	// The Trust ID of the trust relationship to be deleted.
	//
	// TrustId is a required field
	TrustId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTrustInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrustInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrustInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrustInput"}
	if s.TrustId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DeleteTrust request.
type DeleteTrustOutput struct {
	_ struct{} `type:"structure"`

	// The Trust ID of the trust relationship that was deleted.
	TrustId *string `type:"string"`
}

// String returns the string representation
func (s DeleteTrustOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrustOutput) GoString() string {
	return s.String()
}

// Removes the specified directory as a publisher to the specified SNS topic.
type DeregisterEventTopicInput struct {
	_ struct{} `type:"structure"`

	// The Directory ID to remove as a publisher. This directory will no longer
	// send messages to the specified SNS topic.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The name of the SNS topic from which to remove the directory as a publisher.
	//
	// TopicName is a required field
	TopicName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterEventTopicInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterEventTopicInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterEventTopicInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterEventTopicInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.TopicName == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicName"))
	}
	if s.TopicName != nil && len(*s.TopicName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TopicName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DeregisterEventTopic request.
type DeregisterEventTopicOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterEventTopicOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterEventTopicOutput) GoString() string {
	return s.String()
}

// Describes a conditional forwarder.
type DescribeConditionalForwardersInput struct {
	_ struct{} `type:"structure"`

	// The directory ID for which to get the list of associated conditional forwarders.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The fully qualified domain names (FQDN) of the remote domains for which to
	// get the list of associated conditional forwarders. If this member is null,
	// all conditional forwarders are returned.
	RemoteDomainNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeConditionalForwardersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConditionalForwardersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConditionalForwardersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConditionalForwardersInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DescribeConditionalForwarder request.
type DescribeConditionalForwardersOutput struct {
	_ struct{} `type:"structure"`

	// The list of conditional forwarders that have been created.
	ConditionalForwarders []*ConditionalForwarder `type:"list"`
}

// String returns the string representation
func (s DescribeConditionalForwardersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConditionalForwardersOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DescribeDirectories operation.
type DescribeDirectoriesInput struct {
	_ struct{} `type:"structure"`

	// A list of identifiers of the directories for which to obtain the information.
	// If this member is null, all directories that belong to the current account
	// are returned.
	//
	// An empty list results in an InvalidParameterException being thrown.
	DirectoryIds []*string `type:"list"`

	// The maximum number of items to return. If this value is zero, the maximum
	// number of items is specified by the limitations of the operation.
	Limit *int64 `type:"integer"`

	// The DescribeDirectoriesResult.NextToken value from a previous call to DescribeDirectories.
	// Pass null if this is the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeDirectoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectoriesInput) GoString() string {
	return s.String()
}

// Contains the results of the DescribeDirectories operation.
type DescribeDirectoriesOutput struct {
	_ struct{} `type:"structure"`

	// The list of DirectoryDescription objects that were retrieved.
	//
	// It is possible that this list contains less than the number of items specified
	// in the Limit member of the request. This occurs if there are less than the
	// requested number of items left to retrieve, or if the limitations of the
	// operation have been exceeded.
	DirectoryDescriptions []*DirectoryDescription `type:"list"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to DescribeDirectories to retrieve the next
	// set of items.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeDirectoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectoriesOutput) GoString() string {
	return s.String()
}

// Describes event topics.
type DescribeEventTopicsInput struct {
	_ struct{} `type:"structure"`

	// The Directory ID for which to get the list of associated SNS topics. If this
	// member is null, associations for all Directory IDs are returned.
	DirectoryId *string `type:"string"`

	// A list of SNS topic names for which to obtain the information. If this member
	// is null, all associations for the specified Directory ID are returned.
	//
	// An empty list results in an InvalidParameterException being thrown.
	TopicNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeEventTopicsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventTopicsInput) GoString() string {
	return s.String()
}

// The result of a DescribeEventTopic request.
type DescribeEventTopicsOutput struct {
	_ struct{} `type:"structure"`

	// A list of SNS topic names that receive status messages from the specified
	// Directory ID.
	EventTopics []*EventTopic `type:"list"`
}

// String returns the string representation
func (s DescribeEventTopicsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventTopicsOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DescribeSnapshots operation.
type DescribeSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for which to retrieve snapshot information.
	DirectoryId *string `type:"string"`

	// The maximum number of objects to return.
	Limit *int64 `type:"integer"`

	// The DescribeSnapshotsResult.NextToken value from a previous call to DescribeSnapshots.
	// Pass null if this is the first call.
	NextToken *string `type:"string"`

	// A list of identifiers of the snapshots to obtain the information for. If
	// this member is null or empty, all snapshots are returned using the Limit
	// and NextToken members.
	SnapshotIds []*string `type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotsInput) GoString() string {
	return s.String()
}

// Contains the results of the DescribeSnapshots operation.
type DescribeSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// If not null, more results are available. Pass this value in the NextToken
	// member of a subsequent call to DescribeSnapshots.
	NextToken *string `type:"string"`

	// The list of Snapshot objects that were retrieved.
	//
	// It is possible that this list contains less than the number of items specified
	// in the Limit member of the request. This occurs if there are less than the
	// requested number of items left to retrieve, or if the limitations of the
	// operation have been exceeded.
	Snapshots []*Snapshot `type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotsOutput) GoString() string {
	return s.String()
}

// Describes the trust relationships for a particular Microsoft AD in the AWS
// cloud. If no input parameters are are provided, such as directory ID or trust
// ID, this request describes all the trust relationships.
type DescribeTrustsInput struct {
	_ struct{} `type:"structure"`

	// The Directory ID of the AWS directory that is a part of the requested trust
	// relationship.
	DirectoryId *string `type:"string"`

	// The maximum number of objects to return.
	Limit *int64 `type:"integer"`

	// The DescribeTrustsResult.NextToken value from a previous call to DescribeTrusts.
	// Pass null if this is the first call.
	NextToken *string `type:"string"`

	// A list of identifiers of the trust relationships for which to obtain the
	// information. If this member is null, all trust relationships that belong
	// to the current account are returned.
	//
	// An empty list results in an InvalidParameterException being thrown.
	TrustIds []*string `type:"list"`
}

// String returns the string representation
func (s DescribeTrustsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustsInput) GoString() string {
	return s.String()
}

// The result of a DescribeTrust request.
type DescribeTrustsOutput struct {
	_ struct{} `type:"structure"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to DescribeTrusts to retrieve the next set
	// of items.
	NextToken *string `type:"string"`

	// The list of Trust objects that were retrieved.
	//
	// It is possible that this list contains less than the number of items specified
	// in the Limit member of the request. This occurs if there are less than the
	// requested number of items left to retrieve, or if the limitations of the
	// operation have been exceeded.
	Trusts []*Trust `type:"list"`
}

// String returns the string representation
func (s DescribeTrustsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustsOutput) GoString() string {
	return s.String()
}

// Contains information for the ConnectDirectory operation when an AD Connector
// directory is being created.
type DirectoryConnectSettings struct {
	_ struct{} `type:"structure"`

	// A list of one or more IP addresses of DNS servers or domain controllers in
	// the on-premises directory.
	//
	// CustomerDnsIps is a required field
	CustomerDnsIps []*string `type:"list" required:"true"`

	// The username of an account in the on-premises directory that is used to connect
	// to the directory. This account must have the following privileges:
	//
	//    * Read users and groups
	//
	//    * Create computer objects
	//
	//    * Join computers to the domain
	//
	// CustomerUserName is a required field
	CustomerUserName *string `min:"1" type:"string" required:"true"`

	// A list of subnet identifiers in the VPC in which the AD Connector is created.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`

	// The identifier of the VPC in which the AD Connector is created.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DirectoryConnectSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryConnectSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DirectoryConnectSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DirectoryConnectSettings"}
	if s.CustomerDnsIps == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomerDnsIps"))
	}
	if s.CustomerUserName == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomerUserName"))
	}
	if s.CustomerUserName != nil && len(*s.CustomerUserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomerUserName", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about an AD Connector directory.
type DirectoryConnectSettingsDescription struct {
	_ struct{} `type:"structure"`

	// A list of the Availability Zones that the directory is in.
	AvailabilityZones []*string `type:"list"`

	// The IP addresses of the AD Connector servers.
	ConnectIps []*string `type:"list"`

	// The username of the service account in the on-premises directory.
	CustomerUserName *string `min:"1" type:"string"`

	// The security group identifier for the AD Connector directory.
	SecurityGroupId *string `type:"string"`

	// A list of subnet identifiers in the VPC that the AD connector is in.
	SubnetIds []*string `type:"list"`

	// The identifier of the VPC that the AD Connector is in.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DirectoryConnectSettingsDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryConnectSettingsDescription) GoString() string {
	return s.String()
}

// Contains information about an AWS Directory Service directory.
type DirectoryDescription struct {
	_ struct{} `type:"structure"`

	// The access URL for the directory, such as http://<alias>.awsapps.com. If
	// no alias has been created for the directory, <alias> is the directory identifier,
	// such as d-XXXXXXXXXX.
	AccessUrl *string `min:"1" type:"string"`

	// The alias for the directory. If no alias has been created for the directory,
	// the alias is the directory identifier, such as d-XXXXXXXXXX.
	Alias *string `min:"1" type:"string"`

	// A DirectoryConnectSettingsDescription object that contains additional information
	// about an AD Connector directory. This member is only present if the directory
	// is an AD Connector directory.
	ConnectSettings *DirectoryConnectSettingsDescription `type:"structure"`

	// The textual description for the directory.
	Description *string `type:"string"`

	// The directory identifier.
	DirectoryId *string `type:"string"`

	// The IP addresses of the DNS servers for the directory. For a Simple AD or
	// Microsoft AD directory, these are the IP addresses of the Simple AD or Microsoft
	// AD directory servers. For an AD Connector directory, these are the IP addresses
	// of the DNS servers or domain controllers in the on-premises directory to
	// which the AD Connector is connected.
	DnsIpAddrs []*string `type:"list"`

	// Specifies when the directory was created.
	LaunchTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The fully-qualified name of the directory.
	Name *string `type:"string"`

	// A RadiusSettings object that contains information about the RADIUS server
	// configured for this directory.
	RadiusSettings *RadiusSettings `type:"structure"`

	// The status of the RADIUS MFA server connection.
	RadiusStatus *string `type:"string" enum:"RadiusStatus"`

	// The short name of the directory.
	ShortName *string `type:"string"`

	// The directory size.
	Size *string `type:"string" enum:"DirectorySize"`

	// Indicates if single-sign on is enabled for the directory. For more information,
	// see EnableSso and DisableSso.
	SsoEnabled *bool `type:"boolean"`

	// The current stage of the directory.
	Stage *string `type:"string" enum:"DirectoryStage"`

	// The date and time that the stage was last updated.
	StageLastUpdatedDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Additional information about the directory stage.
	StageReason *string `type:"string"`

	// The directory size.
	Type *string `type:"string" enum:"DirectoryType"`

	// A DirectoryVpcSettingsDescription object that contains additional information
	// about a directory. This member is only present if the directory is a Simple
	// AD or Managed AD directory.
	VpcSettings *DirectoryVpcSettingsDescription `type:"structure"`
}

// String returns the string representation
func (s DirectoryDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryDescription) GoString() string {
	return s.String()
}

// Contains directory limit information for a region.
type DirectoryLimits struct {
	_ struct{} `type:"structure"`

	// The current number of cloud directories in the region.
	CloudOnlyDirectoriesCurrentCount *int64 `type:"integer"`

	// The maximum number of cloud directories allowed in the region.
	CloudOnlyDirectoriesLimit *int64 `type:"integer"`

	// Indicates if the cloud directory limit has been reached.
	CloudOnlyDirectoriesLimitReached *bool `type:"boolean"`

	// The current number of Microsoft AD directories in the region.
	CloudOnlyMicrosoftADCurrentCount *int64 `type:"integer"`

	// The maximum number of Microsoft AD directories allowed in the region.
	CloudOnlyMicrosoftADLimit *int64 `type:"integer"`

	// Indicates if the Microsoft AD directory limit has been reached.
	CloudOnlyMicrosoftADLimitReached *bool `type:"boolean"`

	// The current number of connected directories in the region.
	ConnectedDirectoriesCurrentCount *int64 `type:"integer"`

	// The maximum number of connected directories allowed in the region.
	ConnectedDirectoriesLimit *int64 `type:"integer"`

	// Indicates if the connected directory limit has been reached.
	ConnectedDirectoriesLimitReached *bool `type:"boolean"`
}

// String returns the string representation
func (s DirectoryLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryLimits) GoString() string {
	return s.String()
}

// Contains VPC information for the CreateDirectory or CreateMicrosoftAD operation.
type DirectoryVpcSettings struct {
	_ struct{} `type:"structure"`

	// The identifiers of the subnets for the directory servers. The two subnets
	// must be in different Availability Zones. AWS Directory Service creates a
	// directory server and a DNS server in each of these subnets.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`

	// The identifier of the VPC in which to create the directory.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DirectoryVpcSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryVpcSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DirectoryVpcSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DirectoryVpcSettings"}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about the directory.
type DirectoryVpcSettingsDescription struct {
	_ struct{} `type:"structure"`

	// The list of Availability Zones that the directory is in.
	AvailabilityZones []*string `type:"list"`

	// The security group identifier for the directory. If the directory was created
	// before 8/1/2014, this is the identifier of the directory members security
	// group that was created when the directory was created. If the directory was
	// created after this date, this value is null.
	SecurityGroupId *string `type:"string"`

	// The identifiers of the subnets for the directory servers.
	SubnetIds []*string `type:"list"`

	// The identifier of the VPC that the directory is in.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DirectoryVpcSettingsDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryVpcSettingsDescription) GoString() string {
	return s.String()
}

// Contains the inputs for the DisableRadius operation.
type DisableRadiusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for which to disable MFA.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableRadiusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableRadiusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableRadiusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableRadiusInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the DisableRadius operation.
type DisableRadiusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableRadiusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableRadiusOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DisableSso operation.
type DisableSsoInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for which to disable single-sign on.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The password of an alternate account to use to disable single-sign on. This
	// is only used for AD Connector directories. For more information, see the
	// UserName parameter.
	Password *string `min:"1" type:"string"`

	// The username of an alternate account to use to disable single-sign on. This
	// is only used for AD Connector directories. This account must have privileges
	// to remove a service principal name.
	//
	// If the AD Connector service account does not have privileges to remove a
	// service principal name, you can specify an alternate account with the UserName
	// and Password parameters. These credentials are only used to disable single
	// sign-on and are not stored by the service. The AD Connector service account
	// is not changed.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DisableSsoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSsoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableSsoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableSsoInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the DisableSso operation.
type DisableSsoOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableSsoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSsoOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the EnableRadius operation.
type EnableRadiusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for which to enable MFA.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// A RadiusSettings object that contains information about the RADIUS server.
	//
	// RadiusSettings is a required field
	RadiusSettings *RadiusSettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s EnableRadiusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableRadiusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableRadiusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableRadiusInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.RadiusSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("RadiusSettings"))
	}
	if s.RadiusSettings != nil {
		if err := s.RadiusSettings.Validate(); err != nil {
			invalidParams.AddNested("RadiusSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the EnableRadius operation.
type EnableRadiusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableRadiusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableRadiusOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the EnableSso operation.
type EnableSsoInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for which to enable single-sign on.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The password of an alternate account to use to enable single-sign on. This
	// is only used for AD Connector directories. For more information, see the
	// UserName parameter.
	Password *string `min:"1" type:"string"`

	// The username of an alternate account to use to enable single-sign on. This
	// is only used for AD Connector directories. This account must have privileges
	// to add a service principal name.
	//
	// If the AD Connector service account does not have privileges to add a service
	// principal name, you can specify an alternate account with the UserName and
	// Password parameters. These credentials are only used to enable single sign-on
	// and are not stored by the service. The AD Connector service account is not
	// changed.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EnableSsoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSsoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableSsoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableSsoInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the EnableSso operation.
type EnableSsoOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableSsoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSsoOutput) GoString() string {
	return s.String()
}

// Information about SNS topic and AWS Directory Service directory associations.
type EventTopic struct {
	_ struct{} `type:"structure"`

	// The date and time of when you associated your directory with the SNS topic.
	CreatedDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Directory ID of an AWS Directory Service directory that will publish
	// status messages to an SNS topic.
	DirectoryId *string `type:"string"`

	// The topic registration status.
	Status *string `type:"string" enum:"TopicStatus"`

	// The SNS topic ARN (Amazon Resource Name).
	TopicArn *string `type:"string"`

	// The name of an AWS SNS topic the receives status messages from the directory.
	TopicName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EventTopic) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventTopic) GoString() string {
	return s.String()
}

// Contains the inputs for the GetDirectoryLimits operation.
type GetDirectoryLimitsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetDirectoryLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDirectoryLimitsInput) GoString() string {
	return s.String()
}

// Contains the results of the GetDirectoryLimits operation.
type GetDirectoryLimitsOutput struct {
	_ struct{} `type:"structure"`

	// A DirectoryLimits object that contains the directory limits for the current
	// region.
	DirectoryLimits *DirectoryLimits `type:"structure"`
}

// String returns the string representation
func (s GetDirectoryLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDirectoryLimitsOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the GetSnapshotLimits operation.
type GetSnapshotLimitsInput struct {
	_ struct{} `type:"structure"`

	// Contains the identifier of the directory to obtain the limits for.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetSnapshotLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSnapshotLimitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSnapshotLimitsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSnapshotLimitsInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the GetSnapshotLimits operation.
type GetSnapshotLimitsOutput struct {
	_ struct{} `type:"structure"`

	// A SnapshotLimits object that contains the manual snapshot limits for the
	// specified directory.
	SnapshotLimits *SnapshotLimits `type:"structure"`
}

// String returns the string representation
func (s GetSnapshotLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSnapshotLimitsOutput) GoString() string {
	return s.String()
}

// IP address block. This is often the address block of the DNS server used
// for your on-premises domain.
type IpRoute struct {
	_ struct{} `type:"structure"`

	// IP address block using CIDR format, for example 10.0.0.0/24. This is often
	// the address block of the DNS server used for your on-premises domain. For
	// a single IP address use a CIDR address block with /32. For example 10.0.0.0/32.
	CidrIp *string `type:"string"`

	// Description of the address block.
	Description *string `type:"string"`
}

// String returns the string representation
func (s IpRoute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpRoute) GoString() string {
	return s.String()
}

// Information about one or more IP address blocks.
type IpRouteInfo struct {
	_ struct{} `type:"structure"`

	// The date and time the address block was added to the directory.
	AddedDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// IP address block in the IpRoute.
	CidrIp *string `type:"string"`

	// Description of the IpRouteInfo.
	Description *string `type:"string"`

	// Identifier (ID) of the directory associated with the IP addresses.
	DirectoryId *string `type:"string"`

	// The status of the IP address block.
	IpRouteStatusMsg *string `type:"string" enum:"IpRouteStatusMsg"`

	// The reason for the IpRouteStatusMsg.
	IpRouteStatusReason *string `type:"string"`
}

// String returns the string representation
func (s IpRouteInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpRouteInfo) GoString() string {
	return s.String()
}

type ListIpRoutesInput struct {
	_ struct{} `type:"structure"`

	// Identifier (ID) of the directory for which you want to retrieve the IP addresses.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// Maximum number of items to return. If this value is zero, the maximum number
	// of items is specified by the limitations of the operation.
	Limit *int64 `type:"integer"`

	// The ListIpRoutes.NextToken value from a previous call to ListIpRoutes. Pass
	// null if this is the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListIpRoutesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIpRoutesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIpRoutesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIpRoutesInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListIpRoutesOutput struct {
	_ struct{} `type:"structure"`

	// A list of IpRoutes.
	IpRoutesInfo []*IpRouteInfo `type:"list"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to ListIpRoutes to retrieve the next set of
	// items.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListIpRoutesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIpRoutesOutput) GoString() string {
	return s.String()
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	Limit *int64 `type:"integer"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// Identifier (ID) of the directory for which you want to retrieve tags.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// List of tags returned by the ListTagsForResource operation.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// Contains information about a Remote Authentication Dial In User Service (RADIUS)
// server.
type RadiusSettings struct {
	_ struct{} `type:"structure"`

	// The protocol specified for your RADIUS endpoints.
	AuthenticationProtocol *string `type:"string" enum:"RadiusAuthenticationProtocol"`

	// Not currently used.
	DisplayLabel *string `min:"1" type:"string"`

	// The port that your RADIUS server is using for communications. Your on-premises
	// network must allow inbound traffic over this port from the AWS Directory
	// Service servers.
	RadiusPort *int64 `min:"1025" type:"integer"`

	// The maximum number of times that communication with the RADIUS server is
	// attempted.
	RadiusRetries *int64 `type:"integer"`

	// An array of strings that contains the IP addresses of the RADIUS server endpoints,
	// or the IP addresses of your RADIUS server load balancer.
	RadiusServers []*string `type:"list"`

	// The amount of time, in seconds, to wait for the RADIUS server to respond.
	RadiusTimeout *int64 `min:"1" type:"integer"`

	// Not currently used.
	SharedSecret *string `min:"8" type:"string"`

	// Not currently used.
	UseSameUsername *bool `type:"boolean"`
}

// String returns the string representation
func (s RadiusSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RadiusSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RadiusSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RadiusSettings"}
	if s.DisplayLabel != nil && len(*s.DisplayLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayLabel", 1))
	}
	if s.RadiusPort != nil && *s.RadiusPort < 1025 {
		invalidParams.Add(request.NewErrParamMinValue("RadiusPort", 1025))
	}
	if s.RadiusTimeout != nil && *s.RadiusTimeout < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RadiusTimeout", 1))
	}
	if s.SharedSecret != nil && len(*s.SharedSecret) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("SharedSecret", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Registers a new event topic.
type RegisterEventTopicInput struct {
	_ struct{} `type:"structure"`

	// The Directory ID that will publish status messages to the SNS topic.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The SNS topic name to which the directory will publish status messages. This
	// SNS topic must be in the same region as the specified Directory ID.
	//
	// TopicName is a required field
	TopicName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterEventTopicInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterEventTopicInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterEventTopicInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterEventTopicInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.TopicName == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicName"))
	}
	if s.TopicName != nil && len(*s.TopicName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TopicName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a RegisterEventTopic request.
type RegisterEventTopicOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterEventTopicOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterEventTopicOutput) GoString() string {
	return s.String()
}

type RemoveIpRoutesInput struct {
	_ struct{} `type:"structure"`

	// IP address blocks that you want to remove.
	//
	// CidrIps is a required field
	CidrIps []*string `type:"list" required:"true"`

	// Identifier (ID) of the directory from which you want to remove the IP addresses.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveIpRoutesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveIpRoutesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveIpRoutesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveIpRoutesInput"}
	if s.CidrIps == nil {
		invalidParams.Add(request.NewErrParamRequired("CidrIps"))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RemoveIpRoutesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveIpRoutesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveIpRoutesOutput) GoString() string {
	return s.String()
}

type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// Identifier (ID) of the directory from which to remove the tag.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The tag key (name) of the tag to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RemoveTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceOutput) GoString() string {
	return s.String()
}

// An object representing the inputs for the RestoreFromSnapshot operation.
type RestoreFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the snapshot to restore from.
	//
	// SnapshotId is a required field
	SnapshotId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RestoreFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreFromSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreFromSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreFromSnapshotInput"}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the RestoreFromSnapshot operation.
type RestoreFromSnapshotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RestoreFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreFromSnapshotOutput) GoString() string {
	return s.String()
}

// Describes a directory snapshot.
type Snapshot struct {
	_ struct{} `type:"structure"`

	// The directory identifier.
	DirectoryId *string `type:"string"`

	// The descriptive name of the snapshot.
	Name *string `type:"string"`

	// The snapshot identifier.
	SnapshotId *string `type:"string"`

	// The date and time that the snapshot was taken.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The snapshot status.
	Status *string `type:"string" enum:"SnapshotStatus"`

	// The snapshot type.
	Type *string `type:"string" enum:"SnapshotType"`
}

// String returns the string representation
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Snapshot) GoString() string {
	return s.String()
}

// Contains manual snapshot limit information for a directory.
type SnapshotLimits struct {
	_ struct{} `type:"structure"`

	// The current number of manual snapshots of the directory.
	ManualSnapshotsCurrentCount *int64 `type:"integer"`

	// The maximum number of manual snapshots allowed.
	ManualSnapshotsLimit *int64 `type:"integer"`

	// Indicates if the manual snapshot limit has been reached.
	ManualSnapshotsLimitReached *bool `type:"boolean"`
}

// String returns the string representation
func (s SnapshotLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotLimits) GoString() string {
	return s.String()
}

// Metadata assigned to an Amazon Directory Services directory consisting of
// a key-value pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// Required name of the tag. The string value can be Unicode characters and
	// cannot be prefixed with "aws:". The string can contain only the set of Unicode
	// letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The optional value of the tag. The string value can be Unicode characters.
	// The string can contain only the set of Unicode letters, digits, white-space,
	// '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a trust relationship between an Microsoft AD in the AWS cloud and
// an external domain.
type Trust struct {
	_ struct{} `type:"structure"`

	// The date and time that the trust relationship was created.
	CreatedDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Directory ID of the AWS directory involved in the trust relationship.
	DirectoryId *string `type:"string"`

	// The date and time that the trust relationship was last updated.
	LastUpdatedDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Fully Qualified Domain Name (FQDN) of the external domain involved in
	// the trust relationship.
	RemoteDomainName *string `type:"string"`

	// The date and time that the TrustState was last updated.
	StateLastUpdatedDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The trust relationship direction.
	TrustDirection *string `type:"string" enum:"TrustDirection"`

	// The unique ID of the trust relationship.
	TrustId *string `type:"string"`

	// The trust relationship state.
	TrustState *string `type:"string" enum:"TrustState"`

	// The reason for the TrustState.
	TrustStateReason *string `type:"string"`

	// The trust relationship type.
	TrustType *string `type:"string" enum:"TrustType"`
}

// String returns the string representation
func (s Trust) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Trust) GoString() string {
	return s.String()
}

// Updates a conditional forwarder.
type UpdateConditionalForwarderInput struct {
	_ struct{} `type:"structure"`

	// The directory ID of the AWS directory for which to update the conditional
	// forwarder.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The updated IP addresses of the remote DNS server associated with the conditional
	// forwarder.
	//
	// DnsIpAddrs is a required field
	DnsIpAddrs []*string `type:"list" required:"true"`

	// The fully qualified domain name (FQDN) of the remote domain with which you
	// will set up a trust relationship.
	//
	// RemoteDomainName is a required field
	RemoteDomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateConditionalForwarderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConditionalForwarderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConditionalForwarderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConditionalForwarderInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.DnsIpAddrs == nil {
		invalidParams.Add(request.NewErrParamRequired("DnsIpAddrs"))
	}
	if s.RemoteDomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoteDomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of an UpdateConditionalForwarder request.
type UpdateConditionalForwarderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateConditionalForwarderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConditionalForwarderOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the UpdateRadius operation.
type UpdateRadiusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for which to update the RADIUS server information.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// A RadiusSettings object that contains information about the RADIUS server.
	//
	// RadiusSettings is a required field
	RadiusSettings *RadiusSettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateRadiusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRadiusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRadiusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRadiusInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.RadiusSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("RadiusSettings"))
	}
	if s.RadiusSettings != nil {
		if err := s.RadiusSettings.Validate(); err != nil {
			invalidParams.AddNested("RadiusSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the UpdateRadius operation.
type UpdateRadiusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRadiusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRadiusOutput) GoString() string {
	return s.String()
}

// Initiates the verification of an existing trust relationship between a Microsoft
// AD in the AWS cloud and an external domain.
type VerifyTrustInput struct {
	_ struct{} `type:"structure"`

	// The unique Trust ID of the trust relationship to verify.
	//
	// TrustId is a required field
	TrustId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VerifyTrustInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyTrustInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyTrustInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyTrustInput"}
	if s.TrustId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Result of a VerifyTrust request.
type VerifyTrustOutput struct {
	_ struct{} `type:"structure"`

	// The unique Trust ID of the trust relationship that was verified.
	TrustId *string `type:"string"`
}

// String returns the string representation
func (s VerifyTrustOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyTrustOutput) GoString() string {
	return s.String()
}

const (
	// DirectorySizeSmall is a DirectorySize enum value
	DirectorySizeSmall = "Small"

	// DirectorySizeLarge is a DirectorySize enum value
	DirectorySizeLarge = "Large"
)

const (
	// DirectoryStageRequested is a DirectoryStage enum value
	DirectoryStageRequested = "Requested"

	// DirectoryStageCreating is a DirectoryStage enum value
	DirectoryStageCreating = "Creating"

	// DirectoryStageCreated is a DirectoryStage enum value
	DirectoryStageCreated = "Created"

	// DirectoryStageActive is a DirectoryStage enum value
	DirectoryStageActive = "Active"

	// DirectoryStageInoperable is a DirectoryStage enum value
	DirectoryStageInoperable = "Inoperable"

	// DirectoryStageImpaired is a DirectoryStage enum value
	DirectoryStageImpaired = "Impaired"

	// DirectoryStageRestoring is a DirectoryStage enum value
	DirectoryStageRestoring = "Restoring"

	// DirectoryStageRestoreFailed is a DirectoryStage enum value
	DirectoryStageRestoreFailed = "RestoreFailed"

	// DirectoryStageDeleting is a DirectoryStage enum value
	DirectoryStageDeleting = "Deleting"

	// DirectoryStageDeleted is a DirectoryStage enum value
	DirectoryStageDeleted = "Deleted"

	// DirectoryStageFailed is a DirectoryStage enum value
	DirectoryStageFailed = "Failed"
)

const (
	// DirectoryTypeSimpleAd is a DirectoryType enum value
	DirectoryTypeSimpleAd = "SimpleAD"

	// DirectoryTypeAdconnector is a DirectoryType enum value
	DirectoryTypeAdconnector = "ADConnector"

	// DirectoryTypeMicrosoftAd is a DirectoryType enum value
	DirectoryTypeMicrosoftAd = "MicrosoftAD"
)

const (
	// IpRouteStatusMsgAdding is a IpRouteStatusMsg enum value
	IpRouteStatusMsgAdding = "Adding"

	// IpRouteStatusMsgAdded is a IpRouteStatusMsg enum value
	IpRouteStatusMsgAdded = "Added"

	// IpRouteStatusMsgRemoving is a IpRouteStatusMsg enum value
	IpRouteStatusMsgRemoving = "Removing"

	// IpRouteStatusMsgRemoved is a IpRouteStatusMsg enum value
	IpRouteStatusMsgRemoved = "Removed"

	// IpRouteStatusMsgAddFailed is a IpRouteStatusMsg enum value
	IpRouteStatusMsgAddFailed = "AddFailed"

	// IpRouteStatusMsgRemoveFailed is a IpRouteStatusMsg enum value
	IpRouteStatusMsgRemoveFailed = "RemoveFailed"
)

const (
	// RadiusAuthenticationProtocolPap is a RadiusAuthenticationProtocol enum value
	RadiusAuthenticationProtocolPap = "PAP"

	// RadiusAuthenticationProtocolChap is a RadiusAuthenticationProtocol enum value
	RadiusAuthenticationProtocolChap = "CHAP"

	// RadiusAuthenticationProtocolMsChapv1 is a RadiusAuthenticationProtocol enum value
	RadiusAuthenticationProtocolMsChapv1 = "MS-CHAPv1"

	// RadiusAuthenticationProtocolMsChapv2 is a RadiusAuthenticationProtocol enum value
	RadiusAuthenticationProtocolMsChapv2 = "MS-CHAPv2"
)

const (
	// RadiusStatusCreating is a RadiusStatus enum value
	RadiusStatusCreating = "Creating"

	// RadiusStatusCompleted is a RadiusStatus enum value
	RadiusStatusCompleted = "Completed"

	// RadiusStatusFailed is a RadiusStatus enum value
	RadiusStatusFailed = "Failed"
)

const (
	// ReplicationScopeDomain is a ReplicationScope enum value
	ReplicationScopeDomain = "Domain"
)

const (
	// SnapshotStatusCreating is a SnapshotStatus enum value
	SnapshotStatusCreating = "Creating"

	// SnapshotStatusCompleted is a SnapshotStatus enum value
	SnapshotStatusCompleted = "Completed"

	// SnapshotStatusFailed is a SnapshotStatus enum value
	SnapshotStatusFailed = "Failed"
)

const (
	// SnapshotTypeAuto is a SnapshotType enum value
	SnapshotTypeAuto = "Auto"

	// SnapshotTypeManual is a SnapshotType enum value
	SnapshotTypeManual = "Manual"
)

const (
	// TopicStatusRegistered is a TopicStatus enum value
	TopicStatusRegistered = "Registered"

	// TopicStatusTopicnotfound is a TopicStatus enum value
	TopicStatusTopicnotfound = "Topic not found"

	// TopicStatusFailed is a TopicStatus enum value
	TopicStatusFailed = "Failed"

	// TopicStatusDeleted is a TopicStatus enum value
	TopicStatusDeleted = "Deleted"
)

const (
	// TrustDirectionOneWayOutgoing is a TrustDirection enum value
	TrustDirectionOneWayOutgoing = "One-Way: Outgoing"

	// TrustDirectionOneWayIncoming is a TrustDirection enum value
	TrustDirectionOneWayIncoming = "One-Way: Incoming"

	// TrustDirectionTwoWay is a TrustDirection enum value
	TrustDirectionTwoWay = "Two-Way"
)

const (
	// TrustStateCreating is a TrustState enum value
	TrustStateCreating = "Creating"

	// TrustStateCreated is a TrustState enum value
	TrustStateCreated = "Created"

	// TrustStateVerifying is a TrustState enum value
	TrustStateVerifying = "Verifying"

	// TrustStateVerifyFailed is a TrustState enum value
	TrustStateVerifyFailed = "VerifyFailed"

	// TrustStateVerified is a TrustState enum value
	TrustStateVerified = "Verified"

	// TrustStateDeleting is a TrustState enum value
	TrustStateDeleting = "Deleting"

	// TrustStateDeleted is a TrustState enum value
	TrustStateDeleted = "Deleted"

	// TrustStateFailed is a TrustState enum value
	TrustStateFailed = "Failed"
)

const (
	// TrustTypeForest is a TrustType enum value
	TrustTypeForest = "Forest"
)
