// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package codedeploy provides a client for AWS CodeDeploy.
package codedeploy

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddTagsToOnPremisesInstances = "AddTagsToOnPremisesInstances"

// AddTagsToOnPremisesInstancesRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToOnPremisesInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddTagsToOnPremisesInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddTagsToOnPremisesInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddTagsToOnPremisesInstancesRequest method.
//    req, resp := client.AddTagsToOnPremisesInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) AddTagsToOnPremisesInstancesRequest(input *AddTagsToOnPremisesInstancesInput) (req *request.Request, output *AddTagsToOnPremisesInstancesOutput) {
	op := &request.Operation{
		Name:       opAddTagsToOnPremisesInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToOnPremisesInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AddTagsToOnPremisesInstancesOutput{}
	req.Data = output
	return
}

// AddTagsToOnPremisesInstances API operation for AWS CodeDeploy.
//
// Adds tags to on-premises instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation AddTagsToOnPremisesInstances for usage and error information.
//
// Returned Error Codes:
//   * InstanceNameRequiredException
//   An on-premises instance name was not specified.
//
//   * TagRequiredException
//   A tag was not specified.
//
//   * InvalidTagException
//   The specified tag was specified in an invalid format.
//
//   * TagLimitExceededException
//   The maximum allowed number of tags was exceeded.
//
//   * InstanceLimitExceededException
//   The maximum number of allowed on-premises instances in a single call was
//   exceeded.
//
//   * InstanceNotRegisteredException
//   The specified on-premises instance is not registered.
//
func (c *CodeDeploy) AddTagsToOnPremisesInstances(input *AddTagsToOnPremisesInstancesInput) (*AddTagsToOnPremisesInstancesOutput, error) {
	req, out := c.AddTagsToOnPremisesInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opBatchGetApplicationRevisions = "BatchGetApplicationRevisions"

// BatchGetApplicationRevisionsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetApplicationRevisions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BatchGetApplicationRevisions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchGetApplicationRevisions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchGetApplicationRevisionsRequest method.
//    req, resp := client.BatchGetApplicationRevisionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) BatchGetApplicationRevisionsRequest(input *BatchGetApplicationRevisionsInput) (req *request.Request, output *BatchGetApplicationRevisionsOutput) {
	op := &request.Operation{
		Name:       opBatchGetApplicationRevisions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetApplicationRevisionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BatchGetApplicationRevisionsOutput{}
	req.Data = output
	return
}

// BatchGetApplicationRevisions API operation for AWS CodeDeploy.
//
// Gets information about one or more application revisions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation BatchGetApplicationRevisions for usage and error information.
//
// Returned Error Codes:
//   * ApplicationDoesNotExistException
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * RevisionRequiredException
//   The revision ID was not specified.
//
//   * InvalidRevisionException
//   The revision was specified in an invalid format.
//
//   * BatchLimitExceededException
//   The maximum number of names or IDs allowed for this request (100) was exceeded.
//
func (c *CodeDeploy) BatchGetApplicationRevisions(input *BatchGetApplicationRevisionsInput) (*BatchGetApplicationRevisionsOutput, error) {
	req, out := c.BatchGetApplicationRevisionsRequest(input)
	err := req.Send()
	return out, err
}

const opBatchGetApplications = "BatchGetApplications"

// BatchGetApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetApplications operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BatchGetApplications for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchGetApplications method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchGetApplicationsRequest method.
//    req, resp := client.BatchGetApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) BatchGetApplicationsRequest(input *BatchGetApplicationsInput) (req *request.Request, output *BatchGetApplicationsOutput) {
	op := &request.Operation{
		Name:       opBatchGetApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetApplicationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BatchGetApplicationsOutput{}
	req.Data = output
	return
}

// BatchGetApplications API operation for AWS CodeDeploy.
//
// Gets information about one or more applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation BatchGetApplications for usage and error information.
//
// Returned Error Codes:
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * ApplicationDoesNotExistException
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * BatchLimitExceededException
//   The maximum number of names or IDs allowed for this request (100) was exceeded.
//
func (c *CodeDeploy) BatchGetApplications(input *BatchGetApplicationsInput) (*BatchGetApplicationsOutput, error) {
	req, out := c.BatchGetApplicationsRequest(input)
	err := req.Send()
	return out, err
}

const opBatchGetDeploymentGroups = "BatchGetDeploymentGroups"

// BatchGetDeploymentGroupsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetDeploymentGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BatchGetDeploymentGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchGetDeploymentGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchGetDeploymentGroupsRequest method.
//    req, resp := client.BatchGetDeploymentGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) BatchGetDeploymentGroupsRequest(input *BatchGetDeploymentGroupsInput) (req *request.Request, output *BatchGetDeploymentGroupsOutput) {
	op := &request.Operation{
		Name:       opBatchGetDeploymentGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetDeploymentGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BatchGetDeploymentGroupsOutput{}
	req.Data = output
	return
}

// BatchGetDeploymentGroups API operation for AWS CodeDeploy.
//
// Get information about one or more deployment groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation BatchGetDeploymentGroups for usage and error information.
//
// Returned Error Codes:
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * ApplicationDoesNotExistException
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * DeploymentGroupNameRequiredException
//   The deployment group name was not specified.
//
//   * InvalidDeploymentGroupNameException
//   The deployment group name was specified in an invalid format.
//
//   * BatchLimitExceededException
//   The maximum number of names or IDs allowed for this request (100) was exceeded.
//
func (c *CodeDeploy) BatchGetDeploymentGroups(input *BatchGetDeploymentGroupsInput) (*BatchGetDeploymentGroupsOutput, error) {
	req, out := c.BatchGetDeploymentGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opBatchGetDeploymentInstances = "BatchGetDeploymentInstances"

// BatchGetDeploymentInstancesRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetDeploymentInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BatchGetDeploymentInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchGetDeploymentInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchGetDeploymentInstancesRequest method.
//    req, resp := client.BatchGetDeploymentInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) BatchGetDeploymentInstancesRequest(input *BatchGetDeploymentInstancesInput) (req *request.Request, output *BatchGetDeploymentInstancesOutput) {
	op := &request.Operation{
		Name:       opBatchGetDeploymentInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetDeploymentInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BatchGetDeploymentInstancesOutput{}
	req.Data = output
	return
}

// BatchGetDeploymentInstances API operation for AWS CodeDeploy.
//
// Gets information about one or more instance that are part of a deployment
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation BatchGetDeploymentInstances for usage and error information.
//
// Returned Error Codes:
//   * DeploymentIdRequiredException
//   At least one deployment ID must be specified.
//
//   * DeploymentDoesNotExistException
//   The deployment does not exist with the applicable IAM user or AWS account.
//
//   * InstanceIdRequiredException
//   The instance ID was not specified.
//
//   * InvalidDeploymentIdException
//   At least one of the deployment IDs was specified in an invalid format.
//
//   * InvalidInstanceNameException
//   The specified on-premises instance name was specified in an invalid format.
//
//   * BatchLimitExceededException
//   The maximum number of names or IDs allowed for this request (100) was exceeded.
//
func (c *CodeDeploy) BatchGetDeploymentInstances(input *BatchGetDeploymentInstancesInput) (*BatchGetDeploymentInstancesOutput, error) {
	req, out := c.BatchGetDeploymentInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opBatchGetDeployments = "BatchGetDeployments"

// BatchGetDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetDeployments operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BatchGetDeployments for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchGetDeployments method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchGetDeploymentsRequest method.
//    req, resp := client.BatchGetDeploymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) BatchGetDeploymentsRequest(input *BatchGetDeploymentsInput) (req *request.Request, output *BatchGetDeploymentsOutput) {
	op := &request.Operation{
		Name:       opBatchGetDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetDeploymentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BatchGetDeploymentsOutput{}
	req.Data = output
	return
}

// BatchGetDeployments API operation for AWS CodeDeploy.
//
// Gets information about one or more deployments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation BatchGetDeployments for usage and error information.
//
// Returned Error Codes:
//   * DeploymentIdRequiredException
//   At least one deployment ID must be specified.
//
//   * InvalidDeploymentIdException
//   At least one of the deployment IDs was specified in an invalid format.
//
//   * BatchLimitExceededException
//   The maximum number of names or IDs allowed for this request (100) was exceeded.
//
func (c *CodeDeploy) BatchGetDeployments(input *BatchGetDeploymentsInput) (*BatchGetDeploymentsOutput, error) {
	req, out := c.BatchGetDeploymentsRequest(input)
	err := req.Send()
	return out, err
}

const opBatchGetOnPremisesInstances = "BatchGetOnPremisesInstances"

// BatchGetOnPremisesInstancesRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetOnPremisesInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BatchGetOnPremisesInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchGetOnPremisesInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchGetOnPremisesInstancesRequest method.
//    req, resp := client.BatchGetOnPremisesInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) BatchGetOnPremisesInstancesRequest(input *BatchGetOnPremisesInstancesInput) (req *request.Request, output *BatchGetOnPremisesInstancesOutput) {
	op := &request.Operation{
		Name:       opBatchGetOnPremisesInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetOnPremisesInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BatchGetOnPremisesInstancesOutput{}
	req.Data = output
	return
}

// BatchGetOnPremisesInstances API operation for AWS CodeDeploy.
//
// Gets information about one or more on-premises instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation BatchGetOnPremisesInstances for usage and error information.
//
// Returned Error Codes:
//   * InstanceNameRequiredException
//   An on-premises instance name was not specified.
//
//   * InvalidInstanceNameException
//   The specified on-premises instance name was specified in an invalid format.
//
//   * BatchLimitExceededException
//   The maximum number of names or IDs allowed for this request (100) was exceeded.
//
func (c *CodeDeploy) BatchGetOnPremisesInstances(input *BatchGetOnPremisesInstancesInput) (*BatchGetOnPremisesInstancesOutput, error) {
	req, out := c.BatchGetOnPremisesInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateApplication for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateApplication method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateApplicationRequest method.
//    req, resp := client.CreateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateApplicationOutput{}
	req.Data = output
	return
}

// CreateApplication API operation for AWS CodeDeploy.
//
// Creates an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation CreateApplication for usage and error information.
//
// Returned Error Codes:
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * ApplicationAlreadyExistsException
//   An application with the specified name already exists with the applicable
//   IAM user or AWS account.
//
//   * ApplicationLimitExceededException
//   More applications were attempted to be created than are allowed.
//
func (c *CodeDeploy) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDeployment = "CreateDeployment"

// CreateDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeployment operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateDeployment for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateDeployment method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateDeploymentRequest method.
//    req, resp := client.CreateDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) CreateDeploymentRequest(input *CreateDeploymentInput) (req *request.Request, output *CreateDeploymentOutput) {
	op := &request.Operation{
		Name:       opCreateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeploymentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDeploymentOutput{}
	req.Data = output
	return
}

// CreateDeployment API operation for AWS CodeDeploy.
//
// Deploys an application revision through the specified deployment group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation CreateDeployment for usage and error information.
//
// Returned Error Codes:
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * ApplicationDoesNotExistException
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * DeploymentGroupNameRequiredException
//   The deployment group name was not specified.
//
//   * InvalidDeploymentGroupNameException
//   The deployment group name was specified in an invalid format.
//
//   * DeploymentGroupDoesNotExistException
//   The named deployment group does not exist with the applicable IAM user or
//   AWS account.
//
//   * RevisionRequiredException
//   The revision ID was not specified.
//
//   * RevisionDoesNotExistException
//   The named revision does not exist with the applicable IAM user or AWS account.
//
//   * InvalidRevisionException
//   The revision was specified in an invalid format.
//
//   * InvalidDeploymentConfigNameException
//   The deployment configuration name was specified in an invalid format.
//
//   * DeploymentConfigDoesNotExistException
//   The deployment configuration does not exist with the applicable IAM user
//   or AWS account.
//
//   * DescriptionTooLongException
//   The description is too long.
//
//   * DeploymentLimitExceededException
//   The number of allowed deployments was exceeded.
//
//   * InvalidAutoRollbackConfigException
//   The automatic rollback configuration was specified in an invalid format.
//   For example, automatic rollback is enabled but an invalid triggering event
//   type or no event types were listed.
//
func (c *CodeDeploy) CreateDeployment(input *CreateDeploymentInput) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDeploymentConfig = "CreateDeploymentConfig"

// CreateDeploymentConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeploymentConfig operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateDeploymentConfig for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateDeploymentConfig method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateDeploymentConfigRequest method.
//    req, resp := client.CreateDeploymentConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) CreateDeploymentConfigRequest(input *CreateDeploymentConfigInput) (req *request.Request, output *CreateDeploymentConfigOutput) {
	op := &request.Operation{
		Name:       opCreateDeploymentConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeploymentConfigInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDeploymentConfigOutput{}
	req.Data = output
	return
}

// CreateDeploymentConfig API operation for AWS CodeDeploy.
//
// Creates a deployment configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation CreateDeploymentConfig for usage and error information.
//
// Returned Error Codes:
//   * InvalidDeploymentConfigNameException
//   The deployment configuration name was specified in an invalid format.
//
//   * DeploymentConfigNameRequiredException
//   The deployment configuration name was not specified.
//
//   * DeploymentConfigAlreadyExistsException
//   A deployment configuration with the specified name already exists with the
//   applicable IAM user or AWS account.
//
//   * InvalidMinimumHealthyHostValueException
//   The minimum healthy instance value was specified in an invalid format.
//
//   * DeploymentConfigLimitExceededException
//   The deployment configurations limit was exceeded.
//
func (c *CodeDeploy) CreateDeploymentConfig(input *CreateDeploymentConfigInput) (*CreateDeploymentConfigOutput, error) {
	req, out := c.CreateDeploymentConfigRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDeploymentGroup = "CreateDeploymentGroup"

// CreateDeploymentGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeploymentGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateDeploymentGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateDeploymentGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateDeploymentGroupRequest method.
//    req, resp := client.CreateDeploymentGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) CreateDeploymentGroupRequest(input *CreateDeploymentGroupInput) (req *request.Request, output *CreateDeploymentGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDeploymentGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeploymentGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDeploymentGroupOutput{}
	req.Data = output
	return
}

// CreateDeploymentGroup API operation for AWS CodeDeploy.
//
// Creates a deployment group to which application revisions will be deployed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation CreateDeploymentGroup for usage and error information.
//
// Returned Error Codes:
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * ApplicationDoesNotExistException
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * DeploymentGroupNameRequiredException
//   The deployment group name was not specified.
//
//   * InvalidDeploymentGroupNameException
//   The deployment group name was specified in an invalid format.
//
//   * DeploymentGroupAlreadyExistsException
//   A deployment group with the specified name already exists with the applicable
//   IAM user or AWS account.
//
//   * InvalidEC2TagException
//   The tag was specified in an invalid format.
//
//   * InvalidTagException
//   The specified tag was specified in an invalid format.
//
//   * InvalidAutoScalingGroupException
//   The Auto Scaling group was specified in an invalid format or does not exist.
//
//   * InvalidDeploymentConfigNameException
//   The deployment configuration name was specified in an invalid format.
//
//   * DeploymentConfigDoesNotExistException
//   The deployment configuration does not exist with the applicable IAM user
//   or AWS account.
//
//   * RoleRequiredException
//   The role ID was not specified.
//
//   * InvalidRoleException
//   The service role ARN was specified in an invalid format. Or, if an Auto Scaling
//   group was specified, the specified service role does not grant the appropriate
//   permissions to Auto Scaling.
//
//   * DeploymentGroupLimitExceededException
//   The deployment groups limit was exceeded.
//
//   * LifecycleHookLimitExceededException
//   The limit for lifecycle hooks was exceeded.
//
//   * InvalidTriggerConfigException
//   The trigger was specified in an invalid format.
//
//   * TriggerTargetsLimitExceededException
//   The maximum allowed number of triggers was exceeded.
//
//   * InvalidAlarmConfigException
//   The format of the alarm configuration is invalid. Possible causes include:
//
//      * The alarm list is null.
//
//      * The alarm object is null.
//
//      * The alarm name is empty or null or exceeds the 255 character limit.
//
//      * Two alarms with the same name have been specified.
//
//      * The alarm configuration is enabled but the alarm list is empty.
//
//   * AlarmsLimitExceededException
//   The maximum number of alarms for a deployment group (10) was exceeded.
//
//   * InvalidAutoRollbackConfigException
//   The automatic rollback configuration was specified in an invalid format.
//   For example, automatic rollback is enabled but an invalid triggering event
//   type or no event types were listed.
//
func (c *CodeDeploy) CreateDeploymentGroup(input *CreateDeploymentGroupInput) (*CreateDeploymentGroupOutput, error) {
	req, out := c.CreateDeploymentGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteApplication for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteApplication method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteApplicationRequest method.
//    req, resp := client.DeleteApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteApplicationOutput{}
	req.Data = output
	return
}

// DeleteApplication API operation for AWS CodeDeploy.
//
// Deletes an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Codes:
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
func (c *CodeDeploy) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDeploymentConfig = "DeleteDeploymentConfig"

// DeleteDeploymentConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeploymentConfig operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteDeploymentConfig for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteDeploymentConfig method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteDeploymentConfigRequest method.
//    req, resp := client.DeleteDeploymentConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) DeleteDeploymentConfigRequest(input *DeleteDeploymentConfigInput) (req *request.Request, output *DeleteDeploymentConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteDeploymentConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeploymentConfigInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteDeploymentConfigOutput{}
	req.Data = output
	return
}

// DeleteDeploymentConfig API operation for AWS CodeDeploy.
//
// Deletes a deployment configuration.
//
// A deployment configuration cannot be deleted if it is currently in use. Predefined
// configurations cannot be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation DeleteDeploymentConfig for usage and error information.
//
// Returned Error Codes:
//   * InvalidDeploymentConfigNameException
//   The deployment configuration name was specified in an invalid format.
//
//   * DeploymentConfigNameRequiredException
//   The deployment configuration name was not specified.
//
//   * DeploymentConfigInUseException
//   The deployment configuration is still in use.
//
//   * InvalidOperationException
//   An invalid operation was detected.
//
func (c *CodeDeploy) DeleteDeploymentConfig(input *DeleteDeploymentConfigInput) (*DeleteDeploymentConfigOutput, error) {
	req, out := c.DeleteDeploymentConfigRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDeploymentGroup = "DeleteDeploymentGroup"

// DeleteDeploymentGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeploymentGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteDeploymentGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteDeploymentGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteDeploymentGroupRequest method.
//    req, resp := client.DeleteDeploymentGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) DeleteDeploymentGroupRequest(input *DeleteDeploymentGroupInput) (req *request.Request, output *DeleteDeploymentGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDeploymentGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeploymentGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDeploymentGroupOutput{}
	req.Data = output
	return
}

// DeleteDeploymentGroup API operation for AWS CodeDeploy.
//
// Deletes a deployment group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation DeleteDeploymentGroup for usage and error information.
//
// Returned Error Codes:
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * DeploymentGroupNameRequiredException
//   The deployment group name was not specified.
//
//   * InvalidDeploymentGroupNameException
//   The deployment group name was specified in an invalid format.
//
//   * InvalidRoleException
//   The service role ARN was specified in an invalid format. Or, if an Auto Scaling
//   group was specified, the specified service role does not grant the appropriate
//   permissions to Auto Scaling.
//
func (c *CodeDeploy) DeleteDeploymentGroup(input *DeleteDeploymentGroupInput) (*DeleteDeploymentGroupOutput, error) {
	req, out := c.DeleteDeploymentGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeregisterOnPremisesInstance = "DeregisterOnPremisesInstance"

// DeregisterOnPremisesInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterOnPremisesInstance operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeregisterOnPremisesInstance for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeregisterOnPremisesInstance method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeregisterOnPremisesInstanceRequest method.
//    req, resp := client.DeregisterOnPremisesInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) DeregisterOnPremisesInstanceRequest(input *DeregisterOnPremisesInstanceInput) (req *request.Request, output *DeregisterOnPremisesInstanceOutput) {
	op := &request.Operation{
		Name:       opDeregisterOnPremisesInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterOnPremisesInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeregisterOnPremisesInstanceOutput{}
	req.Data = output
	return
}

// DeregisterOnPremisesInstance API operation for AWS CodeDeploy.
//
// Deregisters an on-premises instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation DeregisterOnPremisesInstance for usage and error information.
//
// Returned Error Codes:
//   * InstanceNameRequiredException
//   An on-premises instance name was not specified.
//
//   * InvalidInstanceNameException
//   The specified on-premises instance name was specified in an invalid format.
//
func (c *CodeDeploy) DeregisterOnPremisesInstance(input *DeregisterOnPremisesInstanceInput) (*DeregisterOnPremisesInstanceOutput, error) {
	req, out := c.DeregisterOnPremisesInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opGetApplication = "GetApplication"

// GetApplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetApplication operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetApplication for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetApplication method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetApplicationRequest method.
//    req, resp := client.GetApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) GetApplicationRequest(input *GetApplicationInput) (req *request.Request, output *GetApplicationOutput) {
	op := &request.Operation{
		Name:       opGetApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetApplicationOutput{}
	req.Data = output
	return
}

// GetApplication API operation for AWS CodeDeploy.
//
// Gets information about an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation GetApplication for usage and error information.
//
// Returned Error Codes:
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * ApplicationDoesNotExistException
//   The application does not exist with the applicable IAM user or AWS account.
//
func (c *CodeDeploy) GetApplication(input *GetApplicationInput) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opGetApplicationRevision = "GetApplicationRevision"

// GetApplicationRevisionRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationRevision operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetApplicationRevision for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetApplicationRevision method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetApplicationRevisionRequest method.
//    req, resp := client.GetApplicationRevisionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) GetApplicationRevisionRequest(input *GetApplicationRevisionInput) (req *request.Request, output *GetApplicationRevisionOutput) {
	op := &request.Operation{
		Name:       opGetApplicationRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetApplicationRevisionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetApplicationRevisionOutput{}
	req.Data = output
	return
}

// GetApplicationRevision API operation for AWS CodeDeploy.
//
// Gets information about an application revision.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation GetApplicationRevision for usage and error information.
//
// Returned Error Codes:
//   * ApplicationDoesNotExistException
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * RevisionDoesNotExistException
//   The named revision does not exist with the applicable IAM user or AWS account.
//
//   * RevisionRequiredException
//   The revision ID was not specified.
//
//   * InvalidRevisionException
//   The revision was specified in an invalid format.
//
func (c *CodeDeploy) GetApplicationRevision(input *GetApplicationRevisionInput) (*GetApplicationRevisionOutput, error) {
	req, out := c.GetApplicationRevisionRequest(input)
	err := req.Send()
	return out, err
}

const opGetDeployment = "GetDeployment"

// GetDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the GetDeployment operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetDeployment for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetDeployment method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetDeploymentRequest method.
//    req, resp := client.GetDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) GetDeploymentRequest(input *GetDeploymentInput) (req *request.Request, output *GetDeploymentOutput) {
	op := &request.Operation{
		Name:       opGetDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeploymentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDeploymentOutput{}
	req.Data = output
	return
}

// GetDeployment API operation for AWS CodeDeploy.
//
// Gets information about a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation GetDeployment for usage and error information.
//
// Returned Error Codes:
//   * DeploymentIdRequiredException
//   At least one deployment ID must be specified.
//
//   * InvalidDeploymentIdException
//   At least one of the deployment IDs was specified in an invalid format.
//
//   * DeploymentDoesNotExistException
//   The deployment does not exist with the applicable IAM user or AWS account.
//
func (c *CodeDeploy) GetDeployment(input *GetDeploymentInput) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	err := req.Send()
	return out, err
}

const opGetDeploymentConfig = "GetDeploymentConfig"

// GetDeploymentConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetDeploymentConfig operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetDeploymentConfig for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetDeploymentConfig method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetDeploymentConfigRequest method.
//    req, resp := client.GetDeploymentConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) GetDeploymentConfigRequest(input *GetDeploymentConfigInput) (req *request.Request, output *GetDeploymentConfigOutput) {
	op := &request.Operation{
		Name:       opGetDeploymentConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeploymentConfigInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDeploymentConfigOutput{}
	req.Data = output
	return
}

// GetDeploymentConfig API operation for AWS CodeDeploy.
//
// Gets information about a deployment configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation GetDeploymentConfig for usage and error information.
//
// Returned Error Codes:
//   * InvalidDeploymentConfigNameException
//   The deployment configuration name was specified in an invalid format.
//
//   * DeploymentConfigNameRequiredException
//   The deployment configuration name was not specified.
//
//   * DeploymentConfigDoesNotExistException
//   The deployment configuration does not exist with the applicable IAM user
//   or AWS account.
//
func (c *CodeDeploy) GetDeploymentConfig(input *GetDeploymentConfigInput) (*GetDeploymentConfigOutput, error) {
	req, out := c.GetDeploymentConfigRequest(input)
	err := req.Send()
	return out, err
}

const opGetDeploymentGroup = "GetDeploymentGroup"

// GetDeploymentGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetDeploymentGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetDeploymentGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetDeploymentGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetDeploymentGroupRequest method.
//    req, resp := client.GetDeploymentGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) GetDeploymentGroupRequest(input *GetDeploymentGroupInput) (req *request.Request, output *GetDeploymentGroupOutput) {
	op := &request.Operation{
		Name:       opGetDeploymentGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeploymentGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDeploymentGroupOutput{}
	req.Data = output
	return
}

// GetDeploymentGroup API operation for AWS CodeDeploy.
//
// Gets information about a deployment group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation GetDeploymentGroup for usage and error information.
//
// Returned Error Codes:
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * ApplicationDoesNotExistException
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * DeploymentGroupNameRequiredException
//   The deployment group name was not specified.
//
//   * InvalidDeploymentGroupNameException
//   The deployment group name was specified in an invalid format.
//
//   * DeploymentGroupDoesNotExistException
//   The named deployment group does not exist with the applicable IAM user or
//   AWS account.
//
func (c *CodeDeploy) GetDeploymentGroup(input *GetDeploymentGroupInput) (*GetDeploymentGroupOutput, error) {
	req, out := c.GetDeploymentGroupRequest(input)
	err := req.Send()
	return out, err
}

const opGetDeploymentInstance = "GetDeploymentInstance"

// GetDeploymentInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetDeploymentInstance operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetDeploymentInstance for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetDeploymentInstance method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetDeploymentInstanceRequest method.
//    req, resp := client.GetDeploymentInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) GetDeploymentInstanceRequest(input *GetDeploymentInstanceInput) (req *request.Request, output *GetDeploymentInstanceOutput) {
	op := &request.Operation{
		Name:       opGetDeploymentInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeploymentInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDeploymentInstanceOutput{}
	req.Data = output
	return
}

// GetDeploymentInstance API operation for AWS CodeDeploy.
//
// Gets information about an instance as part of a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation GetDeploymentInstance for usage and error information.
//
// Returned Error Codes:
//   * DeploymentIdRequiredException
//   At least one deployment ID must be specified.
//
//   * DeploymentDoesNotExistException
//   The deployment does not exist with the applicable IAM user or AWS account.
//
//   * InstanceIdRequiredException
//   The instance ID was not specified.
//
//   * InvalidDeploymentIdException
//   At least one of the deployment IDs was specified in an invalid format.
//
//   * InstanceDoesNotExistException
//   The specified instance does not exist in the deployment group.
//
//   * InvalidInstanceNameException
//   The specified on-premises instance name was specified in an invalid format.
//
func (c *CodeDeploy) GetDeploymentInstance(input *GetDeploymentInstanceInput) (*GetDeploymentInstanceOutput, error) {
	req, out := c.GetDeploymentInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opGetOnPremisesInstance = "GetOnPremisesInstance"

// GetOnPremisesInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetOnPremisesInstance operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetOnPremisesInstance for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetOnPremisesInstance method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetOnPremisesInstanceRequest method.
//    req, resp := client.GetOnPremisesInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) GetOnPremisesInstanceRequest(input *GetOnPremisesInstanceInput) (req *request.Request, output *GetOnPremisesInstanceOutput) {
	op := &request.Operation{
		Name:       opGetOnPremisesInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOnPremisesInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetOnPremisesInstanceOutput{}
	req.Data = output
	return
}

// GetOnPremisesInstance API operation for AWS CodeDeploy.
//
// Gets information about an on-premises instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation GetOnPremisesInstance for usage and error information.
//
// Returned Error Codes:
//   * InstanceNameRequiredException
//   An on-premises instance name was not specified.
//
//   * InstanceNotRegisteredException
//   The specified on-premises instance is not registered.
//
//   * InvalidInstanceNameException
//   The specified on-premises instance name was specified in an invalid format.
//
func (c *CodeDeploy) GetOnPremisesInstance(input *GetOnPremisesInstanceInput) (*GetOnPremisesInstanceOutput, error) {
	req, out := c.GetOnPremisesInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opListApplicationRevisions = "ListApplicationRevisions"

// ListApplicationRevisionsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationRevisions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListApplicationRevisions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListApplicationRevisions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListApplicationRevisionsRequest method.
//    req, resp := client.ListApplicationRevisionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) ListApplicationRevisionsRequest(input *ListApplicationRevisionsInput) (req *request.Request, output *ListApplicationRevisionsOutput) {
	op := &request.Operation{
		Name:       opListApplicationRevisions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationRevisionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListApplicationRevisionsOutput{}
	req.Data = output
	return
}

// ListApplicationRevisions API operation for AWS CodeDeploy.
//
// Lists information about revisions for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ListApplicationRevisions for usage and error information.
//
// Returned Error Codes:
//   * ApplicationDoesNotExistException
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * InvalidSortByException
//   The column name to sort by is either not present or was specified in an invalid
//   format.
//
//   * InvalidSortOrderException
//   The sort order was specified in an invalid format.
//
//   * InvalidBucketNameFilterException
//   The bucket name either doesn't exist or was specified in an invalid format.
//
//   * InvalidKeyPrefixFilterException
//   The specified key prefix filter was specified in an invalid format.
//
//   * BucketNameFilterRequiredException
//   A bucket name is required, but was not provided.
//
//   * InvalidDeployedStateFilterException
//   The deployed state filter was specified in an invalid format.
//
//   * InvalidNextTokenException
//   The next token was specified in an invalid format.
//
func (c *CodeDeploy) ListApplicationRevisions(input *ListApplicationRevisionsInput) (*ListApplicationRevisionsOutput, error) {
	req, out := c.ListApplicationRevisionsRequest(input)
	err := req.Send()
	return out, err
}

// ListApplicationRevisionsPages iterates over the pages of a ListApplicationRevisions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplicationRevisions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApplicationRevisions operation.
//    pageNum := 0
//    err := client.ListApplicationRevisionsPages(params,
//        func(page *ListApplicationRevisionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeDeploy) ListApplicationRevisionsPages(input *ListApplicationRevisionsInput, fn func(p *ListApplicationRevisionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListApplicationRevisionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListApplicationRevisionsOutput), lastPage)
	})
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListApplications for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListApplications method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListApplicationsRequest method.
//    req, resp := client.ListApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListApplicationsOutput{}
	req.Data = output
	return
}

// ListApplications API operation for AWS CodeDeploy.
//
// Lists the applications registered with the applicable IAM user or AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ListApplications for usage and error information.
//
// Returned Error Codes:
//   * InvalidNextTokenException
//   The next token was specified in an invalid format.
//
func (c *CodeDeploy) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	err := req.Send()
	return out, err
}

// ListApplicationsPages iterates over the pages of a ListApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApplications operation.
//    pageNum := 0
//    err := client.ListApplicationsPages(params,
//        func(page *ListApplicationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeDeploy) ListApplicationsPages(input *ListApplicationsInput, fn func(p *ListApplicationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListApplicationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListApplicationsOutput), lastPage)
	})
}

const opListDeploymentConfigs = "ListDeploymentConfigs"

// ListDeploymentConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeploymentConfigs operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListDeploymentConfigs for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListDeploymentConfigs method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListDeploymentConfigsRequest method.
//    req, resp := client.ListDeploymentConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) ListDeploymentConfigsRequest(input *ListDeploymentConfigsInput) (req *request.Request, output *ListDeploymentConfigsOutput) {
	op := &request.Operation{
		Name:       opListDeploymentConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentConfigsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDeploymentConfigsOutput{}
	req.Data = output
	return
}

// ListDeploymentConfigs API operation for AWS CodeDeploy.
//
// Lists the deployment configurations with the applicable IAM user or AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ListDeploymentConfigs for usage and error information.
//
// Returned Error Codes:
//   * InvalidNextTokenException
//   The next token was specified in an invalid format.
//
func (c *CodeDeploy) ListDeploymentConfigs(input *ListDeploymentConfigsInput) (*ListDeploymentConfigsOutput, error) {
	req, out := c.ListDeploymentConfigsRequest(input)
	err := req.Send()
	return out, err
}

// ListDeploymentConfigsPages iterates over the pages of a ListDeploymentConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeploymentConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDeploymentConfigs operation.
//    pageNum := 0
//    err := client.ListDeploymentConfigsPages(params,
//        func(page *ListDeploymentConfigsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeDeploy) ListDeploymentConfigsPages(input *ListDeploymentConfigsInput, fn func(p *ListDeploymentConfigsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDeploymentConfigsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDeploymentConfigsOutput), lastPage)
	})
}

const opListDeploymentGroups = "ListDeploymentGroups"

// ListDeploymentGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeploymentGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListDeploymentGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListDeploymentGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListDeploymentGroupsRequest method.
//    req, resp := client.ListDeploymentGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) ListDeploymentGroupsRequest(input *ListDeploymentGroupsInput) (req *request.Request, output *ListDeploymentGroupsOutput) {
	op := &request.Operation{
		Name:       opListDeploymentGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDeploymentGroupsOutput{}
	req.Data = output
	return
}

// ListDeploymentGroups API operation for AWS CodeDeploy.
//
// Lists the deployment groups for an application registered with the applicable
// IAM user or AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ListDeploymentGroups for usage and error information.
//
// Returned Error Codes:
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * ApplicationDoesNotExistException
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * InvalidNextTokenException
//   The next token was specified in an invalid format.
//
func (c *CodeDeploy) ListDeploymentGroups(input *ListDeploymentGroupsInput) (*ListDeploymentGroupsOutput, error) {
	req, out := c.ListDeploymentGroupsRequest(input)
	err := req.Send()
	return out, err
}

// ListDeploymentGroupsPages iterates over the pages of a ListDeploymentGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeploymentGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDeploymentGroups operation.
//    pageNum := 0
//    err := client.ListDeploymentGroupsPages(params,
//        func(page *ListDeploymentGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeDeploy) ListDeploymentGroupsPages(input *ListDeploymentGroupsInput, fn func(p *ListDeploymentGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDeploymentGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDeploymentGroupsOutput), lastPage)
	})
}

const opListDeploymentInstances = "ListDeploymentInstances"

// ListDeploymentInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListDeploymentInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListDeploymentInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListDeploymentInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListDeploymentInstancesRequest method.
//    req, resp := client.ListDeploymentInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) ListDeploymentInstancesRequest(input *ListDeploymentInstancesInput) (req *request.Request, output *ListDeploymentInstancesOutput) {
	op := &request.Operation{
		Name:       opListDeploymentInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDeploymentInstancesOutput{}
	req.Data = output
	return
}

// ListDeploymentInstances API operation for AWS CodeDeploy.
//
// Lists the instance for a deployment associated with the applicable IAM user
// or AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ListDeploymentInstances for usage and error information.
//
// Returned Error Codes:
//   * DeploymentIdRequiredException
//   At least one deployment ID must be specified.
//
//   * DeploymentDoesNotExistException
//   The deployment does not exist with the applicable IAM user or AWS account.
//
//   * DeploymentNotStartedException
//   The specified deployment has not started.
//
//   * InvalidNextTokenException
//   The next token was specified in an invalid format.
//
//   * InvalidDeploymentIdException
//   At least one of the deployment IDs was specified in an invalid format.
//
//   * InvalidInstanceStatusException
//   The specified instance status does not exist.
//
func (c *CodeDeploy) ListDeploymentInstances(input *ListDeploymentInstancesInput) (*ListDeploymentInstancesOutput, error) {
	req, out := c.ListDeploymentInstancesRequest(input)
	err := req.Send()
	return out, err
}

// ListDeploymentInstancesPages iterates over the pages of a ListDeploymentInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeploymentInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDeploymentInstances operation.
//    pageNum := 0
//    err := client.ListDeploymentInstancesPages(params,
//        func(page *ListDeploymentInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeDeploy) ListDeploymentInstancesPages(input *ListDeploymentInstancesInput, fn func(p *ListDeploymentInstancesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDeploymentInstancesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDeploymentInstancesOutput), lastPage)
	})
}

const opListDeployments = "ListDeployments"

// ListDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeployments operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListDeployments for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListDeployments method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListDeploymentsRequest method.
//    req, resp := client.ListDeploymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) ListDeploymentsRequest(input *ListDeploymentsInput) (req *request.Request, output *ListDeploymentsOutput) {
	op := &request.Operation{
		Name:       opListDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDeploymentsOutput{}
	req.Data = output
	return
}

// ListDeployments API operation for AWS CodeDeploy.
//
// Lists the deployments in a deployment group for an application registered
// with the applicable IAM user or AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ListDeployments for usage and error information.
//
// Returned Error Codes:
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * ApplicationDoesNotExistException
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * InvalidDeploymentGroupNameException
//   The deployment group name was specified in an invalid format.
//
//   * DeploymentGroupDoesNotExistException
//   The named deployment group does not exist with the applicable IAM user or
//   AWS account.
//
//   * DeploymentGroupNameRequiredException
//   The deployment group name was not specified.
//
//   * InvalidTimeRangeException
//   The specified time range was specified in an invalid format.
//
//   * InvalidDeploymentStatusException
//   The specified deployment status doesn't exist or cannot be determined.
//
//   * InvalidNextTokenException
//   The next token was specified in an invalid format.
//
func (c *CodeDeploy) ListDeployments(input *ListDeploymentsInput) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	err := req.Send()
	return out, err
}

// ListDeploymentsPages iterates over the pages of a ListDeployments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeployments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDeployments operation.
//    pageNum := 0
//    err := client.ListDeploymentsPages(params,
//        func(page *ListDeploymentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeDeploy) ListDeploymentsPages(input *ListDeploymentsInput, fn func(p *ListDeploymentsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDeploymentsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDeploymentsOutput), lastPage)
	})
}

const opListOnPremisesInstances = "ListOnPremisesInstances"

// ListOnPremisesInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListOnPremisesInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListOnPremisesInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListOnPremisesInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListOnPremisesInstancesRequest method.
//    req, resp := client.ListOnPremisesInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) ListOnPremisesInstancesRequest(input *ListOnPremisesInstancesInput) (req *request.Request, output *ListOnPremisesInstancesOutput) {
	op := &request.Operation{
		Name:       opListOnPremisesInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListOnPremisesInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListOnPremisesInstancesOutput{}
	req.Data = output
	return
}

// ListOnPremisesInstances API operation for AWS CodeDeploy.
//
// Gets a list of names for one or more on-premises instances.
//
// Unless otherwise specified, both registered and deregistered on-premises
// instance names will be listed. To list only registered or deregistered on-premises
// instance names, use the registration status parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ListOnPremisesInstances for usage and error information.
//
// Returned Error Codes:
//   * InvalidRegistrationStatusException
//   The registration status was specified in an invalid format.
//
//   * InvalidTagFilterException
//   The specified tag filter was specified in an invalid format.
//
//   * InvalidNextTokenException
//   The next token was specified in an invalid format.
//
func (c *CodeDeploy) ListOnPremisesInstances(input *ListOnPremisesInstancesInput) (*ListOnPremisesInstancesOutput, error) {
	req, out := c.ListOnPremisesInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterApplicationRevision = "RegisterApplicationRevision"

// RegisterApplicationRevisionRequest generates a "aws/request.Request" representing the
// client's request for the RegisterApplicationRevision operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RegisterApplicationRevision for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RegisterApplicationRevision method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RegisterApplicationRevisionRequest method.
//    req, resp := client.RegisterApplicationRevisionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) RegisterApplicationRevisionRequest(input *RegisterApplicationRevisionInput) (req *request.Request, output *RegisterApplicationRevisionOutput) {
	op := &request.Operation{
		Name:       opRegisterApplicationRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterApplicationRevisionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RegisterApplicationRevisionOutput{}
	req.Data = output
	return
}

// RegisterApplicationRevision API operation for AWS CodeDeploy.
//
// Registers with AWS CodeDeploy a revision for the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation RegisterApplicationRevision for usage and error information.
//
// Returned Error Codes:
//   * ApplicationDoesNotExistException
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * DescriptionTooLongException
//   The description is too long.
//
//   * RevisionRequiredException
//   The revision ID was not specified.
//
//   * InvalidRevisionException
//   The revision was specified in an invalid format.
//
func (c *CodeDeploy) RegisterApplicationRevision(input *RegisterApplicationRevisionInput) (*RegisterApplicationRevisionOutput, error) {
	req, out := c.RegisterApplicationRevisionRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterOnPremisesInstance = "RegisterOnPremisesInstance"

// RegisterOnPremisesInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RegisterOnPremisesInstance operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RegisterOnPremisesInstance for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RegisterOnPremisesInstance method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RegisterOnPremisesInstanceRequest method.
//    req, resp := client.RegisterOnPremisesInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) RegisterOnPremisesInstanceRequest(input *RegisterOnPremisesInstanceInput) (req *request.Request, output *RegisterOnPremisesInstanceOutput) {
	op := &request.Operation{
		Name:       opRegisterOnPremisesInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterOnPremisesInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RegisterOnPremisesInstanceOutput{}
	req.Data = output
	return
}

// RegisterOnPremisesInstance API operation for AWS CodeDeploy.
//
// Registers an on-premises instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation RegisterOnPremisesInstance for usage and error information.
//
// Returned Error Codes:
//   * InstanceNameAlreadyRegisteredException
//   The specified on-premises instance name is already registered.
//
//   * IamUserArnAlreadyRegisteredException
//   The specified IAM user ARN is already registered with an on-premises instance.
//
//   * InstanceNameRequiredException
//   An on-premises instance name was not specified.
//
//   * IamUserArnRequiredException
//   An IAM user ARN was not specified.
//
//   * InvalidInstanceNameException
//   The specified on-premises instance name was specified in an invalid format.
//
//   * InvalidIamUserArnException
//   The IAM user ARN was specified in an invalid format.
//
func (c *CodeDeploy) RegisterOnPremisesInstance(input *RegisterOnPremisesInstanceInput) (*RegisterOnPremisesInstanceOutput, error) {
	req, out := c.RegisterOnPremisesInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTagsFromOnPremisesInstances = "RemoveTagsFromOnPremisesInstances"

// RemoveTagsFromOnPremisesInstancesRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromOnPremisesInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveTagsFromOnPremisesInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveTagsFromOnPremisesInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveTagsFromOnPremisesInstancesRequest method.
//    req, resp := client.RemoveTagsFromOnPremisesInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) RemoveTagsFromOnPremisesInstancesRequest(input *RemoveTagsFromOnPremisesInstancesInput) (req *request.Request, output *RemoveTagsFromOnPremisesInstancesOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromOnPremisesInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromOnPremisesInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RemoveTagsFromOnPremisesInstancesOutput{}
	req.Data = output
	return
}

// RemoveTagsFromOnPremisesInstances API operation for AWS CodeDeploy.
//
// Removes one or more tags from one or more on-premises instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation RemoveTagsFromOnPremisesInstances for usage and error information.
//
// Returned Error Codes:
//   * InstanceNameRequiredException
//   An on-premises instance name was not specified.
//
//   * TagRequiredException
//   A tag was not specified.
//
//   * InvalidTagException
//   The specified tag was specified in an invalid format.
//
//   * TagLimitExceededException
//   The maximum allowed number of tags was exceeded.
//
//   * InstanceLimitExceededException
//   The maximum number of allowed on-premises instances in a single call was
//   exceeded.
//
//   * InstanceNotRegisteredException
//   The specified on-premises instance is not registered.
//
func (c *CodeDeploy) RemoveTagsFromOnPremisesInstances(input *RemoveTagsFromOnPremisesInstancesInput) (*RemoveTagsFromOnPremisesInstancesOutput, error) {
	req, out := c.RemoveTagsFromOnPremisesInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opStopDeployment = "StopDeployment"

// StopDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the StopDeployment operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StopDeployment for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StopDeployment method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StopDeploymentRequest method.
//    req, resp := client.StopDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) StopDeploymentRequest(input *StopDeploymentInput) (req *request.Request, output *StopDeploymentOutput) {
	op := &request.Operation{
		Name:       opStopDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDeploymentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StopDeploymentOutput{}
	req.Data = output
	return
}

// StopDeployment API operation for AWS CodeDeploy.
//
// Attempts to stop an ongoing deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation StopDeployment for usage and error information.
//
// Returned Error Codes:
//   * DeploymentIdRequiredException
//   At least one deployment ID must be specified.
//
//   * DeploymentDoesNotExistException
//   The deployment does not exist with the applicable IAM user or AWS account.
//
//   * DeploymentAlreadyCompletedException
//   The deployment is already complete.
//
//   * InvalidDeploymentIdException
//   At least one of the deployment IDs was specified in an invalid format.
//
func (c *CodeDeploy) StopDeployment(input *StopDeploymentInput) (*StopDeploymentOutput, error) {
	req, out := c.StopDeploymentRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateApplication for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateApplication method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateApplicationRequest method.
//    req, resp := client.UpdateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateApplicationOutput{}
	req.Data = output
	return
}

// UpdateApplication API operation for AWS CodeDeploy.
//
// Changes the name of an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Codes:
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * ApplicationAlreadyExistsException
//   An application with the specified name already exists with the applicable
//   IAM user or AWS account.
//
//   * ApplicationDoesNotExistException
//   The application does not exist with the applicable IAM user or AWS account.
//
func (c *CodeDeploy) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDeploymentGroup = "UpdateDeploymentGroup"

// UpdateDeploymentGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDeploymentGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateDeploymentGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateDeploymentGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateDeploymentGroupRequest method.
//    req, resp := client.UpdateDeploymentGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CodeDeploy) UpdateDeploymentGroupRequest(input *UpdateDeploymentGroupInput) (req *request.Request, output *UpdateDeploymentGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateDeploymentGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeploymentGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateDeploymentGroupOutput{}
	req.Data = output
	return
}

// UpdateDeploymentGroup API operation for AWS CodeDeploy.
//
// Changes information about a deployment group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation UpdateDeploymentGroup for usage and error information.
//
// Returned Error Codes:
//   * ApplicationNameRequiredException
//   The minimum number of required application names was not specified.
//
//   * InvalidApplicationNameException
//   The application name was specified in an invalid format.
//
//   * ApplicationDoesNotExistException
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * InvalidDeploymentGroupNameException
//   The deployment group name was specified in an invalid format.
//
//   * DeploymentGroupAlreadyExistsException
//   A deployment group with the specified name already exists with the applicable
//   IAM user or AWS account.
//
//   * DeploymentGroupNameRequiredException
//   The deployment group name was not specified.
//
//   * DeploymentGroupDoesNotExistException
//   The named deployment group does not exist with the applicable IAM user or
//   AWS account.
//
//   * InvalidEC2TagException
//   The tag was specified in an invalid format.
//
//   * InvalidTagException
//   The specified tag was specified in an invalid format.
//
//   * InvalidAutoScalingGroupException
//   The Auto Scaling group was specified in an invalid format or does not exist.
//
//   * InvalidDeploymentConfigNameException
//   The deployment configuration name was specified in an invalid format.
//
//   * DeploymentConfigDoesNotExistException
//   The deployment configuration does not exist with the applicable IAM user
//   or AWS account.
//
//   * InvalidRoleException
//   The service role ARN was specified in an invalid format. Or, if an Auto Scaling
//   group was specified, the specified service role does not grant the appropriate
//   permissions to Auto Scaling.
//
//   * LifecycleHookLimitExceededException
//   The limit for lifecycle hooks was exceeded.
//
//   * InvalidTriggerConfigException
//   The trigger was specified in an invalid format.
//
//   * TriggerTargetsLimitExceededException
//   The maximum allowed number of triggers was exceeded.
//
//   * InvalidAlarmConfigException
//   The format of the alarm configuration is invalid. Possible causes include:
//
//      * The alarm list is null.
//
//      * The alarm object is null.
//
//      * The alarm name is empty or null or exceeds the 255 character limit.
//
//      * Two alarms with the same name have been specified.
//
//      * The alarm configuration is enabled but the alarm list is empty.
//
//   * AlarmsLimitExceededException
//   The maximum number of alarms for a deployment group (10) was exceeded.
//
//   * InvalidAutoRollbackConfigException
//   The automatic rollback configuration was specified in an invalid format.
//   For example, automatic rollback is enabled but an invalid triggering event
//   type or no event types were listed.
//
func (c *CodeDeploy) UpdateDeploymentGroup(input *UpdateDeploymentGroupInput) (*UpdateDeploymentGroupOutput, error) {
	req, out := c.UpdateDeploymentGroupRequest(input)
	err := req.Send()
	return out, err
}

// Represents the input of, and adds tags to, an on-premises instance operation.
type AddTagsToOnPremisesInstancesInput struct {
	_ struct{} `type:"structure"`

	// The names of the on-premises instances to which to add tags.
	//
	// InstanceNames is a required field
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The tag key-value pairs to add to the on-premises instances.
	//
	// Keys and values are both required. Keys cannot be null or empty strings.
	// Value-only tags are not allowed.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToOnPremisesInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToOnPremisesInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToOnPremisesInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToOnPremisesInstancesInput"}
	if s.InstanceNames == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceNames"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AddTagsToOnPremisesInstancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToOnPremisesInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToOnPremisesInstancesOutput) GoString() string {
	return s.String()
}

// Information about an alarm.
type Alarm struct {
	_ struct{} `type:"structure"`

	// The name of the alarm. Maximum length is 255 characters. Each alarm name
	// can be used only once in a list of alarms.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s Alarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Alarm) GoString() string {
	return s.String()
}

// Information about alarms associated with the deployment group.
type AlarmConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of alarms configured for the deployment group. A maximum of 10 alarms
	// can be added to a deployment group.
	Alarms []*Alarm `locationName:"alarms" type:"list"`

	// Indicates whether the alarm configuration is enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// Indicates whether a deployment should continue if information about the current
	// state of alarms cannot be retrieved from Amazon CloudWatch. The default value
	// is false.
	//
	//    * true: The deployment will proceed even if alarm status information can't
	//    be retrieved from Amazon CloudWatch.
	//
	//    * false: The deployment will stop if alarm status information can't be
	//    retrieved from Amazon CloudWatch.
	IgnorePollAlarmFailure *bool `locationName:"ignorePollAlarmFailure" type:"boolean"`
}

// String returns the string representation
func (s AlarmConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlarmConfiguration) GoString() string {
	return s.String()
}

// Information about an application.
type ApplicationInfo struct {
	_ struct{} `type:"structure"`

	// The application ID.
	ApplicationId *string `locationName:"applicationId" type:"string"`

	// The application name.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// The time at which the application was created.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"unix"`

	// True if the user has authenticated with GitHub for the specified application;
	// otherwise, false.
	LinkedToGitHub *bool `locationName:"linkedToGitHub" type:"boolean"`
}

// String returns the string representation
func (s ApplicationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationInfo) GoString() string {
	return s.String()
}

// Information about a configuration for automatically rolling back to a previous
// version of an application revision when a deployment doesn't complete successfully.
type AutoRollbackConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether a defined automatic rollback configuration is currently
	// enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The event type or types that trigger a rollback.
	Events []*string `locationName:"events" type:"list"`
}

// String returns the string representation
func (s AutoRollbackConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoRollbackConfiguration) GoString() string {
	return s.String()
}

// Information about an Auto Scaling group.
type AutoScalingGroup struct {
	_ struct{} `type:"structure"`

	// An Auto Scaling lifecycle event hook name.
	Hook *string `locationName:"hook" type:"string"`

	// The Auto Scaling group name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s AutoScalingGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingGroup) GoString() string {
	return s.String()
}

// Represents the input of a batch get application revisions operation.
type BatchGetApplicationRevisionsInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application about which to get revision information.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Information to get about the application revisions, including type and location.
	//
	// Revisions is a required field
	Revisions []*RevisionLocation `locationName:"revisions" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetApplicationRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetApplicationRevisionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetApplicationRevisionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetApplicationRevisionsInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.Revisions == nil {
		invalidParams.Add(request.NewErrParamRequired("Revisions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a batch get application revisions operation.
type BatchGetApplicationRevisionsOutput struct {
	_ struct{} `type:"structure"`

	// The name of the application that corresponds to the revisions.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// Information about errors that may have occurred during the API call.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// Additional information about the revisions, including the type and location.
	Revisions []*RevisionInfo `locationName:"revisions" type:"list"`
}

// String returns the string representation
func (s BatchGetApplicationRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetApplicationRevisionsOutput) GoString() string {
	return s.String()
}

// Represents the input of a batch get applications operation.
type BatchGetApplicationsInput struct {
	_ struct{} `type:"structure"`

	// A list of application names separated by spaces.
	ApplicationNames []*string `locationName:"applicationNames" type:"list"`
}

// String returns the string representation
func (s BatchGetApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetApplicationsInput) GoString() string {
	return s.String()
}

// Represents the output of a batch get applications operation.
type BatchGetApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the applications.
	ApplicationsInfo []*ApplicationInfo `locationName:"applicationsInfo" type:"list"`
}

// String returns the string representation
func (s BatchGetApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetApplicationsOutput) GoString() string {
	return s.String()
}

// Represents the input of a batch get deployment groups operation.
type BatchGetDeploymentGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// The deployment groups' names.
	//
	// DeploymentGroupNames is a required field
	DeploymentGroupNames []*string `locationName:"deploymentGroupNames" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetDeploymentGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDeploymentGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetDeploymentGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetDeploymentGroupsInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.DeploymentGroupNames == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentGroupNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a batch get deployment groups operation.
type BatchGetDeploymentGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deployment groups.
	DeploymentGroupsInfo []*DeploymentGroupInfo `locationName:"deploymentGroupsInfo" type:"list"`

	// Information about errors that may have occurred during the API call.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`
}

// String returns the string representation
func (s BatchGetDeploymentGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDeploymentGroupsOutput) GoString() string {
	return s.String()
}

// Represents the input of a batch get deployment instances operation.
type BatchGetDeploymentInstancesInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of a deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	// The unique IDs of instances in the deployment group.
	//
	// InstanceIds is a required field
	InstanceIds []*string `locationName:"instanceIds" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetDeploymentInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDeploymentInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetDeploymentInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetDeploymentInstancesInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.InstanceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a batch get deployment instance operation.
type BatchGetDeploymentInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Information about errors that may have occurred during the API call.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// Information about the instance.
	InstancesSummary []*InstanceSummary `locationName:"instancesSummary" type:"list"`
}

// String returns the string representation
func (s BatchGetDeploymentInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDeploymentInstancesOutput) GoString() string {
	return s.String()
}

// Represents the input of a batch get deployments operation.
type BatchGetDeploymentsInput struct {
	_ struct{} `type:"structure"`

	// A list of deployment IDs, separated by spaces.
	DeploymentIds []*string `locationName:"deploymentIds" type:"list"`
}

// String returns the string representation
func (s BatchGetDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDeploymentsInput) GoString() string {
	return s.String()
}

// Represents the output of a batch get deployments operation.
type BatchGetDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deployments.
	DeploymentsInfo []*DeploymentInfo `locationName:"deploymentsInfo" type:"list"`
}

// String returns the string representation
func (s BatchGetDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDeploymentsOutput) GoString() string {
	return s.String()
}

// Represents the input of a batch get on-premises instances operation.
type BatchGetOnPremisesInstancesInput struct {
	_ struct{} `type:"structure"`

	// The names of the on-premises instances about which to get information.
	InstanceNames []*string `locationName:"instanceNames" type:"list"`
}

// String returns the string representation
func (s BatchGetOnPremisesInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetOnPremisesInstancesInput) GoString() string {
	return s.String()
}

// Represents the output of a batch get on-premises instances operation.
type BatchGetOnPremisesInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the on-premises instances.
	InstanceInfos []*InstanceInfo `locationName:"instanceInfos" type:"list"`
}

// String returns the string representation
func (s BatchGetOnPremisesInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetOnPremisesInstancesOutput) GoString() string {
	return s.String()
}

// Represents the input of a create application operation.
type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application. This name must be unique with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a create application operation.
type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// A unique application ID.
	ApplicationId *string `locationName:"applicationId" type:"string"`
}

// String returns the string representation
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// Represents the input of a create deployment configuration operation.
type CreateDeploymentConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the deployment configuration to create.
	//
	// DeploymentConfigName is a required field
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string" required:"true"`

	// The minimum number of healthy instances that should be available at any time
	// during the deployment. There are two parameters expected in the input: type
	// and value.
	//
	// The type parameter takes either of the following values:
	//
	//    * HOST_COUNT: The value parameter represents the minimum number of healthy
	//    instances as an absolute value.
	//
	//    * FLEET_PERCENT: The value parameter represents the minimum number of
	//    healthy instances as a percentage of the total number of instances in
	//    the deployment. If you specify FLEET_PERCENT, at the start of the deployment,
	//    AWS CodeDeploy converts the percentage to the equivalent number of instance
	//    and rounds up fractional instances.
	//
	// The value parameter takes an integer.
	//
	// For example, to set a minimum of 95% healthy instance, specify a type of
	// FLEET_PERCENT and a value of 95.
	MinimumHealthyHosts *MinimumHealthyHosts `locationName:"minimumHealthyHosts" type:"structure"`
}

// String returns the string representation
func (s CreateDeploymentConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentConfigInput"}
	if s.DeploymentConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentConfigName"))
	}
	if s.DeploymentConfigName != nil && len(*s.DeploymentConfigName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentConfigName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a create deployment configuration operation.
type CreateDeploymentConfigOutput struct {
	_ struct{} `type:"structure"`

	// A unique deployment configuration ID.
	DeploymentConfigId *string `locationName:"deploymentConfigId" type:"string"`
}

// String returns the string representation
func (s CreateDeploymentConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentConfigOutput) GoString() string {
	return s.String()
}

// Represents the input of a create deployment group operation.
type CreateDeploymentGroupInput struct {
	_ struct{} `type:"structure"`

	// Information to add about Amazon CloudWatch alarms when the deployment group
	// is created.
	AlarmConfiguration *AlarmConfiguration `locationName:"alarmConfiguration" type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Configuration information for an automatic rollback that is added when a
	// deployment group is created.
	AutoRollbackConfiguration *AutoRollbackConfiguration `locationName:"autoRollbackConfiguration" type:"structure"`

	// A list of associated Auto Scaling groups.
	AutoScalingGroups []*string `locationName:"autoScalingGroups" type:"list"`

	// If specified, the deployment configuration name can be either one of the
	// predefined configurations provided with AWS CodeDeploy or a custom deployment
	// configuration that you create by calling the create deployment configuration
	// operation.
	//
	// CodeDeployDefault.OneAtATime is the default deployment configuration. It
	// is used if a configuration isn't specified for the deployment or the deployment
	// group.
	//
	// The predefined deployment configurations include the following:
	//
	//    * CodeDeployDefault.AllAtOnce attempts to deploy an application revision
	//    to as many instances as possible at once. The status of the overall deployment
	//    will be displayed as Succeeded if the application revision is deployed
	//    to one or more of the instances. The status of the overall deployment
	//    will be displayed as Failed if the application revision is not deployed
	//    to any of the instances. Using an example of nine instances, CodeDeployDefault.AllAtOnce
	//    will attempt to deploy to all nine instances at once. The overall deployment
	//    will succeed if deployment to even a single instance is successful; it
	//    will fail only if deployments to all nine instances fail.
	//
	//    * CodeDeployDefault.HalfAtATime deploys to up to half of the instances
	//    at a time (with fractions rounded down). The overall deployment succeeds
	//    if the application revision is deployed to at least half of the instances
	//    (with fractions rounded up); otherwise, the deployment fails. In the example
	//    of nine instances, it will deploy to up to four instances at a time. The
	//    overall deployment succeeds if deployment to five or more instances succeed;
	//    otherwise, the deployment fails. The deployment may be successfully deployed
	//    to some instances even if the overall deployment fails.
	//
	//    * CodeDeployDefault.OneAtATime deploys the application revision to only
	//    one instance at a time.
	//
	// For deployment groups that contain more than one instance:
	//
	// The overall deployment succeeds if the application revision is deployed to
	//    all of the instances. The exception to this rule is if deployment to the
	//    last instance fails, the overall deployment still succeeds. This is because
	//    AWS CodeDeploy allows only one instance at a time to be taken offline
	//    with the CodeDeployDefault.OneAtATime configuration.
	//
	// The overall deployment fails as soon as the application revision fails to
	//    be deployed to any but the last instance. The deployment may be successfully
	//    deployed to some instances even if the overall deployment fails.
	//
	// In an example using nine instances, it will deploy to one instance at a time.
	//    The overall deployment succeeds if deployment to the first eight instances
	//    is successful; the overall deployment fails if deployment to any of the
	//    first eight instances fails.
	//
	// For deployment groups that contain only one instance, the overall deployment
	//    is successful only if deployment to the single instance is successful
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// The name of a new deployment group for the specified application.
	//
	// DeploymentGroupName is a required field
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string" required:"true"`

	// The Amazon EC2 tags on which to filter.
	Ec2TagFilters []*EC2TagFilter `locationName:"ec2TagFilters" type:"list"`

	// The on-premises instance tags on which to filter.
	OnPremisesInstanceTagFilters []*TagFilter `locationName:"onPremisesInstanceTagFilters" type:"list"`

	// A service role ARN that allows AWS CodeDeploy to act on the user's behalf
	// when interacting with AWS services.
	//
	// ServiceRoleArn is a required field
	ServiceRoleArn *string `locationName:"serviceRoleArn" type:"string" required:"true"`

	// Information about triggers to create when the deployment group is created.
	// For examples, see Create a Trigger for an AWS CodeDeploy Event (http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html)
	// in the AWS CodeDeploy User Guide.
	TriggerConfigurations []*TriggerConfig `locationName:"triggerConfigurations" type:"list"`
}

// String returns the string representation
func (s CreateDeploymentGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentGroupInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.DeploymentConfigName != nil && len(*s.DeploymentConfigName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentConfigName", 1))
	}
	if s.DeploymentGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentGroupName"))
	}
	if s.DeploymentGroupName != nil && len(*s.DeploymentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentGroupName", 1))
	}
	if s.ServiceRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a create deployment group operation.
type CreateDeploymentGroupOutput struct {
	_ struct{} `type:"structure"`

	// A unique deployment group ID.
	DeploymentGroupId *string `locationName:"deploymentGroupId" type:"string"`
}

// String returns the string representation
func (s CreateDeploymentGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentGroupOutput) GoString() string {
	return s.String()
}

// Represents the input of a create deployment operation.
type CreateDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Configuration information for an automatic rollback that is added when a
	// deployment is created.
	AutoRollbackConfiguration *AutoRollbackConfiguration `locationName:"autoRollbackConfiguration" type:"structure"`

	// The name of a deployment configuration associated with the applicable IAM
	// user or AWS account.
	//
	// If not specified, the value configured in the deployment group will be used
	// as the default. If the deployment group does not have a deployment configuration
	// associated with it, then CodeDeployDefault.OneAtATime will be used by default.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// The name of the deployment group.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string"`

	// A comment about the deployment.
	Description *string `locationName:"description" type:"string"`

	// If set to true, then if the deployment causes the ApplicationStop deployment
	// lifecycle event to an instance to fail, the deployment to that instance will
	// not be considered to have failed at that point and will continue on to the
	// BeforeInstall deployment lifecycle event.
	//
	// If set to false or not specified, then if the deployment causes the ApplicationStop
	// deployment lifecycle event to fail to an instance, the deployment to that
	// instance will stop, and the deployment to that instance will be considered
	// to have failed.
	IgnoreApplicationStopFailures *bool `locationName:"ignoreApplicationStopFailures" type:"boolean"`

	// The type and location of the revision to deploy.
	Revision *RevisionLocation `locationName:"revision" type:"structure"`

	// Indicates whether to deploy to all instances or only to instances that are
	// not running the latest application revision.
	UpdateOutdatedInstancesOnly *bool `locationName:"updateOutdatedInstancesOnly" type:"boolean"`
}

// String returns the string representation
func (s CreateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.DeploymentConfigName != nil && len(*s.DeploymentConfigName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentConfigName", 1))
	}
	if s.DeploymentGroupName != nil && len(*s.DeploymentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a create deployment operation.
type CreateDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// A unique deployment ID.
	DeploymentId *string `locationName:"deploymentId" type:"string"`
}

// String returns the string representation
func (s CreateDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentOutput) GoString() string {
	return s.String()
}

// Represents the input of a delete application operation.
type DeleteApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

// Represents the input of a delete deployment configuration operation.
type DeleteDeploymentConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of a deployment configuration associated with the applicable IAM
	// user or AWS account.
	//
	// DeploymentConfigName is a required field
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeploymentConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeploymentConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeploymentConfigInput"}
	if s.DeploymentConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentConfigName"))
	}
	if s.DeploymentConfigName != nil && len(*s.DeploymentConfigName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentConfigName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteDeploymentConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeploymentConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentConfigOutput) GoString() string {
	return s.String()
}

// Represents the input of a delete deployment group operation.
type DeleteDeploymentGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// The name of an existing deployment group for the specified application.
	//
	// DeploymentGroupName is a required field
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeploymentGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeploymentGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeploymentGroupInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.DeploymentGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentGroupName"))
	}
	if s.DeploymentGroupName != nil && len(*s.DeploymentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a delete deployment group operation.
type DeleteDeploymentGroupOutput struct {
	_ struct{} `type:"structure"`

	// If the output contains no data, and the corresponding deployment group contained
	// at least one Auto Scaling group, AWS CodeDeploy successfully removed all
	// corresponding Auto Scaling lifecycle event hooks from the Amazon EC2 instances
	// in the Auto Scaling group. If the output contains data, AWS CodeDeploy could
	// not remove some Auto Scaling lifecycle event hooks from the Amazon EC2 instances
	// in the Auto Scaling group.
	HooksNotCleanedUp []*AutoScalingGroup `locationName:"hooksNotCleanedUp" type:"list"`
}

// String returns the string representation
func (s DeleteDeploymentGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentGroupOutput) GoString() string {
	return s.String()
}

// Information about a deployment configuration.
type DeploymentConfigInfo struct {
	_ struct{} `type:"structure"`

	// The time at which the deployment configuration was created.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"unix"`

	// The deployment configuration ID.
	DeploymentConfigId *string `locationName:"deploymentConfigId" type:"string"`

	// The deployment configuration name.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// Information about the number or percentage of minimum healthy instance.
	MinimumHealthyHosts *MinimumHealthyHosts `locationName:"minimumHealthyHosts" type:"structure"`
}

// String returns the string representation
func (s DeploymentConfigInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentConfigInfo) GoString() string {
	return s.String()
}

// Information about a deployment group.
type DeploymentGroupInfo struct {
	_ struct{} `type:"structure"`

	// A list of alarms associated with the deployment group.
	AlarmConfiguration *AlarmConfiguration `locationName:"alarmConfiguration" type:"structure"`

	// The application name.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// Information about the automatic rollback configuration associated with the
	// deployment group.
	AutoRollbackConfiguration *AutoRollbackConfiguration `locationName:"autoRollbackConfiguration" type:"structure"`

	// A list of associated Auto Scaling groups.
	AutoScalingGroups []*AutoScalingGroup `locationName:"autoScalingGroups" type:"list"`

	// The deployment configuration name.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// The deployment group ID.
	DeploymentGroupId *string `locationName:"deploymentGroupId" type:"string"`

	// The deployment group name.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string"`

	// The Amazon EC2 tags on which to filter.
	Ec2TagFilters []*EC2TagFilter `locationName:"ec2TagFilters" type:"list"`

	// The on-premises instance tags on which to filter.
	OnPremisesInstanceTagFilters []*TagFilter `locationName:"onPremisesInstanceTagFilters" type:"list"`

	// A service role ARN.
	ServiceRoleArn *string `locationName:"serviceRoleArn" type:"string"`

	// Information about the deployment group's target revision, including type
	// and location.
	TargetRevision *RevisionLocation `locationName:"targetRevision" type:"structure"`

	// Information about triggers associated with the deployment group.
	TriggerConfigurations []*TriggerConfig `locationName:"triggerConfigurations" type:"list"`
}

// String returns the string representation
func (s DeploymentGroupInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentGroupInfo) GoString() string {
	return s.String()
}

// Information about a deployment.
type DeploymentInfo struct {
	_ struct{} `type:"structure"`

	// The application name.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// Information about the automatic rollback configuration associated with the
	// deployment.
	AutoRollbackConfiguration *AutoRollbackConfiguration `locationName:"autoRollbackConfiguration" type:"structure"`

	// A timestamp indicating when the deployment was complete.
	CompleteTime *time.Time `locationName:"completeTime" type:"timestamp" timestampFormat:"unix"`

	// A timestamp indicating when the deployment was created.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"unix"`

	// The means by which the deployment was created:
	//
	//    * user: A user created the deployment.
	//
	//    * autoscaling: Auto Scaling created the deployment.
	//
	//    * codeDeployRollback: A rollback process created the deployment.
	Creator *string `locationName:"creator" type:"string" enum:"DeploymentCreator"`

	// The deployment configuration name.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// The deployment group name.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string"`

	// The deployment ID.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A summary of the deployment status of the instances in the deployment.
	DeploymentOverview *DeploymentOverview `locationName:"deploymentOverview" type:"structure"`

	// A comment about the deployment.
	Description *string `locationName:"description" type:"string"`

	// Information about any error associated with this deployment.
	ErrorInformation *ErrorInformation `locationName:"errorInformation" type:"structure"`

	// If true, then if the deployment causes the ApplicationStop deployment lifecycle
	// event to an instance to fail, the deployment to that instance will not be
	// considered to have failed at that point and will continue on to the BeforeInstall
	// deployment lifecycle event.
	//
	// If false or not specified, then if the deployment causes the ApplicationStop
	// deployment lifecycle event to an instance to fail, the deployment to that
	// instance will stop, and the deployment to that instance will be considered
	// to have failed.
	IgnoreApplicationStopFailures *bool `locationName:"ignoreApplicationStopFailures" type:"boolean"`

	// Information about the location of stored application artifacts and the service
	// from which to retrieve them.
	Revision *RevisionLocation `locationName:"revision" type:"structure"`

	// Information about a deployment rollback.
	RollbackInfo *RollbackInfo `locationName:"rollbackInfo" type:"structure"`

	// A timestamp indicating when the deployment was deployed to the deployment
	// group.
	//
	// In some cases, the reported value of the start time may be later than the
	// complete time. This is due to differences in the clock settings of back-end
	// servers that participate in the deployment process.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"unix"`

	// The current state of the deployment as a whole.
	Status *string `locationName:"status" type:"string" enum:"DeploymentStatus"`

	// Indicates whether only instances that are not running the latest application
	// revision are to be deployed to.
	UpdateOutdatedInstancesOnly *bool `locationName:"updateOutdatedInstancesOnly" type:"boolean"`
}

// String returns the string representation
func (s DeploymentInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentInfo) GoString() string {
	return s.String()
}

// Information about the deployment status of the instances in the deployment.
type DeploymentOverview struct {
	_ struct{} `type:"structure"`

	// The number of instances in the deployment in a failed state.
	Failed *int64 `type:"long"`

	// The number of instances in which the deployment is in progress.
	InProgress *int64 `type:"long"`

	// The number of instances in the deployment in a pending state.
	Pending *int64 `type:"long"`

	// The number of instances in the deployment in a skipped state.
	Skipped *int64 `type:"long"`

	// The number of instances in the deployment to which revisions have been successfully
	// deployed.
	Succeeded *int64 `type:"long"`
}

// String returns the string representation
func (s DeploymentOverview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentOverview) GoString() string {
	return s.String()
}

// Represents the input of a deregister on-premises instance operation.
type DeregisterOnPremisesInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the on-premises instance to deregister.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterOnPremisesInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterOnPremisesInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterOnPremisesInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterOnPremisesInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeregisterOnPremisesInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterOnPremisesInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterOnPremisesInstanceOutput) GoString() string {
	return s.String()
}

// Diagnostic information about executable scripts that are part of a deployment.
type Diagnostics struct {
	_ struct{} `type:"structure"`

	// The associated error code:
	//
	//    * Success: The specified script ran.
	//
	//    * ScriptMissing: The specified script was not found in the specified location.
	//
	//    * ScriptNotExecutable: The specified script is not a recognized executable
	//    file type.
	//
	//    * ScriptTimedOut: The specified script did not finish running in the specified
	//    time period.
	//
	//    * ScriptFailed: The specified script failed to run as expected.
	//
	//    * UnknownError: The specified script did not run for an unknown reason.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"LifecycleErrorCode"`

	// The last portion of the diagnostic log.
	//
	// If available, AWS CodeDeploy returns up to the last 4 KB of the diagnostic
	// log.
	LogTail *string `locationName:"logTail" type:"string"`

	// The message associated with the error.
	Message *string `locationName:"message" type:"string"`

	// The name of the script.
	ScriptName *string `locationName:"scriptName" type:"string"`
}

// String returns the string representation
func (s Diagnostics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Diagnostics) GoString() string {
	return s.String()
}

// Information about a tag filter.
type EC2TagFilter struct {
	_ struct{} `type:"structure"`

	// The tag filter key.
	Key *string `type:"string"`

	// The tag filter type:
	//
	//    * KEY_ONLY: Key only.
	//
	//    * VALUE_ONLY: Value only.
	//
	//    * KEY_AND_VALUE: Key and value.
	Type *string `type:"string" enum:"EC2TagFilterType"`

	// The tag filter value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s EC2TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2TagFilter) GoString() string {
	return s.String()
}

// Information about a deployment error.
type ErrorInformation struct {
	_ struct{} `type:"structure"`

	// The error code:
	//
	//    * APPLICATION_MISSING: The application was missing. This error code will
	//    most likely be raised if the application is deleted after the deployment
	//    is created but before it is started.
	//
	//    * DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error
	//    code will most likely be raised if the deployment group is deleted after
	//    the deployment is created but before it is started.
	//
	//    * HEALTH_CONSTRAINTS: The deployment failed on too many instances to be
	//    successfully deployed within the instance health constraints specified.
	//
	//    * HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed
	//    within the instance health constraints specified.
	//
	//    * IAM_ROLE_MISSING: The service role cannot be accessed.
	//
	//    * IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
	//
	//    * INTERNAL_ERROR: There was an internal error.
	//
	//    * NO_EC2_SUBSCRIPTION: The calling account is not subscribed to the Amazon
	//    EC2 service.
	//
	//    * NO_INSTANCES: No instance were specified, or no instance can be found.
	//
	//    * OVER_MAX_INSTANCES: The maximum number of instance was exceeded.
	//
	//    * THROTTLED: The operation was throttled because the calling account exceeded
	//    the throttling limits of one or more AWS services.
	//
	//    * TIMEOUT: The deployment has timed out.
	//
	//    * REVISION_MISSING: The revision ID was missing. This error code will
	//    most likely be raised if the revision is deleted after the deployment
	//    is created but before it is started.
	Code *string `locationName:"code" type:"string" enum:"ErrorCode"`

	// An accompanying error message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ErrorInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorInformation) GoString() string {
	return s.String()
}

// Information about an application revision.
type GenericRevisionInfo struct {
	_ struct{} `type:"structure"`

	// The deployment groups for which this is the current target revision.
	DeploymentGroups []*string `locationName:"deploymentGroups" type:"list"`

	// A comment about the revision.
	Description *string `locationName:"description" type:"string"`

	// When the revision was first used by AWS CodeDeploy.
	FirstUsedTime *time.Time `locationName:"firstUsedTime" type:"timestamp" timestampFormat:"unix"`

	// When the revision was last used by AWS CodeDeploy.
	LastUsedTime *time.Time `locationName:"lastUsedTime" type:"timestamp" timestampFormat:"unix"`

	// When the revision was registered with AWS CodeDeploy.
	RegisterTime *time.Time `locationName:"registerTime" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s GenericRevisionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenericRevisionInfo) GoString() string {
	return s.String()
}

// Represents the input of a get application operation.
type GetApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a get application operation.
type GetApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the application.
	Application *ApplicationInfo `locationName:"application" type:"structure"`
}

// String returns the string representation
func (s GetApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationOutput) GoString() string {
	return s.String()
}

// Represents the input of a get application revision operation.
type GetApplicationRevisionInput struct {
	_ struct{} `type:"structure"`

	// The name of the application that corresponds to the revision.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Information about the application revision to get, including type and location.
	//
	// Revision is a required field
	Revision *RevisionLocation `locationName:"revision" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApplicationRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationRevisionInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.Revision == nil {
		invalidParams.Add(request.NewErrParamRequired("Revision"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a get application revision operation.
type GetApplicationRevisionOutput struct {
	_ struct{} `type:"structure"`

	// The name of the application that corresponds to the revision.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// Additional information about the revision, including type and location.
	Revision *RevisionLocation `locationName:"revision" type:"structure"`

	// General information about the revision.
	RevisionInfo *GenericRevisionInfo `locationName:"revisionInfo" type:"structure"`
}

// String returns the string representation
func (s GetApplicationRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationRevisionOutput) GoString() string {
	return s.String()
}

// Represents the input of a get deployment configuration operation.
type GetDeploymentConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of a deployment configuration associated with the applicable IAM
	// user or AWS account.
	//
	// DeploymentConfigName is a required field
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeploymentConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentConfigInput"}
	if s.DeploymentConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentConfigName"))
	}
	if s.DeploymentConfigName != nil && len(*s.DeploymentConfigName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentConfigName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a get deployment configuration operation.
type GetDeploymentConfigOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deployment configuration.
	DeploymentConfigInfo *DeploymentConfigInfo `locationName:"deploymentConfigInfo" type:"structure"`
}

// String returns the string representation
func (s GetDeploymentConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentConfigOutput) GoString() string {
	return s.String()
}

// Represents the input of a get deployment group operation.
type GetDeploymentGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// The name of an existing deployment group for the specified application.
	//
	// DeploymentGroupName is a required field
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeploymentGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentGroupInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.DeploymentGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentGroupName"))
	}
	if s.DeploymentGroupName != nil && len(*s.DeploymentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a get deployment group operation.
type GetDeploymentGroupOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deployment group.
	DeploymentGroupInfo *DeploymentGroupInfo `locationName:"deploymentGroupInfo" type:"structure"`
}

// String returns the string representation
func (s GetDeploymentGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentGroupOutput) GoString() string {
	return s.String()
}

// Represents the input of a get deployment operation.
type GetDeploymentInput struct {
	_ struct{} `type:"structure"`

	// A deployment ID associated with the applicable IAM user or AWS account.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the input of a get deployment instance operation.
type GetDeploymentInstanceInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of a deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	// The unique ID of an instance in the deployment group.
	//
	// InstanceId is a required field
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeploymentInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentInstanceInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a get deployment instance operation.
type GetDeploymentInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the instance.
	InstanceSummary *InstanceSummary `locationName:"instanceSummary" type:"structure"`
}

// String returns the string representation
func (s GetDeploymentInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentInstanceOutput) GoString() string {
	return s.String()
}

// Represents the output of a get deployment operation.
type GetDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deployment.
	DeploymentInfo *DeploymentInfo `locationName:"deploymentInfo" type:"structure"`
}

// String returns the string representation
func (s GetDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentOutput) GoString() string {
	return s.String()
}

// Represents the input of a get on-premises instance operation.
type GetOnPremisesInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the on-premises instance about which to get information.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOnPremisesInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOnPremisesInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOnPremisesInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOnPremisesInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a get on-premises instance operation.
type GetOnPremisesInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the on-premises instance.
	InstanceInfo *InstanceInfo `locationName:"instanceInfo" type:"structure"`
}

// String returns the string representation
func (s GetOnPremisesInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOnPremisesInstanceOutput) GoString() string {
	return s.String()
}

// Information about the location of application artifacts stored in GitHub.
type GitHubLocation struct {
	_ struct{} `type:"structure"`

	// The SHA1 commit ID of the GitHub commit that represents the bundled artifacts
	// for the application revision.
	CommitId *string `locationName:"commitId" type:"string"`

	// The GitHub account and repository pair that stores a reference to the commit
	// that represents the bundled artifacts for the application revision.
	//
	// Specified as account/repository.
	Repository *string `locationName:"repository" type:"string"`
}

// String returns the string representation
func (s GitHubLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GitHubLocation) GoString() string {
	return s.String()
}

// Information about an on-premises instance.
type InstanceInfo struct {
	_ struct{} `type:"structure"`

	// If the on-premises instance was deregistered, the time at which the on-premises
	// instance was deregistered.
	DeregisterTime *time.Time `locationName:"deregisterTime" type:"timestamp" timestampFormat:"unix"`

	// The IAM user ARN associated with the on-premises instance.
	IamUserArn *string `locationName:"iamUserArn" type:"string"`

	// The ARN of the on-premises instance.
	InstanceArn *string `locationName:"instanceArn" type:"string"`

	// The name of the on-premises instance.
	InstanceName *string `locationName:"instanceName" type:"string"`

	// The time at which the on-premises instance was registered.
	RegisterTime *time.Time `locationName:"registerTime" type:"timestamp" timestampFormat:"unix"`

	// The tags currently associated with the on-premises instance.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s InstanceInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceInfo) GoString() string {
	return s.String()
}

// Information about an instance in a deployment.
type InstanceSummary struct {
	_ struct{} `type:"structure"`

	// The deployment ID.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The instance ID.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// A timestamp indicating when the instance information was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"unix"`

	// A list of lifecycle events for this instance.
	LifecycleEvents []*LifecycleEvent `locationName:"lifecycleEvents" type:"list"`

	// The deployment status for this instance:
	//
	//    * Pending: The deployment is pending for this instance.
	//
	//    * In Progress: The deployment is in progress for this instance.
	//
	//    * Succeeded: The deployment has succeeded for this instance.
	//
	//    * Failed: The deployment has failed for this instance.
	//
	//    * Skipped: The deployment has been skipped for this instance.
	//
	//    * Unknown: The deployment status is unknown for this instance.
	Status *string `locationName:"status" type:"string" enum:"InstanceStatus"`
}

// String returns the string representation
func (s InstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceSummary) GoString() string {
	return s.String()
}

// Information about a deployment lifecycle event.
type LifecycleEvent struct {
	_ struct{} `type:"structure"`

	// Diagnostic information about the deployment lifecycle event.
	Diagnostics *Diagnostics `locationName:"diagnostics" type:"structure"`

	// A timestamp indicating when the deployment lifecycle event ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"unix"`

	// The deployment lifecycle event name, such as ApplicationStop, BeforeInstall,
	// AfterInstall, ApplicationStart, or ValidateService.
	LifecycleEventName *string `locationName:"lifecycleEventName" type:"string"`

	// A timestamp indicating when the deployment lifecycle event started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"unix"`

	// The deployment lifecycle event status:
	//
	//    * Pending: The deployment lifecycle event is pending.
	//
	//    * InProgress: The deployment lifecycle event is in progress.
	//
	//    * Succeeded: The deployment lifecycle event ran successfully.
	//
	//    * Failed: The deployment lifecycle event has failed.
	//
	//    * Skipped: The deployment lifecycle event has been skipped.
	//
	//    * Unknown: The deployment lifecycle event is unknown.
	Status *string `locationName:"status" type:"string" enum:"LifecycleEventStatus"`
}

// String returns the string representation
func (s LifecycleEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleEvent) GoString() string {
	return s.String()
}

// Represents the input of a list application revisions operation.
type ListApplicationRevisionsInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Whether to list revisions based on whether the revision is the target revision
	// of an deployment group:
	//
	//    * include: List revisions that are target revisions of a deployment group.
	//
	//    * exclude: Do not list revisions that are target revisions of a deployment
	//    group.
	//
	//    * ignore: List all revisions.
	Deployed *string `locationName:"deployed" type:"string" enum:"ListStateFilterAction"`

	// An identifier returned from the previous list application revisions call.
	// It can be used to return the next set of applications in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An Amazon S3 bucket name to limit the search for revisions.
	//
	// If set to null, all of the user's buckets will be searched.
	S3Bucket *string `locationName:"s3Bucket" type:"string"`

	// A key prefix for the set of Amazon S3 objects to limit the search for revisions.
	S3KeyPrefix *string `locationName:"s3KeyPrefix" type:"string"`

	// The column name to use to sort the list results:
	//
	//    * registerTime: Sort by the time the revisions were registered with AWS
	//    CodeDeploy.
	//
	//    * firstUsedTime: Sort by the time the revisions were first used in a deployment.
	//
	//    * lastUsedTime: Sort by the time the revisions were last used in a deployment.
	//
	// If not specified or set to null, the results will be returned in an arbitrary
	// order.
	SortBy *string `locationName:"sortBy" type:"string" enum:"ApplicationRevisionSortBy"`

	// The order in which to sort the list results:
	//
	//    * ascending: ascending order.
	//
	//    * descending: descending order.
	//
	// If not specified, the results will be sorted in ascending order.
	//
	// If set to null, the results will be sorted in an arbitrary order.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s ListApplicationRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationRevisionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationRevisionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationRevisionsInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a list application revisions operation.
type ListApplicationRevisionsOutput struct {
	_ struct{} `type:"structure"`

	// If a large amount of information is returned, an identifier will also be
	// returned. It can be used in a subsequent list application revisions call
	// to return the next set of application revisions in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of locations that contain the matching revisions.
	Revisions []*RevisionLocation `locationName:"revisions" type:"list"`
}

// String returns the string representation
func (s ListApplicationRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationRevisionsOutput) GoString() string {
	return s.String()
}

// Represents the input of a list applications operation.
type ListApplicationsInput struct {
	_ struct{} `type:"structure"`

	// An identifier returned from the previous list applications call. It can be
	// used to return the next set of applications in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Represents the output of a list applications operation.
type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of application names.
	Applications []*string `locationName:"applications" type:"list"`

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent list applications call to return the next
	// set of applications, will also be returned. in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// Represents the input of a list deployment configurations operation.
type ListDeploymentConfigsInput struct {
	_ struct{} `type:"structure"`

	// An identifier returned from the previous list deployment configurations call.
	// It can be used to return the next set of deployment configurations in the
	// list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentConfigsInput) GoString() string {
	return s.String()
}

// Represents the output of a list deployment configurations operation.
type ListDeploymentConfigsOutput struct {
	_ struct{} `type:"structure"`

	// A list of deployment configurations, including built-in configurations such
	// as CodeDeployDefault.OneAtATime.
	DeploymentConfigsList []*string `locationName:"deploymentConfigsList" type:"list"`

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent list deployment configurations call to return
	// the next set of deployment configurations in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentConfigsOutput) GoString() string {
	return s.String()
}

// Represents the input of a list deployment groups operation.
type ListDeploymentGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// An identifier returned from the previous list deployment groups call. It
	// can be used to return the next set of deployment groups in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentGroupsInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a list deployment groups operation.
type ListDeploymentGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The application name.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// A list of corresponding deployment group names.
	DeploymentGroups []*string `locationName:"deploymentGroups" type:"list"`

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent list deployment groups call to return the
	// next set of deployment groups in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentGroupsOutput) GoString() string {
	return s.String()
}

// Represents the input of a list deployment instances operation.
type ListDeploymentInstancesInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of a deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	// A subset of instances to list by status:
	//
	//    * Pending: Include those instance with pending deployments.
	//
	//    * InProgress: Include those instance where deployments are still in progress.
	//
	//    * Succeeded: Include those instances with successful deployments.
	//
	//    * Failed: Include those instance with failed deployments.
	//
	//    * Skipped: Include those instance with skipped deployments.
	//
	//    * Unknown: Include those instance with deployments in an unknown state.
	InstanceStatusFilter []*string `locationName:"instanceStatusFilter" type:"list"`

	// An identifier returned from the previous list deployment instances call.
	// It can be used to return the next set of deployment instances in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentInstancesInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a list deployment instances operation.
type ListDeploymentInstancesOutput struct {
	_ struct{} `type:"structure"`

	// A list of instance IDs.
	InstancesList []*string `locationName:"instancesList" type:"list"`

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent list deployment instances call to return the
	// next set of deployment instances in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentInstancesOutput) GoString() string {
	return s.String()
}

// Represents the input of a list deployments operation.
type ListDeploymentsInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// A time range (start and end) for returning a subset of the list of deployments.
	CreateTimeRange *TimeRange `locationName:"createTimeRange" type:"structure"`

	// The name of an existing deployment group for the specified application.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string"`

	// A subset of deployments to list by status:
	//
	//    * Created: Include created deployments in the resulting list.
	//
	//    * Queued: Include queued deployments in the resulting list.
	//
	//    * In Progress: Include in-progress deployments in the resulting list.
	//
	//    * Succeeded: Include successful deployments in the resulting list.
	//
	//    * Failed: Include failed deployments in the resulting list.
	//
	//    * Stopped: Include stopped deployments in the resulting list.
	IncludeOnlyStatuses []*string `locationName:"includeOnlyStatuses" type:"list"`

	// An identifier returned from the previous list deployments call. It can be
	// used to return the next set of deployments in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentsInput"}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.DeploymentGroupName != nil && len(*s.DeploymentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a list deployments operation.
type ListDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of deployment IDs.
	Deployments []*string `locationName:"deployments" type:"list"`

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent list deployments call to return the next set
	// of deployments in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentsOutput) GoString() string {
	return s.String()
}

// Represents the input of a list on-premises instances operation.
type ListOnPremisesInstancesInput struct {
	_ struct{} `type:"structure"`

	// An identifier returned from the previous list on-premises instances call.
	// It can be used to return the next set of on-premises instances in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The registration status of the on-premises instances:
	//
	//    * Deregistered: Include deregistered on-premises instances in the resulting
	//    list.
	//
	//    * Registered: Include registered on-premises instances in the resulting
	//    list.
	RegistrationStatus *string `locationName:"registrationStatus" type:"string" enum:"RegistrationStatus"`

	// The on-premises instance tags that will be used to restrict the corresponding
	// on-premises instance names returned.
	TagFilters []*TagFilter `locationName:"tagFilters" type:"list"`
}

// String returns the string representation
func (s ListOnPremisesInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOnPremisesInstancesInput) GoString() string {
	return s.String()
}

// Represents the output of list on-premises instances operation.
type ListOnPremisesInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The list of matching on-premises instance names.
	InstanceNames []*string `locationName:"instanceNames" type:"list"`

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent list on-premises instances call to return
	// the next set of on-premises instances in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListOnPremisesInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOnPremisesInstancesOutput) GoString() string {
	return s.String()
}

// Information about minimum healthy instance.
type MinimumHealthyHosts struct {
	_ struct{} `type:"structure"`

	// The minimum healthy instance type:
	//
	//    * HOST_COUNT: The minimum number of healthy instance as an absolute value.
	//
	//    * FLEET_PERCENT: The minimum number of healthy instance as a percentage
	//    of the total number of instance in the deployment.
	//
	// In an example of nine instance, if a HOST_COUNT of six is specified, deploy
	// to up to three instances at a time. The deployment will be successful if
	// six or more instances are deployed to successfully; otherwise, the deployment
	// fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance
	// at a time. The deployment will be successful if four or more instance are
	// deployed to successfully; otherwise, the deployment fails.
	//
	// In a call to the get deployment configuration operation, CodeDeployDefault.OneAtATime
	// will return a minimum healthy instance type of MOST_CONCURRENCY and a value
	// of 1. This means a deployment to only one instance at a time. (You cannot
	// set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In
	// addition, with CodeDeployDefault.OneAtATime, AWS CodeDeploy will try to ensure
	// that all instances but one are kept in a healthy state during the deployment.
	// Although this allows one instance at a time to be taken offline for a new
	// deployment, it also means that if the deployment to the last instance fails,
	// the overall deployment still succeeds.
	Type *string `locationName:"type" type:"string" enum:"MinimumHealthyHostsType"`

	// The minimum healthy instance value.
	Value *int64 `locationName:"value" type:"integer"`
}

// String returns the string representation
func (s MinimumHealthyHosts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MinimumHealthyHosts) GoString() string {
	return s.String()
}

// Represents the input of a register application revision operation.
type RegisterApplicationRevisionInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// A comment about the revision.
	Description *string `locationName:"description" type:"string"`

	// Information about the application revision to register, including type and
	// location.
	//
	// Revision is a required field
	Revision *RevisionLocation `locationName:"revision" type:"structure" required:"true"`
}

// String returns the string representation
func (s RegisterApplicationRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterApplicationRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterApplicationRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterApplicationRevisionInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.Revision == nil {
		invalidParams.Add(request.NewErrParamRequired("Revision"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RegisterApplicationRevisionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterApplicationRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterApplicationRevisionOutput) GoString() string {
	return s.String()
}

// Represents the input of the register on-premises instance operation.
type RegisterOnPremisesInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM user to associate with the on-premises instance.
	//
	// IamUserArn is a required field
	IamUserArn *string `locationName:"iamUserArn" type:"string" required:"true"`

	// The name of the on-premises instance to register.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterOnPremisesInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterOnPremisesInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterOnPremisesInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterOnPremisesInstanceInput"}
	if s.IamUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamUserArn"))
	}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RegisterOnPremisesInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterOnPremisesInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterOnPremisesInstanceOutput) GoString() string {
	return s.String()
}

// Represents the input of a remove tags from on-premises instances operation.
type RemoveTagsFromOnPremisesInstancesInput struct {
	_ struct{} `type:"structure"`

	// The names of the on-premises instances from which to remove tags.
	//
	// InstanceNames is a required field
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The tag key-value pairs to remove from the on-premises instances.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromOnPremisesInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromOnPremisesInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromOnPremisesInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromOnPremisesInstancesInput"}
	if s.InstanceNames == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceNames"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RemoveTagsFromOnPremisesInstancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromOnPremisesInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromOnPremisesInstancesOutput) GoString() string {
	return s.String()
}

// Information about an application revision.
type RevisionInfo struct {
	_ struct{} `type:"structure"`

	// Information about an application revision.
	GenericRevisionInfo *GenericRevisionInfo `locationName:"genericRevisionInfo" type:"structure"`

	// Information about the location of an application revision.
	RevisionLocation *RevisionLocation `locationName:"revisionLocation" type:"structure"`
}

// String returns the string representation
func (s RevisionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevisionInfo) GoString() string {
	return s.String()
}

// Information about the location of an application revision.
type RevisionLocation struct {
	_ struct{} `type:"structure"`

	// Information about the location of application artifacts stored in GitHub.
	GitHubLocation *GitHubLocation `locationName:"gitHubLocation" type:"structure"`

	// The type of application revision:
	//
	//    * S3: An application revision stored in Amazon S3.
	//
	//    * GitHub: An application revision stored in GitHub.
	RevisionType *string `locationName:"revisionType" type:"string" enum:"RevisionLocationType"`

	// Information about the location of application artifacts stored in Amazon
	// S3.
	S3Location *S3Location `locationName:"s3Location" type:"structure"`
}

// String returns the string representation
func (s RevisionLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevisionLocation) GoString() string {
	return s.String()
}

// Information about a deployment rollback.
type RollbackInfo struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment rollback.
	RollbackDeploymentId *string `locationName:"rollbackDeploymentId" type:"string"`

	// Information describing the status of a deployment rollback; for example,
	// whether the deployment can't be rolled back, is in progress, failed, or succeeded.
	RollbackMessage *string `locationName:"rollbackMessage" type:"string"`

	// The deployment ID of the deployment that was underway and triggered a rollback
	// deployment because it failed or was stopped.
	RollbackTriggeringDeploymentId *string `locationName:"rollbackTriggeringDeploymentId" type:"string"`
}

// String returns the string representation
func (s RollbackInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RollbackInfo) GoString() string {
	return s.String()
}

// Information about the location of application artifacts stored in Amazon
// S3.
type S3Location struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket where the application revision is stored.
	Bucket *string `locationName:"bucket" type:"string"`

	// The file type of the application revision. Must be one of the following:
	//
	//    * tar: A tar archive file.
	//
	//    * tgz: A compressed tar archive file.
	//
	//    * zip: A zip archive file.
	BundleType *string `locationName:"bundleType" type:"string" enum:"BundleType"`

	// The ETag of the Amazon S3 object that represents the bundled artifacts for
	// the application revision.
	//
	// If the ETag is not specified as an input parameter, ETag validation of the
	// object will be skipped.
	ETag *string `locationName:"eTag" type:"string"`

	// The name of the Amazon S3 object that represents the bundled artifacts for
	// the application revision.
	Key *string `locationName:"key" type:"string"`

	// A specific version of the Amazon S3 object that represents the bundled artifacts
	// for the application revision.
	//
	// If the version is not specified, the system will use the most recent version
	// by default.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Location) GoString() string {
	return s.String()
}

// Represents the input of a stop deployment operation.
type StopDeploymentInput struct {
	_ struct{} `type:"structure"`

	// Indicates, when a deployment is stopped, whether instances that have been
	// updated should be rolled back to the previous version of the application
	// revision.
	AutoRollbackEnabled *bool `locationName:"autoRollbackEnabled" type:"boolean"`

	// The unique ID of a deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`
}

// String returns the string representation
func (s StopDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDeploymentInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a stop deployment operation.
type StopDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The status of the stop deployment operation:
	//
	//    * Pending: The stop operation is pending.
	//
	//    * Succeeded: The stop operation was successful.
	Status *string `locationName:"status" type:"string" enum:"StopStatus"`

	// An accompanying status message.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation
func (s StopDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDeploymentOutput) GoString() string {
	return s.String()
}

// Information about a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	Key *string `type:"string"`

	// The tag's value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Information about an on-premises instance tag filter.
type TagFilter struct {
	_ struct{} `type:"structure"`

	// The on-premises instance tag filter key.
	Key *string `type:"string"`

	// The on-premises instance tag filter type:
	//
	//    * KEY_ONLY: Key only.
	//
	//    * VALUE_ONLY: Value only.
	//
	//    * KEY_AND_VALUE: Key and value.
	Type *string `type:"string" enum:"TagFilterType"`

	// The on-premises instance tag filter value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilter) GoString() string {
	return s.String()
}

// Information about a time range.
type TimeRange struct {
	_ struct{} `type:"structure"`

	// The end time of the time range.
	//
	// Specify null to leave the end time open-ended.
	End *time.Time `locationName:"end" type:"timestamp" timestampFormat:"unix"`

	// The start time of the time range.
	//
	// Specify null to leave the start time open-ended.
	Start *time.Time `locationName:"start" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s TimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeRange) GoString() string {
	return s.String()
}

// Information about notification triggers for the deployment group.
type TriggerConfig struct {
	_ struct{} `type:"structure"`

	// The event type or types for which notifications are triggered.
	TriggerEvents []*string `locationName:"triggerEvents" type:"list"`

	// The name of the notification trigger.
	TriggerName *string `locationName:"triggerName" type:"string"`

	// The ARN of the Amazon Simple Notification Service topic through which notifications
	// about deployment or instance events are sent.
	TriggerTargetArn *string `locationName:"triggerTargetArn" type:"string"`
}

// String returns the string representation
func (s TriggerConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TriggerConfig) GoString() string {
	return s.String()
}

// Represents the input of an update application operation.
type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The current name of the application you want to change.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// The new name to give the application.
	NewApplicationName *string `locationName:"newApplicationName" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.NewApplicationName != nil && len(*s.NewApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

// Represents the input of an update deployment group operation.
type UpdateDeploymentGroupInput struct {
	_ struct{} `type:"structure"`

	// Information to add or change about Amazon CloudWatch alarms when the deployment
	// group is updated.
	AlarmConfiguration *AlarmConfiguration `locationName:"alarmConfiguration" type:"structure"`

	// The application name corresponding to the deployment group to update.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Information for an automatic rollback configuration that is added or changed
	// when a deployment group is updated.
	AutoRollbackConfiguration *AutoRollbackConfiguration `locationName:"autoRollbackConfiguration" type:"structure"`

	// The replacement list of Auto Scaling groups to be included in the deployment
	// group, if you want to change them. To keep the Auto Scaling groups, enter
	// their names. To remove Auto Scaling groups, do not enter any Auto Scaling
	// group names.
	AutoScalingGroups []*string `locationName:"autoScalingGroups" type:"list"`

	// The current name of the deployment group.
	//
	// CurrentDeploymentGroupName is a required field
	CurrentDeploymentGroupName *string `locationName:"currentDeploymentGroupName" min:"1" type:"string" required:"true"`

	// The replacement deployment configuration name to use, if you want to change
	// it.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// The replacement set of Amazon EC2 tags on which to filter, if you want to
	// change them. To keep the existing tags, enter their names. To remove tags,
	// do not enter any tag names.
	Ec2TagFilters []*EC2TagFilter `locationName:"ec2TagFilters" type:"list"`

	// The new name of the deployment group, if you want to change it.
	NewDeploymentGroupName *string `locationName:"newDeploymentGroupName" min:"1" type:"string"`

	// The replacement set of on-premises instance tags on which to filter, if you
	// want to change them. To keep the existing tags, enter their names. To remove
	// tags, do not enter any tag names.
	OnPremisesInstanceTagFilters []*TagFilter `locationName:"onPremisesInstanceTagFilters" type:"list"`

	// A replacement ARN for the service role, if you want to change it.
	ServiceRoleArn *string `locationName:"serviceRoleArn" type:"string"`

	// Information about triggers to change when the deployment group is updated.
	// For examples, see Modify Triggers in an AWS CodeDeploy Deployment Group (http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html)
	// in the AWS CodeDeploy User Guide.
	TriggerConfigurations []*TriggerConfig `locationName:"triggerConfigurations" type:"list"`
}

// String returns the string representation
func (s UpdateDeploymentGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeploymentGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeploymentGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeploymentGroupInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentDeploymentGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentDeploymentGroupName"))
	}
	if s.CurrentDeploymentGroupName != nil && len(*s.CurrentDeploymentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CurrentDeploymentGroupName", 1))
	}
	if s.DeploymentConfigName != nil && len(*s.DeploymentConfigName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentConfigName", 1))
	}
	if s.NewDeploymentGroupName != nil && len(*s.NewDeploymentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewDeploymentGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of an update deployment group operation.
type UpdateDeploymentGroupOutput struct {
	_ struct{} `type:"structure"`

	// If the output contains no data, and the corresponding deployment group contained
	// at least one Auto Scaling group, AWS CodeDeploy successfully removed all
	// corresponding Auto Scaling lifecycle event hooks from the AWS account. If
	// the output contains data, AWS CodeDeploy could not remove some Auto Scaling
	// lifecycle event hooks from the AWS account.
	HooksNotCleanedUp []*AutoScalingGroup `locationName:"hooksNotCleanedUp" type:"list"`
}

// String returns the string representation
func (s UpdateDeploymentGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeploymentGroupOutput) GoString() string {
	return s.String()
}

const (
	// ApplicationRevisionSortByRegisterTime is a ApplicationRevisionSortBy enum value
	ApplicationRevisionSortByRegisterTime = "registerTime"

	// ApplicationRevisionSortByFirstUsedTime is a ApplicationRevisionSortBy enum value
	ApplicationRevisionSortByFirstUsedTime = "firstUsedTime"

	// ApplicationRevisionSortByLastUsedTime is a ApplicationRevisionSortBy enum value
	ApplicationRevisionSortByLastUsedTime = "lastUsedTime"
)

const (
	// AutoRollbackEventDeploymentFailure is a AutoRollbackEvent enum value
	AutoRollbackEventDeploymentFailure = "DEPLOYMENT_FAILURE"

	// AutoRollbackEventDeploymentStopOnAlarm is a AutoRollbackEvent enum value
	AutoRollbackEventDeploymentStopOnAlarm = "DEPLOYMENT_STOP_ON_ALARM"

	// AutoRollbackEventDeploymentStopOnRequest is a AutoRollbackEvent enum value
	AutoRollbackEventDeploymentStopOnRequest = "DEPLOYMENT_STOP_ON_REQUEST"
)

const (
	// BundleTypeTar is a BundleType enum value
	BundleTypeTar = "tar"

	// BundleTypeTgz is a BundleType enum value
	BundleTypeTgz = "tgz"

	// BundleTypeZip is a BundleType enum value
	BundleTypeZip = "zip"
)

const (
	// DeploymentCreatorUser is a DeploymentCreator enum value
	DeploymentCreatorUser = "user"

	// DeploymentCreatorAutoscaling is a DeploymentCreator enum value
	DeploymentCreatorAutoscaling = "autoscaling"

	// DeploymentCreatorCodeDeployRollback is a DeploymentCreator enum value
	DeploymentCreatorCodeDeployRollback = "codeDeployRollback"
)

const (
	// DeploymentStatusCreated is a DeploymentStatus enum value
	DeploymentStatusCreated = "Created"

	// DeploymentStatusQueued is a DeploymentStatus enum value
	DeploymentStatusQueued = "Queued"

	// DeploymentStatusInProgress is a DeploymentStatus enum value
	DeploymentStatusInProgress = "InProgress"

	// DeploymentStatusSucceeded is a DeploymentStatus enum value
	DeploymentStatusSucceeded = "Succeeded"

	// DeploymentStatusFailed is a DeploymentStatus enum value
	DeploymentStatusFailed = "Failed"

	// DeploymentStatusStopped is a DeploymentStatus enum value
	DeploymentStatusStopped = "Stopped"
)

const (
	// EC2TagFilterTypeKeyOnly is a EC2TagFilterType enum value
	EC2TagFilterTypeKeyOnly = "KEY_ONLY"

	// EC2TagFilterTypeValueOnly is a EC2TagFilterType enum value
	EC2TagFilterTypeValueOnly = "VALUE_ONLY"

	// EC2TagFilterTypeKeyAndValue is a EC2TagFilterType enum value
	EC2TagFilterTypeKeyAndValue = "KEY_AND_VALUE"
)

const (
	// ErrorCodeDeploymentGroupMissing is a ErrorCode enum value
	ErrorCodeDeploymentGroupMissing = "DEPLOYMENT_GROUP_MISSING"

	// ErrorCodeApplicationMissing is a ErrorCode enum value
	ErrorCodeApplicationMissing = "APPLICATION_MISSING"

	// ErrorCodeRevisionMissing is a ErrorCode enum value
	ErrorCodeRevisionMissing = "REVISION_MISSING"

	// ErrorCodeIamRoleMissing is a ErrorCode enum value
	ErrorCodeIamRoleMissing = "IAM_ROLE_MISSING"

	// ErrorCodeIamRolePermissions is a ErrorCode enum value
	ErrorCodeIamRolePermissions = "IAM_ROLE_PERMISSIONS"

	// ErrorCodeNoEc2Subscription is a ErrorCode enum value
	ErrorCodeNoEc2Subscription = "NO_EC2_SUBSCRIPTION"

	// ErrorCodeOverMaxInstances is a ErrorCode enum value
	ErrorCodeOverMaxInstances = "OVER_MAX_INSTANCES"

	// ErrorCodeNoInstances is a ErrorCode enum value
	ErrorCodeNoInstances = "NO_INSTANCES"

	// ErrorCodeTimeout is a ErrorCode enum value
	ErrorCodeTimeout = "TIMEOUT"

	// ErrorCodeHealthConstraintsInvalid is a ErrorCode enum value
	ErrorCodeHealthConstraintsInvalid = "HEALTH_CONSTRAINTS_INVALID"

	// ErrorCodeHealthConstraints is a ErrorCode enum value
	ErrorCodeHealthConstraints = "HEALTH_CONSTRAINTS"

	// ErrorCodeInternalError is a ErrorCode enum value
	ErrorCodeInternalError = "INTERNAL_ERROR"

	// ErrorCodeThrottled is a ErrorCode enum value
	ErrorCodeThrottled = "THROTTLED"

	// ErrorCodeAlarmActive is a ErrorCode enum value
	ErrorCodeAlarmActive = "ALARM_ACTIVE"

	// ErrorCodeAgentIssue is a ErrorCode enum value
	ErrorCodeAgentIssue = "AGENT_ISSUE"

	// ErrorCodeAutoScalingIamRolePermissions is a ErrorCode enum value
	ErrorCodeAutoScalingIamRolePermissions = "AUTO_SCALING_IAM_ROLE_PERMISSIONS"

	// ErrorCodeAutoScalingConfiguration is a ErrorCode enum value
	ErrorCodeAutoScalingConfiguration = "AUTO_SCALING_CONFIGURATION"

	// ErrorCodeManualStop is a ErrorCode enum value
	ErrorCodeManualStop = "MANUAL_STOP"
)

const (
	// InstanceStatusPending is a InstanceStatus enum value
	InstanceStatusPending = "Pending"

	// InstanceStatusInProgress is a InstanceStatus enum value
	InstanceStatusInProgress = "InProgress"

	// InstanceStatusSucceeded is a InstanceStatus enum value
	InstanceStatusSucceeded = "Succeeded"

	// InstanceStatusFailed is a InstanceStatus enum value
	InstanceStatusFailed = "Failed"

	// InstanceStatusSkipped is a InstanceStatus enum value
	InstanceStatusSkipped = "Skipped"

	// InstanceStatusUnknown is a InstanceStatus enum value
	InstanceStatusUnknown = "Unknown"
)

const (
	// LifecycleErrorCodeSuccess is a LifecycleErrorCode enum value
	LifecycleErrorCodeSuccess = "Success"

	// LifecycleErrorCodeScriptMissing is a LifecycleErrorCode enum value
	LifecycleErrorCodeScriptMissing = "ScriptMissing"

	// LifecycleErrorCodeScriptNotExecutable is a LifecycleErrorCode enum value
	LifecycleErrorCodeScriptNotExecutable = "ScriptNotExecutable"

	// LifecycleErrorCodeScriptTimedOut is a LifecycleErrorCode enum value
	LifecycleErrorCodeScriptTimedOut = "ScriptTimedOut"

	// LifecycleErrorCodeScriptFailed is a LifecycleErrorCode enum value
	LifecycleErrorCodeScriptFailed = "ScriptFailed"

	// LifecycleErrorCodeUnknownError is a LifecycleErrorCode enum value
	LifecycleErrorCodeUnknownError = "UnknownError"
)

const (
	// LifecycleEventStatusPending is a LifecycleEventStatus enum value
	LifecycleEventStatusPending = "Pending"

	// LifecycleEventStatusInProgress is a LifecycleEventStatus enum value
	LifecycleEventStatusInProgress = "InProgress"

	// LifecycleEventStatusSucceeded is a LifecycleEventStatus enum value
	LifecycleEventStatusSucceeded = "Succeeded"

	// LifecycleEventStatusFailed is a LifecycleEventStatus enum value
	LifecycleEventStatusFailed = "Failed"

	// LifecycleEventStatusSkipped is a LifecycleEventStatus enum value
	LifecycleEventStatusSkipped = "Skipped"

	// LifecycleEventStatusUnknown is a LifecycleEventStatus enum value
	LifecycleEventStatusUnknown = "Unknown"
)

const (
	// ListStateFilterActionInclude is a ListStateFilterAction enum value
	ListStateFilterActionInclude = "include"

	// ListStateFilterActionExclude is a ListStateFilterAction enum value
	ListStateFilterActionExclude = "exclude"

	// ListStateFilterActionIgnore is a ListStateFilterAction enum value
	ListStateFilterActionIgnore = "ignore"
)

const (
	// MinimumHealthyHostsTypeHostCount is a MinimumHealthyHostsType enum value
	MinimumHealthyHostsTypeHostCount = "HOST_COUNT"

	// MinimumHealthyHostsTypeFleetPercent is a MinimumHealthyHostsType enum value
	MinimumHealthyHostsTypeFleetPercent = "FLEET_PERCENT"
)

const (
	// RegistrationStatusRegistered is a RegistrationStatus enum value
	RegistrationStatusRegistered = "Registered"

	// RegistrationStatusDeregistered is a RegistrationStatus enum value
	RegistrationStatusDeregistered = "Deregistered"
)

const (
	// RevisionLocationTypeS3 is a RevisionLocationType enum value
	RevisionLocationTypeS3 = "S3"

	// RevisionLocationTypeGitHub is a RevisionLocationType enum value
	RevisionLocationTypeGitHub = "GitHub"
)

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ascending"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "descending"
)

const (
	// StopStatusPending is a StopStatus enum value
	StopStatusPending = "Pending"

	// StopStatusSucceeded is a StopStatus enum value
	StopStatusSucceeded = "Succeeded"
)

const (
	// TagFilterTypeKeyOnly is a TagFilterType enum value
	TagFilterTypeKeyOnly = "KEY_ONLY"

	// TagFilterTypeValueOnly is a TagFilterType enum value
	TagFilterTypeValueOnly = "VALUE_ONLY"

	// TagFilterTypeKeyAndValue is a TagFilterType enum value
	TagFilterTypeKeyAndValue = "KEY_AND_VALUE"
)

const (
	// TriggerEventTypeDeploymentStart is a TriggerEventType enum value
	TriggerEventTypeDeploymentStart = "DeploymentStart"

	// TriggerEventTypeDeploymentSuccess is a TriggerEventType enum value
	TriggerEventTypeDeploymentSuccess = "DeploymentSuccess"

	// TriggerEventTypeDeploymentFailure is a TriggerEventType enum value
	TriggerEventTypeDeploymentFailure = "DeploymentFailure"

	// TriggerEventTypeDeploymentStop is a TriggerEventType enum value
	TriggerEventTypeDeploymentStop = "DeploymentStop"

	// TriggerEventTypeDeploymentRollback is a TriggerEventType enum value
	TriggerEventTypeDeploymentRollback = "DeploymentRollback"

	// TriggerEventTypeInstanceStart is a TriggerEventType enum value
	TriggerEventTypeInstanceStart = "InstanceStart"

	// TriggerEventTypeInstanceSuccess is a TriggerEventType enum value
	TriggerEventTypeInstanceSuccess = "InstanceSuccess"

	// TriggerEventTypeInstanceFailure is a TriggerEventType enum value
	TriggerEventTypeInstanceFailure = "InstanceFailure"
)
