// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing bot recommendation request.
func (c *Client) UpdateBotRecommendation(ctx context.Context, params *UpdateBotRecommendationInput, optFns ...func(*Options)) (*UpdateBotRecommendationOutput, error) {
	if params == nil {
		params = &UpdateBotRecommendationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateBotRecommendation", params, optFns, c.addOperationUpdateBotRecommendationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateBotRecommendationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateBotRecommendationInput struct {

	// The unique identifier of the bot containing the bot recommendation to be
	// updated.
	//
	// This member is required.
	BotId *string

	// The unique identifier of the bot recommendation to be updated.
	//
	// This member is required.
	BotRecommendationId *string

	// The version of the bot containing the bot recommendation to be updated.
	//
	// This member is required.
	BotVersion *string

	// The object representing the passwords that will be used to encrypt the data
	// related to the bot recommendation results, as well as the KMS key ARN used to
	// encrypt the associated metadata.
	//
	// This member is required.
	EncryptionSetting *types.EncryptionSetting

	// The identifier of the language and locale of the bot recommendation to update.
	// The string must match one of the supported locales. For more information, see [Supported languages]
	//
	// [Supported languages]: https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html
	//
	// This member is required.
	LocaleId *string

	noSmithyDocumentSerde
}

type UpdateBotRecommendationOutput struct {

	// The unique identifier of the bot containing the bot recommendation that has
	// been updated.
	BotId *string

	// The unique identifier of the bot recommendation to be updated.
	BotRecommendationId *string

	// The status of the bot recommendation.
	//
	// If the status is Failed, then the reasons for the failure are listed in the
	// failureReasons field.
	BotRecommendationStatus types.BotRecommendationStatus

	// The version of the bot containing the bot recommendation that has been updated.
	BotVersion *string

	// A timestamp of the date and time that the bot recommendation was created.
	CreationDateTime *time.Time

	// The object representing the passwords that were used to encrypt the data
	// related to the bot recommendation results, as well as the KMS key ARN used to
	// encrypt the associated metadata.
	EncryptionSetting *types.EncryptionSetting

	// A timestamp of the date and time that the bot recommendation was last updated.
	LastUpdatedDateTime *time.Time

	// The identifier of the language and locale of the bot recommendation to update.
	// The string must match one of the supported locales. For more information, see [Supported languages]
	//
	// [Supported languages]: https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html
	LocaleId *string

	// The object representing the Amazon S3 bucket containing the transcript, as well
	// as the associated metadata.
	TranscriptSourceSetting *types.TranscriptSourceSetting

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateBotRecommendationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateBotRecommendation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateBotRecommendation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateBotRecommendation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateBotRecommendationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateBotRecommendation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateBotRecommendation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateBotRecommendation",
	}
}
