// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets a list of recommended intents provided by the bot recommendation that you
// can use in your bot. Intents in the response are ordered by relevance.
func (c *Client) ListRecommendedIntents(ctx context.Context, params *ListRecommendedIntentsInput, optFns ...func(*Options)) (*ListRecommendedIntentsOutput, error) {
	if params == nil {
		params = &ListRecommendedIntentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRecommendedIntents", params, optFns, c.addOperationListRecommendedIntentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRecommendedIntentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRecommendedIntentsInput struct {

	// The unique identifier of the bot associated with the recommended intents.
	//
	// This member is required.
	BotId *string

	// The identifier of the bot recommendation that contains the recommended intents.
	//
	// This member is required.
	BotRecommendationId *string

	// The version of the bot that contains the recommended intents.
	//
	// This member is required.
	BotVersion *string

	// The identifier of the language and locale of the recommended intents.
	//
	// This member is required.
	LocaleId *string

	// The maximum number of bot recommendations to return in each page of results. If
	// there are fewer results than the max page size, only the actual number of
	// results are returned.
	MaxResults *int32

	// If the response from the ListRecommendedIntents operation contains more results
	// than specified in the maxResults parameter, a token is returned in the response.
	// Use that token in the nextToken parameter to return the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRecommendedIntentsOutput struct {

	// The unique identifier of the bot associated with the recommended intent.
	BotId *string

	// The identifier of the bot recommendation that contains the recommended intent.
	BotRecommendationId *string

	// The version of the bot that contains the intent.
	BotVersion *string

	// The identifier of the language and locale of the intents to list. The string
	// must match one of the supported locales. For more information, see [Supported languages].
	//
	// [Supported languages]: https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html
	LocaleId *string

	// A token that indicates whether there are more results to return in a response
	// to the ListRecommendedIntents operation. If the nextToken field is present, you
	// send the contents as the nextToken parameter of a ListRecommendedIntents
	// operation request to get the next page of results.
	NextToken *string

	// Summary information for the intents that meet the filter criteria specified in
	// the request. The length of the list is specified in the maxResults parameter of
	// the request. If there are more intents available, the nextToken field contains a
	// token to get the next page of results.
	SummaryList []types.RecommendedIntentSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRecommendedIntentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRecommendedIntents{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRecommendedIntents{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRecommendedIntents"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListRecommendedIntentsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRecommendedIntents(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListRecommendedIntentsPaginatorOptions is the paginator options for
// ListRecommendedIntents
type ListRecommendedIntentsPaginatorOptions struct {
	// The maximum number of bot recommendations to return in each page of results. If
	// there are fewer results than the max page size, only the actual number of
	// results are returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRecommendedIntentsPaginator is a paginator for ListRecommendedIntents
type ListRecommendedIntentsPaginator struct {
	options   ListRecommendedIntentsPaginatorOptions
	client    ListRecommendedIntentsAPIClient
	params    *ListRecommendedIntentsInput
	nextToken *string
	firstPage bool
}

// NewListRecommendedIntentsPaginator returns a new ListRecommendedIntentsPaginator
func NewListRecommendedIntentsPaginator(client ListRecommendedIntentsAPIClient, params *ListRecommendedIntentsInput, optFns ...func(*ListRecommendedIntentsPaginatorOptions)) *ListRecommendedIntentsPaginator {
	if params == nil {
		params = &ListRecommendedIntentsInput{}
	}

	options := ListRecommendedIntentsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRecommendedIntentsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRecommendedIntentsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRecommendedIntents page.
func (p *ListRecommendedIntentsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRecommendedIntentsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRecommendedIntents(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRecommendedIntentsAPIClient is a client that implements the
// ListRecommendedIntents operation.
type ListRecommendedIntentsAPIClient interface {
	ListRecommendedIntents(context.Context, *ListRecommendedIntentsInput, ...func(*Options)) (*ListRecommendedIntentsOutput, error)
}

var _ ListRecommendedIntentsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRecommendedIntents(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRecommendedIntents",
	}
}
