// Code generated by smithy-go-codegen DO NOT EDIT.

package keyspaces

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/keyspaces/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns auto scaling related settings of the specified table in JSON format. If
// the table is a multi-Region table, the Amazon Web Services Region specific auto
// scaling settings of the table are included. Amazon Keyspaces auto scaling helps
// you provision throughput capacity for variable workloads efficiently by
// increasing and decreasing your table's read and write capacity automatically in
// response to application traffic. For more information, see Managing throughput
// capacity automatically with Amazon Keyspaces auto scaling (https://docs.aws.amazon.com/keyspaces/latest/devguide/autoscaling.html)
// in the Amazon Keyspaces Developer Guide. GetTableAutoScalingSettings can't be
// used as an action in an IAM policy. To define permissions for
// GetTableAutoScalingSettings , you must allow the following two actions in the
// IAM policy statement's Action element:
//   - application-autoscaling:DescribeScalableTargets
//   - application-autoscaling:DescribeScalingPolicies
func (c *Client) GetTableAutoScalingSettings(ctx context.Context, params *GetTableAutoScalingSettingsInput, optFns ...func(*Options)) (*GetTableAutoScalingSettingsOutput, error) {
	if params == nil {
		params = &GetTableAutoScalingSettingsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetTableAutoScalingSettings", params, optFns, c.addOperationGetTableAutoScalingSettingsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetTableAutoScalingSettingsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetTableAutoScalingSettingsInput struct {

	// The name of the keyspace.
	//
	// This member is required.
	KeyspaceName *string

	// The name of the table.
	//
	// This member is required.
	TableName *string

	noSmithyDocumentSerde
}

type GetTableAutoScalingSettingsOutput struct {

	// The name of the keyspace.
	//
	// This member is required.
	KeyspaceName *string

	// The Amazon Resource Name (ARN) of the table.
	//
	// This member is required.
	ResourceArn *string

	// The name of the table.
	//
	// This member is required.
	TableName *string

	// The auto scaling settings of the table.
	AutoScalingSpecification *types.AutoScalingSpecification

	// The Amazon Web Services Region specific settings of a multi-Region table.
	// Returns the settings for all Regions the table is replicated in.
	ReplicaSpecifications []types.ReplicaAutoScalingSpecification

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetTableAutoScalingSettingsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetTableAutoScalingSettings{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetTableAutoScalingSettings{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetTableAutoScalingSettings"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetTableAutoScalingSettingsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetTableAutoScalingSettings(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetTableAutoScalingSettings(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetTableAutoScalingSettings",
	}
}
