// Code generated by smithy-go-codegen DO NOT EDIT.

package drs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/drs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all Source Networks or multiple Source Networks filtered by ID.
func (c *Client) DescribeSourceNetworks(ctx context.Context, params *DescribeSourceNetworksInput, optFns ...func(*Options)) (*DescribeSourceNetworksOutput, error) {
	if params == nil {
		params = &DescribeSourceNetworksInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeSourceNetworks", params, optFns, c.addOperationDescribeSourceNetworksMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeSourceNetworksOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeSourceNetworksInput struct {

	// A set of filters by which to return Source Networks.
	Filters *types.DescribeSourceNetworksRequestFilters

	// Maximum number of Source Networks to retrieve.
	MaxResults *int32

	// The token of the next Source Networks to retrieve.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeSourceNetworksOutput struct {

	// An array of Source Networks.
	Items []types.SourceNetwork

	// The token of the next Source Networks to retrieve.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeSourceNetworksMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeSourceNetworks{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeSourceNetworks{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeSourceNetworks"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeSourceNetworks(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeSourceNetworksAPIClient is a client that implements the
// DescribeSourceNetworks operation.
type DescribeSourceNetworksAPIClient interface {
	DescribeSourceNetworks(context.Context, *DescribeSourceNetworksInput, ...func(*Options)) (*DescribeSourceNetworksOutput, error)
}

var _ DescribeSourceNetworksAPIClient = (*Client)(nil)

// DescribeSourceNetworksPaginatorOptions is the paginator options for
// DescribeSourceNetworks
type DescribeSourceNetworksPaginatorOptions struct {
	// Maximum number of Source Networks to retrieve.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeSourceNetworksPaginator is a paginator for DescribeSourceNetworks
type DescribeSourceNetworksPaginator struct {
	options   DescribeSourceNetworksPaginatorOptions
	client    DescribeSourceNetworksAPIClient
	params    *DescribeSourceNetworksInput
	nextToken *string
	firstPage bool
}

// NewDescribeSourceNetworksPaginator returns a new DescribeSourceNetworksPaginator
func NewDescribeSourceNetworksPaginator(client DescribeSourceNetworksAPIClient, params *DescribeSourceNetworksInput, optFns ...func(*DescribeSourceNetworksPaginatorOptions)) *DescribeSourceNetworksPaginator {
	if params == nil {
		params = &DescribeSourceNetworksInput{}
	}

	options := DescribeSourceNetworksPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeSourceNetworksPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeSourceNetworksPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeSourceNetworks page.
func (p *DescribeSourceNetworksPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeSourceNetworksOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeSourceNetworks(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeSourceNetworks(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeSourceNetworks",
	}
}
