// Code generated by smithy-go-codegen DO NOT EDIT.

package finspacedata

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/finspacedata/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies the details of a permission group. You cannot modify a
// permissionGroupID .
//
// Deprecated: This method will be discontinued.
func (c *Client) UpdatePermissionGroup(ctx context.Context, params *UpdatePermissionGroupInput, optFns ...func(*Options)) (*UpdatePermissionGroupOutput, error) {
	if params == nil {
		params = &UpdatePermissionGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdatePermissionGroup", params, optFns, c.addOperationUpdatePermissionGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdatePermissionGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdatePermissionGroupInput struct {

	// The unique identifier for the permission group to update.
	//
	// This member is required.
	PermissionGroupId *string

	// The permissions that are granted to a specific group for accessing the FinSpace
	// application. When assigning application permissions, be aware that the
	// permission ManageUsersAndGroups allows users to grant themselves or others
	// access to any functionality in their FinSpace environment's application. It
	// should only be granted to trusted users.
	//   - CreateDataset – Group members can create new datasets.
	//   - ManageClusters – Group members can manage Apache Spark clusters from
	//   FinSpace notebooks.
	//   - ManageUsersAndGroups – Group members can manage users and permission groups.
	//   This is a privileged permission that allows users to grant themselves or others
	//   access to any functionality in the application. It should only be granted to
	//   trusted users.
	//   - ManageAttributeSets – Group members can manage attribute sets.
	//   - ViewAuditData – Group members can view audit data.
	//   - AccessNotebooks – Group members will have access to FinSpace notebooks.
	//   - GetTemporaryCredentials – Group members can get temporary API credentials.
	ApplicationPermissions []types.ApplicationPermission

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string

	// A brief description for the permission group.
	Description *string

	// The name of the permission group.
	Name *string

	noSmithyDocumentSerde
}

type UpdatePermissionGroupOutput struct {

	// The unique identifier for the updated permission group.
	PermissionGroupId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdatePermissionGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdatePermissionGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdatePermissionGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdatePermissionGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = addRestJsonContentTypeCustomization(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opUpdatePermissionGroupMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpUpdatePermissionGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdatePermissionGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpUpdatePermissionGroup struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpUpdatePermissionGroup) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpUpdatePermissionGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*UpdatePermissionGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *UpdatePermissionGroupInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opUpdatePermissionGroupMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpUpdatePermissionGroup{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opUpdatePermissionGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdatePermissionGroup",
	}
}
