// Code generated by smithy-go-codegen DO NOT EDIT.

package athena

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/athena/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the capacity reservations for the current account.
func (c *Client) ListCapacityReservations(ctx context.Context, params *ListCapacityReservationsInput, optFns ...func(*Options)) (*ListCapacityReservationsOutput, error) {
	if params == nil {
		params = &ListCapacityReservationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCapacityReservations", params, optFns, c.addOperationListCapacityReservationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCapacityReservationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCapacityReservationsInput struct {

	// Specifies the maximum number of results to return.
	MaxResults *int32

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated.
	NextToken *string

	noSmithyDocumentSerde
}

type ListCapacityReservationsOutput struct {

	// The capacity reservations for the current account.
	//
	// This member is required.
	CapacityReservations []types.CapacityReservation

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of pages,
	// pass in the NextToken from the response object of the previous page call.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCapacityReservationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListCapacityReservations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListCapacityReservations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCapacityReservations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCapacityReservations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCapacityReservationsAPIClient is a client that implements the
// ListCapacityReservations operation.
type ListCapacityReservationsAPIClient interface {
	ListCapacityReservations(context.Context, *ListCapacityReservationsInput, ...func(*Options)) (*ListCapacityReservationsOutput, error)
}

var _ ListCapacityReservationsAPIClient = (*Client)(nil)

// ListCapacityReservationsPaginatorOptions is the paginator options for
// ListCapacityReservations
type ListCapacityReservationsPaginatorOptions struct {
	// Specifies the maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCapacityReservationsPaginator is a paginator for ListCapacityReservations
type ListCapacityReservationsPaginator struct {
	options   ListCapacityReservationsPaginatorOptions
	client    ListCapacityReservationsAPIClient
	params    *ListCapacityReservationsInput
	nextToken *string
	firstPage bool
}

// NewListCapacityReservationsPaginator returns a new
// ListCapacityReservationsPaginator
func NewListCapacityReservationsPaginator(client ListCapacityReservationsAPIClient, params *ListCapacityReservationsInput, optFns ...func(*ListCapacityReservationsPaginatorOptions)) *ListCapacityReservationsPaginator {
	if params == nil {
		params = &ListCapacityReservationsInput{}
	}

	options := ListCapacityReservationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCapacityReservationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCapacityReservationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCapacityReservations page.
func (p *ListCapacityReservationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCapacityReservationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListCapacityReservations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListCapacityReservations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCapacityReservations",
	}
}
