// Code generated by smithy-go-codegen DO NOT EDIT.

package appsync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a list of environmental variables in an API by its ID value. When
// creating an environmental variable, it must follow the constraints below:
//   - Both JavaScript and VTL templates support environmental variables.
//   - Environmental variables are not evaluated before function invocation.
//   - Environmental variables only support string values.
//   - Any defined value in an environmental variable is considered a string
//     literal and not expanded.
//   - Variable evaluations should ideally be performed in the function code.
//
// When creating an environmental variable key-value pair, it must follow the
// additional constraints below:
//   - Keys must begin with a letter.
//   - Keys must be at least two characters long.
//   - Keys can only contain letters, numbers, and the underscore character (_).
//   - Values can be up to 512 characters long.
//   - You can configure up to 50 key-value pairs in a GraphQL API.
//
// You can create a list of environmental variables by adding it to the
// environmentVariables payload as a list in the format
// {"key1":"value1","key2":"value2", …} . Note that each call of the
// PutGraphqlApiEnvironmentVariables action will result in the overwriting of the
// existing environmental variable list of that API. This means the existing
// environmental variables will be lost. To avoid this, you must include all
// existing and new environmental variables in the list each time you call this
// action.
func (c *Client) PutGraphqlApiEnvironmentVariables(ctx context.Context, params *PutGraphqlApiEnvironmentVariablesInput, optFns ...func(*Options)) (*PutGraphqlApiEnvironmentVariablesOutput, error) {
	if params == nil {
		params = &PutGraphqlApiEnvironmentVariablesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutGraphqlApiEnvironmentVariables", params, optFns, c.addOperationPutGraphqlApiEnvironmentVariablesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutGraphqlApiEnvironmentVariablesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutGraphqlApiEnvironmentVariablesInput struct {

	// The ID of the API to which the environmental variable list will be written.
	//
	// This member is required.
	ApiId *string

	// The list of environmental variables to add to the API. When creating an
	// environmental variable key-value pair, it must follow the additional constraints
	// below:
	//   - Keys must begin with a letter.
	//   - Keys must be at least two characters long.
	//   - Keys can only contain letters, numbers, and the underscore character (_).
	//   - Values can be up to 512 characters long.
	//   - You can configure up to 50 key-value pairs in a GraphQL API.
	// You can create a list of environmental variables by adding it to the
	// environmentVariables payload as a list in the format
	// {"key1":"value1","key2":"value2", …} . Note that each call of the
	// PutGraphqlApiEnvironmentVariables action will result in the overwriting of the
	// existing environmental variable list of that API. This means the existing
	// environmental variables will be lost. To avoid this, you must include all
	// existing and new environmental variables in the list each time you call this
	// action.
	//
	// This member is required.
	EnvironmentVariables map[string]string

	noSmithyDocumentSerde
}

type PutGraphqlApiEnvironmentVariablesOutput struct {

	// The payload containing each environmental variable in the "key" : "value"
	// format.
	EnvironmentVariables map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutGraphqlApiEnvironmentVariablesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutGraphqlApiEnvironmentVariables{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutGraphqlApiEnvironmentVariables{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutGraphqlApiEnvironmentVariables"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPutGraphqlApiEnvironmentVariablesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutGraphqlApiEnvironmentVariables(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutGraphqlApiEnvironmentVariables(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutGraphqlApiEnvironmentVariables",
	}
}
