// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Describes the result of an existing snapshot job that has finished running. A
// finished snapshot job will return a COMPLETED or FAILED status when you poll
// the job with a DescribeDashboardSnapshotJob API call. If the job has not
// finished running, this operation returns a message that says Dashboard Snapshot
// Job with id has not reached a terminal state. .
func (c *Client) DescribeDashboardSnapshotJobResult(ctx context.Context, params *DescribeDashboardSnapshotJobResultInput, optFns ...func(*Options)) (*DescribeDashboardSnapshotJobResultOutput, error) {
	if params == nil {
		params = &DescribeDashboardSnapshotJobResultInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeDashboardSnapshotJobResult", params, optFns, c.addOperationDescribeDashboardSnapshotJobResultMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeDashboardSnapshotJobResultOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeDashboardSnapshotJobResultInput struct {

	// The ID of the Amazon Web Services account that the dashboard snapshot job is
	// executed in.
	//
	// This member is required.
	AwsAccountId *string

	// The ID of the dashboard that you have started a snapshot job for.
	//
	// This member is required.
	DashboardId *string

	// The ID of the job to be described. The job ID is set when you start a new job
	// with a StartDashboardSnapshotJob API call.
	//
	// This member is required.
	SnapshotJobId *string

	noSmithyDocumentSerde
}

type DescribeDashboardSnapshotJobResultOutput struct {

	// The Amazon Resource Name (ARN) for the snapshot job. The job ARN is generated
	// when you start a new job with a StartDashboardSnapshotJob API call.
	Arn *string

	// The time that a snapshot job was created.
	CreatedTime *time.Time

	// Displays information for the error that caused a job to fail.
	ErrorInfo *types.SnapshotJobErrorInfo

	// Indicates the status of a job after it has reached a terminal state. A finished
	// snapshot job will retuen a COMPLETED or FAILED status.
	JobStatus types.SnapshotJobStatus

	// The time that a snapshot job status was last updated.
	LastUpdatedTime *time.Time

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The result of the snapshot job. Jobs that have successfully completed will
	// return the S3Uri where they are located. Jobs that have failedwill return
	// information on the error that caused the job to fail.
	Result *types.SnapshotJobResult

	// The HTTP status of the request
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeDashboardSnapshotJobResultMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeDashboardSnapshotJobResult{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeDashboardSnapshotJobResult{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeDashboardSnapshotJobResult"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeDashboardSnapshotJobResultValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeDashboardSnapshotJobResult(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeDashboardSnapshotJobResult(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeDashboardSnapshotJobResult",
	}
}
