// Code generated by smithy-go-codegen DO NOT EDIT.

package servicecatalog

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/servicecatalog/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Notifies the result of the provisioning engine execution.
func (c *Client) NotifyProvisionProductEngineWorkflowResult(ctx context.Context, params *NotifyProvisionProductEngineWorkflowResultInput, optFns ...func(*Options)) (*NotifyProvisionProductEngineWorkflowResultOutput, error) {
	if params == nil {
		params = &NotifyProvisionProductEngineWorkflowResultInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "NotifyProvisionProductEngineWorkflowResult", params, optFns, c.addOperationNotifyProvisionProductEngineWorkflowResultMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*NotifyProvisionProductEngineWorkflowResultOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type NotifyProvisionProductEngineWorkflowResultInput struct {

	// The idempotency token that identifies the provisioning engine execution.
	//
	// This member is required.
	IdempotencyToken *string

	// The identifier of the record.
	//
	// This member is required.
	RecordId *string

	// The status of the provisioning engine execution.
	//
	// This member is required.
	Status types.EngineWorkflowStatus

	// The encrypted contents of the provisioning engine execution payload that Service
	// Catalog sends after the Terraform product provisioning workflow starts.
	//
	// This member is required.
	WorkflowToken *string

	// The reason why the provisioning engine execution failed.
	FailureReason *string

	// The output of the provisioning engine execution.
	Outputs []types.RecordOutput

	// The ID for the provisioned product resources that are part of a resource group.
	ResourceIdentifier *types.EngineWorkflowResourceIdentifier

	noSmithyDocumentSerde
}

type NotifyProvisionProductEngineWorkflowResultOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationNotifyProvisionProductEngineWorkflowResultMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpNotifyProvisionProductEngineWorkflowResult{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpNotifyProvisionProductEngineWorkflowResult{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opNotifyProvisionProductEngineWorkflowResultMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpNotifyProvisionProductEngineWorkflowResultValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opNotifyProvisionProductEngineWorkflowResult(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpNotifyProvisionProductEngineWorkflowResult struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpNotifyProvisionProductEngineWorkflowResult) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpNotifyProvisionProductEngineWorkflowResult) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*NotifyProvisionProductEngineWorkflowResultInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *NotifyProvisionProductEngineWorkflowResultInput ")
	}

	if input.IdempotencyToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.IdempotencyToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opNotifyProvisionProductEngineWorkflowResultMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpNotifyProvisionProductEngineWorkflowResult{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opNotifyProvisionProductEngineWorkflowResult(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "servicecatalog",
		OperationName: "NotifyProvisionProductEngineWorkflowResult",
	}
}
