// Code generated by smithy-go-codegen DO NOT EDIT.

package securitylake

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/securitylake/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an existing notification method for the subscription (SQS or HTTPs
// endpoint) or switches the notification subscription endpoint for a subscriber.
func (c *Client) UpdateSubscriptionNotificationConfiguration(ctx context.Context, params *UpdateSubscriptionNotificationConfigurationInput, optFns ...func(*Options)) (*UpdateSubscriptionNotificationConfigurationOutput, error) {
	if params == nil {
		params = &UpdateSubscriptionNotificationConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateSubscriptionNotificationConfiguration", params, optFns, c.addOperationUpdateSubscriptionNotificationConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateSubscriptionNotificationConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateSubscriptionNotificationConfigurationInput struct {

	// The subscription ID for which the subscription notification is specified.
	//
	// This member is required.
	SubscriptionId *string

	// Create a new subscription notification for the specified subscription ID in
	// Amazon Security Lake.
	CreateSqs *bool

	// The key name for the subscription notification.
	HttpsApiKeyName *string

	// The key value for the subscription notification.
	HttpsApiKeyValue *string

	// The HTTPS method used for the subscription notification.
	HttpsMethod types.HttpsMethod

	// The Amazon Resource Name (ARN) specifying the role of the subscriber. For more
	// information about ARNs and how to use them in policies, see, see the Managing
	// data access
	// (https://docs.aws.amazon.com//security-lake/latest/userguide/subscriber-data-access.html)
	// and Amazon Web Services Managed Policies
	// (https://docs.aws.amazon.com/security-lake/latest/userguide/security-iam-awsmanpol.html)in
	// the Amazon Security Lake User Guide.
	RoleArn *string

	// The subscription endpoint in Security Lake.
	SubscriptionEndpoint *string

	noSmithyDocumentSerde
}

type UpdateSubscriptionNotificationConfigurationOutput struct {

	// Returns the ARN of the queue.
	QueueArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateSubscriptionNotificationConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateSubscriptionNotificationConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateSubscriptionNotificationConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateSubscriptionNotificationConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateSubscriptionNotificationConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateSubscriptionNotificationConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "securitylake",
		OperationName: "UpdateSubscriptionNotificationConfiguration",
	}
}
