// Code generated by smithy-go-codegen DO NOT EDIT.

package types

type AnalysisErrorType string

// Enum values for AnalysisErrorType
const (
	AnalysisErrorTypeAccessDenied                 AnalysisErrorType = "ACCESS_DENIED"
	AnalysisErrorTypeSourceNotFound               AnalysisErrorType = "SOURCE_NOT_FOUND"
	AnalysisErrorTypeDataSetNotFound              AnalysisErrorType = "DATA_SET_NOT_FOUND"
	AnalysisErrorTypeInternalFailure              AnalysisErrorType = "INTERNAL_FAILURE"
	AnalysisErrorTypeParameterValueIncompatible   AnalysisErrorType = "PARAMETER_VALUE_INCOMPATIBLE"
	AnalysisErrorTypeParameterTypeInvalid         AnalysisErrorType = "PARAMETER_TYPE_INVALID"
	AnalysisErrorTypeParameterNotFound            AnalysisErrorType = "PARAMETER_NOT_FOUND"
	AnalysisErrorTypeColumnTypeMismatch           AnalysisErrorType = "COLUMN_TYPE_MISMATCH"
	AnalysisErrorTypeColumnGeographicRoleMismatch AnalysisErrorType = "COLUMN_GEOGRAPHIC_ROLE_MISMATCH"
	AnalysisErrorTypeColumnReplacementMissing     AnalysisErrorType = "COLUMN_REPLACEMENT_MISSING"
)

// Values returns all known values for AnalysisErrorType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (AnalysisErrorType) Values() []AnalysisErrorType {
	return []AnalysisErrorType{
		"ACCESS_DENIED",
		"SOURCE_NOT_FOUND",
		"DATA_SET_NOT_FOUND",
		"INTERNAL_FAILURE",
		"PARAMETER_VALUE_INCOMPATIBLE",
		"PARAMETER_TYPE_INVALID",
		"PARAMETER_NOT_FOUND",
		"COLUMN_TYPE_MISMATCH",
		"COLUMN_GEOGRAPHIC_ROLE_MISMATCH",
		"COLUMN_REPLACEMENT_MISSING",
	}
}

type AnalysisFilterAttribute string

// Enum values for AnalysisFilterAttribute
const (
	AnalysisFilterAttributeQuicksightUser                AnalysisFilterAttribute = "QUICKSIGHT_USER"
	AnalysisFilterAttributeQuicksightViewerOrOwner       AnalysisFilterAttribute = "QUICKSIGHT_VIEWER_OR_OWNER"
	AnalysisFilterAttributeDirectQuicksightViewerOrOwner AnalysisFilterAttribute = "DIRECT_QUICKSIGHT_VIEWER_OR_OWNER"
	AnalysisFilterAttributeQuicksightOwner               AnalysisFilterAttribute = "QUICKSIGHT_OWNER"
	AnalysisFilterAttributeDirectQuicksightOwner         AnalysisFilterAttribute = "DIRECT_QUICKSIGHT_OWNER"
	AnalysisFilterAttributeDirectQuicksightSoleOwner     AnalysisFilterAttribute = "DIRECT_QUICKSIGHT_SOLE_OWNER"
	AnalysisFilterAttributeAnalysisName                  AnalysisFilterAttribute = "ANALYSIS_NAME"
)

// Values returns all known values for AnalysisFilterAttribute. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (AnalysisFilterAttribute) Values() []AnalysisFilterAttribute {
	return []AnalysisFilterAttribute{
		"QUICKSIGHT_USER",
		"QUICKSIGHT_VIEWER_OR_OWNER",
		"DIRECT_QUICKSIGHT_VIEWER_OR_OWNER",
		"QUICKSIGHT_OWNER",
		"DIRECT_QUICKSIGHT_OWNER",
		"DIRECT_QUICKSIGHT_SOLE_OWNER",
		"ANALYSIS_NAME",
	}
}

type AnchorOption string

// Enum values for AnchorOption
const (
	AnchorOptionNow AnchorOption = "NOW"
)

// Values returns all known values for AnchorOption. Note that this can be expanded
// in the future, and so it is only as up to date as the client. The ordering of
// this slice is not guaranteed to be stable across updates.
func (AnchorOption) Values() []AnchorOption {
	return []AnchorOption{
		"NOW",
	}
}

type ArcThickness string

// Enum values for ArcThickness
const (
	ArcThicknessSmall  ArcThickness = "SMALL"
	ArcThicknessMedium ArcThickness = "MEDIUM"
	ArcThicknessLarge  ArcThickness = "LARGE"
	ArcThicknessWhole  ArcThickness = "WHOLE"
)

// Values returns all known values for ArcThickness. Note that this can be expanded
// in the future, and so it is only as up to date as the client. The ordering of
// this slice is not guaranteed to be stable across updates.
func (ArcThickness) Values() []ArcThickness {
	return []ArcThickness{
		"SMALL",
		"MEDIUM",
		"LARGE",
		"WHOLE",
	}
}

type ArcThicknessOptions string

// Enum values for ArcThicknessOptions
const (
	ArcThicknessOptionsSmall  ArcThicknessOptions = "SMALL"
	ArcThicknessOptionsMedium ArcThicknessOptions = "MEDIUM"
	ArcThicknessOptionsLarge  ArcThicknessOptions = "LARGE"
)

// Values returns all known values for ArcThicknessOptions. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (ArcThicknessOptions) Values() []ArcThicknessOptions {
	return []ArcThicknessOptions{
		"SMALL",
		"MEDIUM",
		"LARGE",
	}
}

type AssignmentStatus string

// Enum values for AssignmentStatus
const (
	AssignmentStatusEnabled  AssignmentStatus = "ENABLED"
	AssignmentStatusDraft    AssignmentStatus = "DRAFT"
	AssignmentStatusDisabled AssignmentStatus = "DISABLED"
)

// Values returns all known values for AssignmentStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (AssignmentStatus) Values() []AssignmentStatus {
	return []AssignmentStatus{
		"ENABLED",
		"DRAFT",
		"DISABLED",
	}
}

type AuthenticationMethodOption string

// Enum values for AuthenticationMethodOption
const (
	AuthenticationMethodOptionIamAndQuicksight AuthenticationMethodOption = "IAM_AND_QUICKSIGHT"
	AuthenticationMethodOptionIamOnly          AuthenticationMethodOption = "IAM_ONLY"
	AuthenticationMethodOptionActiveDirectory  AuthenticationMethodOption = "ACTIVE_DIRECTORY"
)

// Values returns all known values for AuthenticationMethodOption. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
// The ordering of this slice is not guaranteed to be stable across updates.
func (AuthenticationMethodOption) Values() []AuthenticationMethodOption {
	return []AuthenticationMethodOption{
		"IAM_AND_QUICKSIGHT",
		"IAM_ONLY",
		"ACTIVE_DIRECTORY",
	}
}

type AxisBinding string

// Enum values for AxisBinding
const (
	AxisBindingPrimaryYaxis   AxisBinding = "PRIMARY_YAXIS"
	AxisBindingSecondaryYaxis AxisBinding = "SECONDARY_YAXIS"
)

// Values returns all known values for AxisBinding. Note that this can be expanded
// in the future, and so it is only as up to date as the client. The ordering of
// this slice is not guaranteed to be stable across updates.
func (AxisBinding) Values() []AxisBinding {
	return []AxisBinding{
		"PRIMARY_YAXIS",
		"SECONDARY_YAXIS",
	}
}

type BarChartOrientation string

// Enum values for BarChartOrientation
const (
	BarChartOrientationHorizontal BarChartOrientation = "HORIZONTAL"
	BarChartOrientationVertical   BarChartOrientation = "VERTICAL"
)

// Values returns all known values for BarChartOrientation. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (BarChartOrientation) Values() []BarChartOrientation {
	return []BarChartOrientation{
		"HORIZONTAL",
		"VERTICAL",
	}
}

type BarsArrangement string

// Enum values for BarsArrangement
const (
	BarsArrangementClustered      BarsArrangement = "CLUSTERED"
	BarsArrangementStacked        BarsArrangement = "STACKED"
	BarsArrangementStackedPercent BarsArrangement = "STACKED_PERCENT"
)

// Values returns all known values for BarsArrangement. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (BarsArrangement) Values() []BarsArrangement {
	return []BarsArrangement{
		"CLUSTERED",
		"STACKED",
		"STACKED_PERCENT",
	}
}

type BaseMapStyleType string

// Enum values for BaseMapStyleType
const (
	BaseMapStyleTypeLightGray BaseMapStyleType = "LIGHT_GRAY"
	BaseMapStyleTypeDarkGray  BaseMapStyleType = "DARK_GRAY"
	BaseMapStyleTypeStreet    BaseMapStyleType = "STREET"
	BaseMapStyleTypeImagery   BaseMapStyleType = "IMAGERY"
)

// Values returns all known values for BaseMapStyleType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (BaseMapStyleType) Values() []BaseMapStyleType {
	return []BaseMapStyleType{
		"LIGHT_GRAY",
		"DARK_GRAY",
		"STREET",
		"IMAGERY",
	}
}

type BoxPlotFillStyle string

// Enum values for BoxPlotFillStyle
const (
	BoxPlotFillStyleSolid       BoxPlotFillStyle = "SOLID"
	BoxPlotFillStyleTransparent BoxPlotFillStyle = "TRANSPARENT"
)

// Values returns all known values for BoxPlotFillStyle. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (BoxPlotFillStyle) Values() []BoxPlotFillStyle {
	return []BoxPlotFillStyle{
		"SOLID",
		"TRANSPARENT",
	}
}

type CategoricalAggregationFunction string

// Enum values for CategoricalAggregationFunction
const (
	CategoricalAggregationFunctionCount         CategoricalAggregationFunction = "COUNT"
	CategoricalAggregationFunctionDistinctCount CategoricalAggregationFunction = "DISTINCT_COUNT"
)

// Values returns all known values for CategoricalAggregationFunction. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (CategoricalAggregationFunction) Values() []CategoricalAggregationFunction {
	return []CategoricalAggregationFunction{
		"COUNT",
		"DISTINCT_COUNT",
	}
}

type CategoryFilterMatchOperator string

// Enum values for CategoryFilterMatchOperator
const (
	CategoryFilterMatchOperatorEquals         CategoryFilterMatchOperator = "EQUALS"
	CategoryFilterMatchOperatorDoesNotEqual   CategoryFilterMatchOperator = "DOES_NOT_EQUAL"
	CategoryFilterMatchOperatorContains       CategoryFilterMatchOperator = "CONTAINS"
	CategoryFilterMatchOperatorDoesNotContain CategoryFilterMatchOperator = "DOES_NOT_CONTAIN"
	CategoryFilterMatchOperatorStartsWith     CategoryFilterMatchOperator = "STARTS_WITH"
	CategoryFilterMatchOperatorEndsWith       CategoryFilterMatchOperator = "ENDS_WITH"
)

// Values returns all known values for CategoryFilterMatchOperator. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
// The ordering of this slice is not guaranteed to be stable across updates.
func (CategoryFilterMatchOperator) Values() []CategoryFilterMatchOperator {
	return []CategoryFilterMatchOperator{
		"EQUALS",
		"DOES_NOT_EQUAL",
		"CONTAINS",
		"DOES_NOT_CONTAIN",
		"STARTS_WITH",
		"ENDS_WITH",
	}
}

type CategoryFilterSelectAllOptions string

// Enum values for CategoryFilterSelectAllOptions
const (
	CategoryFilterSelectAllOptionsFilterAllValues CategoryFilterSelectAllOptions = "FILTER_ALL_VALUES"
)

// Values returns all known values for CategoryFilterSelectAllOptions. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (CategoryFilterSelectAllOptions) Values() []CategoryFilterSelectAllOptions {
	return []CategoryFilterSelectAllOptions{
		"FILTER_ALL_VALUES",
	}
}

type ColorFillType string

// Enum values for ColorFillType
const (
	ColorFillTypeDiscrete ColorFillType = "DISCRETE"
	ColorFillTypeGradient ColorFillType = "GRADIENT"
)

// Values returns all known values for ColorFillType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (ColorFillType) Values() []ColorFillType {
	return []ColorFillType{
		"DISCRETE",
		"GRADIENT",
	}
}

type ColumnDataType string

// Enum values for ColumnDataType
const (
	ColumnDataTypeString   ColumnDataType = "STRING"
	ColumnDataTypeInteger  ColumnDataType = "INTEGER"
	ColumnDataTypeDecimal  ColumnDataType = "DECIMAL"
	ColumnDataTypeDatetime ColumnDataType = "DATETIME"
)

// Values returns all known values for ColumnDataType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (ColumnDataType) Values() []ColumnDataType {
	return []ColumnDataType{
		"STRING",
		"INTEGER",
		"DECIMAL",
		"DATETIME",
	}
}

type ColumnRole string

// Enum values for ColumnRole
const (
	ColumnRoleDimension ColumnRole = "DIMENSION"
	ColumnRoleMeasure   ColumnRole = "MEASURE"
)

// Values returns all known values for ColumnRole. Note that this can be expanded
// in the future, and so it is only as up to date as the client. The ordering of
// this slice is not guaranteed to be stable across updates.
func (ColumnRole) Values() []ColumnRole {
	return []ColumnRole{
		"DIMENSION",
		"MEASURE",
	}
}

type ColumnTagName string

// Enum values for ColumnTagName
const (
	ColumnTagNameColumnGeographicRole ColumnTagName = "COLUMN_GEOGRAPHIC_ROLE"
	ColumnTagNameColumnDescription    ColumnTagName = "COLUMN_DESCRIPTION"
)

// Values returns all known values for ColumnTagName. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (ColumnTagName) Values() []ColumnTagName {
	return []ColumnTagName{
		"COLUMN_GEOGRAPHIC_ROLE",
		"COLUMN_DESCRIPTION",
	}
}

type ComparisonMethod string

// Enum values for ComparisonMethod
const (
	ComparisonMethodDifference        ComparisonMethod = "DIFFERENCE"
	ComparisonMethodPercentDifference ComparisonMethod = "PERCENT_DIFFERENCE"
	ComparisonMethodPercent           ComparisonMethod = "PERCENT"
)

// Values returns all known values for ComparisonMethod. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (ComparisonMethod) Values() []ComparisonMethod {
	return []ComparisonMethod{
		"DIFFERENCE",
		"PERCENT_DIFFERENCE",
		"PERCENT",
	}
}

type ConditionalFormattingIconDisplayOption string

// Enum values for ConditionalFormattingIconDisplayOption
const (
	ConditionalFormattingIconDisplayOptionIconOnly ConditionalFormattingIconDisplayOption = "ICON_ONLY"
)

// Values returns all known values for ConditionalFormattingIconDisplayOption. Note
// that this can be expanded in the future, and so it is only as up to date as the
// client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (ConditionalFormattingIconDisplayOption) Values() []ConditionalFormattingIconDisplayOption {
	return []ConditionalFormattingIconDisplayOption{
		"ICON_ONLY",
	}
}

type ConditionalFormattingIconSetType string

// Enum values for ConditionalFormattingIconSetType
const (
	ConditionalFormattingIconSetTypePlusMinus        ConditionalFormattingIconSetType = "PLUS_MINUS"
	ConditionalFormattingIconSetTypeCheckX           ConditionalFormattingIconSetType = "CHECK_X"
	ConditionalFormattingIconSetTypeThreeColorArrow  ConditionalFormattingIconSetType = "THREE_COLOR_ARROW"
	ConditionalFormattingIconSetTypeThreeGrayArrow   ConditionalFormattingIconSetType = "THREE_GRAY_ARROW"
	ConditionalFormattingIconSetTypeCaretUpMinusDown ConditionalFormattingIconSetType = "CARET_UP_MINUS_DOWN"
	ConditionalFormattingIconSetTypeThreeShape       ConditionalFormattingIconSetType = "THREE_SHAPE"
	ConditionalFormattingIconSetTypeThreeCircle      ConditionalFormattingIconSetType = "THREE_CIRCLE"
	ConditionalFormattingIconSetTypeFlags            ConditionalFormattingIconSetType = "FLAGS"
	ConditionalFormattingIconSetTypeBars             ConditionalFormattingIconSetType = "BARS"
	ConditionalFormattingIconSetTypeFourColorArrow   ConditionalFormattingIconSetType = "FOUR_COLOR_ARROW"
	ConditionalFormattingIconSetTypeFourGrayArrow    ConditionalFormattingIconSetType = "FOUR_GRAY_ARROW"
)

// Values returns all known values for ConditionalFormattingIconSetType. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (ConditionalFormattingIconSetType) Values() []ConditionalFormattingIconSetType {
	return []ConditionalFormattingIconSetType{
		"PLUS_MINUS",
		"CHECK_X",
		"THREE_COLOR_ARROW",
		"THREE_GRAY_ARROW",
		"CARET_UP_MINUS_DOWN",
		"THREE_SHAPE",
		"THREE_CIRCLE",
		"FLAGS",
		"BARS",
		"FOUR_COLOR_ARROW",
		"FOUR_GRAY_ARROW",
	}
}

type CrossDatasetTypes string

// Enum values for CrossDatasetTypes
const (
	CrossDatasetTypesAllDatasets   CrossDatasetTypes = "ALL_DATASETS"
	CrossDatasetTypesSingleDataset CrossDatasetTypes = "SINGLE_DATASET"
)

// Values returns all known values for CrossDatasetTypes. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (CrossDatasetTypes) Values() []CrossDatasetTypes {
	return []CrossDatasetTypes{
		"ALL_DATASETS",
		"SINGLE_DATASET",
	}
}

type CustomContentImageScalingConfiguration string

// Enum values for CustomContentImageScalingConfiguration
const (
	CustomContentImageScalingConfigurationFitToHeight   CustomContentImageScalingConfiguration = "FIT_TO_HEIGHT"
	CustomContentImageScalingConfigurationFitToWidth    CustomContentImageScalingConfiguration = "FIT_TO_WIDTH"
	CustomContentImageScalingConfigurationDoNotScale    CustomContentImageScalingConfiguration = "DO_NOT_SCALE"
	CustomContentImageScalingConfigurationScaleToVisual CustomContentImageScalingConfiguration = "SCALE_TO_VISUAL"
)

// Values returns all known values for CustomContentImageScalingConfiguration. Note
// that this can be expanded in the future, and so it is only as up to date as the
// client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (CustomContentImageScalingConfiguration) Values() []CustomContentImageScalingConfiguration {
	return []CustomContentImageScalingConfiguration{
		"FIT_TO_HEIGHT",
		"FIT_TO_WIDTH",
		"DO_NOT_SCALE",
		"SCALE_TO_VISUAL",
	}
}

type CustomContentType string

// Enum values for CustomContentType
const (
	CustomContentTypeImage                CustomContentType = "IMAGE"
	CustomContentTypeOtherEmbeddedContent CustomContentType = "OTHER_EMBEDDED_CONTENT"
)

// Values returns all known values for CustomContentType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (CustomContentType) Values() []CustomContentType {
	return []CustomContentType{
		"IMAGE",
		"OTHER_EMBEDDED_CONTENT",
	}
}

type DashboardBehavior string

// Enum values for DashboardBehavior
const (
	DashboardBehaviorEnabled  DashboardBehavior = "ENABLED"
	DashboardBehaviorDisabled DashboardBehavior = "DISABLED"
)

// Values returns all known values for DashboardBehavior. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (DashboardBehavior) Values() []DashboardBehavior {
	return []DashboardBehavior{
		"ENABLED",
		"DISABLED",
	}
}

type DashboardErrorType string

// Enum values for DashboardErrorType
const (
	DashboardErrorTypeAccessDenied                 DashboardErrorType = "ACCESS_DENIED"
	DashboardErrorTypeSourceNotFound               DashboardErrorType = "SOURCE_NOT_FOUND"
	DashboardErrorTypeDataSetNotFound              DashboardErrorType = "DATA_SET_NOT_FOUND"
	DashboardErrorTypeInternalFailure              DashboardErrorType = "INTERNAL_FAILURE"
	DashboardErrorTypeParameterValueIncompatible   DashboardErrorType = "PARAMETER_VALUE_INCOMPATIBLE"
	DashboardErrorTypeParameterTypeInvalid         DashboardErrorType = "PARAMETER_TYPE_INVALID"
	DashboardErrorTypeParameterNotFound            DashboardErrorType = "PARAMETER_NOT_FOUND"
	DashboardErrorTypeColumnTypeMismatch           DashboardErrorType = "COLUMN_TYPE_MISMATCH"
	DashboardErrorTypeColumnGeographicRoleMismatch DashboardErrorType = "COLUMN_GEOGRAPHIC_ROLE_MISMATCH"
	DashboardErrorTypeColumnReplacementMissing     DashboardErrorType = "COLUMN_REPLACEMENT_MISSING"
)

// Values returns all known values for DashboardErrorType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (DashboardErrorType) Values() []DashboardErrorType {
	return []DashboardErrorType{
		"ACCESS_DENIED",
		"SOURCE_NOT_FOUND",
		"DATA_SET_NOT_FOUND",
		"INTERNAL_FAILURE",
		"PARAMETER_VALUE_INCOMPATIBLE",
		"PARAMETER_TYPE_INVALID",
		"PARAMETER_NOT_FOUND",
		"COLUMN_TYPE_MISMATCH",
		"COLUMN_GEOGRAPHIC_ROLE_MISMATCH",
		"COLUMN_REPLACEMENT_MISSING",
	}
}

type DashboardFilterAttribute string

// Enum values for DashboardFilterAttribute
const (
	DashboardFilterAttributeQuicksightUser                DashboardFilterAttribute = "QUICKSIGHT_USER"
	DashboardFilterAttributeQuicksightViewerOrOwner       DashboardFilterAttribute = "QUICKSIGHT_VIEWER_OR_OWNER"
	DashboardFilterAttributeDirectQuicksightViewerOrOwner DashboardFilterAttribute = "DIRECT_QUICKSIGHT_VIEWER_OR_OWNER"
	DashboardFilterAttributeQuicksightOwner               DashboardFilterAttribute = "QUICKSIGHT_OWNER"
	DashboardFilterAttributeDirectQuicksightOwner         DashboardFilterAttribute = "DIRECT_QUICKSIGHT_OWNER"
	DashboardFilterAttributeDirectQuicksightSoleOwner     DashboardFilterAttribute = "DIRECT_QUICKSIGHT_SOLE_OWNER"
	DashboardFilterAttributeDashboardName                 DashboardFilterAttribute = "DASHBOARD_NAME"
)

// Values returns all known values for DashboardFilterAttribute. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (DashboardFilterAttribute) Values() []DashboardFilterAttribute {
	return []DashboardFilterAttribute{
		"QUICKSIGHT_USER",
		"QUICKSIGHT_VIEWER_OR_OWNER",
		"DIRECT_QUICKSIGHT_VIEWER_OR_OWNER",
		"QUICKSIGHT_OWNER",
		"DIRECT_QUICKSIGHT_OWNER",
		"DIRECT_QUICKSIGHT_SOLE_OWNER",
		"DASHBOARD_NAME",
	}
}

type DashboardUIState string

// Enum values for DashboardUIState
const (
	DashboardUIStateExpanded  DashboardUIState = "EXPANDED"
	DashboardUIStateCollapsed DashboardUIState = "COLLAPSED"
)

// Values returns all known values for DashboardUIState. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (DashboardUIState) Values() []DashboardUIState {
	return []DashboardUIState{
		"EXPANDED",
		"COLLAPSED",
	}
}

type DataLabelContent string

// Enum values for DataLabelContent
const (
	DataLabelContentValue           DataLabelContent = "VALUE"
	DataLabelContentPercent         DataLabelContent = "PERCENT"
	DataLabelContentValueAndPercent DataLabelContent = "VALUE_AND_PERCENT"
)

// Values returns all known values for DataLabelContent. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (DataLabelContent) Values() []DataLabelContent {
	return []DataLabelContent{
		"VALUE",
		"PERCENT",
		"VALUE_AND_PERCENT",
	}
}

type DataLabelOverlap string

// Enum values for DataLabelOverlap
const (
	DataLabelOverlapDisableOverlap DataLabelOverlap = "DISABLE_OVERLAP"
	DataLabelOverlapEnableOverlap  DataLabelOverlap = "ENABLE_OVERLAP"
)

// Values returns all known values for DataLabelOverlap. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (DataLabelOverlap) Values() []DataLabelOverlap {
	return []DataLabelOverlap{
		"DISABLE_OVERLAP",
		"ENABLE_OVERLAP",
	}
}

type DataLabelPosition string

// Enum values for DataLabelPosition
const (
	DataLabelPositionInside  DataLabelPosition = "INSIDE"
	DataLabelPositionOutside DataLabelPosition = "OUTSIDE"
	DataLabelPositionLeft    DataLabelPosition = "LEFT"
	DataLabelPositionTop     DataLabelPosition = "TOP"
	DataLabelPositionBottom  DataLabelPosition = "BOTTOM"
	DataLabelPositionRight   DataLabelPosition = "RIGHT"
)

// Values returns all known values for DataLabelPosition. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (DataLabelPosition) Values() []DataLabelPosition {
	return []DataLabelPosition{
		"INSIDE",
		"OUTSIDE",
		"LEFT",
		"TOP",
		"BOTTOM",
		"RIGHT",
	}
}

type DataSetFilterAttribute string

// Enum values for DataSetFilterAttribute
const (
	DataSetFilterAttributeQuicksightViewerOrOwner       DataSetFilterAttribute = "QUICKSIGHT_VIEWER_OR_OWNER"
	DataSetFilterAttributeQuicksightOwner               DataSetFilterAttribute = "QUICKSIGHT_OWNER"
	DataSetFilterAttributeDirectQuicksightViewerOrOwner DataSetFilterAttribute = "DIRECT_QUICKSIGHT_VIEWER_OR_OWNER"
	DataSetFilterAttributeDirectQuicksightOwner         DataSetFilterAttribute = "DIRECT_QUICKSIGHT_OWNER"
	DataSetFilterAttributeDirectQuicksightSoleOwner     DataSetFilterAttribute = "DIRECT_QUICKSIGHT_SOLE_OWNER"
	DataSetFilterAttributeDatasetName                   DataSetFilterAttribute = "DATASET_NAME"
)

// Values returns all known values for DataSetFilterAttribute. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (DataSetFilterAttribute) Values() []DataSetFilterAttribute {
	return []DataSetFilterAttribute{
		"QUICKSIGHT_VIEWER_OR_OWNER",
		"QUICKSIGHT_OWNER",
		"DIRECT_QUICKSIGHT_VIEWER_OR_OWNER",
		"DIRECT_QUICKSIGHT_OWNER",
		"DIRECT_QUICKSIGHT_SOLE_OWNER",
		"DATASET_NAME",
	}
}

type DataSetImportMode string

// Enum values for DataSetImportMode
const (
	DataSetImportModeSpice       DataSetImportMode = "SPICE"
	DataSetImportModeDirectQuery DataSetImportMode = "DIRECT_QUERY"
)

// Values returns all known values for DataSetImportMode. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (DataSetImportMode) Values() []DataSetImportMode {
	return []DataSetImportMode{
		"SPICE",
		"DIRECT_QUERY",
	}
}

type DataSourceErrorInfoType string

// Enum values for DataSourceErrorInfoType
const (
	DataSourceErrorInfoTypeAccessDenied              DataSourceErrorInfoType = "ACCESS_DENIED"
	DataSourceErrorInfoTypeCopySourceNotFound        DataSourceErrorInfoType = "COPY_SOURCE_NOT_FOUND"
	DataSourceErrorInfoTypeTimeout                   DataSourceErrorInfoType = "TIMEOUT"
	DataSourceErrorInfoTypeEngineVersionNotSupported DataSourceErrorInfoType = "ENGINE_VERSION_NOT_SUPPORTED"
	DataSourceErrorInfoTypeUnknownHost               DataSourceErrorInfoType = "UNKNOWN_HOST"
	DataSourceErrorInfoTypeGenericSqlFailure         DataSourceErrorInfoType = "GENERIC_SQL_FAILURE"
	DataSourceErrorInfoTypeConflict                  DataSourceErrorInfoType = "CONFLICT"
	DataSourceErrorInfoTypeUnknown                   DataSourceErrorInfoType = "UNKNOWN"
)

// Values returns all known values for DataSourceErrorInfoType. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (DataSourceErrorInfoType) Values() []DataSourceErrorInfoType {
	return []DataSourceErrorInfoType{
		"ACCESS_DENIED",
		"COPY_SOURCE_NOT_FOUND",
		"TIMEOUT",
		"ENGINE_VERSION_NOT_SUPPORTED",
		"UNKNOWN_HOST",
		"GENERIC_SQL_FAILURE",
		"CONFLICT",
		"UNKNOWN",
	}
}

type DataSourceFilterAttribute string

// Enum values for DataSourceFilterAttribute
const (
	DataSourceFilterAttributeDirectQuicksightViewerOrOwner DataSourceFilterAttribute = "DIRECT_QUICKSIGHT_VIEWER_OR_OWNER"
	DataSourceFilterAttributeDirectQuicksightOwner         DataSourceFilterAttribute = "DIRECT_QUICKSIGHT_OWNER"
	DataSourceFilterAttributeDirectQuicksightSoleOwner     DataSourceFilterAttribute = "DIRECT_QUICKSIGHT_SOLE_OWNER"
	DataSourceFilterAttributeDatasourceName                DataSourceFilterAttribute = "DATASOURCE_NAME"
)

// Values returns all known values for DataSourceFilterAttribute. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
// The ordering of this slice is not guaranteed to be stable across updates.
func (DataSourceFilterAttribute) Values() []DataSourceFilterAttribute {
	return []DataSourceFilterAttribute{
		"DIRECT_QUICKSIGHT_VIEWER_OR_OWNER",
		"DIRECT_QUICKSIGHT_OWNER",
		"DIRECT_QUICKSIGHT_SOLE_OWNER",
		"DATASOURCE_NAME",
	}
}

type DataSourceType string

// Enum values for DataSourceType
const (
	DataSourceTypeAdobeAnalytics      DataSourceType = "ADOBE_ANALYTICS"
	DataSourceTypeAmazonElasticsearch DataSourceType = "AMAZON_ELASTICSEARCH"
	DataSourceTypeAthena              DataSourceType = "ATHENA"
	DataSourceTypeAurora              DataSourceType = "AURORA"
	DataSourceTypeAuroraPostgresql    DataSourceType = "AURORA_POSTGRESQL"
	DataSourceTypeAwsIotAnalytics     DataSourceType = "AWS_IOT_ANALYTICS"
	DataSourceTypeGithub              DataSourceType = "GITHUB"
	DataSourceTypeJira                DataSourceType = "JIRA"
	DataSourceTypeMariadb             DataSourceType = "MARIADB"
	DataSourceTypeMysql               DataSourceType = "MYSQL"
	DataSourceTypeOracle              DataSourceType = "ORACLE"
	DataSourceTypePostgresql          DataSourceType = "POSTGRESQL"
	DataSourceTypePresto              DataSourceType = "PRESTO"
	DataSourceTypeRedshift            DataSourceType = "REDSHIFT"
	DataSourceTypeS3                  DataSourceType = "S3"
	DataSourceTypeSalesforce          DataSourceType = "SALESFORCE"
	DataSourceTypeServicenow          DataSourceType = "SERVICENOW"
	DataSourceTypeSnowflake           DataSourceType = "SNOWFLAKE"
	DataSourceTypeSpark               DataSourceType = "SPARK"
	DataSourceTypeSqlserver           DataSourceType = "SQLSERVER"
	DataSourceTypeTeradata            DataSourceType = "TERADATA"
	DataSourceTypeTwitter             DataSourceType = "TWITTER"
	DataSourceTypeTimestream          DataSourceType = "TIMESTREAM"
	DataSourceTypeAmazonOpensearch    DataSourceType = "AMAZON_OPENSEARCH"
	DataSourceTypeExasol              DataSourceType = "EXASOL"
	DataSourceTypeDatabricks          DataSourceType = "DATABRICKS"
)

// Values returns all known values for DataSourceType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (DataSourceType) Values() []DataSourceType {
	return []DataSourceType{
		"ADOBE_ANALYTICS",
		"AMAZON_ELASTICSEARCH",
		"ATHENA",
		"AURORA",
		"AURORA_POSTGRESQL",
		"AWS_IOT_ANALYTICS",
		"GITHUB",
		"JIRA",
		"MARIADB",
		"MYSQL",
		"ORACLE",
		"POSTGRESQL",
		"PRESTO",
		"REDSHIFT",
		"S3",
		"SALESFORCE",
		"SERVICENOW",
		"SNOWFLAKE",
		"SPARK",
		"SQLSERVER",
		"TERADATA",
		"TWITTER",
		"TIMESTREAM",
		"AMAZON_OPENSEARCH",
		"EXASOL",
		"DATABRICKS",
	}
}

type DateAggregationFunction string

// Enum values for DateAggregationFunction
const (
	DateAggregationFunctionCount         DateAggregationFunction = "COUNT"
	DateAggregationFunctionDistinctCount DateAggregationFunction = "DISTINCT_COUNT"
	DateAggregationFunctionMin           DateAggregationFunction = "MIN"
	DateAggregationFunctionMax           DateAggregationFunction = "MAX"
)

// Values returns all known values for DateAggregationFunction. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (DateAggregationFunction) Values() []DateAggregationFunction {
	return []DateAggregationFunction{
		"COUNT",
		"DISTINCT_COUNT",
		"MIN",
		"MAX",
	}
}

type DayOfWeek string

// Enum values for DayOfWeek
const (
	DayOfWeekSunday    DayOfWeek = "SUNDAY"
	DayOfWeekMonday    DayOfWeek = "MONDAY"
	DayOfWeekTuesday   DayOfWeek = "TUESDAY"
	DayOfWeekWednesday DayOfWeek = "WEDNESDAY"
	DayOfWeekThursday  DayOfWeek = "THURSDAY"
	DayOfWeekFriday    DayOfWeek = "FRIDAY"
	DayOfWeekSaturday  DayOfWeek = "SATURDAY"
)

// Values returns all known values for DayOfWeek. Note that this can be expanded in
// the future, and so it is only as up to date as the client. The ordering of this
// slice is not guaranteed to be stable across updates.
func (DayOfWeek) Values() []DayOfWeek {
	return []DayOfWeek{
		"SUNDAY",
		"MONDAY",
		"TUESDAY",
		"WEDNESDAY",
		"THURSDAY",
		"FRIDAY",
		"SATURDAY",
	}
}

type Edition string

// Enum values for Edition
const (
	EditionStandard       Edition = "STANDARD"
	EditionEnterprise     Edition = "ENTERPRISE"
	EditionEnterpriseAndQ Edition = "ENTERPRISE_AND_Q"
)

// Values returns all known values for Edition. Note that this can be expanded in
// the future, and so it is only as up to date as the client. The ordering of this
// slice is not guaranteed to be stable across updates.
func (Edition) Values() []Edition {
	return []Edition{
		"STANDARD",
		"ENTERPRISE",
		"ENTERPRISE_AND_Q",
	}
}

type EmbeddingIdentityType string

// Enum values for EmbeddingIdentityType
const (
	EmbeddingIdentityTypeIam        EmbeddingIdentityType = "IAM"
	EmbeddingIdentityTypeQuicksight EmbeddingIdentityType = "QUICKSIGHT"
	EmbeddingIdentityTypeAnonymous  EmbeddingIdentityType = "ANONYMOUS"
)

// Values returns all known values for EmbeddingIdentityType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (EmbeddingIdentityType) Values() []EmbeddingIdentityType {
	return []EmbeddingIdentityType{
		"IAM",
		"QUICKSIGHT",
		"ANONYMOUS",
	}
}

type ExceptionResourceType string

// Enum values for ExceptionResourceType
const (
	ExceptionResourceTypeUser                ExceptionResourceType = "USER"
	ExceptionResourceTypeGroup               ExceptionResourceType = "GROUP"
	ExceptionResourceTypeNamespace           ExceptionResourceType = "NAMESPACE"
	ExceptionResourceTypeAccountSettings     ExceptionResourceType = "ACCOUNT_SETTINGS"
	ExceptionResourceTypeIampolicyAssignment ExceptionResourceType = "IAMPOLICY_ASSIGNMENT"
	ExceptionResourceTypeDataSource          ExceptionResourceType = "DATA_SOURCE"
	ExceptionResourceTypeDataSet             ExceptionResourceType = "DATA_SET"
	ExceptionResourceTypeVpcConnection       ExceptionResourceType = "VPC_CONNECTION"
	ExceptionResourceTypeIngestion           ExceptionResourceType = "INGESTION"
)

// Values returns all known values for ExceptionResourceType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (ExceptionResourceType) Values() []ExceptionResourceType {
	return []ExceptionResourceType{
		"USER",
		"GROUP",
		"NAMESPACE",
		"ACCOUNT_SETTINGS",
		"IAMPOLICY_ASSIGNMENT",
		"DATA_SOURCE",
		"DATA_SET",
		"VPC_CONNECTION",
		"INGESTION",
	}
}

type FileFormat string

// Enum values for FileFormat
const (
	FileFormatCsv  FileFormat = "CSV"
	FileFormatTsv  FileFormat = "TSV"
	FileFormatClf  FileFormat = "CLF"
	FileFormatElf  FileFormat = "ELF"
	FileFormatXlsx FileFormat = "XLSX"
	FileFormatJson FileFormat = "JSON"
)

// Values returns all known values for FileFormat. Note that this can be expanded
// in the future, and so it is only as up to date as the client. The ordering of
// this slice is not guaranteed to be stable across updates.
func (FileFormat) Values() []FileFormat {
	return []FileFormat{
		"CSV",
		"TSV",
		"CLF",
		"ELF",
		"XLSX",
		"JSON",
	}
}

type FilterNullOption string

// Enum values for FilterNullOption
const (
	FilterNullOptionAllValues    FilterNullOption = "ALL_VALUES"
	FilterNullOptionNullsOnly    FilterNullOption = "NULLS_ONLY"
	FilterNullOptionNonNullsOnly FilterNullOption = "NON_NULLS_ONLY"
)

// Values returns all known values for FilterNullOption. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (FilterNullOption) Values() []FilterNullOption {
	return []FilterNullOption{
		"ALL_VALUES",
		"NULLS_ONLY",
		"NON_NULLS_ONLY",
	}
}

type FilterOperator string

// Enum values for FilterOperator
const (
	FilterOperatorStringEquals FilterOperator = "StringEquals"
	FilterOperatorStringLike   FilterOperator = "StringLike"
)

// Values returns all known values for FilterOperator. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (FilterOperator) Values() []FilterOperator {
	return []FilterOperator{
		"StringEquals",
		"StringLike",
	}
}

type FilterVisualScope string

// Enum values for FilterVisualScope
const (
	FilterVisualScopeAllVisuals      FilterVisualScope = "ALL_VISUALS"
	FilterVisualScopeSelectedVisuals FilterVisualScope = "SELECTED_VISUALS"
)

// Values returns all known values for FilterVisualScope. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (FilterVisualScope) Values() []FilterVisualScope {
	return []FilterVisualScope{
		"ALL_VISUALS",
		"SELECTED_VISUALS",
	}
}

type FolderFilterAttribute string

// Enum values for FolderFilterAttribute
const (
	FolderFilterAttributeParentFolderArn               FolderFilterAttribute = "PARENT_FOLDER_ARN"
	FolderFilterAttributeDirectQuicksightOwner         FolderFilterAttribute = "DIRECT_QUICKSIGHT_OWNER"
	FolderFilterAttributeDirectQuicksightSoleOwner     FolderFilterAttribute = "DIRECT_QUICKSIGHT_SOLE_OWNER"
	FolderFilterAttributeDirectQuicksightViewerOrOwner FolderFilterAttribute = "DIRECT_QUICKSIGHT_VIEWER_OR_OWNER"
	FolderFilterAttributeQuicksightOwner               FolderFilterAttribute = "QUICKSIGHT_OWNER"
	FolderFilterAttributeQuicksightViewerOrOwner       FolderFilterAttribute = "QUICKSIGHT_VIEWER_OR_OWNER"
	FolderFilterAttributeFolderName                    FolderFilterAttribute = "FOLDER_NAME"
)

// Values returns all known values for FolderFilterAttribute. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (FolderFilterAttribute) Values() []FolderFilterAttribute {
	return []FolderFilterAttribute{
		"PARENT_FOLDER_ARN",
		"DIRECT_QUICKSIGHT_OWNER",
		"DIRECT_QUICKSIGHT_SOLE_OWNER",
		"DIRECT_QUICKSIGHT_VIEWER_OR_OWNER",
		"QUICKSIGHT_OWNER",
		"QUICKSIGHT_VIEWER_OR_OWNER",
		"FOLDER_NAME",
	}
}

type FolderType string

// Enum values for FolderType
const (
	FolderTypeShared FolderType = "SHARED"
)

// Values returns all known values for FolderType. Note that this can be expanded
// in the future, and so it is only as up to date as the client. The ordering of
// this slice is not guaranteed to be stable across updates.
func (FolderType) Values() []FolderType {
	return []FolderType{
		"SHARED",
	}
}

type FontDecoration string

// Enum values for FontDecoration
const (
	FontDecorationUnderline FontDecoration = "UNDERLINE"
	FontDecorationNone      FontDecoration = "NONE"
)

// Values returns all known values for FontDecoration. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (FontDecoration) Values() []FontDecoration {
	return []FontDecoration{
		"UNDERLINE",
		"NONE",
	}
}

type FontStyle string

// Enum values for FontStyle
const (
	FontStyleNormal FontStyle = "NORMAL"
	FontStyleItalic FontStyle = "ITALIC"
)

// Values returns all known values for FontStyle. Note that this can be expanded in
// the future, and so it is only as up to date as the client. The ordering of this
// slice is not guaranteed to be stable across updates.
func (FontStyle) Values() []FontStyle {
	return []FontStyle{
		"NORMAL",
		"ITALIC",
	}
}

type FontWeightName string

// Enum values for FontWeightName
const (
	FontWeightNameNormal FontWeightName = "NORMAL"
	FontWeightNameBold   FontWeightName = "BOLD"
)

// Values returns all known values for FontWeightName. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (FontWeightName) Values() []FontWeightName {
	return []FontWeightName{
		"NORMAL",
		"BOLD",
	}
}

type ForecastComputationSeasonality string

// Enum values for ForecastComputationSeasonality
const (
	ForecastComputationSeasonalityAutomatic ForecastComputationSeasonality = "AUTOMATIC"
	ForecastComputationSeasonalityCustom    ForecastComputationSeasonality = "CUSTOM"
)

// Values returns all known values for ForecastComputationSeasonality. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (ForecastComputationSeasonality) Values() []ForecastComputationSeasonality {
	return []ForecastComputationSeasonality{
		"AUTOMATIC",
		"CUSTOM",
	}
}

type FunnelChartMeasureDataLabelStyle string

// Enum values for FunnelChartMeasureDataLabelStyle
const (
	FunnelChartMeasureDataLabelStyleValueOnly                         FunnelChartMeasureDataLabelStyle = "VALUE_ONLY"
	FunnelChartMeasureDataLabelStylePercentageByFirstStage            FunnelChartMeasureDataLabelStyle = "PERCENTAGE_BY_FIRST_STAGE"
	FunnelChartMeasureDataLabelStylePercentageByPreviousStage         FunnelChartMeasureDataLabelStyle = "PERCENTAGE_BY_PREVIOUS_STAGE"
	FunnelChartMeasureDataLabelStyleValueAndPercentageByFirstStage    FunnelChartMeasureDataLabelStyle = "VALUE_AND_PERCENTAGE_BY_FIRST_STAGE"
	FunnelChartMeasureDataLabelStyleValueAndPercentageByPreviousStage FunnelChartMeasureDataLabelStyle = "VALUE_AND_PERCENTAGE_BY_PREVIOUS_STAGE"
)

// Values returns all known values for FunnelChartMeasureDataLabelStyle. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (FunnelChartMeasureDataLabelStyle) Values() []FunnelChartMeasureDataLabelStyle {
	return []FunnelChartMeasureDataLabelStyle{
		"VALUE_ONLY",
		"PERCENTAGE_BY_FIRST_STAGE",
		"PERCENTAGE_BY_PREVIOUS_STAGE",
		"VALUE_AND_PERCENTAGE_BY_FIRST_STAGE",
		"VALUE_AND_PERCENTAGE_BY_PREVIOUS_STAGE",
	}
}

type GeoSpatialCountryCode string

// Enum values for GeoSpatialCountryCode
const (
	GeoSpatialCountryCodeUs GeoSpatialCountryCode = "US"
)

// Values returns all known values for GeoSpatialCountryCode. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (GeoSpatialCountryCode) Values() []GeoSpatialCountryCode {
	return []GeoSpatialCountryCode{
		"US",
	}
}

type GeoSpatialDataRole string

// Enum values for GeoSpatialDataRole
const (
	GeoSpatialDataRoleCountry   GeoSpatialDataRole = "COUNTRY"
	GeoSpatialDataRoleState     GeoSpatialDataRole = "STATE"
	GeoSpatialDataRoleCounty    GeoSpatialDataRole = "COUNTY"
	GeoSpatialDataRoleCity      GeoSpatialDataRole = "CITY"
	GeoSpatialDataRolePostcode  GeoSpatialDataRole = "POSTCODE"
	GeoSpatialDataRoleLongitude GeoSpatialDataRole = "LONGITUDE"
	GeoSpatialDataRoleLatitude  GeoSpatialDataRole = "LATITUDE"
)

// Values returns all known values for GeoSpatialDataRole. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (GeoSpatialDataRole) Values() []GeoSpatialDataRole {
	return []GeoSpatialDataRole{
		"COUNTRY",
		"STATE",
		"COUNTY",
		"CITY",
		"POSTCODE",
		"LONGITUDE",
		"LATITUDE",
	}
}

type GeospatialSelectedPointStyle string

// Enum values for GeospatialSelectedPointStyle
const (
	GeospatialSelectedPointStylePoint   GeospatialSelectedPointStyle = "POINT"
	GeospatialSelectedPointStyleCluster GeospatialSelectedPointStyle = "CLUSTER"
)

// Values returns all known values for GeospatialSelectedPointStyle. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
// The ordering of this slice is not guaranteed to be stable across updates.
func (GeospatialSelectedPointStyle) Values() []GeospatialSelectedPointStyle {
	return []GeospatialSelectedPointStyle{
		"POINT",
		"CLUSTER",
	}
}

type GroupFilterAttribute string

// Enum values for GroupFilterAttribute
const (
	GroupFilterAttributeGroupName GroupFilterAttribute = "GROUP_NAME"
)

// Values returns all known values for GroupFilterAttribute. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (GroupFilterAttribute) Values() []GroupFilterAttribute {
	return []GroupFilterAttribute{
		"GROUP_NAME",
	}
}

type GroupFilterOperator string

// Enum values for GroupFilterOperator
const (
	GroupFilterOperatorStartsWith GroupFilterOperator = "StartsWith"
)

// Values returns all known values for GroupFilterOperator. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (GroupFilterOperator) Values() []GroupFilterOperator {
	return []GroupFilterOperator{
		"StartsWith",
	}
}

type HistogramBinType string

// Enum values for HistogramBinType
const (
	HistogramBinTypeBinCount HistogramBinType = "BIN_COUNT"
	HistogramBinTypeBinWidth HistogramBinType = "BIN_WIDTH"
)

// Values returns all known values for HistogramBinType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (HistogramBinType) Values() []HistogramBinType {
	return []HistogramBinType{
		"BIN_COUNT",
		"BIN_WIDTH",
	}
}

type HorizontalTextAlignment string

// Enum values for HorizontalTextAlignment
const (
	HorizontalTextAlignmentLeft   HorizontalTextAlignment = "LEFT"
	HorizontalTextAlignmentCenter HorizontalTextAlignment = "CENTER"
	HorizontalTextAlignmentRight  HorizontalTextAlignment = "RIGHT"
	HorizontalTextAlignmentAuto   HorizontalTextAlignment = "AUTO"
)

// Values returns all known values for HorizontalTextAlignment. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (HorizontalTextAlignment) Values() []HorizontalTextAlignment {
	return []HorizontalTextAlignment{
		"LEFT",
		"CENTER",
		"RIGHT",
		"AUTO",
	}
}

type Icon string

// Enum values for Icon
const (
	IconCaretUp        Icon = "CARET_UP"
	IconCaretDown      Icon = "CARET_DOWN"
	IconPlus           Icon = "PLUS"
	IconMinus          Icon = "MINUS"
	IconArrowUp        Icon = "ARROW_UP"
	IconArrowDown      Icon = "ARROW_DOWN"
	IconArrowLeft      Icon = "ARROW_LEFT"
	IconArrowUpLeft    Icon = "ARROW_UP_LEFT"
	IconArrowDownLeft  Icon = "ARROW_DOWN_LEFT"
	IconArrowRight     Icon = "ARROW_RIGHT"
	IconArrowUpRight   Icon = "ARROW_UP_RIGHT"
	IconArrowDownRight Icon = "ARROW_DOWN_RIGHT"
	IconFaceUp         Icon = "FACE_UP"
	IconFaceDown       Icon = "FACE_DOWN"
	IconFaceFlat       Icon = "FACE_FLAT"
	IconOneBar         Icon = "ONE_BAR"
	IconTwoBar         Icon = "TWO_BAR"
	IconThreeBar       Icon = "THREE_BAR"
	IconCircle         Icon = "CIRCLE"
	IconTriangle       Icon = "TRIANGLE"
	IconSquare         Icon = "SQUARE"
	IconFlag           Icon = "FLAG"
	IconThumbsUp       Icon = "THUMBS_UP"
	IconThumbsDown     Icon = "THUMBS_DOWN"
	IconCheckmark      Icon = "CHECKMARK"
	IconX              Icon = "X"
)

// Values returns all known values for Icon. Note that this can be expanded in the
// future, and so it is only as up to date as the client. The ordering of this
// slice is not guaranteed to be stable across updates.
func (Icon) Values() []Icon {
	return []Icon{
		"CARET_UP",
		"CARET_DOWN",
		"PLUS",
		"MINUS",
		"ARROW_UP",
		"ARROW_DOWN",
		"ARROW_LEFT",
		"ARROW_UP_LEFT",
		"ARROW_DOWN_LEFT",
		"ARROW_RIGHT",
		"ARROW_UP_RIGHT",
		"ARROW_DOWN_RIGHT",
		"FACE_UP",
		"FACE_DOWN",
		"FACE_FLAT",
		"ONE_BAR",
		"TWO_BAR",
		"THREE_BAR",
		"CIRCLE",
		"TRIANGLE",
		"SQUARE",
		"FLAG",
		"THUMBS_UP",
		"THUMBS_DOWN",
		"CHECKMARK",
		"X",
	}
}

type IdentityStore string

// Enum values for IdentityStore
const (
	IdentityStoreQuicksight IdentityStore = "QUICKSIGHT"
)

// Values returns all known values for IdentityStore. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (IdentityStore) Values() []IdentityStore {
	return []IdentityStore{
		"QUICKSIGHT",
	}
}

type IdentityType string

// Enum values for IdentityType
const (
	IdentityTypeIam        IdentityType = "IAM"
	IdentityTypeQuicksight IdentityType = "QUICKSIGHT"
)

// Values returns all known values for IdentityType. Note that this can be expanded
// in the future, and so it is only as up to date as the client. The ordering of
// this slice is not guaranteed to be stable across updates.
func (IdentityType) Values() []IdentityType {
	return []IdentityType{
		"IAM",
		"QUICKSIGHT",
	}
}

type IngestionErrorType string

// Enum values for IngestionErrorType
const (
	IngestionErrorTypeFailureToAssumeRole             IngestionErrorType = "FAILURE_TO_ASSUME_ROLE"
	IngestionErrorTypeIngestionSuperseded             IngestionErrorType = "INGESTION_SUPERSEDED"
	IngestionErrorTypeIngestionCanceled               IngestionErrorType = "INGESTION_CANCELED"
	IngestionErrorTypeDataSetDeleted                  IngestionErrorType = "DATA_SET_DELETED"
	IngestionErrorTypeDataSetNotSpice                 IngestionErrorType = "DATA_SET_NOT_SPICE"
	IngestionErrorTypeS3UploadedFileDeleted           IngestionErrorType = "S3_UPLOADED_FILE_DELETED"
	IngestionErrorTypeS3ManifestError                 IngestionErrorType = "S3_MANIFEST_ERROR"
	IngestionErrorTypeDataToleranceException          IngestionErrorType = "DATA_TOLERANCE_EXCEPTION"
	IngestionErrorTypeSpiceTableNotFound              IngestionErrorType = "SPICE_TABLE_NOT_FOUND"
	IngestionErrorTypeDataSetSizeLimitExceeded        IngestionErrorType = "DATA_SET_SIZE_LIMIT_EXCEEDED"
	IngestionErrorTypeRowSizeLimitExceeded            IngestionErrorType = "ROW_SIZE_LIMIT_EXCEEDED"
	IngestionErrorTypeAccountCapacityLimitExceeded    IngestionErrorType = "ACCOUNT_CAPACITY_LIMIT_EXCEEDED"
	IngestionErrorTypeCustomerError                   IngestionErrorType = "CUSTOMER_ERROR"
	IngestionErrorTypeDataSourceNotFound              IngestionErrorType = "DATA_SOURCE_NOT_FOUND"
	IngestionErrorTypeIamRoleNotAvailable             IngestionErrorType = "IAM_ROLE_NOT_AVAILABLE"
	IngestionErrorTypeConnectionFailure               IngestionErrorType = "CONNECTION_FAILURE"
	IngestionErrorTypeSqlTableNotFound                IngestionErrorType = "SQL_TABLE_NOT_FOUND"
	IngestionErrorTypePermissionDenied                IngestionErrorType = "PERMISSION_DENIED"
	IngestionErrorTypeSslCertificateValidationFailure IngestionErrorType = "SSL_CERTIFICATE_VALIDATION_FAILURE"
	IngestionErrorTypeOauthTokenFailure               IngestionErrorType = "OAUTH_TOKEN_FAILURE"
	IngestionErrorTypeSourceApiLimitExceededFailure   IngestionErrorType = "SOURCE_API_LIMIT_EXCEEDED_FAILURE"
	IngestionErrorTypePasswordAuthenticationFailure   IngestionErrorType = "PASSWORD_AUTHENTICATION_FAILURE"
	IngestionErrorTypeSqlSchemaMismatchError          IngestionErrorType = "SQL_SCHEMA_MISMATCH_ERROR"
	IngestionErrorTypeInvalidDateFormat               IngestionErrorType = "INVALID_DATE_FORMAT"
	IngestionErrorTypeInvalidDataprepSyntax           IngestionErrorType = "INVALID_DATAPREP_SYNTAX"
	IngestionErrorTypeSourceResourceLimitExceeded     IngestionErrorType = "SOURCE_RESOURCE_LIMIT_EXCEEDED"
	IngestionErrorTypeSqlInvalidParameterValue        IngestionErrorType = "SQL_INVALID_PARAMETER_VALUE"
	IngestionErrorTypeQueryTimeout                    IngestionErrorType = "QUERY_TIMEOUT"
	IngestionErrorTypeSqlNumericOverflow              IngestionErrorType = "SQL_NUMERIC_OVERFLOW"
	IngestionErrorTypeUnresolvableHost                IngestionErrorType = "UNRESOLVABLE_HOST"
	IngestionErrorTypeUnroutableHost                  IngestionErrorType = "UNROUTABLE_HOST"
	IngestionErrorTypeSqlException                    IngestionErrorType = "SQL_EXCEPTION"
	IngestionErrorTypeS3FileInaccessible              IngestionErrorType = "S3_FILE_INACCESSIBLE"
	IngestionErrorTypeIotFileNotFound                 IngestionErrorType = "IOT_FILE_NOT_FOUND"
	IngestionErrorTypeIotDataSetFileEmpty             IngestionErrorType = "IOT_DATA_SET_FILE_EMPTY"
	IngestionErrorTypeInvalidDataSourceConfig         IngestionErrorType = "INVALID_DATA_SOURCE_CONFIG"
	IngestionErrorTypeDataSourceAuthFailed            IngestionErrorType = "DATA_SOURCE_AUTH_FAILED"
	IngestionErrorTypeDataSourceConnectionFailed      IngestionErrorType = "DATA_SOURCE_CONNECTION_FAILED"
	IngestionErrorTypeFailureToProcessJsonFile        IngestionErrorType = "FAILURE_TO_PROCESS_JSON_FILE"
	IngestionErrorTypeInternalServiceError            IngestionErrorType = "INTERNAL_SERVICE_ERROR"
	IngestionErrorTypeRefreshSuppressedByEdit         IngestionErrorType = "REFRESH_SUPPRESSED_BY_EDIT"
	IngestionErrorTypePermissionNotFound              IngestionErrorType = "PERMISSION_NOT_FOUND"
	IngestionErrorTypeElasticsearchCursorNotEnabled   IngestionErrorType = "ELASTICSEARCH_CURSOR_NOT_ENABLED"
	IngestionErrorTypeCursorNotEnabled                IngestionErrorType = "CURSOR_NOT_ENABLED"
	IngestionErrorTypeDuplicateColumnNamesFound       IngestionErrorType = "DUPLICATE_COLUMN_NAMES_FOUND"
)

// Values returns all known values for IngestionErrorType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (IngestionErrorType) Values() []IngestionErrorType {
	return []IngestionErrorType{
		"FAILURE_TO_ASSUME_ROLE",
		"INGESTION_SUPERSEDED",
		"INGESTION_CANCELED",
		"DATA_SET_DELETED",
		"DATA_SET_NOT_SPICE",
		"S3_UPLOADED_FILE_DELETED",
		"S3_MANIFEST_ERROR",
		"DATA_TOLERANCE_EXCEPTION",
		"SPICE_TABLE_NOT_FOUND",
		"DATA_SET_SIZE_LIMIT_EXCEEDED",
		"ROW_SIZE_LIMIT_EXCEEDED",
		"ACCOUNT_CAPACITY_LIMIT_EXCEEDED",
		"CUSTOMER_ERROR",
		"DATA_SOURCE_NOT_FOUND",
		"IAM_ROLE_NOT_AVAILABLE",
		"CONNECTION_FAILURE",
		"SQL_TABLE_NOT_FOUND",
		"PERMISSION_DENIED",
		"SSL_CERTIFICATE_VALIDATION_FAILURE",
		"OAUTH_TOKEN_FAILURE",
		"SOURCE_API_LIMIT_EXCEEDED_FAILURE",
		"PASSWORD_AUTHENTICATION_FAILURE",
		"SQL_SCHEMA_MISMATCH_ERROR",
		"INVALID_DATE_FORMAT",
		"INVALID_DATAPREP_SYNTAX",
		"SOURCE_RESOURCE_LIMIT_EXCEEDED",
		"SQL_INVALID_PARAMETER_VALUE",
		"QUERY_TIMEOUT",
		"SQL_NUMERIC_OVERFLOW",
		"UNRESOLVABLE_HOST",
		"UNROUTABLE_HOST",
		"SQL_EXCEPTION",
		"S3_FILE_INACCESSIBLE",
		"IOT_FILE_NOT_FOUND",
		"IOT_DATA_SET_FILE_EMPTY",
		"INVALID_DATA_SOURCE_CONFIG",
		"DATA_SOURCE_AUTH_FAILED",
		"DATA_SOURCE_CONNECTION_FAILED",
		"FAILURE_TO_PROCESS_JSON_FILE",
		"INTERNAL_SERVICE_ERROR",
		"REFRESH_SUPPRESSED_BY_EDIT",
		"PERMISSION_NOT_FOUND",
		"ELASTICSEARCH_CURSOR_NOT_ENABLED",
		"CURSOR_NOT_ENABLED",
		"DUPLICATE_COLUMN_NAMES_FOUND",
	}
}

type IngestionRequestSource string

// Enum values for IngestionRequestSource
const (
	IngestionRequestSourceManual    IngestionRequestSource = "MANUAL"
	IngestionRequestSourceScheduled IngestionRequestSource = "SCHEDULED"
)

// Values returns all known values for IngestionRequestSource. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (IngestionRequestSource) Values() []IngestionRequestSource {
	return []IngestionRequestSource{
		"MANUAL",
		"SCHEDULED",
	}
}

type IngestionRequestType string

// Enum values for IngestionRequestType
const (
	IngestionRequestTypeInitialIngestion   IngestionRequestType = "INITIAL_INGESTION"
	IngestionRequestTypeEdit               IngestionRequestType = "EDIT"
	IngestionRequestTypeIncrementalRefresh IngestionRequestType = "INCREMENTAL_REFRESH"
	IngestionRequestTypeFullRefresh        IngestionRequestType = "FULL_REFRESH"
)

// Values returns all known values for IngestionRequestType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (IngestionRequestType) Values() []IngestionRequestType {
	return []IngestionRequestType{
		"INITIAL_INGESTION",
		"EDIT",
		"INCREMENTAL_REFRESH",
		"FULL_REFRESH",
	}
}

type IngestionStatus string

// Enum values for IngestionStatus
const (
	IngestionStatusInitialized IngestionStatus = "INITIALIZED"
	IngestionStatusQueued      IngestionStatus = "QUEUED"
	IngestionStatusRunning     IngestionStatus = "RUNNING"
	IngestionStatusFailed      IngestionStatus = "FAILED"
	IngestionStatusCompleted   IngestionStatus = "COMPLETED"
	IngestionStatusCancelled   IngestionStatus = "CANCELLED"
)

// Values returns all known values for IngestionStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (IngestionStatus) Values() []IngestionStatus {
	return []IngestionStatus{
		"INITIALIZED",
		"QUEUED",
		"RUNNING",
		"FAILED",
		"COMPLETED",
		"CANCELLED",
	}
}

type IngestionType string

// Enum values for IngestionType
const (
	IngestionTypeIncrementalRefresh IngestionType = "INCREMENTAL_REFRESH"
	IngestionTypeFullRefresh        IngestionType = "FULL_REFRESH"
)

// Values returns all known values for IngestionType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (IngestionType) Values() []IngestionType {
	return []IngestionType{
		"INCREMENTAL_REFRESH",
		"FULL_REFRESH",
	}
}

type InputColumnDataType string

// Enum values for InputColumnDataType
const (
	InputColumnDataTypeString   InputColumnDataType = "STRING"
	InputColumnDataTypeInteger  InputColumnDataType = "INTEGER"
	InputColumnDataTypeDecimal  InputColumnDataType = "DECIMAL"
	InputColumnDataTypeDatetime InputColumnDataType = "DATETIME"
	InputColumnDataTypeBit      InputColumnDataType = "BIT"
	InputColumnDataTypeBoolean  InputColumnDataType = "BOOLEAN"
	InputColumnDataTypeJson     InputColumnDataType = "JSON"
)

// Values returns all known values for InputColumnDataType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (InputColumnDataType) Values() []InputColumnDataType {
	return []InputColumnDataType{
		"STRING",
		"INTEGER",
		"DECIMAL",
		"DATETIME",
		"BIT",
		"BOOLEAN",
		"JSON",
	}
}

type JoinType string

// Enum values for JoinType
const (
	JoinTypeInner JoinType = "INNER"
	JoinTypeOuter JoinType = "OUTER"
	JoinTypeLeft  JoinType = "LEFT"
	JoinTypeRight JoinType = "RIGHT"
)

// Values returns all known values for JoinType. Note that this can be expanded in
// the future, and so it is only as up to date as the client. The ordering of this
// slice is not guaranteed to be stable across updates.
func (JoinType) Values() []JoinType {
	return []JoinType{
		"INNER",
		"OUTER",
		"LEFT",
		"RIGHT",
	}
}

type LayoutElementType string

// Enum values for LayoutElementType
const (
	LayoutElementTypeVisual           LayoutElementType = "VISUAL"
	LayoutElementTypeFilterControl    LayoutElementType = "FILTER_CONTROL"
	LayoutElementTypeParameterControl LayoutElementType = "PARAMETER_CONTROL"
	LayoutElementTypeTextBox          LayoutElementType = "TEXT_BOX"
)

// Values returns all known values for LayoutElementType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (LayoutElementType) Values() []LayoutElementType {
	return []LayoutElementType{
		"VISUAL",
		"FILTER_CONTROL",
		"PARAMETER_CONTROL",
		"TEXT_BOX",
	}
}

type LegendPosition string

// Enum values for LegendPosition
const (
	LegendPositionAuto   LegendPosition = "AUTO"
	LegendPositionRight  LegendPosition = "RIGHT"
	LegendPositionBottom LegendPosition = "BOTTOM"
	LegendPositionTop    LegendPosition = "TOP"
)

// Values returns all known values for LegendPosition. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (LegendPosition) Values() []LegendPosition {
	return []LegendPosition{
		"AUTO",
		"RIGHT",
		"BOTTOM",
		"TOP",
	}
}

type LineChartLineStyle string

// Enum values for LineChartLineStyle
const (
	LineChartLineStyleSolid  LineChartLineStyle = "SOLID"
	LineChartLineStyleDotted LineChartLineStyle = "DOTTED"
	LineChartLineStyleDashed LineChartLineStyle = "DASHED"
)

// Values returns all known values for LineChartLineStyle. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (LineChartLineStyle) Values() []LineChartLineStyle {
	return []LineChartLineStyle{
		"SOLID",
		"DOTTED",
		"DASHED",
	}
}

type LineChartMarkerShape string

// Enum values for LineChartMarkerShape
const (
	LineChartMarkerShapeCircle        LineChartMarkerShape = "CIRCLE"
	LineChartMarkerShapeTriangle      LineChartMarkerShape = "TRIANGLE"
	LineChartMarkerShapeSquare        LineChartMarkerShape = "SQUARE"
	LineChartMarkerShapeDiamond       LineChartMarkerShape = "DIAMOND"
	LineChartMarkerShapeRoundedSquare LineChartMarkerShape = "ROUNDED_SQUARE"
)

// Values returns all known values for LineChartMarkerShape. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (LineChartMarkerShape) Values() []LineChartMarkerShape {
	return []LineChartMarkerShape{
		"CIRCLE",
		"TRIANGLE",
		"SQUARE",
		"DIAMOND",
		"ROUNDED_SQUARE",
	}
}

type LineChartType string

// Enum values for LineChartType
const (
	LineChartTypeLine        LineChartType = "LINE"
	LineChartTypeArea        LineChartType = "AREA"
	LineChartTypeStackedArea LineChartType = "STACKED_AREA"
)

// Values returns all known values for LineChartType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (LineChartType) Values() []LineChartType {
	return []LineChartType{
		"LINE",
		"AREA",
		"STACKED_AREA",
	}
}

type LineInterpolation string

// Enum values for LineInterpolation
const (
	LineInterpolationLinear  LineInterpolation = "LINEAR"
	LineInterpolationSmooth  LineInterpolation = "SMOOTH"
	LineInterpolationStepped LineInterpolation = "STEPPED"
)

// Values returns all known values for LineInterpolation. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (LineInterpolation) Values() []LineInterpolation {
	return []LineInterpolation{
		"LINEAR",
		"SMOOTH",
		"STEPPED",
	}
}

type LookbackWindowSizeUnit string

// Enum values for LookbackWindowSizeUnit
const (
	LookbackWindowSizeUnitHour LookbackWindowSizeUnit = "HOUR"
	LookbackWindowSizeUnitDay  LookbackWindowSizeUnit = "DAY"
	LookbackWindowSizeUnitWeek LookbackWindowSizeUnit = "WEEK"
)

// Values returns all known values for LookbackWindowSizeUnit. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (LookbackWindowSizeUnit) Values() []LookbackWindowSizeUnit {
	return []LookbackWindowSizeUnit{
		"HOUR",
		"DAY",
		"WEEK",
	}
}

type MapZoomMode string

// Enum values for MapZoomMode
const (
	MapZoomModeAuto   MapZoomMode = "AUTO"
	MapZoomModeManual MapZoomMode = "MANUAL"
)

// Values returns all known values for MapZoomMode. Note that this can be expanded
// in the future, and so it is only as up to date as the client. The ordering of
// this slice is not guaranteed to be stable across updates.
func (MapZoomMode) Values() []MapZoomMode {
	return []MapZoomMode{
		"AUTO",
		"MANUAL",
	}
}

type MaximumMinimumComputationType string

// Enum values for MaximumMinimumComputationType
const (
	MaximumMinimumComputationTypeMaximum MaximumMinimumComputationType = "MAXIMUM"
	MaximumMinimumComputationTypeMinimum MaximumMinimumComputationType = "MINIMUM"
)

// Values returns all known values for MaximumMinimumComputationType. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (MaximumMinimumComputationType) Values() []MaximumMinimumComputationType {
	return []MaximumMinimumComputationType{
		"MAXIMUM",
		"MINIMUM",
	}
}

type MemberType string

// Enum values for MemberType
const (
	MemberTypeDashboard MemberType = "DASHBOARD"
	MemberTypeAnalysis  MemberType = "ANALYSIS"
	MemberTypeDataset   MemberType = "DATASET"
)

// Values returns all known values for MemberType. Note that this can be expanded
// in the future, and so it is only as up to date as the client. The ordering of
// this slice is not guaranteed to be stable across updates.
func (MemberType) Values() []MemberType {
	return []MemberType{
		"DASHBOARD",
		"ANALYSIS",
		"DATASET",
	}
}

type MissingDataTreatmentOption string

// Enum values for MissingDataTreatmentOption
const (
	MissingDataTreatmentOptionInterpolate MissingDataTreatmentOption = "INTERPOLATE"
	MissingDataTreatmentOptionShowAsZero  MissingDataTreatmentOption = "SHOW_AS_ZERO"
	MissingDataTreatmentOptionShowAsBlank MissingDataTreatmentOption = "SHOW_AS_BLANK"
)

// Values returns all known values for MissingDataTreatmentOption. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
// The ordering of this slice is not guaranteed to be stable across updates.
func (MissingDataTreatmentOption) Values() []MissingDataTreatmentOption {
	return []MissingDataTreatmentOption{
		"INTERPOLATE",
		"SHOW_AS_ZERO",
		"SHOW_AS_BLANK",
	}
}

type NamespaceErrorType string

// Enum values for NamespaceErrorType
const (
	NamespaceErrorTypePermissionDenied     NamespaceErrorType = "PERMISSION_DENIED"
	NamespaceErrorTypeInternalServiceError NamespaceErrorType = "INTERNAL_SERVICE_ERROR"
)

// Values returns all known values for NamespaceErrorType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (NamespaceErrorType) Values() []NamespaceErrorType {
	return []NamespaceErrorType{
		"PERMISSION_DENIED",
		"INTERNAL_SERVICE_ERROR",
	}
}

type NamespaceStatus string

// Enum values for NamespaceStatus
const (
	NamespaceStatusCreated             NamespaceStatus = "CREATED"
	NamespaceStatusCreating            NamespaceStatus = "CREATING"
	NamespaceStatusDeleting            NamespaceStatus = "DELETING"
	NamespaceStatusRetryableFailure    NamespaceStatus = "RETRYABLE_FAILURE"
	NamespaceStatusNonRetryableFailure NamespaceStatus = "NON_RETRYABLE_FAILURE"
)

// Values returns all known values for NamespaceStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (NamespaceStatus) Values() []NamespaceStatus {
	return []NamespaceStatus{
		"CREATED",
		"CREATING",
		"DELETING",
		"RETRYABLE_FAILURE",
		"NON_RETRYABLE_FAILURE",
	}
}

type NegativeValueDisplayMode string

// Enum values for NegativeValueDisplayMode
const (
	NegativeValueDisplayModePositive NegativeValueDisplayMode = "POSITIVE"
	NegativeValueDisplayModeNegative NegativeValueDisplayMode = "NEGATIVE"
)

// Values returns all known values for NegativeValueDisplayMode. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (NegativeValueDisplayMode) Values() []NegativeValueDisplayMode {
	return []NegativeValueDisplayMode{
		"POSITIVE",
		"NEGATIVE",
	}
}

type NumberScale string

// Enum values for NumberScale
const (
	NumberScaleNone      NumberScale = "NONE"
	NumberScaleAuto      NumberScale = "AUTO"
	NumberScaleThousands NumberScale = "THOUSANDS"
	NumberScaleMillions  NumberScale = "MILLIONS"
	NumberScaleBillions  NumberScale = "BILLIONS"
	NumberScaleTrillions NumberScale = "TRILLIONS"
)

// Values returns all known values for NumberScale. Note that this can be expanded
// in the future, and so it is only as up to date as the client. The ordering of
// this slice is not guaranteed to be stable across updates.
func (NumberScale) Values() []NumberScale {
	return []NumberScale{
		"NONE",
		"AUTO",
		"THOUSANDS",
		"MILLIONS",
		"BILLIONS",
		"TRILLIONS",
	}
}

type NumericEqualityMatchOperator string

// Enum values for NumericEqualityMatchOperator
const (
	NumericEqualityMatchOperatorEquals       NumericEqualityMatchOperator = "EQUALS"
	NumericEqualityMatchOperatorDoesNotEqual NumericEqualityMatchOperator = "DOES_NOT_EQUAL"
)

// Values returns all known values for NumericEqualityMatchOperator. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
// The ordering of this slice is not guaranteed to be stable across updates.
func (NumericEqualityMatchOperator) Values() []NumericEqualityMatchOperator {
	return []NumericEqualityMatchOperator{
		"EQUALS",
		"DOES_NOT_EQUAL",
	}
}

type NumericFilterSelectAllOptions string

// Enum values for NumericFilterSelectAllOptions
const (
	NumericFilterSelectAllOptionsFilterAllValues NumericFilterSelectAllOptions = "FILTER_ALL_VALUES"
)

// Values returns all known values for NumericFilterSelectAllOptions. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (NumericFilterSelectAllOptions) Values() []NumericFilterSelectAllOptions {
	return []NumericFilterSelectAllOptions{
		"FILTER_ALL_VALUES",
	}
}

type NumericSeparatorSymbol string

// Enum values for NumericSeparatorSymbol
const (
	NumericSeparatorSymbolComma NumericSeparatorSymbol = "COMMA"
	NumericSeparatorSymbolDot   NumericSeparatorSymbol = "DOT"
	NumericSeparatorSymbolSpace NumericSeparatorSymbol = "SPACE"
)

// Values returns all known values for NumericSeparatorSymbol. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (NumericSeparatorSymbol) Values() []NumericSeparatorSymbol {
	return []NumericSeparatorSymbol{
		"COMMA",
		"DOT",
		"SPACE",
	}
}

type OtherCategories string

// Enum values for OtherCategories
const (
	OtherCategoriesInclude OtherCategories = "INCLUDE"
	OtherCategoriesExclude OtherCategories = "EXCLUDE"
)

// Values returns all known values for OtherCategories. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (OtherCategories) Values() []OtherCategories {
	return []OtherCategories{
		"INCLUDE",
		"EXCLUDE",
	}
}

type PanelBorderStyle string

// Enum values for PanelBorderStyle
const (
	PanelBorderStyleSolid  PanelBorderStyle = "SOLID"
	PanelBorderStyleDashed PanelBorderStyle = "DASHED"
	PanelBorderStyleDotted PanelBorderStyle = "DOTTED"
)

// Values returns all known values for PanelBorderStyle. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (PanelBorderStyle) Values() []PanelBorderStyle {
	return []PanelBorderStyle{
		"SOLID",
		"DASHED",
		"DOTTED",
	}
}

type PaperOrientation string

// Enum values for PaperOrientation
const (
	PaperOrientationPortrait  PaperOrientation = "PORTRAIT"
	PaperOrientationLandscape PaperOrientation = "LANDSCAPE"
)

// Values returns all known values for PaperOrientation. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (PaperOrientation) Values() []PaperOrientation {
	return []PaperOrientation{
		"PORTRAIT",
		"LANDSCAPE",
	}
}

type PaperSize string

// Enum values for PaperSize
const (
	PaperSizeUsLetter        PaperSize = "US_LETTER"
	PaperSizeUsLegal         PaperSize = "US_LEGAL"
	PaperSizeUsTabloidLedger PaperSize = "US_TABLOID_LEDGER"
	PaperSizeA0              PaperSize = "A0"
	PaperSizeA1              PaperSize = "A1"
	PaperSizeA2              PaperSize = "A2"
	PaperSizeA3              PaperSize = "A3"
	PaperSizeA4              PaperSize = "A4"
	PaperSizeA5              PaperSize = "A5"
	PaperSizeJisB4           PaperSize = "JIS_B4"
	PaperSizeJisB5           PaperSize = "JIS_B5"
)

// Values returns all known values for PaperSize. Note that this can be expanded in
// the future, and so it is only as up to date as the client. The ordering of this
// slice is not guaranteed to be stable across updates.
func (PaperSize) Values() []PaperSize {
	return []PaperSize{
		"US_LETTER",
		"US_LEGAL",
		"US_TABLOID_LEDGER",
		"A0",
		"A1",
		"A2",
		"A3",
		"A4",
		"A5",
		"JIS_B4",
		"JIS_B5",
	}
}

type ParameterValueType string

// Enum values for ParameterValueType
const (
	ParameterValueTypeMultiValued  ParameterValueType = "MULTI_VALUED"
	ParameterValueTypeSingleValued ParameterValueType = "SINGLE_VALUED"
)

// Values returns all known values for ParameterValueType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (ParameterValueType) Values() []ParameterValueType {
	return []ParameterValueType{
		"MULTI_VALUED",
		"SINGLE_VALUED",
	}
}

type PivotTableConditionalFormattingScopeRole string

// Enum values for PivotTableConditionalFormattingScopeRole
const (
	PivotTableConditionalFormattingScopeRoleField      PivotTableConditionalFormattingScopeRole = "FIELD"
	PivotTableConditionalFormattingScopeRoleFieldTotal PivotTableConditionalFormattingScopeRole = "FIELD_TOTAL"
	PivotTableConditionalFormattingScopeRoleGrandTotal PivotTableConditionalFormattingScopeRole = "GRAND_TOTAL"
)

// Values returns all known values for PivotTableConditionalFormattingScopeRole.
// Note that this can be expanded in the future, and so it is only as up to date as
// the client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (PivotTableConditionalFormattingScopeRole) Values() []PivotTableConditionalFormattingScopeRole {
	return []PivotTableConditionalFormattingScopeRole{
		"FIELD",
		"FIELD_TOTAL",
		"GRAND_TOTAL",
	}
}

type PivotTableMetricPlacement string

// Enum values for PivotTableMetricPlacement
const (
	PivotTableMetricPlacementRow    PivotTableMetricPlacement = "ROW"
	PivotTableMetricPlacementColumn PivotTableMetricPlacement = "COLUMN"
)

// Values returns all known values for PivotTableMetricPlacement. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
// The ordering of this slice is not guaranteed to be stable across updates.
func (PivotTableMetricPlacement) Values() []PivotTableMetricPlacement {
	return []PivotTableMetricPlacement{
		"ROW",
		"COLUMN",
	}
}

type PivotTableSubtotalLevel string

// Enum values for PivotTableSubtotalLevel
const (
	PivotTableSubtotalLevelAll    PivotTableSubtotalLevel = "ALL"
	PivotTableSubtotalLevelCustom PivotTableSubtotalLevel = "CUSTOM"
	PivotTableSubtotalLevelLast   PivotTableSubtotalLevel = "LAST"
)

// Values returns all known values for PivotTableSubtotalLevel. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (PivotTableSubtotalLevel) Values() []PivotTableSubtotalLevel {
	return []PivotTableSubtotalLevel{
		"ALL",
		"CUSTOM",
		"LAST",
	}
}

type PrimaryValueDisplayType string

// Enum values for PrimaryValueDisplayType
const (
	PrimaryValueDisplayTypeHidden     PrimaryValueDisplayType = "HIDDEN"
	PrimaryValueDisplayTypeComparison PrimaryValueDisplayType = "COMPARISON"
	PrimaryValueDisplayTypeActual     PrimaryValueDisplayType = "ACTUAL"
)

// Values returns all known values for PrimaryValueDisplayType. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (PrimaryValueDisplayType) Values() []PrimaryValueDisplayType {
	return []PrimaryValueDisplayType{
		"HIDDEN",
		"COMPARISON",
		"ACTUAL",
	}
}

type RadarChartShape string

// Enum values for RadarChartShape
const (
	RadarChartShapeCircle  RadarChartShape = "CIRCLE"
	RadarChartShapePolygon RadarChartShape = "POLYGON"
)

// Values returns all known values for RadarChartShape. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (RadarChartShape) Values() []RadarChartShape {
	return []RadarChartShape{
		"CIRCLE",
		"POLYGON",
	}
}

type ReferenceLineLabelHorizontalPosition string

// Enum values for ReferenceLineLabelHorizontalPosition
const (
	ReferenceLineLabelHorizontalPositionLeft   ReferenceLineLabelHorizontalPosition = "LEFT"
	ReferenceLineLabelHorizontalPositionCenter ReferenceLineLabelHorizontalPosition = "CENTER"
	ReferenceLineLabelHorizontalPositionRight  ReferenceLineLabelHorizontalPosition = "RIGHT"
)

// Values returns all known values for ReferenceLineLabelHorizontalPosition. Note
// that this can be expanded in the future, and so it is only as up to date as the
// client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (ReferenceLineLabelHorizontalPosition) Values() []ReferenceLineLabelHorizontalPosition {
	return []ReferenceLineLabelHorizontalPosition{
		"LEFT",
		"CENTER",
		"RIGHT",
	}
}

type ReferenceLineLabelVerticalPosition string

// Enum values for ReferenceLineLabelVerticalPosition
const (
	ReferenceLineLabelVerticalPositionAbove ReferenceLineLabelVerticalPosition = "ABOVE"
	ReferenceLineLabelVerticalPositionBelow ReferenceLineLabelVerticalPosition = "BELOW"
)

// Values returns all known values for ReferenceLineLabelVerticalPosition. Note
// that this can be expanded in the future, and so it is only as up to date as the
// client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (ReferenceLineLabelVerticalPosition) Values() []ReferenceLineLabelVerticalPosition {
	return []ReferenceLineLabelVerticalPosition{
		"ABOVE",
		"BELOW",
	}
}

type ReferenceLinePatternType string

// Enum values for ReferenceLinePatternType
const (
	ReferenceLinePatternTypeSolid  ReferenceLinePatternType = "SOLID"
	ReferenceLinePatternTypeDashed ReferenceLinePatternType = "DASHED"
	ReferenceLinePatternTypeDotted ReferenceLinePatternType = "DOTTED"
)

// Values returns all known values for ReferenceLinePatternType. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (ReferenceLinePatternType) Values() []ReferenceLinePatternType {
	return []ReferenceLinePatternType{
		"SOLID",
		"DASHED",
		"DOTTED",
	}
}

type ReferenceLineValueLabelRelativePosition string

// Enum values for ReferenceLineValueLabelRelativePosition
const (
	ReferenceLineValueLabelRelativePositionBeforeCustomLabel ReferenceLineValueLabelRelativePosition = "BEFORE_CUSTOM_LABEL"
	ReferenceLineValueLabelRelativePositionAfterCustomLabel  ReferenceLineValueLabelRelativePosition = "AFTER_CUSTOM_LABEL"
)

// Values returns all known values for ReferenceLineValueLabelRelativePosition.
// Note that this can be expanded in the future, and so it is only as up to date as
// the client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (ReferenceLineValueLabelRelativePosition) Values() []ReferenceLineValueLabelRelativePosition {
	return []ReferenceLineValueLabelRelativePosition{
		"BEFORE_CUSTOM_LABEL",
		"AFTER_CUSTOM_LABEL",
	}
}

type RefreshInterval string

// Enum values for RefreshInterval
const (
	RefreshIntervalMinute15 RefreshInterval = "MINUTE15"
	RefreshIntervalMinute30 RefreshInterval = "MINUTE30"
	RefreshIntervalHourly   RefreshInterval = "HOURLY"
	RefreshIntervalDaily    RefreshInterval = "DAILY"
	RefreshIntervalWeekly   RefreshInterval = "WEEKLY"
	RefreshIntervalMonthly  RefreshInterval = "MONTHLY"
)

// Values returns all known values for RefreshInterval. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (RefreshInterval) Values() []RefreshInterval {
	return []RefreshInterval{
		"MINUTE15",
		"MINUTE30",
		"HOURLY",
		"DAILY",
		"WEEKLY",
		"MONTHLY",
	}
}

type RelativeDateType string

// Enum values for RelativeDateType
const (
	RelativeDateTypePrevious RelativeDateType = "PREVIOUS"
	RelativeDateTypeThis     RelativeDateType = "THIS"
	RelativeDateTypeLast     RelativeDateType = "LAST"
	RelativeDateTypeNow      RelativeDateType = "NOW"
	RelativeDateTypeNext     RelativeDateType = "NEXT"
)

// Values returns all known values for RelativeDateType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (RelativeDateType) Values() []RelativeDateType {
	return []RelativeDateType{
		"PREVIOUS",
		"THIS",
		"LAST",
		"NOW",
		"NEXT",
	}
}

type RelativeFontSize string

// Enum values for RelativeFontSize
const (
	RelativeFontSizeExtraSmall RelativeFontSize = "EXTRA_SMALL"
	RelativeFontSizeSmall      RelativeFontSize = "SMALL"
	RelativeFontSizeMedium     RelativeFontSize = "MEDIUM"
	RelativeFontSizeLarge      RelativeFontSize = "LARGE"
	RelativeFontSizeExtraLarge RelativeFontSize = "EXTRA_LARGE"
)

// Values returns all known values for RelativeFontSize. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (RelativeFontSize) Values() []RelativeFontSize {
	return []RelativeFontSize{
		"EXTRA_SMALL",
		"SMALL",
		"MEDIUM",
		"LARGE",
		"EXTRA_LARGE",
	}
}

type ResizeOption string

// Enum values for ResizeOption
const (
	ResizeOptionFixed      ResizeOption = "FIXED"
	ResizeOptionResponsive ResizeOption = "RESPONSIVE"
)

// Values returns all known values for ResizeOption. Note that this can be expanded
// in the future, and so it is only as up to date as the client. The ordering of
// this slice is not guaranteed to be stable across updates.
func (ResizeOption) Values() []ResizeOption {
	return []ResizeOption{
		"FIXED",
		"RESPONSIVE",
	}
}

type ResourceStatus string

// Enum values for ResourceStatus
const (
	ResourceStatusCreationInProgress ResourceStatus = "CREATION_IN_PROGRESS"
	ResourceStatusCreationSuccessful ResourceStatus = "CREATION_SUCCESSFUL"
	ResourceStatusCreationFailed     ResourceStatus = "CREATION_FAILED"
	ResourceStatusUpdateInProgress   ResourceStatus = "UPDATE_IN_PROGRESS"
	ResourceStatusUpdateSuccessful   ResourceStatus = "UPDATE_SUCCESSFUL"
	ResourceStatusUpdateFailed       ResourceStatus = "UPDATE_FAILED"
	ResourceStatusDeleted            ResourceStatus = "DELETED"
)

// Values returns all known values for ResourceStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (ResourceStatus) Values() []ResourceStatus {
	return []ResourceStatus{
		"CREATION_IN_PROGRESS",
		"CREATION_SUCCESSFUL",
		"CREATION_FAILED",
		"UPDATE_IN_PROGRESS",
		"UPDATE_SUCCESSFUL",
		"UPDATE_FAILED",
		"DELETED",
	}
}

type RowLevelPermissionFormatVersion string

// Enum values for RowLevelPermissionFormatVersion
const (
	RowLevelPermissionFormatVersionVersion1 RowLevelPermissionFormatVersion = "VERSION_1"
	RowLevelPermissionFormatVersionVersion2 RowLevelPermissionFormatVersion = "VERSION_2"
)

// Values returns all known values for RowLevelPermissionFormatVersion. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (RowLevelPermissionFormatVersion) Values() []RowLevelPermissionFormatVersion {
	return []RowLevelPermissionFormatVersion{
		"VERSION_1",
		"VERSION_2",
	}
}

type RowLevelPermissionPolicy string

// Enum values for RowLevelPermissionPolicy
const (
	RowLevelPermissionPolicyGrantAccess RowLevelPermissionPolicy = "GRANT_ACCESS"
	RowLevelPermissionPolicyDenyAccess  RowLevelPermissionPolicy = "DENY_ACCESS"
)

// Values returns all known values for RowLevelPermissionPolicy. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (RowLevelPermissionPolicy) Values() []RowLevelPermissionPolicy {
	return []RowLevelPermissionPolicy{
		"GRANT_ACCESS",
		"DENY_ACCESS",
	}
}

type SectionPageBreakStatus string

// Enum values for SectionPageBreakStatus
const (
	SectionPageBreakStatusEnabled  SectionPageBreakStatus = "ENABLED"
	SectionPageBreakStatusDisabled SectionPageBreakStatus = "DISABLED"
)

// Values returns all known values for SectionPageBreakStatus. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (SectionPageBreakStatus) Values() []SectionPageBreakStatus {
	return []SectionPageBreakStatus{
		"ENABLED",
		"DISABLED",
	}
}

type SelectAllValueOptions string

// Enum values for SelectAllValueOptions
const (
	SelectAllValueOptionsAllValues SelectAllValueOptions = "ALL_VALUES"
)

// Values returns all known values for SelectAllValueOptions. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (SelectAllValueOptions) Values() []SelectAllValueOptions {
	return []SelectAllValueOptions{
		"ALL_VALUES",
	}
}

type SelectedFieldOptions string

// Enum values for SelectedFieldOptions
const (
	SelectedFieldOptionsAllFields SelectedFieldOptions = "ALL_FIELDS"
)

// Values returns all known values for SelectedFieldOptions. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (SelectedFieldOptions) Values() []SelectedFieldOptions {
	return []SelectedFieldOptions{
		"ALL_FIELDS",
	}
}

type SelectedTooltipType string

// Enum values for SelectedTooltipType
const (
	SelectedTooltipTypeBasic    SelectedTooltipType = "BASIC"
	SelectedTooltipTypeDetailed SelectedTooltipType = "DETAILED"
)

// Values returns all known values for SelectedTooltipType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (SelectedTooltipType) Values() []SelectedTooltipType {
	return []SelectedTooltipType{
		"BASIC",
		"DETAILED",
	}
}

type SheetContentType string

// Enum values for SheetContentType
const (
	SheetContentTypePaginated   SheetContentType = "PAGINATED"
	SheetContentTypeInteractive SheetContentType = "INTERACTIVE"
)

// Values returns all known values for SheetContentType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (SheetContentType) Values() []SheetContentType {
	return []SheetContentType{
		"PAGINATED",
		"INTERACTIVE",
	}
}

type SheetControlDateTimePickerType string

// Enum values for SheetControlDateTimePickerType
const (
	SheetControlDateTimePickerTypeSingleValued SheetControlDateTimePickerType = "SINGLE_VALUED"
	SheetControlDateTimePickerTypeDateRange    SheetControlDateTimePickerType = "DATE_RANGE"
)

// Values returns all known values for SheetControlDateTimePickerType. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (SheetControlDateTimePickerType) Values() []SheetControlDateTimePickerType {
	return []SheetControlDateTimePickerType{
		"SINGLE_VALUED",
		"DATE_RANGE",
	}
}

type SheetControlListType string

// Enum values for SheetControlListType
const (
	SheetControlListTypeMultiSelect  SheetControlListType = "MULTI_SELECT"
	SheetControlListTypeSingleSelect SheetControlListType = "SINGLE_SELECT"
)

// Values returns all known values for SheetControlListType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (SheetControlListType) Values() []SheetControlListType {
	return []SheetControlListType{
		"MULTI_SELECT",
		"SINGLE_SELECT",
	}
}

type SheetControlSliderType string

// Enum values for SheetControlSliderType
const (
	SheetControlSliderTypeSinglePoint SheetControlSliderType = "SINGLE_POINT"
	SheetControlSliderTypeRange       SheetControlSliderType = "RANGE"
)

// Values returns all known values for SheetControlSliderType. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (SheetControlSliderType) Values() []SheetControlSliderType {
	return []SheetControlSliderType{
		"SINGLE_POINT",
		"RANGE",
	}
}

type SimpleNumericalAggregationFunction string

// Enum values for SimpleNumericalAggregationFunction
const (
	SimpleNumericalAggregationFunctionSum           SimpleNumericalAggregationFunction = "SUM"
	SimpleNumericalAggregationFunctionAverage       SimpleNumericalAggregationFunction = "AVERAGE"
	SimpleNumericalAggregationFunctionMin           SimpleNumericalAggregationFunction = "MIN"
	SimpleNumericalAggregationFunctionMax           SimpleNumericalAggregationFunction = "MAX"
	SimpleNumericalAggregationFunctionCount         SimpleNumericalAggregationFunction = "COUNT"
	SimpleNumericalAggregationFunctionDistinctCount SimpleNumericalAggregationFunction = "DISTINCT_COUNT"
	SimpleNumericalAggregationFunctionVar           SimpleNumericalAggregationFunction = "VAR"
	SimpleNumericalAggregationFunctionVarp          SimpleNumericalAggregationFunction = "VARP"
	SimpleNumericalAggregationFunctionStdev         SimpleNumericalAggregationFunction = "STDEV"
	SimpleNumericalAggregationFunctionStdevp        SimpleNumericalAggregationFunction = "STDEVP"
	SimpleNumericalAggregationFunctionMedian        SimpleNumericalAggregationFunction = "MEDIAN"
)

// Values returns all known values for SimpleNumericalAggregationFunction. Note
// that this can be expanded in the future, and so it is only as up to date as the
// client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (SimpleNumericalAggregationFunction) Values() []SimpleNumericalAggregationFunction {
	return []SimpleNumericalAggregationFunction{
		"SUM",
		"AVERAGE",
		"MIN",
		"MAX",
		"COUNT",
		"DISTINCT_COUNT",
		"VAR",
		"VARP",
		"STDEV",
		"STDEVP",
		"MEDIAN",
	}
}

type SortDirection string

// Enum values for SortDirection
const (
	SortDirectionAsc  SortDirection = "ASC"
	SortDirectionDesc SortDirection = "DESC"
)

// Values returns all known values for SortDirection. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (SortDirection) Values() []SortDirection {
	return []SortDirection{
		"ASC",
		"DESC",
	}
}

type Status string

// Enum values for Status
const (
	StatusEnabled  Status = "ENABLED"
	StatusDisabled Status = "DISABLED"
)

// Values returns all known values for Status. Note that this can be expanded in
// the future, and so it is only as up to date as the client. The ordering of this
// slice is not guaranteed to be stable across updates.
func (Status) Values() []Status {
	return []Status{
		"ENABLED",
		"DISABLED",
	}
}

type TableBorderStyle string

// Enum values for TableBorderStyle
const (
	TableBorderStyleNone  TableBorderStyle = "NONE"
	TableBorderStyleSolid TableBorderStyle = "SOLID"
)

// Values returns all known values for TableBorderStyle. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (TableBorderStyle) Values() []TableBorderStyle {
	return []TableBorderStyle{
		"NONE",
		"SOLID",
	}
}

type TableCellImageScalingConfiguration string

// Enum values for TableCellImageScalingConfiguration
const (
	TableCellImageScalingConfigurationFitToCellHeight TableCellImageScalingConfiguration = "FIT_TO_CELL_HEIGHT"
	TableCellImageScalingConfigurationFitToCellWidth  TableCellImageScalingConfiguration = "FIT_TO_CELL_WIDTH"
	TableCellImageScalingConfigurationDoNotScale      TableCellImageScalingConfiguration = "DO_NOT_SCALE"
)

// Values returns all known values for TableCellImageScalingConfiguration. Note
// that this can be expanded in the future, and so it is only as up to date as the
// client. The ordering of this slice is not guaranteed to be stable across
// updates.
func (TableCellImageScalingConfiguration) Values() []TableCellImageScalingConfiguration {
	return []TableCellImageScalingConfiguration{
		"FIT_TO_CELL_HEIGHT",
		"FIT_TO_CELL_WIDTH",
		"DO_NOT_SCALE",
	}
}

type TableFieldIconSetType string

// Enum values for TableFieldIconSetType
const (
	TableFieldIconSetTypeLink TableFieldIconSetType = "LINK"
)

// Values returns all known values for TableFieldIconSetType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (TableFieldIconSetType) Values() []TableFieldIconSetType {
	return []TableFieldIconSetType{
		"LINK",
	}
}

type TableOrientation string

// Enum values for TableOrientation
const (
	TableOrientationVertical   TableOrientation = "VERTICAL"
	TableOrientationHorizontal TableOrientation = "HORIZONTAL"
)

// Values returns all known values for TableOrientation. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (TableOrientation) Values() []TableOrientation {
	return []TableOrientation{
		"VERTICAL",
		"HORIZONTAL",
	}
}

type TableTotalsPlacement string

// Enum values for TableTotalsPlacement
const (
	TableTotalsPlacementStart TableTotalsPlacement = "START"
	TableTotalsPlacementEnd   TableTotalsPlacement = "END"
)

// Values returns all known values for TableTotalsPlacement. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (TableTotalsPlacement) Values() []TableTotalsPlacement {
	return []TableTotalsPlacement{
		"START",
		"END",
	}
}

type TableTotalsScrollStatus string

// Enum values for TableTotalsScrollStatus
const (
	TableTotalsScrollStatusPinned   TableTotalsScrollStatus = "PINNED"
	TableTotalsScrollStatusScrolled TableTotalsScrollStatus = "SCROLLED"
)

// Values returns all known values for TableTotalsScrollStatus. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (TableTotalsScrollStatus) Values() []TableTotalsScrollStatus {
	return []TableTotalsScrollStatus{
		"PINNED",
		"SCROLLED",
	}
}

type TargetVisualOptions string

// Enum values for TargetVisualOptions
const (
	TargetVisualOptionsAllVisuals TargetVisualOptions = "ALL_VISUALS"
)

// Values returns all known values for TargetVisualOptions. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (TargetVisualOptions) Values() []TargetVisualOptions {
	return []TargetVisualOptions{
		"ALL_VISUALS",
	}
}

type TemplateErrorType string

// Enum values for TemplateErrorType
const (
	TemplateErrorTypeSourceNotFound  TemplateErrorType = "SOURCE_NOT_FOUND"
	TemplateErrorTypeDataSetNotFound TemplateErrorType = "DATA_SET_NOT_FOUND"
	TemplateErrorTypeInternalFailure TemplateErrorType = "INTERNAL_FAILURE"
	TemplateErrorTypeAccessDenied    TemplateErrorType = "ACCESS_DENIED"
)

// Values returns all known values for TemplateErrorType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (TemplateErrorType) Values() []TemplateErrorType {
	return []TemplateErrorType{
		"SOURCE_NOT_FOUND",
		"DATA_SET_NOT_FOUND",
		"INTERNAL_FAILURE",
		"ACCESS_DENIED",
	}
}

type TextQualifier string

// Enum values for TextQualifier
const (
	TextQualifierDoubleQuote TextQualifier = "DOUBLE_QUOTE"
	TextQualifierSingleQuote TextQualifier = "SINGLE_QUOTE"
)

// Values returns all known values for TextQualifier. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (TextQualifier) Values() []TextQualifier {
	return []TextQualifier{
		"DOUBLE_QUOTE",
		"SINGLE_QUOTE",
	}
}

type TextWrap string

// Enum values for TextWrap
const (
	TextWrapNone TextWrap = "NONE"
	TextWrapWrap TextWrap = "WRAP"
)

// Values returns all known values for TextWrap. Note that this can be expanded in
// the future, and so it is only as up to date as the client. The ordering of this
// slice is not guaranteed to be stable across updates.
func (TextWrap) Values() []TextWrap {
	return []TextWrap{
		"NONE",
		"WRAP",
	}
}

type ThemeErrorType string

// Enum values for ThemeErrorType
const (
	ThemeErrorTypeInternalFailure ThemeErrorType = "INTERNAL_FAILURE"
)

// Values returns all known values for ThemeErrorType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (ThemeErrorType) Values() []ThemeErrorType {
	return []ThemeErrorType{
		"INTERNAL_FAILURE",
	}
}

type ThemeType string

// Enum values for ThemeType
const (
	ThemeTypeQuicksight ThemeType = "QUICKSIGHT"
	ThemeTypeCustom     ThemeType = "CUSTOM"
	ThemeTypeAll        ThemeType = "ALL"
)

// Values returns all known values for ThemeType. Note that this can be expanded in
// the future, and so it is only as up to date as the client. The ordering of this
// slice is not guaranteed to be stable across updates.
func (ThemeType) Values() []ThemeType {
	return []ThemeType{
		"QUICKSIGHT",
		"CUSTOM",
		"ALL",
	}
}

type TimeGranularity string

// Enum values for TimeGranularity
const (
	TimeGranularityYear        TimeGranularity = "YEAR"
	TimeGranularityQuarter     TimeGranularity = "QUARTER"
	TimeGranularityMonth       TimeGranularity = "MONTH"
	TimeGranularityWeek        TimeGranularity = "WEEK"
	TimeGranularityDay         TimeGranularity = "DAY"
	TimeGranularityHour        TimeGranularity = "HOUR"
	TimeGranularityMinute      TimeGranularity = "MINUTE"
	TimeGranularitySecond      TimeGranularity = "SECOND"
	TimeGranularityMillisecond TimeGranularity = "MILLISECOND"
)

// Values returns all known values for TimeGranularity. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (TimeGranularity) Values() []TimeGranularity {
	return []TimeGranularity{
		"YEAR",
		"QUARTER",
		"MONTH",
		"WEEK",
		"DAY",
		"HOUR",
		"MINUTE",
		"SECOND",
		"MILLISECOND",
	}
}

type TooltipTitleType string

// Enum values for TooltipTitleType
const (
	TooltipTitleTypeNone         TooltipTitleType = "NONE"
	TooltipTitleTypePrimaryValue TooltipTitleType = "PRIMARY_VALUE"
)

// Values returns all known values for TooltipTitleType. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (TooltipTitleType) Values() []TooltipTitleType {
	return []TooltipTitleType{
		"NONE",
		"PRIMARY_VALUE",
	}
}

type TopBottomComputationType string

// Enum values for TopBottomComputationType
const (
	TopBottomComputationTypeTop    TopBottomComputationType = "TOP"
	TopBottomComputationTypeBottom TopBottomComputationType = "BOTTOM"
)

// Values returns all known values for TopBottomComputationType. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (TopBottomComputationType) Values() []TopBottomComputationType {
	return []TopBottomComputationType{
		"TOP",
		"BOTTOM",
	}
}

type TopBottomSortOrder string

// Enum values for TopBottomSortOrder
const (
	TopBottomSortOrderPercentDifference  TopBottomSortOrder = "PERCENT_DIFFERENCE"
	TopBottomSortOrderAbsoluteDifference TopBottomSortOrder = "ABSOLUTE_DIFFERENCE"
)

// Values returns all known values for TopBottomSortOrder. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (TopBottomSortOrder) Values() []TopBottomSortOrder {
	return []TopBottomSortOrder{
		"PERCENT_DIFFERENCE",
		"ABSOLUTE_DIFFERENCE",
	}
}

type URLTargetConfiguration string

// Enum values for URLTargetConfiguration
const (
	URLTargetConfigurationNewTab    URLTargetConfiguration = "NEW_TAB"
	URLTargetConfigurationNewWindow URLTargetConfiguration = "NEW_WINDOW"
	URLTargetConfigurationSameTab   URLTargetConfiguration = "SAME_TAB"
)

// Values returns all known values for URLTargetConfiguration. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (URLTargetConfiguration) Values() []URLTargetConfiguration {
	return []URLTargetConfiguration{
		"NEW_TAB",
		"NEW_WINDOW",
		"SAME_TAB",
	}
}

type UserRole string

// Enum values for UserRole
const (
	UserRoleAdmin            UserRole = "ADMIN"
	UserRoleAuthor           UserRole = "AUTHOR"
	UserRoleReader           UserRole = "READER"
	UserRoleRestrictedAuthor UserRole = "RESTRICTED_AUTHOR"
	UserRoleRestrictedReader UserRole = "RESTRICTED_READER"
)

// Values returns all known values for UserRole. Note that this can be expanded in
// the future, and so it is only as up to date as the client. The ordering of this
// slice is not guaranteed to be stable across updates.
func (UserRole) Values() []UserRole {
	return []UserRole{
		"ADMIN",
		"AUTHOR",
		"READER",
		"RESTRICTED_AUTHOR",
		"RESTRICTED_READER",
	}
}

type ValueWhenUnsetOption string

// Enum values for ValueWhenUnsetOption
const (
	ValueWhenUnsetOptionRecommendedValue ValueWhenUnsetOption = "RECOMMENDED_VALUE"
	ValueWhenUnsetOptionNull             ValueWhenUnsetOption = "NULL"
)

// Values returns all known values for ValueWhenUnsetOption. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (ValueWhenUnsetOption) Values() []ValueWhenUnsetOption {
	return []ValueWhenUnsetOption{
		"RECOMMENDED_VALUE",
		"NULL",
	}
}

type VerticalTextAlignment string

// Enum values for VerticalTextAlignment
const (
	VerticalTextAlignmentTop    VerticalTextAlignment = "TOP"
	VerticalTextAlignmentMiddle VerticalTextAlignment = "MIDDLE"
	VerticalTextAlignmentBottom VerticalTextAlignment = "BOTTOM"
)

// Values returns all known values for VerticalTextAlignment. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (VerticalTextAlignment) Values() []VerticalTextAlignment {
	return []VerticalTextAlignment{
		"TOP",
		"MIDDLE",
		"BOTTOM",
	}
}

type Visibility string

// Enum values for Visibility
const (
	VisibilityHidden  Visibility = "HIDDEN"
	VisibilityVisible Visibility = "VISIBLE"
)

// Values returns all known values for Visibility. Note that this can be expanded
// in the future, and so it is only as up to date as the client. The ordering of
// this slice is not guaranteed to be stable across updates.
func (Visibility) Values() []Visibility {
	return []Visibility{
		"HIDDEN",
		"VISIBLE",
	}
}

type VisualCustomActionTrigger string

// Enum values for VisualCustomActionTrigger
const (
	VisualCustomActionTriggerDataPointClick VisualCustomActionTrigger = "DATA_POINT_CLICK"
	VisualCustomActionTriggerDataPointMenu  VisualCustomActionTrigger = "DATA_POINT_MENU"
)

// Values returns all known values for VisualCustomActionTrigger. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
// The ordering of this slice is not guaranteed to be stable across updates.
func (VisualCustomActionTrigger) Values() []VisualCustomActionTrigger {
	return []VisualCustomActionTrigger{
		"DATA_POINT_CLICK",
		"DATA_POINT_MENU",
	}
}

type WidgetStatus string

// Enum values for WidgetStatus
const (
	WidgetStatusEnabled  WidgetStatus = "ENABLED"
	WidgetStatusDisabled WidgetStatus = "DISABLED"
)

// Values returns all known values for WidgetStatus. Note that this can be expanded
// in the future, and so it is only as up to date as the client. The ordering of
// this slice is not guaranteed to be stable across updates.
func (WidgetStatus) Values() []WidgetStatus {
	return []WidgetStatus{
		"ENABLED",
		"DISABLED",
	}
}

type WordCloudCloudLayout string

// Enum values for WordCloudCloudLayout
const (
	WordCloudCloudLayoutFluid  WordCloudCloudLayout = "FLUID"
	WordCloudCloudLayoutNormal WordCloudCloudLayout = "NORMAL"
)

// Values returns all known values for WordCloudCloudLayout. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (WordCloudCloudLayout) Values() []WordCloudCloudLayout {
	return []WordCloudCloudLayout{
		"FLUID",
		"NORMAL",
	}
}

type WordCloudWordCasing string

// Enum values for WordCloudWordCasing
const (
	WordCloudWordCasingLowerCase    WordCloudWordCasing = "LOWER_CASE"
	WordCloudWordCasingExistingCase WordCloudWordCasing = "EXISTING_CASE"
)

// Values returns all known values for WordCloudWordCasing. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (WordCloudWordCasing) Values() []WordCloudWordCasing {
	return []WordCloudWordCasing{
		"LOWER_CASE",
		"EXISTING_CASE",
	}
}

type WordCloudWordOrientation string

// Enum values for WordCloudWordOrientation
const (
	WordCloudWordOrientationHorizontal            WordCloudWordOrientation = "HORIZONTAL"
	WordCloudWordOrientationHorizontalAndVertical WordCloudWordOrientation = "HORIZONTAL_AND_VERTICAL"
)

// Values returns all known values for WordCloudWordOrientation. Note that this can
// be expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (WordCloudWordOrientation) Values() []WordCloudWordOrientation {
	return []WordCloudWordOrientation{
		"HORIZONTAL",
		"HORIZONTAL_AND_VERTICAL",
	}
}

type WordCloudWordPadding string

// Enum values for WordCloudWordPadding
const (
	WordCloudWordPaddingNone   WordCloudWordPadding = "NONE"
	WordCloudWordPaddingSmall  WordCloudWordPadding = "SMALL"
	WordCloudWordPaddingMedium WordCloudWordPadding = "MEDIUM"
	WordCloudWordPaddingLarge  WordCloudWordPadding = "LARGE"
)

// Values returns all known values for WordCloudWordPadding. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (WordCloudWordPadding) Values() []WordCloudWordPadding {
	return []WordCloudWordPadding{
		"NONE",
		"SMALL",
		"MEDIUM",
		"LARGE",
	}
}

type WordCloudWordScaling string

// Enum values for WordCloudWordScaling
const (
	WordCloudWordScalingEmphasize WordCloudWordScaling = "EMPHASIZE"
	WordCloudWordScalingNormal    WordCloudWordScaling = "NORMAL"
)

// Values returns all known values for WordCloudWordScaling. Note that this can be
// expanded in the future, and so it is only as up to date as the client. The
// ordering of this slice is not guaranteed to be stable across updates.
func (WordCloudWordScaling) Values() []WordCloudWordScaling {
	return []WordCloudWordScaling{
		"EMPHASIZE",
		"NORMAL",
	}
}
