// Code generated by smithy-go-codegen DO NOT EDIT.

// Package networkfirewall provides the API client, operations, and parameter types
// for AWS Network Firewall.
//
// This is the API Reference for Network Firewall. This guide is for developers who
// need detailed information about the Network Firewall API actions, data types,
// and errors.
//
// * The REST API requires you to handle connection details, such as
// calculating signatures, handling request retries, and error handling. For
// general information about using the Amazon Web Services REST APIs, see Amazon
// Web Services APIs (https://docs.aws.amazon.com/general/latest/gr/aws-apis.html).
// To access Network Firewall using the REST API endpoint:
// https://network-firewall..amazonaws.com
//
// * Alternatively, you can use one of the
// Amazon Web Services SDKs to access an API that's tailored to the programming
// language or platform that you're using. For more information, see Amazon Web
// Services SDKs (http://aws.amazon.com/tools/#SDKs).
//
// * For descriptions of
// Network Firewall features, including and step-by-step instructions on how to use
// them through the Network Firewall console, see the Network Firewall Developer
// Guide
// (https://docs.aws.amazon.com/network-firewall/latest/developerguide/).
//
// Network
// Firewall is a stateful, managed, network firewall and intrusion detection and
// prevention service for Amazon Virtual Private Cloud (Amazon VPC). With Network
// Firewall, you can filter traffic at the perimeter of your VPC. This includes
// filtering traffic going to and coming from an internet gateway, NAT gateway, or
// over VPN or Direct Connect. Network Firewall uses rules that are compatible with
// Suricata, a free, open source network analysis and threat detection engine.
// Network Firewall supports Suricata version 6.0.9. For information about
// Suricata, see the Suricata website (https://suricata.io/). You can use Network
// Firewall to monitor and protect your VPC traffic in a number of ways. The
// following are just a few examples:
//
// * Allow domains or IP addresses for known
// Amazon Web Services service endpoints, such as Amazon S3, and block all other
// forms of traffic.
//
// * Use custom lists of known bad domains to limit the types of
// domain names that your applications can access.
//
// * Perform deep packet
// inspection on traffic entering or leaving your VPC.
//
// * Use stateful protocol
// detection to filter protocols like HTTPS, regardless of the port used.
//
// To
// enable Network Firewall for your VPCs, you perform steps in both Amazon VPC and
// in Network Firewall. For information about using Amazon VPC, see Amazon VPC User
// Guide (https://docs.aws.amazon.com/vpc/latest/userguide/). To start using
// Network Firewall, do the following:
//
// * (Optional) If you don't already have a
// VPC that you want to protect, create it in Amazon VPC.
//
// * In Amazon VPC, in each
// Availability Zone where you want to have a firewall endpoint, create a subnet
// for the sole use of Network Firewall.
//
// * In Network Firewall, create stateless
// and stateful rule groups, to define the components of the network traffic
// filtering behavior that you want your firewall to have.
//
// * In Network Firewall,
// create a firewall policy that uses your rule groups and specifies additional
// default traffic filtering behavior.
//
// * In Network Firewall, create a firewall
// and specify your new firewall policy and VPC subnets. Network Firewall creates a
// firewall endpoint in each subnet that you specify, with the behavior that's
// defined in the firewall policy.
//
// * In Amazon VPC, use ingress routing
// enhancements to route traffic through the new firewall endpoints.
package networkfirewall
