// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Object specifying a participant token in a stage.
type ParticipantToken struct {

	// Application-provided attributes to encode into the token and attach to a stage.
	// This field is exposed to all stage participants and should not be used for
	// personally identifying, confidential, or sensitive information.
	Attributes map[string]string

	// Set of capabilities that the user is allowed to perform in the stage.
	Capabilities []ParticipantTokenCapability

	// Duration (in minutes), after which the participant token expires. Default: 60 (1
	// hour).
	Duration int32

	// ISO 8601 timestamp (returned as a string) for when this token expires.
	ExpirationTime *time.Time

	// Unique identifier for this participant token, assigned by IVS.
	ParticipantId *string

	// The issued client token, encrypted.
	Token *string

	// Name to help identify the token. This can be any UTF-8 encoded text. This field
	// is exposed to all stage participants and should not be used for personally
	// identifying, confidential, or sensitive information.
	UserId *string

	noSmithyDocumentSerde
}

// Object specifying a participant token configuration in a stage.
type ParticipantTokenConfiguration struct {

	// Application-provided attributes to encode into the corresponding participant
	// token and attach to a stage. Map keys and values can contain UTF-8 encoded text.
	// The maximum length of this field is 1 KB total. This field is exposed to all
	// stage participants and should not be used for personally identifying,
	// confidential, or sensitive information.
	Attributes map[string]string

	// Set of capabilities that the user is allowed to perform in the stage.
	Capabilities []ParticipantTokenCapability

	// Duration (in minutes), after which the corresponding participant token expires.
	// Default: 60 (1 hour).
	Duration int32

	// Name that can be specified to help identify the corresponding participant token.
	// This can be any UTF-8 encoded text. This field is exposed to all stage
	// participants and should not be used for personally identifying, confidential, or
	// sensitive information.
	UserId *string

	noSmithyDocumentSerde
}

// Object specifying a stage.
type Stage struct {

	// Stage ARN.
	//
	// This member is required.
	Arn *string

	// ID of the active session within the stage.
	ActiveSessionId *string

	// Stage name.
	Name *string

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources
	// (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for details,
	// including restrictions that apply to tags and "Tag naming limits and
	// requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Summary information about a stage.
type StageSummary struct {

	// Stage ARN.
	//
	// This member is required.
	Arn *string

	// ID of the active session within the stage.
	ActiveSessionId *string

	// Stage name.
	Name *string

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources
	// (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for details,
	// including restrictions that apply to tags and "Tag naming limits and
	// requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
