// Code generated by smithy-go-codegen DO NOT EDIT.

package guardduty

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/guardduty/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Configures the delegated administrator account with the provided values. You
// must provide the value for either autoEnableOrganizationMembers or autoEnable.
// There might be regional differences because some data sources might not be
// available in all the Amazon Web Services Regions where GuardDuty is presently
// supported. For more information, see Regions and endpoints
// (https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html).
func (c *Client) UpdateOrganizationConfiguration(ctx context.Context, params *UpdateOrganizationConfigurationInput, optFns ...func(*Options)) (*UpdateOrganizationConfigurationOutput, error) {
	if params == nil {
		params = &UpdateOrganizationConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateOrganizationConfiguration", params, optFns, c.addOperationUpdateOrganizationConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateOrganizationConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateOrganizationConfigurationInput struct {

	// The ID of the detector that configures the delegated administrator.
	//
	// This member is required.
	DetectorId *string

	// Indicates whether to automatically enable member accounts in the organization.
	// Even though this is still supported, we recommend using
	// AutoEnableOrganizationMembers to achieve the similar results.
	//
	// Deprecated: This field is deprecated, use AutoEnableOrganizationMembers instead
	AutoEnable bool

	// Indicates the auto-enablement configuration of GuardDuty for the member accounts
	// in the organization.
	//
	// * NEW: Indicates that when a new account joins the
	// organization, they will have GuardDuty enabled automatically.
	//
	// * ALL: Indicates
	// that all accounts in the Amazon Web Services Organization have GuardDuty enabled
	// automatically. This includes NEW accounts that join the organization and
	// accounts that may have been suspended or removed from the organization in
	// GuardDuty.
	//
	// * NONE: Indicates that GuardDuty will not be automatically enabled
	// for any accounts in the organization. GuardDuty must be managed for each account
	// individually by the administrator.
	AutoEnableOrganizationMembers types.AutoEnableMembers

	// Describes which data sources will be updated.
	//
	// Deprecated: This parameter is deprecated, use Features instead
	DataSources *types.OrganizationDataSourceConfigurations

	// A list of features that will be configured for the organization.
	Features []types.OrganizationFeatureConfiguration

	noSmithyDocumentSerde
}

type UpdateOrganizationConfigurationOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateOrganizationConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateOrganizationConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateOrganizationConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateOrganizationConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateOrganizationConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateOrganizationConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "guardduty",
		OperationName: "UpdateOrganizationConfiguration",
	}
}
