// Code generated by smithy-go-codegen DO NOT EDIT.

package fms

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/fms/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Disassociates resources from a Firewall Manager resource set.
func (c *Client) BatchDisassociateResource(ctx context.Context, params *BatchDisassociateResourceInput, optFns ...func(*Options)) (*BatchDisassociateResourceOutput, error) {
	if params == nil {
		params = &BatchDisassociateResourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchDisassociateResource", params, optFns, c.addOperationBatchDisassociateResourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchDisassociateResourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchDisassociateResourceInput struct {

	// The uniform resource identifiers (URI) of resources that should be disassociated
	// from the resource set. The URIs must be Amazon Resource Names (ARNs).
	//
	// This member is required.
	Items []string

	// A unique identifier for the resource set, used in a TODO to refer to the
	// resource set.
	//
	// This member is required.
	ResourceSetIdentifier *string

	noSmithyDocumentSerde
}

type BatchDisassociateResourceOutput struct {

	// The resources that failed to disassociate from the resource set.
	//
	// This member is required.
	FailedItems []types.FailedItem

	// A unique identifier for the resource set, used in a TODO to refer to the
	// resource set.
	//
	// This member is required.
	ResourceSetIdentifier *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchDisassociateResourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpBatchDisassociateResource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpBatchDisassociateResource{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpBatchDisassociateResourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchDisassociateResource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchDisassociateResource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "fms",
		OperationName: "BatchDisassociateResource",
	}
}
