// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The entity representing certificate data generated for managed endpoint.
type Certificate struct {

	// The ARN of the certificate generated for managed endpoint.
	CertificateArn *string

	// The base64 encoded PEM certificate data generated for managed endpoint.
	CertificateData *string

	noSmithyDocumentSerde
}

// A configuration for CloudWatch monitoring. You can configure your jobs to send
// log information to CloudWatch Logs.
type CloudWatchMonitoringConfiguration struct {

	// The name of the log group for log publishing.
	//
	// This member is required.
	LogGroupName *string

	// The specified name prefix for log streams.
	LogStreamNamePrefix *string

	noSmithyDocumentSerde
}

// A configuration specification to be used when provisioning virtual clusters,
// which can include configurations for applications and software bundled with
// Amazon EMR on EKS. A configuration consists of a classification, properties, and
// optional nested configurations. A classification refers to an
// application-specific configuration file. Properties are the settings you want to
// change in that file.
type Configuration struct {

	// The classification within a configuration.
	//
	// This member is required.
	Classification *string

	// A list of additional configurations to apply within a configuration object.
	Configurations []Configuration

	// A set of properties specified within a configuration classification.
	Properties map[string]string

	noSmithyDocumentSerde
}

// A configuration specification to be used to override existing configurations.
type ConfigurationOverrides struct {

	// The configurations for the application running by the job run.
	ApplicationConfiguration []Configuration

	// The configurations for monitoring.
	MonitoringConfiguration *MonitoringConfiguration

	noSmithyDocumentSerde
}

// The information about the container used for a job run or a managed endpoint.
//
// The following types satisfy this interface:
//
//	ContainerInfoMemberEksInfo
type ContainerInfo interface {
	isContainerInfo()
}

// The information about the Amazon EKS cluster.
type ContainerInfoMemberEksInfo struct {
	Value EksInfo

	noSmithyDocumentSerde
}

func (*ContainerInfoMemberEksInfo) isContainerInfo() {}

// The information about the container provider.
type ContainerProvider struct {

	// The ID of the container cluster.
	//
	// This member is required.
	Id *string

	// The type of the container provider. Amazon EKS is the only supported type as of
	// now.
	//
	// This member is required.
	Type ContainerProviderType

	// The information about the container cluster.
	Info ContainerInfo

	noSmithyDocumentSerde
}

// The information about the Amazon EKS cluster.
type EksInfo struct {

	// The namespaces of the Amazon EKS cluster.
	Namespace *string

	noSmithyDocumentSerde
}

// This entity represents the endpoint that is managed by Amazon EMR on EKS.
type Endpoint struct {

	// The ARN of the endpoint.
	Arn *string

	// The certificate ARN of the endpoint. This field is under deprecation and will be
	// removed in future.
	//
	// Deprecated: Customer provided certificate-arn is deprecated and would be removed
	// in future.
	CertificateArn *string

	// The certificate generated by emr control plane on customer behalf to secure the
	// managed endpoint.
	CertificateAuthority *Certificate

	// The configuration settings that are used to override existing configurations for
	// endpoints.
	ConfigurationOverrides *ConfigurationOverrides

	// The date and time when the endpoint was created.
	CreatedAt *time.Time

	// The execution role ARN of the endpoint.
	ExecutionRoleArn *string

	// The reasons why the endpoint has failed.
	FailureReason FailureReason

	// The ID of the endpoint.
	Id *string

	// The name of the endpoint.
	Name *string

	// The EMR release version to be used for the endpoint.
	ReleaseLabel *string

	// The security group configuration of the endpoint.
	SecurityGroup *string

	// The server URL of the endpoint.
	ServerUrl *string

	// The state of the endpoint.
	State EndpointState

	// Additional details of the endpoint state.
	StateDetails *string

	// The subnet IDs of the endpoint.
	SubnetIds []string

	// The tags of the endpoint.
	Tags map[string]string

	// The type of the endpoint.
	Type *string

	// The ID of the endpoint's virtual cluster.
	VirtualClusterId *string

	noSmithyDocumentSerde
}

// Specify the driver that the job runs on. Exactly one of the two available job
// drivers is required, either sparkSqlJobDriver or sparkSubmitJobDriver.
type JobDriver struct {

	// The job driver for job type.
	SparkSqlJobDriver *SparkSqlJobDriver

	// The job driver parameters specified for spark submit.
	SparkSubmitJobDriver *SparkSubmitJobDriver

	noSmithyDocumentSerde
}

// This entity describes a job run. A job run is a unit of work, such as a Spark
// jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
type JobRun struct {

	// The ARN of job run.
	Arn *string

	// The client token used to start a job run.
	ClientToken *string

	// The configuration settings that are used to override default configuration.
	ConfigurationOverrides *ConfigurationOverrides

	// The date and time when the job run was created.
	CreatedAt *time.Time

	// The user who created the job run.
	CreatedBy *string

	// The execution role ARN of the job run.
	ExecutionRoleArn *string

	// The reasons why the job run has failed.
	FailureReason FailureReason

	// The date and time when the job run has finished.
	FinishedAt *time.Time

	// The ID of the job run.
	Id *string

	// Parameters of job driver for the job run.
	JobDriver *JobDriver

	// The name of the job run.
	Name *string

	// The release version of Amazon EMR.
	ReleaseLabel *string

	// The configuration of the retry policy that the job runs on.
	RetryPolicyConfiguration *RetryPolicyConfiguration

	// The current status of the retry policy executed on the job.
	RetryPolicyExecution *RetryPolicyExecution

	// The state of the job run.
	State JobRunState

	// Additional details of the job run state.
	StateDetails *string

	// The assigned tags of the job run.
	Tags map[string]string

	// The ID of the job run's virtual cluster.
	VirtualClusterId *string

	noSmithyDocumentSerde
}

// This entity describes a job template. Job template stores values of StartJobRun
// API request in a template and can be used to start a job run. Job template
// allows two use cases: avoid repeating recurring StartJobRun API request values,
// enforcing certain values in StartJobRun API request.
type JobTemplate struct {

	// The job template data which holds values of StartJobRun API request.
	//
	// This member is required.
	JobTemplateData *JobTemplateData

	// The ARN of the job template.
	Arn *string

	// The date and time when the job template was created.
	CreatedAt *time.Time

	// The user who created the job template.
	CreatedBy *string

	// The error message in case the decryption of job template fails.
	DecryptionError *string

	// The ID of the job template.
	Id *string

	// The KMS key ARN used to encrypt the job template.
	KmsKeyArn *string

	// The name of the job template.
	Name *string

	// The tags assigned to the job template.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The values of StartJobRun API requests used in job runs started using the job
// template.
type JobTemplateData struct {

	// The execution role ARN of the job run.
	//
	// This member is required.
	ExecutionRoleArn *string

	// Specify the driver that the job runs on. Exactly one of the two available job
	// drivers is required, either sparkSqlJobDriver or sparkSubmitJobDriver.
	//
	// This member is required.
	JobDriver *JobDriver

	// The release version of Amazon EMR.
	//
	// This member is required.
	ReleaseLabel *string

	// The configuration settings that are used to override defaults configuration.
	ConfigurationOverrides *ParametricConfigurationOverrides

	// The tags assigned to jobs started using the job template.
	JobTags map[string]string

	// The configuration of parameters existing in the job template.
	ParameterConfiguration map[string]TemplateParameterConfiguration

	noSmithyDocumentSerde
}

// Configuration setting for monitoring.
type MonitoringConfiguration struct {

	// Monitoring configurations for CloudWatch.
	CloudWatchMonitoringConfiguration *CloudWatchMonitoringConfiguration

	// Monitoring configurations for the persistent application UI.
	PersistentAppUI PersistentAppUI

	// Amazon S3 configuration for monitoring log publishing.
	S3MonitoringConfiguration *S3MonitoringConfiguration

	noSmithyDocumentSerde
}

// A configuration for CloudWatch monitoring. You can configure your jobs to send
// log information to CloudWatch Logs. This data type allows job template
// parameters to be specified within.
type ParametricCloudWatchMonitoringConfiguration struct {

	// The name of the log group for log publishing.
	LogGroupName *string

	// The specified name prefix for log streams.
	LogStreamNamePrefix *string

	noSmithyDocumentSerde
}

// A configuration specification to be used to override existing configurations.
// This data type allows job template parameters to be specified within.
type ParametricConfigurationOverrides struct {

	// The configurations for the application running by the job run.
	ApplicationConfiguration []Configuration

	// The configurations for monitoring.
	MonitoringConfiguration *ParametricMonitoringConfiguration

	noSmithyDocumentSerde
}

// Configuration setting for monitoring. This data type allows job template
// parameters to be specified within.
type ParametricMonitoringConfiguration struct {

	// Monitoring configurations for CloudWatch.
	CloudWatchMonitoringConfiguration *ParametricCloudWatchMonitoringConfiguration

	// Monitoring configurations for the persistent application UI.
	PersistentAppUI *string

	// Amazon S3 configuration for monitoring log publishing.
	S3MonitoringConfiguration *ParametricS3MonitoringConfiguration

	noSmithyDocumentSerde
}

// Amazon S3 configuration for monitoring log publishing. You can configure your
// jobs to send log information to Amazon S3. This data type allows job template
// parameters to be specified within.
type ParametricS3MonitoringConfiguration struct {

	// Amazon S3 destination URI for log publishing.
	LogUri *string

	noSmithyDocumentSerde
}

// The configuration of the retry policy that the job runs on.
type RetryPolicyConfiguration struct {

	// The maximum number of attempts on the job's driver.
	//
	// This member is required.
	MaxAttempts *int32

	noSmithyDocumentSerde
}

// The current status of the retry policy executed on the job.
type RetryPolicyExecution struct {

	// The current number of attempts made on the driver of the job.
	//
	// This member is required.
	CurrentAttemptCount *int32

	noSmithyDocumentSerde
}

// Amazon S3 configuration for monitoring log publishing. You can configure your
// jobs to send log information to Amazon S3.
type S3MonitoringConfiguration struct {

	// Amazon S3 destination URI for log publishing.
	//
	// This member is required.
	LogUri *string

	noSmithyDocumentSerde
}

// The job driver for job type.
type SparkSqlJobDriver struct {

	// The SQL file to be executed.
	EntryPoint *string

	// The Spark parameters to be included in the Spark SQL command.
	SparkSqlParameters *string

	noSmithyDocumentSerde
}

// The information about job driver for Spark submit.
type SparkSubmitJobDriver struct {

	// The entry point of job application.
	//
	// This member is required.
	EntryPoint *string

	// The arguments for job application.
	EntryPointArguments []string

	// The Spark submit parameters that are used for job runs.
	SparkSubmitParameters *string

	noSmithyDocumentSerde
}

// The configuration of a job template parameter.
type TemplateParameterConfiguration struct {

	// The default value for the job template parameter.
	DefaultValue *string

	// The type of the job template parameter. Allowed values are: ‘STRING’, ‘NUMBER’.
	Type TemplateParameterDataType

	noSmithyDocumentSerde
}

// This entity describes a virtual cluster. A virtual cluster is a Kubernetes
// namespace that Amazon EMR is registered with. Amazon EMR uses virtual clusters
// to run jobs and host endpoints. Multiple virtual clusters can be backed by the
// same physical cluster. However, each virtual cluster maps to one namespace on an
// Amazon EKS cluster. Virtual clusters do not create any active resources that
// contribute to your bill or that require lifecycle management outside the
// service.
type VirtualCluster struct {

	// The ARN of the virtual cluster.
	Arn *string

	// The container provider of the virtual cluster.
	ContainerProvider *ContainerProvider

	// The date and time when the virtual cluster is created.
	CreatedAt *time.Time

	// The ID of the virtual cluster.
	Id *string

	// The name of the virtual cluster.
	Name *string

	// The state of the virtual cluster.
	State VirtualClusterState

	// The assigned tags of the virtual cluster.
	Tags map[string]string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isContainerInfo() {}
