// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// The definition of AWS Cost and Usage Report. You can specify the report name,
// time unit, report format, compression format, S3 bucket, additional artifacts,
// and schema elements in the definition.
type ReportDefinition struct {

	// A list of strings that indicate additional content that Amazon Web Services
	// includes in the report, such as individual resource IDs.
	//
	// This member is required.
	AdditionalSchemaElements []SchemaElement

	// The compression format that AWS uses for the report.
	//
	// This member is required.
	Compression CompressionFormat

	// The format that AWS saves the report in.
	//
	// This member is required.
	Format ReportFormat

	// The name of the report that you want to create. The name must be unique, is case
	// sensitive, and can't include spaces.
	//
	// This member is required.
	ReportName *string

	// The S3 bucket where AWS delivers the report.
	//
	// This member is required.
	S3Bucket *string

	// The prefix that AWS adds to the report name when AWS delivers the report. Your
	// prefix can't include spaces.
	//
	// This member is required.
	S3Prefix *string

	// The region of the S3 bucket that AWS delivers the report into.
	//
	// This member is required.
	S3Region AWSRegion

	// The length of time covered by the report.
	//
	// This member is required.
	TimeUnit TimeUnit

	// A list of manifests that you want Amazon Web Services to create for this report.
	AdditionalArtifacts []AdditionalArtifact

	// The Amazon resource name of the billing view. You can get this value by using
	// the billing view service public APIs.
	BillingViewArn *string

	// Whether you want Amazon Web Services to update your reports after they have been
	// finalized if Amazon Web Services detects charges related to previous months.
	// These charges can include refunds, credits, or support fees.
	RefreshClosedReports *bool

	// Whether you want Amazon Web Services to overwrite the previous version of each
	// report or to deliver the report in addition to the previous versions.
	ReportVersioning ReportVersioning

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
