// Code generated by smithy-go-codegen DO NOT EDIT.

package comprehend

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/comprehend/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieve the configuration properties of a flywheel iteration. For more
// information about flywheels, see  Flywheel overview
// (https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the
// Amazon Comprehend Developer Guide.
func (c *Client) DescribeFlywheelIteration(ctx context.Context, params *DescribeFlywheelIterationInput, optFns ...func(*Options)) (*DescribeFlywheelIterationOutput, error) {
	if params == nil {
		params = &DescribeFlywheelIterationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeFlywheelIteration", params, optFns, c.addOperationDescribeFlywheelIterationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeFlywheelIterationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeFlywheelIterationInput struct {

	//
	//
	// This member is required.
	FlywheelArn *string

	//
	//
	// This member is required.
	FlywheelIterationId *string

	noSmithyDocumentSerde
}

type DescribeFlywheelIterationOutput struct {

	// The configuration properties of a flywheel iteration.
	FlywheelIterationProperties *types.FlywheelIterationProperties

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeFlywheelIterationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeFlywheelIteration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeFlywheelIteration{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeFlywheelIterationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeFlywheelIteration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeFlywheelIteration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "comprehend",
		OperationName: "DescribeFlywheelIteration",
	}
}
