// Code generated by smithy-go-codegen DO NOT EDIT.

package chimesdkmediapipelines

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets the configuration settings for a media insights pipeline.
func (c *Client) GetMediaInsightsPipelineConfiguration(ctx context.Context, params *GetMediaInsightsPipelineConfigurationInput, optFns ...func(*Options)) (*GetMediaInsightsPipelineConfigurationOutput, error) {
	if params == nil {
		params = &GetMediaInsightsPipelineConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetMediaInsightsPipelineConfiguration", params, optFns, c.addOperationGetMediaInsightsPipelineConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetMediaInsightsPipelineConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetMediaInsightsPipelineConfigurationInput struct {

	// The unique identifier of the requested resource. Valid values include the name
	// and ARN of the media insights pipeline configuration.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetMediaInsightsPipelineConfigurationOutput struct {

	// The requested media insights pipeline configuration.
	MediaInsightsPipelineConfiguration *types.MediaInsightsPipelineConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetMediaInsightsPipelineConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetMediaInsightsPipelineConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetMediaInsightsPipelineConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetMediaInsightsPipelineConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetMediaInsightsPipelineConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetMediaInsightsPipelineConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "chime",
		OperationName: "GetMediaInsightsPipelineConfiguration",
	}
}
