# The following Ragel file was autogenerated with unicode2ragel.rb 
# from: http://www.unicode.org/Public/9.0.0/ucd/auxiliary/GraphemeBreakProperty.txt
#
# It defines ["Prepend", "CR", "LF", "Control", "Extend", "Regional_Indicator", "SpacingMark", "L", "V", "T", "LV", "LVT", "E_Base", "E_Modifier", "ZWJ", "Glue_After_Zwj", "E_Base_GAZ"].
#
# To use this, make sure that your alphtype is set to byte,
# and that your input is in utf8.

%%{
    machine GraphemeCluster;
    
    Prepend = 
        0xD8 0x80..0x85         #Cf   [6] ARABIC NUMBER SIGN..ARABIC NUMBER ...
      | 0xDB 0x9D               #Cf       ARABIC END OF AYAH
      | 0xDC 0x8F               #Cf       SYRIAC ABBREVIATION MARK
      | 0xE0 0xA3 0xA2          #Cf       ARABIC DISPUTED END OF AYAH
      | 0xE0 0xB5 0x8E          #Lo       MALAYALAM LETTER DOT REPH
      | 0xF0 0x91 0x82 0xBD     #Cf       KAITHI NUMBER SIGN
      | 0xF0 0x91 0x87 0x82..0x83  #Lo   [2] SHARADA SIGN JIHVAMULIYA..SHARA...
      ;

    CR = 
        0x0D                    #Cc       <control-000D>
      ;

    LF = 
        0x0A                    #Cc       <control-000A>
      ;

    Control = 
        0x00..0x09              #Cc  [10] <control-0000>..<control-0009>
      | 0x0B..0x0C              #Cc   [2] <control-000B>..<control-000C>
      | 0x0E..0x1F              #Cc  [18] <control-000E>..<control-001F>
      | 0x7F                    #Cc  [33] <control-007F>..<control-009F>
      | 0xC2 0x80..0x9F         #
      | 0xC2 0xAD               #Cf       SOFT HYPHEN
      | 0xD8 0x9C               #Cf       ARABIC LETTER MARK
      | 0xE1 0xA0 0x8E          #Cf       MONGOLIAN VOWEL SEPARATOR
      | 0xE2 0x80 0x8B          #Cf       ZERO WIDTH SPACE
      | 0xE2 0x80 0x8E..0x8F    #Cf   [2] LEFT-TO-RIGHT MARK..RIGHT-TO-LEFT ...
      | 0xE2 0x80 0xA8          #Zl       LINE SEPARATOR
      | 0xE2 0x80 0xA9          #Zp       PARAGRAPH SEPARATOR
      | 0xE2 0x80 0xAA..0xAE    #Cf   [5] LEFT-TO-RIGHT EMBEDDING..RIGHT-TO-...
      | 0xE2 0x81 0xA0..0xA4    #Cf   [5] WORD JOINER..INVISIBLE PLUS
      | 0xE2 0x81 0xA5          #Cn       <reserved-2065>
      | 0xE2 0x81 0xA6..0xAF    #Cf  [10] LEFT-TO-RIGHT ISOLATE..NOMINAL DIG...
      | 0xED 0xA0 0x80..0xFF        #Cs [2048] <surrogate-D800>..<surrogate-...
      | 0xED 0xA1..0xBE 0x00..0xFF  #
      | 0xED 0xBF 0x00..0xBF        #
      | 0xEF 0xBB 0xBF          #Cf       ZERO WIDTH NO-BREAK SPACE
      | 0xEF 0xBF 0xB0..0xB8    #Cn   [9] <reserved-FFF0>..<reserved-FFF8>
      | 0xEF 0xBF 0xB9..0xBB    #Cf   [3] INTERLINEAR ANNOTATION ANCHOR..INT...
      | 0xF0 0x9B 0xB2 0xA0..0xA3  #Cf   [4] SHORTHAND FORMAT LETTER OVERLAP...
      | 0xF0 0x9D 0x85 0xB3..0xBA  #Cf   [8] MUSICAL SYMBOL BEGIN BEAM..MUSI...
      | 0xF3 0xA0 0x80 0x80     #Cn       <reserved-E0000>
      | 0xF3 0xA0 0x80 0x81     #Cf       LANGUAGE TAG
      | 0xF3 0xA0 0x80 0x82..0x9F  #Cn  [30] <reserved-E0002>..<reserved-E001F>
      | 0xF3 0xA0 0x82 0x80..0xFF  #Cn [128] <reserved-E0080>..<reserved-E00FF>
      | 0xF3 0xA0 0x83 0x00..0xBF  #
      | 0xF3 0xA0 0x87 0xB0..0xFF        #Cn [3600] <reserved-E01F0>..<reser...
      | 0xF3 0xA0 0x88..0xBE 0x00..0xFF  #
      | 0xF3 0xA0 0xBF 0x00..0xBF        #
      ;

    Extend = 
        0xCC 0x80..0xFF         #Mn [112] COMBINING GRAVE ACCENT..COMBINING ...
      | 0xCD 0x00..0xAF         #
      | 0xD2 0x83..0x87         #Mn   [5] COMBINING CYRILLIC TITLO..COMBININ...
      | 0xD2 0x88..0x89         #Me   [2] COMBINING CYRILLIC HUNDRED THOUSAN...
      | 0xD6 0x91..0xBD         #Mn  [45] HEBREW ACCENT ETNAHTA..HEBREW POIN...
      | 0xD6 0xBF               #Mn       HEBREW POINT RAFE
      | 0xD7 0x81..0x82         #Mn   [2] HEBREW POINT SHIN DOT..HEBREW POIN...
      | 0xD7 0x84..0x85         #Mn   [2] HEBREW MARK UPPER DOT..HEBREW MARK...
      | 0xD7 0x87               #Mn       HEBREW POINT QAMATS QATAN
      | 0xD8 0x90..0x9A         #Mn  [11] ARABIC SIGN SALLALLAHOU ALAYHE WAS...
      | 0xD9 0x8B..0x9F         #Mn  [21] ARABIC FATHATAN..ARABIC WAVY HAMZA...
      | 0xD9 0xB0               #Mn       ARABIC LETTER SUPERSCRIPT ALEF
      | 0xDB 0x96..0x9C         #Mn   [7] ARABIC SMALL HIGH LIGATURE SAD WIT...
      | 0xDB 0x9F..0xA4         #Mn   [6] ARABIC SMALL HIGH ROUNDED ZERO..AR...
      | 0xDB 0xA7..0xA8         #Mn   [2] ARABIC SMALL HIGH YEH..ARABIC SMAL...
      | 0xDB 0xAA..0xAD         #Mn   [4] ARABIC EMPTY CENTRE LOW STOP..ARAB...
      | 0xDC 0x91               #Mn       SYRIAC LETTER SUPERSCRIPT ALAPH
      | 0xDC 0xB0..0xFF         #Mn  [27] SYRIAC PTHAHA ABOVE..SYRIAC BARREKH
      | 0xDD 0x00..0x8A         #
      | 0xDE 0xA6..0xB0         #Mn  [11] THAANA ABAFILI..THAANA SUKUN
      | 0xDF 0xAB..0xB3         #Mn   [9] NKO COMBINING SHORT HIGH TONE..NKO...
      | 0xE0 0xA0 0x96..0x99    #Mn   [4] SAMARITAN MARK IN..SAMARITAN MARK ...
      | 0xE0 0xA0 0x9B..0xA3    #Mn   [9] SAMARITAN MARK EPENTHETIC YUT..SAM...
      | 0xE0 0xA0 0xA5..0xA7    #Mn   [3] SAMARITAN VOWEL SIGN SHORT A..SAMA...
      | 0xE0 0xA0 0xA9..0xAD    #Mn   [5] SAMARITAN VOWEL SIGN LONG I..SAMAR...
      | 0xE0 0xA1 0x99..0x9B    #Mn   [3] MANDAIC AFFRICATION MARK..MANDAIC ...
      | 0xE0 0xA3 0x94..0xA1    #Mn  [14] ARABIC SMALL HIGH WORD AR-RUB..ARA...
      | 0xE0 0xA3 0xA3..0xFF    #Mn  [32] ARABIC TURNED DAMMA BELOW..DEVANAG...
      | 0xE0 0xA4 0x00..0x82    #
      | 0xE0 0xA4 0xBA          #Mn       DEVANAGARI VOWEL SIGN OE
      | 0xE0 0xA4 0xBC          #Mn       DEVANAGARI SIGN NUKTA
      | 0xE0 0xA5 0x81..0x88    #Mn   [8] DEVANAGARI VOWEL SIGN U..DEVANAGAR...
      | 0xE0 0xA5 0x8D          #Mn       DEVANAGARI SIGN VIRAMA
      | 0xE0 0xA5 0x91..0x97    #Mn   [7] DEVANAGARI STRESS SIGN UDATTA..DEV...
      | 0xE0 0xA5 0xA2..0xA3    #Mn   [2] DEVANAGARI VOWEL SIGN VOCALIC L..D...
      | 0xE0 0xA6 0x81          #Mn       BENGALI SIGN CANDRABINDU
      | 0xE0 0xA6 0xBC          #Mn       BENGALI SIGN NUKTA
      | 0xE0 0xA6 0xBE          #Mc       BENGALI VOWEL SIGN AA
      | 0xE0 0xA7 0x81..0x84    #Mn   [4] BENGALI VOWEL SIGN U..BENGALI VOWE...
      | 0xE0 0xA7 0x8D          #Mn       BENGALI SIGN VIRAMA
      | 0xE0 0xA7 0x97          #Mc       BENGALI AU LENGTH MARK
      | 0xE0 0xA7 0xA2..0xA3    #Mn   [2] BENGALI VOWEL SIGN VOCALIC L..BENG...
      | 0xE0 0xA8 0x81..0x82    #Mn   [2] GURMUKHI SIGN ADAK BINDI..GURMUKHI...
      | 0xE0 0xA8 0xBC          #Mn       GURMUKHI SIGN NUKTA
      | 0xE0 0xA9 0x81..0x82    #Mn   [2] GURMUKHI VOWEL SIGN U..GURMUKHI VO...
      | 0xE0 0xA9 0x87..0x88    #Mn   [2] GURMUKHI VOWEL SIGN EE..GURMUKHI V...
      | 0xE0 0xA9 0x8B..0x8D    #Mn   [3] GURMUKHI VOWEL SIGN OO..GURMUKHI S...
      | 0xE0 0xA9 0x91          #Mn       GURMUKHI SIGN UDAAT
      | 0xE0 0xA9 0xB0..0xB1    #Mn   [2] GURMUKHI TIPPI..GURMUKHI ADDAK
      | 0xE0 0xA9 0xB5          #Mn       GURMUKHI SIGN YAKASH
      | 0xE0 0xAA 0x81..0x82    #Mn   [2] GUJARATI SIGN CANDRABINDU..GUJARAT...
      | 0xE0 0xAA 0xBC          #Mn       GUJARATI SIGN NUKTA
      | 0xE0 0xAB 0x81..0x85    #Mn   [5] GUJARATI VOWEL SIGN U..GUJARATI VO...
      | 0xE0 0xAB 0x87..0x88    #Mn   [2] GUJARATI VOWEL SIGN E..GUJARATI VO...
      | 0xE0 0xAB 0x8D          #Mn       GUJARATI SIGN VIRAMA
      | 0xE0 0xAB 0xA2..0xA3    #Mn   [2] GUJARATI VOWEL SIGN VOCALIC L..GUJ...
      | 0xE0 0xAC 0x81          #Mn       ORIYA SIGN CANDRABINDU
      | 0xE0 0xAC 0xBC          #Mn       ORIYA SIGN NUKTA
      | 0xE0 0xAC 0xBE          #Mc       ORIYA VOWEL SIGN AA
      | 0xE0 0xAC 0xBF          #Mn       ORIYA VOWEL SIGN I
      | 0xE0 0xAD 0x81..0x84    #Mn   [4] ORIYA VOWEL SIGN U..ORIYA VOWEL SI...
      | 0xE0 0xAD 0x8D          #Mn       ORIYA SIGN VIRAMA
      | 0xE0 0xAD 0x96          #Mn       ORIYA AI LENGTH MARK
      | 0xE0 0xAD 0x97          #Mc       ORIYA AU LENGTH MARK
      | 0xE0 0xAD 0xA2..0xA3    #Mn   [2] ORIYA VOWEL SIGN VOCALIC L..ORIYA ...
      | 0xE0 0xAE 0x82          #Mn       TAMIL SIGN ANUSVARA
      | 0xE0 0xAE 0xBE          #Mc       TAMIL VOWEL SIGN AA
      | 0xE0 0xAF 0x80          #Mn       TAMIL VOWEL SIGN II
      | 0xE0 0xAF 0x8D          #Mn       TAMIL SIGN VIRAMA
      | 0xE0 0xAF 0x97          #Mc       TAMIL AU LENGTH MARK
      | 0xE0 0xB0 0x80          #Mn       TELUGU SIGN COMBINING CANDRABINDU ...
      | 0xE0 0xB0 0xBE..0xFF    #Mn   [3] TELUGU VOWEL SIGN AA..TELUGU VOWEL...
      | 0xE0 0xB1 0x00..0x80    #
      | 0xE0 0xB1 0x86..0x88    #Mn   [3] TELUGU VOWEL SIGN E..TELUGU VOWEL ...
      | 0xE0 0xB1 0x8A..0x8D    #Mn   [4] TELUGU VOWEL SIGN O..TELUGU SIGN V...
      | 0xE0 0xB1 0x95..0x96    #Mn   [2] TELUGU LENGTH MARK..TELUGU AI LENG...
      | 0xE0 0xB1 0xA2..0xA3    #Mn   [2] TELUGU VOWEL SIGN VOCALIC L..TELUG...
      | 0xE0 0xB2 0x81          #Mn       KANNADA SIGN CANDRABINDU
      | 0xE0 0xB2 0xBC          #Mn       KANNADA SIGN NUKTA
      | 0xE0 0xB2 0xBF          #Mn       KANNADA VOWEL SIGN I
      | 0xE0 0xB3 0x82          #Mc       KANNADA VOWEL SIGN UU
      | 0xE0 0xB3 0x86          #Mn       KANNADA VOWEL SIGN E
      | 0xE0 0xB3 0x8C..0x8D    #Mn   [2] KANNADA VOWEL SIGN AU..KANNADA SIG...
      | 0xE0 0xB3 0x95..0x96    #Mc   [2] KANNADA LENGTH MARK..KANNADA AI LE...
      | 0xE0 0xB3 0xA2..0xA3    #Mn   [2] KANNADA VOWEL SIGN VOCALIC L..KANN...
      | 0xE0 0xB4 0x81          #Mn       MALAYALAM SIGN CANDRABINDU
      | 0xE0 0xB4 0xBE          #Mc       MALAYALAM VOWEL SIGN AA
      | 0xE0 0xB5 0x81..0x84    #Mn   [4] MALAYALAM VOWEL SIGN U..MALAYALAM ...
      | 0xE0 0xB5 0x8D          #Mn       MALAYALAM SIGN VIRAMA
      | 0xE0 0xB5 0x97          #Mc       MALAYALAM AU LENGTH MARK
      | 0xE0 0xB5 0xA2..0xA3    #Mn   [2] MALAYALAM VOWEL SIGN VOCALIC L..MA...
      | 0xE0 0xB7 0x8A          #Mn       SINHALA SIGN AL-LAKUNA
      | 0xE0 0xB7 0x8F          #Mc       SINHALA VOWEL SIGN AELA-PILLA
      | 0xE0 0xB7 0x92..0x94    #Mn   [3] SINHALA VOWEL SIGN KETTI IS-PILLA....
      | 0xE0 0xB7 0x96          #Mn       SINHALA VOWEL SIGN DIGA PAA-PILLA
      | 0xE0 0xB7 0x9F          #Mc       SINHALA VOWEL SIGN GAYANUKITTA
      | 0xE0 0xB8 0xB1          #Mn       THAI CHARACTER MAI HAN-AKAT
      | 0xE0 0xB8 0xB4..0xBA    #Mn   [7] THAI CHARACTER SARA I..THAI CHARAC...
      | 0xE0 0xB9 0x87..0x8E    #Mn   [8] THAI CHARACTER MAITAIKHU..THAI CHA...
      | 0xE0 0xBA 0xB1          #Mn       LAO VOWEL SIGN MAI KAN
      | 0xE0 0xBA 0xB4..0xB9    #Mn   [6] LAO VOWEL SIGN I..LAO VOWEL SIGN UU
      | 0xE0 0xBA 0xBB..0xBC    #Mn   [2] LAO VOWEL SIGN MAI KON..LAO SEMIVO...
      | 0xE0 0xBB 0x88..0x8D    #Mn   [6] LAO TONE MAI EK..LAO NIGGAHITA
      | 0xE0 0xBC 0x98..0x99    #Mn   [2] TIBETAN ASTROLOGICAL SIGN -KHYUD P...
      | 0xE0 0xBC 0xB5          #Mn       TIBETAN MARK NGAS BZUNG NYI ZLA
      | 0xE0 0xBC 0xB7          #Mn       TIBETAN MARK NGAS BZUNG SGOR RTAGS
      | 0xE0 0xBC 0xB9          #Mn       TIBETAN MARK TSA -PHRU
      | 0xE0 0xBD 0xB1..0xBE    #Mn  [14] TIBETAN VOWEL SIGN AA..TIBETAN SIG...
      | 0xE0 0xBE 0x80..0x84    #Mn   [5] TIBETAN VOWEL SIGN REVERSED I..TIB...
      | 0xE0 0xBE 0x86..0x87    #Mn   [2] TIBETAN SIGN LCI RTAGS..TIBETAN SI...
      | 0xE0 0xBE 0x8D..0x97    #Mn  [11] TIBETAN SUBJOINED SIGN LCE TSA CAN...
      | 0xE0 0xBE 0x99..0xBC    #Mn  [36] TIBETAN SUBJOINED LETTER NYA..TIBE...
      | 0xE0 0xBF 0x86          #Mn       TIBETAN SYMBOL PADMA GDAN
      | 0xE1 0x80 0xAD..0xB0    #Mn   [4] MYANMAR VOWEL SIGN I..MYANMAR VOWE...
      | 0xE1 0x80 0xB2..0xB7    #Mn   [6] MYANMAR VOWEL SIGN AI..MYANMAR SIG...
      | 0xE1 0x80 0xB9..0xBA    #Mn   [2] MYANMAR SIGN VIRAMA..MYANMAR SIGN ...
      | 0xE1 0x80 0xBD..0xBE    #Mn   [2] MYANMAR CONSONANT SIGN MEDIAL WA.....
      | 0xE1 0x81 0x98..0x99    #Mn   [2] MYANMAR VOWEL SIGN VOCALIC L..MYAN...
      | 0xE1 0x81 0x9E..0xA0    #Mn   [3] MYANMAR CONSONANT SIGN MON MEDIAL ...
      | 0xE1 0x81 0xB1..0xB4    #Mn   [4] MYANMAR VOWEL SIGN GEBA KAREN I..M...
      | 0xE1 0x82 0x82          #Mn       MYANMAR CONSONANT SIGN SHAN MEDIAL WA
      | 0xE1 0x82 0x85..0x86    #Mn   [2] MYANMAR VOWEL SIGN SHAN E ABOVE..M...
      | 0xE1 0x82 0x8D          #Mn       MYANMAR SIGN SHAN COUNCIL EMPHATIC...
      | 0xE1 0x82 0x9D          #Mn       MYANMAR VOWEL SIGN AITON AI
      | 0xE1 0x8D 0x9D..0x9F    #Mn   [3] ETHIOPIC COMBINING GEMINATION AND ...
      | 0xE1 0x9C 0x92..0x94    #Mn   [3] TAGALOG VOWEL SIGN I..TAGALOG SIGN...
      | 0xE1 0x9C 0xB2..0xB4    #Mn   [3] HANUNOO VOWEL SIGN I..HANUNOO SIGN...
      | 0xE1 0x9D 0x92..0x93    #Mn   [2] BUHID VOWEL SIGN I..BUHID VOWEL SI...
      | 0xE1 0x9D 0xB2..0xB3    #Mn   [2] TAGBANWA VOWEL SIGN I..TAGBANWA VO...
      | 0xE1 0x9E 0xB4..0xB5    #Mn   [2] KHMER VOWEL INHERENT AQ..KHMER VOW...
      | 0xE1 0x9E 0xB7..0xBD    #Mn   [7] KHMER VOWEL SIGN I..KHMER VOWEL SI...
      | 0xE1 0x9F 0x86          #Mn       KHMER SIGN NIKAHIT
      | 0xE1 0x9F 0x89..0x93    #Mn  [11] KHMER SIGN MUUSIKATOAN..KHMER SIGN...
      | 0xE1 0x9F 0x9D          #Mn       KHMER SIGN ATTHACAN
      | 0xE1 0xA0 0x8B..0x8D    #Mn   [3] MONGOLIAN FREE VARIATION SELECTOR ...
      | 0xE1 0xA2 0x85..0x86    #Mn   [2] MONGOLIAN LETTER ALI GALI BALUDA.....
      | 0xE1 0xA2 0xA9          #Mn       MONGOLIAN LETTER ALI GALI DAGALGA
      | 0xE1 0xA4 0xA0..0xA2    #Mn   [3] LIMBU VOWEL SIGN A..LIMBU VOWEL SI...
      | 0xE1 0xA4 0xA7..0xA8    #Mn   [2] LIMBU VOWEL SIGN E..LIMBU VOWEL SI...
      | 0xE1 0xA4 0xB2          #Mn       LIMBU SMALL LETTER ANUSVARA
      | 0xE1 0xA4 0xB9..0xBB    #Mn   [3] LIMBU SIGN MUKPHRENG..LIMBU SIGN SA-I
      | 0xE1 0xA8 0x97..0x98    #Mn   [2] BUGINESE VOWEL SIGN I..BUGINESE VO...
      | 0xE1 0xA8 0x9B          #Mn       BUGINESE VOWEL SIGN AE
      | 0xE1 0xA9 0x96          #Mn       TAI THAM CONSONANT SIGN MEDIAL LA
      | 0xE1 0xA9 0x98..0x9E    #Mn   [7] TAI THAM SIGN MAI KANG LAI..TAI TH...
      | 0xE1 0xA9 0xA0          #Mn       TAI THAM SIGN SAKOT
      | 0xE1 0xA9 0xA2          #Mn       TAI THAM VOWEL SIGN MAI SAT
      | 0xE1 0xA9 0xA5..0xAC    #Mn   [8] TAI THAM VOWEL SIGN I..TAI THAM VO...
      | 0xE1 0xA9 0xB3..0xBC    #Mn  [10] TAI THAM VOWEL SIGN OA ABOVE..TAI ...
      | 0xE1 0xA9 0xBF          #Mn       TAI THAM COMBINING CRYPTOGRAMMIC DOT
      | 0xE1 0xAA 0xB0..0xBD    #Mn  [14] COMBINING DOUBLED CIRCUMFLEX ACCEN...
      | 0xE1 0xAA 0xBE          #Me       COMBINING PARENTHESES OVERLAY
      | 0xE1 0xAC 0x80..0x83    #Mn   [4] BALINESE SIGN ULU RICEM..BALINESE ...
      | 0xE1 0xAC 0xB4          #Mn       BALINESE SIGN REREKAN
      | 0xE1 0xAC 0xB6..0xBA    #Mn   [5] BALINESE VOWEL SIGN ULU..BALINESE ...
      | 0xE1 0xAC 0xBC          #Mn       BALINESE VOWEL SIGN LA LENGA
      | 0xE1 0xAD 0x82          #Mn       BALINESE VOWEL SIGN PEPET
      | 0xE1 0xAD 0xAB..0xB3    #Mn   [9] BALINESE MUSICAL SYMBOL COMBINING ...
      | 0xE1 0xAE 0x80..0x81    #Mn   [2] SUNDANESE SIGN PANYECEK..SUNDANESE...
      | 0xE1 0xAE 0xA2..0xA5    #Mn   [4] SUNDANESE CONSONANT SIGN PANYAKRA....
      | 0xE1 0xAE 0xA8..0xA9    #Mn   [2] SUNDANESE VOWEL SIGN PAMEPET..SUND...
      | 0xE1 0xAE 0xAB..0xAD    #Mn   [3] SUNDANESE SIGN VIRAMA..SUNDANESE C...
      | 0xE1 0xAF 0xA6          #Mn       BATAK SIGN TOMPI
      | 0xE1 0xAF 0xA8..0xA9    #Mn   [2] BATAK VOWEL SIGN PAKPAK E..BATAK V...
      | 0xE1 0xAF 0xAD          #Mn       BATAK VOWEL SIGN KARO O
      | 0xE1 0xAF 0xAF..0xB1    #Mn   [3] BATAK VOWEL SIGN U FOR SIMALUNGUN ...
      | 0xE1 0xB0 0xAC..0xB3    #Mn   [8] LEPCHA VOWEL SIGN E..LEPCHA CONSON...
      | 0xE1 0xB0 0xB6..0xB7    #Mn   [2] LEPCHA SIGN RAN..LEPCHA SIGN NUKTA
      | 0xE1 0xB3 0x90..0x92    #Mn   [3] VEDIC TONE KARSHANA..VEDIC TONE PR...
      | 0xE1 0xB3 0x94..0xA0    #Mn  [13] VEDIC SIGN YAJURVEDIC MIDLINE SVAR...
      | 0xE1 0xB3 0xA2..0xA8    #Mn   [7] VEDIC SIGN VISARGA SVARITA..VEDIC ...
      | 0xE1 0xB3 0xAD          #Mn       VEDIC SIGN TIRYAK
      | 0xE1 0xB3 0xB4          #Mn       VEDIC TONE CANDRA ABOVE
      | 0xE1 0xB3 0xB8..0xB9    #Mn   [2] VEDIC TONE RING ABOVE..VEDIC TONE ...
      | 0xE1 0xB7 0x80..0xB5    #Mn  [54] COMBINING DOTTED GRAVE ACCENT..COM...
      | 0xE1 0xB7 0xBB..0xBF    #Mn   [5] COMBINING DELETION MARK..COMBINING...
      | 0xE2 0x80 0x8C          #Cf       ZERO WIDTH NON-JOINER
      | 0xE2 0x83 0x90..0x9C    #Mn  [13] COMBINING LEFT HARPOON ABOVE..COMB...
      | 0xE2 0x83 0x9D..0xA0    #Me   [4] COMBINING ENCLOSING CIRCLE..COMBIN...
      | 0xE2 0x83 0xA1          #Mn       COMBINING LEFT RIGHT ARROW ABOVE
      | 0xE2 0x83 0xA2..0xA4    #Me   [3] COMBINING ENCLOSING SCREEN..COMBIN...
      | 0xE2 0x83 0xA5..0xB0    #Mn  [12] COMBINING REVERSE SOLIDUS OVERLAY....
      | 0xE2 0xB3 0xAF..0xB1    #Mn   [3] COPTIC COMBINING NI ABOVE..COPTIC ...
      | 0xE2 0xB5 0xBF          #Mn       TIFINAGH CONSONANT JOINER
      | 0xE2 0xB7 0xA0..0xBF    #Mn  [32] COMBINING CYRILLIC LETTER BE..COMB...
      | 0xE3 0x80 0xAA..0xAD    #Mn   [4] IDEOGRAPHIC LEVEL TONE MARK..IDEOG...
      | 0xE3 0x80 0xAE..0xAF    #Mc   [2] HANGUL SINGLE DOT TONE MARK..HANGU...
      | 0xE3 0x82 0x99..0x9A    #Mn   [2] COMBINING KATAKANA-HIRAGANA VOICED...
      | 0xEA 0x99 0xAF          #Mn       COMBINING CYRILLIC VZMET
      | 0xEA 0x99 0xB0..0xB2    #Me   [3] COMBINING CYRILLIC TEN MILLIONS SI...
      | 0xEA 0x99 0xB4..0xBD    #Mn  [10] COMBINING CYRILLIC LETTER UKRAINIA...
      | 0xEA 0x9A 0x9E..0x9F    #Mn   [2] COMBINING CYRILLIC LETTER EF..COMB...
      | 0xEA 0x9B 0xB0..0xB1    #Mn   [2] BAMUM COMBINING MARK KOQNDON..BAMU...
      | 0xEA 0xA0 0x82          #Mn       SYLOTI NAGRI SIGN DVISVARA
      | 0xEA 0xA0 0x86          #Mn       SYLOTI NAGRI SIGN HASANTA
      | 0xEA 0xA0 0x8B          #Mn       SYLOTI NAGRI SIGN ANUSVARA
      | 0xEA 0xA0 0xA5..0xA6    #Mn   [2] SYLOTI NAGRI VOWEL SIGN U..SYLOTI ...
      | 0xEA 0xA3 0x84..0x85    #Mn   [2] SAURASHTRA SIGN VIRAMA..SAURASHTRA...
      | 0xEA 0xA3 0xA0..0xB1    #Mn  [18] COMBINING DEVANAGARI DIGIT ZERO..C...
      | 0xEA 0xA4 0xA6..0xAD    #Mn   [8] KAYAH LI VOWEL UE..KAYAH LI TONE C...
      | 0xEA 0xA5 0x87..0x91    #Mn  [11] REJANG VOWEL SIGN I..REJANG CONSON...
      | 0xEA 0xA6 0x80..0x82    #Mn   [3] JAVANESE SIGN PANYANGGA..JAVANESE ...
      | 0xEA 0xA6 0xB3          #Mn       JAVANESE SIGN CECAK TELU
      | 0xEA 0xA6 0xB6..0xB9    #Mn   [4] JAVANESE VOWEL SIGN WULU..JAVANESE...
      | 0xEA 0xA6 0xBC          #Mn       JAVANESE VOWEL SIGN PEPET
      | 0xEA 0xA7 0xA5          #Mn       MYANMAR SIGN SHAN SAW
      | 0xEA 0xA8 0xA9..0xAE    #Mn   [6] CHAM VOWEL SIGN AA..CHAM VOWEL SIG...
      | 0xEA 0xA8 0xB1..0xB2    #Mn   [2] CHAM VOWEL SIGN AU..CHAM VOWEL SIG...
      | 0xEA 0xA8 0xB5..0xB6    #Mn   [2] CHAM CONSONANT SIGN LA..CHAM CONSO...
      | 0xEA 0xA9 0x83          #Mn       CHAM CONSONANT SIGN FINAL NG
      | 0xEA 0xA9 0x8C          #Mn       CHAM CONSONANT SIGN FINAL M
      | 0xEA 0xA9 0xBC          #Mn       MYANMAR SIGN TAI LAING TONE-2
      | 0xEA 0xAA 0xB0          #Mn       TAI VIET MAI KANG
      | 0xEA 0xAA 0xB2..0xB4    #Mn   [3] TAI VIET VOWEL I..TAI VIET VOWEL U
      | 0xEA 0xAA 0xB7..0xB8    #Mn   [2] TAI VIET MAI KHIT..TAI VIET VOWEL IA
      | 0xEA 0xAA 0xBE..0xBF    #Mn   [2] TAI VIET VOWEL AM..TAI VIET TONE M...
      | 0xEA 0xAB 0x81          #Mn       TAI VIET TONE MAI THO
      | 0xEA 0xAB 0xAC..0xAD    #Mn   [2] MEETEI MAYEK VOWEL SIGN UU..MEETEI...
      | 0xEA 0xAB 0xB6          #Mn       MEETEI MAYEK VIRAMA
      | 0xEA 0xAF 0xA5          #Mn       MEETEI MAYEK VOWEL SIGN ANAP
      | 0xEA 0xAF 0xA8          #Mn       MEETEI MAYEK VOWEL SIGN UNAP
      | 0xEA 0xAF 0xAD          #Mn       MEETEI MAYEK APUN IYEK
      | 0xEF 0xAC 0x9E          #Mn       HEBREW POINT JUDEO-SPANISH VARIKA
      | 0xEF 0xB8 0x80..0x8F    #Mn  [16] VARIATION SELECTOR-1..VARIATION SE...
      | 0xEF 0xB8 0xA0..0xAF    #Mn  [16] COMBINING LIGATURE LEFT HALF..COMB...
      | 0xEF 0xBE 0x9E..0x9F    #Lm   [2] HALFWIDTH KATAKANA VOICED SOUND MA...
      | 0xF0 0x90 0x87 0xBD     #Mn       PHAISTOS DISC SIGN COMBINING OBLIQ...
      | 0xF0 0x90 0x8B 0xA0     #Mn       COPTIC EPACT THOUSANDS MARK
      | 0xF0 0x90 0x8D 0xB6..0xBA  #Mn   [5] COMBINING OLD PERMIC LETTER AN....
      | 0xF0 0x90 0xA8 0x81..0x83  #Mn   [3] KHAROSHTHI VOWEL SIGN I..KHAROS...
      | 0xF0 0x90 0xA8 0x85..0x86  #Mn   [2] KHAROSHTHI VOWEL SIGN E..KHAROS...
      | 0xF0 0x90 0xA8 0x8C..0x8F  #Mn   [4] KHAROSHTHI VOWEL LENGTH MARK..K...
      | 0xF0 0x90 0xA8 0xB8..0xBA  #Mn   [3] KHAROSHTHI SIGN BAR ABOVE..KHAR...
      | 0xF0 0x90 0xA8 0xBF     #Mn       KHAROSHTHI VIRAMA
      | 0xF0 0x90 0xAB 0xA5..0xA6  #Mn   [2] MANICHAEAN ABBREVIATION MARK AB...
      | 0xF0 0x91 0x80 0x81     #Mn       BRAHMI SIGN ANUSVARA
      | 0xF0 0x91 0x80 0xB8..0xFF  #Mn  [15] BRAHMI VOWEL SIGN AA..BRAHMI VI...
      | 0xF0 0x91 0x81 0x00..0x86  #
      | 0xF0 0x91 0x81 0xBF..0xFF  #Mn   [3] BRAHMI NUMBER JOINER..KAITHI SI...
      | 0xF0 0x91 0x82 0x00..0x81  #
      | 0xF0 0x91 0x82 0xB3..0xB6  #Mn   [4] KAITHI VOWEL SIGN U..KAITHI VOW...
      | 0xF0 0x91 0x82 0xB9..0xBA  #Mn   [2] KAITHI SIGN VIRAMA..KAITHI SIGN...
      | 0xF0 0x91 0x84 0x80..0x82  #Mn   [3] CHAKMA SIGN CANDRABINDU..CHAKMA...
      | 0xF0 0x91 0x84 0xA7..0xAB  #Mn   [5] CHAKMA VOWEL SIGN A..CHAKMA VOW...
      | 0xF0 0x91 0x84 0xAD..0xB4  #Mn   [8] CHAKMA VOWEL SIGN AI..CHAKMA MA...
      | 0xF0 0x91 0x85 0xB3     #Mn       MAHAJANI SIGN NUKTA
      | 0xF0 0x91 0x86 0x80..0x81  #Mn   [2] SHARADA SIGN CANDRABINDU..SHARA...
      | 0xF0 0x91 0x86 0xB6..0xBE  #Mn   [9] SHARADA VOWEL SIGN U..SHARADA V...
      | 0xF0 0x91 0x87 0x8A..0x8C  #Mn   [3] SHARADA SIGN NUKTA..SHARADA EXT...
      | 0xF0 0x91 0x88 0xAF..0xB1  #Mn   [3] KHOJKI VOWEL SIGN U..KHOJKI VOW...
      | 0xF0 0x91 0x88 0xB4     #Mn       KHOJKI SIGN ANUSVARA
      | 0xF0 0x91 0x88 0xB6..0xB7  #Mn   [2] KHOJKI SIGN NUKTA..KHOJKI SIGN ...
      | 0xF0 0x91 0x88 0xBE     #Mn       KHOJKI SIGN SUKUN
      | 0xF0 0x91 0x8B 0x9F     #Mn       KHUDAWADI SIGN ANUSVARA
      | 0xF0 0x91 0x8B 0xA3..0xAA  #Mn   [8] KHUDAWADI VOWEL SIGN U..KHUDAWA...
      | 0xF0 0x91 0x8C 0x80..0x81  #Mn   [2] GRANTHA SIGN COMBINING ANUSVARA...
      | 0xF0 0x91 0x8C 0xBC     #Mn       GRANTHA SIGN NUKTA
      | 0xF0 0x91 0x8C 0xBE     #Mc       GRANTHA VOWEL SIGN AA
      | 0xF0 0x91 0x8D 0x80     #Mn       GRANTHA VOWEL SIGN II
      | 0xF0 0x91 0x8D 0x97     #Mc       GRANTHA AU LENGTH MARK
      | 0xF0 0x91 0x8D 0xA6..0xAC  #Mn   [7] COMBINING GRANTHA DIGIT ZERO..C...
      | 0xF0 0x91 0x8D 0xB0..0xB4  #Mn   [5] COMBINING GRANTHA LETTER A..COM...
      | 0xF0 0x91 0x90 0xB8..0xBF  #Mn   [8] NEWA VOWEL SIGN U..NEWA VOWEL S...
      | 0xF0 0x91 0x91 0x82..0x84  #Mn   [3] NEWA SIGN VIRAMA..NEWA SIGN ANU...
      | 0xF0 0x91 0x91 0x86     #Mn       NEWA SIGN NUKTA
      | 0xF0 0x91 0x92 0xB0     #Mc       TIRHUTA VOWEL SIGN AA
      | 0xF0 0x91 0x92 0xB3..0xB8  #Mn   [6] TIRHUTA VOWEL SIGN U..TIRHUTA V...
      | 0xF0 0x91 0x92 0xBA     #Mn       TIRHUTA VOWEL SIGN SHORT E
      | 0xF0 0x91 0x92 0xBD     #Mc       TIRHUTA VOWEL SIGN SHORT O
      | 0xF0 0x91 0x92 0xBF..0xFF  #Mn   [2] TIRHUTA SIGN CANDRABINDU..TIRHU...
      | 0xF0 0x91 0x93 0x00..0x80  #
      | 0xF0 0x91 0x93 0x82..0x83  #Mn   [2] TIRHUTA SIGN VIRAMA..TIRHUTA SI...
      | 0xF0 0x91 0x96 0xAF     #Mc       SIDDHAM VOWEL SIGN AA
      | 0xF0 0x91 0x96 0xB2..0xB5  #Mn   [4] SIDDHAM VOWEL SIGN U..SIDDHAM V...
      | 0xF0 0x91 0x96 0xBC..0xBD  #Mn   [2] SIDDHAM SIGN CANDRABINDU..SIDDH...
      | 0xF0 0x91 0x96 0xBF..0xFF  #Mn   [2] SIDDHAM SIGN VIRAMA..SIDDHAM SI...
      | 0xF0 0x91 0x97 0x00..0x80  #
      | 0xF0 0x91 0x97 0x9C..0x9D  #Mn   [2] SIDDHAM VOWEL SIGN ALTERNATE U....
      | 0xF0 0x91 0x98 0xB3..0xBA  #Mn   [8] MODI VOWEL SIGN U..MODI VOWEL S...
      | 0xF0 0x91 0x98 0xBD     #Mn       MODI SIGN ANUSVARA
      | 0xF0 0x91 0x98 0xBF..0xFF  #Mn   [2] MODI SIGN VIRAMA..MODI SIGN ARD...
      | 0xF0 0x91 0x99 0x00..0x80  #
      | 0xF0 0x91 0x9A 0xAB     #Mn       TAKRI SIGN ANUSVARA
      | 0xF0 0x91 0x9A 0xAD     #Mn       TAKRI VOWEL SIGN AA
      | 0xF0 0x91 0x9A 0xB0..0xB5  #Mn   [6] TAKRI VOWEL SIGN U..TAKRI VOWEL...
      | 0xF0 0x91 0x9A 0xB7     #Mn       TAKRI SIGN NUKTA
      | 0xF0 0x91 0x9C 0x9D..0x9F  #Mn   [3] AHOM CONSONANT SIGN MEDIAL LA.....
      | 0xF0 0x91 0x9C 0xA2..0xA5  #Mn   [4] AHOM VOWEL SIGN I..AHOM VOWEL S...
      | 0xF0 0x91 0x9C 0xA7..0xAB  #Mn   [5] AHOM VOWEL SIGN AW..AHOM SIGN K...
      | 0xF0 0x91 0xB0 0xB0..0xB6  #Mn   [7] BHAIKSUKI VOWEL SIGN I..BHAIKSU...
      | 0xF0 0x91 0xB0 0xB8..0xBD  #Mn   [6] BHAIKSUKI VOWEL SIGN E..BHAIKSU...
      | 0xF0 0x91 0xB0 0xBF     #Mn       BHAIKSUKI SIGN VIRAMA
      | 0xF0 0x91 0xB2 0x92..0xA7  #Mn  [22] MARCHEN SUBJOINED LETTER KA..MA...
      | 0xF0 0x91 0xB2 0xAA..0xB0  #Mn   [7] MARCHEN SUBJOINED LETTER RA..MA...
      | 0xF0 0x91 0xB2 0xB2..0xB3  #Mn   [2] MARCHEN VOWEL SIGN U..MARCHEN V...
      | 0xF0 0x91 0xB2 0xB5..0xB6  #Mn   [2] MARCHEN SIGN ANUSVARA..MARCHEN ...
      | 0xF0 0x96 0xAB 0xB0..0xB4  #Mn   [5] BASSA VAH COMBINING HIGH TONE.....
      | 0xF0 0x96 0xAC 0xB0..0xB6  #Mn   [7] PAHAWH HMONG MARK CIM TUB..PAHA...
      | 0xF0 0x96 0xBE 0x8F..0x92  #Mn   [4] MIAO TONE RIGHT..MIAO TONE BELOW
      | 0xF0 0x9B 0xB2 0x9D..0x9E  #Mn   [2] DUPLOYAN THICK LETTER SELECTOR....
      | 0xF0 0x9D 0x85 0xA5     #Mc       MUSICAL SYMBOL COMBINING STEM
      | 0xF0 0x9D 0x85 0xA7..0xA9  #Mn   [3] MUSICAL SYMBOL COMBINING TREMOL...
      | 0xF0 0x9D 0x85 0xAE..0xB2  #Mc   [5] MUSICAL SYMBOL COMBINING FLAG-1...
      | 0xF0 0x9D 0x85 0xBB..0xFF  #Mn   [8] MUSICAL SYMBOL COMBINING ACCENT...
      | 0xF0 0x9D 0x86 0x00..0x82  #
      | 0xF0 0x9D 0x86 0x85..0x8B  #Mn   [7] MUSICAL SYMBOL COMBINING DOIT.....
      | 0xF0 0x9D 0x86 0xAA..0xAD  #Mn   [4] MUSICAL SYMBOL COMBINING DOWN B...
      | 0xF0 0x9D 0x89 0x82..0x84  #Mn   [3] COMBINING GREEK MUSICAL TRISEME...
      | 0xF0 0x9D 0xA8 0x80..0xB6  #Mn  [55] SIGNWRITING HEAD RIM..SIGNWRITI...
      | 0xF0 0x9D 0xA8 0xBB..0xFF  #Mn  [50] SIGNWRITING MOUTH CLOSED NEUTRA...
      | 0xF0 0x9D 0xA9 0x00..0xAC  #
      | 0xF0 0x9D 0xA9 0xB5     #Mn       SIGNWRITING UPPER BODY TILTING FRO...
      | 0xF0 0x9D 0xAA 0x84     #Mn       SIGNWRITING LOCATION HEAD NECK
      | 0xF0 0x9D 0xAA 0x9B..0x9F  #Mn   [5] SIGNWRITING FILL MODIFIER-2..SI...
      | 0xF0 0x9D 0xAA 0xA1..0xAF  #Mn  [15] SIGNWRITING ROTATION MODIFIER-2...
      | 0xF0 0x9E 0x80 0x80..0x86  #Mn   [7] COMBINING GLAGOLITIC LETTER AZU...
      | 0xF0 0x9E 0x80 0x88..0x98  #Mn  [17] COMBINING GLAGOLITIC LETTER ZEM...
      | 0xF0 0x9E 0x80 0x9B..0xA1  #Mn   [7] COMBINING GLAGOLITIC LETTER SHT...
      | 0xF0 0x9E 0x80 0xA3..0xA4  #Mn   [2] COMBINING GLAGOLITIC LETTER YU....
      | 0xF0 0x9E 0x80 0xA6..0xAA  #Mn   [5] COMBINING GLAGOLITIC LETTER YO....
      | 0xF0 0x9E 0xA3 0x90..0x96  #Mn   [7] MENDE KIKAKUI COMBINING NUMBER ...
      | 0xF0 0x9E 0xA5 0x84..0x8A  #Mn   [7] ADLAM ALIF LENGTHENER..ADLAM NUKTA
      | 0xF3 0xA0 0x80 0xA0..0xFF  #Cf  [96] TAG SPACE..CANCEL TAG
      | 0xF3 0xA0 0x81 0x00..0xBF  #
      | 0xF3 0xA0 0x84 0x80..0xFF        #Mn [240] VARIATION SELECTOR-17..VA...
      | 0xF3 0xA0 0x85..0x86 0x00..0xFF  #
      | 0xF3 0xA0 0x87 0x00..0xAF        #
      ;

    Regional_Indicator = 
        0xF0 0x9F 0x87 0xA6..0xBF  #So  [26] REGIONAL INDICATOR SYMBOL LETTE...
      ;

    SpacingMark = 
        0xE0 0xA4 0x83          #Mc       DEVANAGARI SIGN VISARGA
      | 0xE0 0xA4 0xBB          #Mc       DEVANAGARI VOWEL SIGN OOE
      | 0xE0 0xA4 0xBE..0xFF    #Mc   [3] DEVANAGARI VOWEL SIGN AA..DEVANAGA...
      | 0xE0 0xA5 0x00..0x80    #
      | 0xE0 0xA5 0x89..0x8C    #Mc   [4] DEVANAGARI VOWEL SIGN CANDRA O..DE...
      | 0xE0 0xA5 0x8E..0x8F    #Mc   [2] DEVANAGARI VOWEL SIGN PRISHTHAMATR...
      | 0xE0 0xA6 0x82..0x83    #Mc   [2] BENGALI SIGN ANUSVARA..BENGALI SIG...
      | 0xE0 0xA6 0xBF..0xFF    #Mc   [2] BENGALI VOWEL SIGN I..BENGALI VOWE...
      | 0xE0 0xA7 0x00..0x80    #
      | 0xE0 0xA7 0x87..0x88    #Mc   [2] BENGALI VOWEL SIGN E..BENGALI VOWE...
      | 0xE0 0xA7 0x8B..0x8C    #Mc   [2] BENGALI VOWEL SIGN O..BENGALI VOWE...
      | 0xE0 0xA8 0x83          #Mc       GURMUKHI SIGN VISARGA
      | 0xE0 0xA8 0xBE..0xFF    #Mc   [3] GURMUKHI VOWEL SIGN AA..GURMUKHI V...
      | 0xE0 0xA9 0x00..0x80    #
      | 0xE0 0xAA 0x83          #Mc       GUJARATI SIGN VISARGA
      | 0xE0 0xAA 0xBE..0xFF    #Mc   [3] GUJARATI VOWEL SIGN AA..GUJARATI V...
      | 0xE0 0xAB 0x00..0x80    #
      | 0xE0 0xAB 0x89          #Mc       GUJARATI VOWEL SIGN CANDRA O
      | 0xE0 0xAB 0x8B..0x8C    #Mc   [2] GUJARATI VOWEL SIGN O..GUJARATI VO...
      | 0xE0 0xAC 0x82..0x83    #Mc   [2] ORIYA SIGN ANUSVARA..ORIYA SIGN VI...
      | 0xE0 0xAD 0x80          #Mc       ORIYA VOWEL SIGN II
      | 0xE0 0xAD 0x87..0x88    #Mc   [2] ORIYA VOWEL SIGN E..ORIYA VOWEL SI...
      | 0xE0 0xAD 0x8B..0x8C    #Mc   [2] ORIYA VOWEL SIGN O..ORIYA VOWEL SI...
      | 0xE0 0xAE 0xBF          #Mc       TAMIL VOWEL SIGN I
      | 0xE0 0xAF 0x81..0x82    #Mc   [2] TAMIL VOWEL SIGN U..TAMIL VOWEL SI...
      | 0xE0 0xAF 0x86..0x88    #Mc   [3] TAMIL VOWEL SIGN E..TAMIL VOWEL SI...
      | 0xE0 0xAF 0x8A..0x8C    #Mc   [3] TAMIL VOWEL SIGN O..TAMIL VOWEL SI...
      | 0xE0 0xB0 0x81..0x83    #Mc   [3] TELUGU SIGN CANDRABINDU..TELUGU SI...
      | 0xE0 0xB1 0x81..0x84    #Mc   [4] TELUGU VOWEL SIGN U..TELUGU VOWEL ...
      | 0xE0 0xB2 0x82..0x83    #Mc   [2] KANNADA SIGN ANUSVARA..KANNADA SIG...
      | 0xE0 0xB2 0xBE          #Mc       KANNADA VOWEL SIGN AA
      | 0xE0 0xB3 0x80..0x81    #Mc   [2] KANNADA VOWEL SIGN II..KANNADA VOW...
      | 0xE0 0xB3 0x83..0x84    #Mc   [2] KANNADA VOWEL SIGN VOCALIC R..KANN...
      | 0xE0 0xB3 0x87..0x88    #Mc   [2] KANNADA VOWEL SIGN EE..KANNADA VOW...
      | 0xE0 0xB3 0x8A..0x8B    #Mc   [2] KANNADA VOWEL SIGN O..KANNADA VOWE...
      | 0xE0 0xB4 0x82..0x83    #Mc   [2] MALAYALAM SIGN ANUSVARA..MALAYALAM...
      | 0xE0 0xB4 0xBF..0xFF    #Mc   [2] MALAYALAM VOWEL SIGN I..MALAYALAM ...
      | 0xE0 0xB5 0x00..0x80    #
      | 0xE0 0xB5 0x86..0x88    #Mc   [3] MALAYALAM VOWEL SIGN E..MALAYALAM ...
      | 0xE0 0xB5 0x8A..0x8C    #Mc   [3] MALAYALAM VOWEL SIGN O..MALAYALAM ...
      | 0xE0 0xB6 0x82..0x83    #Mc   [2] SINHALA SIGN ANUSVARAYA..SINHALA S...
      | 0xE0 0xB7 0x90..0x91    #Mc   [2] SINHALA VOWEL SIGN KETTI AEDA-PILL...
      | 0xE0 0xB7 0x98..0x9E    #Mc   [7] SINHALA VOWEL SIGN GAETTA-PILLA..S...
      | 0xE0 0xB7 0xB2..0xB3    #Mc   [2] SINHALA VOWEL SIGN DIGA GAETTA-PIL...
      | 0xE0 0xB8 0xB3          #Lo       THAI CHARACTER SARA AM
      | 0xE0 0xBA 0xB3          #Lo       LAO VOWEL SIGN AM
      | 0xE0 0xBC 0xBE..0xBF    #Mc   [2] TIBETAN SIGN YAR TSHES..TIBETAN SI...
      | 0xE0 0xBD 0xBF          #Mc       TIBETAN SIGN RNAM BCAD
      | 0xE1 0x80 0xB1          #Mc       MYANMAR VOWEL SIGN E
      | 0xE1 0x80 0xBB..0xBC    #Mc   [2] MYANMAR CONSONANT SIGN MEDIAL YA.....
      | 0xE1 0x81 0x96..0x97    #Mc   [2] MYANMAR VOWEL SIGN VOCALIC R..MYAN...
      | 0xE1 0x82 0x84          #Mc       MYANMAR VOWEL SIGN SHAN E
      | 0xE1 0x9E 0xB6          #Mc       KHMER VOWEL SIGN AA
      | 0xE1 0x9E 0xBE..0xFF    #Mc   [8] KHMER VOWEL SIGN OE..KHMER VOWEL S...
      | 0xE1 0x9F 0x00..0x85    #
      | 0xE1 0x9F 0x87..0x88    #Mc   [2] KHMER SIGN REAHMUK..KHMER SIGN YUU...
      | 0xE1 0xA4 0xA3..0xA6    #Mc   [4] LIMBU VOWEL SIGN EE..LIMBU VOWEL S...
      | 0xE1 0xA4 0xA9..0xAB    #Mc   [3] LIMBU SUBJOINED LETTER YA..LIMBU S...
      | 0xE1 0xA4 0xB0..0xB1    #Mc   [2] LIMBU SMALL LETTER KA..LIMBU SMALL...
      | 0xE1 0xA4 0xB3..0xB8    #Mc   [6] LIMBU SMALL LETTER TA..LIMBU SMALL...
      | 0xE1 0xA8 0x99..0x9A    #Mc   [2] BUGINESE VOWEL SIGN E..BUGINESE VO...
      | 0xE1 0xA9 0x95          #Mc       TAI THAM CONSONANT SIGN MEDIAL RA
      | 0xE1 0xA9 0x97          #Mc       TAI THAM CONSONANT SIGN LA TANG LAI
      | 0xE1 0xA9 0xAD..0xB2    #Mc   [6] TAI THAM VOWEL SIGN OY..TAI THAM V...
      | 0xE1 0xAC 0x84          #Mc       BALINESE SIGN BISAH
      | 0xE1 0xAC 0xB5          #Mc       BALINESE VOWEL SIGN TEDUNG
      | 0xE1 0xAC 0xBB          #Mc       BALINESE VOWEL SIGN RA REPA TEDUNG
      | 0xE1 0xAC 0xBD..0xFF    #Mc   [5] BALINESE VOWEL SIGN LA LENGA TEDUN...
      | 0xE1 0xAD 0x00..0x81    #
      | 0xE1 0xAD 0x83..0x84    #Mc   [2] BALINESE VOWEL SIGN PEPET TEDUNG.....
      | 0xE1 0xAE 0x82          #Mc       SUNDANESE SIGN PANGWISAD
      | 0xE1 0xAE 0xA1          #Mc       SUNDANESE CONSONANT SIGN PAMINGKAL
      | 0xE1 0xAE 0xA6..0xA7    #Mc   [2] SUNDANESE VOWEL SIGN PANAELAENG..S...
      | 0xE1 0xAE 0xAA          #Mc       SUNDANESE SIGN PAMAAEH
      | 0xE1 0xAF 0xA7          #Mc       BATAK VOWEL SIGN E
      | 0xE1 0xAF 0xAA..0xAC    #Mc   [3] BATAK VOWEL SIGN I..BATAK VOWEL SI...
      | 0xE1 0xAF 0xAE          #Mc       BATAK VOWEL SIGN U
      | 0xE1 0xAF 0xB2..0xB3    #Mc   [2] BATAK PANGOLAT..BATAK PANONGONAN
      | 0xE1 0xB0 0xA4..0xAB    #Mc   [8] LEPCHA SUBJOINED LETTER YA..LEPCHA...
      | 0xE1 0xB0 0xB4..0xB5    #Mc   [2] LEPCHA CONSONANT SIGN NYIN-DO..LEP...
      | 0xE1 0xB3 0xA1          #Mc       VEDIC TONE ATHARVAVEDIC INDEPENDEN...
      | 0xE1 0xB3 0xB2..0xB3    #Mc   [2] VEDIC SIGN ARDHAVISARGA..VEDIC SIG...
      | 0xEA 0xA0 0xA3..0xA4    #Mc   [2] SYLOTI NAGRI VOWEL SIGN A..SYLOTI ...
      | 0xEA 0xA0 0xA7          #Mc       SYLOTI NAGRI VOWEL SIGN OO
      | 0xEA 0xA2 0x80..0x81    #Mc   [2] SAURASHTRA SIGN ANUSVARA..SAURASHT...
      | 0xEA 0xA2 0xB4..0xFF    #Mc  [16] SAURASHTRA CONSONANT SIGN HAARU..S...
      | 0xEA 0xA3 0x00..0x83    #
      | 0xEA 0xA5 0x92..0x93    #Mc   [2] REJANG CONSONANT SIGN H..REJANG VI...
      | 0xEA 0xA6 0x83          #Mc       JAVANESE SIGN WIGNYAN
      | 0xEA 0xA6 0xB4..0xB5    #Mc   [2] JAVANESE VOWEL SIGN TARUNG..JAVANE...
      | 0xEA 0xA6 0xBA..0xBB    #Mc   [2] JAVANESE VOWEL SIGN TALING..JAVANE...
      | 0xEA 0xA6 0xBD..0xFF    #Mc   [4] JAVANESE CONSONANT SIGN KERET..JAV...
      | 0xEA 0xA7 0x00..0x80    #
      | 0xEA 0xA8 0xAF..0xB0    #Mc   [2] CHAM VOWEL SIGN O..CHAM VOWEL SIGN AI
      | 0xEA 0xA8 0xB3..0xB4    #Mc   [2] CHAM CONSONANT SIGN YA..CHAM CONSO...
      | 0xEA 0xA9 0x8D          #Mc       CHAM CONSONANT SIGN FINAL H
      | 0xEA 0xAB 0xAB          #Mc       MEETEI MAYEK VOWEL SIGN II
      | 0xEA 0xAB 0xAE..0xAF    #Mc   [2] MEETEI MAYEK VOWEL SIGN AU..MEETEI...
      | 0xEA 0xAB 0xB5          #Mc       MEETEI MAYEK VOWEL SIGN VISARGA
      | 0xEA 0xAF 0xA3..0xA4    #Mc   [2] MEETEI MAYEK VOWEL SIGN ONAP..MEET...
      | 0xEA 0xAF 0xA6..0xA7    #Mc   [2] MEETEI MAYEK VOWEL SIGN YENAP..MEE...
      | 0xEA 0xAF 0xA9..0xAA    #Mc   [2] MEETEI MAYEK VOWEL SIGN CHEINAP..M...
      | 0xEA 0xAF 0xAC          #Mc       MEETEI MAYEK LUM IYEK
      | 0xF0 0x91 0x80 0x80     #Mc       BRAHMI SIGN CANDRABINDU
      | 0xF0 0x91 0x80 0x82     #Mc       BRAHMI SIGN VISARGA
      | 0xF0 0x91 0x82 0x82     #Mc       KAITHI SIGN VISARGA
      | 0xF0 0x91 0x82 0xB0..0xB2  #Mc   [3] KAITHI VOWEL SIGN AA..KAITHI VO...
      | 0xF0 0x91 0x82 0xB7..0xB8  #Mc   [2] KAITHI VOWEL SIGN O..KAITHI VOW...
      | 0xF0 0x91 0x84 0xAC     #Mc       CHAKMA VOWEL SIGN E
      | 0xF0 0x91 0x86 0x82     #Mc       SHARADA SIGN VISARGA
      | 0xF0 0x91 0x86 0xB3..0xB5  #Mc   [3] SHARADA VOWEL SIGN AA..SHARADA ...
      | 0xF0 0x91 0x86 0xBF..0xFF  #Mc   [2] SHARADA VOWEL SIGN AU..SHARADA ...
      | 0xF0 0x91 0x87 0x00..0x80  #
      | 0xF0 0x91 0x88 0xAC..0xAE  #Mc   [3] KHOJKI VOWEL SIGN AA..KHOJKI VO...
      | 0xF0 0x91 0x88 0xB2..0xB3  #Mc   [2] KHOJKI VOWEL SIGN O..KHOJKI VOW...
      | 0xF0 0x91 0x88 0xB5     #Mc       KHOJKI SIGN VIRAMA
      | 0xF0 0x91 0x8B 0xA0..0xA2  #Mc   [3] KHUDAWADI VOWEL SIGN AA..KHUDAW...
      | 0xF0 0x91 0x8C 0x82..0x83  #Mc   [2] GRANTHA SIGN ANUSVARA..GRANTHA ...
      | 0xF0 0x91 0x8C 0xBF     #Mc       GRANTHA VOWEL SIGN I
      | 0xF0 0x91 0x8D 0x81..0x84  #Mc   [4] GRANTHA VOWEL SIGN U..GRANTHA V...
      | 0xF0 0x91 0x8D 0x87..0x88  #Mc   [2] GRANTHA VOWEL SIGN EE..GRANTHA ...
      | 0xF0 0x91 0x8D 0x8B..0x8D  #Mc   [3] GRANTHA VOWEL SIGN OO..GRANTHA ...
      | 0xF0 0x91 0x8D 0xA2..0xA3  #Mc   [2] GRANTHA VOWEL SIGN VOCALIC L..G...
      | 0xF0 0x91 0x90 0xB5..0xB7  #Mc   [3] NEWA VOWEL SIGN AA..NEWA VOWEL ...
      | 0xF0 0x91 0x91 0x80..0x81  #Mc   [2] NEWA VOWEL SIGN O..NEWA VOWEL S...
      | 0xF0 0x91 0x91 0x85     #Mc       NEWA SIGN VISARGA
      | 0xF0 0x91 0x92 0xB1..0xB2  #Mc   [2] TIRHUTA VOWEL SIGN I..TIRHUTA V...
      | 0xF0 0x91 0x92 0xB9     #Mc       TIRHUTA VOWEL SIGN E
      | 0xF0 0x91 0x92 0xBB..0xBC  #Mc   [2] TIRHUTA VOWEL SIGN AI..TIRHUTA ...
      | 0xF0 0x91 0x92 0xBE     #Mc       TIRHUTA VOWEL SIGN AU
      | 0xF0 0x91 0x93 0x81     #Mc       TIRHUTA SIGN VISARGA
      | 0xF0 0x91 0x96 0xB0..0xB1  #Mc   [2] SIDDHAM VOWEL SIGN I..SIDDHAM V...
      | 0xF0 0x91 0x96 0xB8..0xBB  #Mc   [4] SIDDHAM VOWEL SIGN E..SIDDHAM V...
      | 0xF0 0x91 0x96 0xBE     #Mc       SIDDHAM SIGN VISARGA
      | 0xF0 0x91 0x98 0xB0..0xB2  #Mc   [3] MODI VOWEL SIGN AA..MODI VOWEL ...
      | 0xF0 0x91 0x98 0xBB..0xBC  #Mc   [2] MODI VOWEL SIGN O..MODI VOWEL S...
      | 0xF0 0x91 0x98 0xBE     #Mc       MODI SIGN VISARGA
      | 0xF0 0x91 0x9A 0xAC     #Mc       TAKRI SIGN VISARGA
      | 0xF0 0x91 0x9A 0xAE..0xAF  #Mc   [2] TAKRI VOWEL SIGN I..TAKRI VOWEL...
      | 0xF0 0x91 0x9A 0xB6     #Mc       TAKRI SIGN VIRAMA
      | 0xF0 0x91 0x9C 0xA0..0xA1  #Mc   [2] AHOM VOWEL SIGN A..AHOM VOWEL S...
      | 0xF0 0x91 0x9C 0xA6     #Mc       AHOM VOWEL SIGN E
      | 0xF0 0x91 0xB0 0xAF     #Mc       BHAIKSUKI VOWEL SIGN AA
      | 0xF0 0x91 0xB0 0xBE     #Mc       BHAIKSUKI SIGN VISARGA
      | 0xF0 0x91 0xB2 0xA9     #Mc       MARCHEN SUBJOINED LETTER YA
      | 0xF0 0x91 0xB2 0xB1     #Mc       MARCHEN VOWEL SIGN I
      | 0xF0 0x91 0xB2 0xB4     #Mc       MARCHEN VOWEL SIGN O
      | 0xF0 0x96 0xBD 0x91..0xBE  #Mc  [46] MIAO SIGN ASPIRATION..MIAO VOWE...
      | 0xF0 0x9D 0x85 0xA6     #Mc       MUSICAL SYMBOL COMBINING SPRECHGES...
      | 0xF0 0x9D 0x85 0xAD     #Mc       MUSICAL SYMBOL COMBINING AUGMENTAT...
      ;

    L = 
        0xE1 0x84 0x80..0xFF    #Lo  [96] HANGUL CHOSEONG KIYEOK..HANGUL CHO...
      | 0xE1 0x85 0x00..0x9F    #
      | 0xEA 0xA5 0xA0..0xBC    #Lo  [29] HANGUL CHOSEONG TIKEUT-MIEUM..HANG...
      ;

    V = 
        0xE1 0x85 0xA0..0xFF    #Lo  [72] HANGUL JUNGSEONG FILLER..HANGUL JU...
      | 0xE1 0x86 0x00..0xA7    #
      | 0xED 0x9E 0xB0..0xFF    #Lo  [23] HANGUL JUNGSEONG O-YEO..HANGUL JUN...
      | 0xED 0x9F 0x00..0x86    #
      ;

    T = 
        0xE1 0x86 0xA8..0xFF    #Lo  [88] HANGUL JONGSEONG KIYEOK..HANGUL JO...
      | 0xE1 0x87 0x00..0xBF    #
      | 0xED 0x9F 0x8B..0xBB    #Lo  [49] HANGUL JONGSEONG NIEUN-RIEUL..HANG...
      ;

    LV = 
        0xEA 0xB0 0x80          #Lo       HANGUL SYLLABLE GA
      | 0xEA 0xB0 0x9C          #Lo       HANGUL SYLLABLE GAE
      | 0xEA 0xB0 0xB8          #Lo       HANGUL SYLLABLE GYA
      | 0xEA 0xB1 0x94          #Lo       HANGUL SYLLABLE GYAE
      | 0xEA 0xB1 0xB0          #Lo       HANGUL SYLLABLE GEO
      | 0xEA 0xB2 0x8C          #Lo       HANGUL SYLLABLE GE
      | 0xEA 0xB2 0xA8          #Lo       HANGUL SYLLABLE GYEO
      | 0xEA 0xB3 0x84          #Lo       HANGUL SYLLABLE GYE
      | 0xEA 0xB3 0xA0          #Lo       HANGUL SYLLABLE GO
      | 0xEA 0xB3 0xBC          #Lo       HANGUL SYLLABLE GWA
      | 0xEA 0xB4 0x98          #Lo       HANGUL SYLLABLE GWAE
      | 0xEA 0xB4 0xB4          #Lo       HANGUL SYLLABLE GOE
      | 0xEA 0xB5 0x90          #Lo       HANGUL SYLLABLE GYO
      | 0xEA 0xB5 0xAC          #Lo       HANGUL SYLLABLE GU
      | 0xEA 0xB6 0x88          #Lo       HANGUL SYLLABLE GWEO
      | 0xEA 0xB6 0xA4          #Lo       HANGUL SYLLABLE GWE
      | 0xEA 0xB7 0x80          #Lo       HANGUL SYLLABLE GWI
      | 0xEA 0xB7 0x9C          #Lo       HANGUL SYLLABLE GYU
      | 0xEA 0xB7 0xB8          #Lo       HANGUL SYLLABLE GEU
      | 0xEA 0xB8 0x94          #Lo       HANGUL SYLLABLE GYI
      | 0xEA 0xB8 0xB0          #Lo       HANGUL SYLLABLE GI
      | 0xEA 0xB9 0x8C          #Lo       HANGUL SYLLABLE GGA
      | 0xEA 0xB9 0xA8          #Lo       HANGUL SYLLABLE GGAE
      | 0xEA 0xBA 0x84          #Lo       HANGUL SYLLABLE GGYA
      | 0xEA 0xBA 0xA0          #Lo       HANGUL SYLLABLE GGYAE
      | 0xEA 0xBA 0xBC          #Lo       HANGUL SYLLABLE GGEO
      | 0xEA 0xBB 0x98          #Lo       HANGUL SYLLABLE GGE
      | 0xEA 0xBB 0xB4          #Lo       HANGUL SYLLABLE GGYEO
      | 0xEA 0xBC 0x90          #Lo       HANGUL SYLLABLE GGYE
      | 0xEA 0xBC 0xAC          #Lo       HANGUL SYLLABLE GGO
      | 0xEA 0xBD 0x88          #Lo       HANGUL SYLLABLE GGWA
      | 0xEA 0xBD 0xA4          #Lo       HANGUL SYLLABLE GGWAE
      | 0xEA 0xBE 0x80          #Lo       HANGUL SYLLABLE GGOE
      | 0xEA 0xBE 0x9C          #Lo       HANGUL SYLLABLE GGYO
      | 0xEA 0xBE 0xB8          #Lo       HANGUL SYLLABLE GGU
      | 0xEA 0xBF 0x94          #Lo       HANGUL SYLLABLE GGWEO
      | 0xEA 0xBF 0xB0          #Lo       HANGUL SYLLABLE GGWE
      | 0xEB 0x80 0x8C          #Lo       HANGUL SYLLABLE GGWI
      | 0xEB 0x80 0xA8          #Lo       HANGUL SYLLABLE GGYU
      | 0xEB 0x81 0x84          #Lo       HANGUL SYLLABLE GGEU
      | 0xEB 0x81 0xA0          #Lo       HANGUL SYLLABLE GGYI
      | 0xEB 0x81 0xBC          #Lo       HANGUL SYLLABLE GGI
      | 0xEB 0x82 0x98          #Lo       HANGUL SYLLABLE NA
      | 0xEB 0x82 0xB4          #Lo       HANGUL SYLLABLE NAE
      | 0xEB 0x83 0x90          #Lo       HANGUL SYLLABLE NYA
      | 0xEB 0x83 0xAC          #Lo       HANGUL SYLLABLE NYAE
      | 0xEB 0x84 0x88          #Lo       HANGUL SYLLABLE NEO
      | 0xEB 0x84 0xA4          #Lo       HANGUL SYLLABLE NE
      | 0xEB 0x85 0x80          #Lo       HANGUL SYLLABLE NYEO
      | 0xEB 0x85 0x9C          #Lo       HANGUL SYLLABLE NYE
      | 0xEB 0x85 0xB8          #Lo       HANGUL SYLLABLE NO
      | 0xEB 0x86 0x94          #Lo       HANGUL SYLLABLE NWA
      | 0xEB 0x86 0xB0          #Lo       HANGUL SYLLABLE NWAE
      | 0xEB 0x87 0x8C          #Lo       HANGUL SYLLABLE NOE
      | 0xEB 0x87 0xA8          #Lo       HANGUL SYLLABLE NYO
      | 0xEB 0x88 0x84          #Lo       HANGUL SYLLABLE NU
      | 0xEB 0x88 0xA0          #Lo       HANGUL SYLLABLE NWEO
      | 0xEB 0x88 0xBC          #Lo       HANGUL SYLLABLE NWE
      | 0xEB 0x89 0x98          #Lo       HANGUL SYLLABLE NWI
      | 0xEB 0x89 0xB4          #Lo       HANGUL SYLLABLE NYU
      | 0xEB 0x8A 0x90          #Lo       HANGUL SYLLABLE NEU
      | 0xEB 0x8A 0xAC          #Lo       HANGUL SYLLABLE NYI
      | 0xEB 0x8B 0x88          #Lo       HANGUL SYLLABLE NI
      | 0xEB 0x8B 0xA4          #Lo       HANGUL SYLLABLE DA
      | 0xEB 0x8C 0x80          #Lo       HANGUL SYLLABLE DAE
      | 0xEB 0x8C 0x9C          #Lo       HANGUL SYLLABLE DYA
      | 0xEB 0x8C 0xB8          #Lo       HANGUL SYLLABLE DYAE
      | 0xEB 0x8D 0x94          #Lo       HANGUL SYLLABLE DEO
      | 0xEB 0x8D 0xB0          #Lo       HANGUL SYLLABLE DE
      | 0xEB 0x8E 0x8C          #Lo       HANGUL SYLLABLE DYEO
      | 0xEB 0x8E 0xA8          #Lo       HANGUL SYLLABLE DYE
      | 0xEB 0x8F 0x84          #Lo       HANGUL SYLLABLE DO
      | 0xEB 0x8F 0xA0          #Lo       HANGUL SYLLABLE DWA
      | 0xEB 0x8F 0xBC          #Lo       HANGUL SYLLABLE DWAE
      | 0xEB 0x90 0x98          #Lo       HANGUL SYLLABLE DOE
      | 0xEB 0x90 0xB4          #Lo       HANGUL SYLLABLE DYO
      | 0xEB 0x91 0x90          #Lo       HANGUL SYLLABLE DU
      | 0xEB 0x91 0xAC          #Lo       HANGUL SYLLABLE DWEO
      | 0xEB 0x92 0x88          #Lo       HANGUL SYLLABLE DWE
      | 0xEB 0x92 0xA4          #Lo       HANGUL SYLLABLE DWI
      | 0xEB 0x93 0x80          #Lo       HANGUL SYLLABLE DYU
      | 0xEB 0x93 0x9C          #Lo       HANGUL SYLLABLE DEU
      | 0xEB 0x93 0xB8          #Lo       HANGUL SYLLABLE DYI
      | 0xEB 0x94 0x94          #Lo       HANGUL SYLLABLE DI
      | 0xEB 0x94 0xB0          #Lo       HANGUL SYLLABLE DDA
      | 0xEB 0x95 0x8C          #Lo       HANGUL SYLLABLE DDAE
      | 0xEB 0x95 0xA8          #Lo       HANGUL SYLLABLE DDYA
      | 0xEB 0x96 0x84          #Lo       HANGUL SYLLABLE DDYAE
      | 0xEB 0x96 0xA0          #Lo       HANGUL SYLLABLE DDEO
      | 0xEB 0x96 0xBC          #Lo       HANGUL SYLLABLE DDE
      | 0xEB 0x97 0x98          #Lo       HANGUL SYLLABLE DDYEO
      | 0xEB 0x97 0xB4          #Lo       HANGUL SYLLABLE DDYE
      | 0xEB 0x98 0x90          #Lo       HANGUL SYLLABLE DDO
      | 0xEB 0x98 0xAC          #Lo       HANGUL SYLLABLE DDWA
      | 0xEB 0x99 0x88          #Lo       HANGUL SYLLABLE DDWAE
      | 0xEB 0x99 0xA4          #Lo       HANGUL SYLLABLE DDOE
      | 0xEB 0x9A 0x80          #Lo       HANGUL SYLLABLE DDYO
      | 0xEB 0x9A 0x9C          #Lo       HANGUL SYLLABLE DDU
      | 0xEB 0x9A 0xB8          #Lo       HANGUL SYLLABLE DDWEO
      | 0xEB 0x9B 0x94          #Lo       HANGUL SYLLABLE DDWE
      | 0xEB 0x9B 0xB0          #Lo       HANGUL SYLLABLE DDWI
      | 0xEB 0x9C 0x8C          #Lo       HANGUL SYLLABLE DDYU
      | 0xEB 0x9C 0xA8          #Lo       HANGUL SYLLABLE DDEU
      | 0xEB 0x9D 0x84          #Lo       HANGUL SYLLABLE DDYI
      | 0xEB 0x9D 0xA0          #Lo       HANGUL SYLLABLE DDI
      | 0xEB 0x9D 0xBC          #Lo       HANGUL SYLLABLE RA
      | 0xEB 0x9E 0x98          #Lo       HANGUL SYLLABLE RAE
      | 0xEB 0x9E 0xB4          #Lo       HANGUL SYLLABLE RYA
      | 0xEB 0x9F 0x90          #Lo       HANGUL SYLLABLE RYAE
      | 0xEB 0x9F 0xAC          #Lo       HANGUL SYLLABLE REO
      | 0xEB 0xA0 0x88          #Lo       HANGUL SYLLABLE RE
      | 0xEB 0xA0 0xA4          #Lo       HANGUL SYLLABLE RYEO
      | 0xEB 0xA1 0x80          #Lo       HANGUL SYLLABLE RYE
      | 0xEB 0xA1 0x9C          #Lo       HANGUL SYLLABLE RO
      | 0xEB 0xA1 0xB8          #Lo       HANGUL SYLLABLE RWA
      | 0xEB 0xA2 0x94          #Lo       HANGUL SYLLABLE RWAE
      | 0xEB 0xA2 0xB0          #Lo       HANGUL SYLLABLE ROE
      | 0xEB 0xA3 0x8C          #Lo       HANGUL SYLLABLE RYO
      | 0xEB 0xA3 0xA8          #Lo       HANGUL SYLLABLE RU
      | 0xEB 0xA4 0x84          #Lo       HANGUL SYLLABLE RWEO
      | 0xEB 0xA4 0xA0          #Lo       HANGUL SYLLABLE RWE
      | 0xEB 0xA4 0xBC          #Lo       HANGUL SYLLABLE RWI
      | 0xEB 0xA5 0x98          #Lo       HANGUL SYLLABLE RYU
      | 0xEB 0xA5 0xB4          #Lo       HANGUL SYLLABLE REU
      | 0xEB 0xA6 0x90          #Lo       HANGUL SYLLABLE RYI
      | 0xEB 0xA6 0xAC          #Lo       HANGUL SYLLABLE RI
      | 0xEB 0xA7 0x88          #Lo       HANGUL SYLLABLE MA
      | 0xEB 0xA7 0xA4          #Lo       HANGUL SYLLABLE MAE
      | 0xEB 0xA8 0x80          #Lo       HANGUL SYLLABLE MYA
      | 0xEB 0xA8 0x9C          #Lo       HANGUL SYLLABLE MYAE
      | 0xEB 0xA8 0xB8          #Lo       HANGUL SYLLABLE MEO
      | 0xEB 0xA9 0x94          #Lo       HANGUL SYLLABLE ME
      | 0xEB 0xA9 0xB0          #Lo       HANGUL SYLLABLE MYEO
      | 0xEB 0xAA 0x8C          #Lo       HANGUL SYLLABLE MYE
      | 0xEB 0xAA 0xA8          #Lo       HANGUL SYLLABLE MO
      | 0xEB 0xAB 0x84          #Lo       HANGUL SYLLABLE MWA
      | 0xEB 0xAB 0xA0          #Lo       HANGUL SYLLABLE MWAE
      | 0xEB 0xAB 0xBC          #Lo       HANGUL SYLLABLE MOE
      | 0xEB 0xAC 0x98          #Lo       HANGUL SYLLABLE MYO
      | 0xEB 0xAC 0xB4          #Lo       HANGUL SYLLABLE MU
      | 0xEB 0xAD 0x90          #Lo       HANGUL SYLLABLE MWEO
      | 0xEB 0xAD 0xAC          #Lo       HANGUL SYLLABLE MWE
      | 0xEB 0xAE 0x88          #Lo       HANGUL SYLLABLE MWI
      | 0xEB 0xAE 0xA4          #Lo       HANGUL SYLLABLE MYU
      | 0xEB 0xAF 0x80          #Lo       HANGUL SYLLABLE MEU
      | 0xEB 0xAF 0x9C          #Lo       HANGUL SYLLABLE MYI
      | 0xEB 0xAF 0xB8          #Lo       HANGUL SYLLABLE MI
      | 0xEB 0xB0 0x94          #Lo       HANGUL SYLLABLE BA
      | 0xEB 0xB0 0xB0          #Lo       HANGUL SYLLABLE BAE
      | 0xEB 0xB1 0x8C          #Lo       HANGUL SYLLABLE BYA
      | 0xEB 0xB1 0xA8          #Lo       HANGUL SYLLABLE BYAE
      | 0xEB 0xB2 0x84          #Lo       HANGUL SYLLABLE BEO
      | 0xEB 0xB2 0xA0          #Lo       HANGUL SYLLABLE BE
      | 0xEB 0xB2 0xBC          #Lo       HANGUL SYLLABLE BYEO
      | 0xEB 0xB3 0x98          #Lo       HANGUL SYLLABLE BYE
      | 0xEB 0xB3 0xB4          #Lo       HANGUL SYLLABLE BO
      | 0xEB 0xB4 0x90          #Lo       HANGUL SYLLABLE BWA
      | 0xEB 0xB4 0xAC          #Lo       HANGUL SYLLABLE BWAE
      | 0xEB 0xB5 0x88          #Lo       HANGUL SYLLABLE BOE
      | 0xEB 0xB5 0xA4          #Lo       HANGUL SYLLABLE BYO
      | 0xEB 0xB6 0x80          #Lo       HANGUL SYLLABLE BU
      | 0xEB 0xB6 0x9C          #Lo       HANGUL SYLLABLE BWEO
      | 0xEB 0xB6 0xB8          #Lo       HANGUL SYLLABLE BWE
      | 0xEB 0xB7 0x94          #Lo       HANGUL SYLLABLE BWI
      | 0xEB 0xB7 0xB0          #Lo       HANGUL SYLLABLE BYU
      | 0xEB 0xB8 0x8C          #Lo       HANGUL SYLLABLE BEU
      | 0xEB 0xB8 0xA8          #Lo       HANGUL SYLLABLE BYI
      | 0xEB 0xB9 0x84          #Lo       HANGUL SYLLABLE BI
      | 0xEB 0xB9 0xA0          #Lo       HANGUL SYLLABLE BBA
      | 0xEB 0xB9 0xBC          #Lo       HANGUL SYLLABLE BBAE
      | 0xEB 0xBA 0x98          #Lo       HANGUL SYLLABLE BBYA
      | 0xEB 0xBA 0xB4          #Lo       HANGUL SYLLABLE BBYAE
      | 0xEB 0xBB 0x90          #Lo       HANGUL SYLLABLE BBEO
      | 0xEB 0xBB 0xAC          #Lo       HANGUL SYLLABLE BBE
      | 0xEB 0xBC 0x88          #Lo       HANGUL SYLLABLE BBYEO
      | 0xEB 0xBC 0xA4          #Lo       HANGUL SYLLABLE BBYE
      | 0xEB 0xBD 0x80          #Lo       HANGUL SYLLABLE BBO
      | 0xEB 0xBD 0x9C          #Lo       HANGUL SYLLABLE BBWA
      | 0xEB 0xBD 0xB8          #Lo       HANGUL SYLLABLE BBWAE
      | 0xEB 0xBE 0x94          #Lo       HANGUL SYLLABLE BBOE
      | 0xEB 0xBE 0xB0          #Lo       HANGUL SYLLABLE BBYO
      | 0xEB 0xBF 0x8C          #Lo       HANGUL SYLLABLE BBU
      | 0xEB 0xBF 0xA8          #Lo       HANGUL SYLLABLE BBWEO
      | 0xEC 0x80 0x84          #Lo       HANGUL SYLLABLE BBWE
      | 0xEC 0x80 0xA0          #Lo       HANGUL SYLLABLE BBWI
      | 0xEC 0x80 0xBC          #Lo       HANGUL SYLLABLE BBYU
      | 0xEC 0x81 0x98          #Lo       HANGUL SYLLABLE BBEU
      | 0xEC 0x81 0xB4          #Lo       HANGUL SYLLABLE BBYI
      | 0xEC 0x82 0x90          #Lo       HANGUL SYLLABLE BBI
      | 0xEC 0x82 0xAC          #Lo       HANGUL SYLLABLE SA
      | 0xEC 0x83 0x88          #Lo       HANGUL SYLLABLE SAE
      | 0xEC 0x83 0xA4          #Lo       HANGUL SYLLABLE SYA
      | 0xEC 0x84 0x80          #Lo       HANGUL SYLLABLE SYAE
      | 0xEC 0x84 0x9C          #Lo       HANGUL SYLLABLE SEO
      | 0xEC 0x84 0xB8          #Lo       HANGUL SYLLABLE SE
      | 0xEC 0x85 0x94          #Lo       HANGUL SYLLABLE SYEO
      | 0xEC 0x85 0xB0          #Lo       HANGUL SYLLABLE SYE
      | 0xEC 0x86 0x8C          #Lo       HANGUL SYLLABLE SO
      | 0xEC 0x86 0xA8          #Lo       HANGUL SYLLABLE SWA
      | 0xEC 0x87 0x84          #Lo       HANGUL SYLLABLE SWAE
      | 0xEC 0x87 0xA0          #Lo       HANGUL SYLLABLE SOE
      | 0xEC 0x87 0xBC          #Lo       HANGUL SYLLABLE SYO
      | 0xEC 0x88 0x98          #Lo       HANGUL SYLLABLE SU
      | 0xEC 0x88 0xB4          #Lo       HANGUL SYLLABLE SWEO
      | 0xEC 0x89 0x90          #Lo       HANGUL SYLLABLE SWE
      | 0xEC 0x89 0xAC          #Lo       HANGUL SYLLABLE SWI
      | 0xEC 0x8A 0x88          #Lo       HANGUL SYLLABLE SYU
      | 0xEC 0x8A 0xA4          #Lo       HANGUL SYLLABLE SEU
      | 0xEC 0x8B 0x80          #Lo       HANGUL SYLLABLE SYI
      | 0xEC 0x8B 0x9C          #Lo       HANGUL SYLLABLE SI
      | 0xEC 0x8B 0xB8          #Lo       HANGUL SYLLABLE SSA
      | 0xEC 0x8C 0x94          #Lo       HANGUL SYLLABLE SSAE
      | 0xEC 0x8C 0xB0          #Lo       HANGUL SYLLABLE SSYA
      | 0xEC 0x8D 0x8C          #Lo       HANGUL SYLLABLE SSYAE
      | 0xEC 0x8D 0xA8          #Lo       HANGUL SYLLABLE SSEO
      | 0xEC 0x8E 0x84          #Lo       HANGUL SYLLABLE SSE
      | 0xEC 0x8E 0xA0          #Lo       HANGUL SYLLABLE SSYEO
      | 0xEC 0x8E 0xBC          #Lo       HANGUL SYLLABLE SSYE
      | 0xEC 0x8F 0x98          #Lo       HANGUL SYLLABLE SSO
      | 0xEC 0x8F 0xB4          #Lo       HANGUL SYLLABLE SSWA
      | 0xEC 0x90 0x90          #Lo       HANGUL SYLLABLE SSWAE
      | 0xEC 0x90 0xAC          #Lo       HANGUL SYLLABLE SSOE
      | 0xEC 0x91 0x88          #Lo       HANGUL SYLLABLE SSYO
      | 0xEC 0x91 0xA4          #Lo       HANGUL SYLLABLE SSU
      | 0xEC 0x92 0x80          #Lo       HANGUL SYLLABLE SSWEO
      | 0xEC 0x92 0x9C          #Lo       HANGUL SYLLABLE SSWE
      | 0xEC 0x92 0xB8          #Lo       HANGUL SYLLABLE SSWI
      | 0xEC 0x93 0x94          #Lo       HANGUL SYLLABLE SSYU
      | 0xEC 0x93 0xB0          #Lo       HANGUL SYLLABLE SSEU
      | 0xEC 0x94 0x8C          #Lo       HANGUL SYLLABLE SSYI
      | 0xEC 0x94 0xA8          #Lo       HANGUL SYLLABLE SSI
      | 0xEC 0x95 0x84          #Lo       HANGUL SYLLABLE A
      | 0xEC 0x95 0xA0          #Lo       HANGUL SYLLABLE AE
      | 0xEC 0x95 0xBC          #Lo       HANGUL SYLLABLE YA
      | 0xEC 0x96 0x98          #Lo       HANGUL SYLLABLE YAE
      | 0xEC 0x96 0xB4          #Lo       HANGUL SYLLABLE EO
      | 0xEC 0x97 0x90          #Lo       HANGUL SYLLABLE E
      | 0xEC 0x97 0xAC          #Lo       HANGUL SYLLABLE YEO
      | 0xEC 0x98 0x88          #Lo       HANGUL SYLLABLE YE
      | 0xEC 0x98 0xA4          #Lo       HANGUL SYLLABLE O
      | 0xEC 0x99 0x80          #Lo       HANGUL SYLLABLE WA
      | 0xEC 0x99 0x9C          #Lo       HANGUL SYLLABLE WAE
      | 0xEC 0x99 0xB8          #Lo       HANGUL SYLLABLE OE
      | 0xEC 0x9A 0x94          #Lo       HANGUL SYLLABLE YO
      | 0xEC 0x9A 0xB0          #Lo       HANGUL SYLLABLE U
      | 0xEC 0x9B 0x8C          #Lo       HANGUL SYLLABLE WEO
      | 0xEC 0x9B 0xA8          #Lo       HANGUL SYLLABLE WE
      | 0xEC 0x9C 0x84          #Lo       HANGUL SYLLABLE WI
      | 0xEC 0x9C 0xA0          #Lo       HANGUL SYLLABLE YU
      | 0xEC 0x9C 0xBC          #Lo       HANGUL SYLLABLE EU
      | 0xEC 0x9D 0x98          #Lo       HANGUL SYLLABLE YI
      | 0xEC 0x9D 0xB4          #Lo       HANGUL SYLLABLE I
      | 0xEC 0x9E 0x90          #Lo       HANGUL SYLLABLE JA
      | 0xEC 0x9E 0xAC          #Lo       HANGUL SYLLABLE JAE
      | 0xEC 0x9F 0x88          #Lo       HANGUL SYLLABLE JYA
      | 0xEC 0x9F 0xA4          #Lo       HANGUL SYLLABLE JYAE
      | 0xEC 0xA0 0x80          #Lo       HANGUL SYLLABLE JEO
      | 0xEC 0xA0 0x9C          #Lo       HANGUL SYLLABLE JE
      | 0xEC 0xA0 0xB8          #Lo       HANGUL SYLLABLE JYEO
      | 0xEC 0xA1 0x94          #Lo       HANGUL SYLLABLE JYE
      | 0xEC 0xA1 0xB0          #Lo       HANGUL SYLLABLE JO
      | 0xEC 0xA2 0x8C          #Lo       HANGUL SYLLABLE JWA
      | 0xEC 0xA2 0xA8          #Lo       HANGUL SYLLABLE JWAE
      | 0xEC 0xA3 0x84          #Lo       HANGUL SYLLABLE JOE
      | 0xEC 0xA3 0xA0          #Lo       HANGUL SYLLABLE JYO
      | 0xEC 0xA3 0xBC          #Lo       HANGUL SYLLABLE JU
      | 0xEC 0xA4 0x98          #Lo       HANGUL SYLLABLE JWEO
      | 0xEC 0xA4 0xB4          #Lo       HANGUL SYLLABLE JWE
      | 0xEC 0xA5 0x90          #Lo       HANGUL SYLLABLE JWI
      | 0xEC 0xA5 0xAC          #Lo       HANGUL SYLLABLE JYU
      | 0xEC 0xA6 0x88          #Lo       HANGUL SYLLABLE JEU
      | 0xEC 0xA6 0xA4          #Lo       HANGUL SYLLABLE JYI
      | 0xEC 0xA7 0x80          #Lo       HANGUL SYLLABLE JI
      | 0xEC 0xA7 0x9C          #Lo       HANGUL SYLLABLE JJA
      | 0xEC 0xA7 0xB8          #Lo       HANGUL SYLLABLE JJAE
      | 0xEC 0xA8 0x94          #Lo       HANGUL SYLLABLE JJYA
      | 0xEC 0xA8 0xB0          #Lo       HANGUL SYLLABLE JJYAE
      | 0xEC 0xA9 0x8C          #Lo       HANGUL SYLLABLE JJEO
      | 0xEC 0xA9 0xA8          #Lo       HANGUL SYLLABLE JJE
      | 0xEC 0xAA 0x84          #Lo       HANGUL SYLLABLE JJYEO
      | 0xEC 0xAA 0xA0          #Lo       HANGUL SYLLABLE JJYE
      | 0xEC 0xAA 0xBC          #Lo       HANGUL SYLLABLE JJO
      | 0xEC 0xAB 0x98          #Lo       HANGUL SYLLABLE JJWA
      | 0xEC 0xAB 0xB4          #Lo       HANGUL SYLLABLE JJWAE
      | 0xEC 0xAC 0x90          #Lo       HANGUL SYLLABLE JJOE
      | 0xEC 0xAC 0xAC          #Lo       HANGUL SYLLABLE JJYO
      | 0xEC 0xAD 0x88          #Lo       HANGUL SYLLABLE JJU
      | 0xEC 0xAD 0xA4          #Lo       HANGUL SYLLABLE JJWEO
      | 0xEC 0xAE 0x80          #Lo       HANGUL SYLLABLE JJWE
      | 0xEC 0xAE 0x9C          #Lo       HANGUL SYLLABLE JJWI
      | 0xEC 0xAE 0xB8          #Lo       HANGUL SYLLABLE JJYU
      | 0xEC 0xAF 0x94          #Lo       HANGUL SYLLABLE JJEU
      | 0xEC 0xAF 0xB0          #Lo       HANGUL SYLLABLE JJYI
      | 0xEC 0xB0 0x8C          #Lo       HANGUL SYLLABLE JJI
      | 0xEC 0xB0 0xA8          #Lo       HANGUL SYLLABLE CA
      | 0xEC 0xB1 0x84          #Lo       HANGUL SYLLABLE CAE
      | 0xEC 0xB1 0xA0          #Lo       HANGUL SYLLABLE CYA
      | 0xEC 0xB1 0xBC          #Lo       HANGUL SYLLABLE CYAE
      | 0xEC 0xB2 0x98          #Lo       HANGUL SYLLABLE CEO
      | 0xEC 0xB2 0xB4          #Lo       HANGUL SYLLABLE CE
      | 0xEC 0xB3 0x90          #Lo       HANGUL SYLLABLE CYEO
      | 0xEC 0xB3 0xAC          #Lo       HANGUL SYLLABLE CYE
      | 0xEC 0xB4 0x88          #Lo       HANGUL SYLLABLE CO
      | 0xEC 0xB4 0xA4          #Lo       HANGUL SYLLABLE CWA
      | 0xEC 0xB5 0x80          #Lo       HANGUL SYLLABLE CWAE
      | 0xEC 0xB5 0x9C          #Lo       HANGUL SYLLABLE COE
      | 0xEC 0xB5 0xB8          #Lo       HANGUL SYLLABLE CYO
      | 0xEC 0xB6 0x94          #Lo       HANGUL SYLLABLE CU
      | 0xEC 0xB6 0xB0          #Lo       HANGUL SYLLABLE CWEO
      | 0xEC 0xB7 0x8C          #Lo       HANGUL SYLLABLE CWE
      | 0xEC 0xB7 0xA8          #Lo       HANGUL SYLLABLE CWI
      | 0xEC 0xB8 0x84          #Lo       HANGUL SYLLABLE CYU
      | 0xEC 0xB8 0xA0          #Lo       HANGUL SYLLABLE CEU
      | 0xEC 0xB8 0xBC          #Lo       HANGUL SYLLABLE CYI
      | 0xEC 0xB9 0x98          #Lo       HANGUL SYLLABLE CI
      | 0xEC 0xB9 0xB4          #Lo       HANGUL SYLLABLE KA
      | 0xEC 0xBA 0x90          #Lo       HANGUL SYLLABLE KAE
      | 0xEC 0xBA 0xAC          #Lo       HANGUL SYLLABLE KYA
      | 0xEC 0xBB 0x88          #Lo       HANGUL SYLLABLE KYAE
      | 0xEC 0xBB 0xA4          #Lo       HANGUL SYLLABLE KEO
      | 0xEC 0xBC 0x80          #Lo       HANGUL SYLLABLE KE
      | 0xEC 0xBC 0x9C          #Lo       HANGUL SYLLABLE KYEO
      | 0xEC 0xBC 0xB8          #Lo       HANGUL SYLLABLE KYE
      | 0xEC 0xBD 0x94          #Lo       HANGUL SYLLABLE KO
      | 0xEC 0xBD 0xB0          #Lo       HANGUL SYLLABLE KWA
      | 0xEC 0xBE 0x8C          #Lo       HANGUL SYLLABLE KWAE
      | 0xEC 0xBE 0xA8          #Lo       HANGUL SYLLABLE KOE
      | 0xEC 0xBF 0x84          #Lo       HANGUL SYLLABLE KYO
      | 0xEC 0xBF 0xA0          #Lo       HANGUL SYLLABLE KU
      | 0xEC 0xBF 0xBC          #Lo       HANGUL SYLLABLE KWEO
      | 0xED 0x80 0x98          #Lo       HANGUL SYLLABLE KWE
      | 0xED 0x80 0xB4          #Lo       HANGUL SYLLABLE KWI
      | 0xED 0x81 0x90          #Lo       HANGUL SYLLABLE KYU
      | 0xED 0x81 0xAC          #Lo       HANGUL SYLLABLE KEU
      | 0xED 0x82 0x88          #Lo       HANGUL SYLLABLE KYI
      | 0xED 0x82 0xA4          #Lo       HANGUL SYLLABLE KI
      | 0xED 0x83 0x80          #Lo       HANGUL SYLLABLE TA
      | 0xED 0x83 0x9C          #Lo       HANGUL SYLLABLE TAE
      | 0xED 0x83 0xB8          #Lo       HANGUL SYLLABLE TYA
      | 0xED 0x84 0x94          #Lo       HANGUL SYLLABLE TYAE
      | 0xED 0x84 0xB0          #Lo       HANGUL SYLLABLE TEO
      | 0xED 0x85 0x8C          #Lo       HANGUL SYLLABLE TE
      | 0xED 0x85 0xA8          #Lo       HANGUL SYLLABLE TYEO
      | 0xED 0x86 0x84          #Lo       HANGUL SYLLABLE TYE
      | 0xED 0x86 0xA0          #Lo       HANGUL SYLLABLE TO
      | 0xED 0x86 0xBC          #Lo       HANGUL SYLLABLE TWA
      | 0xED 0x87 0x98          #Lo       HANGUL SYLLABLE TWAE
      | 0xED 0x87 0xB4          #Lo       HANGUL SYLLABLE TOE
      | 0xED 0x88 0x90          #Lo       HANGUL SYLLABLE TYO
      | 0xED 0x88 0xAC          #Lo       HANGUL SYLLABLE TU
      | 0xED 0x89 0x88          #Lo       HANGUL SYLLABLE TWEO
      | 0xED 0x89 0xA4          #Lo       HANGUL SYLLABLE TWE
      | 0xED 0x8A 0x80          #Lo       HANGUL SYLLABLE TWI
      | 0xED 0x8A 0x9C          #Lo       HANGUL SYLLABLE TYU
      | 0xED 0x8A 0xB8          #Lo       HANGUL SYLLABLE TEU
      | 0xED 0x8B 0x94          #Lo       HANGUL SYLLABLE TYI
      | 0xED 0x8B 0xB0          #Lo       HANGUL SYLLABLE TI
      | 0xED 0x8C 0x8C          #Lo       HANGUL SYLLABLE PA
      | 0xED 0x8C 0xA8          #Lo       HANGUL SYLLABLE PAE
      | 0xED 0x8D 0x84          #Lo       HANGUL SYLLABLE PYA
      | 0xED 0x8D 0xA0          #Lo       HANGUL SYLLABLE PYAE
      | 0xED 0x8D 0xBC          #Lo       HANGUL SYLLABLE PEO
      | 0xED 0x8E 0x98          #Lo       HANGUL SYLLABLE PE
      | 0xED 0x8E 0xB4          #Lo       HANGUL SYLLABLE PYEO
      | 0xED 0x8F 0x90          #Lo       HANGUL SYLLABLE PYE
      | 0xED 0x8F 0xAC          #Lo       HANGUL SYLLABLE PO
      | 0xED 0x90 0x88          #Lo       HANGUL SYLLABLE PWA
      | 0xED 0x90 0xA4          #Lo       HANGUL SYLLABLE PWAE
      | 0xED 0x91 0x80          #Lo       HANGUL SYLLABLE POE
      | 0xED 0x91 0x9C          #Lo       HANGUL SYLLABLE PYO
      | 0xED 0x91 0xB8          #Lo       HANGUL SYLLABLE PU
      | 0xED 0x92 0x94          #Lo       HANGUL SYLLABLE PWEO
      | 0xED 0x92 0xB0          #Lo       HANGUL SYLLABLE PWE
      | 0xED 0x93 0x8C          #Lo       HANGUL SYLLABLE PWI
      | 0xED 0x93 0xA8          #Lo       HANGUL SYLLABLE PYU
      | 0xED 0x94 0x84          #Lo       HANGUL SYLLABLE PEU
      | 0xED 0x94 0xA0          #Lo       HANGUL SYLLABLE PYI
      | 0xED 0x94 0xBC          #Lo       HANGUL SYLLABLE PI
      | 0xED 0x95 0x98          #Lo       HANGUL SYLLABLE HA
      | 0xED 0x95 0xB4          #Lo       HANGUL SYLLABLE HAE
      | 0xED 0x96 0x90          #Lo       HANGUL SYLLABLE HYA
      | 0xED 0x96 0xAC          #Lo       HANGUL SYLLABLE HYAE
      | 0xED 0x97 0x88          #Lo       HANGUL SYLLABLE HEO
      | 0xED 0x97 0xA4          #Lo       HANGUL SYLLABLE HE
      | 0xED 0x98 0x80          #Lo       HANGUL SYLLABLE HYEO
      | 0xED 0x98 0x9C          #Lo       HANGUL SYLLABLE HYE
      | 0xED 0x98 0xB8          #Lo       HANGUL SYLLABLE HO
      | 0xED 0x99 0x94          #Lo       HANGUL SYLLABLE HWA
      | 0xED 0x99 0xB0          #Lo       HANGUL SYLLABLE HWAE
      | 0xED 0x9A 0x8C          #Lo       HANGUL SYLLABLE HOE
      | 0xED 0x9A 0xA8          #Lo       HANGUL SYLLABLE HYO
      | 0xED 0x9B 0x84          #Lo       HANGUL SYLLABLE HU
      | 0xED 0x9B 0xA0          #Lo       HANGUL SYLLABLE HWEO
      | 0xED 0x9B 0xBC          #Lo       HANGUL SYLLABLE HWE
      | 0xED 0x9C 0x98          #Lo       HANGUL SYLLABLE HWI
      | 0xED 0x9C 0xB4          #Lo       HANGUL SYLLABLE HYU
      | 0xED 0x9D 0x90          #Lo       HANGUL SYLLABLE HEU
      | 0xED 0x9D 0xAC          #Lo       HANGUL SYLLABLE HYI
      | 0xED 0x9E 0x88          #Lo       HANGUL SYLLABLE HI
      ;

    LVT = 
        0xEA 0xB0 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE GAG..HANGUL SYLLAB...
      | 0xEA 0xB0 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE GAEG..HANGUL SYLLA...
      | 0xEA 0xB0 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE GYAG..HANGUL SYLLA...
      | 0xEA 0xB1 0x00..0x93    #
      | 0xEA 0xB1 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE GYAEG..HANGUL SYLL...
      | 0xEA 0xB1 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE GEOG..HANGUL SYLLA...
      | 0xEA 0xB2 0x00..0x8B    #
      | 0xEA 0xB2 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE GEG..HANGUL SYLLAB...
      | 0xEA 0xB2 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE GYEOG..HANGUL SYLL...
      | 0xEA 0xB3 0x00..0x83    #
      | 0xEA 0xB3 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE GYEG..HANGUL SYLLA...
      | 0xEA 0xB3 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE GOG..HANGUL SYLLAB...
      | 0xEA 0xB3 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE GWAG..HANGUL SYLLA...
      | 0xEA 0xB4 0x00..0x97    #
      | 0xEA 0xB4 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE GWAEG..HANGUL SYLL...
      | 0xEA 0xB4 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE GOEG..HANGUL SYLLA...
      | 0xEA 0xB5 0x00..0x8F    #
      | 0xEA 0xB5 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE GYOG..HANGUL SYLLA...
      | 0xEA 0xB5 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE GUG..HANGUL SYLLAB...
      | 0xEA 0xB6 0x00..0x87    #
      | 0xEA 0xB6 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE GWEOG..HANGUL SYLL...
      | 0xEA 0xB6 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE GWEG..HANGUL SYLLA...
      | 0xEA 0xB7 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE GWIG..HANGUL SYLLA...
      | 0xEA 0xB7 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE GYUG..HANGUL SYLLA...
      | 0xEA 0xB7 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE GEUG..HANGUL SYLLA...
      | 0xEA 0xB8 0x00..0x93    #
      | 0xEA 0xB8 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE GYIG..HANGUL SYLLA...
      | 0xEA 0xB8 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE GIG..HANGUL SYLLAB...
      | 0xEA 0xB9 0x00..0x8B    #
      | 0xEA 0xB9 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE GGAG..HANGUL SYLLA...
      | 0xEA 0xB9 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE GGAEG..HANGUL SYLL...
      | 0xEA 0xBA 0x00..0x83    #
      | 0xEA 0xBA 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE GGYAG..HANGUL SYLL...
      | 0xEA 0xBA 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE GGYAEG..HANGUL SYL...
      | 0xEA 0xBA 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE GGEOG..HANGUL SYLL...
      | 0xEA 0xBB 0x00..0x97    #
      | 0xEA 0xBB 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE GGEG..HANGUL SYLLA...
      | 0xEA 0xBB 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE GGYEOG..HANGUL SYL...
      | 0xEA 0xBC 0x00..0x8F    #
      | 0xEA 0xBC 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE GGYEG..HANGUL SYLL...
      | 0xEA 0xBC 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE GGOG..HANGUL SYLLA...
      | 0xEA 0xBD 0x00..0x87    #
      | 0xEA 0xBD 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE GGWAG..HANGUL SYLL...
      | 0xEA 0xBD 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE GGWAEG..HANGUL SYL...
      | 0xEA 0xBE 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE GGOEG..HANGUL SYLL...
      | 0xEA 0xBE 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE GGYOG..HANGUL SYLL...
      | 0xEA 0xBE 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE GGUG..HANGUL SYLLA...
      | 0xEA 0xBF 0x00..0x93    #
      | 0xEA 0xBF 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE GGWEOG..HANGUL SYL...
      | 0xEA 0xBF 0xB1..0xFF        #Lo  [27] HANGUL SYLLABLE GGWEG..HANGUL ...
      | 0xEA 0xC0..0xFF 0x00..0xFF  #
      | 0xEB 0x00 0x00..0xFF        #
      | 0xEB 0x01..0x7F 0x00..0xFF  #
      | 0xEB 0x80 0x00..0x8B        #
      | 0xEB 0x80 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE GGWIG..HANGUL SYLL...
      | 0xEB 0x80 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE GGYUG..HANGUL SYLL...
      | 0xEB 0x81 0x00..0x83    #
      | 0xEB 0x81 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE GGEUG..HANGUL SYLL...
      | 0xEB 0x81 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE GGYIG..HANGUL SYLL...
      | 0xEB 0x81 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE GGIG..HANGUL SYLLA...
      | 0xEB 0x82 0x00..0x97    #
      | 0xEB 0x82 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE NAG..HANGUL SYLLAB...
      | 0xEB 0x82 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE NAEG..HANGUL SYLLA...
      | 0xEB 0x83 0x00..0x8F    #
      | 0xEB 0x83 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE NYAG..HANGUL SYLLA...
      | 0xEB 0x83 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE NYAEG..HANGUL SYLL...
      | 0xEB 0x84 0x00..0x87    #
      | 0xEB 0x84 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE NEOG..HANGUL SYLLA...
      | 0xEB 0x84 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE NEG..HANGUL SYLLAB...
      | 0xEB 0x85 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE NYEOG..HANGUL SYLL...
      | 0xEB 0x85 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE NYEG..HANGUL SYLLA...
      | 0xEB 0x85 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE NOG..HANGUL SYLLAB...
      | 0xEB 0x86 0x00..0x93    #
      | 0xEB 0x86 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE NWAG..HANGUL SYLLA...
      | 0xEB 0x86 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE NWAEG..HANGUL SYLL...
      | 0xEB 0x87 0x00..0x8B    #
      | 0xEB 0x87 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE NOEG..HANGUL SYLLA...
      | 0xEB 0x87 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE NYOG..HANGUL SYLLA...
      | 0xEB 0x88 0x00..0x83    #
      | 0xEB 0x88 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE NUG..HANGUL SYLLAB...
      | 0xEB 0x88 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE NWEOG..HANGUL SYLL...
      | 0xEB 0x88 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE NWEG..HANGUL SYLLA...
      | 0xEB 0x89 0x00..0x97    #
      | 0xEB 0x89 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE NWIG..HANGUL SYLLA...
      | 0xEB 0x89 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE NYUG..HANGUL SYLLA...
      | 0xEB 0x8A 0x00..0x8F    #
      | 0xEB 0x8A 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE NEUG..HANGUL SYLLA...
      | 0xEB 0x8A 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE NYIG..HANGUL SYLLA...
      | 0xEB 0x8B 0x00..0x87    #
      | 0xEB 0x8B 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE NIG..HANGUL SYLLAB...
      | 0xEB 0x8B 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE DAG..HANGUL SYLLAB...
      | 0xEB 0x8C 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE DAEG..HANGUL SYLLA...
      | 0xEB 0x8C 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE DYAG..HANGUL SYLLA...
      | 0xEB 0x8C 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE DYAEG..HANGUL SYLL...
      | 0xEB 0x8D 0x00..0x93    #
      | 0xEB 0x8D 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE DEOG..HANGUL SYLLA...
      | 0xEB 0x8D 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE DEG..HANGUL SYLLAB...
      | 0xEB 0x8E 0x00..0x8B    #
      | 0xEB 0x8E 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE DYEOG..HANGUL SYLL...
      | 0xEB 0x8E 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE DYEG..HANGUL SYLLA...
      | 0xEB 0x8F 0x00..0x83    #
      | 0xEB 0x8F 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE DOG..HANGUL SYLLAB...
      | 0xEB 0x8F 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE DWAG..HANGUL SYLLA...
      | 0xEB 0x8F 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE DWAEG..HANGUL SYLL...
      | 0xEB 0x90 0x00..0x97    #
      | 0xEB 0x90 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE DOEG..HANGUL SYLLA...
      | 0xEB 0x90 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE DYOG..HANGUL SYLLA...
      | 0xEB 0x91 0x00..0x8F    #
      | 0xEB 0x91 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE DUG..HANGUL SYLLAB...
      | 0xEB 0x91 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE DWEOG..HANGUL SYLL...
      | 0xEB 0x92 0x00..0x87    #
      | 0xEB 0x92 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE DWEG..HANGUL SYLLA...
      | 0xEB 0x92 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE DWIG..HANGUL SYLLA...
      | 0xEB 0x93 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE DYUG..HANGUL SYLLA...
      | 0xEB 0x93 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE DEUG..HANGUL SYLLA...
      | 0xEB 0x93 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE DYIG..HANGUL SYLLA...
      | 0xEB 0x94 0x00..0x93    #
      | 0xEB 0x94 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE DIG..HANGUL SYLLAB...
      | 0xEB 0x94 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE DDAG..HANGUL SYLLA...
      | 0xEB 0x95 0x00..0x8B    #
      | 0xEB 0x95 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE DDAEG..HANGUL SYLL...
      | 0xEB 0x95 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE DDYAG..HANGUL SYLL...
      | 0xEB 0x96 0x00..0x83    #
      | 0xEB 0x96 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE DDYAEG..HANGUL SYL...
      | 0xEB 0x96 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE DDEOG..HANGUL SYLL...
      | 0xEB 0x96 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE DDEG..HANGUL SYLLA...
      | 0xEB 0x97 0x00..0x97    #
      | 0xEB 0x97 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE DDYEOG..HANGUL SYL...
      | 0xEB 0x97 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE DDYEG..HANGUL SYLL...
      | 0xEB 0x98 0x00..0x8F    #
      | 0xEB 0x98 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE DDOG..HANGUL SYLLA...
      | 0xEB 0x98 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE DDWAG..HANGUL SYLL...
      | 0xEB 0x99 0x00..0x87    #
      | 0xEB 0x99 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE DDWAEG..HANGUL SYL...
      | 0xEB 0x99 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE DDOEG..HANGUL SYLL...
      | 0xEB 0x9A 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE DDYOG..HANGUL SYLL...
      | 0xEB 0x9A 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE DDUG..HANGUL SYLLA...
      | 0xEB 0x9A 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE DDWEOG..HANGUL SYL...
      | 0xEB 0x9B 0x00..0x93    #
      | 0xEB 0x9B 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE DDWEG..HANGUL SYLL...
      | 0xEB 0x9B 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE DDWIG..HANGUL SYLL...
      | 0xEB 0x9C 0x00..0x8B    #
      | 0xEB 0x9C 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE DDYUG..HANGUL SYLL...
      | 0xEB 0x9C 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE DDEUG..HANGUL SYLL...
      | 0xEB 0x9D 0x00..0x83    #
      | 0xEB 0x9D 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE DDYIG..HANGUL SYLL...
      | 0xEB 0x9D 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE DDIG..HANGUL SYLLA...
      | 0xEB 0x9D 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE RAG..HANGUL SYLLAB...
      | 0xEB 0x9E 0x00..0x97    #
      | 0xEB 0x9E 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE RAEG..HANGUL SYLLA...
      | 0xEB 0x9E 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE RYAG..HANGUL SYLLA...
      | 0xEB 0x9F 0x00..0x8F    #
      | 0xEB 0x9F 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE RYAEG..HANGUL SYLL...
      | 0xEB 0x9F 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE REOG..HANGUL SYLLA...
      | 0xEB 0xA0 0x00..0x87    #
      | 0xEB 0xA0 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE REG..HANGUL SYLLAB...
      | 0xEB 0xA0 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE RYEOG..HANGUL SYLL...
      | 0xEB 0xA1 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE RYEG..HANGUL SYLLA...
      | 0xEB 0xA1 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE ROG..HANGUL SYLLAB...
      | 0xEB 0xA1 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE RWAG..HANGUL SYLLA...
      | 0xEB 0xA2 0x00..0x93    #
      | 0xEB 0xA2 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE RWAEG..HANGUL SYLL...
      | 0xEB 0xA2 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE ROEG..HANGUL SYLLA...
      | 0xEB 0xA3 0x00..0x8B    #
      | 0xEB 0xA3 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE RYOG..HANGUL SYLLA...
      | 0xEB 0xA3 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE RUG..HANGUL SYLLAB...
      | 0xEB 0xA4 0x00..0x83    #
      | 0xEB 0xA4 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE RWEOG..HANGUL SYLL...
      | 0xEB 0xA4 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE RWEG..HANGUL SYLLA...
      | 0xEB 0xA4 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE RWIG..HANGUL SYLLA...
      | 0xEB 0xA5 0x00..0x97    #
      | 0xEB 0xA5 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE RYUG..HANGUL SYLLA...
      | 0xEB 0xA5 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE REUG..HANGUL SYLLA...
      | 0xEB 0xA6 0x00..0x8F    #
      | 0xEB 0xA6 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE RYIG..HANGUL SYLLA...
      | 0xEB 0xA6 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE RIG..HANGUL SYLLAB...
      | 0xEB 0xA7 0x00..0x87    #
      | 0xEB 0xA7 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE MAG..HANGUL SYLLAB...
      | 0xEB 0xA7 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE MAEG..HANGUL SYLLA...
      | 0xEB 0xA8 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE MYAG..HANGUL SYLLA...
      | 0xEB 0xA8 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE MYAEG..HANGUL SYLL...
      | 0xEB 0xA8 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE MEOG..HANGUL SYLLA...
      | 0xEB 0xA9 0x00..0x93    #
      | 0xEB 0xA9 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE MEG..HANGUL SYLLAB...
      | 0xEB 0xA9 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE MYEOG..HANGUL SYLL...
      | 0xEB 0xAA 0x00..0x8B    #
      | 0xEB 0xAA 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE MYEG..HANGUL SYLLA...
      | 0xEB 0xAA 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE MOG..HANGUL SYLLAB...
      | 0xEB 0xAB 0x00..0x83    #
      | 0xEB 0xAB 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE MWAG..HANGUL SYLLA...
      | 0xEB 0xAB 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE MWAEG..HANGUL SYLL...
      | 0xEB 0xAB 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE MOEG..HANGUL SYLLA...
      | 0xEB 0xAC 0x00..0x97    #
      | 0xEB 0xAC 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE MYOG..HANGUL SYLLA...
      | 0xEB 0xAC 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE MUG..HANGUL SYLLAB...
      | 0xEB 0xAD 0x00..0x8F    #
      | 0xEB 0xAD 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE MWEOG..HANGUL SYLL...
      | 0xEB 0xAD 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE MWEG..HANGUL SYLLA...
      | 0xEB 0xAE 0x00..0x87    #
      | 0xEB 0xAE 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE MWIG..HANGUL SYLLA...
      | 0xEB 0xAE 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE MYUG..HANGUL SYLLA...
      | 0xEB 0xAF 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE MEUG..HANGUL SYLLA...
      | 0xEB 0xAF 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE MYIG..HANGUL SYLLA...
      | 0xEB 0xAF 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE MIG..HANGUL SYLLAB...
      | 0xEB 0xB0 0x00..0x93    #
      | 0xEB 0xB0 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE BAG..HANGUL SYLLAB...
      | 0xEB 0xB0 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE BAEG..HANGUL SYLLA...
      | 0xEB 0xB1 0x00..0x8B    #
      | 0xEB 0xB1 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE BYAG..HANGUL SYLLA...
      | 0xEB 0xB1 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE BYAEG..HANGUL SYLL...
      | 0xEB 0xB2 0x00..0x83    #
      | 0xEB 0xB2 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE BEOG..HANGUL SYLLA...
      | 0xEB 0xB2 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE BEG..HANGUL SYLLAB...
      | 0xEB 0xB2 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE BYEOG..HANGUL SYLL...
      | 0xEB 0xB3 0x00..0x97    #
      | 0xEB 0xB3 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE BYEG..HANGUL SYLLA...
      | 0xEB 0xB3 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE BOG..HANGUL SYLLAB...
      | 0xEB 0xB4 0x00..0x8F    #
      | 0xEB 0xB4 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE BWAG..HANGUL SYLLA...
      | 0xEB 0xB4 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE BWAEG..HANGUL SYLL...
      | 0xEB 0xB5 0x00..0x87    #
      | 0xEB 0xB5 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE BOEG..HANGUL SYLLA...
      | 0xEB 0xB5 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE BYOG..HANGUL SYLLA...
      | 0xEB 0xB6 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE BUG..HANGUL SYLLAB...
      | 0xEB 0xB6 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE BWEOG..HANGUL SYLL...
      | 0xEB 0xB6 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE BWEG..HANGUL SYLLA...
      | 0xEB 0xB7 0x00..0x93    #
      | 0xEB 0xB7 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE BWIG..HANGUL SYLLA...
      | 0xEB 0xB7 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE BYUG..HANGUL SYLLA...
      | 0xEB 0xB8 0x00..0x8B    #
      | 0xEB 0xB8 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE BEUG..HANGUL SYLLA...
      | 0xEB 0xB8 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE BYIG..HANGUL SYLLA...
      | 0xEB 0xB9 0x00..0x83    #
      | 0xEB 0xB9 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE BIG..HANGUL SYLLAB...
      | 0xEB 0xB9 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE BBAG..HANGUL SYLLA...
      | 0xEB 0xB9 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE BBAEG..HANGUL SYLL...
      | 0xEB 0xBA 0x00..0x97    #
      | 0xEB 0xBA 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE BBYAG..HANGUL SYLL...
      | 0xEB 0xBA 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE BBYAEG..HANGUL SYL...
      | 0xEB 0xBB 0x00..0x8F    #
      | 0xEB 0xBB 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE BBEOG..HANGUL SYLL...
      | 0xEB 0xBB 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE BBEG..HANGUL SYLLA...
      | 0xEB 0xBC 0x00..0x87    #
      | 0xEB 0xBC 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE BBYEOG..HANGUL SYL...
      | 0xEB 0xBC 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE BBYEG..HANGUL SYLL...
      | 0xEB 0xBD 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE BBOG..HANGUL SYLLA...
      | 0xEB 0xBD 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE BBWAG..HANGUL SYLL...
      | 0xEB 0xBD 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE BBWAEG..HANGUL SYL...
      | 0xEB 0xBE 0x00..0x93    #
      | 0xEB 0xBE 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE BBOEG..HANGUL SYLL...
      | 0xEB 0xBE 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE BBYOG..HANGUL SYLL...
      | 0xEB 0xBF 0x00..0x8B    #
      | 0xEB 0xBF 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE BBUG..HANGUL SYLLA...
      | 0xEB 0xBF 0xA9..0xFF        #Lo  [27] HANGUL SYLLABLE BBWEOG..HANGUL...
      | 0xEB 0xC0..0xFF 0x00..0xFF  #
      | 0xEC 0x00 0x00..0xFF        #
      | 0xEC 0x01..0x7F 0x00..0xFF  #
      | 0xEC 0x80 0x00..0x83        #
      | 0xEC 0x80 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE BBWEG..HANGUL SYLL...
      | 0xEC 0x80 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE BBWIG..HANGUL SYLL...
      | 0xEC 0x80 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE BBYUG..HANGUL SYLL...
      | 0xEC 0x81 0x00..0x97    #
      | 0xEC 0x81 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE BBEUG..HANGUL SYLL...
      | 0xEC 0x81 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE BBYIG..HANGUL SYLL...
      | 0xEC 0x82 0x00..0x8F    #
      | 0xEC 0x82 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE BBIG..HANGUL SYLLA...
      | 0xEC 0x82 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE SAG..HANGUL SYLLAB...
      | 0xEC 0x83 0x00..0x87    #
      | 0xEC 0x83 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE SAEG..HANGUL SYLLA...
      | 0xEC 0x83 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE SYAG..HANGUL SYLLA...
      | 0xEC 0x84 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE SYAEG..HANGUL SYLL...
      | 0xEC 0x84 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE SEOG..HANGUL SYLLA...
      | 0xEC 0x84 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE SEG..HANGUL SYLLAB...
      | 0xEC 0x85 0x00..0x93    #
      | 0xEC 0x85 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE SYEOG..HANGUL SYLL...
      | 0xEC 0x85 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE SYEG..HANGUL SYLLA...
      | 0xEC 0x86 0x00..0x8B    #
      | 0xEC 0x86 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE SOG..HANGUL SYLLAB...
      | 0xEC 0x86 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE SWAG..HANGUL SYLLA...
      | 0xEC 0x87 0x00..0x83    #
      | 0xEC 0x87 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE SWAEG..HANGUL SYLL...
      | 0xEC 0x87 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE SOEG..HANGUL SYLLA...
      | 0xEC 0x87 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE SYOG..HANGUL SYLLA...
      | 0xEC 0x88 0x00..0x97    #
      | 0xEC 0x88 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE SUG..HANGUL SYLLAB...
      | 0xEC 0x88 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE SWEOG..HANGUL SYLL...
      | 0xEC 0x89 0x00..0x8F    #
      | 0xEC 0x89 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE SWEG..HANGUL SYLLA...
      | 0xEC 0x89 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE SWIG..HANGUL SYLLA...
      | 0xEC 0x8A 0x00..0x87    #
      | 0xEC 0x8A 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE SYUG..HANGUL SYLLA...
      | 0xEC 0x8A 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE SEUG..HANGUL SYLLA...
      | 0xEC 0x8B 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE SYIG..HANGUL SYLLA...
      | 0xEC 0x8B 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE SIG..HANGUL SYLLAB...
      | 0xEC 0x8B 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE SSAG..HANGUL SYLLA...
      | 0xEC 0x8C 0x00..0x93    #
      | 0xEC 0x8C 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE SSAEG..HANGUL SYLL...
      | 0xEC 0x8C 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE SSYAG..HANGUL SYLL...
      | 0xEC 0x8D 0x00..0x8B    #
      | 0xEC 0x8D 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE SSYAEG..HANGUL SYL...
      | 0xEC 0x8D 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE SSEOG..HANGUL SYLL...
      | 0xEC 0x8E 0x00..0x83    #
      | 0xEC 0x8E 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE SSEG..HANGUL SYLLA...
      | 0xEC 0x8E 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE SSYEOG..HANGUL SYL...
      | 0xEC 0x8E 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE SSYEG..HANGUL SYLL...
      | 0xEC 0x8F 0x00..0x97    #
      | 0xEC 0x8F 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE SSOG..HANGUL SYLLA...
      | 0xEC 0x8F 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE SSWAG..HANGUL SYLL...
      | 0xEC 0x90 0x00..0x8F    #
      | 0xEC 0x90 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE SSWAEG..HANGUL SYL...
      | 0xEC 0x90 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE SSOEG..HANGUL SYLL...
      | 0xEC 0x91 0x00..0x87    #
      | 0xEC 0x91 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE SSYOG..HANGUL SYLL...
      | 0xEC 0x91 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE SSUG..HANGUL SYLLA...
      | 0xEC 0x92 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE SSWEOG..HANGUL SYL...
      | 0xEC 0x92 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE SSWEG..HANGUL SYLL...
      | 0xEC 0x92 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE SSWIG..HANGUL SYLL...
      | 0xEC 0x93 0x00..0x93    #
      | 0xEC 0x93 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE SSYUG..HANGUL SYLL...
      | 0xEC 0x93 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE SSEUG..HANGUL SYLL...
      | 0xEC 0x94 0x00..0x8B    #
      | 0xEC 0x94 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE SSYIG..HANGUL SYLL...
      | 0xEC 0x94 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE SSIG..HANGUL SYLLA...
      | 0xEC 0x95 0x00..0x83    #
      | 0xEC 0x95 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE AG..HANGUL SYLLABL...
      | 0xEC 0x95 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE AEG..HANGUL SYLLAB...
      | 0xEC 0x95 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE YAG..HANGUL SYLLAB...
      | 0xEC 0x96 0x00..0x97    #
      | 0xEC 0x96 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE YAEG..HANGUL SYLLA...
      | 0xEC 0x96 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE EOG..HANGUL SYLLAB...
      | 0xEC 0x97 0x00..0x8F    #
      | 0xEC 0x97 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE EG..HANGUL SYLLABL...
      | 0xEC 0x97 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE YEOG..HANGUL SYLLA...
      | 0xEC 0x98 0x00..0x87    #
      | 0xEC 0x98 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE YEG..HANGUL SYLLAB...
      | 0xEC 0x98 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE OG..HANGUL SYLLABL...
      | 0xEC 0x99 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE WAG..HANGUL SYLLAB...
      | 0xEC 0x99 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE WAEG..HANGUL SYLLA...
      | 0xEC 0x99 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE OEG..HANGUL SYLLAB...
      | 0xEC 0x9A 0x00..0x93    #
      | 0xEC 0x9A 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE YOG..HANGUL SYLLAB...
      | 0xEC 0x9A 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE UG..HANGUL SYLLABL...
      | 0xEC 0x9B 0x00..0x8B    #
      | 0xEC 0x9B 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE WEOG..HANGUL SYLLA...
      | 0xEC 0x9B 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE WEG..HANGUL SYLLAB...
      | 0xEC 0x9C 0x00..0x83    #
      | 0xEC 0x9C 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE WIG..HANGUL SYLLAB...
      | 0xEC 0x9C 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE YUG..HANGUL SYLLAB...
      | 0xEC 0x9C 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE EUG..HANGUL SYLLAB...
      | 0xEC 0x9D 0x00..0x97    #
      | 0xEC 0x9D 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE YIG..HANGUL SYLLAB...
      | 0xEC 0x9D 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE IG..HANGUL SYLLABL...
      | 0xEC 0x9E 0x00..0x8F    #
      | 0xEC 0x9E 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE JAG..HANGUL SYLLAB...
      | 0xEC 0x9E 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE JAEG..HANGUL SYLLA...
      | 0xEC 0x9F 0x00..0x87    #
      | 0xEC 0x9F 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE JYAG..HANGUL SYLLA...
      | 0xEC 0x9F 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE JYAEG..HANGUL SYLL...
      | 0xEC 0xA0 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE JEOG..HANGUL SYLLA...
      | 0xEC 0xA0 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE JEG..HANGUL SYLLAB...
      | 0xEC 0xA0 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE JYEOG..HANGUL SYLL...
      | 0xEC 0xA1 0x00..0x93    #
      | 0xEC 0xA1 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE JYEG..HANGUL SYLLA...
      | 0xEC 0xA1 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE JOG..HANGUL SYLLAB...
      | 0xEC 0xA2 0x00..0x8B    #
      | 0xEC 0xA2 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE JWAG..HANGUL SYLLA...
      | 0xEC 0xA2 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE JWAEG..HANGUL SYLL...
      | 0xEC 0xA3 0x00..0x83    #
      | 0xEC 0xA3 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE JOEG..HANGUL SYLLA...
      | 0xEC 0xA3 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE JYOG..HANGUL SYLLA...
      | 0xEC 0xA3 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE JUG..HANGUL SYLLAB...
      | 0xEC 0xA4 0x00..0x97    #
      | 0xEC 0xA4 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE JWEOG..HANGUL SYLL...
      | 0xEC 0xA4 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE JWEG..HANGUL SYLLA...
      | 0xEC 0xA5 0x00..0x8F    #
      | 0xEC 0xA5 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE JWIG..HANGUL SYLLA...
      | 0xEC 0xA5 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE JYUG..HANGUL SYLLA...
      | 0xEC 0xA6 0x00..0x87    #
      | 0xEC 0xA6 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE JEUG..HANGUL SYLLA...
      | 0xEC 0xA6 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE JYIG..HANGUL SYLLA...
      | 0xEC 0xA7 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE JIG..HANGUL SYLLAB...
      | 0xEC 0xA7 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE JJAG..HANGUL SYLLA...
      | 0xEC 0xA7 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE JJAEG..HANGUL SYLL...
      | 0xEC 0xA8 0x00..0x93    #
      | 0xEC 0xA8 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE JJYAG..HANGUL SYLL...
      | 0xEC 0xA8 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE JJYAEG..HANGUL SYL...
      | 0xEC 0xA9 0x00..0x8B    #
      | 0xEC 0xA9 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE JJEOG..HANGUL SYLL...
      | 0xEC 0xA9 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE JJEG..HANGUL SYLLA...
      | 0xEC 0xAA 0x00..0x83    #
      | 0xEC 0xAA 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE JJYEOG..HANGUL SYL...
      | 0xEC 0xAA 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE JJYEG..HANGUL SYLL...
      | 0xEC 0xAA 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE JJOG..HANGUL SYLLA...
      | 0xEC 0xAB 0x00..0x97    #
      | 0xEC 0xAB 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE JJWAG..HANGUL SYLL...
      | 0xEC 0xAB 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE JJWAEG..HANGUL SYL...
      | 0xEC 0xAC 0x00..0x8F    #
      | 0xEC 0xAC 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE JJOEG..HANGUL SYLL...
      | 0xEC 0xAC 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE JJYOG..HANGUL SYLL...
      | 0xEC 0xAD 0x00..0x87    #
      | 0xEC 0xAD 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE JJUG..HANGUL SYLLA...
      | 0xEC 0xAD 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE JJWEOG..HANGUL SYL...
      | 0xEC 0xAE 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE JJWEG..HANGUL SYLL...
      | 0xEC 0xAE 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE JJWIG..HANGUL SYLL...
      | 0xEC 0xAE 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE JJYUG..HANGUL SYLL...
      | 0xEC 0xAF 0x00..0x93    #
      | 0xEC 0xAF 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE JJEUG..HANGUL SYLL...
      | 0xEC 0xAF 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE JJYIG..HANGUL SYLL...
      | 0xEC 0xB0 0x00..0x8B    #
      | 0xEC 0xB0 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE JJIG..HANGUL SYLLA...
      | 0xEC 0xB0 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE CAG..HANGUL SYLLAB...
      | 0xEC 0xB1 0x00..0x83    #
      | 0xEC 0xB1 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE CAEG..HANGUL SYLLA...
      | 0xEC 0xB1 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE CYAG..HANGUL SYLLA...
      | 0xEC 0xB1 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE CYAEG..HANGUL SYLL...
      | 0xEC 0xB2 0x00..0x97    #
      | 0xEC 0xB2 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE CEOG..HANGUL SYLLA...
      | 0xEC 0xB2 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE CEG..HANGUL SYLLAB...
      | 0xEC 0xB3 0x00..0x8F    #
      | 0xEC 0xB3 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE CYEOG..HANGUL SYLL...
      | 0xEC 0xB3 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE CYEG..HANGUL SYLLA...
      | 0xEC 0xB4 0x00..0x87    #
      | 0xEC 0xB4 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE COG..HANGUL SYLLAB...
      | 0xEC 0xB4 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE CWAG..HANGUL SYLLA...
      | 0xEC 0xB5 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE CWAEG..HANGUL SYLL...
      | 0xEC 0xB5 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE COEG..HANGUL SYLLA...
      | 0xEC 0xB5 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE CYOG..HANGUL SYLLA...
      | 0xEC 0xB6 0x00..0x93    #
      | 0xEC 0xB6 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE CUG..HANGUL SYLLAB...
      | 0xEC 0xB6 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE CWEOG..HANGUL SYLL...
      | 0xEC 0xB7 0x00..0x8B    #
      | 0xEC 0xB7 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE CWEG..HANGUL SYLLA...
      | 0xEC 0xB7 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE CWIG..HANGUL SYLLA...
      | 0xEC 0xB8 0x00..0x83    #
      | 0xEC 0xB8 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE CYUG..HANGUL SYLLA...
      | 0xEC 0xB8 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE CEUG..HANGUL SYLLA...
      | 0xEC 0xB8 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE CYIG..HANGUL SYLLA...
      | 0xEC 0xB9 0x00..0x97    #
      | 0xEC 0xB9 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE CIG..HANGUL SYLLAB...
      | 0xEC 0xB9 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE KAG..HANGUL SYLLAB...
      | 0xEC 0xBA 0x00..0x8F    #
      | 0xEC 0xBA 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE KAEG..HANGUL SYLLA...
      | 0xEC 0xBA 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE KYAG..HANGUL SYLLA...
      | 0xEC 0xBB 0x00..0x87    #
      | 0xEC 0xBB 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE KYAEG..HANGUL SYLL...
      | 0xEC 0xBB 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE KEOG..HANGUL SYLLA...
      | 0xEC 0xBC 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE KEG..HANGUL SYLLAB...
      | 0xEC 0xBC 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE KYEOG..HANGUL SYLL...
      | 0xEC 0xBC 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE KYEG..HANGUL SYLLA...
      | 0xEC 0xBD 0x00..0x93    #
      | 0xEC 0xBD 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE KOG..HANGUL SYLLAB...
      | 0xEC 0xBD 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE KWAG..HANGUL SYLLA...
      | 0xEC 0xBE 0x00..0x8B    #
      | 0xEC 0xBE 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE KWAEG..HANGUL SYLL...
      | 0xEC 0xBE 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE KOEG..HANGUL SYLLA...
      | 0xEC 0xBF 0x00..0x83    #
      | 0xEC 0xBF 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE KYOG..HANGUL SYLLA...
      | 0xEC 0xBF 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE KUG..HANGUL SYLLAB...
      | 0xEC 0xBF 0xBD..0xFF        #Lo  [27] HANGUL SYLLABLE KWEOG..HANGUL ...
      | 0xEC 0xC0..0xFF 0x00..0xFF  #
      | 0xED 0x00 0x00..0xFF        #
      | 0xED 0x01..0x7F 0x00..0xFF  #
      | 0xED 0x80 0x00..0x97        #
      | 0xED 0x80 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE KWEG..HANGUL SYLLA...
      | 0xED 0x80 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE KWIG..HANGUL SYLLA...
      | 0xED 0x81 0x00..0x8F    #
      | 0xED 0x81 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE KYUG..HANGUL SYLLA...
      | 0xED 0x81 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE KEUG..HANGUL SYLLA...
      | 0xED 0x82 0x00..0x87    #
      | 0xED 0x82 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE KYIG..HANGUL SYLLA...
      | 0xED 0x82 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE KIG..HANGUL SYLLAB...
      | 0xED 0x83 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE TAG..HANGUL SYLLAB...
      | 0xED 0x83 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE TAEG..HANGUL SYLLA...
      | 0xED 0x83 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE TYAG..HANGUL SYLLA...
      | 0xED 0x84 0x00..0x93    #
      | 0xED 0x84 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE TYAEG..HANGUL SYLL...
      | 0xED 0x84 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE TEOG..HANGUL SYLLA...
      | 0xED 0x85 0x00..0x8B    #
      | 0xED 0x85 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE TEG..HANGUL SYLLAB...
      | 0xED 0x85 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE TYEOG..HANGUL SYLL...
      | 0xED 0x86 0x00..0x83    #
      | 0xED 0x86 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE TYEG..HANGUL SYLLA...
      | 0xED 0x86 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE TOG..HANGUL SYLLAB...
      | 0xED 0x86 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE TWAG..HANGUL SYLLA...
      | 0xED 0x87 0x00..0x97    #
      | 0xED 0x87 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE TWAEG..HANGUL SYLL...
      | 0xED 0x87 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE TOEG..HANGUL SYLLA...
      | 0xED 0x88 0x00..0x8F    #
      | 0xED 0x88 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE TYOG..HANGUL SYLLA...
      | 0xED 0x88 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE TUG..HANGUL SYLLAB...
      | 0xED 0x89 0x00..0x87    #
      | 0xED 0x89 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE TWEOG..HANGUL SYLL...
      | 0xED 0x89 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE TWEG..HANGUL SYLLA...
      | 0xED 0x8A 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE TWIG..HANGUL SYLLA...
      | 0xED 0x8A 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE TYUG..HANGUL SYLLA...
      | 0xED 0x8A 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE TEUG..HANGUL SYLLA...
      | 0xED 0x8B 0x00..0x93    #
      | 0xED 0x8B 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE TYIG..HANGUL SYLLA...
      | 0xED 0x8B 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE TIG..HANGUL SYLLAB...
      | 0xED 0x8C 0x00..0x8B    #
      | 0xED 0x8C 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE PAG..HANGUL SYLLAB...
      | 0xED 0x8C 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE PAEG..HANGUL SYLLA...
      | 0xED 0x8D 0x00..0x83    #
      | 0xED 0x8D 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE PYAG..HANGUL SYLLA...
      | 0xED 0x8D 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE PYAEG..HANGUL SYLL...
      | 0xED 0x8D 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE PEOG..HANGUL SYLLA...
      | 0xED 0x8E 0x00..0x97    #
      | 0xED 0x8E 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE PEG..HANGUL SYLLAB...
      | 0xED 0x8E 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE PYEOG..HANGUL SYLL...
      | 0xED 0x8F 0x00..0x8F    #
      | 0xED 0x8F 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE PYEG..HANGUL SYLLA...
      | 0xED 0x8F 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE POG..HANGUL SYLLAB...
      | 0xED 0x90 0x00..0x87    #
      | 0xED 0x90 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE PWAG..HANGUL SYLLA...
      | 0xED 0x90 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE PWAEG..HANGUL SYLL...
      | 0xED 0x91 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE POEG..HANGUL SYLLA...
      | 0xED 0x91 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE PYOG..HANGUL SYLLA...
      | 0xED 0x91 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE PUG..HANGUL SYLLAB...
      | 0xED 0x92 0x00..0x93    #
      | 0xED 0x92 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE PWEOG..HANGUL SYLL...
      | 0xED 0x92 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE PWEG..HANGUL SYLLA...
      | 0xED 0x93 0x00..0x8B    #
      | 0xED 0x93 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE PWIG..HANGUL SYLLA...
      | 0xED 0x93 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE PYUG..HANGUL SYLLA...
      | 0xED 0x94 0x00..0x83    #
      | 0xED 0x94 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE PEUG..HANGUL SYLLA...
      | 0xED 0x94 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE PYIG..HANGUL SYLLA...
      | 0xED 0x94 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE PIG..HANGUL SYLLAB...
      | 0xED 0x95 0x00..0x97    #
      | 0xED 0x95 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE HAG..HANGUL SYLLAB...
      | 0xED 0x95 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE HAEG..HANGUL SYLLA...
      | 0xED 0x96 0x00..0x8F    #
      | 0xED 0x96 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE HYAG..HANGUL SYLLA...
      | 0xED 0x96 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE HYAEG..HANGUL SYLL...
      | 0xED 0x97 0x00..0x87    #
      | 0xED 0x97 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE HEOG..HANGUL SYLLA...
      | 0xED 0x97 0xA5..0xBF    #Lo  [27] HANGUL SYLLABLE HEG..HANGUL SYLLAB...
      | 0xED 0x98 0x81..0x9B    #Lo  [27] HANGUL SYLLABLE HYEOG..HANGUL SYLL...
      | 0xED 0x98 0x9D..0xB7    #Lo  [27] HANGUL SYLLABLE HYEG..HANGUL SYLLA...
      | 0xED 0x98 0xB9..0xFF    #Lo  [27] HANGUL SYLLABLE HOG..HANGUL SYLLAB...
      | 0xED 0x99 0x00..0x93    #
      | 0xED 0x99 0x95..0xAF    #Lo  [27] HANGUL SYLLABLE HWAG..HANGUL SYLLA...
      | 0xED 0x99 0xB1..0xFF    #Lo  [27] HANGUL SYLLABLE HWAEG..HANGUL SYLL...
      | 0xED 0x9A 0x00..0x8B    #
      | 0xED 0x9A 0x8D..0xA7    #Lo  [27] HANGUL SYLLABLE HOEG..HANGUL SYLLA...
      | 0xED 0x9A 0xA9..0xFF    #Lo  [27] HANGUL SYLLABLE HYOG..HANGUL SYLLA...
      | 0xED 0x9B 0x00..0x83    #
      | 0xED 0x9B 0x85..0x9F    #Lo  [27] HANGUL SYLLABLE HUG..HANGUL SYLLAB...
      | 0xED 0x9B 0xA1..0xBB    #Lo  [27] HANGUL SYLLABLE HWEOG..HANGUL SYLL...
      | 0xED 0x9B 0xBD..0xFF    #Lo  [27] HANGUL SYLLABLE HWEG..HANGUL SYLLA...
      | 0xED 0x9C 0x00..0x97    #
      | 0xED 0x9C 0x99..0xB3    #Lo  [27] HANGUL SYLLABLE HWIG..HANGUL SYLLA...
      | 0xED 0x9C 0xB5..0xFF    #Lo  [27] HANGUL SYLLABLE HYUG..HANGUL SYLLA...
      | 0xED 0x9D 0x00..0x8F    #
      | 0xED 0x9D 0x91..0xAB    #Lo  [27] HANGUL SYLLABLE HEUG..HANGUL SYLLA...
      | 0xED 0x9D 0xAD..0xFF    #Lo  [27] HANGUL SYLLABLE HYIG..HANGUL SYLLA...
      | 0xED 0x9E 0x00..0x87    #
      | 0xED 0x9E 0x89..0xA3    #Lo  [27] HANGUL SYLLABLE HIG..HANGUL SYLLAB...
      ;

    E_Base = 
        0xE2 0x98 0x9D          #So       WHITE UP POINTING INDEX
      | 0xE2 0x9B 0xB9          #So       PERSON WITH BALL
      | 0xE2 0x9C 0x8A..0x8D    #So   [4] RAISED FIST..WRITING HAND
      | 0xF0 0x9F 0x8E 0x85     #So       FATHER CHRISTMAS
      | 0xF0 0x9F 0x8F 0x83..0x84  #So   [2] RUNNER..SURFER
      | 0xF0 0x9F 0x8F 0x8A..0x8B  #So   [2] SWIMMER..WEIGHT LIFTER
      | 0xF0 0x9F 0x91 0x82..0x83  #So   [2] EAR..NOSE
      | 0xF0 0x9F 0x91 0x86..0x90  #So  [11] WHITE UP POINTING BACKHAND INDE...
      | 0xF0 0x9F 0x91 0xAE     #So       POLICE OFFICER
      | 0xF0 0x9F 0x91 0xB0..0xB8  #So   [9] BRIDE WITH VEIL..PRINCESS
      | 0xF0 0x9F 0x91 0xBC     #So       BABY ANGEL
      | 0xF0 0x9F 0x92 0x81..0x83  #So   [3] INFORMATION DESK PERSON..DANCER
      | 0xF0 0x9F 0x92 0x85..0x87  #So   [3] NAIL POLISH..HAIRCUT
      | 0xF0 0x9F 0x92 0xAA     #So       FLEXED BICEPS
      | 0xF0 0x9F 0x95 0xB5     #So       SLEUTH OR SPY
      | 0xF0 0x9F 0x95 0xBA     #So       MAN DANCING
      | 0xF0 0x9F 0x96 0x90     #So       RAISED HAND WITH FINGERS SPLAYED
      | 0xF0 0x9F 0x96 0x95..0x96  #So   [2] REVERSED HAND WITH MIDDLE FINGE...
      | 0xF0 0x9F 0x99 0x85..0x87  #So   [3] FACE WITH NO GOOD GESTURE..PERS...
      | 0xF0 0x9F 0x99 0x8B..0x8F  #So   [5] HAPPY PERSON RAISING ONE HAND.....
      | 0xF0 0x9F 0x9A 0xA3     #So       ROWBOAT
      | 0xF0 0x9F 0x9A 0xB4..0xB6  #So   [3] BICYCLIST..PEDESTRIAN
      | 0xF0 0x9F 0x9B 0x80     #So       BATH
      | 0xF0 0x9F 0xA4 0x98..0x9E  #So   [7] SIGN OF THE HORNS..HAND WITH IN...
      | 0xF0 0x9F 0xA4 0xA6     #So       FACE PALM
      | 0xF0 0x9F 0xA4 0xB0     #So       PREGNANT WOMAN
      | 0xF0 0x9F 0xA4 0xB3..0xB9  #So   [7] SELFIE..JUGGLING
      | 0xF0 0x9F 0xA4 0xBC..0xBE  #So   [3] WRESTLERS..HANDBALL
      ;

    E_Modifier = 
        0xF0 0x9F 0x8F 0xBB..0xBF  #Sk   [5] EMOJI MODIFIER FITZPATRICK TYPE...
      ;

    ZWJ = 
        0xE2 0x80 0x8D          #Cf       ZERO WIDTH JOINER
      ;

    Glue_After_Zwj = 
        0xE2 0x9D 0xA4          #So       HEAVY BLACK HEART
      | 0xF0 0x9F 0x92 0x8B     #So       KISS MARK
      | 0xF0 0x9F 0x97 0xA8     #So       LEFT SPEECH BUBBLE
      ;

    E_Base_GAZ = 
        0xF0 0x9F 0x91 0xA6..0xA9  #So   [4] BOY..WOMAN
      ;

}%%
