// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

#ifndef __TopShellH
#define __TopShellH

#include <qapp.h>
#include <qlabel.h>
#include <qlcdnum.h>
#include <qpixmap.h>
#include <qpushbt.h>
#include <qwidget.h>

class CommentShell;
class OptShell;
class QueueShell;
class TrackShell;
class SampleShell;

class TopShell : public QWidget
{
  Q_OBJECT

  signals:
  void channelSignal(int);

public:
  TopShell(CommentShell *, OptShell *, QueueShell *, SampleShell *, TrackShell *);
  void moduleFile(const char *);
  void moduleTitle(const char *);
  void setPosition(int);
  void setChannels(int);
  void setMaxPosition(int);
  void doNext(int);

private:
  void pickRandom();

  static const char *backXbm;
  static const char *forwardXbm;
  static const char *previousXbm;
  static const char *nextXbm;
  static const char *playXbm;
  static const char *stopXbm;

  QLabel *fileLabel;
  QLabel *nameLabel;
  
  QLCDNumber *positionLcd;
  QLCDNumber *channelLcd;

  QPushButton *button[12];
  QPixmap *pixmaps[6];

  int maxPosition;
  int doRandom;

 private slots:
 void backClicked();
  void forwardClicked();
  void playClicked();
  void nextClicked();
  void previousClicked();
  void stopClicked();
  void setRandom();
};

inline void
TopShell::setMaxPosition(int position)
{
  maxPosition = position;
}

inline void
TopShell::moduleFile(const char *modFile)
{
  fileLabel->setText(modFile);
}

inline void
TopShell::moduleTitle(const char *modTitle)
{
  nameLabel->setText(modTitle);
}

#endif
