/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn client.
 * Copyright (C) 2008 - 2010 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"
#include "commands.h"
#include "delete_connection_clicked.h"
#include "populate_client_settings.h"

extern gchar *selected_connection;


void delete_connection_clicked(struct w *widgets)
{
    gchar *cmd, *info, *path;

    if( selected_connection == NULL || strlen(selected_connection) < 3 )
    {
	info = g_strdup_printf(_("The connection name is too short.\n"));
	show_info(info);
	g_free(info);
        return;
    }

    /* See if we have required things such as certs */
    path = g_strdup_printf("%s/client/%s", OPENVPN_SYSCONF_DIR, selected_connection);
    if( ! file_exists(path) )
    {
	info = g_strdup_printf(_("The connection does not exist.\n"));
	show_info(info);
	g_free(info);
	g_free(path);
	return;
    }
    g_free(path);

    cmd = g_strdup_printf("rm -rf %s/client/%s", OPENVPN_SYSCONF_DIR, selected_connection);
    if( ! run_command(cmd) )
    {
	info = g_strdup_printf(_("Error removing the connection directory with this command:\n%s\n"), cmd);
	show_info(info);
	g_free(info);
	g_free(cmd);
	return;
    }

    if( selected_connection != NULL )
    {
        g_free(selected_connection);
        selected_connection = NULL;
    }

    /* Populate the client settings. */
    populate_connections(widgets);
    populate_client_settings(widgets);
}
