/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.applications.hwiki;

import hypergraph.graphApi.AttributeManager;
import hypergraph.graphApi.Element;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphException;
import hypergraph.graphApi.Group;
import hypergraph.graphApi.Node;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JApplet;
import org.apache.xmlrpc.XmlRpcClient;

public class GraphPanel
extends hypergraph.visualnet.GraphPanel {
    private static Group groupNew;
    private static Group groupPending;
    private static Group groupDone;
    private static Group groupFail;
    private static String homepageUrl;
    private static final String LISTLINKS = "wiki.listLinks";
    private JApplet explorer;
    private String clientName = "http://www.jspwiki.org/RPCU/";
    static String url;

    public GraphPanel(Graph graph, JApplet jApplet) {
        super(graph);
        this.explorer = jApplet;
        groupNew = graph.createGroup();
        groupPending = graph.createGroup();
        groupDone = graph.createGroup();
        groupFail = graph.createGroup();
        graph.getAttributeManager().setAttribute("node.color", groupNew, Color.blue);
        graph.getAttributeManager().setAttribute("node.color", groupPending, Color.green);
        graph.getAttributeManager().setAttribute("node.color", groupFail, Color.red);
        graph.getAttributeManager().setAttribute("node.color", groupDone, Color.black);
    }

    public void setRpcClientName(String string) {
        if (string != null) {
            this.clientName = string;
        }
    }

    private XmlRpcClient getNewClient() throws MalformedURLException {
        return new XmlRpcClient(this.clientName);
    }

    public void addRelatedUrls(String string, final int n) {
        url = string;
        Runnable runnable = new Runnable(){

            public void run() {
                GraphPanel.this.loadRelatedUrls(url, n);
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRelatedUrls(String string, int n) {
        if (n < 0) {
            return;
        }
        Vector<String> vector = new Vector<String>(1);
        vector.add(string);
        Node node = (Node)this.getGraph().getElement(string);
        if (node.getGroup() != null && !node.getGroup().equals(groupNew)) {
            return;
        }
        node.setGroup(groupPending);
        AttributeManager attributeManager = this.getGraph().getAttributeManager();
        try {
            Vector vector2 = (Vector)this.getNewClient().execute(LISTLINKS, vector);
            for (int i = 0; i < vector2.size(); ++i) {
                Graph graph;
                Hashtable hashtable = (Hashtable)vector2.elementAt(i);
                String string2 = (String)hashtable.get("page");
                String string3 = (String)hashtable.get("type");
                String string4 = (String)hashtable.get("href");
                if (string3.equals("external")) continue;
                Node node2 = (Node)this.getGraph().getElement(string2);
                if (node2 == null) {
                    try {
                        graph = this.getGraph();
                        synchronized (graph) {
                            node2 = this.getGraph().createNode(string2);
                            node2.setGroup(groupNew);
                        }
                    }
                    catch (GraphException graphException) {
                        graphException.printStackTrace();
                    }
                }
                graph = this.getGraph();
                synchronized (graph) {
                    this.getGraph().createEdge(node, node2);
                }
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                attributeManager.setAttribute("xlink:href", node2, string4);
                this.addRelatedUrls(node2.getName(), n - 1);
            }
            node.setGroup(groupDone);
        }
        catch (Exception exception) {
            node.setGroup(groupFail);
            exception.printStackTrace();
        }
    }

    public void setHoverElement(Element element, boolean bl) {
        if (this.getHoverElement() != element) {
            AppletContext appletContext;
            if (element == null) {
                appletContext = this.explorer.getAppletContext();
                appletContext.showStatus("");
                this.setToolTipText(null);
            }
            if (element != null && element.getElementType() == 1) {
                appletContext = this.explorer.getAppletContext();
                String string = element.getName();
                appletContext.showStatus(string);
                this.setToolTipText(string);
            }
            if (element == null || element.getElementType() == 2) {
                // empty if block
            }
        }
        super.setHoverElement(element, bl);
        if (this.getHoverElement() == null) {
            this.explorer.getAppletContext().showStatus("");
        }
    }

    protected void logoClicked(MouseEvent mouseEvent) {
        super.logoClicked(mouseEvent);
        try {
            this.explorer.getAppletContext().showDocument(new URL(homepageUrl));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        if (this.isOnLogo(mouseEvent.getPoint())) {
            this.explorer.getAppletContext().showStatus(homepageUrl);
        }
    }

    public void nodeClicked(int n, Node node) {
        super.nodeClicked(n, node);
        if (n == 1) {
            this.addRelatedUrls(node.getName(), 0);
            AttributeManager attributeManager = this.getGraph().getAttributeManager();
            String string = (String)attributeManager.getAttribute("xlink:href", node);
            String string2 = this.getPropertyManager().getString("hypergraph.applications.hexplorer.GraphPanel.target");
            try {
                URL uRL = new URL(this.explorer.getDocumentBase(), string);
                AppletContext appletContext = this.explorer.getAppletContext();
                appletContext.showDocument(uRL, string2);
            }
            catch (Exception exception) {
                System.out.println(string);
                System.out.println(string2);
                exception.printStackTrace();
            }
        }
    }

    static {
        homepageUrl = "http://hypergraph.sourceforge.net";
    }
}

