/* $Id: lookup.c,v 1.2 2009/05/17 19:20:09 nicm Exp $ */

/*
 * Copyright (c) 2008 Nicholas Marriott <nicm@users.sourceforge.net>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF MIND, USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <sys/types.h>

#include <unistd.h>

#include "fdm.h"

struct userdata *
user_lookup(const char *user, struct userfunctions *order)
{
	struct userdata	*ud;
	u_int		 i;

	for (i = 0; i < ARRAY_LENGTH(order); i++) {
		if ((ud = ARRAY_ITEM(order, i)(user)) != NULL)
		    return (ud);
	}
	return (NULL);
}

void
user_free(struct userdata *ud)
{
	xfree(ud->name);
	xfree(ud->home);
	xfree(ud);

}

struct userdata *
user_copy(struct userdata *ud)
{
	struct userdata	*ue;

	ue = xmalloc(sizeof *ue);
	ue->uid = ud->uid;
	ue->gid = ud->gid;
	ue->name = xstrdup(ud->name);
	ue->home = xstrdup(ud->home);

	return (ue);
}
