/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.CaseMgr;
import com.stevesoft.pat.Or;
import com.stevesoft.pat.Pattern;
import com.stevesoft.pat.Regex;
import com.stevesoft.pat.Skip2;
import com.stevesoft.pat.SkipBMH;
import com.stevesoft.pat.Skipped;
import com.stevesoft.pat.StringLike;
import com.stevesoft.pat.oneChar;

public class Skip {
    String src;
    int c;
    int mask;
    int offset;
    boolean ign;
    boolean m1;

    static int mkmask(int c) {
        char x = (char)c;
        return ~(CaseMgr.toUpperCase(x) | CaseMgr.toLowerCase(x) | CaseMgr.toTitleCase(x));
    }

    public static String string(Regex r) {
        return r.skipper == null ? null : r.skipper.src;
    }

    public static int offset(Regex r) {
        return r.skipper == null ? -1 : r.skipper.offset;
    }

    public Skip(String s, boolean ign, int o) {
        this.src = s;
        this.c = s.charAt(0);
        this.mask = ign ? Skip.mkmask(this.c) : 0;
        this.offset = o;
        this.ign = ign;
        this.m1 = s.length() == 1;
    }

    public final int find(StringLike s) {
        return this.find(s, 0, s.length());
    }

    static final int min(int a, int b) {
        return a < b ? a : b;
    }

    public int find(StringLike s, int start, int end) {
        if (start > end) {
            return -1;
        }
        start += this.offset;
        int vend = Skip.min(s.length() - 1, end + this.offset);
        if (this.mask != this.c) {
            for (int i = start; i <= vend; ++i) {
                if (0 != (s.charAt(i) & this.mask) || !this.m1 && !CaseMgr.regionMatches(s, this.ign, i, this.src, 0, this.src.length())) continue;
                return i - this.offset;
            }
        } else {
            for (int i = start; i <= vend; ++i) {
                if (this.c != s.charAt(i) || !this.m1 && !CaseMgr.regionMatches(s, this.ign, i, this.src, 0, this.src.length())) continue;
                return i - this.offset;
            }
        }
        return -1;
    }

    static Skip findSkip(Regex r) {
        return Skip.findSkip(r.thePattern, r.ignoreCase, !r.dontMatchInQuotes);
    }

    static Skip findSkip(Pattern p, boolean ignoreCase, boolean trnc) {
        StringBuffer sb = new StringBuffer();
        Skip subsk = null;
        int offset = 0;
        int skipc = -1;
        int skipoff = 0;
        while (p != null) {
            if (p instanceof oneChar) {
                skipc = ((oneChar)p).c;
                skipoff = offset;
            }
            if (p instanceof oneChar && p.next instanceof oneChar) {
                Pattern psav = p;
                sb.append(((oneChar)p).c);
                while (p.next instanceof oneChar) {
                    sb.append(((oneChar)p.next).c);
                    p = p.next;
                }
                String st = sb.toString();
                Skip sk = null;
                sk = st.length() > 2 ? new SkipBMH(st, ignoreCase, offset) : new Skip2(st, ignoreCase, offset);
                if (trnc && st.length() > 2) {
                    psav.next = new Skipped(st.substring(1));
                    psav.next.next = p.next;
                    psav.next.parent = p.parent;
                }
                return sk;
            }
            if (p instanceof Or && ((Or)p).v.size() == 1 && !((Or)p).leftForm().equals("(?!") && null != (subsk = Skip.findSkip((Pattern)((Or)p).v.elementAt(0), ignoreCase, trnc))) {
                subsk.offset += offset;
                return subsk;
            }
            if (p.minChars().equals(p.maxChars())) {
                offset += p.minChars().intValue();
            } else {
                return skipc < 0 ? null : new Skip("" + (char)skipc, ignoreCase, skipoff);
            }
            p = p.next;
        }
        return null;
    }
}

