<?php
# dvdisaster: English homepage translation
# Copyright (C) 2004-2012 Carsten Gnörlich
#
# UTF-8 trigger: äöüß 
#
# Include our PHP sub routines, then call begin_page()
# to start the HTML page, insert the header, 
# navigation and news if appropriate.

require("../include/dvdisaster.php");
require("../include/screenshot.php");

begin_page();
?>

<!-- Insert actual page content below -->

<h3 class="top">Примеры</h3>

На предыдущих страницах уже приводились примеры
 <a href="howtos52.php?expand=1">хороших образов и файлов для исправления ошибок</a>
и <a href="howtos53.php?expand=1">хороших образов, дополненных
данными для исправления ошибок</a>.
Дальше представлены некоторые типичные примеры ситуаций с ошибками:<p>

<hr>

Вот два типичных случая вывода информации для образов,
которые еще не полностью восстановлены:<p>

<?php begin_screen_shot("Образ с нечитаемыми секторами, RS01","compare-bad-rs01.png"); ?>
<b>Образ с нечитаемыми секторами и файл для исправления ошибок</b>.
Образ, показанный здесь, содержит 6245 нечитаемых секторов; данные для исправления 
ошибок присутствуют в виде файла.
<p>
<?php end_screen_shot(); ?>

<?php begin_screen_shot("Образ с нечитаемыми секторами, RS02","compare-bad-rs02.png"); ?>
<b>Образ, дополненный данными для исправления ошибок, содержащий нечитаемые секторы</b>.
В конце этого образа есть нечитаемые секторы. Особенно задет раздел
ECC, поскольку даные для исправления ошибок размещены 
в конце образа. Имейте в виду, что это не ослабляет способность исправления ошибок, 
поскольку она не зависит от расположения ошибок: 10000 ошибок в начале носителя исправить так же легко, как и 10000 ошибок в его конце.<br>
Кодировщик RS02, который использовался для создания данных для исправления ошибок,
способен предсказывать вероятность успешного восстановления образа.
Это показывается в конце области вывода сведений по данным для исправления ошибок.
<?php end_screen_shot(); ?>

<hr>  

<?php begin_screen_shot("Прерванное чтение","compare-trunc-rs01.png"); ?>
<b>Образ от прерванного процесса чтения</b>.
Этот образ короче, чем должен быть; это обычно случается, когда
процесс чтения преждевременно останаливается.
<p>
<?php end_screen_shot(); ?>

<?php begin_screen_shot("Образ слишком большой","compat-150-rs01.png"); ?>
<b>Образ больше, чем должен быть</b>.
Этот образ больше, чем предполагался; возможные причины этого обсуждаются 
в разделе о <a href="howtos90.php">совместимости образов</a>.
Исправить эту проблему можно; смотрите советы, относящиеся к
<a href="howtos91.php#err">использованию файлов для исправления ошибок</a> и
<a href="howtos92.php#err">использованию дополненных образов</a>.
<?php end_screen_shot(); ?>

<?php begin_screen_shot("Неправильный файл для исправления ошибок","compare-mismatch-rs01.png"); ?>
<b>Неправильный файл для исправления ошибок</b>.
Файл для исправления ошибок был создан для другого образа.
Это приводит к появлению большого числа CRC-ошибок, поскольку в секторах другое содержимое.
Однако вот наиболее важный намек:<p>
Отпечаток: <span class="red">несоответствие</span><p>
Это говорит о том, что файл для исправления ошибок не от этого образа.
<?php end_screen_shot(); ?>

<!-- do not change below -->

<?php
# end_page() adds the footer line and closes the HTML properly.

end_page();
?>
