/*
    main.c - Belegloser Datentrgeraustausch mit einer Bank
    Copyright (c) 1996,8,2001-4  Martin Schulze <joey@infodrom.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA.

    $Id: main.c,v 1.20 2004-08-06 21:14:06 joey Exp $
 */

static char version[] = "0.7";

#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "dtaus.h"

#define FN_DTAUS   "dtaus0.txt"
#define FN_CONTROL "dtaus0.ctl"
#define FN_BELEG   "dtaus0.doc"
#define FN_CHECK   "dtaus0.sik"
#define FN_LATEX   "dtaus0.tex"

char *dtaus   = FN_DTAUS;
char *control = FN_CONTROL;
char *beleg   = FN_BELEG;
char *check   = FN_CHECK;
char *latex   = NULL;

void help ()
{
  printf ("dtaus - Belegloser Datentrgeraustausch mit einer Bank\n\n");
  printf ("  -dtaus         Erzeugt eine Bankdatei\n");
  printf ("  -control       Liest eine Bankdatei und erzeugt die Kontrolldatei\n");
  printf ("\n");
  printf ("  -d <dtaus>     Bankdatei [%s]\n", FN_DTAUS);
  printf ("  -c <control>   Steuerdatei [%s]\n", FN_CONTROL);
  printf ("  -b <begleit>   Begleitzettel fr die Bank [%s]\n", FN_BELEG);
  printf ("  -l [<begleit>] Begleitzettel als LaTeX [%s]\n", FN_LATEX);
  printf ("  -o <kontroll>  Kontrolldatei zum Abheften [%s]\n", FN_CHECK);
}

#define DTAUS   1
#define CONTROL 2

int main (int argc, char **argv)
{
  int action = 0;
  int i = 0;
  struct stat sbuf;

  while (argc - i > 1) {
    i++;
    if ( !strcmp(argv[i], "-h") ) {
      help(); exit(0);
    } else if ( !strcmp(argv[i], "-v") ) {
      printf ("dtaus version %s - Copyright (c) 1997,8,2001,4 by Martin Schulze <joey@infodrom.org>\n", version);
      exit (0);
    } else if ( !strcmp(argv[i], "-d") ) {
      if (argc - i > 1) {
	i++;
	dtaus = argv[i];
      }
    } else if ( !strcmp(argv[i], "-c") ) {
      if (argc - i > 1) {
	i++;
	control = argv[i];
      }
    } else if ( !strcmp(argv[i], "-b") ) {
      if (argc - i > 1) {
	i++;
	beleg = argv[i];
      }
    } else if ( !strcmp(argv[i], "-l") ) {
      if (argc - i > 1 && argv[i+1][0] != '-') {
	i++;
	latex = argv[i];
      } else
	latex = FN_LATEX;
    } else if ( !strcmp(argv[i], "-o") ) {
      if (argc - i > 1) {
	i++;
	check = argv[i];
      }
    } else if ( !strcmp(argv[i], "-dtaus") ) {
      action = DTAUS;
    } else if ( !strcmp(argv[i], "-control") ) {
      action = CONTROL;
    } 
  }

  if (action == DTAUS) {
    if (!strcmp("-", control) || !stat(control, &sbuf)) {
      if (control2dtaus (control, dtaus, beleg, check, latex) == 0)
	exit (1);
    }
    else {
      fprintf( stderr, "Can't stat %s\n", control);
      exit (1);
    }
  } else if (action == CONTROL) {
    if (!strcmp("-", dtaus) || !stat(dtaus, &sbuf))
      dtaus2control (dtaus, control);
    else {
      fprintf( stderr, "Can't stat %s\n", dtaus);
      exit (1);
    }
  } else {
    fprintf (stderr, "Keine Routine angegeben (-dtaus bzw. -control vergessen).\n");
    exit (1);
  }
  exit (0);
}
