#include "label.h"
#include "font.h"
#include "viewwin.h"

using namespace std;

extern int mousex, mouseyy;
extern viewport view;
extern int lmb;

label::label (const string& t) {
	set_text (t);
}

void label::set_text (const string& t) {
	text = t;
	int w = get_char_width (text), h = get_max_char_height (text);
	const box<int>& e = get_extents ();
	set_extents (e.left, e.bottom, e.left + w, e.bottom + h);
}

void label::draw () {
	widget::draw ();
	int x, y; get_pos (x, y);
	draw_string (text, x, y);
}

int label::handle_input () {
	return widget::handle_input ();
}

void label::update () {
	set_text (text);
}
