   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*             CLIPS Version 6.30  08/16/14            */
   /*                                                     */
   /*       DEFTEMPLATE BASIC COMMANDS HEADER FILE        */
   /*******************************************************/

/*************************************************************/
/* Purpose: Implements core commands for the deftemplate     */
/*   construct such as clear, reset, save, undeftemplate,    */
/*   ppdeftemplate, list-deftemplates, and                   */
/*   get-deftemplate-list.                                   */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*      Brian L. Dantes                                      */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*      6.23: Corrected compilation errors for files         */
/*            generated by constructs-to-c. DR0861           */
/*                                                           */
/*            Changed name of variable log to logName        */
/*            because of Unix compiler warnings of shadowed  */
/*            definitions.                                   */
/*                                                           */
/*      6.24: Renamed BOOLEAN macro type to intBool.         */
/*                                                           */
/*            Corrected code to remove compiler warnings     */
/*            when ENVIRONMENT_API_ONLY flag is set.         */
/*                                                           */
/*      6.30: Removed conditional code for unsupported       */
/*            compilers/operating systems (IBM_MCW,          */
/*            MAC_MCW, and IBM_TBC).                         */
/*                                                           */
/*            Added const qualifiers to remove C++           */
/*            deprecation warnings.                          */
/*                                                           */
/*            Converted API macros to function calls.        */
/*                                                           */
/*************************************************************/

#ifndef _H_tmpltbsc
#define _H_tmpltbsc

#ifndef _H_evaluatn
#include "evaluatn.h"
#endif

#ifdef LOCALE
#undef LOCALE
#endif

#ifdef _TMPLTBSC_SOURCE_
#define LOCALE
#else
#define LOCALE extern
#endif

   LOCALE void                           DeftemplateBasicCommands(void *);
   LOCALE void                           UndeftemplateCommand(void *);
   LOCALE intBool                        EnvUndeftemplate(void *,void *);
   LOCALE void                           GetDeftemplateListFunction(void *,DATA_OBJECT_PTR);
   LOCALE void                           EnvGetDeftemplateList(void *,DATA_OBJECT_PTR,void *);
   LOCALE void                          *DeftemplateModuleFunction(void *);
#if DEBUGGING_FUNCTIONS
   LOCALE void                           PPDeftemplateCommand(void *);
   LOCALE int                            PPDeftemplate(void *,const char *,const char *);
   LOCALE void                           ListDeftemplatesCommand(void *);
   LOCALE void                           EnvListDeftemplates(void *,const char *,void *);
   LOCALE unsigned                       EnvGetDeftemplateWatch(void *,void *);
   LOCALE void                           EnvSetDeftemplateWatch(void *,unsigned,void *);
   LOCALE unsigned                       DeftemplateWatchAccess(void *,int,unsigned,struct expr *);
   LOCALE unsigned                       DeftemplateWatchPrint(void *,const char *,int,struct expr *);
#endif

#if ALLOW_ENVIRONMENT_GLOBALS

   LOCALE void                           GetDeftemplateList(DATA_OBJECT_PTR,void *);
#if DEBUGGING_FUNCTIONS
   LOCALE unsigned                       GetDeftemplateWatch(void *);
   LOCALE void                           ListDeftemplates(const char *,void *);
   LOCALE void                           SetDeftemplateWatch(unsigned,void *);
#endif
   LOCALE intBool                        Undeftemplate(void *);

#endif /* ALLOW_ENVIRONMENT_GLOBALS */

#endif /* _H_tmpltbsc */


