/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

import com.claritysys.jvm.classfile.Attribute;

public abstract class CfEntry {
    private int accessFlags;
    private boolean deprecated;
    private Attribute attributes;

    public CfEntry() {
    }

    public CfEntry(int accessFlags) {
        this.accessFlags = accessFlags;
    }

    public final int getAccessFlags() {
        return this.accessFlags;
    }

    public final void setAccessFlags(int accessFlags) {
        this.accessFlags = accessFlags;
    }

    private final void setFlag(int flag, boolean set) {
        this.accessFlags = set ? (this.accessFlags |= flag) : (this.accessFlags &= flag ^ 0xFFFF);
    }

    public final void setPublic(boolean flag) {
        this.setFlag(1, flag);
    }

    public final boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public final void setPrivate(boolean flag) {
        this.setFlag(2, flag);
    }

    public final boolean isPrivate() {
        return (this.accessFlags & 2) != 0;
    }

    public final void setProtected(boolean flag) {
        this.setFlag(4, flag);
    }

    public final boolean isProtected() {
        return (this.accessFlags & 4) != 0;
    }

    public final void setStatic(boolean flag) {
        this.setFlag(8, flag);
    }

    public final boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public final void setFinal(boolean flag) {
        this.setFlag(16, flag);
    }

    public final boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public final void setSynchronized(boolean flag) {
        this.setFlag(32, flag);
    }

    public final boolean isSynchronized() {
        return (this.accessFlags & 0x20) != 0;
    }

    public final void setVolatile(boolean flag) {
        this.setFlag(64, flag);
    }

    public final boolean isVolatile() {
        return (this.accessFlags & 0x40) != 0;
    }

    public final void setTransient(boolean flag) {
        this.setFlag(128, flag);
    }

    public final boolean isTransient() {
        return (this.accessFlags & 0x80) != 0;
    }

    public final void setNative(boolean flag) {
        this.setFlag(256, flag);
    }

    public final boolean isNative() {
        return (this.accessFlags & 0x100) != 0;
    }

    public final void setInterface(boolean flag) {
        this.setFlag(512, flag);
    }

    public final boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public final void setAbstract(boolean flag) {
        this.setFlag(1024, flag);
    }

    public final boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public final void setStrict(boolean flag) {
        this.setFlag(2048, flag);
    }

    public final boolean isStrict() {
        return (this.accessFlags & 0x800) != 0;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public Attribute getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attribute attributes) {
        this.attributes = attributes;
    }

    public int getAttributeCount() {
        int count = 0;
        for (Attribute a = this.getAttributes(); a != null; a = a.getNext()) {
            ++count;
        }
        return count;
    }
}

