/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.detail;

import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.detail.FixedListDetailPane;
import org.gjt.jclasslib.structures.ClassMember;
import org.gjt.jclasslib.structures.FieldInfo;
import org.gjt.jclasslib.structures.MethodInfo;
import org.gjt.jclasslib.util.ExtendedJLabel;

public class ClassMemberDetailPane
extends FixedListDetailPane {
    public static final int FIELDS = 1;
    public static final int METHODS = 2;
    private int mode;
    private ExtendedJLabel lblName;
    private ExtendedJLabel lblNameVerbose;
    private ExtendedJLabel lblDescriptor;
    private ExtendedJLabel lblDescriptorVerbose;
    private ExtendedJLabel lblAccessFlags;
    private ExtendedJLabel lblAccessFlagsVerbose;

    public ClassMemberDetailPane(BrowserServices browserServices, int n) {
        super(browserServices);
        this.mode = n;
    }

    protected void setupLabels() {
        this.lblName = this.linkLabel();
        this.lblNameVerbose = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("Name:"), this.lblName, this.lblNameVerbose);
        this.lblDescriptor = this.linkLabel();
        this.lblDescriptorVerbose = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("Descriptor:"), this.lblDescriptor, this.lblDescriptorVerbose);
        this.lblAccessFlags = this.highlightLabel();
        this.lblAccessFlagsVerbose = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("Access flags:"), this.lblAccessFlags, this.lblAccessFlagsVerbose);
    }

    public void show(TreePath treePath) {
        ClassMember classMember;
        int n = this.getIndex(treePath);
        if (this.mode == 1) {
            FieldInfo[] fieldInfoArray = this.services.getClassFile().getFields();
            if (n >= fieldInfoArray.length) {
                return;
            }
            classMember = fieldInfoArray[n];
        } else {
            MethodInfo[] methodInfoArray = this.services.getClassFile().getMethods();
            if (n >= methodInfoArray.length) {
                return;
            }
            classMember = methodInfoArray[n];
        }
        this.constantPoolHyperlink(this.lblName, this.lblNameVerbose, classMember.getNameIndex());
        this.constantPoolHyperlink(this.lblDescriptor, this.lblDescriptorVerbose, classMember.getDescriptorIndex());
        this.lblAccessFlags.setText(classMember.getFormattedAccessFlags());
        this.lblAccessFlagsVerbose.setText("[" + classMember.getAccessFlagsVerbose() + "]");
        super.show(treePath);
    }
}

