------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
-- A S I S _ U L . E N V I R O N M E N T . C H E C K  _ P A R A M E T E R S --
--                                                                          --
--            (adapted for gnatcheck from ASIS Utility Library)             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                     Copyright (C) 2005-2010, AdaCore                     --
--                                                                          --
-- Asis Utility Library (ASIS UL) is free software; you can redistribute it --
-- and/or  modify  it  under  terms  of  the  GNU General Public License as --
-- published by the Free Software Foundation; either version 2, or (at your --
-- option)  any later version.  ASIS UL  is distributed in the hope that it --
-- will  be  useful,  but  WITHOUT  ANY  WARRANTY; without even the implied --
-- warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the --
-- GNU  General Public License for more details. You should have received a --
-- copy of the  GNU General Public License  distributed with GNAT; see file --
-- COPYING. If not,  write  to the  Free Software Foundation,  51 Franklin --
-- Street, Fifth Floor, Boston, MA 02110-1301, USA.                         --
--                                                                          --
-- ASIS UL is maintained by AdaCore (http://www.adacore.com).               --
--                                                                          --
------------------------------------------------------------------------------

with ASIS_UL.Options;            use ASIS_UL.Options;
with ASIS_UL.Output;
with ASIS_UL.Source_Table;

with Gnatcheck.Categories;
with Gnatcheck.Compiler;         use Gnatcheck.Compiler;
with Gnatcheck.Ids;              use Gnatcheck.Ids;
with Gnatcheck.Options;
with Gnatcheck.Output;           use Gnatcheck.Output;
with Gnatcheck.Rules;            use Gnatcheck.Rules;
with Gnatcheck.Rules.Rule_Table; use Gnatcheck.Rules.Rule_Table;

separate (ASIS_UL.Environment)
procedure Check_Parameters is
begin

   --  We generate the rule help inconditionally.
   if Gnatcheck.Options.Generate_Rules_Help then
      Rules_Help;
   end if;

   if Gnatcheck.Options.Generate_Category_Help then
      Gnatcheck.Categories.Category_Help
        (Category_Name => "", --  Root category
         From_Status   => Gnatcheck.Options.Rule_Report_Status,
         Recursively   => Gnatcheck.Options.Recursive_Help,
         Level         => 0);
   end if;

   if ASIS_UL.Options.Generate_XML_Help then
      Gnatcheck.Categories.XML_Categories_Help;
   end if;

   --  Now check if we have anything to do:

   if ASIS_UL.Options.No_Argument_File_Specified then

      if Gnatcheck.Options.Generate_Rules_Help
       or else
         Gnatcheck.Options.Generate_Category_Help
       or else
         ASIS_UL.Options.Generate_XML_Help
      then
         Nothing_To_Do := True;
         return;
      else
         Error ("No input source file set");
         Brief_Help;
         raise Parameter_Error;
      end if;

   end if;

   Process_ADA_PRJ_INCLUDE_FILE;

   Set_Source_Search_Path;

   Read_Args_From_Temp_Storage (Duplication_Report => True);

   Nothing_To_Do := Last_Source < First_SF_Id;

   if Nothing_To_Do then
      Error ("No existing file to process");
      --  All the rest does not make any sense
      return;
   end if;

   Set_Compiler_Checks;

   Analyze_Compiler_Output :=
     Use_gnaty_Option or else Use_gnatw_Option or else Check_Restrictions;

   if Analyze_Compiler_Output then
      Store_Option ("-gnatwn");
      Store_Option (Get_Warning_Option);
      Store_Option ("-gnatyN");
   end if;

   if Use_gnaty_Option then
      Store_Option (Get_Style_Option);
   end if;

   if Check_Restrictions then
      Store_Option ("-gnatec=" & Restriction_Config_File);
   end if;

   Set_Arg_List;

   Suppess_Compiler_Check := not (Use_gnatw_Option
                                or else
                                  Use_gnaty_Option
                                or else
                                  Check_Restrictions);

   for Rule in All_Rules.First .. All_Rules.Last loop

      if All_Rules.Table (Rule).Diagnosis /= null
       and then
         Is_Enable (All_Rules.Table (Rule).all)
      then
         --  Note, that if a rule does not have its own diagnoses, this
         --  means that it is implemented by some other rules, so it
         --  should not go into the report
         Gnatcheck.Options.Active_Rule_Present := True;
         exit;
      end if;
   end loop;

   if not (Gnatcheck.Options.Active_Rule_Present
           or else
             Analyze_Compiler_Output)
   then
      --  Here we have some sources specified, so this situation definitely
      --  is wrong!
      Error ("No rule to check specified");
      Brief_Help;
      raise Parameter_Error;
   end if;

   --  If we are here - we have sources to check and rules to apply
   Total_Sources := Natural (Last_Source);
   Sources_Left  := Total_Sources;

   --  Check is the active set of rules requires building the global
   --  structure

   for J in First_Rule .. All_Rules.Last loop

      if All_Rules.Table (J).Rule_State = Enabled then

         if All_Rules.Table (J).all in Global_Rule_Template'Class then
            ASIS_UL.Options.Buld_Call_Graph         := True;
            Gnatcheck.Options.Analyse_Expanded_Code := True;
            Init_Global_Structure
              (Global_Rule_Template'Class (All_Rules.Table (J).all));
         end if;

         if Checked_On_Expanded_Code (All_Rules.Table (J).all) then
            Gnatcheck.Options.Analyse_Expanded_Code := True;
         end if;

         if All_Rules.Table (J).all in Text_Rule_Template'Class then
            Gnatcheck.Options.Analyse_Source_Text := True;
         end if;

      end if;

   end loop;

   ASIS_UL.Output.Set_Report_File;

   --  Check for non-documented --no-column option:

   if Gnatcheck.Options.Full_Source_Locations
     and then
       Gnatcheck.Options.No_Column_Num_In_Diagnoses
   then
      Error ("-l and --no-column cannot be set together");
      raise Parameter_Error;
   end if;

end Check_Parameters;
