/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.model.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeRouteTablesRequest
extends AmazonWebServiceRequest {
    private Boolean dryRun;
    private List<String> routeTableIds;
    private List<Filter> filters;

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public DescribeRouteTablesRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public List<String> getRouteTableIds() {
        if (this.routeTableIds == null) {
            this.routeTableIds = new ArrayList<String>();
        }
        return this.routeTableIds;
    }

    public void setRouteTableIds(Collection<String> routeTableIds) {
        if (routeTableIds == null) {
            this.routeTableIds = null;
            return;
        }
        ArrayList<String> routeTableIdsCopy = new ArrayList<String>(routeTableIds.size());
        routeTableIdsCopy.addAll(routeTableIds);
        this.routeTableIds = routeTableIdsCopy;
    }

    public DescribeRouteTablesRequest withRouteTableIds(String ... routeTableIds) {
        if (this.getRouteTableIds() == null) {
            this.setRouteTableIds(new ArrayList<String>(routeTableIds.length));
        }
        for (String value : routeTableIds) {
            this.getRouteTableIds().add(value);
        }
        return this;
    }

    public DescribeRouteTablesRequest withRouteTableIds(Collection<String> routeTableIds) {
        if (routeTableIds == null) {
            this.routeTableIds = null;
        } else {
            ArrayList<String> routeTableIdsCopy = new ArrayList<String>(routeTableIds.size());
            routeTableIdsCopy.addAll(routeTableIds);
            this.routeTableIds = routeTableIdsCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ArrayList<Filter> filtersCopy = new ArrayList<Filter>(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeRouteTablesRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeRouteTablesRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ArrayList<Filter> filtersCopy = new ArrayList<Filter>(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dryRun != null) {
            sb.append("DryRun: " + this.dryRun + ", ");
        }
        if (this.routeTableIds != null) {
            sb.append("RouteTableIds: " + this.routeTableIds + ", ");
        }
        if (this.filters != null) {
            sb.append("Filters: " + this.filters + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isDryRun() == null ? 0 : this.isDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getRouteTableIds() == null ? 0 : ((Object)this.getRouteTableIds()).hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : ((Object)this.getFilters()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouteTablesRequest)) {
            return false;
        }
        DescribeRouteTablesRequest other = (DescribeRouteTablesRequest)((Object)obj);
        if (other.isDryRun() == null ^ this.isDryRun() == null) {
            return false;
        }
        if (other.isDryRun() != null && !other.isDryRun().equals(this.isDryRun())) {
            return false;
        }
        if (other.getRouteTableIds() == null ^ this.getRouteTableIds() == null) {
            return false;
        }
        if (other.getRouteTableIds() != null && !((Object)other.getRouteTableIds()).equals(this.getRouteTableIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || ((Object)other.getFilters()).equals(this.getFilters());
    }
}

