/* ui.c generated by valac 0.22.1, the Vala compiler
 * generated from ui.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <gobject/gvaluecollector.h>


#define TYPE_USER_INTERFACE (user_interface_get_type ())
#define USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INTERFACE, UserInterface))
#define USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_INTERFACE, UserInterfaceClass))
#define IS_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INTERFACE))
#define IS_USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_INTERFACE))
#define USER_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_INTERFACE, UserInterfaceClass))

typedef struct _UserInterface UserInterface;
typedef struct _UserInterfaceClass UserInterfaceClass;
typedef struct _UserInterfacePrivate UserInterfacePrivate;

#define TYPE_PROGRESS_BAR_DIALOG (progress_bar_dialog_get_type ())
#define PROGRESS_BAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialog))
#define PROGRESS_BAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogClass))
#define IS_PROGRESS_BAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRESS_BAR_DIALOG))
#define IS_PROGRESS_BAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRESS_BAR_DIALOG))
#define PROGRESS_BAR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogClass))

typedef struct _ProgressBarDialog ProgressBarDialog;
typedef struct _ProgressBarDialogClass ProgressBarDialogClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_AUTOSAVE_MANAGER (autosave_manager_get_type ())
#define AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManager))
#define AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))
#define IS_AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTOSAVE_MANAGER))
#define IS_AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTOSAVE_MANAGER))
#define AUTOSAVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))

typedef struct _AutosaveManager AutosaveManager;
typedef struct _AutosaveManagerClass AutosaveManagerClass;

#define TYPE_BOOK_VIEW (book_view_get_type ())
#define BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_VIEW, BookView))
#define BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_VIEW, BookViewClass))
#define IS_BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_VIEW))
#define IS_BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_VIEW))
#define BOOK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_VIEW, BookViewClass))

typedef struct _BookView BookView;
typedef struct _BookViewClass BookViewClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))
#define _autosave_manager_unref0(var) ((var == NULL) ? NULL : (var = (autosave_manager_unref (var), NULL)))
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_MODE (scan_mode_get_type ())
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
#define _scan_options_unref0(var) ((var == NULL) ? NULL : (var = (scan_options_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _ParamSpecUserInterface ParamSpecUserInterface;
typedef struct _ProgressBarDialogPrivate ProgressBarDialogPrivate;

struct _UserInterface {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UserInterfacePrivate * priv;
};

struct _UserInterfaceClass {
	GTypeClass parent_class;
	void (*finalize) (UserInterface *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _UserInterfacePrivate {
	GSettings* settings;
	GtkBuilder* builder;
	GtkApplicationWindow* window;
	GMenuModel* app_menu;
	GtkMenuBar* menubar;
	GtkBox* main_vbox;
	GtkInfoBar* info_bar;
	GtkImage* info_bar_image;
	GtkLabel* info_bar_label;
	GtkButton* info_bar_close_button;
	GtkButton* info_bar_change_scanner_button;
	GtkMenuItem* page_move_left_menuitem;
	GtkMenuItem* page_move_right_menuitem;
	GtkMenuItem* page_delete_menuitem;
	GtkMenuItem* crop_rotate_menuitem;
	GtkMenuItem* save_menuitem;
	GtkMenuItem* save_as_menuitem;
	GtkMenuItem* copy_to_clipboard_menuitem;
	GtkToolButton* save_toolbutton;
	GtkMenuItem* stop_menuitem;
	GtkToolButton* stop_toolbutton;
	GtkRadioMenuItem* text_toolbar_menuitem;
	GtkRadioMenuItem* text_menu_menuitem;
	GtkRadioMenuItem* photo_toolbar_menuitem;
	GtkRadioMenuItem* photo_menu_menuitem;
	GtkDialog* authorize_dialog;
	GtkLabel* authorize_label;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	GtkDialog* preferences_dialog;
	GtkComboBox* device_combo;
	GtkComboBox* text_dpi_combo;
	GtkComboBox* photo_dpi_combo;
	GtkComboBox* page_side_combo;
	GtkComboBox* paper_size_combo;
	GtkScale* brightness_scale;
	GtkScale* contrast_scale;
	GtkScale* quality_scale;
	GtkListStore* device_model;
	GtkListStore* text_dpi_model;
	GtkListStore* photo_dpi_model;
	GtkListStore* page_side_model;
	GtkListStore* paper_size_model;
	GtkAdjustment* brightness_adjustment;
	GtkAdjustment* contrast_adjustment;
	GtkAdjustment* quality_adjustment;
	gboolean setting_devices;
	gboolean user_selected_device;
	GtkFileChooserDialog* save_dialog;
	ProgressBarDialog* progress_dialog;
	gboolean have_error;
	gchar* error_title;
	gchar* error_text;
	gboolean error_change_scanner_hint;
	Book* _book;
	gchar* book_uri;
	AutosaveManager* autosave_manager;
	BookView* book_view;
	gboolean updating_page_menu;
	gint default_page_width;
	gint default_page_height;
	gint default_page_dpi;
	ScanDirection default_page_scan_direction;
	gchar* document_hint;
	gchar* _default_file_name;
	gboolean scanning_;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
	guint save_state_timeout;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecUserInterface {
	GParamSpec parent_instance;
};

struct _ProgressBarDialog {
	GtkWindow parent_instance;
	ProgressBarDialogPrivate * priv;
};

struct _ProgressBarDialogClass {
	GtkWindowClass parent_class;
};

struct _ProgressBarDialogPrivate {
	GtkProgressBar* bar;
};


static gpointer user_interface_parent_class = NULL;
static gpointer progress_bar_dialog_parent_class = NULL;

gpointer user_interface_ref (gpointer instance);
void user_interface_unref (gpointer instance);
GParamSpec* param_spec_user_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_user_interface (GValue* value, gpointer v_object);
void value_take_user_interface (GValue* value, gpointer v_object);
gpointer value_get_user_interface (const GValue* value);
GType user_interface_get_type (void) G_GNUC_CONST;
GType progress_bar_dialog_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer autosave_manager_ref (gpointer instance);
void autosave_manager_unref (gpointer instance);
GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_autosave_manager (GValue* value, gpointer v_object);
void value_take_autosave_manager (GValue* value, gpointer v_object);
gpointer value_get_autosave_manager (const GValue* value);
GType autosave_manager_get_type (void) G_GNUC_CONST;
GType book_view_get_type (void) G_GNUC_CONST;
GType scan_direction_get_type (void) G_GNUC_CONST;
#define USER_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_INTERFACE, UserInterfacePrivate))
enum  {
	USER_INTERFACE_DUMMY_PROPERTY
};
Book* user_interface_get_book (UserInterface* self);
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static void user_interface_page_removed_cb (UserInterface* self, Book* book, Page* page);
static void _user_interface_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self);
static void user_interface_page_added_cb (UserInterface* self, Book* book, Page* page);
static void _user_interface_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self);
#define USER_INTERFACE_DEFAULT_TEXT_DPI 150
#define USER_INTERFACE_DEFAULT_PHOTO_DPI 300
void user_interface_new_document_activate_cb (UserInterface* self);
static void _user_interface_new_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_save_document_activate_cb (UserInterface* self);
static void _user_interface_save_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_save_as_document_activate_cb (UserInterface* self);
static void _user_interface_save_as_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_email_document_activate_cb (UserInterface* self);
static void _user_interface_email_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_print_document_activate_cb (UserInterface* self);
static void _user_interface_print_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_preferences_activate_cb (UserInterface* self);
static void _user_interface_preferences_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_help_contents_activate_cb (UserInterface* self);
static void _user_interface_help_contents_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_about_activate_cb (UserInterface* self);
static void _user_interface_about_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_quit_activate_cb (UserInterface* self);
static void _user_interface_quit_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
UserInterface* user_interface_new (void);
UserInterface* user_interface_construct (GType object_type);
Book* book_new (void);
Book* book_construct (GType object_type);
static void user_interface_set_book (UserInterface* self, Book* value);
static void user_interface_load (UserInterface* self);
AutosaveManager* autosave_manager_new (void);
AutosaveManager* autosave_manager_construct (GType object_type);
void autosave_manager_set_book (AutosaveManager* self, Book* value);
void autosave_manager_load (AutosaveManager* self);
guint book_get_n_pages (Book* self);
static void user_interface_add_default_page (UserInterface* self);
void book_set_needs_saving (Book* self, gboolean value);
Page* book_get_page (Book* self, gint page_number);
void book_view_set_selected_page (BookView* self, Page* value);
static void user_interface_needs_saving_cb (UserInterface* self, Book* book);
static void _user_interface_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self);
static gboolean user_interface_find_scan_device (UserInterface* self, const gchar* device, GtkTreeIter* iter);
static void user_interface_show_error_dialog (UserInterface* self, const gchar* error_title, const gchar* error_text);
void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password);
void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, UserInterface* self);
gchar* user_interface_get_selected_device (UserInterface* self);
static void user_interface_update_info_bar (UserInterface* self);
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
void user_interface_set_scan_devices (UserInterface* self, GList* devices);
Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction);
void book_append_page (Book* self, Page* page);
static void user_interface_on_file_type_changed (UserInterface* self, GtkTreeSelection* selection);
static gchar* user_interface_get_selected_extension (UserInterface* self, GtkTreeSelection* selection);
static gchar* user_interface_choose_file_location (UserInterface* self);
const gchar* user_interface_get_default_file_name (UserInterface* self);
static void _user_interface_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static gboolean user_interface_save_document (UserInterface* self, gboolean force_choose_location);
void user_interface_show_progress_dialog (UserInterface* self);
void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
gint user_interface_get_quality (UserInterface* self);
void user_interface_hide_progress_dialog (UserInterface* self);
void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
static gboolean user_interface_prompt_to_save (UserInterface* self, const gchar* title, const gchar* discard_label);
gboolean book_get_needs_saving (Book* self);
static void user_interface_clear_document (UserInterface* self);
void book_clear (Book* self);
static void user_interface_new_document (UserInterface* self);
gboolean user_interface_get_scanning (UserInterface* self);
void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_set_document_hint (UserInterface* self, const gchar* document_hint, gboolean save);
void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
GType scan_type_get_type (void) G_GNUC_CONST;
static void user_interface_set_page_side (UserInterface* self, ScanType page_side);
static void user_interface_set_paper_size (UserInterface* self, gint width, gint height);
static gint user_interface_get_text_dpi (UserInterface* self);
static gint user_interface_get_photo_dpi (UserInterface* self);
static ScanType user_interface_get_page_side (UserInterface* self);
static gboolean user_interface_get_paper_size (UserInterface* self, gint* width, gint* height);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static ScanOptions* user_interface_make_scan_options (UserInterface* self);
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
GType scan_mode_get_type (void) G_GNUC_CONST;
gint user_interface_get_brightness (UserInterface* self);
gint user_interface_get_contrast (UserInterface* self);
void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, UserInterface* self);
gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, UserInterface* self);
static void user_interface_update_page_menu (UserInterface* self);
Page* book_view_get_selected_page (BookView* self);
guint book_get_page_index (Book* self, Page* page);
static void user_interface_page_selected_cb (UserInterface* self, BookView* view, Page* page);
gboolean page_get_has_crop (Page* self);
const gchar* page_get_crop_name (Page* self);
static void user_interface_show_page_cb (UserInterface* self, BookView* view, Page* page);
gchar* get_temporary_filename (const gchar* prefix, const gchar* extension);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
static void user_interface_show_page_menu_cb (UserInterface* self, BookView* view);
void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void page_rotate_left (Page* self);
void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void page_rotate_right (Page* self);
static void user_interface_set_crop (UserInterface* self, const gchar* crop_name);
void page_set_no_crop (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
void page_set_named_crop (Page* self, const gchar* name);
void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, UserInterface* self);
void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void page_rotate_crop (Page* self);
void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void book_move_page (Book* self, Page* page, guint location);
void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
Book* book_view_get_book (BookView* self);
void book_delete_page (Book* self, Page* page);
void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT copy_to_clipboard_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void page_copy_to_clipboard (Page* self, GtkWindow* window);
void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_draw_page (UserInterface* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number);
gboolean page_get_is_landscape (Page* self);
gint page_get_dpi (Page* self);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_print_document (UserInterface* self);
static void _user_interface_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_show_help (UserInterface* self);
void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_show_about (UserInterface* self);
void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
static gboolean user_interface_on_quit (UserInterface* self);
static void user_interface_save_state (UserInterface* self, gboolean force);
void autosave_manager_cleanup (AutosaveManager* self);
void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, UserInterface* self);
static void user_interface_info_bar_response_cb (UserInterface* self, GtkInfoBar* widget, gint response_id);
gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, UserInterface* self);
gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, UserInterface* self);
static void user_interface_page_size_changed_cb (UserInterface* self, Page* page);
static void user_interface_page_scan_direction_changed_cb (UserInterface* self, Page* page);
ScanDirection page_get_scan_direction (Page* self);
static void _user_interface_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self);
static void _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self);
static void user_interface_set_dpi_combo (UserInterface* self, GtkComboBox* combo, gint default_dpi, gint current_dpi);
static gboolean user_interface_has_app_menu (UserInterface* self, GtkApplication* app);
static void _user_interface_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
static void __lambda4_ (UserInterface* self);
static void ___lambda4__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void __lambda5_ (UserInterface* self);
static void ___lambda5__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void __lambda6_ (UserInterface* self);
static void ___lambda6__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void __lambda7_ (UserInterface* self);
static void ___lambda7__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
void user_interface_set_brightness (UserInterface* self, gint value);
static void __lambda8_ (UserInterface* self);
static void ___lambda8__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
void user_interface_set_contrast (UserInterface* self, gint value);
static void __lambda9_ (UserInterface* self);
static void ___lambda9__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
void user_interface_set_quality (UserInterface* self, gint value);
static void __lambda10_ (UserInterface* self);
static void ___lambda10__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
BookView* book_view_new (Book* book);
BookView* book_view_construct (GType object_type, Book* book);
static void _user_interface_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self);
static void _user_interface_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self);
static void _user_interface_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self);
static void user_interface_load_state (UserInterface* self);
ProgressBarDialog* progress_bar_dialog_new (GtkApplicationWindow* parent, const gchar* title);
ProgressBarDialog* progress_bar_dialog_construct (GType object_type, GtkApplicationWindow* parent, const gchar* title);
static void user_interface_book_saving_cb (UserInterface* self, gint page_number);
static void _user_interface_book_saving_cb_book_saving (Book* _sender, gint i, gpointer self);
static gchar* user_interface_get_state_filename (UserInterface* self);
static gint user_interface_state_get_integer (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, gint _default_);
static gboolean user_interface_state_get_boolean (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, gboolean _default_);
static gchar* user_interface_state_get_string (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, const gchar* _default_);
static gboolean ___lambda3_ (UserInterface* self);
static gboolean ____lambda3__gsource_func (gpointer self);
static gboolean ___lambda11_ (UserInterface* self);
static gboolean ____lambda11__gsource_func (gpointer self);
void progress_bar_dialog_set_fraction (ProgressBarDialog* self, gdouble percent);
void progress_bar_dialog_set_message (ProgressBarDialog* self, const gchar* message);
void user_interface_start (UserInterface* self);
Page* user_interface_get_selected_page (UserInterface* self);
void user_interface_set_selected_page (UserInterface* self, Page* value);
void user_interface_set_default_file_name (UserInterface* self, const gchar* value);
void user_interface_set_scanning (UserInterface* self, gboolean value);
void user_interface_set_selected_device (UserInterface* self, const gchar* value);
static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void user_interface_finalize (UserInterface* obj);
#define PROGRESS_BAR_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogPrivate))
enum  {
	PROGRESS_BAR_DIALOG_DUMMY_PROPERTY
};
static void progress_bar_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry USER_INTERFACE_action_entries[9] = {{"new_document", _user_interface_new_document_activate_cb_gsimple_action_activate_callback}, {"save", _user_interface_save_document_activate_cb_gsimple_action_activate_callback}, {"save_as", _user_interface_save_as_document_activate_cb_gsimple_action_activate_callback}, {"email", _user_interface_email_document_activate_cb_gsimple_action_activate_callback}, {"print", _user_interface_print_document_activate_cb_gsimple_action_activate_callback}, {"preferences", _user_interface_preferences_activate_cb_gsimple_action_activate_callback}, {"help", _user_interface_help_contents_activate_cb_gsimple_action_activate_callback}, {"about", _user_interface_about_activate_cb_gsimple_action_activate_callback}, {"quit", _user_interface_quit_activate_cb_gsimple_action_activate_callback}};

static void _user_interface_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self) {
#line 213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_removed_cb (self, _sender, page);
#line 562 "ui.c"
}


static void _user_interface_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self) {
#line 214 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_added_cb (self, _sender, page);
#line 569 "ui.c"
}


static void _user_interface_new_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_new_document_activate_cb (self);
#line 576 "ui.c"
}


static void _user_interface_save_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_document_activate_cb (self);
#line 583 "ui.c"
}


static void _user_interface_save_as_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_as_document_activate_cb (self);
#line 590 "ui.c"
}


static void _user_interface_email_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_email_document_activate_cb (self);
#line 597 "ui.c"
}


static void _user_interface_print_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_print_document_activate_cb (self);
#line 604 "ui.c"
}


static void _user_interface_preferences_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_preferences_activate_cb (self);
#line 611 "ui.c"
}


static void _user_interface_help_contents_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_help_contents_activate_cb (self);
#line 618 "ui.c"
}


static void _user_interface_about_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_about_activate_cb (self);
#line 625 "ui.c"
}


static void _user_interface_quit_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_quit_activate_cb (self);
#line 632 "ui.c"
}


static void _user_interface_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_needs_saving_cb (self, _sender);
#line 639 "ui.c"
}


UserInterface* user_interface_construct (GType object_type) {
	UserInterface* self = NULL;
	GSettings* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	Book* _tmp2_ = NULL;
	Book* _tmp3_ = NULL;
	Book* _tmp4_ = NULL;
	AutosaveManager* _tmp5_ = NULL;
	AutosaveManager* _tmp6_ = NULL;
	Book* _tmp7_ = NULL;
	AutosaveManager* _tmp8_ = NULL;
	Book* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	Book* _tmp17_ = NULL;
#line 187 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = (UserInterface*) g_type_create_instance (object_type);
#line 189 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = g_settings_new ("org.gnome.SimpleScan");
#line 189 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->settings);
#line 189 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->settings = _tmp0_;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_new ();
#line 191 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_book (self, _tmp2_);
#line 191 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_book_unref0 (_tmp2_);
#line 192 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->_book;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp3_, "page-removed", (GCallback) _user_interface_page_removed_cb_book_page_removed, self);
#line 193 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->_book;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp4_, "page-added", (GCallback) _user_interface_page_added_cb_book_page_added, self);
#line 195 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_load (self);
#line 197 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = autosave_manager_new ();
#line 197 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_autosave_manager_unref0 (self->priv->autosave_manager);
#line 197 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->autosave_manager = _tmp5_;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = self->priv->autosave_manager;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = self->priv->_book;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	autosave_manager_set_book (_tmp6_, _tmp7_);
#line 199 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = self->priv->autosave_manager;
#line 199 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	autosave_manager_load (_tmp8_);
#line 201 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = self->priv->_book;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = book_get_n_pages (_tmp9_);
#line 201 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = _tmp10_;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp11_ == ((guint) 0)) {
#line 708 "ui.c"
		Book* _tmp12_ = NULL;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_add_default_page (self);
#line 204 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp12_ = self->priv->_book;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		book_set_needs_saving (_tmp12_, FALSE);
#line 716 "ui.c"
	} else {
		BookView* _tmp13_ = NULL;
		Book* _tmp14_ = NULL;
		Page* _tmp15_ = NULL;
		Page* _tmp16_ = NULL;
#line 207 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp13_ = self->priv->book_view;
#line 207 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp14_ = self->priv->_book;
#line 207 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = book_get_page (_tmp14_, 0);
#line 207 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp16_ = _tmp15_;
#line 207 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		book_view_set_selected_page (_tmp13_, _tmp16_);
#line 207 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_page_unref0 (_tmp16_);
#line 734 "ui.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = self->priv->_book;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp17_, "needs-saving-changed", (GCallback) _user_interface_needs_saving_cb_book_needs_saving_changed, self);
#line 187 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self;
#line 742 "ui.c"
}


UserInterface* user_interface_new (void) {
#line 187 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return user_interface_construct (TYPE_USER_INTERFACE);
#line 749 "ui.c"
}


static gboolean user_interface_find_scan_device (UserInterface* self, const gchar* device, GtkTreeIter* iter) {
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	gboolean have_iter = FALSE;
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 217 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 217 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (device != NULL, FALSE);
#line 219 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	have_iter = FALSE;
#line 221 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->device_model;
#line 221 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 221 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_iter = _tmp1_;
#line 221 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 774 "ui.c"
		{
			gboolean _tmp3_ = FALSE;
#line 223 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp3_ = TRUE;
#line 223 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			while (TRUE) {
#line 781 "ui.c"
				gboolean _tmp4_ = FALSE;
				gchar* d = NULL;
				GtkListStore* _tmp10_ = NULL;
				GtkTreeIter _tmp11_ = {0};
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
#line 223 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp4_ = _tmp3_;
#line 223 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (!_tmp4_) {
#line 792 "ui.c"
					gboolean _tmp5_ = FALSE;
					gboolean _tmp6_ = FALSE;
					gboolean _tmp9_ = FALSE;
#line 229 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp6_ = have_iter;
#line 229 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (!_tmp6_) {
#line 800 "ui.c"
						GtkListStore* _tmp7_ = NULL;
						gboolean _tmp8_ = FALSE;
#line 229 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp7_ = self->priv->device_model;
#line 229 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp8_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp7_, &_vala_iter);
#line 229 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp5_ = _tmp8_;
#line 809 "ui.c"
					} else {
#line 229 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp5_ = FALSE;
#line 813 "ui.c"
					}
#line 229 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp9_ = _tmp5_;
#line 229 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (!_tmp9_) {
#line 229 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						break;
#line 821 "ui.c"
					}
				}
#line 223 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp3_ = FALSE;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp10_ = self->priv->device_model;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp11_ = _vala_iter;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 0, &d, -1, -1);
#line 227 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp12_ = d;
#line 227 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp13_ = device;
#line 227 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
#line 228 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					have_iter = TRUE;
#line 840 "ui.c"
				}
#line 223 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_free0 (d);
#line 844 "ui.c"
			}
		}
	}
#line 232 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = have_iter;
#line 232 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (iter) {
#line 232 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*iter = _vala_iter;
#line 854 "ui.c"
	}
#line 232 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 858 "ui.c"
}


static void user_interface_show_error_dialog (UserInterface* self, const gchar* error_title, const gchar* error_text) {
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (error_title != NULL);
#line 235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (error_text != NULL);
#line 237 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->window;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = error_title;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp1_);
#line 237 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp2_);
#line 237 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dialog = _tmp2_;
#line 242 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _ ("_Close");
#line 242 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) dialog, _tmp3_, 0);
#line 243 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = error_text;
#line 243 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp4_);
#line 244 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) dialog);
#line 235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (dialog);
#line 897 "ui.c"
}


void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password) {
	gchar* _vala_username = NULL;
	gchar* _vala_password = NULL;
	gchar* description = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	GtkEntry* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	GtkEntry* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GtkEntry* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 247 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (resource != NULL);
#line 250 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = _ ("Username and password required to access '%s'");
#line 250 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = resource;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = g_strdup_printf (_tmp0_, _tmp1_);
#line 250 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	description = _tmp2_;
#line 252 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->username_entry;
#line 252 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_entry_set_text (_tmp3_, "");
#line 253 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->password_entry;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_entry_set_text (_tmp4_, "");
#line 254 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = self->priv->authorize_label;
#line 254 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_label_set_text (_tmp5_, description);
#line 256 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = self->priv->authorize_dialog;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp6_);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = self->priv->authorize_dialog;
#line 257 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_dialog_run (_tmp7_);
#line 258 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = self->priv->authorize_dialog;
#line 258 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp8_);
#line 260 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = self->priv->username_entry;
#line 260 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = gtk_entry_get_text (_tmp9_);
#line 260 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 260 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_vala_username);
#line 260 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_username = _tmp11_;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = self->priv->password_entry;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = gtk_entry_get_text (_tmp12_);
#line 261 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = g_strdup (_tmp13_);
#line 261 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_vala_password);
#line 261 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_password = _tmp14_;
#line 247 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (description);
#line 247 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (username) {
#line 247 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*username = _vala_username;
#line 982 "ui.c"
	} else {
#line 247 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_vala_username);
#line 986 "ui.c"
	}
#line 247 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (password) {
#line 247 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*password = _vala_password;
#line 992 "ui.c"
	} else {
#line 247 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_vala_password);
#line 996 "ui.c"
	}
}


void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 265 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 265 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 267 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->setting_devices;
#line 267 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 1017 "ui.c"
	}
#line 269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->user_selected_device = TRUE;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_selected_device (self);
#line 270 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = _tmp3_ != NULL;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_tmp3_);
#line 270 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_) {
#line 1033 "ui.c"
		GSettings* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = self->priv->settings;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = user_interface_get_selected_device (self);
#line 271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = _tmp6_;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = _tmp7_;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_settings_set_string (_tmp5_, "selected-device", _tmp8_);
#line 271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_tmp8_);
#line 1050 "ui.c"
	}
}


static void user_interface_update_info_bar (UserInterface* self) {
	GtkMessageType type = 0;
	gchar* title = NULL;
	gchar* text = NULL;
	gchar* image_id = NULL;
	gboolean show_close_button = FALSE;
	gboolean show_change_scanner_button = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkInfoBar* _tmp15_ = NULL;
	GtkMessageType _tmp16_ = 0;
	GtkImage* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* message = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GtkButton* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	GtkButton* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	GtkInfoBar* _tmp28_ = NULL;
#line 274 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 278 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	show_close_button = FALSE;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	show_change_scanner_button = FALSE;
#line 281 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->have_error;
#line 281 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 1088 "ui.c"
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		type = GTK_MESSAGE_ERROR;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = g_strdup ("dialog-error");
#line 284 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (image_id);
#line 284 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		image_id = _tmp1_;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = self->priv->error_title;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 285 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (title);
#line 285 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		title = _tmp3_;
#line 286 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->error_text;
#line 286 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 286 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (text);
#line 286 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		text = _tmp5_;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		show_close_button = TRUE;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = self->priv->error_change_scanner_hint;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		show_change_scanner_button = _tmp6_;
#line 1125 "ui.c"
	} else {
		GtkListStore* _tmp7_ = NULL;
		gint _tmp8_ = 0;
#line 290 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = self->priv->device_model;
#line 290 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp7_, NULL);
#line 290 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp8_ == 0) {
#line 1135 "ui.c"
			gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
#line 292 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			type = GTK_MESSAGE_WARNING;
#line 293 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp9_ = g_strdup ("dialog-warning");
#line 293 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (image_id);
#line 293 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			image_id = _tmp9_;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp10_ = _ ("No scanners detected");
#line 295 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp11_ = g_strdup (_tmp10_);
#line 295 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (title);
#line 295 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			title = _tmp11_;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp12_ = _ ("Please check your scanner is connected and powered on");
#line 297 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp13_ = g_strdup (_tmp12_);
#line 297 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (text);
#line 297 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			text = _tmp13_;
#line 1165 "ui.c"
		} else {
			GtkInfoBar* _tmp14_ = NULL;
#line 301 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp14_ = self->priv->info_bar;
#line 301 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_widget_hide ((GtkWidget*) _tmp14_);
#line 302 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (image_id);
#line 302 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (text);
#line 302 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (title);
#line 302 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			return;
#line 1180 "ui.c"
		}
	}
#line 305 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = self->priv->info_bar;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = type;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_info_bar_set_message_type (_tmp15_, _tmp16_);
#line 306 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = self->priv->info_bar_image;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = image_id;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_image_set_from_icon_name (_tmp17_, _tmp18_, GTK_ICON_SIZE_DIALOG);
#line 307 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = title;
#line 307 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = text;
#line 307 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = g_strdup_printf ("<big><b>%s</b></big>\n\n%s", _tmp19_, _tmp20_);
#line 307 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	message = _tmp21_;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = self->priv->info_bar_label;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = message;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_label_set_markup (_tmp22_, _tmp23_);
#line 309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = self->priv->info_bar_close_button;
#line 309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = show_close_button;
#line 309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp24_, _tmp25_);
#line 310 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp26_ = self->priv->info_bar_change_scanner_button;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = show_change_scanner_button;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp26_, _tmp27_);
#line 311 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp28_ = self->priv->info_bar;
#line 311 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp28_);
#line 274 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (message);
#line 274 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (image_id);
#line 274 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (text);
#line 274 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (title);
#line 1233 "ui.c"
}


static gpointer _scan_device_ref0 (gpointer self) {
#line 328 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self ? scan_device_ref (self) : NULL;
#line 1240 "ui.c"
}


void user_interface_set_scan_devices (UserInterface* self, GList* devices) {
	gboolean have_selection = FALSE;
	gint index = 0;
	GtkTreeIter iter = {0};
	gboolean _tmp0_ = FALSE;
	GList* _tmp3_ = NULL;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp55_ = FALSE;
#line 314 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 316 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	have_selection = FALSE;
#line 320 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->setting_devices = TRUE;
#line 323 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->user_selected_device;
#line 323 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 1263 "ui.c"
		GtkComboBox* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 324 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = self->priv->device_combo;
#line 324 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = gtk_combo_box_get_active (_tmp1_);
#line 324 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		have_selection = _tmp2_ >= 0;
#line 1272 "ui.c"
	}
#line 327 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	index = 0;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = devices;
#line 1278 "ui.c"
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		device_collection = _tmp3_;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
#line 1286 "ui.c"
			ScanDevice* _tmp4_ = NULL;
			ScanDevice* device = NULL;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp4_ = _scan_device_ref0 ((ScanDevice*) device_it->data);
#line 328 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			device = _tmp4_;
#line 1293 "ui.c"
			{
				gint n_delete = 0;
				GtkListStore* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				GtkTreeIter _tmp7_ = {0};
				gboolean _tmp8_ = FALSE;
				gint _tmp21_ = 0;
				gint _tmp45_ = 0;
#line 330 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				n_delete = -1;
#line 333 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp5_ = self->priv->device_model;
#line 333 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp6_ = index;
#line 333 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp8_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp5_, &_tmp7_, NULL, _tmp6_);
#line 333 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				iter = _tmp7_;
#line 333 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp8_) {
#line 1314 "ui.c"
					gint i = 0;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					i = 0;
#line 1318 "ui.c"
					{
						gboolean _tmp9_ = FALSE;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp9_ = TRUE;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						while (TRUE) {
#line 1325 "ui.c"
							gboolean _tmp10_ = FALSE;
							gchar* name = NULL;
							gboolean matched = FALSE;
							GtkListStore* _tmp13_ = NULL;
							GtkTreeIter _tmp14_ = {0};
							const gchar* _tmp15_ = NULL;
							ScanDevice* _tmp16_ = NULL;
							const gchar* _tmp17_ = NULL;
							gboolean _tmp18_ = FALSE;
							gint _tmp20_ = 0;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp10_ = _tmp9_;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							if (!_tmp10_) {
#line 1340 "ui.c"
								GtkListStore* _tmp11_ = NULL;
								gboolean _tmp12_ = FALSE;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp11_ = self->priv->device_model;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp12_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp11_, &iter);
#line 350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								if (!_tmp12_) {
#line 350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
									break;
#line 1351 "ui.c"
								}
							}
#line 336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp9_ = FALSE;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp13_ = self->priv->device_model;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp14_ = iter;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							gtk_tree_model_get ((GtkTreeModel*) _tmp13_, &_tmp14_, 0, &name, -1, -1);
#line 342 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp15_ = name;
#line 342 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp16_ = device;
#line 342 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp17_ = _tmp16_->name;
#line 342 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							matched = g_strcmp0 (_tmp15_, _tmp17_) == 0;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp18_ = matched;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							if (_tmp18_) {
#line 1374 "ui.c"
								gint _tmp19_ = 0;
#line 346 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp19_ = i;
#line 346 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								n_delete = _tmp19_;
#line 347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_g_free0 (name);
#line 347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								break;
#line 1384 "ui.c"
							}
#line 349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp20_ = i;
#line 349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							i = _tmp20_ + 1;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_g_free0 (name);
#line 1392 "ui.c"
						}
					}
				}
#line 354 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp21_ = n_delete;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp21_ >= 0) {
#line 1400 "ui.c"
					gint i = 0;
					GtkListStore* _tmp22_ = NULL;
					GtkTreeIter _tmp23_ = {0};
					ScanDevice* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp22_ = self->priv->device_model;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp23_ = iter;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp24_ = device;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp25_ = _tmp24_->label;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_list_store_set (_tmp22_, &_tmp23_, 1, _tmp25_, -1, -1);
#line 1416 "ui.c"
					{
						gboolean _tmp26_ = FALSE;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						i = 0;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp26_ = TRUE;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						while (TRUE) {
#line 1425 "ui.c"
							gboolean _tmp27_ = FALSE;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							GtkListStore* _tmp31_ = NULL;
							gint _tmp32_ = 0;
							GtkTreeIter _tmp33_ = {0};
							GtkListStore* _tmp34_ = NULL;
							GtkTreeIter _tmp35_ = {0};
#line 361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp27_ = _tmp26_;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							if (!_tmp27_) {
#line 1438 "ui.c"
								gint _tmp28_ = 0;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp28_ = i;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								i = _tmp28_ + 1;
#line 1444 "ui.c"
							}
#line 361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp26_ = FALSE;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp29_ = i;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp30_ = n_delete;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							if (!(_tmp29_ < _tmp30_)) {
#line 361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								break;
#line 1456 "ui.c"
							}
#line 363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp31_ = self->priv->device_model;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp32_ = index;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp31_, &_tmp33_, NULL, _tmp32_);
#line 363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							iter = _tmp33_;
#line 364 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp34_ = self->priv->device_model;
#line 364 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp35_ = iter;
#line 364 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							gtk_list_store_remove (_tmp34_, &_tmp35_);
#line 1472 "ui.c"
						}
					}
				} else {
					GtkListStore* _tmp36_ = NULL;
					gint _tmp37_ = 0;
					GtkTreeIter _tmp38_ = {0};
					GtkListStore* _tmp39_ = NULL;
					GtkTreeIter _tmp40_ = {0};
					ScanDevice* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					ScanDevice* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp36_ = self->priv->device_model;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp37_ = index;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_list_store_insert (_tmp36_, &_tmp38_, _tmp37_);
#line 369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					iter = _tmp38_;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp39_ = self->priv->device_model;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp40_ = iter;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp41_ = device;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp42_ = _tmp41_->name;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp43_ = device;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp44_ = _tmp43_->label;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_list_store_set (_tmp39_, &_tmp40_, 0, _tmp42_, 1, _tmp44_, -1, -1);
#line 1507 "ui.c"
				}
#line 372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp45_ = index;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				index = _tmp45_ + 1;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_scan_device_unref0 (device);
#line 1515 "ui.c"
			}
		}
	}
#line 376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	while (TRUE) {
#line 1521 "ui.c"
		GtkListStore* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		GtkTreeIter _tmp48_ = {0};
		gboolean _tmp49_ = FALSE;
		GtkListStore* _tmp50_ = NULL;
		GtkTreeIter _tmp51_ = {0};
#line 376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp46_ = self->priv->device_model;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp47_ = index;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp49_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp46_, &_tmp48_, NULL, _tmp47_);
#line 376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		iter = _tmp48_;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (!_tmp49_) {
#line 376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			break;
#line 1540 "ui.c"
		}
#line 377 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp50_ = self->priv->device_model;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp51_ = iter;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_list_store_remove (_tmp50_, &_tmp51_);
#line 1548 "ui.c"
	}
#line 380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp53_ = have_selection;
#line 380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp53_) {
#line 1554 "ui.c"
		GList* _tmp54_ = NULL;
#line 380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp54_ = devices;
#line 380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp52_ = _tmp54_ != NULL;
#line 1560 "ui.c"
	} else {
#line 380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp52_ = FALSE;
#line 1564 "ui.c"
	}
#line 380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp55_ = _tmp52_;
#line 380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp55_) {
#line 1570 "ui.c"
		GtkComboBox* _tmp56_ = NULL;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp56_ = self->priv->device_combo;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_combo_box_set_active (_tmp56_, 0);
#line 1576 "ui.c"
	}
#line 383 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->setting_devices = FALSE;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_info_bar (self);
#line 1582 "ui.c"
}


static void user_interface_add_default_page (UserInterface* self) {
	Page* page = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ScanDirection _tmp3_ = 0;
	Page* _tmp4_ = NULL;
	Book* _tmp5_ = NULL;
	BookView* _tmp6_ = NULL;
#line 388 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->default_page_width;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->default_page_height;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->default_page_dpi;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->default_page_scan_direction;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp4_;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = self->priv->_book;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_append_page (_tmp5_, page);
#line 395 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = self->priv->book_view;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_view_set_selected_page (_tmp6_, page);
#line 388 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 1619 "ui.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 928 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 929 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 929 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 929 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 929 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 931 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 931 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1644 "ui.c"
		gchar* _tmp4_ = NULL;
#line 932 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 932 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 932 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 1652 "ui.c"
	} else {
#line 934 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = -1;
#line 934 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 1658 "ui.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1189 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1190 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1190 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1190 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1191 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1191 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1694 "ui.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1192 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1192 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1192 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1703 "ui.c"
	}
#line 1194 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1194 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1709 "ui.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1195 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1195 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1195 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1718 "ui.c"
	}
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1724 "ui.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1733 "ui.c"
	} else {
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1737 "ui.c"
	}
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 1747 "ui.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 1756 "ui.c"
	} else {
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 1760 "ui.c"
	}
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1199 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1199 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1199 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 1784 "ui.c"
}


static void user_interface_on_file_type_changed (UserInterface* self, GtkTreeSelection* selection) {
	gchar* extension = NULL;
	GtkTreeSelection* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path = NULL;
	GtkFileChooserDialog* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint extension_index = 0;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GtkFileChooserDialog* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
#line 398 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 398 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (selection != NULL);
#line 400 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = selection;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_selected_extension (self, _tmp0_);
#line 400 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	extension = _tmp1_;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->save_dialog;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp2_);
#line 401 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	path = _tmp3_;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = path;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = g_path_get_basename (_tmp4_);
#line 402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	filename = _tmp5_;
#line 405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = filename;
#line 405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = string_last_index_of_char (_tmp6_, (gunichar) '.', 0);
#line 405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	extension_index = _tmp7_;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = extension_index;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp8_ >= 0) {
#line 1839 "ui.c"
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gchar* _tmp11_ = NULL;
#line 407 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = filename;
#line 407 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = extension_index;
#line 407 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp11_ = string_slice (_tmp9_, (glong) 0, (glong) _tmp10_);
#line 407 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (filename);
#line 407 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		filename = _tmp11_;
#line 1853 "ui.c"
	}
#line 408 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = filename;
#line 408 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = extension;
#line 408 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
#line 408 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (filename);
#line 408 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	filename = _tmp14_;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = self->priv->save_dialog;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = filename;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp15_, _tmp16_);
#line 398 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (filename);
#line 398 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (path);
#line 398 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (extension);
#line 1877 "ui.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self ? g_object_ref (self) : NULL;
#line 1884 "ui.c"
}


static gchar* user_interface_get_selected_extension (UserInterface* self, GtkTreeSelection* selection) {
	gchar* result = NULL;
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	gchar* extension = NULL;
	gchar* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	GtkTreeModel* _tmp5_ = NULL;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 412 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (selection != NULL, NULL);
#line 416 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = g_strdup ("");
#line 416 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	extension = _tmp0_;
#line 418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = selection;
#line 418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = gtk_tree_selection_get_selected (_tmp1_, &_tmp2_, &_tmp3_);
#line 418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (model);
#line 418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = _g_object_ref0 (_tmp2_);
#line 418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	model = _tmp5_;
#line 418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp3_;
#line 418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_) {
#line 1921 "ui.c"
		GtkTreeModel* _tmp6_ = NULL;
		GtkTreeIter _tmp7_ = {0};
#line 419 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = model;
#line 419 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = iter;
#line 419 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get (_tmp6_, &_tmp7_, 1, &extension, -1, -1);
#line 1930 "ui.c"
	}
#line 420 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = extension;
#line 420 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (model);
#line 420 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 1938 "ui.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1961 "ui.c"
		glong _tmp4_ = 0L;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 1969 "ui.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 1981 "ui.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1167 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 2006 "ui.c"
		glong _tmp2_ = 0L;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 2012 "ui.c"
	} else {
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2016 "ui.c"
	}
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 2022 "ui.c"
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 2034 "ui.c"
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 2044 "ui.c"
	}
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 2050 "ui.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 2064 "ui.c"
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 2074 "ui.c"
	}
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 2080 "ui.c"
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 2089 "ui.c"
	}
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 2109 "ui.c"
}


static void _user_interface_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
#line 507 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_on_file_type_changed (self, _sender);
#line 2116 "ui.c"
}


static gchar* user_interface_choose_file_location (UserInterface* self) {
	gchar* result = NULL;
	gchar* directory = NULL;
	GSettings* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp8_ = NULL;
	GtkApplicationWindow* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_ = NULL;
	GtkFileChooserDialog* _tmp14_ = NULL;
	GtkFileChooserDialog* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkFileChooserDialog* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp19_ = NULL;
	GtkFileFilter* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GtkFileFilter* _tmp22_ = NULL;
	GtkFileFilter* _tmp23_ = NULL;
	GtkFileChooserDialog* _tmp24_ = NULL;
	GtkFileFilter* _tmp25_ = NULL;
	GtkFileFilter* _tmp26_ = NULL;
	GtkFileFilter* _tmp27_ = NULL;
	GtkFileFilter* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GtkFileFilter* _tmp30_ = NULL;
	GtkFileChooserDialog* _tmp31_ = NULL;
	GtkFileFilter* _tmp32_ = NULL;
	GtkFileFilter* _tmp33_ = NULL;
	GtkExpander* expander = NULL;
	const gchar* _tmp34_ = NULL;
	GtkExpander* _tmp35_ = NULL;
	GtkExpander* _tmp36_ = NULL;
	GtkFileChooserDialog* _tmp37_ = NULL;
	GtkExpander* _tmp38_ = NULL;
	gchar* default_extension = NULL;
	gchar* _tmp39_ = NULL;
	gint index = 0;
	const gchar* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	GtkListStore* file_type_store = NULL;
	GtkListStore* _tmp46_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp47_ = NULL;
	GtkTreeIter _tmp48_ = {0};
	GtkListStore* _tmp49_ = NULL;
	GtkTreeIter _tmp50_ = {0};
	const gchar* _tmp51_ = NULL;
	GtkListStore* _tmp52_ = NULL;
	GtkTreeIter _tmp53_ = {0};
	GtkListStore* _tmp54_ = NULL;
	GtkTreeIter _tmp55_ = {0};
	const gchar* _tmp56_ = NULL;
	GtkListStore* _tmp57_ = NULL;
	GtkTreeIter _tmp58_ = {0};
	GtkListStore* _tmp59_ = NULL;
	GtkTreeIter _tmp60_ = {0};
	const gchar* _tmp61_ = NULL;
	GtkTreeView* file_type_view = NULL;
	GtkListStore* _tmp62_ = NULL;
	GtkTreeView* _tmp63_ = NULL;
	GtkTreeView* _tmp64_ = NULL;
	GtkTreeView* _tmp65_ = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkCellRendererText* _tmp66_ = NULL;
	GtkCellRendererText* _tmp67_ = NULL;
	GtkTreeViewColumn* _tmp68_ = NULL;
	GtkTreeViewColumn* _tmp69_ = NULL;
	GtkTreeView* _tmp70_ = NULL;
	GtkTreeViewColumn* _tmp71_ = NULL;
	GtkExpander* _tmp72_ = NULL;
	GtkTreeView* _tmp73_ = NULL;
	GtkListStore* _tmp74_ = NULL;
	GtkTreeIter _tmp75_ = {0};
	gboolean _tmp76_ = FALSE;
	GtkTreeView* _tmp88_ = NULL;
	GtkTreeSelection* _tmp89_ = NULL;
	GtkExpander* _tmp90_ = NULL;
	gint response = 0;
	GtkFileChooserDialog* _tmp91_ = NULL;
	gint _tmp92_ = 0;
	gchar* uri = NULL;
	gint _tmp93_ = 0;
	GSettings* _tmp113_ = NULL;
	GtkFileChooserDialog* _tmp114_ = NULL;
	gchar* _tmp115_ = NULL;
	gchar* _tmp116_ = NULL;
	GtkTreeView* _tmp117_ = NULL;
	GtkTreeSelection* _tmp118_ = NULL;
	guint _tmp119_ = 0U;
	GtkFileChooserDialog* _tmp120_ = NULL;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 426 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	directory = NULL;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_settings_get_string (_tmp0_, "save-directory");
#line 427 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (directory);
#line 427 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	directory = _tmp1_;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = directory;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp3_ == NULL) {
#line 429 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = TRUE;
#line 2236 "ui.c"
	} else {
		const gchar* _tmp4_ = NULL;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = directory;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
#line 2243 "ui.c"
	}
#line 429 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = _tmp2_;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp5_) {
#line 2249 "ui.c"
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 430 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
#line 430 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 430 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (directory);
#line 430 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		directory = _tmp7_;
#line 2260 "ui.c"
	}
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = _ ("Save As...");
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = self->priv->window;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = _ ("_Cancel");
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = _ ("_Save");
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp8_, (GtkWindow*) _tmp9_, GTK_FILE_CHOOSER_ACTION_SAVE, _tmp10_, GTK_RESPONSE_CANCEL, _tmp11_, GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp12_);
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->save_dialog = _tmp12_;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = self->priv->save_dialog;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp13_, TRUE);
#line 440 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = self->priv->save_dialog;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp14_, FALSE);
#line 441 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = self->priv->save_dialog;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = directory;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp15_, _tmp16_);
#line 442 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = self->priv->save_dialog;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = self->priv->_default_file_name;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp17_, _tmp18_);
#line 445 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = gtk_file_filter_new ();
#line 445 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp19_);
#line 445 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	filter = _tmp19_;
#line 446 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = filter;
#line 446 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = _ ("Image Files");
#line 446 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_filter_set_name (_tmp20_, _tmp21_);
#line 448 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = filter;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_filter_add_pixbuf_formats (_tmp22_);
#line 449 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = filter;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_filter_add_mime_type (_tmp23_, "application/pdf");
#line 450 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = self->priv->save_dialog;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = filter;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp26_ = _g_object_ref0 (_tmp25_);
#line 450 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp24_, _tmp26_);
#line 451 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = gtk_file_filter_new ();
#line 451 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp27_);
#line 451 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (filter);
#line 451 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	filter = _tmp27_;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp28_ = filter;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp29_ = _ ("All Files");
#line 452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_filter_set_name (_tmp28_, _tmp29_);
#line 454 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp30_ = filter;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_filter_add_pattern (_tmp30_, "*");
#line 455 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp31_ = self->priv->save_dialog;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp32_ = filter;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp33_ = _g_object_ref0 (_tmp32_);
#line 455 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp31_, _tmp33_);
#line 457 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp34_ = _ ("Select File _Type");
#line 457 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp35_ = (GtkExpander*) gtk_expander_new_with_mnemonic (_tmp34_);
#line 457 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp35_);
#line 457 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	expander = _tmp35_;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp36_ = expander;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_expander_set_spacing (_tmp36_, 5);
#line 460 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp37_ = self->priv->save_dialog;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp38_ = expander;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_extra_widget ((GtkFileChooser*) _tmp37_, (GtkWidget*) _tmp38_);
#line 462 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp39_ = g_strdup ("");
#line 462 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	default_extension = _tmp39_;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp40_ = self->priv->_default_file_name;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp41_ = string_last_index_of_char (_tmp40_, (gunichar) '.', 0);
#line 463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	index = _tmp41_;
#line 464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp42_ = index;
#line 464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp42_ >= 0) {
#line 2384 "ui.c"
		const gchar* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gchar* _tmp45_ = NULL;
#line 465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp43_ = self->priv->_default_file_name;
#line 465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp44_ = index;
#line 465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp45_ = string_substring (_tmp43_, (glong) _tmp44_, (glong) (-1));
#line 465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (default_extension);
#line 465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		default_extension = _tmp45_;
#line 2398 "ui.c"
	}
#line 467 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp46_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
#line 467 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	file_type_store = _tmp46_;
#line 469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp47_ = file_type_store;
#line 469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp47_, &_tmp48_);
#line 469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp48_;
#line 470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp49_ = file_type_store;
#line 470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp50_ = iter;
#line 470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp51_ = _ ("PDF (multi-page document)");
#line 470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp49_, &_tmp50_, 0, _tmp51_, 1, ".pdf", -1, -1);
#line 475 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp52_ = file_type_store;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp52_, &_tmp53_);
#line 475 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp53_;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp54_ = file_type_store;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp55_ = iter;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp56_ = _ ("JPEG (compressed)");
#line 476 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp54_, &_tmp55_, 0, _tmp56_, 1, ".jpg", -1, -1);
#line 481 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp57_ = file_type_store;
#line 481 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp57_, &_tmp58_);
#line 481 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp58_;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp59_ = file_type_store;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp60_ = iter;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp61_ = _ ("PNG (lossless)");
#line 482 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp59_, &_tmp60_, 0, _tmp61_, 1, ".png", -1, -1);
#line 488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp62_ = file_type_store;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp63_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp62_);
#line 488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp63_);
#line 488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	file_type_view = _tmp63_;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp64_ = file_type_view;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_tree_view_set_headers_visible (_tmp64_, FALSE);
#line 490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp65_ = file_type_view;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_tree_view_set_rules_hint (_tmp65_, TRUE);
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp66_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp66_);
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp67_ = _tmp66_;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp68_ = gtk_tree_view_column_new_with_attributes ("", (GtkCellRenderer*) _tmp67_, "text", 0, NULL, NULL);
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp68_);
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp69_ = _tmp68_;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (_tmp67_);
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	column = _tmp69_;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp70_ = file_type_view;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp71_ = column;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_tree_view_append_column (_tmp70_, _tmp71_);
#line 495 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp72_ = expander;
#line 495 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp73_ = file_type_view;
#line 495 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_container_add ((GtkContainer*) _tmp72_, (GtkWidget*) _tmp73_);
#line 497 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp74_ = file_type_store;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp76_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp74_, &_tmp75_);
#line 497 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp75_;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp76_) {
#line 2498 "ui.c"
		{
			gboolean _tmp77_ = FALSE;
#line 499 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp77_ = TRUE;
#line 499 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			while (TRUE) {
#line 2505 "ui.c"
				gboolean _tmp78_ = FALSE;
				gchar* e = NULL;
				GtkListStore* _tmp81_ = NULL;
				GtkTreeIter _tmp82_ = {0};
				const gchar* _tmp83_ = NULL;
				const gchar* _tmp84_ = NULL;
#line 499 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp78_ = _tmp77_;
#line 499 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (!_tmp78_) {
#line 2516 "ui.c"
					GtkListStore* _tmp79_ = NULL;
					gboolean _tmp80_ = FALSE;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp79_ = file_type_store;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp80_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp79_, &iter);
#line 505 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (!_tmp80_) {
#line 505 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						break;
#line 2527 "ui.c"
					}
				}
#line 499 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp77_ = FALSE;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp81_ = file_type_store;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp82_ = iter;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp81_, &_tmp82_, 1, &e, -1, -1);
#line 503 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp83_ = default_extension;
#line 503 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp84_ = e;
#line 503 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (g_strcmp0 (_tmp83_, _tmp84_) == 0) {
#line 2544 "ui.c"
					GtkTreeView* _tmp85_ = NULL;
					GtkTreeSelection* _tmp86_ = NULL;
					GtkTreeIter _tmp87_ = {0};
#line 504 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp85_ = file_type_view;
#line 504 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp86_ = gtk_tree_view_get_selection (_tmp85_);
#line 504 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp87_ = iter;
#line 504 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_tree_selection_select_iter (_tmp86_, &_tmp87_);
#line 2556 "ui.c"
				}
#line 499 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_free0 (e);
#line 2560 "ui.c"
			}
		}
	}
#line 507 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp88_ = file_type_view;
#line 507 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp89_ = gtk_tree_view_get_selection (_tmp88_);
#line 507 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp89_, "changed", (GCallback) _user_interface_on_file_type_changed_gtk_tree_selection_changed, self);
#line 509 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp90_ = expander;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp90_);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp91_ = self->priv->save_dialog;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp92_ = gtk_dialog_run ((GtkDialog*) _tmp91_);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	response = _tmp92_;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	uri = NULL;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp93_ = response;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp93_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 2586 "ui.c"
		GtkTreeSelection* selection = NULL;
		GtkTreeView* _tmp94_ = NULL;
		GtkTreeSelection* _tmp95_ = NULL;
		GtkTreeSelection* _tmp96_ = NULL;
		gchar* extension = NULL;
		GtkTreeSelection* _tmp97_ = NULL;
		gchar* _tmp98_ = NULL;
		gchar* path = NULL;
		GtkFileChooserDialog* _tmp99_ = NULL;
		gchar* _tmp100_ = NULL;
		gchar* filename = NULL;
		const gchar* _tmp101_ = NULL;
		gchar* _tmp102_ = NULL;
		gint extension_index = 0;
		const gchar* _tmp103_ = NULL;
		gint _tmp104_ = 0;
		gint _tmp105_ = 0;
		const gchar* _tmp109_ = NULL;
		GFile* _tmp110_ = NULL;
		GFile* _tmp111_ = NULL;
		gchar* _tmp112_ = NULL;
#line 516 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp94_ = file_type_view;
#line 516 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp95_ = gtk_tree_view_get_selection (_tmp94_);
#line 516 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp96_ = _g_object_ref0 (_tmp95_);
#line 516 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		selection = _tmp96_;
#line 517 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp97_ = selection;
#line 517 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp98_ = user_interface_get_selected_extension (self, _tmp97_);
#line 517 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		extension = _tmp98_;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp99_ = self->priv->save_dialog;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp100_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp99_);
#line 519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		path = _tmp100_;
#line 520 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp101_ = path;
#line 520 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp102_ = g_path_get_basename (_tmp101_);
#line 520 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		filename = _tmp102_;
#line 522 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp103_ = filename;
#line 522 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp104_ = string_last_index_of_char (_tmp103_, (gunichar) '.', 0);
#line 522 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		extension_index = _tmp104_;
#line 523 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp105_ = extension_index;
#line 523 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp105_ < 0) {
#line 2644 "ui.c"
			const gchar* _tmp106_ = NULL;
			const gchar* _tmp107_ = NULL;
			gchar* _tmp108_ = NULL;
#line 524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp106_ = path;
#line 524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp107_ = extension;
#line 524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp108_ = g_strconcat (_tmp106_, _tmp107_, NULL);
#line 524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (path);
#line 524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			path = _tmp108_;
#line 2658 "ui.c"
		}
#line 526 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp109_ = path;
#line 526 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp110_ = g_file_new_for_path (_tmp109_);
#line 526 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp111_ = _tmp110_;
#line 526 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp112_ = g_file_get_uri (_tmp111_);
#line 526 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 526 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		uri = _tmp112_;
#line 526 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (_tmp111_);
#line 514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (filename);
#line 514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (extension);
#line 514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (selection);
#line 2682 "ui.c"
	}
#line 529 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp113_ = self->priv->settings;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp114_ = self->priv->save_dialog;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp115_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp114_);
#line 529 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp116_ = _tmp115_;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_string (_tmp113_, "save-directory", _tmp116_);
#line 529 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_tmp116_);
#line 531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp117_ = file_type_view;
#line 531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp118_ = gtk_tree_view_get_selection (_tmp117_);
#line 531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("changed", GTK_TYPE_TREE_SELECTION, &_tmp119_, NULL, FALSE);
#line 531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp118_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp119_, 0, NULL, (GCallback) _user_interface_on_file_type_changed_gtk_tree_selection_changed, self);
#line 532 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp120_ = self->priv->save_dialog;
#line 532 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp120_);
#line 533 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 533 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->save_dialog = NULL;
#line 535 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = uri;
#line 535 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (column);
#line 535 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (file_type_view);
#line 535 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (file_type_store);
#line 535 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (default_extension);
#line 535 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (expander);
#line 535 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (filter);
#line 535 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (directory);
#line 535 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 2730 "ui.c"
}


static gboolean user_interface_save_document (UserInterface* self, gboolean force_choose_location) {
	gboolean result = FALSE;
	gchar* uri = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp7_ = NULL;
	GFile* file = NULL;
	const gchar* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* uri_lower = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* format = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	Book* _tmp42_ = NULL;
	GError * _inner_error_ = NULL;
#line 538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 541 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->book_uri;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_ != NULL) {
#line 2762 "ui.c"
		gboolean _tmp2_ = FALSE;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = force_choose_location;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = !_tmp2_;
#line 2768 "ui.c"
	} else {
#line 541 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = FALSE;
#line 2772 "ui.c"
	}
#line 541 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp0_;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp3_) {
#line 2778 "ui.c"
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->book_uri;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 542 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 542 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		uri = _tmp5_;
#line 2789 "ui.c"
	} else {
		gchar* _tmp6_ = NULL;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = user_interface_choose_file_location (self);
#line 544 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 544 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		uri = _tmp6_;
#line 2798 "ui.c"
	}
#line 545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = uri;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp7_ == NULL) {
#line 546 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = FALSE;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 546 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 2810 "ui.c"
	}
#line 548 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = uri;
#line 548 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = g_file_new_for_uri (_tmp8_);
#line 548 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	file = _tmp9_;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = uri;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_debug ("ui.vala:550: Saving to '%s'", _tmp10_);
#line 552 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = uri;
#line 552 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) (-1));
#line 552 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	uri_lower = _tmp12_;
#line 553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = g_strdup ("jpeg");
#line 553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	format = _tmp13_;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = uri_lower;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = g_str_has_suffix (_tmp14_, ".pdf");
#line 554 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp15_) {
#line 2838 "ui.c"
		gchar* _tmp16_ = NULL;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp16_ = g_strdup ("pdf");
#line 555 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (format);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		format = _tmp16_;
#line 2846 "ui.c"
	} else {
		const gchar* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp17_ = uri_lower;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp18_ = g_str_has_suffix (_tmp17_, ".ps");
#line 556 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp18_) {
#line 2856 "ui.c"
			gchar* _tmp19_ = NULL;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp19_ = g_strdup ("ps");
#line 557 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (format);
#line 557 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			format = _tmp19_;
#line 2864 "ui.c"
		} else {
			const gchar* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
#line 558 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp20_ = uri_lower;
#line 558 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp21_ = g_str_has_suffix (_tmp20_, ".png");
#line 558 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (_tmp21_) {
#line 2874 "ui.c"
				gchar* _tmp22_ = NULL;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp22_ = g_strdup ("png");
#line 559 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_free0 (format);
#line 559 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				format = _tmp22_;
#line 2882 "ui.c"
			} else {
				gboolean _tmp23_ = FALSE;
				const gchar* _tmp24_ = NULL;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp28_ = FALSE;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp24_ = uri_lower;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp25_ = g_str_has_suffix (_tmp24_, ".tif");
#line 560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp25_) {
#line 560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp23_ = TRUE;
#line 2896 "ui.c"
				} else {
					const gchar* _tmp26_ = NULL;
					gboolean _tmp27_ = FALSE;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp26_ = uri_lower;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp27_ = g_str_has_suffix (_tmp26_, ".tiff");
#line 560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp23_ = _tmp27_;
#line 2906 "ui.c"
				}
#line 560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp28_ = _tmp23_;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp28_) {
#line 2912 "ui.c"
					gchar* _tmp29_ = NULL;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp29_ = g_strdup ("tiff");
#line 561 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_g_free0 (format);
#line 561 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					format = _tmp29_;
#line 2920 "ui.c"
				}
			}
		}
	}
#line 563 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_show_progress_dialog (self);
#line 2927 "ui.c"
	{
		Book* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		GFile* _tmp34_ = NULL;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp30_ = self->priv->_book;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp31_ = format;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp32_ = user_interface_get_quality (self);
#line 566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp33_ = _tmp32_;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp34_ = file;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		book_save (_tmp30_, _tmp31_, _tmp33_, _tmp34_, &_inner_error_);
#line 566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 2948 "ui.c"
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		GError* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
#line 564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_hide_progress_dialog (self);
#line 571 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp35_ = e;
#line 571 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp36_ = _tmp35_->message;
#line 571 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_warning ("ui.vala:571: Error saving file: %s", _tmp36_);
#line 572 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp37_ = _ ("Failed to save file");
#line 572 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp38_ = e;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp39_ = _tmp38_->message;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_show_error (self, _tmp37_, _tmp39_, FALSE);
#line 576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = FALSE;
#line 576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (format);
#line 576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri_lower);
#line 576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (file);
#line 576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 2995 "ui.c"
	}
	__finally16:
#line 564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (format);
#line 564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri_lower);
#line 564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (file);
#line 564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return FALSE;
#line 3014 "ui.c"
	}
#line 579 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp40_ = uri;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp41_ = g_strdup (_tmp40_);
#line 579 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 579 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->book_uri = _tmp41_;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp42_ = self->priv->_book;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_set_needs_saving (_tmp42_, FALSE);
#line 581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = TRUE;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (format);
#line 581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (uri_lower);
#line 581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (file);
#line 581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (uri);
#line 581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3040 "ui.c"
}


static gboolean user_interface_prompt_to_save (UserInterface* self, const gchar* title, const gchar* discard_label) {
	gboolean result = FALSE;
	Book* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkMessageDialog* _tmp5_ = NULL;
	GtkMessageDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkMessageDialog* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkMessageDialog* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkMessageDialog* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gint response = 0;
	GtkMessageDialog* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	GtkMessageDialog* _tmp16_ = NULL;
	gint _tmp17_ = 0;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (title != NULL, FALSE);
#line 584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (discard_label != NULL, FALSE);
#line 586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->_book;
#line 586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_get_needs_saving (_tmp0_);
#line 586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp2_) {
#line 587 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = TRUE;
#line 587 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 3084 "ui.c"
	}
#line 589 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->window;
#line 589 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = title;
#line 589 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp3_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp4_);
#line 589 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp5_);
#line 589 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dialog = _tmp5_;
#line 594 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = dialog;
#line 594 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = _ ("If you don't save, changes will be permanently lost.");
#line 594 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_message_dialog_format_secondary_text (_tmp6_, "%s", _tmp7_);
#line 597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = dialog;
#line 597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = discard_label;
#line 597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp8_, _tmp9_, (gint) GTK_RESPONSE_NO);
#line 598 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = dialog;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = _ ("_Cancel");
#line 598 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp10_, _tmp11_, (gint) GTK_RESPONSE_CANCEL);
#line 599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = dialog;
#line 599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = _ ("_Save");
#line 599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp12_, _tmp13_, (gint) GTK_RESPONSE_YES);
#line 601 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = dialog;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = gtk_dialog_run ((GtkDialog*) _tmp14_);
#line 601 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	response = _tmp15_;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = dialog;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp16_);
#line 604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = response;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	switch (_tmp17_) {
#line 604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case GTK_RESPONSE_YES:
#line 3136 "ui.c"
		{
			gboolean _tmp18_ = FALSE;
#line 607 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp18_ = user_interface_save_document (self, FALSE);
#line 607 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (_tmp18_) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				result = TRUE;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_object_unref0 (dialog);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				return result;
#line 3149 "ui.c"
			} else {
#line 610 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				result = FALSE;
#line 610 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_object_unref0 (dialog);
#line 610 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				return result;
#line 3157 "ui.c"
			}
		}
#line 604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case GTK_RESPONSE_CANCEL:
#line 3162 "ui.c"
		{
#line 612 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			result = FALSE;
#line 612 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_object_unref0 (dialog);
#line 612 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			return result;
#line 3170 "ui.c"
		}
		default:
#line 604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case GTK_RESPONSE_NO:
#line 3175 "ui.c"
		{
#line 615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			result = TRUE;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_object_unref0 (dialog);
#line 615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			return result;
#line 3183 "ui.c"
		}
	}
#line 584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (dialog);
#line 3188 "ui.c"
}


static void user_interface_clear_document (UserInterface* self) {
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	GtkMenuItem* _tmp2_ = NULL;
	GtkMenuItem* _tmp3_ = NULL;
#line 619 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 621 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->_book;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_clear (_tmp0_);
#line 622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_add_default_page (self);
#line 623 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 623 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->book_uri = NULL;
#line 624 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->_book;
#line 624 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_set_needs_saving (_tmp1_, FALSE);
#line 625 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->save_as_menuitem;
#line 625 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
#line 626 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->copy_to_clipboard_menuitem;
#line 626 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
#line 3221 "ui.c"
}


static void user_interface_new_document (UserInterface* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 629 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 631 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = _ ("Save current document?");
#line 631 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _ ("Discard Changes");
#line 631 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = user_interface_prompt_to_save (self, _tmp0_, _tmp1_);
#line 631 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp2_) {
#line 635 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 3243 "ui.c"
	}
#line 637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = user_interface_get_scanning (self);
#line 637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = _tmp3_;
#line 637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_) {
#line 638 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_signal_emit_by_name (self, "stop-scan");
#line 3253 "ui.c"
	}
#line 639 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_clear_document (self);
#line 3257 "ui.c"
}


void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 645 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_new_document (self);
#line 3268 "ui.c"
}


void user_interface_new_document_activate_cb (UserInterface* self) {
#line 648 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 650 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_new_document (self);
#line 3277 "ui.c"
}


static void user_interface_set_document_hint (UserInterface* self, const gchar* document_hint, gboolean save) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 653 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 653 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (document_hint != NULL);
#line 655 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = document_hint;
#line 655 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 655 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->document_hint);
#line 655 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->document_hint = _tmp1_;
#line 657 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = document_hint;
#line 657 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (g_strcmp0 (_tmp2_, "text") == 0) {
#line 3302 "ui.c"
		GtkRadioMenuItem* _tmp3_ = NULL;
		GtkRadioMenuItem* _tmp4_ = NULL;
#line 659 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->text_toolbar_menuitem;
#line 659 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp3_, TRUE);
#line 660 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->text_menu_menuitem;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp4_, TRUE);
#line 3313 "ui.c"
	} else {
		const gchar* _tmp5_ = NULL;
#line 662 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = document_hint;
#line 662 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (g_strcmp0 (_tmp5_, "photo") == 0) {
#line 3320 "ui.c"
			GtkRadioMenuItem* _tmp6_ = NULL;
			GtkRadioMenuItem* _tmp7_ = NULL;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp6_ = self->priv->photo_toolbar_menuitem;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp6_, TRUE);
#line 665 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp7_ = self->priv->photo_menu_menuitem;
#line 665 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp7_, TRUE);
#line 3331 "ui.c"
		}
	}
#line 668 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = save;
#line 668 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp8_) {
#line 3338 "ui.c"
		GSettings* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 669 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = self->priv->settings;
#line 669 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = document_hint;
#line 669 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_settings_set_string (_tmp9_, "document-type", _tmp10_);
#line 3347 "ui.c"
	}
}


void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 673 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 673 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 675 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 675 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 675 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 676 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_document_hint (self, "text", TRUE);
#line 3367 "ui.c"
	}
}


void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 680 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 680 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 682 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 682 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 682 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 684 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_document_hint (self, "photo", TRUE);
#line 3387 "ui.c"
	}
}


static void user_interface_set_page_side (UserInterface* self, ScanType page_side) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 692 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->page_side_model;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 692 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 3407 "ui.c"
		{
			gboolean _tmp3_ = FALSE;
#line 694 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp3_ = TRUE;
#line 694 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			while (TRUE) {
#line 3414 "ui.c"
				gboolean _tmp4_ = FALSE;
				gint s = 0;
				GtkListStore* _tmp7_ = NULL;
				GtkTreeIter _tmp8_ = {0};
				gint _tmp9_ = 0;
				ScanType _tmp10_ = 0;
#line 694 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp4_ = _tmp3_;
#line 694 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (!_tmp4_) {
#line 3425 "ui.c"
					GtkListStore* _tmp5_ = NULL;
					gboolean _tmp6_ = FALSE;
#line 703 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp5_ = self->priv->page_side_model;
#line 703 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter);
#line 703 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (!_tmp6_) {
#line 703 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						break;
#line 3436 "ui.c"
					}
				}
#line 694 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp3_ = FALSE;
#line 697 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp7_ = self->priv->page_side_model;
#line 697 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp8_ = iter;
#line 697 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, 0, &s, -1, -1);
#line 698 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp9_ = s;
#line 698 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp10_ = page_side;
#line 698 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp9_ == ((gint) _tmp10_)) {
#line 3453 "ui.c"
					GtkComboBox* _tmp11_ = NULL;
					GtkTreeIter _tmp12_ = {0};
#line 700 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp11_ = self->priv->page_side_combo;
#line 700 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp12_ = iter;
#line 700 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_combo_box_set_active_iter (_tmp11_, &_tmp12_);
#line 701 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					return;
#line 3464 "ui.c"
				}
			}
		}
	}
}


static void user_interface_set_paper_size (UserInterface* self, gint width, gint height) {
	GtkTreeIter iter = {0};
	gboolean have_iter = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp20_ = FALSE;
#line 707 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 3479 "ui.c"
	{
		GtkListStore* _tmp0_ = NULL;
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
#line 712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = self->priv->paper_size_model;
#line 712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		iter = _tmp1_;
#line 712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		have_iter = _tmp2_;
#line 712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = TRUE;
#line 712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		while (TRUE) {
#line 3497 "ui.c"
			gboolean _tmp4_ = FALSE;
			gboolean _tmp7_ = FALSE;
			gint w = 0;
			gint h = 0;
			GtkListStore* _tmp8_ = NULL;
			GtkTreeIter _tmp9_ = {0};
			gboolean _tmp10_ = FALSE;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gboolean _tmp15_ = FALSE;
#line 712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp4_ = _tmp3_;
#line 712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (!_tmp4_) {
#line 3512 "ui.c"
				GtkListStore* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
#line 714 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp5_ = self->priv->paper_size_model;
#line 714 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter);
#line 714 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				have_iter = _tmp6_;
#line 3521 "ui.c"
			}
#line 712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp3_ = FALSE;
#line 713 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp7_ = have_iter;
#line 713 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (!_tmp7_) {
#line 713 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				break;
#line 3531 "ui.c"
			}
#line 717 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp8_ = self->priv->paper_size_model;
#line 717 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp9_ = iter;
#line 717 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_tree_model_get ((GtkTreeModel*) _tmp8_, &_tmp9_, 0, &w, 1, &h, -1, -1);
#line 718 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp11_ = w;
#line 718 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp12_ = width;
#line 718 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (_tmp11_ == _tmp12_) {
#line 3545 "ui.c"
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
#line 718 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp13_ = h;
#line 718 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp14_ = height;
#line 718 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp10_ = _tmp13_ == _tmp14_;
#line 3554 "ui.c"
			} else {
#line 718 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp10_ = FALSE;
#line 3558 "ui.c"
			}
#line 718 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp15_ = _tmp10_;
#line 718 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (_tmp15_) {
#line 719 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				break;
#line 3566 "ui.c"
			}
		}
	}
#line 722 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = have_iter;
#line 722 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp16_) {
#line 3574 "ui.c"
		GtkListStore* _tmp17_ = NULL;
		GtkTreeIter _tmp18_ = {0};
		gboolean _tmp19_ = FALSE;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp17_ = self->priv->paper_size_model;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp19_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp17_, &_tmp18_);
#line 723 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		iter = _tmp18_;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		have_iter = _tmp19_;
#line 3586 "ui.c"
	}
#line 724 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = have_iter;
#line 724 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp20_) {
#line 3592 "ui.c"
		GtkComboBox* _tmp21_ = NULL;
		GtkTreeIter _tmp22_ = {0};
#line 725 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp21_ = self->priv->paper_size_combo;
#line 725 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp22_ = iter;
#line 725 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
#line 3601 "ui.c"
	}
}


static gint user_interface_get_text_dpi (UserInterface* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi = 0;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 728 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 731 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dpi = USER_INTERFACE_DEFAULT_TEXT_DPI;
#line 733 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->text_dpi_combo;
#line 733 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 733 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 733 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 3625 "ui.c"
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 734 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->text_dpi_model;
#line 734 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = iter;
#line 734 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
#line 3634 "ui.c"
	}
#line 736 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = dpi;
#line 736 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3640 "ui.c"
}


static gint user_interface_get_photo_dpi (UserInterface* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi = 0;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 739 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 742 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dpi = USER_INTERFACE_DEFAULT_PHOTO_DPI;
#line 744 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->photo_dpi_combo;
#line 744 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 744 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 744 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 3663 "ui.c"
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 745 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->photo_dpi_model;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = iter;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
#line 3672 "ui.c"
	}
#line 747 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = dpi;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3678 "ui.c"
}


static ScanType user_interface_get_page_side (UserInterface* self) {
	ScanType result = 0;
	GtkTreeIter iter = {0};
	gint page_side = 0;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint _tmp5_ = 0;
#line 750 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 753 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page_side = (gint) SCAN_TYPE_ADF_BOTH;
#line 755 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->page_side_combo;
#line 755 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 755 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 755 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 3702 "ui.c"
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 756 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->page_side_model;
#line 756 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = iter;
#line 756 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &page_side, -1, -1);
#line 3711 "ui.c"
	}
#line 758 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page_side;
#line 758 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = (ScanType) _tmp5_;
#line 758 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3719 "ui.c"
}


static gboolean user_interface_get_paper_size (UserInterface* self, gint* width, gint* height) {
	gint _vala_width = 0;
	gint _vala_height = 0;
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	gint _tmp0_ = 0;
	GtkComboBox* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
#line 761 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_height = 0;
#line 765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = _vala_height;
#line 765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_width = _tmp0_;
#line 766 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->paper_size_combo;
#line 766 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
#line 766 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp2_;
#line 766 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp3_) {
#line 3748 "ui.c"
		GtkListStore* _tmp4_ = NULL;
		GtkTreeIter _tmp5_ = {0};
#line 768 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->paper_size_model;
#line 768 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = iter;
#line 768 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, 0, &_vala_width, 1, &_vala_height, -1, -1);
#line 769 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = TRUE;
#line 769 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (width) {
#line 769 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			*width = _vala_width;
#line 3763 "ui.c"
		}
#line 769 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (height) {
#line 769 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			*height = _vala_height;
#line 3769 "ui.c"
		}
#line 769 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 3773 "ui.c"
	}
#line 772 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = FALSE;
#line 772 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (width) {
#line 772 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*width = _vala_width;
#line 3781 "ui.c"
	}
#line 772 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (height) {
#line 772 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*height = _vala_height;
#line 3787 "ui.c"
	}
#line 772 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3791 "ui.c"
}


static ScanOptions* user_interface_make_scan_options (UserInterface* self) {
	ScanOptions* result = NULL;
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ScanOptions* _tmp10_ = NULL;
	ScanOptions* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	ScanOptions* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	ScanOptions* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
#line 775 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 777 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = scan_options_new ();
#line 777 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	options = _tmp0_;
#line 778 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->document_hint;
#line 778 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (g_strcmp0 (_tmp1_, "text") == 0) {
#line 3820 "ui.c"
		ScanOptions* _tmp2_ = NULL;
		ScanOptions* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		ScanOptions* _tmp5_ = NULL;
#line 780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = options;
#line 780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_->scan_mode = SCAN_MODE_GRAY;
#line 781 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = options;
#line 781 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = user_interface_get_text_dpi (self);
#line 781 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_->dpi = _tmp4_;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = options;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_->depth = 2;
#line 3839 "ui.c"
	} else {
		ScanOptions* _tmp6_ = NULL;
		ScanOptions* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		ScanOptions* _tmp9_ = NULL;
#line 786 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = options;
#line 786 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_->scan_mode = SCAN_MODE_COLOR;
#line 787 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = options;
#line 787 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = user_interface_get_photo_dpi (self);
#line 787 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_->dpi = _tmp8_;
#line 788 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = options;
#line 788 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_->depth = 8;
#line 3859 "ui.c"
	}
#line 790 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = options;
#line 790 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = options;
#line 790 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_get_paper_size (self, &_tmp12_, &_tmp13_);
#line 790 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_->paper_width = _tmp12_;
#line 790 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_->paper_height = _tmp13_;
#line 791 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = options;
#line 791 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = user_interface_get_brightness (self);
#line 791 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = _tmp15_;
#line 791 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_->brightness = _tmp16_;
#line 792 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = options;
#line 792 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = user_interface_get_contrast (self);
#line 792 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = _tmp18_;
#line 792 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_->contrast = _tmp19_;
#line 794 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = options;
#line 794 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3891 "ui.c"
}


void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 798 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 798 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 800 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = user_interface_make_scan_options (self);
#line 800 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	options = _tmp0_;
#line 801 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	options->type = SCAN_TYPE_SINGLE;
#line 802 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_selected_device (self);
#line 802 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 802 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 802 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_emit_by_name (self, "start-scan", _tmp3_, options);
#line 802 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_tmp3_);
#line 798 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_scan_options_unref0 (options);
#line 3923 "ui.c"
}


void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 806 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 806 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 808 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_emit_by_name (self, "stop-scan");
#line 3934 "ui.c"
}


void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 812 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 812 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 814 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = user_interface_get_scanning (self);
#line 814 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _tmp0_;
#line 814 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 815 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_signal_emit_by_name (self, "stop-scan");
#line 3953 "ui.c"
	} else {
		ScanOptions* options = NULL;
		ScanOptions* _tmp2_ = NULL;
		ScanOptions* _tmp3_ = NULL;
		ScanType _tmp4_ = 0;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		ScanOptions* _tmp8_ = NULL;
#line 818 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = user_interface_make_scan_options (self);
#line 818 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		options = _tmp2_;
#line 819 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = options;
#line 819 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = user_interface_get_page_side (self);
#line 819 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_->type = _tmp4_;
#line 820 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = user_interface_get_selected_device (self);
#line 820 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = _tmp5_;
#line 820 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = _tmp6_;
#line 820 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = options;
#line 820 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_signal_emit_by_name (self, "start-scan", _tmp7_, _tmp8_);
#line 820 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_tmp7_);
#line 814 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_scan_options_unref0 (options);
#line 3987 "ui.c"
	}
}


void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	GtkDialog* _tmp0_ = NULL;
#line 825 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 825 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 827 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 827 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 4002 "ui.c"
}


void user_interface_preferences_activate_cb (UserInterface* self) {
	GtkDialog* _tmp0_ = NULL;
#line 830 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 832 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 832 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 4014 "ui.c"
}


gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, UserInterface* self) {
	gboolean result = FALSE;
#line 836 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 836 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 838 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = TRUE;
#line 838 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 4028 "ui.c"
}


void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, UserInterface* self) {
	GtkDialog* _tmp0_ = NULL;
#line 842 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 842 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 844 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 844 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 4042 "ui.c"
}


static gpointer _page_ref0 (gpointer self) {
#line 849 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self ? page_ref (self) : NULL;
#line 4049 "ui.c"
}


static void user_interface_update_page_menu (UserInterface* self) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
#line 847 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 849 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 849 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 849 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp3_;
#line 850 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page;
#line 850 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_ == NULL) {
#line 4076 "ui.c"
		GtkMenuItem* _tmp5_ = NULL;
		GtkMenuItem* _tmp6_ = NULL;
#line 852 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = self->priv->page_move_left_menuitem;
#line 852 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
#line 853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = self->priv->page_move_right_menuitem;
#line 853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
#line 4087 "ui.c"
	} else {
		guint index = 0U;
		Book* _tmp7_ = NULL;
		Page* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		GtkMenuItem* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		GtkMenuItem* _tmp12_ = NULL;
		guint _tmp13_ = 0U;
		Book* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		guint _tmp16_ = 0U;
#line 857 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = self->priv->_book;
#line 857 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = page;
#line 857 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = book_get_page_index (_tmp7_, _tmp8_);
#line 857 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		index = _tmp9_;
#line 858 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = self->priv->page_move_left_menuitem;
#line 858 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp11_ = index;
#line 858 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, _tmp11_ > ((guint) 0));
#line 859 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp12_ = self->priv->page_move_right_menuitem;
#line 859 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp13_ = index;
#line 859 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp14_ = self->priv->_book;
#line 859 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = book_get_n_pages (_tmp14_);
#line 859 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp16_ = _tmp15_;
#line 859 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, _tmp13_ < (_tmp16_ - 1));
#line 4126 "ui.c"
	}
#line 847 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 4130 "ui.c"
}


static void user_interface_page_selected_cb (UserInterface* self, BookView* view, Page* page) {
	Page* _tmp0_ = NULL;
	gchar* name = NULL;
	gchar* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GtkRadioMenuItem* menuitem = NULL;
	GtkBuilder* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	GObject* _tmp25_ = NULL;
	GtkRadioMenuItem* _tmp26_ = NULL;
	GtkRadioMenuItem* _tmp27_ = NULL;
	GtkToggleToolButton* toolbutton = NULL;
	GtkBuilder* _tmp28_ = NULL;
	GObject* _tmp29_ = NULL;
	GtkToggleToolButton* _tmp30_ = NULL;
	GtkToggleToolButton* _tmp31_ = NULL;
	Page* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
#line 863 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 863 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 865 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = page;
#line 865 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_ == NULL) {
#line 866 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4165 "ui.c"
	}
#line 868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->updating_page_menu = TRUE;
#line 870 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_page_menu (self);
#line 872 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_strdup ("no_crop_menuitem");
#line 872 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	name = _tmp1_;
#line 873 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = page;
#line 873 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = page_get_has_crop (_tmp2_);
#line 873 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = _tmp3_;
#line 873 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_) {
#line 4183 "ui.c"
		gchar* crop_name = NULL;
		Page* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = page;
#line 876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = page_get_crop_name (_tmp5_);
#line 876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = _tmp6_;
#line 876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		crop_name = _tmp8_;
#line 877 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = crop_name;
#line 877 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp9_ != NULL) {
#line 4204 "ui.c"
			const gchar* _tmp10_ = NULL;
#line 879 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp10_ = crop_name;
#line 879 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (g_strcmp0 (_tmp10_, "A4") == 0) {
#line 4210 "ui.c"
				gchar* _tmp11_ = NULL;
#line 880 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp11_ = g_strdup ("a4_menuitem");
#line 880 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_free0 (name);
#line 880 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				name = _tmp11_;
#line 4218 "ui.c"
			} else {
				const gchar* _tmp12_ = NULL;
#line 881 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp12_ = crop_name;
#line 881 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (g_strcmp0 (_tmp12_, "A5") == 0) {
#line 4225 "ui.c"
					gchar* _tmp13_ = NULL;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp13_ = g_strdup ("a5_menuitem");
#line 882 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_g_free0 (name);
#line 882 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					name = _tmp13_;
#line 4233 "ui.c"
				} else {
					const gchar* _tmp14_ = NULL;
#line 883 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp14_ = crop_name;
#line 883 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (g_strcmp0 (_tmp14_, "A6") == 0) {
#line 4240 "ui.c"
						gchar* _tmp15_ = NULL;
#line 884 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp15_ = g_strdup ("a6_menuitem");
#line 884 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_g_free0 (name);
#line 884 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						name = _tmp15_;
#line 4248 "ui.c"
					} else {
						const gchar* _tmp16_ = NULL;
#line 885 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp16_ = crop_name;
#line 885 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						if (g_strcmp0 (_tmp16_, "letter") == 0) {
#line 4255 "ui.c"
							gchar* _tmp17_ = NULL;
#line 886 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp17_ = g_strdup ("letter_menuitem");
#line 886 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_g_free0 (name);
#line 886 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							name = _tmp17_;
#line 4263 "ui.c"
						} else {
							const gchar* _tmp18_ = NULL;
#line 887 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp18_ = crop_name;
#line 887 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							if (g_strcmp0 (_tmp18_, "legal") == 0) {
#line 4270 "ui.c"
								gchar* _tmp19_ = NULL;
#line 888 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp19_ = g_strdup ("legal_menuitem");
#line 888 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_g_free0 (name);
#line 888 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								name = _tmp19_;
#line 4278 "ui.c"
							} else {
								const gchar* _tmp20_ = NULL;
#line 889 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp20_ = crop_name;
#line 889 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								if (g_strcmp0 (_tmp20_, "4x6") == 0) {
#line 4285 "ui.c"
									gchar* _tmp21_ = NULL;
#line 890 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
									_tmp21_ = g_strdup ("4x6_menuitem");
#line 890 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
									_g_free0 (name);
#line 890 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
									name = _tmp21_;
#line 4293 "ui.c"
								}
							}
						}
					}
				}
			}
		} else {
			gchar* _tmp22_ = NULL;
#line 893 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp22_ = g_strdup ("custom_crop_menuitem");
#line 893 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (name);
#line 893 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			name = _tmp22_;
#line 4308 "ui.c"
		}
#line 873 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (crop_name);
#line 4312 "ui.c"
	}
#line 896 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = self->priv->builder;
#line 896 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = name;
#line 896 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = gtk_builder_get_object (_tmp23_, _tmp24_);
#line 896 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 896 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	menuitem = _tmp26_;
#line 897 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = menuitem;
#line 897 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp27_, TRUE);
#line 898 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp28_ = self->priv->builder;
#line 898 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp29_ = gtk_builder_get_object (_tmp28_, "crop_toolbutton");
#line 898 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GTK_TYPE_TOGGLE_TOOL_BUTTON, GtkToggleToolButton));
#line 898 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	toolbutton = _tmp30_;
#line 899 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp31_ = toolbutton;
#line 899 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp32_ = page;
#line 899 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp33_ = page_get_has_crop (_tmp32_);
#line 899 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp34_ = _tmp33_;
#line 899 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_toggle_tool_button_set_active (_tmp31_, _tmp34_);
#line 901 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->updating_page_menu = FALSE;
#line 863 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (toolbutton);
#line 863 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (menuitem);
#line 863 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (name);
#line 4354 "ui.c"
}


static void user_interface_show_page_cb (UserInterface* self, BookView* view, Page* page) {
	gchar* path = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* file = NULL;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 904 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 904 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 904 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 906 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = get_temporary_filename ("scanned-page", "tiff");
#line 906 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	path = _tmp0_;
#line 907 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = path;
#line 907 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_ == NULL) {
#line 908 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 908 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4384 "ui.c"
	}
#line 909 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = path;
#line 909 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = g_file_new_for_path (_tmp2_);
#line 909 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	file = _tmp3_;
#line 4392 "ui.c"
	{
		Page* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		GFile* _tmp7_ = NULL;
#line 913 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = page;
#line 913 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = user_interface_get_quality (self);
#line 913 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = _tmp5_;
#line 913 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = file;
#line 913 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		page_save (_tmp4_, "tiff", _tmp6_, _tmp7_, &_inner_error_);
#line 913 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 4410 "ui.c"
			goto __catch17_g_error;
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 917 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = _ ("Unable to save image for preview");
#line 917 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = e;
#line 917 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = _tmp9_->message;
#line 917 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp8_, _tmp10_);
#line 920 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 920 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (file);
#line 920 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 920 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4441 "ui.c"
	}
	__finally17:
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (file);
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4456 "ui.c"
	}
	{
		GtkApplicationWindow* _tmp11_ = NULL;
		GdkScreen* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		guint32 _tmp16_ = 0U;
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp11_ = self->priv->window;
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp12_ = gtk_window_get_screen ((GtkWindow*) _tmp11_);
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp13_ = file;
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp14_ = g_file_get_uri (_tmp13_);
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = _tmp14_;
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp16_ = gtk_get_current_event_time ();
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_show_uri (_tmp12_, _tmp15_, _tmp16_, &_inner_error_);
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_tmp15_);
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 4483 "ui.c"
			goto __catch18_g_error;
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 923 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 923 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 929 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp17_ = _ ("Unable to open image preview application");
#line 929 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp18_ = e;
#line 929 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp19_ = _tmp18_->message;
#line 929 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp17_, _tmp19_);
#line 923 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 4508 "ui.c"
	}
	__finally18:
#line 923 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 923 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (file);
#line 923 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 923 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 923 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 923 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4523 "ui.c"
	}
#line 904 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (file);
#line 904 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (path);
#line 4529 "ui.c"
}


static void user_interface_show_page_menu_cb (UserInterface* self, BookView* view) {
	GtkMenu* menu = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkMenu* _tmp2_ = NULL;
	guint32 _tmp3_ = 0U;
#line 935 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 935 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 937 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->builder;
#line 937 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_builder_get_object (_tmp0_, "page_menu");
#line 937 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_MENU, GtkMenu));
#line 937 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	menu = _tmp2_;
#line 938 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = gtk_get_current_event_time ();
#line 938 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_menu_popup (menu, NULL, NULL, NULL, NULL, (guint) 3, _tmp3_);
#line 935 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (menu);
#line 4557 "ui.c"
}


void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_ = FALSE;
	Page* page = NULL;
	BookView* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 942 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 942 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 944 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 944 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 945 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4579 "ui.c"
	}
#line 946 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->book_view;
#line 946 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = book_view_get_selected_page (_tmp1_);
#line 946 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 946 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = _page_ref0 (_tmp3_);
#line 946 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp4_;
#line 947 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page;
#line 947 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp5_ != NULL) {
#line 4595 "ui.c"
		Page* _tmp6_ = NULL;
#line 948 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = page;
#line 948 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		page_rotate_left (_tmp6_);
#line 4601 "ui.c"
	}
#line 942 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 4605 "ui.c"
}


void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_ = FALSE;
	Page* page = NULL;
	BookView* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 952 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 952 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 955 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4627 "ui.c"
	}
#line 956 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->book_view;
#line 956 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = book_view_get_selected_page (_tmp1_);
#line 956 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 956 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = _page_ref0 (_tmp3_);
#line 956 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp4_;
#line 957 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page;
#line 957 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp5_ != NULL) {
#line 4643 "ui.c"
		Page* _tmp6_ = NULL;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = page;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		page_rotate_right (_tmp6_);
#line 4649 "ui.c"
	}
#line 952 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 4653 "ui.c"
}


static void user_interface_set_crop (UserInterface* self, const gchar* crop_name) {
	GtkMenuItem* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Page* page = NULL;
	BookView* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
	Page* _tmp6_ = NULL;
	Page* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 961 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 963 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->crop_rotate_menuitem;
#line 963 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = crop_name;
#line 963 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_ != NULL);
#line 965 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->updating_page_menu;
#line 965 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 966 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4682 "ui.c"
	}
#line 968 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->book_view;
#line 968 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = book_view_get_selected_page (_tmp3_);
#line 968 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 968 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = _page_ref0 (_tmp5_);
#line 968 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp6_;
#line 969 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = page;
#line 969 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp7_ == NULL) {
#line 971 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_warning ("ui.vala:971: Trying to set crop but no selected page");
#line 972 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_page_unref0 (page);
#line 972 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4704 "ui.c"
	}
#line 975 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = crop_name;
#line 975 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp8_ == NULL) {
#line 4710 "ui.c"
		Page* _tmp9_ = NULL;
#line 976 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = page;
#line 976 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		page_set_no_crop (_tmp9_);
#line 4716 "ui.c"
	} else {
		const gchar* _tmp10_ = NULL;
#line 977 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = crop_name;
#line 977 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (g_strcmp0 (_tmp10_, "custom") == 0) {
#line 4723 "ui.c"
			gint width = 0;
			Page* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint height = 0;
			Page* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint crop_width = 0;
			gint _tmp17_ = 0;
			gint crop_height = 0;
			gint _tmp18_ = 0;
			Page* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			Page* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
#line 979 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp11_ = page;
#line 979 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp12_ = page_get_width (_tmp11_);
#line 979 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp13_ = _tmp12_;
#line 979 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			width = _tmp13_;
#line 980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp14_ = page;
#line 980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp15_ = page_get_height (_tmp14_);
#line 980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp16_ = _tmp15_;
#line 980 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			height = _tmp16_;
#line 981 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp17_ = width;
#line 981 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			crop_width = (gint) ((_tmp17_ * 0.8) + 0.5);
#line 982 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp18_ = height;
#line 982 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			crop_height = (gint) ((_tmp18_ * 0.8) + 0.5);
#line 983 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp19_ = page;
#line 983 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp20_ = crop_width;
#line 983 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp21_ = crop_height;
#line 983 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			page_set_custom_crop (_tmp19_, _tmp20_, _tmp21_);
#line 984 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp22_ = page;
#line 984 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp23_ = width;
#line 984 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp24_ = crop_width;
#line 984 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp25_ = height;
#line 984 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp26_ = crop_height;
#line 984 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			page_move_crop (_tmp22_, (_tmp23_ - _tmp24_) / 2, (_tmp25_ - _tmp26_) / 2);
#line 4788 "ui.c"
		} else {
			Page* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp27_ = page;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp28_ = crop_name;
#line 987 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			page_set_named_crop (_tmp27_, _tmp28_);
#line 4798 "ui.c"
		}
	}
#line 961 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 4803 "ui.c"
}


void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 991 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 993 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 993 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 993 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 994 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, NULL);
#line 4822 "ui.c"
	}
}


void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 998 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 998 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1000 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 1000 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1000 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 1001 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "custom");
#line 4842 "ui.c"
	}
}


void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, UserInterface* self) {
	gboolean _tmp0_ = FALSE;
	GtkRadioMenuItem* menuitem = NULL;
	GtkToggleToolButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkRadioMenuItem* _tmp9_ = NULL;
#line 1005 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1005 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1007 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 1007 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 1008 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4863 "ui.c"
	}
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = widget;
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_toggle_tool_button_get_active (_tmp1_);
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 4871 "ui.c"
		GtkBuilder* _tmp3_ = NULL;
		GObject* _tmp4_ = NULL;
		GtkRadioMenuItem* _tmp5_ = NULL;
#line 1012 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->builder;
#line 1012 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = gtk_builder_get_object (_tmp3_, "custom_crop_menuitem");
#line 1012 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1012 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (menuitem);
#line 1012 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		menuitem = _tmp5_;
#line 4885 "ui.c"
	} else {
		GtkBuilder* _tmp6_ = NULL;
		GObject* _tmp7_ = NULL;
		GtkRadioMenuItem* _tmp8_ = NULL;
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = self->priv->builder;
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = gtk_builder_get_object (_tmp6_, "no_crop_menuitem");
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (menuitem);
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		menuitem = _tmp8_;
#line 4900 "ui.c"
	}
#line 1015 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = menuitem;
#line 1015 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp9_, TRUE);
#line 1005 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (menuitem);
#line 4908 "ui.c"
}


void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1019 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1019 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1021 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 1021 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1021 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 1022 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "4x6");
#line 4927 "ui.c"
	}
}


void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1026 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1026 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1028 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 1028 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1028 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 1029 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "legal");
#line 4947 "ui.c"
	}
}


void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1033 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1035 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 1035 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1035 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 1036 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "letter");
#line 4967 "ui.c"
	}
}


void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1040 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1040 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1042 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 1042 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1042 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "A6");
#line 4987 "ui.c"
	}
}


void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1047 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1047 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1049 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 1049 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1049 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "A5");
#line 5007 "ui.c"
	}
}


void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1054 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1054 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1056 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 1056 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1056 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 1057 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "A4");
#line 5027 "ui.c"
	}
}


void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 1061 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1061 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp3_;
#line 1064 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page;
#line 1064 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_ == NULL) {
#line 1065 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_page_unref0 (page);
#line 1065 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 5062 "ui.c"
	}
#line 1066 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page;
#line 1066 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page_rotate_crop (_tmp5_);
#line 1061 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 5070 "ui.c"
}


void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	guint index = 0U;
	Book* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
#line 1070 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1070 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp3_;
#line 1073 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->_book;
#line 1073 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page;
#line 1073 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = book_get_page_index (_tmp4_, _tmp5_);
#line 1073 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	index = _tmp6_;
#line 1074 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = index;
#line 1074 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp7_ > ((guint) 0)) {
#line 5111 "ui.c"
		Book* _tmp8_ = NULL;
		Page* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
#line 1075 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = self->priv->_book;
#line 1075 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = page;
#line 1075 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = index;
#line 1075 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		book_move_page (_tmp8_, _tmp9_, _tmp10_ - 1);
#line 5123 "ui.c"
	}
#line 1077 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_page_menu (self);
#line 1070 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 5129 "ui.c"
}


void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	guint index = 0U;
	Book* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	Book* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
#line 1081 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1081 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1083 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1083 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 1083 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1083 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 1083 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp3_;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->_book;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = book_get_page_index (_tmp4_, _tmp5_);
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	index = _tmp6_;
#line 1085 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = index;
#line 1085 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = self->priv->_book;
#line 1085 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = book_get_n_pages (_tmp8_);
#line 1085 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = _tmp9_;
#line 1085 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp7_ < (_tmp10_ - 1)) {
#line 5179 "ui.c"
		Book* _tmp11_ = NULL;
		Page* _tmp12_ = NULL;
		Book* _tmp13_ = NULL;
		Page* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
#line 1086 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp11_ = self->priv->_book;
#line 1086 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp12_ = page;
#line 1086 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp13_ = self->priv->_book;
#line 1086 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp14_ = page;
#line 1086 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = book_get_page_index (_tmp13_, _tmp14_);
#line 1086 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		book_move_page (_tmp11_, _tmp12_, _tmp15_ + 1);
#line 5197 "ui.c"
	}
#line 1088 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_page_menu (self);
#line 1081 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 5203 "ui.c"
}


void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	Book* _tmp2_ = NULL;
	BookView* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 1092 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1092 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_book (_tmp0_);
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->book_view;
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = book_view_get_selected_page (_tmp3_);
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_delete_page (_tmp2_, _tmp5_);
#line 5232 "ui.c"
}


void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 1098 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1098 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1100 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_document (self, FALSE);
#line 5243 "ui.c"
}


void user_interface_save_document_activate_cb (UserInterface* self) {
#line 1103 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1105 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_document (self, FALSE);
#line 5252 "ui.c"
}


void G_MODULE_EXPORT copy_to_clipboard_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
#line 1109 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1109 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp3_;
#line 1112 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page;
#line 1112 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_ != NULL) {
#line 5281 "ui.c"
		Page* _tmp5_ = NULL;
		GtkApplicationWindow* _tmp6_ = NULL;
#line 1113 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = page;
#line 1113 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = self->priv->window;
#line 1113 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		page_copy_to_clipboard (_tmp5_, (GtkWindow*) _tmp6_);
#line 5290 "ui.c"
	}
#line 1109 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 5294 "ui.c"
}


void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 1117 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1117 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1119 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_document (self, TRUE);
#line 5305 "ui.c"
}


void user_interface_save_as_document_activate_cb (UserInterface* self) {
#line 1122 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1124 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_document (self, TRUE);
#line 5314 "ui.c"
}


static gpointer _cairo_reference0 (gpointer self) {
#line 1131 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self ? cairo_reference (self) : NULL;
#line 5321 "ui.c"
}


static void user_interface_draw_page (UserInterface* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number) {
	cairo_t* context = NULL;
	GtkPrintContext* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	Page* page = NULL;
	Book* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Page* _tmp5_ = NULL;
	gboolean is_landscape = FALSE;
	GtkPrintContext* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	GtkPrintContext* _tmp8_ = NULL;
	gdouble _tmp9_ = 0.0;
	Page* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	cairo_t* _tmp18_ = NULL;
	GtkPrintContext* _tmp19_ = NULL;
	gdouble _tmp20_ = 0.0;
	Page* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	GtkPrintContext* _tmp24_ = NULL;
	gdouble _tmp25_ = 0.0;
	Page* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GdkPixbuf* image = NULL;
	Page* _tmp29_ = NULL;
	GdkPixbuf* _tmp30_ = NULL;
	cairo_t* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (operation != NULL);
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (print_context != NULL);
#line 1131 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = print_context;
#line 1131 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
#line 1131 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _cairo_reference0 (_tmp1_);
#line 1131 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	context = _tmp2_;
#line 1132 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->_book;
#line 1132 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page_number;
#line 1132 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = book_get_page (_tmp3_, _tmp4_);
#line 1132 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp5_;
#line 1135 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	is_landscape = FALSE;
#line 1136 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = print_context;
#line 1136 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = gtk_print_context_get_width (_tmp6_);
#line 1136 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = print_context;
#line 1136 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = gtk_print_context_get_height (_tmp8_);
#line 1136 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp7_ > _tmp9_) {
#line 1137 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		is_landscape = TRUE;
#line 5395 "ui.c"
	}
#line 1138 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = page;
#line 1138 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = page_get_is_landscape (_tmp10_);
#line 1138 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = _tmp11_;
#line 1138 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = is_landscape;
#line 1138 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp12_ != _tmp13_) {
#line 5407 "ui.c"
		cairo_t* _tmp14_ = NULL;
		GtkPrintContext* _tmp15_ = NULL;
		gdouble _tmp16_ = 0.0;
		cairo_t* _tmp17_ = NULL;
#line 1140 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp14_ = context;
#line 1140 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = print_context;
#line 1140 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp16_ = gtk_print_context_get_width (_tmp15_);
#line 1140 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		cairo_translate (_tmp14_, _tmp16_, (gdouble) 0);
#line 1141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp17_ = context;
#line 1141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		cairo_rotate (_tmp17_, G_PI_2);
#line 5424 "ui.c"
	}
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = context;
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = print_context;
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = gtk_print_context_get_dpi_x (_tmp19_);
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = page;
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = page_get_dpi (_tmp21_);
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = _tmp22_;
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = print_context;
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = gtk_print_context_get_dpi_y (_tmp24_);
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp26_ = page;
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = page_get_dpi (_tmp26_);
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp28_ = _tmp27_;
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_scale (_tmp18_, _tmp20_ / _tmp23_, _tmp25_ / _tmp28_);
#line 1147 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp29_ = page;
#line 1147 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp30_ = page_get_image (_tmp29_, TRUE);
#line 1147 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	image = _tmp30_;
#line 1148 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp31_ = context;
#line 1148 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gdk_cairo_set_source_pixbuf (_tmp31_, image, (gdouble) 0, (gdouble) 0);
#line 1149 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp32_ = context;
#line 1149 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_paint (_tmp32_);
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (image);
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_cairo_destroy0 (context);
#line 5470 "ui.c"
}


void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1155 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->document_hint;
#line 1155 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_quality (self);
#line 1155 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1155 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_emit_by_name (self, "email", _tmp0_, _tmp2_);
#line 5490 "ui.c"
}


void user_interface_email_document_activate_cb (UserInterface* self) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1158 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1160 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->document_hint;
#line 1160 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_quality (self);
#line 1160 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1160 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_emit_by_name (self, "email", _tmp0_, _tmp2_);
#line 5508 "ui.c"
}


static void _user_interface_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
#line 1167 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_draw_page (self, _sender, context, page_nr);
#line 5515 "ui.c"
}


static void user_interface_print_document (UserInterface* self) {
	GtkPrintOperation* print = NULL;
	GtkPrintOperation* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp7_ = 0U;
	GError * _inner_error_ = NULL;
#line 1163 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1165 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = gtk_print_operation_new ();
#line 1165 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	print = _tmp0_;
#line 1166 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->_book;
#line 1166 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 1166 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1166 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_print_operation_set_n_pages (print, (gint) _tmp3_);
#line 1167 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (print, "draw-page", (GCallback) _user_interface_draw_page_gtk_print_operation_draw_page, self);
#line 5543 "ui.c"
	{
		GtkApplicationWindow* _tmp4_ = NULL;
#line 1171 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->window;
#line 1171 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_print_operation_run (print, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, (GtkWindow*) _tmp4_, &_inner_error_);
#line 1171 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 5552 "ui.c"
			goto __catch19_g_error;
		}
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 1169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 1169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1175 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = e;
#line 1175 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = _tmp5_->message;
#line 1175 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_warning ("ui.vala:1175: Error printing: %s", _tmp6_);
#line 1169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 5574 "ui.c"
	}
	__finally19:
#line 1169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (print);
#line 1169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 5587 "ui.c"
	}
#line 1178 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("draw-page", GTK_TYPE_PRINT_OPERATION, &_tmp7_, NULL, FALSE);
#line 1178 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (print, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _user_interface_draw_page_gtk_print_operation_draw_page, self);
#line 1163 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (print);
#line 5595 "ui.c"
}


void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 1182 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1182 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1184 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_print_document (self);
#line 5606 "ui.c"
}


void user_interface_print_document_activate_cb (UserInterface* self) {
#line 1187 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1189 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_print_document (self);
#line 5615 "ui.c"
}


static void user_interface_show_help (UserInterface* self) {
	GError * _inner_error_ = NULL;
#line 1192 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 5623 "ui.c"
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 1196 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = self->priv->window;
#line 1196 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 1196 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 1196 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_show_uri (_tmp1_, "help:simple-scan", _tmp2_, &_inner_error_);
#line 1196 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 5638 "ui.c"
			goto __catch20_g_error;
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 1194 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 1194 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1200 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = _ ("Unable to open help file");
#line 1200 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = e;
#line 1200 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = _tmp4_->message;
#line 1200 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp3_, _tmp5_);
#line 1194 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 5663 "ui.c"
	}
	__finally20:
#line 1194 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1194 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1194 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1194 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 5674 "ui.c"
	}
}


void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
#line 1207 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1207 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1209 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_show_help (self);
#line 5686 "ui.c"
}


void user_interface_help_contents_activate_cb (UserInterface* self) {
#line 1212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1214 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_show_help (self);
#line 5695 "ui.c"
}


static void user_interface_show_about (UserInterface* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar* license = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* title = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* description = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GtkApplicationWindow* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
#line 1217 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1219 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = g_strdup ("Robert Ancell <robert.ancell@canonical.com>");
#line 1219 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 1219 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_[0] = _tmp0_;
#line 1219 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	authors = _tmp1_;
#line 1219 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	authors_length1 = 1;
#line 1219 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_authors_size_ = authors_length1;
#line 1222 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _ ("This program is free software: you can redistribute it and/or modify\n" \
"it under the terms of the GNU General Public License as published by\n" \
"the Free Software Foundation, either version 3 of the License, or\n" \
"(at your option) any later version.\n" \
"\n" \
"This program is distributed in the hope that it will be useful,\n" \
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
"GNU General Public License for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License\n" \
"along with this program.  If not, see <http://www.gnu.org/licenses/>.");
#line 1222 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 1222 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	license = _tmp3_;
#line 1225 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = _ ("About Simple Scan");
#line 1225 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 1225 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	title = _tmp5_;
#line 1228 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = _ ("Simple document scanning tool");
#line 1228 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 1228 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	description = _tmp7_;
#line 1230 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = self->priv->window;
#line 1230 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = _ ("translator-credits");
#line 1230 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp8_, "title", title, "program-name", "Simple Scan", "version", VERSION, "comments", description, "logo-icon-name", "scanner", "authors", authors, "translator-credits", _tmp9_, "website", "https://launchpad.net/simple-scan", "copyright", "Copyright © 2009-2011 Canonical Ltd.", "license", license, "wrap-license", TRUE, NULL, NULL);
#line 1217 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (description);
#line 1217 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (title);
#line 1217 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (license);
#line 1217 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 5762 "ui.c"
}


void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
#line 1246 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1246 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1248 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_show_about (self);
#line 5773 "ui.c"
}


void user_interface_about_activate_cb (UserInterface* self) {
#line 1251 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1253 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_show_about (self);
#line 5782 "ui.c"
}


static gboolean user_interface_on_quit (UserInterface* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkApplicationWindow* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	AutosaveManager* _tmp5_ = NULL;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = _ ("Save document before quitting?");
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _ ("Quit without Saving");
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = user_interface_prompt_to_save (self, _tmp0_, _tmp1_);
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp2_) {
#line 1262 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = FALSE;
#line 1262 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 5808 "ui.c"
	}
#line 1264 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->window;
#line 1264 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
#line 1266 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->save_state_timeout;
#line 1266 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_ != ((guint) 0)) {
#line 1267 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_save_state (self, TRUE);
#line 5820 "ui.c"
	}
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = self->priv->autosave_manager;
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	autosave_manager_cleanup (_tmp5_);
#line 1271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = TRUE;
#line 1271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 5830 "ui.c"
}


void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
#line 1275 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1275 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1277 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_on_quit (self);
#line 5841 "ui.c"
}


void user_interface_quit_activate_cb (UserInterface* self) {
#line 1280 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1282 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_on_quit (self);
#line 5850 "ui.c"
}


gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, UserInterface* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1286 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1286 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1286 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1288 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->window_is_maximized;
#line 1288 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp0_) {
#line 5867 "ui.c"
		GdkEventConfigure _tmp1_ = {0};
		gint _tmp2_ = 0;
		GdkEventConfigure _tmp3_ = {0};
		gint _tmp4_ = 0;
#line 1290 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = *event;
#line 1290 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = _tmp1_.width;
#line 1290 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->window_width = _tmp2_;
#line 1291 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = *event;
#line 1291 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = _tmp3_.height;
#line 1291 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->window_height = _tmp4_;
#line 1292 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_save_state (self, FALSE);
#line 5886 "ui.c"
	}
#line 1295 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = FALSE;
#line 1295 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 5892 "ui.c"
}


static void user_interface_info_bar_response_cb (UserInterface* self, GtkInfoBar* widget, gint response_id) {
	gint _tmp0_ = 0;
#line 1298 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1298 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1300 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = response_id;
#line 1300 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_ == 1) {
#line 5906 "ui.c"
		GtkComboBox* _tmp1_ = NULL;
		GtkDialog* _tmp2_ = NULL;
#line 1302 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = self->priv->device_combo;
#line 1302 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
#line 1303 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = self->priv->preferences_dialog;
#line 1303 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_window_present ((GtkWindow*) _tmp2_);
#line 5917 "ui.c"
	} else {
#line 1307 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->have_error = FALSE;
#line 1308 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (self->priv->error_title);
#line 1308 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->error_title = NULL;
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (self->priv->error_text);
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->error_text = NULL;
#line 1310 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_update_info_bar (self);
#line 5931 "ui.c"
	}
}


gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, UserInterface* self) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_ = {0};
	GdkWindowState _tmp1_ = 0;
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1317 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = *event;
#line 1317 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _tmp0_.changed_mask;
#line 1317 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 5952 "ui.c"
		GdkEventWindowState _tmp2_ = {0};
		GdkWindowState _tmp3_ = 0;
#line 1319 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = *event;
#line 1319 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = _tmp2_.new_window_state;
#line 1319 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->window_is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1320 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_save_state (self, FALSE);
#line 5963 "ui.c"
	}
#line 1322 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = FALSE;
#line 1322 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 5969 "ui.c"
}


gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, UserInterface* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1326 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1326 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1326 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1328 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = user_interface_on_quit (self);
#line 1328 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = !_tmp0_;
#line 1328 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 5988 "ui.c"
}


static void user_interface_page_size_changed_cb (UserInterface* self, Page* page) {
	Page* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Page* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Page* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 1331 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1331 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1333 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = page;
#line 1333 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = page_get_width (_tmp0_);
#line 1333 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1333 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_width = _tmp2_;
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = page;
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page_get_height (_tmp3_);
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_height = _tmp5_;
#line 1335 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = page;
#line 1335 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = page_get_dpi (_tmp6_);
#line 1335 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = _tmp7_;
#line 1335 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_dpi = _tmp8_;
#line 1336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_state (self, FALSE);
#line 6032 "ui.c"
}


static void user_interface_page_scan_direction_changed_cb (UserInterface* self, Page* page) {
	Page* _tmp0_ = NULL;
	ScanDirection _tmp1_ = 0;
	ScanDirection _tmp2_ = 0;
#line 1339 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1339 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1341 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = page;
#line 1341 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = page_get_scan_direction (_tmp0_);
#line 1341 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1341 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_scan_direction = _tmp2_;
#line 1342 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_state (self, FALSE);
#line 6054 "ui.c"
}


static void _user_interface_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self) {
#line 1349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_size_changed_cb (self, _sender);
#line 6061 "ui.c"
}


static void _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self) {
#line 1350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_scan_direction_changed_cb (self, _sender);
#line 6068 "ui.c"
}


static void user_interface_page_added_cb (UserInterface* self, Book* book, Page* page) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	ScanDirection _tmp2_ = 0;
	ScanDirection _tmp3_ = 0;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 1345 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1345 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1345 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = page;
#line 1347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_size_changed_cb (self, _tmp0_);
#line 1348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = page;
#line 1348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = page_get_scan_direction (_tmp1_);
#line 1348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_scan_direction = _tmp3_;
#line 1349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page;
#line 1349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp4_, "size-changed", (GCallback) _user_interface_page_size_changed_cb_page_size_changed, self);
#line 1350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page;
#line 1350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp5_, "scan-direction-changed", (GCallback) _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 1352 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_page_menu (self);
#line 6107 "ui.c"
}


static void user_interface_page_removed_cb (UserInterface* self, Book* book, Page* page) {
	Page* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Book* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
#line 1355 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1355 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1355 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = page;
#line 1357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 1357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _user_interface_page_size_changed_cb_page_size_changed, self);
#line 1358 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = page;
#line 1358 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 1358 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 1361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = book;
#line 1361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = book_get_n_pages (_tmp4_);
#line 1361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = _tmp5_;
#line 1361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp6_ == ((guint) 1)) {
#line 1362 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_add_default_page (self);
#line 6147 "ui.c"
	}
#line 1364 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_page_menu (self);
#line 6151 "ui.c"
}


static void user_interface_set_dpi_combo (UserInterface* self, GtkComboBox* combo, gint default_dpi, gint current_dpi) {
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	GtkCellRendererText* _tmp2_ = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkCellRendererText* _tmp4_ = NULL;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkListStore* _tmp7_ = NULL;
	gint* scan_resolutions = NULL;
	gint* _tmp8_ = NULL;
	gint scan_resolutions_length1 = 0;
	gint _scan_resolutions_size_ = 0;
	gint* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (combo != NULL);
#line 1369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp0_);
#line 1369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	renderer = _tmp0_;
#line 1370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = combo;
#line 1370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = renderer;
#line 1370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp1_, (GtkCellRenderer*) _tmp2_, TRUE);
#line 1371 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = combo;
#line 1371 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = renderer;
#line 1371 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) _tmp4_, "text", 1);
#line 1373 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = combo;
#line 1373 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
#line 1373 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1373 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	model = _tmp7_;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = g_new0 (gint, 6);
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_[0] = 75;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_[1] = 150;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_[2] = 300;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_[3] = 600;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_[4] = 1200;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_[5] = 2400;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	scan_resolutions = _tmp8_;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	scan_resolutions_length1 = 6;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_scan_resolutions_size_ = scan_resolutions_length1;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = scan_resolutions;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9__length1 = scan_resolutions_length1;
#line 6226 "ui.c"
	{
		gint* dpi_collection = NULL;
		gint dpi_collection_length1 = 0;
		gint _dpi_collection_size_ = 0;
		gint dpi_it = 0;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dpi_collection = _tmp9_;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dpi_collection_length1 = _tmp9__length1;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		for (dpi_it = 0; dpi_it < _tmp9__length1; dpi_it = dpi_it + 1) {
#line 6238 "ui.c"
			gint dpi = 0;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			dpi = dpi_collection[dpi_it];
#line 6242 "ui.c"
			{
				gchar* label = NULL;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp26_ = NULL;
				GtkTreeIter _tmp27_ = {0};
				GtkListStore* _tmp28_ = NULL;
				GtkTreeIter _tmp29_ = {0};
				gint _tmp30_ = 0;
				const gchar* _tmp31_ = NULL;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
#line 1378 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp10_ = dpi;
#line 1378 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp11_ = default_dpi;
#line 1378 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp10_ == _tmp11_) {
#line 6262 "ui.c"
					const gchar* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					gchar* _tmp14_ = NULL;
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp12_ = _ ("%d dpi (default)");
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp13_ = dpi;
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp14_ = g_strdup_printf (_tmp12_, _tmp13_);
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_g_free0 (label);
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					label = _tmp14_;
#line 6276 "ui.c"
				} else {
					gint _tmp15_ = 0;
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp15_ = dpi;
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (_tmp15_ == 75) {
#line 6283 "ui.c"
						const gchar* _tmp16_ = NULL;
						gint _tmp17_ = 0;
						gchar* _tmp18_ = NULL;
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp16_ = _ ("%d dpi (draft)");
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp17_ = dpi;
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp18_ = g_strdup_printf (_tmp16_, _tmp17_);
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_g_free0 (label);
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						label = _tmp18_;
#line 6297 "ui.c"
					} else {
						gint _tmp19_ = 0;
#line 1384 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp19_ = dpi;
#line 1384 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						if (_tmp19_ == 1200) {
#line 6304 "ui.c"
							const gchar* _tmp20_ = NULL;
							gint _tmp21_ = 0;
							gchar* _tmp22_ = NULL;
#line 1386 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp20_ = _ ("%d dpi (high resolution)");
#line 1386 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp21_ = dpi;
#line 1386 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp22_ = g_strdup_printf (_tmp20_, _tmp21_);
#line 1386 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_g_free0 (label);
#line 1386 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							label = _tmp22_;
#line 6318 "ui.c"
						} else {
							const gchar* _tmp23_ = NULL;
							gint _tmp24_ = 0;
							gchar* _tmp25_ = NULL;
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp23_ = _ ("%d dpi");
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp24_ = dpi;
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp25_ = g_strdup_printf (_tmp23_, _tmp24_);
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_g_free0 (label);
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							label = _tmp25_;
#line 6333 "ui.c"
						}
					}
				}
#line 1392 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp26_ = model;
#line 1392 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_list_store_append (_tmp26_, &_tmp27_);
#line 1392 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				iter = _tmp27_;
#line 1393 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp28_ = model;
#line 1393 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp29_ = iter;
#line 1393 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp30_ = dpi;
#line 1393 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp31_ = label;
#line 1393 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_list_store_set (_tmp28_, &_tmp29_, 0, _tmp30_, 1, _tmp31_, -1, -1);
#line 1395 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp32_ = dpi;
#line 1395 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp33_ = current_dpi;
#line 1395 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp32_ == _tmp33_) {
#line 6359 "ui.c"
					GtkComboBox* _tmp34_ = NULL;
					GtkTreeIter _tmp35_ = {0};
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp34_ = combo;
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp35_ = iter;
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_combo_box_set_active_iter (_tmp34_, &_tmp35_);
#line 6368 "ui.c"
				}
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_free0 (label);
#line 6372 "ui.c"
			}
		}
	}
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	scan_resolutions = (g_free (scan_resolutions), NULL);
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (model);
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (renderer);
#line 6382 "ui.c"
}


static void user_interface_needs_saving_cb (UserInterface* self, Book* book) {
	GtkMenuItem* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkToolButton* _tmp4_ = NULL;
	Book* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	Book* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GtkMenuItem* _tmp12_ = NULL;
#line 1400 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1400 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->save_menuitem;
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book;
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = book_get_needs_saving (_tmp1_);
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp3_);
#line 1403 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->save_toolbutton;
#line 1403 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = book;
#line 1403 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = book_get_needs_saving (_tmp5_);
#line 1403 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = _tmp6_;
#line 1403 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, _tmp7_);
#line 1404 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = book;
#line 1404 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = book_get_needs_saving (_tmp8_);
#line 1404 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = _tmp9_;
#line 1404 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp10_) {
#line 6431 "ui.c"
		GtkMenuItem* _tmp11_ = NULL;
#line 1405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp11_ = self->priv->save_as_menuitem;
#line 1405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, TRUE);
#line 6437 "ui.c"
	}
#line 1406 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = self->priv->copy_to_clipboard_menuitem;
#line 1406 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, TRUE);
#line 6443 "ui.c"
}


static gboolean user_interface_has_app_menu (UserInterface* self, GtkApplication* app) {
	gboolean result = FALSE;
	GtkSettings* gtk_settings = NULL;
	GtkSettings* _tmp0_ = NULL;
	GtkSettings* _tmp1_ = NULL;
	gboolean show_app_menu = FALSE;
	gboolean show_menubar = FALSE;
	GtkSettings* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
#line 1409 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1409 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (app != NULL, FALSE);
#line 1416 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = gtk_settings_get_default ();
#line 1416 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 1416 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_settings = _tmp1_;
#line 1418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	show_app_menu = FALSE;
#line 1419 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	show_menubar = TRUE;
#line 1420 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_settings;
#line 1420 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_get ((GObject*) _tmp2_, "gtk-shell-shows-app-menu", &show_app_menu, "gtk-shell-shows-menubar", &show_menubar, NULL, NULL);
#line 1422 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = show_app_menu;
#line 1422 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_) {
#line 6480 "ui.c"
		gboolean _tmp5_ = FALSE;
#line 1422 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = show_menubar;
#line 1422 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = !_tmp5_;
#line 6486 "ui.c"
	} else {
#line 1422 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = FALSE;
#line 6490 "ui.c"
	}
#line 1422 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = _tmp3_;
#line 1422 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = _tmp6_;
#line 1422 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (gtk_settings);
#line 1422 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 6500 "ui.c"
}


static void _user_interface_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
#line 1503 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_info_bar_response_cb (self, _sender, response_id);
#line 6507 "ui.c"
}


static void __lambda4_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 1545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_text_dpi (self);
#line 1545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp0_, "text-dpi", _tmp1_);
#line 6520 "ui.c"
}


static void ___lambda4__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 1545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda4_ (self);
#line 6527 "ui.c"
}


static void __lambda5_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 1550 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1550 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_photo_dpi (self);
#line 1550 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp0_, "photo-dpi", _tmp1_);
#line 6540 "ui.c"
}


static void ___lambda5__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 1550 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda5_ (self);
#line 6547 "ui.c"
}


static void __lambda6_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	ScanType _tmp1_ = 0;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_page_side (self);
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_enum (_tmp0_, "page-side", (gint) _tmp1_);
#line 6560 "ui.c"
}


static void ___lambda6__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda6_ (self);
#line 6567 "ui.c"
}


static void __lambda7_ (UserInterface* self) {
	gint w = 0;
	gint h = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_get_paper_size (self, &_tmp0_, &_tmp1_);
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	w = _tmp0_;
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	h = _tmp1_;
#line 1572 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->settings;
#line 1572 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp2_, "paper-width", w);
#line 1573 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->settings;
#line 1573 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp3_, "paper-height", h);
#line 6592 "ui.c"
}


static void ___lambda7__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 1568 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda7_ (self);
#line 6599 "ui.c"
}


static void __lambda8_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_brightness (self);
#line 1584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp0_, "brightness", _tmp2_);
#line 6615 "ui.c"
}


static void ___lambda8__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 1584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda8_ (self);
#line 6622 "ui.c"
}


static void __lambda9_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1594 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1594 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_contrast (self);
#line 1594 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1594 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp0_, "contrast", _tmp2_);
#line 6638 "ui.c"
}


static void ___lambda9__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 1594 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda9_ (self);
#line 6645 "ui.c"
}


static void __lambda10_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_quality (self);
#line 1604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp0_, "jpeg-quality", _tmp2_);
#line 6661 "ui.c"
}


static void ___lambda10__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 1604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	__lambda10_ (self);
#line 6668 "ui.c"
}


static void _user_interface_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self) {
#line 1620 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_selected_cb (self, _sender, page);
#line 6675 "ui.c"
}


static void _user_interface_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self) {
#line 1621 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_show_page_cb (self, _sender, page);
#line 6682 "ui.c"
}


static void _user_interface_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self) {
#line 1622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_show_page_menu_cb (self, _sender);
#line 6689 "ui.c"
}


static void _user_interface_book_saving_cb_book_saving (Book* _sender, gint i, gpointer self) {
#line 1638 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_book_saving_cb (self, i);
#line 6696 "ui.c"
}


static void user_interface_load (UserInterface* self) {
	GtkIconTheme* _tmp0_ = NULL;
	GtkApplication* app = NULL;
	GApplication* _tmp1_ = NULL;
	GtkApplication* _tmp2_ = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GtkBuilder* _tmp12_ = NULL;
	GtkBuilder* _tmp13_ = NULL;
	GObject* _tmp14_ = NULL;
	GtkApplicationWindow* _tmp15_ = NULL;
	GtkApplication* _tmp16_ = NULL;
	GtkApplicationWindow* _tmp17_ = NULL;
	GtkBuilder* _tmp18_ = NULL;
	GObject* _tmp19_ = NULL;
	GtkMenuBar* _tmp20_ = NULL;
	GtkApplication* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GtkBuilder* _tmp30_ = NULL;
	GObject* _tmp31_ = NULL;
	GtkBox* _tmp32_ = NULL;
	GtkBuilder* _tmp33_ = NULL;
	GObject* _tmp34_ = NULL;
	GtkMenuItem* _tmp35_ = NULL;
	GtkBuilder* _tmp36_ = NULL;
	GObject* _tmp37_ = NULL;
	GtkMenuItem* _tmp38_ = NULL;
	GtkBuilder* _tmp39_ = NULL;
	GObject* _tmp40_ = NULL;
	GtkMenuItem* _tmp41_ = NULL;
	GtkBuilder* _tmp42_ = NULL;
	GObject* _tmp43_ = NULL;
	GtkMenuItem* _tmp44_ = NULL;
	GtkBuilder* _tmp45_ = NULL;
	GObject* _tmp46_ = NULL;
	GtkMenuItem* _tmp47_ = NULL;
	GtkBuilder* _tmp48_ = NULL;
	GObject* _tmp49_ = NULL;
	GtkMenuItem* _tmp50_ = NULL;
	GtkBuilder* _tmp51_ = NULL;
	GObject* _tmp52_ = NULL;
	GtkMenuItem* _tmp53_ = NULL;
	GtkBuilder* _tmp54_ = NULL;
	GObject* _tmp55_ = NULL;
	GtkToolButton* _tmp56_ = NULL;
	GtkBuilder* _tmp57_ = NULL;
	GObject* _tmp58_ = NULL;
	GtkMenuItem* _tmp59_ = NULL;
	GtkBuilder* _tmp60_ = NULL;
	GObject* _tmp61_ = NULL;
	GtkToolButton* _tmp62_ = NULL;
	GtkBuilder* _tmp63_ = NULL;
	GObject* _tmp64_ = NULL;
	GtkRadioMenuItem* _tmp65_ = NULL;
	GtkBuilder* _tmp66_ = NULL;
	GObject* _tmp67_ = NULL;
	GtkRadioMenuItem* _tmp68_ = NULL;
	GtkBuilder* _tmp69_ = NULL;
	GObject* _tmp70_ = NULL;
	GtkRadioMenuItem* _tmp71_ = NULL;
	GtkBuilder* _tmp72_ = NULL;
	GObject* _tmp73_ = NULL;
	GtkRadioMenuItem* _tmp74_ = NULL;
	GtkBuilder* _tmp75_ = NULL;
	GObject* _tmp76_ = NULL;
	GtkDialog* _tmp77_ = NULL;
	GtkBuilder* _tmp78_ = NULL;
	GObject* _tmp79_ = NULL;
	GtkLabel* _tmp80_ = NULL;
	GtkBuilder* _tmp81_ = NULL;
	GObject* _tmp82_ = NULL;
	GtkEntry* _tmp83_ = NULL;
	GtkBuilder* _tmp84_ = NULL;
	GObject* _tmp85_ = NULL;
	GtkEntry* _tmp86_ = NULL;
	GtkBuilder* _tmp87_ = NULL;
	GObject* _tmp88_ = NULL;
	GtkDialog* _tmp89_ = NULL;
	GtkBuilder* _tmp90_ = NULL;
	GObject* _tmp91_ = NULL;
	GtkComboBox* _tmp92_ = NULL;
	GtkComboBox* _tmp93_ = NULL;
	GtkTreeModel* _tmp94_ = NULL;
	GtkListStore* _tmp95_ = NULL;
	GtkBuilder* _tmp96_ = NULL;
	GObject* _tmp97_ = NULL;
	GtkComboBox* _tmp98_ = NULL;
	GtkComboBox* _tmp99_ = NULL;
	GtkTreeModel* _tmp100_ = NULL;
	GtkListStore* _tmp101_ = NULL;
	GtkBuilder* _tmp102_ = NULL;
	GObject* _tmp103_ = NULL;
	GtkComboBox* _tmp104_ = NULL;
	GtkComboBox* _tmp105_ = NULL;
	GtkTreeModel* _tmp106_ = NULL;
	GtkListStore* _tmp107_ = NULL;
	GtkBuilder* _tmp108_ = NULL;
	GObject* _tmp109_ = NULL;
	GtkComboBox* _tmp110_ = NULL;
	GtkComboBox* _tmp111_ = NULL;
	GtkTreeModel* _tmp112_ = NULL;
	GtkListStore* _tmp113_ = NULL;
	GtkBuilder* _tmp114_ = NULL;
	GObject* _tmp115_ = NULL;
	GtkComboBox* _tmp116_ = NULL;
	GtkComboBox* _tmp117_ = NULL;
	GtkTreeModel* _tmp118_ = NULL;
	GtkListStore* _tmp119_ = NULL;
	GtkBuilder* _tmp120_ = NULL;
	GObject* _tmp121_ = NULL;
	GtkScale* _tmp122_ = NULL;
	GtkScale* _tmp123_ = NULL;
	GtkAdjustment* _tmp124_ = NULL;
	GtkAdjustment* _tmp125_ = NULL;
	GtkBuilder* _tmp126_ = NULL;
	GObject* _tmp127_ = NULL;
	GtkScale* _tmp128_ = NULL;
	GtkScale* _tmp129_ = NULL;
	GtkAdjustment* _tmp130_ = NULL;
	GtkAdjustment* _tmp131_ = NULL;
	GtkBuilder* _tmp132_ = NULL;
	GObject* _tmp133_ = NULL;
	GtkScale* _tmp134_ = NULL;
	GtkScale* _tmp135_ = NULL;
	GtkAdjustment* _tmp136_ = NULL;
	GtkAdjustment* _tmp137_ = NULL;
	GtkInfoBar* _tmp138_ = NULL;
	GtkInfoBar* _tmp139_ = NULL;
	GtkBox* _tmp140_ = NULL;
	GtkInfoBar* _tmp141_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp142_ = NULL;
	GtkContainer* content_area = NULL;
	GtkInfoBar* _tmp143_ = NULL;
	GtkContainer* _tmp144_ = NULL;
	GtkContainer* _tmp145_ = NULL;
	GtkContainer* _tmp146_ = NULL;
	GtkBox* _tmp147_ = NULL;
	GtkBox* _tmp148_ = NULL;
	GtkImage* _tmp149_ = NULL;
	GtkBox* _tmp150_ = NULL;
	GtkImage* _tmp151_ = NULL;
	GtkImage* _tmp152_ = NULL;
	GtkLabel* _tmp153_ = NULL;
	GtkLabel* _tmp154_ = NULL;
	GtkBox* _tmp155_ = NULL;
	GtkLabel* _tmp156_ = NULL;
	GtkLabel* _tmp157_ = NULL;
	GtkInfoBar* _tmp158_ = NULL;
	const gchar* _tmp159_ = NULL;
	GtkButton* _tmp160_ = NULL;
	GtkButton* _tmp161_ = NULL;
	GtkInfoBar* _tmp162_ = NULL;
	const gchar* _tmp163_ = NULL;
	GtkButton* _tmp164_ = NULL;
	GtkButton* _tmp165_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp166_ = NULL;
	GtkTreeIter _tmp167_ = {0};
	GtkListStore* _tmp168_ = NULL;
	GtkTreeIter _tmp169_ = {0};
	const gchar* _tmp170_ = NULL;
	GtkListStore* _tmp171_ = NULL;
	GtkTreeIter _tmp172_ = {0};
	GtkListStore* _tmp173_ = NULL;
	GtkTreeIter _tmp174_ = {0};
	GtkListStore* _tmp175_ = NULL;
	GtkTreeIter _tmp176_ = {0};
	GtkListStore* _tmp177_ = NULL;
	GtkTreeIter _tmp178_ = {0};
	GtkListStore* _tmp179_ = NULL;
	GtkTreeIter _tmp180_ = {0};
	GtkListStore* _tmp181_ = NULL;
	GtkTreeIter _tmp182_ = {0};
	GtkListStore* _tmp183_ = NULL;
	GtkTreeIter _tmp184_ = {0};
	GtkListStore* _tmp185_ = NULL;
	GtkTreeIter _tmp186_ = {0};
	GtkListStore* _tmp187_ = NULL;
	GtkTreeIter _tmp188_ = {0};
	GtkListStore* _tmp189_ = NULL;
	GtkTreeIter _tmp190_ = {0};
	GtkListStore* _tmp191_ = NULL;
	GtkTreeIter _tmp192_ = {0};
	GtkListStore* _tmp193_ = NULL;
	GtkTreeIter _tmp194_ = {0};
	gint dpi = 0;
	GSettings* _tmp195_ = NULL;
	gint _tmp196_ = 0;
	gint _tmp197_ = 0;
	GtkComboBox* _tmp198_ = NULL;
	gint _tmp199_ = 0;
	GtkComboBox* _tmp200_ = NULL;
	GSettings* _tmp201_ = NULL;
	gint _tmp202_ = 0;
	gint _tmp203_ = 0;
	GtkComboBox* _tmp204_ = NULL;
	gint _tmp205_ = 0;
	GtkComboBox* _tmp206_ = NULL;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp207_ = NULL;
	GtkComboBox* _tmp208_ = NULL;
	GtkCellRendererText* _tmp209_ = NULL;
	GtkComboBox* _tmp210_ = NULL;
	GtkCellRendererText* _tmp211_ = NULL;
	GtkCellRendererText* _tmp212_ = NULL;
	GtkComboBox* _tmp213_ = NULL;
	GtkCellRendererText* _tmp214_ = NULL;
	GtkComboBox* _tmp215_ = NULL;
	GtkCellRendererText* _tmp216_ = NULL;
	GSettings* _tmp217_ = NULL;
	gint _tmp218_ = 0;
	GtkComboBox* _tmp219_ = NULL;
	GtkCellRendererText* _tmp220_ = NULL;
	GtkComboBox* _tmp221_ = NULL;
	GtkCellRendererText* _tmp222_ = NULL;
	GtkComboBox* _tmp223_ = NULL;
	GtkCellRendererText* _tmp224_ = NULL;
	gint paper_width = 0;
	GSettings* _tmp225_ = NULL;
	gint _tmp226_ = 0;
	gint paper_height = 0;
	GSettings* _tmp227_ = NULL;
	gint _tmp228_ = 0;
	gint _tmp229_ = 0;
	gint _tmp230_ = 0;
	GtkComboBox* _tmp231_ = NULL;
	gdouble lower = 0.0;
	GtkAdjustment* _tmp232_ = NULL;
	gdouble _tmp233_ = 0.0;
	gchar* darker_label = NULL;
	const gchar* _tmp234_ = NULL;
	gchar* _tmp235_ = NULL;
	gdouble upper = 0.0;
	GtkAdjustment* _tmp236_ = NULL;
	gdouble _tmp237_ = 0.0;
	gchar* lighter_label = NULL;
	const gchar* _tmp238_ = NULL;
	gchar* _tmp239_ = NULL;
	GtkScale* _tmp240_ = NULL;
	gdouble _tmp241_ = 0.0;
	const gchar* _tmp242_ = NULL;
	GtkScale* _tmp243_ = NULL;
	GtkScale* _tmp244_ = NULL;
	gdouble _tmp245_ = 0.0;
	const gchar* _tmp246_ = NULL;
	GSettings* _tmp247_ = NULL;
	gint _tmp248_ = 0;
	GtkAdjustment* _tmp249_ = NULL;
	GtkAdjustment* _tmp250_ = NULL;
	gdouble _tmp251_ = 0.0;
	gchar* less_label = NULL;
	const gchar* _tmp252_ = NULL;
	gchar* _tmp253_ = NULL;
	GtkAdjustment* _tmp254_ = NULL;
	gdouble _tmp255_ = 0.0;
	gchar* more_label = NULL;
	const gchar* _tmp256_ = NULL;
	gchar* _tmp257_ = NULL;
	GtkScale* _tmp258_ = NULL;
	gdouble _tmp259_ = 0.0;
	const gchar* _tmp260_ = NULL;
	GtkScale* _tmp261_ = NULL;
	GtkScale* _tmp262_ = NULL;
	gdouble _tmp263_ = 0.0;
	const gchar* _tmp264_ = NULL;
	GSettings* _tmp265_ = NULL;
	gint _tmp266_ = 0;
	GtkAdjustment* _tmp267_ = NULL;
	GtkAdjustment* _tmp268_ = NULL;
	gdouble _tmp269_ = 0.0;
	gchar* minimum_label = NULL;
	const gchar* _tmp270_ = NULL;
	gchar* _tmp271_ = NULL;
	GtkAdjustment* _tmp272_ = NULL;
	gdouble _tmp273_ = 0.0;
	gchar* maximum_label = NULL;
	const gchar* _tmp274_ = NULL;
	gchar* _tmp275_ = NULL;
	GtkScale* _tmp276_ = NULL;
	gdouble _tmp277_ = 0.0;
	const gchar* _tmp278_ = NULL;
	GtkScale* _tmp279_ = NULL;
	GtkScale* _tmp280_ = NULL;
	gdouble _tmp281_ = 0.0;
	const gchar* _tmp282_ = NULL;
	GSettings* _tmp283_ = NULL;
	gint _tmp284_ = 0;
	GtkAdjustment* _tmp285_ = NULL;
	gchar* device = NULL;
	GSettings* _tmp286_ = NULL;
	gchar* _tmp287_ = NULL;
	const gchar* _tmp288_ = NULL;
	gchar* document_type = NULL;
	GSettings* _tmp294_ = NULL;
	gchar* _tmp295_ = NULL;
	const gchar* _tmp296_ = NULL;
	Book* _tmp298_ = NULL;
	BookView* _tmp299_ = NULL;
	BookView* _tmp300_ = NULL;
	GtkBox* _tmp301_ = NULL;
	BookView* _tmp302_ = NULL;
	BookView* _tmp303_ = NULL;
	BookView* _tmp304_ = NULL;
	BookView* _tmp305_ = NULL;
	BookView* _tmp306_ = NULL;
	gint _tmp307_ = 0;
	gint _tmp308_ = 0;
	GtkApplicationWindow* _tmp309_ = NULL;
	gint _tmp310_ = 0;
	gint _tmp311_ = 0;
	gboolean _tmp312_ = FALSE;
	GtkApplicationWindow* _tmp314_ = NULL;
	const gchar* _tmp315_ = NULL;
	ProgressBarDialog* _tmp316_ = NULL;
	Book* _tmp317_ = NULL;
	GError * _inner_error_ = NULL;
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1427 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = gtk_icon_theme_get_default ();
#line 1427 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_icon_theme_append_search_path (_tmp0_, ICON_DIR);
#line 1429 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_default_icon_name ("scanner");
#line 1431 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_application_get_default ();
#line 1431 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GTK_TYPE_APPLICATION) ? ((GtkApplication*) _tmp1_) : NULL);
#line 1431 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	app = _tmp2_;
#line 1433 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = gtk_builder_new ();
#line 1433 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->builder);
#line 1433 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->builder = _tmp3_;
#line 7036 "ui.c"
	{
		GtkBuilder* _tmp4_ = NULL;
		GtkApplication* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 1436 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->builder;
#line 1436 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_builder_add_from_resource (_tmp4_, "/org/gnome/SimpleScan/simple-scan.ui", &_inner_error_);
#line 1436 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 7047 "ui.c"
			goto __catch21_g_error;
		}
#line 1437 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = app;
#line 1437 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = user_interface_has_app_menu (self, _tmp5_);
#line 1437 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp6_) {
#line 7056 "ui.c"
			GtkBuilder* _tmp7_ = NULL;
#line 1438 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp7_ = self->priv->builder;
#line 1438 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_builder_add_from_resource (_tmp7_, "/org/gnome/SimpleScan/simple-scan-menu.ui", &_inner_error_);
#line 1438 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (_inner_error_ != NULL) {
#line 7064 "ui.c"
				goto __catch21_g_error;
			}
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 1434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 1434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1442 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = e;
#line 1442 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = _tmp8_->message;
#line 1442 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("ui.vala:1442: Unable to load UI: %s\n", _tmp9_);
#line 1443 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = _ ("Files missing");
#line 1443 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp11_ = _ ("Please check your installation");
#line 1443 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp10_, _tmp11_);
#line 1447 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		exit (EXIT_FAILURE);
#line 1434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 7097 "ui.c"
	}
	__finally21:
#line 1434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (app);
#line 1434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 7110 "ui.c"
	}
#line 1449 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = self->priv->builder;
#line 1449 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_builder_connect_signals (_tmp12_, self);
#line 1451 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = self->priv->builder;
#line 1451 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = gtk_builder_get_object (_tmp13_, "simple_scan_window");
#line 1451 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GTK_TYPE_APPLICATION_WINDOW, GtkApplicationWindow));
#line 1451 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->window);
#line 1451 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->window = _tmp15_;
#line 1452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = app;
#line 1452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = self->priv->window;
#line 1452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_application_add_window (_tmp16_, (GtkWindow*) _tmp17_);
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = self->priv->builder;
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = gtk_builder_get_object (_tmp18_, "menubar");
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GTK_TYPE_MENU_BAR, GtkMenuBar));
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->menubar);
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->menubar = _tmp20_;
#line 1454 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = app;
#line 1454 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = user_interface_has_app_menu (self, _tmp21_);
#line 1454 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp22_) {
#line 7148 "ui.c"
		GtkBuilder* _tmp23_ = NULL;
		GObject* _tmp24_ = NULL;
		GMenuModel* _tmp25_ = NULL;
		GtkApplication* _tmp26_ = NULL;
		GtkApplication* _tmp27_ = NULL;
		GMenuModel* _tmp28_ = NULL;
		GtkMenuBar* _tmp29_ = NULL;
#line 1456 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp23_ = self->priv->builder;
#line 1456 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp24_ = gtk_builder_get_object (_tmp23_, "appmenu");
#line 1456 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, g_menu_model_get_type (), GMenuModel));
#line 1456 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (self->priv->app_menu);
#line 1456 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->app_menu = _tmp25_;
#line 1457 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp26_ = app;
#line 1457 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_action_map_add_action_entries ((GActionMap*) _tmp26_, USER_INTERFACE_action_entries, G_N_ELEMENTS (USER_INTERFACE_action_entries), self);
#line 1458 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp27_ = app;
#line 1458 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp28_ = self->priv->app_menu;
#line 1458 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_application_set_app_menu (_tmp27_, _tmp28_);
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp29_ = self->priv->menubar;
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp29_, FALSE);
#line 7180 "ui.c"
	}
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp30_ = self->priv->builder;
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp31_ = gtk_builder_get_object (_tmp30_, "main_vbox");
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GTK_TYPE_BOX, GtkBox));
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->main_vbox);
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->main_vbox = _tmp32_;
#line 1462 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp33_ = self->priv->builder;
#line 1462 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp34_ = gtk_builder_get_object (_tmp33_, "page_move_left_menuitem");
#line 1462 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1462 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_left_menuitem);
#line 1462 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->page_move_left_menuitem = _tmp35_;
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp36_ = self->priv->builder;
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp37_ = gtk_builder_get_object (_tmp36_, "page_move_right_menuitem");
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_right_menuitem);
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->page_move_right_menuitem = _tmp38_;
#line 1464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp39_ = self->priv->builder;
#line 1464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp40_ = gtk_builder_get_object (_tmp39_, "page_delete_menuitem");
#line 1464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_delete_menuitem);
#line 1464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->page_delete_menuitem = _tmp41_;
#line 1465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp42_ = self->priv->builder;
#line 1465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp43_ = gtk_builder_get_object (_tmp42_, "crop_rotate_menuitem");
#line 1465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
#line 1465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->crop_rotate_menuitem = _tmp44_;
#line 1466 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp45_ = self->priv->builder;
#line 1466 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp46_ = gtk_builder_get_object (_tmp45_, "save_menuitem");
#line 1466 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1466 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_menuitem);
#line 1466 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->save_menuitem = _tmp47_;
#line 1467 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp48_ = self->priv->builder;
#line 1467 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp49_ = gtk_builder_get_object (_tmp48_, "save_as_menuitem");
#line 1467 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1467 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_as_menuitem);
#line 1467 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->save_as_menuitem = _tmp50_;
#line 1468 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp51_ = self->priv->builder;
#line 1468 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp52_ = gtk_builder_get_object (_tmp51_, "copy_to_clipboard_menuitem");
#line 1468 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1468 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->copy_to_clipboard_menuitem);
#line 1468 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->copy_to_clipboard_menuitem = _tmp53_;
#line 1469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp54_ = self->priv->builder;
#line 1469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp55_ = gtk_builder_get_object (_tmp54_, "save_toolbutton");
#line 1469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
#line 1469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_toolbutton);
#line 1469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->save_toolbutton = _tmp56_;
#line 1470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp57_ = self->priv->builder;
#line 1470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp58_ = gtk_builder_get_object (_tmp57_, "stop_scan_menuitem");
#line 1470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->stop_menuitem);
#line 1470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->stop_menuitem = _tmp59_;
#line 1471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp60_ = self->priv->builder;
#line 1471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp61_ = gtk_builder_get_object (_tmp60_, "stop_toolbutton");
#line 1471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
#line 1471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->stop_toolbutton);
#line 1471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->stop_toolbutton = _tmp62_;
#line 1473 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp63_ = self->priv->builder;
#line 1473 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp64_ = gtk_builder_get_object (_tmp63_, "text_toolbutton_menuitem");
#line 1473 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1473 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
#line 1473 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->text_toolbar_menuitem = _tmp65_;
#line 1474 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp66_ = self->priv->builder;
#line 1474 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp67_ = gtk_builder_get_object (_tmp66_, "text_menuitem");
#line 1474 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1474 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_menu_menuitem);
#line 1474 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->text_menu_menuitem = _tmp68_;
#line 1475 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp69_ = self->priv->builder;
#line 1475 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp70_ = gtk_builder_get_object (_tmp69_, "photo_toolbutton_menuitem");
#line 1475 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1475 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
#line 1475 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->photo_toolbar_menuitem = _tmp71_;
#line 1476 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp72_ = self->priv->builder;
#line 1476 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp73_ = gtk_builder_get_object (_tmp72_, "photo_menuitem");
#line 1476 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp74_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1476 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_menu_menuitem);
#line 1476 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->photo_menu_menuitem = _tmp74_;
#line 1478 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp75_ = self->priv->builder;
#line 1478 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp76_ = gtk_builder_get_object (_tmp75_, "authorize_dialog");
#line 1478 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, GTK_TYPE_DIALOG, GtkDialog));
#line 1478 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_dialog);
#line 1478 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->authorize_dialog = _tmp77_;
#line 1479 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp78_ = self->priv->builder;
#line 1479 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp79_ = gtk_builder_get_object (_tmp78_, "authorize_label");
#line 1479 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, GTK_TYPE_LABEL, GtkLabel));
#line 1479 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_label);
#line 1479 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->authorize_label = _tmp80_;
#line 1480 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp81_ = self->priv->builder;
#line 1480 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp82_ = gtk_builder_get_object (_tmp81_, "username_entry");
#line 1480 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp83_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, GTK_TYPE_ENTRY, GtkEntry));
#line 1480 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 1480 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->username_entry = _tmp83_;
#line 1481 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp84_ = self->priv->builder;
#line 1481 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp85_ = gtk_builder_get_object (_tmp84_, "password_entry");
#line 1481 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp86_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, GTK_TYPE_ENTRY, GtkEntry));
#line 1481 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 1481 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->password_entry = _tmp86_;
#line 1483 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp87_ = self->priv->builder;
#line 1483 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp88_ = gtk_builder_get_object (_tmp87_, "preferences_dialog");
#line 1483 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp89_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, GTK_TYPE_DIALOG, GtkDialog));
#line 1483 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 1483 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->preferences_dialog = _tmp89_;
#line 1484 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp90_ = self->priv->builder;
#line 1484 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp91_ = gtk_builder_get_object (_tmp90_, "device_combo");
#line 1484 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp92_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1484 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->device_combo);
#line 1484 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->device_combo = _tmp92_;
#line 1485 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp93_ = self->priv->device_combo;
#line 1485 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp94_ = gtk_combo_box_get_model (_tmp93_);
#line 1485 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp95_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1485 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->device_model);
#line 1485 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->device_model = _tmp95_;
#line 1486 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp96_ = self->priv->builder;
#line 1486 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp97_ = gtk_builder_get_object (_tmp96_, "text_dpi_combo");
#line 1486 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp98_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1486 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_combo);
#line 1486 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->text_dpi_combo = _tmp98_;
#line 1487 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp99_ = self->priv->text_dpi_combo;
#line 1487 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp100_ = gtk_combo_box_get_model (_tmp99_);
#line 1487 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp101_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1487 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_model);
#line 1487 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->text_dpi_model = _tmp101_;
#line 1488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp102_ = self->priv->builder;
#line 1488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp103_ = gtk_builder_get_object (_tmp102_, "photo_dpi_combo");
#line 1488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp104_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_combo);
#line 1488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->photo_dpi_combo = _tmp104_;
#line 1489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp105_ = self->priv->photo_dpi_combo;
#line 1489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp106_ = gtk_combo_box_get_model (_tmp105_);
#line 1489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp107_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_model);
#line 1489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->photo_dpi_model = _tmp107_;
#line 1490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp108_ = self->priv->builder;
#line 1490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp109_ = gtk_builder_get_object (_tmp108_, "page_side_combo");
#line 1490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp110_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_combo);
#line 1490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->page_side_combo = _tmp110_;
#line 1491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp111_ = self->priv->page_side_combo;
#line 1491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp112_ = gtk_combo_box_get_model (_tmp111_);
#line 1491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp113_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_model);
#line 1491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->page_side_model = _tmp113_;
#line 1492 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp114_ = self->priv->builder;
#line 1492 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp115_ = gtk_builder_get_object (_tmp114_, "paper_size_combo");
#line 1492 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp116_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1492 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_combo);
#line 1492 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->paper_size_combo = _tmp116_;
#line 1493 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp117_ = self->priv->paper_size_combo;
#line 1493 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp118_ = gtk_combo_box_get_model (_tmp117_);
#line 1493 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp119_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1493 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_model);
#line 1493 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->paper_size_model = _tmp119_;
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp120_ = self->priv->builder;
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp121_ = gtk_builder_get_object (_tmp120_, "brightness_scale");
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp122_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, GTK_TYPE_SCALE, GtkScale));
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_scale);
#line 1494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->brightness_scale = _tmp122_;
#line 1495 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp123_ = self->priv->brightness_scale;
#line 1495 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp124_ = gtk_range_get_adjustment ((GtkRange*) _tmp123_);
#line 1495 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp125_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, GTK_TYPE_ADJUSTMENT, GtkAdjustment));
#line 1495 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_adjustment);
#line 1495 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->brightness_adjustment = _tmp125_;
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp126_ = self->priv->builder;
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp127_ = gtk_builder_get_object (_tmp126_, "contrast_scale");
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp128_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp127_, GTK_TYPE_SCALE, GtkScale));
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_scale);
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->contrast_scale = _tmp128_;
#line 1497 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp129_ = self->priv->contrast_scale;
#line 1497 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp130_ = gtk_range_get_adjustment ((GtkRange*) _tmp129_);
#line 1497 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp131_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp130_, GTK_TYPE_ADJUSTMENT, GtkAdjustment));
#line 1497 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_adjustment);
#line 1497 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->contrast_adjustment = _tmp131_;
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp132_ = self->priv->builder;
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp133_ = gtk_builder_get_object (_tmp132_, "quality_scale");
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp134_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, GTK_TYPE_SCALE, GtkScale));
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->quality_scale);
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->quality_scale = _tmp134_;
#line 1499 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp135_ = self->priv->quality_scale;
#line 1499 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp136_ = gtk_range_get_adjustment ((GtkRange*) _tmp135_);
#line 1499 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp137_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, GTK_TYPE_ADJUSTMENT, GtkAdjustment));
#line 1499 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->quality_adjustment);
#line 1499 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->quality_adjustment = _tmp137_;
#line 1502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp138_ = (GtkInfoBar*) gtk_info_bar_new ();
#line 1502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp138_);
#line 1502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 1502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->info_bar = _tmp138_;
#line 1503 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp139_ = self->priv->info_bar;
#line 1503 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp139_, "response", (GCallback) _user_interface_info_bar_response_cb_gtk_info_bar_response, self);
#line 1504 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp140_ = self->priv->main_vbox;
#line 1504 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp141_ = self->priv->info_bar;
#line 1504 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (_tmp140_, (GtkWidget*) _tmp141_, FALSE, TRUE, (guint) 0);
#line 1505 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp142_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
#line 1505 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp142_);
#line 1505 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	hbox = _tmp142_;
#line 1506 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp143_ = self->priv->info_bar;
#line 1506 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp144_ = gtk_info_bar_get_content_area (_tmp143_);
#line 1506 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp145_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp144_, GTK_TYPE_CONTAINER, GtkContainer));
#line 1506 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	content_area = _tmp145_;
#line 1507 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp146_ = content_area;
#line 1507 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp147_ = hbox;
#line 1507 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_container_add (_tmp146_, (GtkWidget*) _tmp147_);
#line 1508 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp148_ = hbox;
#line 1508 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp148_);
#line 1510 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp149_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-warning", GTK_ICON_SIZE_DIALOG);
#line 1510 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp149_);
#line 1510 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_image);
#line 1510 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->info_bar_image = _tmp149_;
#line 1511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp150_ = hbox;
#line 1511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp151_ = self->priv->info_bar_image;
#line 1511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (_tmp150_, (GtkWidget*) _tmp151_, FALSE, TRUE, (guint) 0);
#line 1512 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp152_ = self->priv->info_bar_image;
#line 1512 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp152_);
#line 1514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp153_ = (GtkLabel*) gtk_label_new (NULL);
#line 1514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp153_);
#line 1514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 1514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->info_bar_label = _tmp153_;
#line 1515 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp154_ = self->priv->info_bar_label;
#line 1515 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp154_, 0.0f, 0.5f);
#line 1516 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp155_ = hbox;
#line 1516 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp156_ = self->priv->info_bar_label;
#line 1516 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (_tmp155_, (GtkWidget*) _tmp156_, TRUE, TRUE, (guint) 0);
#line 1517 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp157_ = self->priv->info_bar_label;
#line 1517 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp157_);
#line 1519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp158_ = self->priv->info_bar;
#line 1519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp159_ = _ ("_Close");
#line 1519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp160_ = gtk_info_bar_add_button (_tmp158_, _tmp159_, (gint) GTK_RESPONSE_CLOSE);
#line 1519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp161_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, GTK_TYPE_BUTTON, GtkButton));
#line 1519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_close_button);
#line 1519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->info_bar_close_button = _tmp161_;
#line 1520 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp162_ = self->priv->info_bar;
#line 1520 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp163_ = _ ("Change _Scanner");
#line 1520 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp164_ = gtk_info_bar_add_button (_tmp162_, _tmp163_, 1);
#line 1520 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp165_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, GTK_TYPE_BUTTON, GtkButton));
#line 1520 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
#line 1520 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->info_bar_change_scanner_button = _tmp165_;
#line 1524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp166_ = self->priv->paper_size_model;
#line 1524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp166_, &_tmp167_);
#line 1524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp167_;
#line 1525 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp168_ = self->priv->paper_size_model;
#line 1525 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp169_ = iter;
#line 1525 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp170_ = _ ("Automatic");
#line 1525 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp168_, &_tmp169_, 0, 0, 1, 0, 2, _tmp170_, -1, -1);
#line 1528 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp171_ = self->priv->paper_size_model;
#line 1528 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp171_, &_tmp172_);
#line 1528 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp172_;
#line 1529 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp173_ = self->priv->paper_size_model;
#line 1529 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp174_ = iter;
#line 1529 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp173_, &_tmp174_, 0, 1050, 1, 1480, 2, "A6", -1, -1);
#line 1530 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp175_ = self->priv->paper_size_model;
#line 1530 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp175_, &_tmp176_);
#line 1530 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp176_;
#line 1531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp177_ = self->priv->paper_size_model;
#line 1531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp178_ = iter;
#line 1531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp177_, &_tmp178_, 0, 1480, 1, 2100, 2, "A5", -1, -1);
#line 1532 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp179_ = self->priv->paper_size_model;
#line 1532 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp179_, &_tmp180_);
#line 1532 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp180_;
#line 1533 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp181_ = self->priv->paper_size_model;
#line 1533 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp182_ = iter;
#line 1533 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp181_, &_tmp182_, 0, 2100, 1, 2970, 2, "A4", -1, -1);
#line 1534 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp183_ = self->priv->paper_size_model;
#line 1534 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp183_, &_tmp184_);
#line 1534 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp184_;
#line 1535 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp185_ = self->priv->paper_size_model;
#line 1535 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp186_ = iter;
#line 1535 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp185_, &_tmp186_, 0, 2159, 1, 2794, 2, "Letter", -1, -1);
#line 1536 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp187_ = self->priv->paper_size_model;
#line 1536 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp187_, &_tmp188_);
#line 1536 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp188_;
#line 1537 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp189_ = self->priv->paper_size_model;
#line 1537 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp190_ = iter;
#line 1537 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp189_, &_tmp190_, 0, 2159, 1, 3556, 2, "Legal", -1, -1);
#line 1538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp191_ = self->priv->paper_size_model;
#line 1538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp191_, &_tmp192_);
#line 1538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp192_;
#line 1539 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp193_ = self->priv->paper_size_model;
#line 1539 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp194_ = iter;
#line 1539 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp193_, &_tmp194_, 0, 1016, 1, 1524, 2, "4×6", -1, -1);
#line 1541 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp195_ = self->priv->settings;
#line 1541 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp196_ = g_settings_get_int (_tmp195_, "text-dpi");
#line 1541 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dpi = _tmp196_;
#line 1542 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp197_ = dpi;
#line 1542 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp197_ <= 0) {
#line 1543 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dpi = USER_INTERFACE_DEFAULT_TEXT_DPI;
#line 7746 "ui.c"
	}
#line 1544 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp198_ = self->priv->text_dpi_combo;
#line 1544 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp199_ = dpi;
#line 1544 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_dpi_combo (self, _tmp198_, USER_INTERFACE_DEFAULT_TEXT_DPI, _tmp199_);
#line 1545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp200_ = self->priv->text_dpi_combo;
#line 1545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp200_, "changed", (GCallback) ___lambda4__gtk_combo_box_changed, self);
#line 1546 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp201_ = self->priv->settings;
#line 1546 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp202_ = g_settings_get_int (_tmp201_, "photo-dpi");
#line 1546 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dpi = _tmp202_;
#line 1547 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp203_ = dpi;
#line 1547 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp203_ <= 0) {
#line 1548 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dpi = USER_INTERFACE_DEFAULT_PHOTO_DPI;
#line 7770 "ui.c"
	}
#line 1549 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp204_ = self->priv->photo_dpi_combo;
#line 1549 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp205_ = dpi;
#line 1549 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_dpi_combo (self, _tmp204_, USER_INTERFACE_DEFAULT_PHOTO_DPI, _tmp205_);
#line 1550 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp206_ = self->priv->photo_dpi_combo;
#line 1550 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp206_, "changed", (GCallback) ___lambda5__gtk_combo_box_changed, self);
#line 1552 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp207_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1552 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp207_);
#line 1552 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	renderer = _tmp207_;
#line 1553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp208_ = self->priv->device_combo;
#line 1553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp209_ = renderer;
#line 1553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp208_, (GtkCellRenderer*) _tmp209_, TRUE);
#line 1554 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp210_ = self->priv->device_combo;
#line 1554 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp211_ = renderer;
#line 1554 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp210_, (GtkCellRenderer*) _tmp211_, "text", 1);
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp212_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp212_);
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	renderer = _tmp212_;
#line 1557 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp213_ = self->priv->page_side_combo;
#line 1557 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp214_ = renderer;
#line 1557 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp213_, (GtkCellRenderer*) _tmp214_, TRUE);
#line 1558 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp215_ = self->priv->page_side_combo;
#line 1558 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp216_ = renderer;
#line 1558 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp215_, (GtkCellRenderer*) _tmp216_, "text", 1);
#line 1559 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp217_ = self->priv->settings;
#line 1559 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp218_ = g_settings_get_enum (_tmp217_, "page-side");
#line 1559 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_page_side (self, (ScanType) _tmp218_);
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp219_ = self->priv->page_side_combo;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp219_, "changed", (GCallback) ___lambda6__gtk_combo_box_changed, self);
#line 1562 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp220_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1562 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp220_);
#line 1562 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1562 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	renderer = _tmp220_;
#line 1563 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp221_ = self->priv->paper_size_combo;
#line 1563 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp222_ = renderer;
#line 1563 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp221_, (GtkCellRenderer*) _tmp222_, TRUE);
#line 1564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp223_ = self->priv->paper_size_combo;
#line 1564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp224_ = renderer;
#line 1564 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp223_, (GtkCellRenderer*) _tmp224_, "text", 2);
#line 1565 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp225_ = self->priv->settings;
#line 1565 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp226_ = g_settings_get_int (_tmp225_, "paper-width");
#line 1565 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	paper_width = _tmp226_;
#line 1566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp227_ = self->priv->settings;
#line 1566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp228_ = g_settings_get_int (_tmp227_, "paper-height");
#line 1566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	paper_height = _tmp228_;
#line 1567 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp229_ = paper_width;
#line 1567 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp230_ = paper_height;
#line 1567 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_paper_size (self, _tmp229_, _tmp230_);
#line 1568 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp231_ = self->priv->paper_size_combo;
#line 1568 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp231_, "changed", (GCallback) ___lambda7__gtk_combo_box_changed, self);
#line 1576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp232_ = self->priv->brightness_adjustment;
#line 1576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp233_ = gtk_adjustment_get_lower (_tmp232_);
#line 1576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	lower = _tmp233_;
#line 1577 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp234_ = _ ("Darker");
#line 1577 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp235_ = g_strdup_printf ("<small>%s</small>", _tmp234_);
#line 1577 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	darker_label = _tmp235_;
#line 1578 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp236_ = self->priv->brightness_adjustment;
#line 1578 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp237_ = gtk_adjustment_get_upper (_tmp236_);
#line 1578 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	upper = _tmp237_;
#line 1579 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp238_ = _ ("Lighter");
#line 1579 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp239_ = g_strdup_printf ("<small>%s</small>", _tmp238_);
#line 1579 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	lighter_label = _tmp239_;
#line 1580 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp240_ = self->priv->brightness_scale;
#line 1580 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp241_ = lower;
#line 1580 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp242_ = darker_label;
#line 1580 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp240_, _tmp241_, GTK_POS_BOTTOM, _tmp242_);
#line 1581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp243_ = self->priv->brightness_scale;
#line 1581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp243_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
#line 1582 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp244_ = self->priv->brightness_scale;
#line 1582 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp245_ = upper;
#line 1582 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp246_ = lighter_label;
#line 1582 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp244_, _tmp245_, GTK_POS_BOTTOM, _tmp246_);
#line 1583 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp247_ = self->priv->settings;
#line 1583 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp248_ = g_settings_get_int (_tmp247_, "brightness");
#line 1583 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_brightness (self, _tmp248_);
#line 1584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp249_ = self->priv->brightness_adjustment;
#line 1584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp249_, "value-changed", (GCallback) ___lambda8__gtk_adjustment_value_changed, self);
#line 1586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp250_ = self->priv->contrast_adjustment;
#line 1586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp251_ = gtk_adjustment_get_lower (_tmp250_);
#line 1586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	lower = _tmp251_;
#line 1587 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp252_ = _ ("Less");
#line 1587 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp253_ = g_strdup_printf ("<small>%s</small>", _tmp252_);
#line 1587 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	less_label = _tmp253_;
#line 1588 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp254_ = self->priv->contrast_adjustment;
#line 1588 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp255_ = gtk_adjustment_get_upper (_tmp254_);
#line 1588 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	upper = _tmp255_;
#line 1589 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp256_ = _ ("More");
#line 1589 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp257_ = g_strdup_printf ("<small>%s</small>", _tmp256_);
#line 1589 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	more_label = _tmp257_;
#line 1590 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp258_ = self->priv->contrast_scale;
#line 1590 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp259_ = lower;
#line 1590 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp260_ = less_label;
#line 1590 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp258_, _tmp259_, GTK_POS_BOTTOM, _tmp260_);
#line 1591 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp261_ = self->priv->contrast_scale;
#line 1591 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp261_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
#line 1592 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp262_ = self->priv->contrast_scale;
#line 1592 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp263_ = upper;
#line 1592 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp264_ = more_label;
#line 1592 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp262_, _tmp263_, GTK_POS_BOTTOM, _tmp264_);
#line 1593 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp265_ = self->priv->settings;
#line 1593 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp266_ = g_settings_get_int (_tmp265_, "contrast");
#line 1593 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_contrast (self, _tmp266_);
#line 1594 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp267_ = self->priv->contrast_adjustment;
#line 1594 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp267_, "value-changed", (GCallback) ___lambda9__gtk_adjustment_value_changed, self);
#line 1596 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp268_ = self->priv->quality_adjustment;
#line 1596 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp269_ = gtk_adjustment_get_lower (_tmp268_);
#line 1596 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	lower = _tmp269_;
#line 1597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp270_ = _ ("Minimum");
#line 1597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp271_ = g_strdup_printf ("<small>%s</small>", _tmp270_);
#line 1597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	minimum_label = _tmp271_;
#line 1598 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp272_ = self->priv->quality_adjustment;
#line 1598 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp273_ = gtk_adjustment_get_upper (_tmp272_);
#line 1598 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	upper = _tmp273_;
#line 1599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp274_ = _ ("Maximum");
#line 1599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp275_ = g_strdup_printf ("<small>%s</small>", _tmp274_);
#line 1599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	maximum_label = _tmp275_;
#line 1600 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp276_ = self->priv->quality_scale;
#line 1600 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp277_ = lower;
#line 1600 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp278_ = minimum_label;
#line 1600 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp276_, _tmp277_, GTK_POS_BOTTOM, _tmp278_);
#line 1601 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp279_ = self->priv->quality_scale;
#line 1601 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp279_, (gdouble) 75, GTK_POS_BOTTOM, NULL);
#line 1602 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp280_ = self->priv->quality_scale;
#line 1602 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp281_ = upper;
#line 1602 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp282_ = maximum_label;
#line 1602 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp280_, _tmp281_, GTK_POS_BOTTOM, _tmp282_);
#line 1603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp283_ = self->priv->settings;
#line 1603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp284_ = g_settings_get_int (_tmp283_, "jpeg-quality");
#line 1603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_quality (self, _tmp284_);
#line 1604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp285_ = self->priv->quality_adjustment;
#line 1604 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp285_, "value-changed", (GCallback) ___lambda10__gtk_adjustment_value_changed, self);
#line 1606 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp286_ = self->priv->settings;
#line 1606 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp287_ = g_settings_get_string (_tmp286_, "selected-device");
#line 1606 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	device = _tmp287_;
#line 1607 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp288_ = device;
#line 1607 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp288_ != NULL) {
#line 8044 "ui.c"
		const gchar* _tmp289_ = NULL;
		GtkTreeIter _tmp290_ = {0};
		gboolean _tmp291_ = FALSE;
#line 1609 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp289_ = device;
#line 1609 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp291_ = user_interface_find_scan_device (self, _tmp289_, &_tmp290_);
#line 1609 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		iter = _tmp290_;
#line 1609 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp291_) {
#line 8056 "ui.c"
			GtkComboBox* _tmp292_ = NULL;
			GtkTreeIter _tmp293_ = {0};
#line 1610 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp292_ = self->priv->device_combo;
#line 1610 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp293_ = iter;
#line 1610 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_combo_box_set_active_iter (_tmp292_, &_tmp293_);
#line 8065 "ui.c"
		}
	}
#line 1613 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp294_ = self->priv->settings;
#line 1613 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp295_ = g_settings_get_string (_tmp294_, "document-type");
#line 1613 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	document_type = _tmp295_;
#line 1614 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp296_ = document_type;
#line 1614 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp296_ != NULL) {
#line 8078 "ui.c"
		const gchar* _tmp297_ = NULL;
#line 1615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp297_ = document_type;
#line 1615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_document_hint (self, _tmp297_, FALSE);
#line 8084 "ui.c"
	}
#line 1617 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp298_ = self->priv->_book;
#line 1617 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp299_ = book_view_new (_tmp298_);
#line 1617 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp299_);
#line 1617 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->book_view);
#line 1617 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->book_view = _tmp299_;
#line 1618 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp300_ = self->priv->book_view;
#line 1618 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp300_, (guint) 18);
#line 1619 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp301_ = self->priv->main_vbox;
#line 1619 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp302_ = self->priv->book_view;
#line 1619 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_end (_tmp301_, (GtkWidget*) _tmp302_, TRUE, TRUE, (guint) 0);
#line 1620 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp303_ = self->priv->book_view;
#line 1620 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp303_, "page-selected", (GCallback) _user_interface_page_selected_cb_book_view_page_selected, self);
#line 1621 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp304_ = self->priv->book_view;
#line 1621 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp304_, "show-page", (GCallback) _user_interface_show_page_cb_book_view_show_page, self);
#line 1622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp305_ = self->priv->book_view;
#line 1622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp305_, "show-menu", (GCallback) _user_interface_show_page_menu_cb_book_view_show_menu, self);
#line 1623 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp306_ = self->priv->book_view;
#line 1623 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp306_);
#line 1626 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_load_state (self);
#line 1629 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp307_ = self->priv->window_width;
#line 1629 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp308_ = self->priv->window_height;
#line 1629 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_debug ("ui.vala:1629: Restoring window to %dx%d pixels", _tmp307_, _tmp308_);
#line 1630 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp309_ = self->priv->window;
#line 1630 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp310_ = self->priv->window_width;
#line 1630 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp311_ = self->priv->window_height;
#line 1630 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp309_, _tmp310_, _tmp311_);
#line 1631 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp312_ = self->priv->window_is_maximized;
#line 1631 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp312_) {
#line 8142 "ui.c"
		GtkApplicationWindow* _tmp313_ = NULL;
#line 1633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_debug ("ui.vala:1633: Restoring window to maximized");
#line 1634 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp313_ = self->priv->window;
#line 1634 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_window_maximize ((GtkWindow*) _tmp313_);
#line 8150 "ui.c"
	}
#line 1637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp314_ = self->priv->window;
#line 1637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp315_ = _ ("Saving document...");
#line 1637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp316_ = progress_bar_dialog_new (_tmp314_, _tmp315_);
#line 1637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp316_);
#line 1637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 1637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->progress_dialog = _tmp316_;
#line 1638 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp317_ = self->priv->_book;
#line 1638 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp317_, "saving", (GCallback) _user_interface_book_saving_cb_book_saving, self);
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (document_type);
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (device);
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (maximum_label);
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (minimum_label);
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (more_label);
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (less_label);
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (lighter_label);
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (darker_label);
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (content_area);
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (hbox);
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (app);
#line 8192 "ui.c"
}


static void user_interface_load_state (UserInterface* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GKeyFile* f = NULL;
	GKeyFile* _tmp3_ = NULL;
	GKeyFile* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GKeyFile* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GKeyFile* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GKeyFile* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	GKeyFile* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	GKeyFile* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	GKeyFile* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GQuark _tmp29_ = 0U;
#line 1670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	static GQuark _tmp28_label0 = 0;
#line 1670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	static GQuark _tmp28_label1 = 0;
#line 1670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	static GQuark _tmp28_label2 = 0;
#line 8226 "ui.c"
	GError * _inner_error_ = NULL;
#line 1646 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1648 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = user_interface_get_state_filename (self);
#line 1648 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _tmp0_;
#line 1648 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1648 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_debug ("ui.vala:1648: Loading state from %s", _tmp2_);
#line 1648 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_tmp2_);
#line 1650 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = g_key_file_new ();
#line 1650 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	f = _tmp3_;
#line 8244 "ui.c"
	{
		GKeyFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 1653 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = f;
#line 1653 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = user_interface_get_state_filename (self);
#line 1653 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = _tmp5_;
#line 1653 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = _tmp6_;
#line 1653 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_key_file_load_from_file (_tmp4_, _tmp7_, G_KEY_FILE_NONE, &_inner_error_);
#line 1653 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_tmp7_);
#line 1653 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 8264 "ui.c"
			goto __catch22_g_error;
		}
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
#line 1651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 1651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1657 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = e;
#line 1657 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (!g_error_matches (_tmp8_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
#line 8281 "ui.c"
			GError* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
#line 1658 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp9_ = e;
#line 1658 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp10_ = _tmp9_->message;
#line 1658 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			g_warning ("ui.vala:1658: Failed to load state: %s", _tmp10_);
#line 8290 "ui.c"
		}
#line 1651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 8294 "ui.c"
	}
	__finally22:
#line 1651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_key_file_unref0 (f);
#line 1651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 8307 "ui.c"
	}
#line 1660 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = f;
#line 1660 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = user_interface_state_get_integer (self, _tmp11_, "window", "width", 600);
#line 1660 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->window_width = _tmp12_;
#line 1661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = self->priv->window_width;
#line 1661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp13_ <= 0) {
#line 1662 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->window_width = 600;
#line 8321 "ui.c"
	}
#line 1663 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = f;
#line 1663 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = user_interface_state_get_integer (self, _tmp14_, "window", "height", 400);
#line 1663 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->window_height = _tmp15_;
#line 1664 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = self->priv->window_height;
#line 1664 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp16_ <= 0) {
#line 1665 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->window_height = 400;
#line 8335 "ui.c"
	}
#line 1666 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = f;
#line 1666 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = user_interface_state_get_boolean (self, _tmp17_, "window", "is-maximized", FALSE);
#line 1666 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->window_is_maximized = _tmp18_;
#line 1667 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = f;
#line 1667 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = user_interface_state_get_integer (self, _tmp19_, "last-page", "width", 595);
#line 1667 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_width = _tmp20_;
#line 1668 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = f;
#line 1668 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = user_interface_state_get_integer (self, _tmp21_, "last-page", "height", 842);
#line 1668 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_height = _tmp22_;
#line 1669 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = f;
#line 1669 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = user_interface_state_get_integer (self, _tmp23_, "last-page", "dpi", 72);
#line 1669 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_dpi = _tmp24_;
#line 1670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = f;
#line 1670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp26_ = user_interface_state_get_string (self, _tmp25_, "last-page", "scan-direction", "top-to-bottom");
#line 1670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = _tmp26_;
#line 1670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp29_ = (NULL == _tmp27_) ? 0 : g_quark_from_string (_tmp27_);
#line 1670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_free (_tmp27_);
#line 1670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp29_ == ((0 != _tmp28_label0) ? _tmp28_label0 : (_tmp28_label0 = g_quark_from_static_string ("bottom-to-top")))) {
#line 1670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		switch (0) {
#line 8375 "ui.c"
			default:
			{
#line 1677 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				self->priv->default_page_scan_direction = SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 1678 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				break;
#line 8382 "ui.c"
			}
		}
	} else if (_tmp29_ == ((0 != _tmp28_label1) ? _tmp28_label1 : (_tmp28_label1 = g_quark_from_static_string ("left-to-right")))) {
#line 1670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		switch (0) {
#line 8388 "ui.c"
			default:
			{
#line 1680 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				self->priv->default_page_scan_direction = SCAN_DIRECTION_LEFT_TO_RIGHT;
#line 1681 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				break;
#line 8395 "ui.c"
			}
		}
	} else if (_tmp29_ == ((0 != _tmp28_label2) ? _tmp28_label2 : (_tmp28_label2 = g_quark_from_static_string ("right-to-left")))) {
#line 1670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		switch (0) {
#line 8401 "ui.c"
			default:
			{
#line 1683 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				self->priv->default_page_scan_direction = SCAN_DIRECTION_RIGHT_TO_LEFT;
#line 1684 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				break;
#line 8408 "ui.c"
			}
		}
	} else {
#line 1670 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		switch (0) {
#line 8414 "ui.c"
			default:
			{
#line 1674 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				self->priv->default_page_scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 1675 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				break;
#line 8421 "ui.c"
			}
		}
	}
#line 1646 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_key_file_unref0 (f);
#line 8427 "ui.c"
}


static gint user_interface_state_get_integer (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, gint _default_) {
	gint result = 0;
	GError * _inner_error_ = NULL;
#line 1688 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1688 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (f != NULL, 0);
#line 1688 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (group_name != NULL, 0);
#line 1688 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 8442 "ui.c"
	{
		gint _tmp0_ = 0;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 1692 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = f;
#line 1692 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = group_name;
#line 1692 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = key;
#line 1692 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = g_key_file_get_integer (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 1692 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = _tmp4_;
#line 1692 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 8461 "ui.c"
			goto __catch23_g_error;
		}
#line 1692 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = _tmp0_;
#line 1692 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 8468 "ui.c"
	}
	goto __finally23;
	__catch23_g_error:
	{
		gint _tmp5_ = 0;
#line 1690 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1690 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1696 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = _default_;
#line 1696 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = _tmp5_;
#line 1696 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 8484 "ui.c"
	}
	__finally23:
#line 1690 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1690 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_clear_error (&_inner_error_);
#line 1690 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return 0;
#line 8493 "ui.c"
}


static gboolean user_interface_state_get_boolean (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, gboolean _default_) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1700 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1700 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (f != NULL, FALSE);
#line 1700 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (group_name != NULL, FALSE);
#line 1700 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 8508 "ui.c"
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 1704 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = f;
#line 1704 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = group_name;
#line 1704 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = key;
#line 1704 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = g_key_file_get_boolean (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 1704 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = _tmp4_;
#line 1704 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 8527 "ui.c"
			goto __catch24_g_error;
		}
#line 1704 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = _tmp0_;
#line 1704 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 8534 "ui.c"
	}
	goto __finally24;
	__catch24_g_error:
	{
		gboolean _tmp5_ = FALSE;
#line 1702 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1702 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1708 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = _default_;
#line 1708 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = _tmp5_;
#line 1708 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 8550 "ui.c"
	}
	__finally24:
#line 1702 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1702 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_clear_error (&_inner_error_);
#line 1702 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return FALSE;
#line 8559 "ui.c"
}


static gchar* user_interface_state_get_string (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, const gchar* _default_) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (f != NULL, NULL);
#line 1712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (group_name != NULL, NULL);
#line 1712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 1712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (_default_ != NULL, NULL);
#line 8576 "ui.c"
	{
		gchar* _tmp0_ = NULL;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 1716 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = f;
#line 1716 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = group_name;
#line 1716 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = key;
#line 1716 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = g_key_file_get_string (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 1716 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = _tmp4_;
#line 1716 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 8595 "ui.c"
			goto __catch25_g_error;
		}
#line 1716 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = _tmp0_;
#line 1716 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 8602 "ui.c"
	}
	goto __finally25;
	__catch25_g_error:
	{
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1714 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1714 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1720 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = _default_;
#line 1720 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 1720 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = _tmp6_;
#line 1720 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 8621 "ui.c"
	}
	__finally25:
#line 1714 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1714 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_clear_error (&_inner_error_);
#line 1714 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return NULL;
#line 8630 "ui.c"
}


static gboolean ___lambda3_ (UserInterface* self) {
	gboolean result = FALSE;
#line 1732 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_state (self, TRUE);
#line 1733 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->save_state_timeout = (guint) 0;
#line 1734 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = FALSE;
#line 1734 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 8644 "ui.c"
}


static gboolean ____lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda3_ (self);
#line 1730 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 8653 "ui.c"
}


static void user_interface_save_state (UserInterface* self, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GKeyFile* f = NULL;
	GKeyFile* _tmp7_ = NULL;
	GKeyFile* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GKeyFile* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GKeyFile* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GKeyFile* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	GKeyFile* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GKeyFile* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	ScanDirection _tmp20_ = 0;
	GError * _inner_error_ = NULL;
#line 1724 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1726 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = force;
#line 1726 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp0_) {
#line 8684 "ui.c"
		guint _tmp1_ = 0U;
		guint _tmp3_ = 0U;
#line 1728 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = self->priv->save_state_timeout;
#line 1728 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp1_ != ((guint) 0)) {
#line 8691 "ui.c"
			guint _tmp2_ = 0U;
#line 1729 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp2_ = self->priv->save_state_timeout;
#line 1729 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			g_source_remove (_tmp2_);
#line 8697 "ui.c"
		}
#line 1730 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda3__gsource_func, user_interface_ref (self), user_interface_unref);
#line 1730 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->save_state_timeout = _tmp3_;
#line 1736 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 8705 "ui.c"
	}
#line 1739 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = user_interface_get_state_filename (self);
#line 1739 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 1739 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = _tmp5_;
#line 1739 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_debug ("ui.vala:1739: Saving state to %s", _tmp6_);
#line 1739 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_tmp6_);
#line 1741 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = g_key_file_new ();
#line 1741 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	f = _tmp7_;
#line 1742 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = f;
#line 1742 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = self->priv->window_width;
#line 1742 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_key_file_set_integer (_tmp8_, "window", "width", _tmp9_);
#line 1743 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = f;
#line 1743 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = self->priv->window_height;
#line 1743 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_key_file_set_integer (_tmp10_, "window", "height", _tmp11_);
#line 1744 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = f;
#line 1744 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = self->priv->window_is_maximized;
#line 1744 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_key_file_set_boolean (_tmp12_, "window", "is-maximized", _tmp13_);
#line 1745 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = f;
#line 1745 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = self->priv->default_page_width;
#line 1745 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_key_file_set_integer (_tmp14_, "last-page", "width", _tmp15_);
#line 1746 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = f;
#line 1746 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = self->priv->default_page_height;
#line 1746 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_key_file_set_integer (_tmp16_, "last-page", "height", _tmp17_);
#line 1747 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = f;
#line 1747 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = self->priv->default_page_dpi;
#line 1747 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_key_file_set_integer (_tmp18_, "last-page", "dpi", _tmp19_);
#line 1748 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = self->priv->default_page_scan_direction;
#line 1748 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	switch (_tmp20_) {
#line 1748 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 8763 "ui.c"
		{
			GKeyFile* _tmp21_ = NULL;
#line 1751 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp21_ = f;
#line 1751 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			g_key_file_set_value (_tmp21_, "last-page", "scan-direction", "top-to-bottom");
#line 1752 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			break;
#line 8772 "ui.c"
		}
#line 1748 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 8776 "ui.c"
		{
			GKeyFile* _tmp22_ = NULL;
#line 1754 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp22_ = f;
#line 1754 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			g_key_file_set_value (_tmp22_, "last-page", "scan-direction", "bottom-to-top");
#line 1755 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			break;
#line 8785 "ui.c"
		}
#line 1748 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 8789 "ui.c"
		{
			GKeyFile* _tmp23_ = NULL;
#line 1757 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp23_ = f;
#line 1757 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			g_key_file_set_value (_tmp23_, "last-page", "scan-direction", "left-to-right");
#line 1758 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			break;
#line 8798 "ui.c"
		}
#line 1748 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 8802 "ui.c"
		{
			GKeyFile* _tmp24_ = NULL;
#line 1760 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp24_ = f;
#line 1760 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			g_key_file_set_value (_tmp24_, "last-page", "scan-direction", "right-to-left");
#line 1761 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			break;
#line 8811 "ui.c"
		}
		default:
#line 1748 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		break;
#line 8816 "ui.c"
	}
	{
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		GKeyFile* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp25_ = user_interface_get_state_filename (self);
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp26_ = _tmp25_;
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp27_ = _tmp26_;
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp28_ = f;
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp29_ = g_key_file_to_data (_tmp28_, NULL, NULL);
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp30_ = _tmp29_;
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_file_set_contents (_tmp27_, _tmp30_, (gssize) (-1), &_inner_error_);
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_tmp30_);
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_tmp27_);
#line 1765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 8845 "ui.c"
			goto __catch26_g_error;
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		GError* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
#line 1763 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 1763 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1769 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp31_ = e;
#line 1769 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp32_ = _tmp31_->message;
#line 1769 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_warning ("ui.vala:1769: Failed to write state: %s", _tmp32_);
#line 1763 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 8867 "ui.c"
	}
	__finally26:
#line 1763 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1763 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_key_file_unref0 (f);
#line 1763 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1763 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1763 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 8880 "ui.c"
	}
#line 1724 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_key_file_unref0 (f);
#line 8884 "ui.c"
}


static gboolean ___lambda11_ (UserInterface* self) {
	gboolean result = FALSE;
	ProgressBarDialog* _tmp0_ = NULL;
#line 1784 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 1784 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 1785 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = FALSE;
#line 1785 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 8899 "ui.c"
}


static gboolean ____lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda11_ (self);
#line 1783 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 8908 "ui.c"
}


static void user_interface_book_saving_cb (UserInterface* self, gint page_number) {
	gint total = 0;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gdouble fraction = 0.0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean complete = FALSE;
	gdouble _tmp6_ = 0.0;
	gboolean _tmp7_ = FALSE;
	gchar* message = NULL;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	ProgressBarDialog* _tmp12_ = NULL;
	gdouble _tmp13_ = 0.0;
	ProgressBarDialog* _tmp14_ = NULL;
#line 1773 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1776 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	while (TRUE) {
#line 8935 "ui.c"
		gboolean _tmp0_ = FALSE;
#line 1776 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = gtk_events_pending ();
#line 1776 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (!_tmp0_) {
#line 1776 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			break;
#line 8943 "ui.c"
		}
#line 1777 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_main_iteration ();
#line 8947 "ui.c"
	}
#line 1779 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->_book;
#line 1779 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 1779 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1779 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	total = (gint) _tmp3_;
#line 1780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page_number;
#line 1780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = total;
#line 1780 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	fraction = (_tmp4_ + 1.0) / _tmp5_;
#line 1781 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = fraction;
#line 1781 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	complete = _tmp6_ == 1.0;
#line 1782 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = complete;
#line 1782 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp7_) {
#line 1783 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda11__gsource_func, user_interface_ref (self), user_interface_unref);
#line 8973 "ui.c"
	}
#line 1787 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = _ ("Saving page %d out of %d");
#line 1787 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = page_number;
#line 1787 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = total;
#line 1787 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = g_strdup_printf (_tmp8_, _tmp9_ + 1, _tmp10_);
#line 1787 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	message = _tmp11_;
#line 1789 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = self->priv->progress_dialog;
#line 1789 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = fraction;
#line 1789 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	progress_bar_dialog_set_fraction (_tmp12_, _tmp13_);
#line 1790 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = self->priv->progress_dialog;
#line 1790 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	progress_bar_dialog_set_message (_tmp14_, message);
#line 1773 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (message);
#line 8997 "ui.c"
}


void user_interface_show_progress_dialog (UserInterface* self) {
	ProgressBarDialog* _tmp0_ = NULL;
#line 1793 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1795 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 1795 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 9009 "ui.c"
}


void user_interface_hide_progress_dialog (UserInterface* self) {
	ProgressBarDialog* _tmp0_ = NULL;
#line 1798 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1800 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 1800 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 9021 "ui.c"
}


void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 1803 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1803 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (error_title != NULL);
#line 1803 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (error_text != NULL);
#line 1805 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->have_error = TRUE;
#line 1806 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = error_title;
#line 1806 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 1806 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->error_title);
#line 1806 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->error_title = _tmp1_;
#line 1807 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = error_text;
#line 1807 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 1807 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->error_text);
#line 1807 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->error_text = _tmp3_;
#line 1808 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = change_scanner_hint;
#line 1808 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->error_change_scanner_hint = _tmp4_;
#line 1809 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_info_bar (self);
#line 9061 "ui.c"
}


void user_interface_start (UserInterface* self) {
	GtkApplicationWindow* _tmp0_ = NULL;
#line 1812 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1814 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->window;
#line 1814 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 9073 "ui.c"
}


Book* user_interface_get_book (UserInterface* self) {
	Book* result;
	Book* _tmp0_ = NULL;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 92 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->_book;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = _tmp0_;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9088 "ui.c"
}


static gpointer _book_ref0 (gpointer self) {
#line 92 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self ? book_ref (self) : NULL;
#line 9095 "ui.c"
}


static void user_interface_set_book (UserInterface* self, Book* value) {
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 92 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = value;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _book_ref0 (_tmp0_);
#line 92 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_book_unref0 (self->priv->_book);
#line 92 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->_book = _tmp1_;
#line 9112 "ui.c"
}


Page* user_interface_get_selected_page (UserInterface* self) {
	Page* result;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
#line 97 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 99 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 99 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 99 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 99 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = _tmp2_;
#line 99 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9133 "ui.c"
}


void user_interface_set_selected_page (UserInterface* self, Page* value) {
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 103 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = value;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_view_set_selected_page (_tmp0_, _tmp1_);
#line 9148 "ui.c"
}


const gchar* user_interface_get_default_file_name (UserInterface* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->_default_file_name;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = _tmp0_;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9163 "ui.c"
}


void user_interface_set_default_file_name (UserInterface* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = value;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->_default_file_name);
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->_default_file_name = _tmp1_;
#line 9180 "ui.c"
}


gboolean user_interface_get_scanning (UserInterface* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 122 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->scanning_;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = _tmp0_;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9195 "ui.c"
}


void user_interface_set_scanning (UserInterface* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	GtkMenuItem* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkMenuItem* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkToolButton* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = value;
#line 125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->scanning_ = _tmp0_;
#line 126 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->page_delete_menuitem;
#line 126 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = value;
#line 126 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, !_tmp2_);
#line 127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->stop_menuitem;
#line 127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = value;
#line 127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp4_);
#line 128 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = self->priv->stop_toolbutton;
#line 128 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = value;
#line 128 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp6_);
#line 9231 "ui.c"
}


gint user_interface_get_brightness (UserInterface* self) {
	gint result;
	GtkAdjustment* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 140 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->brightness_adjustment;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 140 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = (gint) _tmp1_;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9249 "ui.c"
}


void user_interface_set_brightness (UserInterface* self, gint value) {
	GtkAdjustment* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->brightness_adjustment;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = value;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
#line 9264 "ui.c"
}


gint user_interface_get_contrast (UserInterface* self) {
	gint result;
	GtkAdjustment* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 146 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->contrast_adjustment;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 146 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = (gint) _tmp1_;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9282 "ui.c"
}


void user_interface_set_contrast (UserInterface* self, gint value) {
	GtkAdjustment* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 147 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 147 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->contrast_adjustment;
#line 147 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = value;
#line 147 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
#line 9297 "ui.c"
}


gint user_interface_get_quality (UserInterface* self) {
	gint result;
	GtkAdjustment* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 152 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->quality_adjustment;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 152 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = (gint) _tmp1_;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9315 "ui.c"
}


void user_interface_set_quality (UserInterface* self, gint value) {
	GtkAdjustment* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->quality_adjustment;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = value;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
#line 9330 "ui.c"
}


gchar* user_interface_get_selected_device (UserInterface* self) {
	gchar* result;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->device_combo;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 9350 "ui.c"
		gchar* device = NULL;
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 165 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->device_model;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = iter;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &device, -1, -1);
#line 166 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = device;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 9364 "ui.c"
	}
#line 169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = NULL;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9370 "ui.c"
}


void user_interface_set_selected_device (UserInterface* self, const gchar* value) {
	GtkTreeIter iter = {0};
	const gchar* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
#line 172 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 175 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = value;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = user_interface_find_scan_device (self, _tmp0_, &_tmp1_);
#line 175 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp2_) {
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 9393 "ui.c"
	}
#line 178 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->device_combo;
#line 178 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = iter;
#line 178 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_combo_box_set_active_iter (_tmp3_, &_tmp4_);
#line 179 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->user_selected_device = TRUE;
#line 9403 "ui.c"
}


static gchar* user_interface_get_state_filename (UserInterface* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = g_get_user_cache_dir ();
#line 1643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_build_filename (_tmp0_, "simple-scan", "state", NULL);
#line 1643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = _tmp1_;
#line 1643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 9421 "ui.c"
}


static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_SCAN_OPTIONS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (n_param_values == 3);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data2 = param_values->data[0].v_pointer;
#line 9440 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data2 = closure->data;
#line 9446 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	callback = (GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	callback (data1, g_value_get_string (param_values + 1), value_get_scan_options (param_values + 2), data2);
#line 9452 "ui.c"
}


static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_INT) (gpointer data1, const char* arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (n_param_values == 3);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data2 = param_values->data[0].v_pointer;
#line 9471 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data2 = closure->data;
#line 9477 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	callback = (GMarshalFunc_VOID__STRING_INT) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 9483 "ui.c"
}


static void value_user_interface_init (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	value->data[0].v_pointer = NULL;
#line 9490 "ui.c"
}


static void value_user_interface_free_value (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_unref (value->data[0].v_pointer);
#line 9499 "ui.c"
	}
}


static void value_user_interface_copy_value (const GValue* src_value, GValue* dest_value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (src_value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dest_value->data[0].v_pointer = user_interface_ref (src_value->data[0].v_pointer);
#line 9509 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dest_value->data[0].v_pointer = NULL;
#line 9513 "ui.c"
	}
}


static gpointer value_user_interface_peek_pointer (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return value->data[0].v_pointer;
#line 9521 "ui.c"
}


static gchar* value_user_interface_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (collect_values[0].v_pointer) {
#line 9528 "ui.c"
		UserInterface* object;
		object = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (object->parent_instance.g_class == NULL) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 9535 "ui.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 9539 "ui.c"
		}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		value->data[0].v_pointer = user_interface_ref (object);
#line 9543 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		value->data[0].v_pointer = NULL;
#line 9547 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return NULL;
#line 9551 "ui.c"
}


static gchar* value_user_interface_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UserInterface** object_p;
	object_p = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!object_p) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 9562 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*object_p = NULL;
#line 9568 "ui.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*object_p = value->data[0].v_pointer;
#line 9572 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*object_p = user_interface_ref (value->data[0].v_pointer);
#line 9576 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return NULL;
#line 9580 "ui.c"
}


GParamSpec* param_spec_user_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecUserInterface* spec;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_USER_INTERFACE), NULL);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return G_PARAM_SPEC (spec);
#line 9594 "ui.c"
}


gpointer value_get_user_interface (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_INTERFACE), NULL);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return value->data[0].v_pointer;
#line 9603 "ui.c"
}


void value_set_user_interface (GValue* value, gpointer v_object) {
	UserInterface* old;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		value->data[0].v_pointer = v_object;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_ref (value->data[0].v_pointer);
#line 9623 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		value->data[0].v_pointer = NULL;
#line 9627 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_unref (old);
#line 9633 "ui.c"
	}
}


void value_take_user_interface (GValue* value, gpointer v_object) {
	UserInterface* old;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		value->data[0].v_pointer = v_object;
#line 9652 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		value->data[0].v_pointer = NULL;
#line 9656 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_unref (old);
#line 9662 "ui.c"
	}
}


static void user_interface_class_init (UserInterfaceClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	USER_INTERFACE_CLASS (klass)->finalize = user_interface_finalize;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_type_class_add_private (klass, sizeof (UserInterfacePrivate));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_new ("start_scan", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_SCAN_OPTIONS);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_new ("stop_scan", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_new ("email", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_INT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_INT);
#line 9680 "ui.c"
}


static void user_interface_instance_init (UserInterface * self) {
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv = USER_INTERFACE_GET_PRIVATE (self);
#line 93 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->book_uri = NULL;
#line 116 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = g_strdup ("photo");
#line 116 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->document_hint = _tmp0_;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _ ("Scanned Document.pdf");
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->_default_file_name = _tmp2_;
#line 119 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->scanning_ = FALSE;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->ref_count = 1;
#line 9706 "ui.c"
}


static void user_interface_finalize (UserInterface* obj) {
	UserInterface * self;
	Book* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Book* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_INTERFACE, UserInterface);
#line 213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->_book;
#line 213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp1_, NULL, FALSE);
#line 213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _user_interface_page_removed_cb_book_page_removed, self);
#line 214 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->_book;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp3_, NULL, FALSE);
#line 214 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _user_interface_page_added_cb_book_page_added, self);
#line 30 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->settings);
#line 32 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->builder);
#line 34 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->window);
#line 35 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->app_menu);
#line 36 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->menubar);
#line 37 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->main_vbox);
#line 38 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_image);
#line 40 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_close_button);
#line 42 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
#line 43 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_left_menuitem);
#line 44 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_right_menuitem);
#line 45 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_delete_menuitem);
#line 46 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
#line 47 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_menuitem);
#line 48 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_as_menuitem);
#line 49 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->copy_to_clipboard_menuitem);
#line 50 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_toolbutton);
#line 51 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->stop_menuitem);
#line 52 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->stop_toolbutton);
#line 54 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
#line 55 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_menu_menuitem);
#line 56 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
#line 57 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_menu_menuitem);
#line 59 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_dialog);
#line 60 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_label);
#line 61 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 62 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 64 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->device_combo);
#line 66 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_combo);
#line 67 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_combo);
#line 68 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_combo);
#line 69 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_combo);
#line 70 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_scale);
#line 71 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_scale);
#line 72 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->quality_scale);
#line 73 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->device_model);
#line 74 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_model);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_model);
#line 76 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_model);
#line 77 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_model);
#line 78 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_adjustment);
#line 79 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_adjustment);
#line 80 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->quality_adjustment);
#line 84 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 85 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 88 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->error_title);
#line 89 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->error_text);
#line 92 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_book_unref0 (self->priv->_book);
#line 93 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 107 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_autosave_manager_unref0 (self->priv->autosave_manager);
#line 109 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->book_view);
#line 116 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->document_hint);
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->_default_file_name);
#line 9842 "ui.c"
}


GType user_interface_get_type (void) {
	static volatile gsize user_interface_type_id__volatile = 0;
	if (g_once_init_enter (&user_interface_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_user_interface_init, value_user_interface_free_value, value_user_interface_copy_value, value_user_interface_peek_pointer, "p", value_user_interface_collect_value, "p", value_user_interface_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UserInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserInterface), 0, (GInstanceInitFunc) user_interface_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType user_interface_type_id;
		user_interface_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UserInterface", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&user_interface_type_id__volatile, user_interface_type_id);
	}
	return user_interface_type_id__volatile;
}


gpointer user_interface_ref (gpointer instance) {
	UserInterface* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_atomic_int_inc (&self->ref_count);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return instance;
#line 9867 "ui.c"
}


void user_interface_unref (gpointer instance) {
	UserInterface* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		USER_INTERFACE_GET_CLASS (self)->finalize (self);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 9880 "ui.c"
	}
}


ProgressBarDialog* progress_bar_dialog_construct (GType object_type, GtkApplicationWindow* parent, const gchar* title) {
	ProgressBarDialog * self = NULL;
	GtkProgressBar* _tmp0_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp1_ = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp2_ = NULL;
	GtkProgressBar* _tmp3_ = NULL;
	GtkProgressBar* _tmp4_ = NULL;
	GtkProgressBar* _tmp5_ = NULL;
	GtkProgressBar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkApplicationWindow* _tmp8_ = NULL;
	GtkProgressBar* _tmp9_ = NULL;
#line 1822 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 1822 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 1822 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = (ProgressBarDialog*) g_object_new (object_type, NULL);
#line 1824 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = (GtkProgressBar*) gtk_progress_bar_new ();
#line 1824 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp0_);
#line 1824 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->bar);
#line 1824 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->bar = _tmp0_;
#line 1825 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
#line 1825 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp1_);
#line 1825 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	hbox = _tmp1_;
#line 1826 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
#line 1826 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp2_);
#line 1826 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	vbox = _tmp2_;
#line 1827 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_hexpand ((GtkWidget*) hbox, TRUE);
#line 1829 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->bar;
#line 1829 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_progress_bar_set_text (_tmp3_, "");
#line 1830 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->bar;
#line 1830 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_progress_bar_set_show_text (_tmp4_, TRUE);
#line 1831 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = self->priv->bar;
#line 1831 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp5_, 225, 25);
#line 1832 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 250, 50);
#line 1834 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = self->priv->bar;
#line 1834 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp6_, TRUE, FALSE, (guint) 0);
#line 1835 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (hbox, (GtkWidget*) vbox, TRUE, FALSE, (guint) 0);
#line 1836 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox);
#line 1837 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = title;
#line 1837 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_title ((GtkWindow*) self, _tmp7_);
#line 1839 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = parent;
#line 1839 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) _tmp8_);
#line 1840 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER_ON_PARENT);
#line 1841 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
#line 1842 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
#line 1844 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) hbox);
#line 1845 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) vbox);
#line 1846 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = self->priv->bar;
#line 1846 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp9_);
#line 1822 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (vbox);
#line 1822 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (hbox);
#line 1822 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self;
#line 9977 "ui.c"
}


ProgressBarDialog* progress_bar_dialog_new (GtkApplicationWindow* parent, const gchar* title) {
#line 1822 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return progress_bar_dialog_construct (TYPE_PROGRESS_BAR_DIALOG, parent, title);
#line 9984 "ui.c"
}


void progress_bar_dialog_set_fraction (ProgressBarDialog* self, gdouble percent) {
	GtkProgressBar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 1849 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1851 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->bar;
#line 1851 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = percent;
#line 1851 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_progress_bar_set_fraction (_tmp0_, _tmp1_);
#line 9999 "ui.c"
}


void progress_bar_dialog_set_message (ProgressBarDialog* self, const gchar* message) {
	GtkProgressBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1854 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1854 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (message != NULL);
#line 1856 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->bar;
#line 1856 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = message;
#line 1856 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_progress_bar_set_text (_tmp0_, _tmp1_);
#line 10016 "ui.c"
}


static void progress_bar_dialog_class_init (ProgressBarDialogClass * klass) {
#line 1818 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	progress_bar_dialog_parent_class = g_type_class_peek_parent (klass);
#line 1818 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_type_class_add_private (klass, sizeof (ProgressBarDialogPrivate));
#line 1818 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_OBJECT_CLASS (klass)->finalize = progress_bar_dialog_finalize;
#line 10027 "ui.c"
}


static void progress_bar_dialog_instance_init (ProgressBarDialog * self) {
#line 1818 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv = PROGRESS_BAR_DIALOG_GET_PRIVATE (self);
#line 10034 "ui.c"
}


static void progress_bar_dialog_finalize (GObject* obj) {
	ProgressBarDialog * self;
#line 1818 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialog);
#line 1820 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->bar);
#line 1818 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_OBJECT_CLASS (progress_bar_dialog_parent_class)->finalize (obj);
#line 10046 "ui.c"
}


GType progress_bar_dialog_get_type (void) {
	static volatile gsize progress_bar_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&progress_bar_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ProgressBarDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) progress_bar_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProgressBarDialog), 0, (GInstanceInitFunc) progress_bar_dialog_instance_init, NULL };
		GType progress_bar_dialog_type_id;
		progress_bar_dialog_type_id = g_type_register_static (GTK_TYPE_WINDOW, "ProgressBarDialog", &g_define_type_info, 0);
		g_once_init_leave (&progress_bar_dialog_type_id__volatile, progress_bar_dialog_type_id);
	}
	return progress_bar_dialog_type_id__volatile;
}


gchar* get_temporary_filename (const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	gchar* filename = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
#line 1861 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 1861 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 1866 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = prefix;
#line 1866 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = extension;
#line 1866 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = g_strdup_printf ("%sXXXXXX.%s", _tmp0_, _tmp1_);
#line 1866 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	filename = _tmp2_;
#line 10082 "ui.c"
	{
		gint fd = 0;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 1870 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = filename;
#line 1870 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = g_file_open_tmp (_tmp3_, &_tmp4_, &_inner_error_);
#line 1870 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 1870 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		path = _tmp4_;
#line 1870 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		fd = _tmp5_;
#line 1870 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 10101 "ui.c"
			goto __catch27_g_error;
		}
#line 1871 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = fd;
#line 1871 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		close (_tmp6_);
#line 10108 "ui.c"
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 1868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 1868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1875 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = e;
#line 1875 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = _tmp7_->message;
#line 1875 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_warning ("ui.vala:1875: Error saving email attachment: %s", _tmp8_);
#line 1876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = NULL;
#line 1876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 1876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 1876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (filename);
#line 1876 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 10136 "ui.c"
	}
	__finally27:
#line 1868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 1868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (filename);
#line 1868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1868 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return NULL;
#line 10151 "ui.c"
	}
#line 1879 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = path;
#line 1879 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (filename);
#line 1879 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 10159 "ui.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



