/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/CafCoreTypesDoc/CAuthnAuthzCollectionDoc.h"
#include "Doc/CafCoreTypesDoc/CAuthnAuthzDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafCoreTypesXml/AuthnAuthzCollectionXml.h"
#include "Doc/DocXml/CafCoreTypesXml/AuthnAuthzXml.h"

using namespace Caf;

void AuthnAuthzCollectionXml::add(
	const SmartPtrCAuthnAuthzCollectionDoc authnAuthzCollectionDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("AuthnAuthzCollectionXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(authnAuthzCollectionDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::deque<SmartPtrCAuthnAuthzDoc> authnAuthzVal =
			authnAuthzCollectionDoc->getAuthnAuthz();
		CAF_CM_VALIDATE_STL(authnAuthzVal);

		if (! authnAuthzVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCAuthnAuthzDoc> > authnAuthzIter(authnAuthzVal);
				authnAuthzIter; authnAuthzIter++) {
				const SmartPtrCXmlElement authnAuthzXml =
					thisXml->createAndAddElement("authnAuthz");
				AuthnAuthzXml::add(*authnAuthzIter, authnAuthzXml);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCAuthnAuthzCollectionDoc AuthnAuthzCollectionXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("AuthnAuthzCollectionXml", "parse");

	SmartPtrCAuthnAuthzCollectionDoc authnAuthzCollectionDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const CXmlElement::SmartPtrCElementCollection authnAuthzChildrenXml =
			thisXml->findRequiredChildren("authnAuthz");

		std::deque<SmartPtrCAuthnAuthzDoc> authnAuthzVal;
		if (! authnAuthzChildrenXml.IsNull() && ! authnAuthzChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> authnAuthzXmlIter(*authnAuthzChildrenXml);
				authnAuthzXmlIter; authnAuthzXmlIter++) {
				const SmartPtrCXmlElement authnAuthzXml = authnAuthzXmlIter->second;
				const SmartPtrCAuthnAuthzDoc authnAuthzDoc =
					AuthnAuthzXml::parse(authnAuthzXml);
				authnAuthzVal.push_back(authnAuthzDoc);
			}
		}

		authnAuthzCollectionDoc.CreateInstance();
		authnAuthzCollectionDoc->initialize(
			authnAuthzVal);
	}
	CAF_CM_EXIT;

	return authnAuthzCollectionDoc;
}

