//
// TestSuite.System.Security.Cryptography.DESTest.cs
//
// Author:
//      Sebastien Pouliot  <sebastien@ximian.com>
//
// Copyright (C) 2004-2005 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System;
using System.Security.Cryptography;
using System.Text;

using NUnit.Framework;

namespace MonoTests.System.Security.Cryptography {

	[TestFixture]
	public class DESTest {

		// that's the long version
		internal static readonly byte[,] allWeakKeys = {
			{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00 }, // map to packed key 101010101010101
			{ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 }, // map to packed key 101010101010101
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1E, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1E, 0x1F, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1E, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1E, 0x1F, 0x1F, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1E, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1E, 0x1F, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1E, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1E, 0x1F, 0x1F, 0x1F, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1E, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1E, 0x1F, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1E, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1E, 0x1F, 0x1F, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1E, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1E, 0x1F, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1E, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0E, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0E, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0E, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0E, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0E, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0E, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0E, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0E, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0F, 0x0E, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0F, 0x0E, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0F, 0x0E, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0F, 0x0E, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0F, 0x0F, 0x0E, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0F, 0x0F, 0x0E, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0F, 0x0F, 0x0F, 0x0E }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0x1F, 0x1F, 0x1F, 0x1F, 0x0F, 0x0F, 0x0F, 0x0F }, // map to packed key 1F1F1F1F0E0E0E0E
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE0, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE0, 0xE1, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE0, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE0, 0xE1, 0xE1, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE0, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE0, 0xE1, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE0, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE0, 0xE1, 0xE1, 0xE1, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE0, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE0, 0xE1, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE0, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE0, 0xE1, 0xE1, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE0, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE0, 0xE1, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE0, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF0, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF0, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF0, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF0, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF0, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF0, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF0, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF0, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF1, 0xF0, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF1, 0xF0, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF1, 0xF0, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF1, 0xF0, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF1, 0xF1, 0xF0, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF1, 0xF1, 0xF0, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF1, 0xF1, 0xF1, 0xF0 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xE1, 0xE1, 0xE1, 0xE1, 0xF1, 0xF1, 0xF1, 0xF1 }, // map to packed key E0E0E0E0F1F1F1F1
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE }, // map to packed key FEFEFEFEFEFEFEFE
			{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }, // map to packed key FEFEFEFEFEFEFEFE
		};

		[Test]
		public void WeakKeys () 
		{
			byte[] key = new byte [8];
			for (int i=0; i < (allWeakKeys.Length >> 3); i++) {
				for (int j=0; j < key.Length; j++)
					key [j] = allWeakKeys [i,j];

				Assert.IsTrue (DES.IsWeakKey (key), i.ToString ());
			}
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void IsWeakKey_WrongKeyLength () 
		{
			byte[] key = new byte [16]; // 128 bits
			DES.IsWeakKey (key);
		}

		[Test]
#if NET_2_0
		[ExpectedException (typeof (CryptographicException))]
#else
		[ExpectedException (typeof (NullReferenceException))]
#endif
		public void IsWeakKey_Null () 
		{
			DES.IsWeakKey (null);
		}

		// that's the long version
		internal static readonly byte[,] allSemiWeakKeys = {
			{ 0x00, 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x00, 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0E }, // map to packed key 011F011F010E010E
			{ 0x01, 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0F }, // map to packed key 011F011F010E010E
			{ 0x01, 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF0 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF1 }, // map to packed key 01E001E001F101F1
			{ 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFE }, // map to packed key 01FE01FE01FE01FE
			{ 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF }, // map to packed key 01FE01FE01FE01FE
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE0, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1E, 0xE1, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE0, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE0, 0x1F, 0xE1, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE0, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1E, 0xE1, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE0, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xE1, 0x1F, 0xE1, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x00, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1E, 0x01, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x00, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x00, 0x1F, 0x01, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x00, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1E, 0x01, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x00, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0E, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x00, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0E, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0E, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0F, 0x00 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0x01, 0x1F, 0x01, 0x0F, 0x01, 0x0F, 0x01 }, // map to packed key 1F011F010E010E01
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE0, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1E, 0xE1, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE0, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE0, 0x1F, 0xE1, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE0, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1E, 0xE1, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE0, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0E, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0E, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0E, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0E, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0E, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0E, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0E, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0E, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0F, 0xF0, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0F, 0xF0, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0F, 0xF0, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0F, 0xF0, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0F, 0xF1, 0x0E, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0F, 0xF1, 0x0E, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0F, 0xF1, 0x0F, 0xF0 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xE1, 0x1F, 0xE1, 0x0F, 0xF1, 0x0F, 0xF1 }, // map to packed key 1FE01FE00EF10EF1
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F, 0xFE }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F, 0xFF }, // map to packed key 1FFE1FFE0EFE0EFE
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1E, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE0, 0x1F, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1E, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1E, 0xE1, 0x1F, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1E, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE0, 0x1F, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1E, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0x1F, 0xE1, 0x1F, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x00, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE0, 0x01, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x00, 0xE1, 0x01, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x00, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE0, 0x01, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x00, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF0, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x00, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF0, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF0, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF1, 0x00 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x01, 0xE1, 0x01, 0xF1, 0x01, 0xF1, 0x01 }, // map to packed key E001E001F101F101
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1E, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE0, 0x1F, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1E, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1E, 0xE1, 0x1F, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1E, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE0, 0x1F, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1E, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF0, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF0, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF0, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF0, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF0, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF0, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF0, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF0, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF1, 0x0E, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF1, 0x0E, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF1, 0x0E, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF1, 0x0E, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF1, 0x0F, 0xF0, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF1, 0x0F, 0xF0, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF1, 0x0F, 0xF1, 0x0E }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0x1F, 0xE1, 0x1F, 0xF1, 0x0F, 0xF1, 0x0F }, // map to packed key E01FE01FF10EF10E
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1, 0xFE }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1, 0xFF }, // map to packed key E0FEE0FEF1FEF1FE
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFE, 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFE, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x00 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01 }, // map to packed key FE01FE01FE01FE01
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1E, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFE, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1E, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFE, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFF, 0x0E, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFE, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0E }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0x1F, 0xFF, 0x1F, 0xFF, 0x0F, 0xFF, 0x0F }, // map to packed key FE1FFE1FFE0EFE0E
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE0, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFE, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE0, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFE, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFE, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFF, 0xF0, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFE, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF0 }, // map to packed key FEE0FEE0FEF1FEF1
			{ 0xFF, 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1 }, // map to packed key FEE0FEE0FEF1FEF1
		};

		[Test]
		public void SemiWeakKeys () 
		{
			byte[] key = new byte [8];
			for (int i=0; i < (allSemiWeakKeys.Length >> 3); i++) {
				for (int j=0; j < key.Length; j++)
					key [j] = allSemiWeakKeys [i,j];

				Assert.IsTrue (DES.IsSemiWeakKey (key), i.ToString ());
			}
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void IsSemiWeakKey_WrongKeyLength () 
		{
			byte[] key = new byte [16]; // 128 bits
			DES.IsSemiWeakKey (key);
		}

		[Test]
#if NET_2_0
		[ExpectedException (typeof (CryptographicException))]
#else
		[ExpectedException (typeof (NullReferenceException))]
#endif
		public void IsSemiWeakKey_Null () 
		{
			DES.IsSemiWeakKey (null);
		}

		[Test]
		public void GetKey () 
		{
			DES des = DES.Create ();
			byte[] key = des.Key;
			Assert.AreEqual (8, key.Length, "64 bits");

			// we get a copy of the key (not the original)
			string s = BitConverter.ToString (key);
			des.Clear ();
			Assert.AreEqual (s, BitConverter.ToString (key), "Copy");
		}

		[Test]
		[ExpectedException (typeof (ArgumentNullException))]
		public void SetKey_Null () 
		{
			DES des = DES.Create ();
			des.Key = null;
		}

		[Test]
		[ExpectedException (typeof (ArgumentException))]
		public void SetKey_WrongLength () 
		{
			DES des = DES.Create ();
			des.Key = new byte [16]; // 128 bits
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void SetKey_Weak () 
		{
			DES des = DES.Create ();
			des.Key = new byte[] { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void SetKey_SemiWeak () 
		{
			DES des = DES.Create ();
			des.Key = new byte[] { 0xFF, 0xE1, 0xFF, 0xE1, 0xFF, 0xF1, 0xFF, 0xF1 };
		}

		[Test]
		public void DefaultProperties () 
		{
			DES algo = DES.Create ();
			Assert.AreEqual (64, algo.BlockSize, "BlockSize");
			Assert.AreEqual (8, algo.FeedbackSize, "FeedbackSize");
			Assert.AreEqual (64, algo.KeySize, "KeySize");
			Assert.AreEqual (CipherMode.CBC, algo.Mode, "Mode");
			Assert.AreEqual (PaddingMode.PKCS7, algo.Padding, "Padding");
			Assert.AreEqual (1, algo.LegalBlockSizes.Length, "LegalBlockSizes");
			Assert.AreEqual (64, algo.LegalBlockSizes [0].MaxSize, "LegalBlockSizes.MaxSize");
			Assert.AreEqual (64, algo.LegalBlockSizes [0].MinSize, "LegalBlockSizes.MinSize");
			Assert.AreEqual (0, algo.LegalBlockSizes [0].SkipSize, "LegalBlockSizes.SkipSize");
			Assert.AreEqual (1, algo.LegalKeySizes.Length, "LegalKeySizes");
			Assert.AreEqual (64, algo.LegalKeySizes [0].MaxSize, "LegalKeySizes.MaxSize");
			Assert.AreEqual (64, algo.LegalKeySizes [0].MinSize, "LegalKeySizes.MinSize");
			Assert.AreEqual (0, algo.LegalKeySizes [0].SkipSize, "LegalKeySizes.SkipSize");
		}
	}

	// Test vectors from FIPS 81 - DES Modes of Operations
	// http://csrc.nist.gov/publications/fips/fips81/fips81.htm
	//
	// Note: they are to be called from specifics implementations -
	//   not for the abstract DES. Thats why they are in a separate class
	//   which doesn't have a [TestFixture] attribute
	public abstract class DESFIPS81Test {
		protected DES des;

		// Table B1 - ECB Mode
		[Test]
		public void FIPS81_ECBMode () 
		{
			byte[] plaintext = Encoding.ASCII.GetBytes ("Now is the time for all ");
			byte[] result = new byte [24];

			des.Key = new byte[] { 0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF };
			des.Mode = CipherMode.ECB;
			des.Padding = PaddingMode.None;
			ICryptoTransform encrypt = des.CreateEncryptor ();

			encrypt.TransformBlock (plaintext, 0, 8, result, 0);
			Assert.AreEqual ("3F-A4-0E-8A-98-4D-48-15", BitConverter.ToString (result, 0, 8), "Encrypt Block 1");

			encrypt.TransformBlock (plaintext, 8, 8, result, 8);
			Assert.AreEqual ("6A-27-17-87-AB-88-83-F9", BitConverter.ToString (result, 8, 8), "Encrypt Block 2");

			encrypt.TransformBlock (plaintext, 16, 8, result, 16);
			Assert.AreEqual ("89-3D-51-EC-4B-56-3B-53", BitConverter.ToString (result, 16, 8), "Encrypt Block 3");

			ICryptoTransform decrypt = des.CreateDecryptor ();
			
			byte[] decrypted = new byte [24]; // MS cannot *always* reuse buffers
			decrypt.TransformBlock (result, 0, 8, decrypted, 0);
			Assert.AreEqual ("Now is t", Encoding.ASCII.GetString (decrypted, 0, 8), "Decrypt Block 1");

			decrypt.TransformBlock (result, 8, 8, decrypted, 8);
			Assert.AreEqual ("he time ", Encoding.ASCII.GetString (decrypted, 8, 8), "Decrypt Block 2");

			decrypt.TransformBlock (result, 16, 8, decrypted, 16);
			Assert.AreEqual ("for all ", Encoding.ASCII.GetString (decrypted, 16, 8), "Decrypt Block 3");
		}

		// Table C1 - CBC Mode
		[Test]
		public void FIPS81_CBCMode () 
		{
			byte[] plaintext = Encoding.ASCII.GetBytes ("Now is the time for all ");
			byte[] result = new byte [24];

			des.Key = new byte[] { 0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF };
			des.IV = new byte[] { 0x12, 0x34, 0x56, 0x78, 0x90, 0xAB, 0xCD, 0xEF };
			des.Mode = CipherMode.CBC;
			des.Padding = PaddingMode.None;
			ICryptoTransform encrypt = des.CreateEncryptor ();

			encrypt.TransformBlock (plaintext, 0, 8, result, 0);
			Assert.AreEqual ("E5-C7-CD-DE-87-2B-F2-7C", BitConverter.ToString (result, 0, 8), "Encrypt Block 1");

			encrypt.TransformBlock (plaintext, 8, 8, result, 8);
			Assert.AreEqual ("43-E9-34-00-8C-38-9C-0F", BitConverter.ToString (result, 8, 8), "Encrypt Block 2");

			byte[] final = encrypt.TransformFinalBlock (plaintext, 16, 8);
			Buffer.BlockCopy (final, 0, result, 16, 8);
			Assert.AreEqual ("68-37-88-49-9A-7C-05-F6", BitConverter.ToString (result, 16, 8), "Encrypt Block 3");

			ICryptoTransform decrypt = des.CreateDecryptor ();
			
			decrypt.TransformBlock (result, 0, 8, result, 0);
			Assert.AreEqual ("Now is t", Encoding.ASCII.GetString (result, 0, 8), "Decrypt Block 1");

			decrypt.TransformBlock (result, 8, 8, result, 8);
			Assert.AreEqual ("he time ", Encoding.ASCII.GetString (result, 8, 8), "Decrypt Block 2");

			final = decrypt.TransformFinalBlock (result, 16, 8);
			Assert.AreEqual ("for all ", Encoding.ASCII.GetString (final), "Decrypt Block 3");
		}

		// Table D2 - CFB Mode 8 bits
		[Test]
		public void FIPS81_CFB8Mode () 
		{
			byte[] plaintext = Encoding.ASCII.GetBytes ("Now is theXXXXXX"); // padding
			byte[] result = new byte [16];

			des.Key = new byte[] { 0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF };
			des.IV = new byte[] { 0x12, 0x34, 0x56, 0x78, 0x90, 0xAB, 0xCD, 0xEF };
			des.Mode = CipherMode.CFB;
			des.Padding = PaddingMode.None;
			des.FeedbackSize = 8;
			ICryptoTransform encrypt = des.CreateEncryptor ();

			encrypt.TransformBlock (plaintext, 0, 8, result, 0);
			Assert.AreEqual ("F3-1F-DA-07-01-14-62-EE", BitConverter.ToString (result, 0, 8), "Encrypt Block 1");

			byte[] final = encrypt.TransformFinalBlock (plaintext, 8, 8);
			Buffer.BlockCopy (final, 0, result, 8, 8);
			Assert.AreEqual ("18-7F", BitConverter.ToString (final).Substring (0, 5), "Encrypt Block 2");

			ICryptoTransform decrypt = des.CreateDecryptor ();
			
			decrypt.TransformBlock (result, 0, 8, result, 0);
			Assert.AreEqual ("Now is t", Encoding.ASCII.GetString (result, 0, 8), "Decrypt Block 1");

			final = decrypt.TransformFinalBlock (result, 8, 8);
			Assert.AreEqual ("he", Encoding.ASCII.GetString (final, 0, 2), "Decrypt Block 2");
		}
	}
}
