/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.ChopBoxConnector;
import org.jhotdraw.util.Geom;

public class ChopDiamondConnector
extends ChopBoxConnector {
    private static final long serialVersionUID = -1461450322512395462L;

    public ChopDiamondConnector() {
    }

    public ChopDiamondConnector(Figure figure) {
        super(figure);
    }

    protected Point chop(Figure figure, Point point) {
        Rectangle rectangle = figure.displayBox();
        Point point2 = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        Point point3 = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
        Point point4 = new Point(rectangle.x + rectangle.width / 2, rectangle.y);
        if (rectangle.contains(point)) {
            if (point.y > rectangle.y && point.y < rectangle.y + rectangle.height / 2) {
                return point3;
            }
            return point4;
        }
        double d = Geom.pointToAngle(rectangle, point);
        Point point5 = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
        Point point6 = new Point(rectangle.x, rectangle.y + rectangle.height / 2);
        Point point7 = null;
        if (d > 0.0 && d < 1.57) {
            point7 = Geom.intersect(point5.x, point5.y, point3.x, point3.y, point2.x, point2.y, point.x, point.y);
        } else if (d > 1.575 && d < 3.14) {
            point7 = Geom.intersect(point3.x, point3.y, point6.x, point6.y, point2.x, point2.y, point.x, point.y);
        } else if (d > -3.14 && d < -1.575) {
            point7 = Geom.intersect(point6.x, point6.y, point4.x, point4.y, point2.x, point2.y, point.x, point.y);
        } else if (d > -1.57 && d < 0.0) {
            point7 = Geom.intersect(point4.x, point4.y, point5.x, point5.y, point2.x, point2.y, point.x, point.y);
        }
        if (point7 == null) {
            point7 = Geom.angleToPoint(rectangle, d);
        }
        return point7;
    }
}

