/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.net.URL;
import javax.swing.ImageIcon;

public class Images {
    private Images() {
    }

    public static Image createImage(Class clazz, String string) {
        URL uRL = clazz.getResource(string);
        if (uRL == null) {
            throw new InternalError("Ressource \"" + string + "\" not found for class " + clazz);
        }
        Image image = Toolkit.getDefaultToolkit().createImage(uRL);
        return image;
    }

    public static Image createImage(URL uRL) {
        Image image = Toolkit.getDefaultToolkit().createImage(uRL);
        return image;
    }

    public static BufferedImage toBufferedImage(RenderedImage renderedImage) {
        BufferedImage bufferedImage;
        if (renderedImage instanceof BufferedImage) {
            bufferedImage = (BufferedImage)renderedImage;
        } else {
            Raster raster = renderedImage.getData();
            WritableRaster writableRaster = WritableRaster.createWritableRaster(raster.getSampleModel(), null);
            renderedImage.copyData(writableRaster);
            bufferedImage = new BufferedImage(renderedImage.getColorModel(), writableRaster, renderedImage.getColorModel().isAlphaPremultiplied(), null);
        }
        return bufferedImage;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = null;
        if (System.getProperty("java.version").startsWith("1.4.1_")) {
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        } else {
            boolean bl;
            try {
                bl = Images.hasAlpha(image);
            }
            catch (IllegalAccessError illegalAccessError) {
                bl = true;
            }
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            try {
                int n = 1;
                if (bl) {
                    n = 3;
                }
                GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
                GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
                bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bufferedImage == null) {
                int n = 1;
                if (bl) {
                    n = 2;
                }
                bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
            }
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    public static BufferedImage[] split(Image image, int n, boolean bl) {
        BufferedImage bufferedImage = Images.toBufferedImage(image);
        if (n == 1) {
            return new BufferedImage[]{bufferedImage};
        }
        BufferedImage[] bufferedImageArray = new BufferedImage[n];
        for (int i = 0; i < n; ++i) {
            bufferedImageArray[i] = bl ? bufferedImage.getSubimage(bufferedImage.getWidth() / n * i, 0, bufferedImage.getWidth() / n, bufferedImage.getHeight()) : bufferedImage.getSubimage(0, bufferedImage.getHeight() / n * i, bufferedImage.getWidth(), bufferedImage.getHeight() / n);
        }
        return bufferedImageArray;
    }
}

