/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import org.jhotdraw.contrib.ChopDiamondConnector;
import org.jhotdraw.contrib.PolygonFigure;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.framework.Connector;

public class DiamondFigure
extends RectangleFigure {
    public DiamondFigure() {
        super(new Point(0, 0), new Point(0, 0));
    }

    public DiamondFigure(Point point, Point point2) {
        super(point, point2);
    }

    protected Polygon getPolygon() {
        Rectangle rectangle = this.displayBox();
        Polygon polygon = new Polygon();
        polygon.addPoint(rectangle.x, rectangle.y + rectangle.height / 2);
        polygon.addPoint(rectangle.x + rectangle.width / 2, rectangle.y);
        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
        polygon.addPoint(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
        return polygon;
    }

    public void drawBackground(Graphics graphics) {
        Polygon polygon = this.getPolygon();
        graphics.fillPolygon(polygon);
    }

    public void drawFrame(Graphics graphics) {
        Polygon polygon = this.getPolygon();
        graphics.drawPolygon(polygon);
    }

    public Insets connectionInsets() {
        Rectangle rectangle = this.displayBox();
        return new Insets(rectangle.height / 2, rectangle.width / 2, rectangle.height / 2, rectangle.width / 2);
    }

    public boolean containsPoint(int n, int n2) {
        return this.getPolygon().contains(n, n2);
    }

    public Point chop(Point point) {
        return PolygonFigure.chop(this.getPolygon(), point);
    }

    public Connector connectorAt(int n, int n2) {
        return new ChopDiamondConnector(this);
    }
}

