# Copyright (c) 2014 Rackspace Hosting
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
from designate.objects import base


class Tld(base.DictObjectMixin, base.PersistentObjectMixin,
          base.DesignateObject):
    FIELDS = {
        'name': {
            'schema': {
                'type': 'string',
                'format': 'tldname',
                'maxLength': 255,
            },
            'immutable': True,
            'required': True
        },
        'description': {
            'schema': {
                'type': ['string', 'null'],
                'maxLength': 160
            },
        }
    }

    STRING_KEYS = [
        'id', 'name'
    ]


class TldList(base.ListObjectMixin, base.DesignateObject):
    LIST_ITEM_TYPE = Tld

    def __contains__(self, key):
        return bool(list(filter(lambda tld: tld.name == key, self.objects)))
