#ifndef __ROCCAT_SOVA_H__
#define __ROCCAT_SOVA_H__

/*
 * This file is part of roccat-tools.
 *
 * roccat-tools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * roccat-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with roccat-tools. If not, see <http://www.gnu.org/licenses/>.
 */

#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

#define USB_DEVICE_ID_ROCCAT_SOVA 0x2f76
#define USB_DEVICE_ID_ROCCAT_SOVA_MK 0x2f94

#define SOVA_DEVICE_NAME "Sova"
#define SOVA_DEVICE_NAME_MEMBRANE "Sova membrane"
#define SOVA_DEVICE_NAME_MK "Sova MK"
#define SOVA_DEVICE_NAME_COMBINED "Sova membrane/MK"

enum {
	SOVA_PROFILE_NUM = 5,
	SOVA_KEYS_FUNCTION_NUM = 15,
	SOVA_KEYS_PRIMARY_NUM = 144,
	SOVA_MACRO_NUM = 40,
};

typedef enum {
	SOVA_REPORT_ID_MULTIMEDIA = 0x02, /* ro */
	SOVA_REPORT_ID_SPECIAL = 0x03, /* ro */
	SOVA_REPORT_ID_CONTROL = 0x04, /* rw */
	SOVA_REPORT_ID_PROFILE = 0x05, /* rw */
	SOVA_REPORT_ID_KEYS_PRIMARY = 0x06, /* rw */
	SOVA_REPORT_ID_KEYS_FUNCTION = 0x07, /* rw */
	SOVA_REPORT_ID_KEYS_EXTRA = 0x0a, /* rw */
	SOVA_REPORT_ID_KEYS_EASYZONE = 0x0b, /* rw */
	SOVA_REPORT_ID_KEY_MASK = 0x0c, /* rw */
	SOVA_REPORT_ID_LIGHT = 0x0d, /* rw */
	SOVA_REPORT_ID_MACRO = 0x0e, /* rw */
	SOVA_REPORT_ID_INFO = 0x0f, /* ro */
	SOVA_REPORT_ID_RESET = 0x11, /* ro */
	SOVA_REPORT_ID_LIGHT_CONTROL = 0x13, /* wo */
	SOVA_REPORT_ID_TALK = 0x16, /* rw */
} SovaReportId;


typedef enum {
	SOVA_KEY_TYPE_DISABLED = 0x00,
	
	SOVA_KEY_TYPE_MULTIMEDIA_MUTE_MICROPHONE = 0x73,
	SOVA_KEY_TYPE_FOLDER_DESKTOP = 0x74,
	SOVA_KEY_TYPE_FOLDER_FAVORITES = 0x75,
	SOVA_KEY_TYPE_FOLDER_FONTS = 0x76,
	SOVA_KEY_TYPE_FOLDER_MY_DOCUMENTS = 0x77,
	SOVA_KEY_TYPE_FOLDER_MY_DOWNLOADS = 0x78,
	SOVA_KEY_TYPE_FOLDER_MY_MUSIC = 0x79,
	SOVA_KEY_TYPE_FOLDER_MY_PICTURES = 0x7a,
	SOVA_KEY_TYPE_FOLDER_MY_NETWORK = 0x7b,
	SOVA_KEY_TYPE_FOLDER_PRINTERS = 0x7c,
	SOVA_KEY_TYPE_FOLDER_SYSTEM = 0x7d,
	
	SOVA_KEY_TYPE_SYSTEM_SHUTDOWN = 0x81,
	SOVA_KEY_TYPE_SYSTEM_SLEEP = 0x82,
	SOVA_KEY_TYPE_SYSTEM_WAKE = 0x83,
	
	SOVA_KEY_TYPE_TALK_EASYSHIFT_ALL = 0x8c,
	
	SOVA_KEY_TYPE_SYSTEM_HIBERNATE = 0x9f,
	SOVA_KEY_TYPE_SYSTEM_REBOOT = 0xa0,
	SOVA_KEY_TYPE_SYSTEM_LOCK = 0xa1,
	SOVA_KEY_TYPE_SYSTEM_LOGOFF = 0xa2,
	SOVA_KEY_TYPE_LIGHT = 0xa3,
	
	SOVA_KEY_TYPE_BROWSER_NEW_TAB = 0xa5,
	SOVA_KEY_TYPE_BROWSER_NEW_WINDOW = 0xa6,
	SOVA_KEY_TYPE_RECORD = 0xa7,
	SOVA_KEY_TYPE_SYSTEM_CONTROL_PANEL = 0xa8,
	SOVA_KEY_TYPE_SYSTEM_SYSTEM_PANEL = 0xa9,
	SOVA_KEY_TYPE_SYSTEM_TASK_MANAGER = 0xaa,
	SOVA_KEY_TYPE_SYSTEM_SCREEN_SETTINGS = 0xab,
	SOVA_KEY_TYPE_SYSTEM_SCREENSAVER = 0xac,
	SOVA_KEY_TYPE_SYSTEM_THEMES = 0xad,
	SOVA_KEY_TYPE_SYSTEM_DATE_TIME = 0xae,
	SOVA_KEY_TYPE_SYSTEM_NETWORK_SETTINGS = 0xaf,
	SOVA_KEY_TYPE_PROFILE_UP = 0xb0,
	SOVA_KEY_TYPE_PROFILE_DOWN = 0xb1,
	SOVA_KEY_TYPE_PROFILE_CYCLE = 0xb2,
	// FIXME profile n 0xb3-7?
	SOVA_KEY_TYPE_SHORTCUT = 0xb8,
	SOVA_KEY_TYPE_OPEN_APP = 0xb9,
	// FIXME macro play/pause 0xba?
	
	SOVA_KEY_TYPE_TIMER = 0xbc,
	SOVA_KEY_TYPE_TIMER_STOP = 0xbd,
	SOVA_KEY_TYPE_MACRO = 0xbe,
	
	SOVA_KEY_TYPE_APP_EMAIL = 0xc0,
	SOVA_KEY_TYPE_APP_CALCULATOR = 0xc1,
	SOVA_KEY_TYPE_APP_MY_COMPUTER = 0xc2,
	SOVA_KEY_TYPE_APP_BROWSER = 0xc3,
	SOVA_KEY_TYPE_BROWSER_SEARCH = 0xc4,
	SOVA_KEY_TYPE_BROWSER_HOME = 0xc5,
	SOVA_KEY_TYPE_BROWSER_BACK = 0xc6,
	SOVA_KEY_TYPE_BROWSER_FORWARD = 0xc7,
	SOVA_KEY_TYPE_BROWSER_STOP = 0xc8,
	SOVA_KEY_TYPE_BROWSER_REFRESH = 0xc9,
	// FIXME favorites 0xca?
	SOVA_KEY_TYPE_MULTIMEDIA_OPEN_PLAYER = 0xcb,
	SOVA_KEY_TYPE_MULTIMEDIA_PLAY_PAUSE = 0xcc,
	SOVA_KEY_TYPE_MULTIMEDIA_NEXT_TRACK = 0xcd,
	SOVA_KEY_TYPE_MULTIMEDIA_PREVIOUS_TRACK = 0xce,
	SOVA_KEY_TYPE_MULTIMEDIA_STOP = 0xcf,
	SOVA_KEY_TYPE_MULTIMEDIA_VOLUME_UP = 0xd0,
	SOVA_KEY_TYPE_MULTIMEDIA_VOLUME_DOWN = 0xd1,
	SOVA_KEY_TYPE_MULTIMEDIA_MUTE_MASTER_VOLUME = 0xd2,
	
	SOVA_KEY_TYPE_OPEN_DRIVER = 0xdd,
	
	SOVA_KEY_TYPE_SYSTEM_ADMIN_PANEL = 0xe8,
	SOVA_KEY_TYPE_SYSTEM_WINDOWS_FIREWALL = 0xe9,
	SOVA_KEY_TYPE_SYSTEM_REGEDIT = 0xea,
	SOVA_KEY_TYPE_SYSTEM_EVENT_MONITOR = 0xeb,
	SOVA_KEY_TYPE_SYSTEM_PERFORMANCE_MONITOR = 0xec,
	SOVA_KEY_TYPE_SYSTEM_SOUND_SETTINGS = 0xed,
	SOVA_KEY_TYPE_SYSTEM_INTERNET_SETTINGS = 0xee,
	SOVA_KEY_TYPE_SYSTEM_DIRECTX_DIAG = 0xef,
	SOVA_KEY_TYPE_APP_COMMANDLINE = 0xf0,
	
	SOVA_KEY_TYPE_OPEN_DOCUMENT = 0xf2,
	SOVA_KEY_TYPE_OPEN_FOLDER = 0xf3,
	SOVA_KEY_TYPE_OPEN_WEBSITE = 0xf4,
	// FIXME easyshift 0xf5?
	// FIXME easyshift_lock 0xf6?
	// FIXME easyaim 1-5 0xf7-b?
	SOVA_KEY_TYPE_EASYSHIFT = 0xff,
} SovaKeyType;

G_END_DECLS

#endif
