/*
 * This file is part of roccat-tools.
 *
 * roccat-tools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Macro Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * roccat-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Macro Public License for more details.
 *
 * You should have received a copy of the GNU Macro Public License
 * along with roccat-tools. If not, see <http://www.gnu.org/licenses/>.
 */

#include "ryos_driver_state.h"
#include "ryos_device.h"

typedef struct _RyosDriverState RyosDriverState;

struct _RyosDriverState {
	guint8 report_id; /* RYOS_REPORT_ID_DRIVER_STATE */
	guint8 size; /* always 0x03 */
	guint8 state;
} __attribute__ ((packed));

gboolean ryos_driver_state_write(RoccatDevice *ryos, guint state, GError **error) {
	RyosDriverState driver_state;

	driver_state.report_id = RYOS_REPORT_ID_DRIVER_STATE;
	driver_state.size = sizeof(RyosDriverState);
	driver_state.state = state;

	return ryos_device_write(ryos, (gchar const *)&driver_state, sizeof(RyosDriverState), error);
}
