# Stefan Achatz 2012
#
# Tries to find libdbus-glib-1 and sets following variables according to found capabilities:
#
# DBUS-GLIB_FOUND
# DBUS-GLIB_INCLUDE_DIRS
# DBUS-GLIB_LIBRARIES

FIND_PACKAGE(PkgConfig REQUIRED)
PKG_CHECK_MODULES(PKG_DBUS-GLIB dbus-glib-1)

FIND_PATH(DBUS-GLIB_INCLUDE_DIRS dbus/dbus-glib.h
  HINTS
    ${PKG_DBUS-GLIB_INCLUDE_DIRS}
    ${PKG_DBUS-GLIB_INCLUDEDIR}
  PATH_SUFFIXES dbus-1.0
)

FIND_LIBRARY(DBUS-GLIB_LIBRARIES dbus-glib-1
  HINTS ${PKG_DBUS-GLIB_LIBRARY_DIRS}
)

IF(DBUS-GLIB_LIBRARIES AND DBUS-GLIB_INCLUDE_DIRS)
  SET(DBUS-GLIB_FOUND true)
ENDIF()

IF(DBUS-GLIB_FIND_REQUIRED AND NOT DBUS-GLIB_FOUND)
  MESSAGE(FATAL_ERROR "Could not find DBUS-GLIB")
ENDIF()
