;;
;; kern-mk-composite-map
;;     with grid chunks of 32 x 32 tiles size
;;     4 across, 4 down
;; 
;; +----------------------+ +----------------------+ +----------------------+ +----------------------+
;; |  Grid XY=(0,0)       | |  Grid XY=(1,0)       | |  Grid XY=(2,0)       | |  Grid XY=(3,0)       |
;; |NW=  0,0    NE= 31,0  | |NW= 32,0    NE= 63,0  | |NW= 64,0    NE= 95,0  | |NW= 96,0    NE=127,0  |
;; |                      | |                      | |                      | |                      |
;; |SW=  0,31   SE= 31,31 | |SW= 32,31   SE= 63,31 | |SW= 64,31   SE= 95,31 | |SW= 96,31   SE=127,31 |
;; +----------------------+ +----------------------+ +----------------------+ +----------------------+
;; 
;; +----------------------+ +----------------------+ +----------------------+ +----------------------+
;; |  Grid XY=(0,1)       | |  Grid XY=(1,1)       | |  Grid XY=(2,1)       | |  Grid XY=(3,1)       |
;; |NW=  0,32   NE= 31,32 | |NW= 32,32   NE= 63,32 | |NW= 64,32   NE= 95,32 | |NW= 96,32   NE=127,32 |
;; |                      | |                      | |                      | |                      |
;; |SW=  0,63   SE= 31,63 | |SW= 32,63   SE= 63,63 | |SW= 64,63   SE= 95,63 | |SW= 96,63   SE=127,63 |
;; +----------------------+ +----------------------+ +----------------------+ +----------------------+
;; 
;; +----------------------+ +----------------------+ +----------------------+ +----------------------+
;; |  Grid XY=(0,2)       | |  Grid XY=(1,2)       | |  Grid XY=(2,2)       | |  Grid XY=(3,2)       |
;; |NW=  0,64   NE= 31,64 | |NW= 32,64   NE= 63,64 | |NW= 64,64   NE= 95,64 | |NW= 96,64   NE=127,64 |
;; |                      | |                      | |                      | |                      |
;; |SW=  0,95   SE= 31,95 | |SW= 32,95   SE= 63,95 | |SW= 64,95   SE= 95,95 | |SW= 96,95   SE=127,95 |
;; +----------------------+ +----------------------+ +----------------------+ +----------------------+
;; 
;; +----------------------+ +----------------------+ +----------------------+ +----------------------+
;; |  Grid XY=(0,3)       | |  Grid XY=(1,3)       | |  Grid XY=(2,3)       | |  Grid XY=(3,3)       |
;; |NW=  0,96   NE= 31,96 | |NW= 32,96   NE= 63,96 | |NW= 64,96   NE= 95,96 | |NW= 96,96   NE=127,96 |
;; |                      | |                      | |                      | |                      |
;; |SW=  0,127  SE= 31,127| |SW= 32,127  SE= 63,127| |SW= 64,127  SE= 95,127| |SW= 96,127  SE=127,127|
;; +----------------------+ +----------------------+ +----------------------+ +----------------------+


(kern-mk-composite-map
    'm_shard     4 4
	(kern-mk-map nil 32 32 pal_expanded
		(list   ;; Block 0,0 -- NW=(0,0) SE=(31,31)
			"*. *. *. *. ** ** *. *. ** *. *. *. *. ** *. ** ** ** *. *. *. ** ** *. *. ** *. *. ** ** ** ** "
			"** ** ** ** ** ** *. *. ** ** ** ** ** *. ** *. ** ** *. *. *. *. ** ** ** ** *. ** ** *. ** ** "
			"** *. *. *. *. *. *. *. *. *. *. ** ** ** ** *. ** ** ** ** ** ** ** ** ** ** *. ** *. *. ** ** "
			"*. ** *. *. *. ** ** ** *. ** *. ** ** ** ** *. ** *. ** ** ** *. *. ** *. ** ** ** *. *. *. *. "
			"*. *. *. ** ** *. *. *. *. ** ** ** ** ** ** *. ** ** ** ** *. ** ** *. ** *. *. ** ** ** *. ** "
			"** *. ** *. ** ** ** *. ** ** ** ** *. *8 *8 *8 *8 *8 *8 *8 *8 *8 *8 ** ** ** ** ** ** ** ** *. "
			"** *. *. ** ** ** *. *. ** *. *. *c ^g ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^h *a *. ** ** *. *. ** ** "
			"** *. ** ** ** *. ** ** *. ** ^g ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^h *a ** *. *. *. ** *. "
			"*. ** ** *. *. *. *. *. *. *4 ^^ ^^ ^^ .! ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^h *a *8 *. ** ** *. "
			"*. ** ** ** ** ** ** ** *. *c ^^ ^c tb tt td ^a ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^h *a ** ** "
			"** ** ** *. ** ** *. *. ** ^g ^^ %b %5 tt %b %d ^a ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^h *. ** "
			"*. *. ** ** *. *. ** *. *4 ^^ ^^ t7 %% ta tt tt tt t5 ^a ^^ ^^ ^^ ^^ ^^ ^c %3 %% %5 ^a ^^ *a ** "
			"*. ** *. ** *. ** ** *. *c ^^ ^^ tt %% %5 ta tt tt tt tt tt tt tt tt tt td %% -7 %% %5 ^^ ^h *a "
			"** *. *. ** ** *. ** *. ^g ^^ ^c te %% %c ^3 ^^ ^d tt tt tc %3 %% %5 te %3 -b -- -d %% ^^ ^^ ^^ "
			"*. *. *. *. ** ** ** *4 ^^ ^^ t7 %3 %c ^3 ^^ ^c %7 ta tt %3 %c ^7 %a %% %% %% -e %% %c ^^ ^^ ^^ "
			"*. ** *. *. *. ** ** *4 ^^ ^^ tt %% ^b ^^ ^c %3 %% %d tt %% ^b ^^ ^d %% t7 %a %% %c {B {{ ^^ tf "
			"** ** *. ** *. *. ** *4 ^^ ^^ te %a %% %% %% %% %% ^f tt %a %5 ^e %3 %c tt tt tt td %7 {E t7 {E "
			"*. *. ** *. ** ** ** *4 ^^ ^^ ^5 t7 ^f %% %% %% %% tb tt t5 %a %% %c t3 tt tt tt %3 %% %d tt %3 "
			"** *. ** *. ** ** ** ** ^j ^^ ^^ te %3 %c ^3 ^5 %% %5 ta tt tt tt tt tc t& tt tt %a %c t3 tt %% "
			"*. *. ** ** ** ** *. *. *5 ^^ ^^ ^5 %% ^b ^^ ^^ %% %% %5 t% ta tt tt %3 %5 ta tt tt tt tt tc %a "
			"*. ** ** ** ** ** ** *. *4 ^^ ^^ ^c %% %5 ^^ ^c %% %% %% ^7 t% tt tc %% %% %5 t% tt {# {{ {% t3 "
			"** *. *. ** *. ** ** *. *4 ^^ ^^ %3 %% %% ^^ %3 %% %% %c {1 tC tt %3 %c ^7 %a %5 tt {{ {{ {{ tt "
			"*. ** ** *. *. ** *. ** *4 ^^ ^^ %% ^f %% ^^ %a %% %% tb tt tt tt %% ^b ^^ ^d %% te {A {{ {C te "
			"** *. ** ** *. *. ** *. *4 ^^ ^^ %a %% %% ^^ ^5 %% %% %% %5 ta tt %a %d ^e %3 %% %5 tb tt td %3 "
			"** ** ** ** *. ** *. *. ** ^j ^^ ^5 %a %% ^a ^c %% %% -7 %% %5 tt tt t5 %b %% %% %% %5 te %3 %% "
			"*. ** *. *. *. *. *. *. *. *5 ^j ^^ ^5 %a %% %% %% -b -- -d %% tt ^f tt tt tt t5 %% %% %% %% -b "
			"*. ** *. ** *. ** *. *. *. *. *5 ^^ ^^ ^^ ^5 %a %% %% -e %% %c tt tt tt tt tt tt %% %c ^7 %a %% "
			"** *. ** ** ** ** *. *. *. *. *. ^j ^^ ^^ ^^ ^5 t7 %a %% %c t3 tc %3 %% %5 ta tt %e ^b ^^ ^d %a "
			"** ** *. *. *. ** *. *. *. ** *. ** *1 *5 ^^ ^^ ta tt tt tt tt %3 %% -7 %% %5 tt t5 %7 ^e %7 t3 "
			"** *. *. *. ** ** *. *. *. ** *. ** *. *4 ^^ ^^ {2 .. .. t% tt %% -b -- -d %% tt tt %a %% %c tt "
			"*. *. ** *. ** ** ** *. *. *. ** ** *. *4 ^^ ^^ {a .. .. .. tt %a %% -e %% %c tt tt tt tt tt tc "
			"** *. ** ** *. *. ** *. *. *. *. *. *. *4 ^^ ^^ {{ {a {8 .. ta t5 %a %% %c t3 tc t# {8 {8 .. .. "
		))
	(kern-mk-map nil 32 32 pal_expanded
		(list   ;; Block 1,0 -- NW=(32,0) SE=(63,31)
			"** *. ** ** ** ** ** *. *. ** ** ** *. *. ** *. *. *. ** ** ** *. ** *. *. *. *. ** *. *. *. *. "
			"** *. ** *. ** *. ** *. *. ** ** ** ** ** *. ** ** *. *. *. *. *. ** *. ** ** *. *. *. ** *. *. "
			"** ** *. *. *. *. ** *. *. ** ** *. *. ** ** ** *. *. *. *. *. ** *. ** ** ** ** *. ** *. *. *. "
			"** *. ** ** *. *. *. *. ** ** *. *. *. ** *. *. *. *8 *8 *8 ** ** ** *. *. *. ** *. ** ** ** ** "
			"** *. *. ** ** *. *. ** ** ** ** *. *. ** ** *c ^g ^^ .. ^^ ^h *a ** ** ** ** ** *. *. ** *. *. "
			"** ** ** *. *. *. *. *. ** ** ** ** *. *. ** ^g ^^ {{ {6 {{ ^^ ^h ** ** *. *. *. *. ** *. ** ** "
			"*. *. *. ** *. ** *. *. ** ** *. *. *. *. *4 ^^ {{ {3 .. {5 {{ ^^ *2 ** ** ** *. ** ** ** *. ** "
			"*. *. *. ** ** ** *. *. ** ** *. ** ** *. ** ^j {{ {a .. {c ^^ ^l *. ** *. ** ** *. *. ** *. *. "
			"*. ** ** *. *. *. *. ** *. *. ** *. ** ** *. *5 {j {{ {e ^^ ^l *3 *. *. *. ** *. ** ** ** ** ** "
			"** ** *. *. *. ** *. ** ** ** ** *. *. ** *. *. *5 {j {{ {l *3 *. *. *. ** ** ** *. *. *. *. *. "
			"*. *. *. ** *. *. ** ** *. *. *. *. ** *. *8 *. *. *. *1 ** ** *. *. *. ** *. ** *. ** *. ** ** "
			"** *. *8 *8 ** *. *. ** *. ** ** *. *c {g {{ {h *a *. ** ** *. *. ** ** ** ** *. *. ** *. *. *. "
			"*c ^g ^^ ^^ ^h *a *8 *. ** *. *. *. {g {{ ^^ {{ {h ** *. *. ** *. ** ** *. ** ** *. ** *. *. *. "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^h ** *. ** *c {{ ^^ ^^ ^^ {{ *2 ** ** ** *. ** *. *. ** *. *. ** *. ** ** "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ *2 *. *c {g {{ {{ ^^ {{ {l *. ** ** *. ** *. ** *. ** ** *. *. ** ** *. "
			"{{ {{ {C tf {A {{ ^^ ^^ *2 *. {g {{ ^^ {{ {{ {l *3 ** *. *. *. ** *8 *. *. ** *. ** ** *. *8 *c "
			"%3 -7 %% %5 t7 {{ ^^ ^^ *a *4 {{ ^^ ^^ ^^ {{ *3 ** *. ** *8 *c ^g ^^ ^h *a *. ** *. ** ^g ^^ ^^ "
			"-b -- -d %% tt {{ ^^ ^^ ^h *e {{ {{ ^^ {{ {l ** ** *c ^g ^^ ^^ ^^ ^^ ^^ ^h *a *. *. *4 ^^ ^^ ^^ "
			"%% -e %% %c te {{ ^^ ^^ ^^ {{ {{ {{ {{ {{ *3 ** *c ^g ^^ ^^ ^^ {{ ^^ ^^ ^^ ^h *. *. *4 ^^ ^^ ^^ "
			"%% %% %% tf {B {{ ^^ ^^ ^^ ^^ {{ {{ {{ {{ *a *c ^g ^^ ^^ ^^ {{ {{ {{ ^^ ^^ ^^ *a *. *4 ^^ ^^ ^^ "
			"td %% %% %5 tf {A ^^ ^^ ^^ ^^ ^^ ^^ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {{ ^^ ^^ ^^ ^h *e ^^ ^^ ^^ "
			"%3 %c ^7 %a %5 t7 ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ ^^ {{ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
			"%% ^b ^^ ^d %% tt ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {3 {1 {1 {1 {5 {{ ^^ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
			"%% %5 ^e %3 %c te ^^ ^^ ^^ ^^ ^^ ^^ {{ {3 tC t3 tt t5 tA {5 ^^ ^^ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
			"-7 %% %% %c tf ^3 ^^ ^^ ^^ ^^ ^^ {{ {3 .. t3 tt tt tt t5 {4 {{ ^^ ^^ {{ {{ {{ {{ {{ ^^ ^^ ^^ ^^ "
			"-- -d %% t7 ^3 ^^ ^^ ^^ ^^ ^^ ^^ {{ {a .. tt tt ~7 tt tt {4 {{ {{ ^^ {{ {{ ^^ {{ {{ ^^ ^^ ^^ ^^ "
			"-e %% %c te ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {2 ta tt ~6 tt tt tA {5 {{ {{ {{ ^^ ^^ ^^ {{ {{ ^^ ^^ ^^ "
			"%% %c t7 {# ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {2 t% tt ~6 ta tt t5 tA {5 {{ {{ {{ ^^ {{ {{ {{ {{ ^^ ^^ "
			"tt tt tc {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {2 .. tt ~a ~9 ~5 ta t5 tA {1 {1 {1 {1 {5 {{ {{ {{ {{ {{ "
			"/3 .. .. {5 {{ ^^ ^^ ^^ ^^ ^^ ^^ {{ {3 .. tC tt tt t5 ~a ~5 tt tt tt tt tt t5 tA {1 {1 {1 {1 {1 "
			"/7 .. .. {4 {{ {{ ^^ ^^ ^^ ^^ ^^ {{ {2 .. t3 tt tt tt t5 ~6 te ~3 ~9 ~9 ~5 ta tt tt tt tt tt t5 "
			"/7 .. .. .. {5 {{ {{ ^^ ^^ ^^ ^^ {{ {2 .. ta tt tt tt tt ~2 ~9 ~c t3 t5 ~2 ~9 ~9 ~9 ~9 ~9 ~5 ta "
		))
	(kern-mk-map nil 32 32 pal_expanded
		(list   ;; Block 2,0 -- NW=(64,0) SE=(95,31)
			"*. *. *. ** ** ** ^j ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
			"** ** ** ** *. *. *5 ^j ^^ ^^ ^^ ^l *3 *1 *1 *5 ^j ^^ ^^ ^^ ^l *3 *1 *1 *5 ^j ^^ ^^ ^^ ^^ ^c |# "
			"** ** ** ** ** ** *. *5 ^j ^^ ^l *3 ** ** ** ** *5 ^j ^^ ^l *3 *. ** ** ** *5 ^j ^^ ^^ ^^ || tt "
			"*. *. *. ** *. *. *. *. *5 ^^ *3 ** *c ^g ^h *a ** *5 ^^ *3 *. *c ^g ^h *a ** *5 ^^ ^^ *b *d tt "
			"** ** *. *. *. *. *. ** *4 ^^ *2 *. ^g ^^ ^^ ^h *. *4 ^^ *2 *. ^g ^^ ^^ ^h *. *4 ^^ tf .. .. {4 "
			"*. ** ** *. ** *. ** *. ** ^n ** *4 ^^ ^^ ^^ ^^ *a ** ^n *. *4 ^^ ^^ ^^ ^^ *a *c ^^ {2 .. *f tt "
			"** *. ** ** ** *. *. ** *. *. *. *c ^^ ^^ ^^ ^^ ^h *a *. *. *c ^^ ^^ ^^ ^^ tt .. ^^ {2 tb tt tt "
			"*. ** ** *. *. ** ^g ^h *a *8 *c ^g ^^ ^^ ^^ ^^ ^^ ^h *a *c ^g ^^ ^^ ^^ ^^ ^^ {2 {1 {4 ^^ ^5 |A "
			"*. ** *. *. ** *. ^j ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ tb tt td ^^ ^^ ^^ "
			"*. ** *. ** ** ** *5 ^j ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
			"** ** *. *. ** ** *. *5 ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^~ ^^ ^^ ^^ "
			"** ** ** *. *. ** ** *c ^^ ^^ ^^ {{ ^^ ^^ ^^ ^^ ^^ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ ^^ ^^ ^^ "
			"*. *. *. *. ** ** ** ^g ^^ ^^ {{ {{ {{ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ ^^ ^^ {{ ^^ ^^ ^^ {{ {{ {{ ^^ ^^ "
			"** *. *. *. *. *. *4 ^^ ^^ ^^ ^^ {{ {{ ^^ ^^ ^L -3 -1 -1 -1 -5 ^J {{ {{ {{ ^^ ^^ ^^ {{ {{ ^^ ^^ "
			"** *8 *8 *8 *. ** *c ^^ ^^ ^^ ^^ {{ {{ {{ ^L -3 -- -- -8 -- -- -5 {J {{ ^^ ^^ ^^ ^^ ^^ {{ ^^ {{ "
			"^g ^^ ^^ ^^ ^h *e ^g ^^ ^^ ^^ ^^ ^^ {{ {{ -3 -- -c ^G ^^ ^H -a -- -5 {{ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ ^^ ^^ ^^ {{ {{ -2 -- ^G ^^ ^^ ^^ ^H -- -4 ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ ^^ ^^ {{ -2 -4 ^^ ^^ ^^ ^^ ^^ -2 -4 ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ ^^ ^^ ^^ ^L -- -4 {5 ^^ {7 ^^ {3 -2 -- ^J ^^ ^^ ^^ ^^ ^^ {{ {{ {{ "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {7 ^^ -3 -- -4 .. {1 /7 {1 .. -2 -- -5 ^^ {{ ^^ ^^ ^^ {{ {{ {3 "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {b .. {1 -a __ -c .. .. /7 .. .. -a __ -c {5 {{ {{ ^^ {{ {{ {3 .. "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ /0 /d /d == /d /d /d /9 /e /c /e __ /c /d /2 {A {{ {{ {3 .. .. "
			"^^ {{ ^^ ^^ ^^ ^^ {{ ^^ ^^ ^^ {{ /7 t7 -3 __ -- -5 ~A .. ~C -3 -- __ -5 .. /8 /d /e /c /e {8 .. "
			"^^ {{ {{ ^^ {{ {{ {{ {{ {{ {{ {C /7 tt -2 __ __ -- -- -1 -- -- __ __ -4 .. {c {{ {{ {{ {{ {{ {a "
			"{{ {{ {{ {{ {{ {3 {1 {1 {1 {1 /0 /a tt -a -- __ __ __ __ __ __ __ -- -c {4 {{ {{ ^^ ^^ {{ {{ {{ "
			"{{ {{ {{ {3 {1 tC tb tt tt t5 /7 tb tt tH -a -- -- __ __ __ __ -- -c ~# {4 {{ ^^ ^^ ^^ ^^ ^^ {{ "
			"^^ {{ {{ {2 t3 td ~3 ~9 ~5 tt /8 /2 tt tt tt tH -a -- __ __ -- -- ~B .. {4 {{ {{ ^^ ^^ ^^ ^^ ^^ "
			"{{ {{ {3 .. tt ~3 ~c t7 ~6 ta t5 /7 ta tt || tt tM -- __ __ -- -- -- -5 ~A {1 {5 {{ {{ {{ ^^ ^^ "
			"{{ {3 .. tC tt ~6 t3 tt ~a ~5 tt /7 t% ta tt tt -3 -- __ __ -- __ __ -- -- -5 ~A {1 {5 {{ ^^ ^^ "
			"{1 .. tC t3 tc ~6 tt tt t5 ~6 tt /8 /2 .. tD tt -2 __ __ __ __ __ __ __ __ -- -- -5 {4 {{ {{ ^^ "
			"tE t3 tt tc ~3 ~c tt t& tt ~6 ta td /7 tb tt tc -- __ __ __ __ __ __ __ __ __ __ -- ~A {5 {{ ^^ "
			"tt tc ~3 ~9 ~c t3 tc .. tt ~a ~9 ~9 =| ~9 ~9 ~9 -- -- __ __ __ __ __ __ __ __ __ -- -5 {4 {{ ^^ "
		))
	(kern-mk-map nil 32 32 pal_expanded
		(list   ;; Block 3,0 -- NW=(96,0) SE=(127,31)
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
			"tt tt tt *f ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ "
			"tc t& ta tt || ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {7 {{ {{ ^^ ^^ ^^ ^^ ^^ "
			"^3 ^^ ^5 ta tt ^^ ^^ {{ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {3 .. {5 {{ {{ ^^ ^^ ^^ ^^ "
			"^^ .. ^^ tD tt ^^ {{ {{ {{ ^^ ^^ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {b .. .. .. {d {{ ^^ ^^ ^^ ^^ "
			"^^ ^~ ^^ tt *f ^^ {{ {{ {{ ^^ ^^ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {a .. {c {{ {{ ^^ ^^ ^^ ^^ "
			"t5 .. t3 tt || ^^ ^^ {{ ^^ ^^ ^^ ^^ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {6 {{ {{ ^^ ^^ ^^ ^^ ^^ "
			"tt *f tt |C ^3 ^^ ^^ {{ ^^ ^^ ^^ ^^ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {6 {{ {{ ^^ ^^ ^^ ^^ ^^ "
			"^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ ^^ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {e ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
			"^^ ^^ ^^ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ ^^ ^^ {{ {{ ^^ ^^ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
			"^^ ^^ ^^ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ ^^ ^^ {7 ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
			"^^ ^^ {{ {{ {{ {{ {3 {1 {1 {1 {1 {1 {1 {1 {1 {1 {1 {1 {1 {5 {{ {{ ^^ {{ /7 {{ ^^ ^^ ^^ ^^ ^^ ^^ "
			"^^ {{ {{ {{ {3 {1 .. .. .. .. .. .. .. .. .. .. .. .. .. .. {5 {{ {{ {{ /b {{ ^^ ^^ ^^ ^^ ^^ ^^ "
			"{{ {{ {{ {3 .. .. tC t3 tt tt tt tt tt tt tt tt tt tt t5 .. .. {5 {{ {{ {6 {{ {{ ^^ ^^ ^^ ^^ ^^ "
			"{{ {{ {{ {2 .. t3 tt tt tt tt tt tt tt tt tt tt tt tt tt tA .. .. {1 {1 /3 {1 {5 ^^ ^^ ^^ ^^ ^^ "
			"{{ {{ {3 .. .. tt tt tt || || || || || || || || || tt tt t5 .. .. .. .. /b .. .. {5 ^^ ^^ ^^ ^^ "
			"{{ {3 .. .. tC tt tt || || || || || || || || || || tt tt tL -3 -1 -5 .. .. /c /d /2 {1 {5 ^^ ^^ "
			"{3 .. .. tC t3 tt tt || || ~b ~9 ~9 ~9 ~9 ~5 || || || tt -3 -- -- -- ~A .. .. .. /b .. .. {5 ^^ "
			"{2 .. t3 tt tt tt tt || || || || || || |% ~6 |A || || tt -2 -- -- -- -5 .. .. .. /3 .. .. {4 ^^ "
			".. .. tt tt tt || || || || || || || || || ~a ~5 |A || tL -- -- -- -- -- ~A .. .. /b .. .. {4 ^^ "
			".. .. tt tt || || || || || || || || || || |% ~a ~5 tL -3 -- -- -- -- -- -- -5 ~A .. .. ~C _3 -- "
			".. .. tt tt || || ~b ~9 ~9 ~9 ~9 ~9 ~5 |A || |D -- -- -- -- -- __ -- -- -- -- -- -1 -1 -- -- -- "
			".. .. tt tt || || || || || || || |% ~a ~9 ~1 ~9 -8 -- -- -- -- __ __ __ -- -- -- -- -- -- -- -- "
			".. .. tt tt tt || || || || || || || || |D ~6 |# || tH -- -- __ __ __ __ __ __ __ __ __ __ __ __ "
			"{2 .. ta tt tt || || || |C ~3 ~9 ~9 ~9 ~9 ~c || || || -2 -- __ __ __ __ __ __ __ __ __ __ __ __ "
			"{a .. t% tt tt || || ~b ~9 ~c |# || || || || || || tL -- -- __ __ __ __ __ __ __ __ __ __ __ __ "
			"{{ {a .. tt tt || || || || || || || || || || || || -3 -- __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"{{ {{ {2 ta tt tt || || || || || || || tt tt tt tt -2 -- __ -- __ __ __ __ __ __ __ __ __ __ __ "
			"^^ {{ {2 t% ta tt tt tt tt tt tt tt tt tt tt tt tc -2 -- __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"^^ {{ {a .. .. t% ta tt tt tt tt tt tt tt tc t# .. -2 -- __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"^^ ^^ {{ {a {8 {8 {8 .. .. .. .. .. .. {8 {8 {8 {8 -2 -- __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"^^ {{ {{ {{ {{ {{ {{ {a {8 {8 {8 {8 {c {{ {{ {{ {{ -2 -- __ __ __ __ __ __ __ __ __ __ __ __ __ "
		))
	(kern-mk-map nil 32 32 pal_expanded
		(list   ;; Block 0,1 -- NW=(0,32) SE=(31,63)
			"*. ** *. *. ** ** ** ** *. ** *. *. ** *c ^^ ^^ {{ {{ {{ {a t% ta tt tt tt tc t# {# {{ {{ {a /0 "
			"*. ** ** *. *. ** ** *. *. *. *. *. ^g ^^ ^^ ^^ {{ {{ {{ {{ {{ {{ {a {8 {8 {4 {{ {{ ^^ {{ {{ /7 "
			"** *. *. ** ** ** *. *. ** *. *. *. ^j ^^ ^^ ^^ ^^ {{ {{ {{ {{ {{ {{ {{ {{ {6 {{ ^^ ^^ ^^ {{ /7 "
			"*. *. *. ** *. *. *. *. ** ** ** ** *5 ^j ^^ ^^ ^^ ^^ {{ {{ {{ {{ {{ {{ {{ {6 {{ {{ ^^ {{ {C /7 "
			"** ** ** ** *. ** *. ** *. *. *. ** ** *5 ^j ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {a {5 {{ {{ {C /0 /a "
			"** ** ** ** *. *. *. ** *. *. *. *. *. *. *5 ^j ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {a {9 {9 /0 /a {# "
			"** ** *. ** ** ** *. ** *. *. ** *. *. *. ** *5 ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {{ /7 {# {{ "
			"*. *. ** ** *. *. ** ** *. ** *. ** *. *. *. *4 ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ /7 {{ {{ "
			"*. *. *. *. ** ** ** ** *. *. ** *. ** ** ** *4 ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {{ {{ /7 {1 {5 "
			"** ** ** ** ** *. ** *. ** *. *. ** ** *. ** *c ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {{ {3 /7 .. .. "
			"** ** ** ** *. ** *. *. *. *. ** ** *. ** *c ^g ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {3 {1 .. /7 .. .. "
			"*. *. ** *. ** ** *. ** ** ** *. *. ** *c ^g ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {{ {{ {2 .. .. /7 .. .. "
			"*. ** ** ** *. ** *. *. ** *. ** ** *. ^g ^^ ^^ ^^ ^^ {{ {{ ~7 {{ {{ {{ {{ {3 .. .. .. /7 .. .. "
			"*. *. ** *. *c .i *a *. *. ** ** *. *4 ^^ ^^ ^^ {{ {{ {{ {{ ~6 {1 t3 tt t5 .. .. .. .. /7 .. .. "
			"*. ** *. *. .k .. .m *. *. *. *. *. *c ^^ ^^ ^^ {{ {{ {{ {3 ~6 .. te ~7 te .. .. .. .. /7 .. .. "
			"** *. ** *. *5 .n *3 ** *. *. *. ** ^g ^^ ^^ ^^ {{ {{ ~b ~9 ~4 .. .. ~6 .. .. .. .. .. /7 .. .. "
			"*. *. ** ** *. *. *. *. *. ** ** *4 ^^ ^^ ^^ ^^ {{ {{ {{ {2 ~6 .. .. ~6 .. .. .. .. .. /7 .. .. "
			"** *. ** ** *. *. *. ** *. *. *. *4 ^^ ^^ ^^ ^^ {{ {{ {3 .. ~a ~9 ~9 ~4 .. .. .. .. .. /7 .. .. "
			"*. *. *. ** ** ** ** *. ** *. ** *4 ^^ ^^ ^^ ^^ {{ {{ {2 .. .. .. .. ~6 .. .. .. .. .. /7 .. .. "
			"*. *. *. *. *. *. *. ** ** *. ** *c ^^ ^^ ^^ ^^ {{ {3 /0 /d /d /d /d == /d /d /d /d /d /7 .. .. "
			"** ** ** ** *. *. ** *. *. *c ^g ^^ ^^ ^^ ^^ ^^ {{ {2 /7 .. .. .. .. ~6 .. .. .. .. .. /8 /d /d "
			"*. *. *. *. ** ** *. ** *c ^g ^^ ^^ ^^ ^^ ^^ {{ {{ {2 /7 .. .. .. .. ~a ~9 ~9 ~5 .. .. .. .. .. "
			"** ** *. ** ** *. ** ** ^g ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {a /7 .. t3 td .. .. .. .. ~6 .. .. .. .. ~3 "
			"*. ** *. ** ** *. *. *4 ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {{ {{ /7 tC tt ~b ~5 .. .. .. ~6 .. .. .. .. ~6 "
			"** ** ** *. ** ** ** *4 ^^ ^^ ^^ ^^ ^^ {{ ^^ ^^ {{ {{ /7 t3 tt td ~6 .. .. .. ~a ~9 -1 -1 -- -4 "
			"*. *. ** *. ** ** ** *4 ^^ ^^ ^^ ^^ ^^ {{ ^^ ^^ {{ {{ /7 tt ~b ~9 ~8 ~5 .. .. .. ~C -- __ __ -4 "
			"** *. *. *. *. *. ** *4 ^^ ^^ ^^ ^^ ^^ {{ {{ ^^ ^^ {{ /7 ta t5 tA .. ~a ~1 ~9 ~1 -- -- __ __ -4 "
			"*. ** *. *. ** ** *. *4 ^^ ^^ ^^ ^^ {{ {{ {{ ^^ {{ {{ /7 t% tt td .. .. ~6 .. -a -- __ __ -- -- "
			"*. *. *. *. *. ** ** *4 ^^ ^^ ^^ ^^ {{ ^^ ^^ ^^ {{ {3 /7 tC tt ~b ~5 .. ~6 .. ~% -- -- -- -- -- "
			"*. ** ** ** ** ** *. *4 ^^ ^^ ^^ ^^ {{ {{ ^^ ^^ {{ {2 /7 t3 tt td ~~ ~9 ~c .. .. -2 -- tG tH ~a "
			"** *. ** ** ** *. *. *c ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {{ {2 /7 tt ~b ~9 ~c .. .. .. ~C -- -c tt tt tt "
			"** *. ** ** ** *. *. {g {{ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {2 /7 ta td .. .. .. .. .. -3 -- tG tt tt tt "
		))
	(kern-mk-map nil 32 32 pal_expanded
		(list   ;; Block 1,1 -- NW=(32,32) SE=(63,63)
			"/a .. .. {8 .. {5 {{ {{ ^^ ^^ ^^ ^^ {2 .. t% tt tt tt tc ~6 t3 tt tt tt ~6 t3 tt tt tt t5 ~a ~9 "
			".. .. {c {{ {a .. {5 {{ {{ ^^ ^^ ^^ {2 .. .. tt ~3 ~9 ~9 ~c tt t# tD tt ~6 tt t# {8 t% ta tt tt "
			".. {c {{ {{ {{ {a {c {{ {{ ^^ ^^ ^^ {a .. .. tt ~6 t3 tt tt tc .. t3 tc ~6 tt {4 ^^ {a {8 {8 {8 "
			"{c {{ {{ {{ {{ {{ {{ {{ {{ {{ ^^ {{ {{ {2 tC tt ~6 tt t# {8 {8 .. tt ~3 ~c tt {4 ^^ ^^ ^^ {{ {{ "
			"{{ {{ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ {{ {{ {2 t3 tc ~6 tt {4 ^^ {{ {2 tt ~6 t3 tt tA {5 ^^ ^^ ^^ {{ "
			"{{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {{ {3 tC tt ~3 ~c tt {4 ^^ ^^ {2 tt ~6 ta tt t5 {4 {{ ^^ ^^ ^^ "
			"{{ {{ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {b .. t3 tt ~6 t3 tt {4 {{ ^^ {2 tt ~a ~9 ~5 tt {4 {{ {{ ^^ ^^ "
			"{{ {{ {{ {{ {{ ^^ ^^ ^^ ^^ {{ {{ {{ {2 tt tt ~e tt tt {c {{ {{ {2 ta tt t5 ~e tt {4 {{ {{ ^^ ^^ "
			"{{ {{ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ {{ {2 ta tt tt tt tc {{ ^^ ^^ {a {8 t% ta tt tc {4 {{ ^^ ^^ ^^ "
			"{1 {1 {5 {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {a t% ta tt tc t# {{ ^^ ^^ {{ {{ {a {8 {8 {8 {c ^^ ^^ ^^ ^^ "
			".. .. t7 {A {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {a {8 {8 {c ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ "
			".. .. tt ~7 t7 {{ {{ {{ {{ ^^ ^^ ^^ ^^ {{ {{ ^^ ^^ ^^ {{ {{ {{ ^^ ^^ ^^ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ "
			".. .. te ~6 tt {A {{ {{ {{ ^^ ^^ ^^ ^^ {{ {{ ^^ ^^ {C tf {{ tf {A ^^ ^^ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ "
			".. .. .. ~6 tt td {5 {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ tf t# {1 t% tf {{ ^^ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ "
			".. .. .. ~6 tt ~3 ~9 ~9 ~9 ~9 ~d ^^ ^^ ^^ ^^ ^^ {{ {{ {2 .. {4 {{ {{ ^^ ^^ ^^ {{ ^^ ^^ ^^ ^^ ^^ "
			".. .. .. ~6 te ~6 t7 {# {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ {{ tf tA /3 tC tf {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
			".. .. .. ~a ~9 ~4 te {5 {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {% tf /7 tf {# ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {7 {{ "
			".. .. .. .. .. ~~ ~9 ~9 ~5 tb td {A ^^ ^^ ^^ ^^ ^^ ^^ {% /7 {# ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {3 .. {5 "
			".. ~3 ~9 ~9 ~9 ~c t3 t5 ~a ~1 ~d tf {{ ^^ ^^ ^^ ^^ ^^ ^^ /7 ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {b .. .. .. "
			".. ~6 .. .. .. .. ta tt td ~6 tf {# {3 {1 tf ^^ ^^ ^^ ^^ /7 ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {a .. {c "
			"/d == /d /d /2 .. .. .. .. == .. {1 {8 {c {{ ^^ ^^ ^^ ^^ /7 ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {e {{ "
			".. ~6 .. .. /7 .. .. {8 tf ~6 tb td {A {{ {{ ^^ ^^ ^^ ^^ /7 ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
			"~9 ~c .. .. /7 .. {4 {{ {% ~a ~9 ~5 tf {{ ^^ ^^ ^^ ^^ ^^ /7 ^^ ^^ ^^ ^^ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ "
			".. .. .. .. /7 .. {4 {{ ^^ ^^ ^5 ~a ~d ^^ ^^ ^^ ^^ ^^ ^^ /7 ^^ ^^ ^^ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
			".. .. .. .. /7 .. {4 {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ {{ ^^ ^^ /7 ^^ ^^ {{ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ {{ "
			".. .. .. .. /7 .. .. {1 {5 {{ {{ ^^ ^^ ^^ ^^ {{ {{ {{ {C /7 {A {{ {{ {C t7 {A {{ {{ ^^ ^^ ^^ {{ "
			".. .. .. .. /8 /d /d /d /d /2 {{ ^^ ^^ ^^ ^^ {{ t3 tt t5 /7 t3 tt tt tt tt tt tt t5 {{ ^^ {{ {C "
			"~A .. .. .. .. .. .. {c {% /7 {{ ^^ ^^ {{ {{ {{ ta tt tc /7 ta tt tt tt tt tt tt tc {A {{ {C tf "
			"~5 ~A .. .. .. .. {c {{ {{ /7 {A ^^ ^^ ^^ {{ {3 .. /0 /d /9 /d /d /d /d /d /d /d /d /d /d /d /d "
			"-- -- ~5 ~A .. {4 {{ {{ {{ /8 /d {{ ^^ {{ /d /d /d /a .. .. .. .. t3 tt tt tt tt tt tt tt tt tt "
			"tH ~a -- ~~ ~9 ~9 ~9 ~9 ~5 {A {{ ^^ ^^ ^^ {{ {a .. .. .. .. .. .. ta tt tt tt tt tt tt || || tt "
			"tt tH ~~ -c {# {{ {{ {% ~a ~5 {{ {{ ^^ ^^ {{ {{ {2 .. .. .. .. .. .. t% tt tt tt tt || || || || "
		))
	(kern-mk-map nil 32 32 pal_expanded
		(list   ;; Block 2,1 -- NW=(64,32) SE=(95,63)
			"~9 ~9 ~c t3 tt tc t# .. ta tt tt td /7 tb tt tt tH -- __ __ -- -- -- -- __ __ __ -- -4 {4 {{ ^^ "
			"tt tt tt tc t# {8 {8 .. .. .. .. .. /7 .. .. .. .. -a -8 -8 -c ~# ~% -- __ __ __ __ -4 {4 {{ {{ "
			"{8 {8 {8 {8 {c {{ {{ {a {8 .. /0 /d /a {8 .. .. .. .. {8 {8 {8 {8 {8 -a -- __ __ __ -- ~A {5 {{ "
			"{{ {{ ^^ ^^ ^^ ^^ {{ {{ {{ {a /7 {# {{ {{ {a {8 {8 {c {{ {{ {{ {{ {{ {H -- __ __ __ -- -- -1 -1 "
			"{{ {{ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ /7 {{ {{ {{ {{ {{ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ -2 __ __ __ __ __ __ __ "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ /7 {{ ^^ ^^ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ -2 __ __ __ __ __ __ __ "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ /7 ^a ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ -a -- __ __ __ __ __ __ "
			"^c |# || |% ^a ^^ ^^ ^^ ^^ ^^ /8 /2 ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^H -a -8 -- -- __ __ __ "
			"|# || || || |% ^a ^^ ^^ ^^ ^^ ^d /7 ^~ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^c tf ^a ^^ ^^ ^^ ^H -a -- __ __ "
			"|| || || || || t5 ^a ^^ ^^ ^^ /0 /a ^^ ^^ ^^ ^c |& ^a ^^ tb tt td /7 t7 ^^ ^^ ^^ ^^ ^H -- -- __ "
			"|A || || || || tt t5 ^a ^^ ^c /7 ^3 ^^ ^^ ^^ |# || |% ^e /0 /d /d /a te ^^ ^^ ^^ ^^ ^^ -2 -- __ "
			"^5 |A || |C ^7 ta tt tt tt t5 /7 ^^ ^^ ^^ ^c || || || t5 /7 tb tt td ^3 ^^ ^^ ^^ ^^ ^^ -2 -- __ "
			"^^ ^^ ^^ ^^ ^^ ^^ ^5 ta tt tc /7 ^a ^^ ^^ t3 tt || tt tt /7 ^3 ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^L -- -- __ "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^5 /0 /d /9 /2 ^a ^c ta tt tt tt tc /7 ^a ^^ ^^ ^^ ^^ ^^ ^^ ^^ -b -- -- -- "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ /7 t3 t5 /8 /d /d /d /d /d /d /d /a t7 ^a ^^ ^^ ^^ ^^ ^^ ^^ ~% -a -- -- "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ /7 tt tt tt tt tt tt tt tt tt tt tt tt t5 ^a ^^ ^^ ^^ ^^ ^^ {2 .. ~% -- "
			"^^ ^^ ^^ ^^ ^^ {{ {{ {C /7 tt || || || |X || tt tt tt || || || tt tt t5 ^^ ^^ ^^ ^^ {a .. .. -a "
			"{{ {{ {{ {{ ^^ {{ /0 /d /a tt || |t || || || tt t| tt tt || || || tt tt ^^ ^^ ^^ ^^ ^^ {a .. ~% "
			"{9 {9 {5 {{ {{ {C /7 t3 tt tt || || |t || || || tt tt || || |t || || tt ^^ ^^ ^^ ^^ ^^ ^^ {a {8 "
			"{{ {{ {a {5 {C tf /7 tt || || || || || || || tt tt tt || || || |X || tt ^a ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
			"^^ {{ {{ /0 /d /d /a tt || || |t || || || || || tt t| || |X || || || tt t5 ^^ ^^ ^^ ^^ ^^ ^^ ^c "
			"^^ ^^ {{ /7 t3 tt tt || |t || || |X || |t || || tt tt tt |t || || tt t| tt ^a ^^ ^^ ^^ ^^ ^^ t3 "
			"^^ {{ {C /7 tt || || || || || || || || || || || || tt tt || || || tt tt tt || |% ^a ^^ ^^ ^c tt "
			"{{ {C t7 /7 tt || || |X || || || tt || || || |t || tt tt tt || || || tt || || || |X || || tt tt "
			"{C tb tc /7 tt || |t || || tt tt tt || || || || || || tt tt || |X || || || || || || || || tt tt "
			"/0 /d /d /a tt || || || tt tt tt tt tt || |t || || || tt tt tt || || || |t || |C ^7 |A || tt t| "
			"/7 t3 tt tt tt tt || || tt tt || tt tt tt || tt tt tt t| tt || || || || || |X ^b ^^ ^5 tt tt tt "
			"/7 tt tt tt tt tt tt tt tt tt || || tt tt || tt || tt tt tt || || |t || || || |% ^^ ^^ ta tt tt "
			"/a tt tt tt t| tt tt t| tt || || || tt tt t| tt tt tt tt || || || || || |X || tt ^^ ^^ ^5 ta t| "
			"tt tt t| tt tt tt tt || || || |t |X || tt tt || || || || || || |X || || || || tc ^^ ^^ ^^ ^5 ta "
			"|| || tt tt tt || || |t || || || |t || || || |t || || || |t || || || |t || tt ^3 ^^ ^^ ^^ ^^ ^d "
			"|| || || tt tt || || || |X |t || || || || |X || || |t || || || || |X || || tc ^^ ^^ ^^ ^^ ^^ t3 "
		))
	(kern-mk-map nil 32 32 pal_expanded
		(list   ;; Block 3,1 -- NW=(96,32) SE=(127,63)
			"^^ ^^ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ {{ {L -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"^^ ^^ ^^ ^^ -7 {J {{ {{ {{ {{ {{ {{ {{ {{ {C ~C -3 -- __ __ __ __ __ __ __ __ __ ~~ ~~ ~~ __ __ "
			"^^ ^^ ^^ ^^ -2 -- _1 _1 _1 _1 _1 -1 -1 -1 -1 -- -- -- __ __ __ __ __ __ __ __ ~~ -- -- -- ~~ __ "
			"-1 -5 ^J ^L -- -- __ __ __ __ __ __ __ -- -- -- -- __ __ __ __ __ __ __ ~~ -- -- -c ^I -a -- __ "
			"-- -- -- -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ ~~ ~~ -- -- ^K ^^ ^M -- __ "
			"-- -- -- -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ ~~ -- -- -- -5 ^N -3 -- __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- -- -- -- -- -- __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ ~~ ~~ ~~ ~~ ~~ ~~ -- -- -- -- ~~ ~~ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ ~~ -- -- -8 -8 -- -- -- -- -- -- -- -- __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -c {G {{ {{ ^H -a -- -- -- -- -- -- __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- {G {{ ^^ ^^ ^^ ^M -- -c ^I -a -- -- __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -4 {{ ^^ ^^ ^^ ^^ ~3 -- ^K ^^ ^M -- __ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -4 {{ {{ ^^ ^^ ^^ ~a -- -5 ^N -3 -- -- __ -- "
			"-- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ ~~ -4 {{ {{ ^^ ^^ ^^ ^H ~a -- -- -- -- -- -- -- "
			"-- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -c {{ ^^ ^^ ^^ {{ ^^ ^^ ^^ -- -- -- ^I -a -- "
			"-- -- __ __ __ __ __ __ __ __ __ __ __ __ __ ~~ -- {G {{ ^^ !3 !5 {{ !3 !5 ^^ -a -- -4 ^^ ^M -- "
			"-- -- __ __ __ __ __ __ __ __ __ __ __ __ __ -- -c {{ ^^ ^^ !a !! =! !! !c ^^ ^H -a -c ^^ -3 -- "
			"-- -- __ __ __ __ __ __ __ __ __ __ __ __ __ -- {G {{ ^^ ^^ ^^ !e {{ !e ^^ ^^ ^^ {{ {{ ^^ -2 __ "
			"-2 -- __ __ __ __ __ __ __ __ __ __ __ __ __ -4 {{ ^^ ^^ ^^ ^^ ^^ {{ ^^ ^^ ^^ {{ {{ {{ ^^ -2 __ "
			"-2 -- -- __ __ __ __ __ __ __ __ __ __ __ __ -4 {{ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ ^^ {{ {{ {{ ^^ _2 __ "
			"-a -- -- -- -- __ __ __ __ __ __ __ __ __ __ -- {J {{ ^^ ^^ {{ {{ {{ {{ {{ {{ {{ {{ ^^ ^L __ __ "
			"tH -a -- -- -- -- __ __ __ __ __ __ __ __ __ -- -5 {{ ^^ ^^ ^^ {{ ^^ ^^ {{ {{ {{ ^^ ^L _3 __ __ "
			"tt tt tH -a -- -- __ __ __ __ __ __ __ __ __ __ -- {J {{ ^^ ^^ ^^ ^^ ^^ {{ {{ ^^ ^L _3 __ __ __ "
			"tt tt tt tH -- -- __ __ __ __ __ __ __ __ __ __ -- -- -5 ^J ^^ ^^ ^^ ^^ ^^ ^^ ^^ _3 __ __ __ __ "
			"tt tt tt tt -2 -- __ __ __ __ __ __ __ __ __ __ __ __ -- -- -5 ^J ^L -3 -5 ^J ^L __ __ __ __ __ "
			"tt tt tt tt -2 -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- -- -- -- -- __ __ __ __ __ __ "
			"tt tt tt tt -2 -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"tt tt tt tL -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"tt tt tt -3 -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- -- __ __ __ __ __ __ __ __ __ __ "
			"tt tt tL -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ -- -c ^I -a -- __ __ __ __ __ __ __ __ __ "
			"tt tt -3 -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ -- ^K ^^ ^M -- __ __ __ __ __ __ __ __ __ "
			"tt tt -2 -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ -- -5 ^N -3 -- __ __ __ __ __ __ __ __ __ "
		))
	(kern-mk-map nil 32 32 pal_expanded
		(list   ;; Block 0,2 -- NW=(0,64) SE=(31,95)
			"*. ** *. ** *. *. ** *5 {j {{ ^^ ^^ ^^ ^^ ^^ {{ {3 .. /7 .. .. .. .. .. .. ~C -- -- tJ tt tt tt "
			"** *. ** ** *. ** ** ** *5 {{ ^^ ^^ ^^ {{ {{ {3 .. .. /7 .. .. .. .. .. ~C ~3 -- -- -5 tJ tt tt "
			"** ** ** ** ** ** ** ** *c {{ ^^ ^^ {{ {{ /0 /d /d /d /9 /d /d /2 .. .. -3 -- -- __ -- -5 tt tt "
			"*. ** ** *. ** *. ** *c {g {{ ^^ ^^ {{ {3 /7 {c {{ {{ {{ {{ {a /7 .. .. -2 -- __ __ __ -4 tt tt "
			"** *. *. *. ** *. ** {g {{ ^^ ^^ ^^ {{ {2 /7 {{ {{ ^^ ^^ {{ {{ /7 .. ~C -- -- -- __ -- -c tt tt "
			"*. *. *. *. *. *. *c {{ ^^ ^^ ^^ ^^ {{ {2 /7 {{ ^^ ^^ ^^ ^^ {{ /7 .. -3 -- -- -- -- -c tG tt tt "
			"*. ** *. ** *. *c {g {{ ^^ ^^ ^^ ^^ {{ {2 /7 {{ ^^ ^^ ^^ ^^ {{ /7 .. -2 -- -- -c tG tt tt tt tt "
			"** *8 *8 *c {g {{ {{ ^^ ^^ ^^ ^^ ^^ {{ {2 /7 {{ {{ ^^ ^^ {{ {C /7 .. -2 -- -- tG tt tt tt tt tt "
			"^^ ^^ {{ {{ {{ {{ ^^ ^^ ^^ ^^ {{ {{ {3 .. /7 {5 {{ {{ {{ {C /0 /a ~C -- -- -- tJ tt tt {# {{ {{ "
			"^^ ^^ ^^ {{ {{ {{ ^^ ^^ ^^ {{ {{ {3 /0 /d /9 /d /d /d /d /d /a ~C -3 -- -- -- -5 tJ tc {{ ^^ ^^ "
			"^^ ^^ ^^ {{ {{ ^^ ^^ ^^ {{ {{ {3 .. /7 .. .. .. .. .. .. .. .. -3 -- -- -- ~~ -- -- -5 ^^ ^^ ^^ "
			"^^ ^^ ^^ {{ ^^ ^^ ^^ {{ {{ {3 .. .. /7 .. .. .. .. .. .. .. ~C -- ~~ -- -- -- -- -- -c ^^ ^^ ^^ "
			"^^ ^^ ^^ {{ ^^ ^^ ^^ ^^ {{ {2 .. .. /7 .. ~C _3 _1 _5 ~A ~C ~3 ~~ -- -- -- -- -- -- ^K ^^ ^^ ^^ "
			"^^ ^^ {{ {{ {{ ^^ ^^ ^^ {3 .. .. .. /7 ~C _3 __ __ __ __ __ __ __ __ -- -- -- -- -- -5 ^^ ^^ ^^ "
			"^^ ^^ ^^ {{ ^^ ^^ ^^ ^^ {2 .. .. .. .. _3 __ __ __ __ __ __ __ __ __ __ -- __ __ __ -- ^J ^^ ^^ "
			"^^ ^^ ^^ ^^ ^^ {{ {{ {{ {2 .. .. .. .. _a __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -5 ^^ ^^ "
			"^^ ^^ ^^ ^^ {{ {L ~3 ~1 ~5 ~A .. .. .. ~% _a __ __ __ _c ~& _a __ __ __ __ __ __ __ __ -- ^J ^L "
			"^^ ^^ ^^ {{ {L ~3 ~~ ~~ ~~ ~~ ~5 .. .. .. ~% _a _8 _c ~# .. ~% -- __ __ __ __ __ __ __ -- -- -- "
			"^^ ^^ ^^ {{ ~3 ~~ -- ~~ ~~ ~~ ~~ ~A .. .. .. .. .. .. .. .. ~C -- __ __ __ __ __ __ __ __ __ __ "
			"^^ ^^ ^^ {{ ~2 -- -- -- -- -- ~~ ~5 ~A .. .. .. .. .. .. ~C -3 -- -- -- -- __ __ __ __ __ __ __ "
			"^^ ^^ ^^ {{ ~2 -- -- -- -- -- ~~ ~~ ~~ ~5 ~A .. .. ~C -3 -- -- ~~ ~~ ~~ -- -- __ __ __ __ __ __ "
			"^^ ^^ ^^ {{ ~a ~~ -- -- -- -- ~~ ~~ ~~ ~~ ~~ -1 -1 -- -- -- ~~ ~c ~& ~a ~~ -- __ __ __ __ __ __ "
			"^^ ^^ ^^ {{ {H ~a ~~ -- -- ~~ ~c ~& ~a ~~ ~~ ~~ ~~ ~~ ~~ -- ~~ ~B .. ~D ~~ -- __ -- -- -- -8 -- "
			"^^ ^^ ^^ ^^ {{ {H ~a ~~ ~~ ~~ ~B .. ~D ~~ -- -- -- -- -- -- ~~ ~5 ~E ~3 ~~ -- -- -- -c {G {{ {H "
			"^^ ^^ ^^ ^^ ^^ {{ {{ {H ~~ ~~ ~5 ~E ~3 ~~ -- -- -- -- -- -- -- ~~ ~~ ~~ -- -- -c {G {{ {{ ^^ {{ "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ ~a ~~ ~~ ~~ ~~ -- -- -- -- -- -- -- -- -- -- -- -- ~~ {G {{ ^^ ^^ ^^ ^^ "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {H ~a ~~ -- -- -- -- ~~ ~~ ~8 ~8 ~8 ~8 ~~ ~~ ~~ ~~ ~c {{ ^^ ^^ ^^ ^^ ^^ "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {H ~a ~8 ~8 ~8 ~8 ~c {G {{ {{ {{ {{ {H ~a ~c {G {{ {{ ^^ ^^ ^^ ^^ {{ "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {{ {{ {{ {{ {{ ^^ ^^ ^^ ^^ {{ {{ {{ {{ ^^ ^^ ^^ ^^ {{ {{ {L "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ -b -- "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {H -- "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ -- "
		))
	(kern-mk-map nil 32 32 pal_expanded
		(list   ;; Block 1,2 -- NW=(32,64) SE=(63,95)
			"tt tt ~6 {# {{ ^^ {{ {{ {% ~6 {A {{ {{ ^^ ^^ {{ tb tt td .. .. .. .. .. tt tt tt || || || || || "
			"tt tt ~6 {{ ^^ ^^ ^^ ^^ {{ ~a ~d {{ ^^ ^^ ^^ {{ {{ {{ {{ {a {8 {8 .. tC tt || || || || || || || "
			"tt tt ~6 {{ ^^ ^^ ^^ ^^ {{ {{ {{ {{ ^^ ^^ ^^ ^^ {{ {{ {{ {{ {{ {{ tb tt tt tt || || tt tt tt || "
			"tt tt ~6 {A {{ ^^ ^^ ^^ ^^ ^^ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {% ta tt tt tt tt tt tt tt "
			"tt tt ~a ~5 {A {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {% tt tt || tt tt tt || "
			"tt tt t5 ~a ~9 ~9 ~d {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ ^^ ^^ ^^ {{ tt tt || || || || || "
			"tt tt tt tt tt tt td {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {L ~7 {J {{ ^^ ^^ ^^ {{ tt tt tt tt tt tt tt "
			"tt tt tt tt tc {# {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ ~b -- ~d {{ ^^ ^^ ^^ {{ te {# {{ {{ {{ {% ta "
			"{{ {% te {# {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {% ~6 {# {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ "
			"^^ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ~6 ^^ ^^ ^^ ^^ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^c ~6 ^^ ^^ ^^ {{ {C ~7 {J {{ ^^ ^^ ^^ ^^ ^^ "
			"^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ~3 ~c ^^ ~3 ~9 ~9 ~9 -- ~d {{ ^^ ^^ ^^ ^^ ^^ "
			"{{ ^^ ^^ ^^ ^^ {{ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^c ~6 ^b ^c ~6 ^3 {{ {% ~e {G {{ ^^ ^^ {{ {{ {{ "
			"{{ ^^ {{ {{ {{ {{ {{ {7 {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ~3 ~8 ~9 ~9 ~4 ^^ ^^ {{ {{ {{ ^^ ^^ {{ {{ {{ {C "
			"{{ {{ {{ {{ {{ {{ {3 .. {5 {{ {{ ^^ ^^ ^^ ^^ ^c ~6 ^3 ^^ ^5 ~6 ^a ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ t3 "
			"{L -3 -5 {J {{ {3 .. .. .. {5 {{ ^^ ^^ ^^ ^c ~3 ~c ^^ ^^ ^^ ~a ~9 ~d ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ ta "
			"-3 -- -- -- -5 ~A .. .. .. {4 {{ {{ ^^ ^L -3 ~~ ^J ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {3 .. "
			"-- __ __ __ -- -5 ~A .. ~C -3 -1 -1 -1 -- -- -- -5 ^J ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {{ {{ {2 .. "
			"__ __ __ __ __ -- -- -1 -- -- __ __ __ __ __ __ -- -- -5 ^J ^^ ^L -3 -1 -5 {J {{ {{ {{ {3 .. .. "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- -1 -- -- __ -- -- _5 {J {{ {2 .. .. "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ _1 _1 _5 ~A "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ _5 "
			"-- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"-a -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"{H -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"{{ -2 -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"{{ -2 -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"{L -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"-3 -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"-- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"-- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"-- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
		))
	(kern-mk-map nil 32 32 pal_expanded
		(list   ;; Block 2,2 -- NW=(64,64) SE=(95,95)
			"|| || || || tt || || || || || || || || || || || || || || || || || || || ^3 ^^ ^^ ^^ ^^ ^^ ^^ tt "
			"|| || || || tt tt || || || || tt || || || || || || || || || || || || || ^a ^^ ^^ ^^ ^^ ^^ ^^ tt "
			"tt tt tt || || tt || || tt tt tt || || || || || || || || || || || || || |% ^^ ^^ ^^ ^^ ^^ ^^ tt "
			"tt || tt || || tt tt tt tt || tt tt || || || || || || tt tt || || || || |C ^^ ^^ ^^ ^^ ^^ ^^ tt "
			"|| || tt tt tt tt tt || || || || tt || || || || || || tt tt tt || || || ^b ^^ ^^ ^^ ^^ ^^ ^c tt "
			"|| || || tt tt || || || || || tt tt || || || || || tt tt || tt tt tt || || ^a ^^ ^^ ^^ ^c t3 tt "
			"|| || tt tt || || || || tt tt tt tt tc {# {{ {{ {% tt || || || tt tt tt tt t5 ^a ^^ ^c t3 tt tt "
			"tt tt tt tt || || tt tt tt tc {# {{ {{ {{ ^^ ^^ {{ tt tt || tt tt tt tt tt tt t5 ^e t3 tt tt tL "
			"{% ta tt || || || tt {# {{ {{ {{ ^^ ^^ ^^ ^^ ^^ {{ tt ~b ~9 ~9 ~9 ~9 ~5 tt tt tt tt tt tt tt -3 "
			"{{ {% tt tt || tt tc {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ ta tt tt tt tt t5 ~6 tt tt tt tt tt tt tL -- "
			"{{ {C tt tt tt tt {# {{ {{ ^^ ^^ ^^ ^^ ^^ {{ {{ tf {{ {{ {% ta tt tt ~6 ta tt tL -3 -1 -1 -- -- "
			"{{ t3 tt tt tt tc {{ {{ {{ {{ {{ {{ {{ ^^ ^^ {{ {{ ^^ ^^ {{ {% tt tt ~a ~1 ~9 ~~ ~~ -- -- -- -- "
			"{C tt tt tt t# .. {5 {{ {{ tb tt t5 {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ tt tt t5 ~6 t7 -a -- -- -- -- -- "
			"t3 tt tt tc .. .. .. {1 {1 .. t% te {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ {{ ta tt tt ~6 tt tM -- -- -- -- -8 "
			"tt t# .. .. .. .. .. .. .. .. .. .. {5 {{ {{ {{ ^^ ^^ ^^ ^^ {{ {% ta tc ~6 tL -3 -- -- -c tG tt "
			"tc .. .. .. .. .. .. .. .. .. ~C -3 -5 ~A {5 {{ {{ ^^ ^^ ^^ ^^ {{ {{ {% ~2 -- -- -- tG tt tt tt "
			".. .. .. .. .. .. .. .. -b -1 -- -- -- -5 ~A {5 {{ ^^ ^^ ^^ ^^ ^^ {{ {{ -2 -- -- -- tJ tt tt tt "
			".. .. .. .. .. .. .. .. ~% -- -- -- -- -- -5 ~A {{ ^^ ^^ ^^ ^^ {{ {{ {L -- -- -- -- -5 tJ tt tt "
			".. .. .. .. .. .. .. .. ~C -- -- __ __ -- -- -5 {{ ^^ ^^ ^^ ^^ {{ {L -3 -- ~~ -- -- -- -5 tJ tL "
			".. .. .. .. .. .. .. ~C -3 -- -- __ __ -- -- -- {J {{ {{ ^^ {{ -3 -- -- -- ~~ -- -- ~~ -- -- -- "
			".. .. .. .. .. ~C -3 -- -- -- -- __ __ __ -- -- -- -5 {{ ^^ {{ -2 -- -- ~~ ~~ ~~ __ -- ~~ -- -- "
			"~A .. .. ~C -3 -- -- -- -- -- __ __ __ __ __ -- -- -- {J {{ {L -- -- __ __ ~~ __ __ __ __ ~~ ~~ "
			"__ _1 _1 -- -- -- -- -- __ __ __ __ __ __ __ __ -- -- -- -1 -- -- -- __ __ __ __ __ __ __ __ __ "
			"__ __ __ -- -- -- __ __ __ __ __ __ __ __ __ __ -- -- -- -- -- -- __ __ __ __ __ __ __ __ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
		))
	(kern-mk-map nil 32 32 pal_expanded
		(list   ;; Block 3,2 -- NW=(96,64) SE=(127,95)
			"tt tt -a -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- -- __ __ __ __ __ __ __ __ __ __ "
			"tt tt tt tH -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"tt tt tt tL -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"tt tt tt -3 -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"tt tt tt -2 -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"tt tt tL -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"tt tL -3 -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"-3 -- -- -- -- ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"-- -- -- -- ~~ ~~ ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"-- -c tI -- -- ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"-- tG tt -2 -- -- -8 -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"-- tJ tL -- -c tG tt tH -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"-- -- -- -- tG tt tt tt -2 __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"-- -- -- -4 tt tt tt tL -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"tH -- -- -- tJ tt tL -3 -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
			"tt -2 ~~ -- -- -1 -- -- ~~ __ __ __ __ __ __ __ __ __ __ __ __ -- -- -- __ __ __ __ __ __ __ __ "
			"tL -- -- ~~ ~~ ~~ ~~ ~~ -- __ __ __ __ __ __ __ __ __ __ __ -- -c ~& -a -- __ __ __ __ __ __ __ "
			"-3 -- ~~ -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -c ~# .. ~% -- __ __ __ __ __ __ __ "
			"-- -- ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -c ~# tC t7 .. -2 __ __ __ __ __ __ __ "
			"-- ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- ~# tC t3 tt .. -a -- __ __ __ __ __ __ "
			"~~ -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -c tC t3 |. tt tA ~% -a -- __ __ __ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- ~# t3 |. |. |. tt td .. ~D ~~ __ __ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -4 .. tt |. |. |. tc t# ~C -3 -- ~~ ~~ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- ~A ta |. |. tc t# -3 -- -- -- -- ~~ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -5 t% tt |. t# -3 -- -- -- -- -- ~~ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- ~A ta tc {8 -2 -- -- -- -- -- ~~ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -5 {# {{ {{ -a -- -- -- -- -- ~~ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- {J ^^ ^^ {H -a -8 -c {G {M ~~ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -5 {J {{ ^^ {{ {{ {{ {L -3 -- __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -5 {J ^^ ^^ ^^ {L -3 -- __ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- -5 {J {L -3 -- __ __ __ __ "
			"__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- -- -- __ __ __ __ __ "
		))

    (kern-mk-map nil 32 32 pal_expanded
      ;; Map Block #13/16 (0,3)
      ;;   NW=  0,96   NE= 31,96  
      ;;   SW=  0,127  SE= 31,127 
      
      (list
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ -- "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ -- "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ -- "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ -- "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ -- -- "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ -- -- "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ -- "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ -- "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ -- "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
      )
    )
    (kern-mk-map nil 32 32 pal_expanded
      ;; Map Block #14/16 (1,3)
      ;;   NW= 32,96   NE= 63,96  
      ;;   SW= 32,127  SE= 63,127 
      
      (list
        "-- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "-- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "-- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "-- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "-- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "-- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "-- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "-- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "-- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- "
        "-- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- "
        "-- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- "
        "{{ -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- "
        "{{ -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- "
        "{{ {{ -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "^^ {{ -- -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "^^ {{ -- -- -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "^^ {{ {{ {{ {{ -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- "
        "{{ {{ ^^ {{ {{ -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- ~~ "
        "{{ ^^ ^^ ^^ {{ -- -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- -- -- "
        "{{ {{ ^^ {{ {{ {{ {{ -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- -- {{ {{ "
        "^^ {{ {{ {{ ^^ {{ {{ -- -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- {{ {{ {{ {{ "
        "^^ ^^ {{ ^^ ^^ ^^ {{ -- -- -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- {{ ^^ ^^ {{ "
        "^^ ^^ {{ {{ ^^ {{ {{ {{ {{ {{ -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- {{ {{ ^^ {{ "
        "^^ ^^ ^^ {{ {{ {{ ^^ {{ {{ {{ -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- {{ ^^ {{ "
        "^^ ^^ ^^ ^^ {{ ^^ ^^ ^^ {{ {{ -- -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- {{ ^^ {{ "
        "^^ ^^ ^^ ^^ {{ {{ ^^ {{ {{ {{ -- -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- {{ ^^ ^^ "
        "^^ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ {{ {{ {{ -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- {{ {{ ^^ "
        "^^ ^^ ^^ ^^ ^^ ^^ {{ ^^ ^^ ^^ {{ {{ -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- -- {{ {{ "
        "^^ ^^ ^^ ^^ ^^ ^^ {{ {{ ^^ {{ {{ {{ -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- -- -- "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ {{ -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- -- "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
      )
    )
    (kern-mk-map nil 32 32 pal_expanded
      ;; Map Block #15/16 (2,3)
      ;;   NW= 64,96   NE= 95,96  
      ;;   SW= 64,127  SE= 95,127 
      
      (list
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ ~~ -- ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "-- ~~ ~~ ~~ -- __ __ -- __ -- __ -- -- -- -- -- -- -- -- -- -- -- -- __ __ __ __ __ __ __ __ __ "
        "~~ {{ {{ {{ ~~ -- __ __ __ __ __ -- -- -- -- -- -- -- -- -- -- -- -- __ __ __ __ __ __ __ __ __ "
        "{{ {{ ^^ {{ {{ -- __ __ __ __ -- -- -- .. .. .. .. .. .. .. -- -- -- __ __ __ __ __ __ __ __ __ "
        "{{ ^^ ^^ ^^ {{ -- __ __ -- -- -- -- .. .. .. .. .. .. .. .. .. -- -- __ __ __ __ __ __ __ __ __ "
        "{{ {{ ^^ {{ {{ -- __ __ -- -- -- .. .. .. .. tt tt tt .. .. .. -- -- ~~ __ __ __ __ __ __ __ __ "
        "-- {{ {{ {{ -- __ __ __ -- -- .. .. .. .. tt tt tt tt tt .. .. -- -- -- ~~ ~~ ~~ ~~ __ __ __ __ "
        "-- -- -- -- -- __ __ __ -- -- .. .. .. tt tt tt ^^ tt tt tt .. -- -- -- -- -- -- -- -- __ __ __ "
        "__ __ __ __ __ __ __ __ -- -- .. .. .. tt tt ^^ ^^ ^^ tt tt tt tt -- -- {{ {{ {{ -- -- ~~ __ __ "
        "__ __ __ __ __ __ __ __ -- -- .. .. .. tt tt tt ^^ ^^ ^^ tt tt tt tt {{ {{ ^^ {{ {{ -- ~~ __ __ "
        "~~ __ __ __ __ __ __ __ __ -- .. .. .. .. tt tt tt tt ^^ ^^ ^^ tt tt {{ ^^ ^^ ^^ {{ -- -- ~~ ~~ "
        "~~ ~~ __ __ __ __ __ __ __ -- .. .. .. .. td tt tt tt ^^ ^^ ^^ ^^ tt ^^ ^^ ^^ {{ {{ -- -- -- -- "
        "~~ -- __ __ __ __ __ __ __ __ __ .. .. .. .. .. tt tt ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ -- -- {{ {{ {{ "
        "-- -- __ __ __ __ __ __ __ __ __ .. .. .. .. .. .. tt tt ^^ ^^ -- -- ^^ {{ {{ -- -- {{ {{ ^^ {{ "
        "{{ -- -- __ __ __ __ __ __ __ __ .. .. .. .. .. .. .. tt ^^ ^^ ^^ -- -- -- -- -- -- {{ ^^ ^^ ^^ "
        "-- -- ~~ -- __ __ __ __ __ __ __ __ -- -- .. .. .. .. ^^ ^^ ^^ ^^ ^^ {{ ~~ ~~ ~~ -- {{ {{ ^^ {{ "
        "-- ~~ ~~ ~~ __ __ __ __ __ __ __ __ __ -- -- -- -- ^^ ^^ ^^ {{ ^^ {{ -- -- -- -- -- -- {{ {{ {{ "
        "-- -- ~~ -- -- __ __ __ __ __ __ __ __ __ -- -- -- -- ^^ {{ {{ {{ -- -- {{ {{ {{ -- -- -- -- -- "
        "{{ -- -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ -- -- -- {{ -- -- {{ {{ ^^ {{ {{ -- -- {{ {{ "
        "{{ {{ {{ -- -- -- -- ~~ __ __ __ __ __ __ __ __ __ __ __ -- -- -- -- {{ ^^ ^^ ^^ {{ -- -- {{ ^^ "
        "^^ {{ {{ {{ -- -- ~~ ~~ ~~ -- __ __ __ __ __ __ __ __ __ __ __ ~~ -- {{ {{ ^^ {{ {{ -- -- {{ ^^ "
        "{{ {{ {{ -- -- -- -- ~~ -- -- -- __ __ __ __ __ __ __ __ __ __ ~~ -- -- {{ {{ {{ -- -- -- {{ {{ "
        "-- -- -- -- -- -- -- -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ -- -- -- -- -- -- -- -- -- {{ "
        "-- -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ ~~ ~~ ~~ ~~ ~~ -- ~~ -- -- "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- -- -- ~~ ~~ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ -- __ __ __ "
      )
    )
    (kern-mk-map nil 32 32 pal_expanded
      ;; Map Block #16/16 (3,3)
      ;;   NW= 96,96   NE=127,96  
      ;;   SW= 96,127  SE=127,127 
      
      (list
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "-- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "-- -- ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "{{ -- ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "{{ -- ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "{{ -- ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "-- -- ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "-- -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "{{ {{ -- -- ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "^^ {{ {{ -- ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "^^ ^^ {{ -- ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "^^ {{ {{ -- ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "{{ {{ -- -- ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "-- -- -- -- __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "~~ ~~ ~~ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        "__ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ "
        ))
)

(kern-load "raise-merciful-death.scm")

(kern-mk-place 
 'p_hring
 "The Shard Surface"
 nil          ; sprite 
 m_shard      ; map
 #f  ;; wraps
 #f  ;; underground
 #t  ;; wilderness
 #f  ;; tmp combat place

 ;; subplaces:
 (list
  (list p_moongate_clearing 51  46)
  (list p_gregors_hut       61  67)
  (list p_abandoned_farm    43  51)
  (list p_trigrave          29  51)
  (list p_enchanters_tower  29  21)
  (list p_green_tower       80  59)
  (list p_bole              86  40)
  (list p_glasdrin          82  18)
  (list p_oparine           12  78)
  (list p_absalot           120  4)
  (list p_engineers_hut     50   4)
  (list p_void_temple        5  46)
  (list p_poor_house        19  65)
  (list p_ankh_shrine       97   4)
  (list p_westpass          45  61)
  (list p_eastpass          43  61)
  (list p_ancient_derelict  43  17)
  (list p_gate_to_absalot  120  10)
  (list p_tower_of_absalot 120   8)
  (list p_kun               60  38)
  (list p_lost_halls_entrance (loc-x lost-halls-loc) (loc-y lost-halls-loc))
  (list p_voidgap_entrance   7  75)
  (list p_voidgap_exit       4  77)
  )


 nil ; neighbors

 ;; objects:
 (list

  ;; moongates
  (list (kern-tag 'mg-1 (mk-moongate 'ord)) 62 50) ;; near green tower
  (list (kern-tag 'mg-2 (mk-moongate 'ord)) 34 56) ;; near trigrave
  (list (kern-tag 'mg-3 (mk-moongate 'ord)) 19 82) ;; near oparine
  (list (kern-tag 'mg-8 (mk-moongate 'ord)) 21 19) ;; near enchanter's tower
  (list (kern-tag 'mg-5 (mk-moongate 'ord)) 56 27) ;; near kurpolis
  (list (kern-tag 'mg-6 (mk-moongate 'ord)) 90 26) ;; near lost halls & the man
  (list (kern-tag 'mg-7 (mk-moongate 'ord)) 125 18) ;; near absalot
  (list (kern-tag 'mg-4 (mk-moongate 'ord)) 50 7) ;; engineer's hut

  ;; npc party generator
  (put (mk-edge-spawn-generator) 0 0)

  ;; dungeons
  (put (mk-dungeon 'p_kurpolis_entrance 9 10) 53 18)
  (put (mk-dungeon 'p_mushroom_cave 7 12) 78 74)
  (put (mk-dungeon 'p_necromancers_lair 9 9) 40 70)
  (put (mk-dungeon 'p_smoldering_cave 9 9) 118 46)
  (put (mk-dungeon 'p_slimy_cavern 8 30) 13 8)
  
  

  ;; wreck of the Merciful Death
  (put (mk-raise-listener 'raise-merciful-death nil) 
       merciful-death-x 
       merciful-death-y)

  ;; Bandit Hideout
  (put (mk-step-trig 'mk-bandit-hideout nil)
       (loc-x bandit-hideout-loc)
       (loc-y bandit-hideout-loc))

  ;; Angriss's Lair
  (put (mk-step-trig 'mk-angriss-lair nil)
       (loc-x angriss-lair-loc)
       (loc-y angriss-lair-loc))

 ;; Brundegardt
  (put (mk-step-trig 'mk-brundegardt nil)
       (loc-x brundegardt-loc)
       (loc-y brundegardt-loc))

  ;; The MAN's hideout
  (put (mk-step-trig 'mk-mans-hideout nil)
       (loc-x the-mans-hideout-loc)
       (loc-y the-mans-hideout-loc))



  ) ;; end of objects

 nil ; hooks
 nil ; edge entrances
 )

(kern-obj-put-at (mk-world-musicdata 'ml-travelling) (list p_hring 0 0))
(kern-place-add-on-entry-hook p_hring 'music-on-combat-entry)