;; mk-scenery-type is rather like mk-reagent-type, 
;; but on the terrain features layer, and without an interface.
;; 
;; In future, it will be needful to have some kind of interface --
;; it is an explicit goal in Haxima to enable the player to interact with 
;; the world (and its' objects) whenever reasonable.
(define (mk-scenery-type tag name sprite)
  (mk-obj-type tag name sprite layer-tfeat nil))

;; Lightning bolts:
(mk-scenery-type 't_lightning_bolt_red        "lightning bolt" s_lightning_bolt_red)
(mk-scenery-type 't_lightning_bolt_green      "lightning bolt" s_lightning_bolt_green)
(mk-scenery-type 't_lightning_bolt_blue       "lightning bolt" s_lightning_bolt_blue)
(mk-scenery-type 't_lightning_bolt_cyan       "lightning bolt" s_lightning_bolt_cyan)
(mk-scenery-type 't_lightning_bolt_purple     "lightning bolt" s_lightning_bolt_purple)
(mk-scenery-type 't_lightning_bolt_yellow     "lightning bolt" s_lightning_bolt_yellow)
(mk-scenery-type 't_lightning_bolt_brown      "lightning bolt" s_lightning_bolt_brown)
(mk-scenery-type 't_lightning_bolt_orange     "lightning bolt" s_lightning_bolt_orange)
(mk-scenery-type 't_lightning_bolt_white      "lightning bolt" s_lightning_bolt_white)
(mk-scenery-type 't_lightning_bolt_grey       "lightning bolt" s_lightning_bolt_grey)
(mk-scenery-type 't_lightning_bolt_dark_grey  "lightning bolt" s_lightning_bolt_dark_grey)
(mk-scenery-type 't_lightning_bolt_chromatic  "lightning bolt" s_lightning_bolt_chromatic)
;; Magic ball (fireball core or similar):
(mk-scenery-type 't_fireball_red        "fireball" s_magic_ball_core_red)
(mk-scenery-type 't_fireball_green      "fireball" s_magic_ball_core_green)
(mk-scenery-type 't_fireball_blue       "fireball" s_magic_ball_core_blue)
(mk-scenery-type 't_fireball_cyan       "fireball" s_magic_ball_core_cyan)
(mk-scenery-type 't_fireball_purple     "fireball" s_magic_ball_core_purple)
(mk-scenery-type 't_fireball_yellow     "fireball" s_magic_ball_core_yellow)
(mk-scenery-type 't_fireball_brown      "fireball" s_magic_ball_core_brown)
(mk-scenery-type 't_fireball_orange     "fireball" s_magic_ball_core_orange)
(mk-scenery-type 't_fireball_white      "fireball" s_magic_ball_core_white)
(mk-scenery-type 't_fireball_grey       "fireball" s_magic_ball_core_grey)
(mk-scenery-type 't_fireball_dark_grey  "fireball" s_magic_ball_core_dark_grey)
(mk-scenery-type 't_fireball_chromatic  "fireball" s_magic_ball_core_chromatic)
;; Magic burst/bloom/aura/field (5 ball lightnings in one tile):
(mk-scenery-type 't_magic_field_red           "magic field" s_magic_field_red)
(mk-scenery-type 't_magic_field_green         "magic field" s_magic_field_green)
(mk-scenery-type 't_magic_field_blue          "magic field" s_magic_field_blue)
(mk-scenery-type 't_magic_field_cyan          "magic field" s_magic_field_cyan)
(mk-scenery-type 't_magic_field_purple        "magic field" s_magic_field_purple)
(mk-scenery-type 't_magic_field_yellow        "magic field" s_magic_field_yellow)
(mk-scenery-type 't_magic_field_brown         "magic field" s_magic_field_brown)
(mk-scenery-type 't_magic_field_orange        "magic field" s_magic_field_orange)
(mk-scenery-type 't_magic_field_white         "magic field" s_magic_field_white)
(mk-scenery-type 't_magic_field_grey          "magic field" s_magic_field_grey)
(mk-scenery-type 't_magic_field_dark_grey     "magic field" s_magic_field_dark_grey)
(mk-scenery-type 't_magic_field_blue_2        "magic field" s_magic_field_blue_2)
(mk-scenery-type 't_magic_field_red_pulsed    "pulsing magic field" s_magic_field_red_pulsed)
(mk-scenery-type 't_magic_field_green_pulsed  "pulsing magic field" s_magic_field_green_pulsed)
(mk-scenery-type 't_magic_field_blue_pulsed   "pulsing magic field" s_magic_field_blue_pulsed)
(mk-scenery-type 't_magic_field_white_pulsed  "pulsing magic field" s_magic_field_white_pulsed)
(mk-scenery-type 't_magic_field_purple_pulsed "pulsing magic field" s_magic_field_purple_pulsed)
(mk-scenery-type 't_magic_field_brown_pulsed  "pulsing magic field" s_magic_field_brown_pulsed)
(mk-scenery-type 't_magic_field_blue_2_pulsed "pulsing magic field" s_magic_field_blue_2_pulsed)
;; Chromatic ball lightning (8 frames):
(mk-scenery-type 't_magic_field_chromatic_pulsed "pulsing magic field" s_magic_field_chromatic_pulsed)
;; Lightning discharges:
(mk-scenery-type 't_lightning_discharge_red   "lightning" s_lightning_discharge_red)
(mk-scenery-type 't_lightning_discharge_green "lightning" s_lightning_discharge_green)
(mk-scenery-type 't_lightning_discharge_blue  "lightning" s_lightning_discharge_blue)
(mk-scenery-type 't_lightning_discharge_black "lightning" s_lightning_discharge_black)
;; Lightning discharges in cloud:
(mk-scenery-type 't_lightning_cloud_red    "lightning cloud" s_lightning_cloud_blue_red)
(mk-scenery-type 't_lightning_cloud_green  "lightning cloud" s_lightning_cloud_blue_green)
(mk-scenery-type 't_lightning_cloud_blue   "lightning cloud" s_lightning_cloud_blue_blue)
(mk-scenery-type 't_lightning_cloud_purple "lightning cloud" s_lightning_cloud_blue_purple)
(mk-scenery-type 't_lightning_cloud_yellow "lightning cloud" s_lightning_cloud_blue_yellow)
(mk-scenery-type 't_lightning_cloud_orange "lightning cloud" s_lightning_cloud_blue_orange)
;; Magical spheres:
(mk-scenery-type 't_magic_sphere_red    "magical sphere" s_magic_sphere_red)
(mk-scenery-type 't_magic_sphere_green  "magical sphere" s_magic_sphere_green)
(mk-scenery-type 't_magic_sphere_blue   "magical sphere" s_magic_sphere_blue)
(mk-scenery-type 't_magic_sphere_yellow "magical sphere" s_magic_sphere_yellow)
(mk-scenery-type 't_magic_sphere_purple "magical sphere" s_magic_sphere_purple)
(mk-scenery-type 't_magic_sphere_cyan   "magical sphere" s_magic_sphere_cyan)
;; Magical spheres with light rays:
(mk-scenery-type 't_magic_sphere_rays_red    "magical sphere" s_magic_sphere_rays_red)
(mk-scenery-type 't_magic_sphere_rays_green  "magical sphere" s_magic_sphere_rays_green)
(mk-scenery-type 't_magic_sphere_rays_blue   "magical sphere" s_magic_sphere_rays_blue)
(mk-scenery-type 't_magic_sphere_rays_yellow "magical sphere" s_magic_sphere_rays_yellow)
(mk-scenery-type 't_magic_sphere_rays_purple "magical sphere" s_magic_sphere_rays_purple)
(mk-scenery-type 't_magic_sphere_rays_cyan   "magical sphere" s_magic_sphere_rays_cyan)
;; Arrows and Bolts and such in flight:
(mk-scenery-type 't_arrow_wood_red    "arrow" s_arrow_wood_red)
(mk-scenery-type 't_arrow_metal_red   "arrow" s_arrow_metal_red)
(mk-scenery-type 't_arrow_wood_green  "arrow" s_arrow_wood_green)
(mk-scenery-type 't_arrow_metal_green "arrow" s_arrow_metal_green)


;; ss_dg_wearable
(mk-scenery-type 't_helm_leather_1    "helm" s_helm_leather_1)
(mk-scenery-type 't_helm_leather_2    "helm" s_helm_leather_2)
(mk-scenery-type 't_helm_metal_1      "helm" s_helm_metal_1)
(mk-scenery-type 't_helm_metal_2      "helm" s_helm_metal_2)
(mk-scenery-type 't_helm_metal_3      "helm" s_helm_metal_3)
(mk-scenery-type 't_helm_gold_horned  "helm" s_helm_gold_horned)
(mk-scenery-type 't_helm_metal_horned "helm" s_helm_metal_horned)
(mk-scenery-type 't_hat_green_feather "helm" s_hat_green_feather)
(mk-scenery-type 't_crown_1           "helm" s_crown_1)
(mk-scenery-type 't_crown_2           "helm" s_crown_2)
(mk-scenery-type 't_crown_3           "helm" s_crown_3)
(mk-scenery-type 't_crown_4           "helm" s_crown_4)

(mk-scenery-type 't_amulet_1   "amulet" s_amulet_1)
(mk-scenery-type 't_amulet_2   "amulet" s_amulet_2)
(mk-scenery-type 't_amulet_3   "amulet" s_amulet_3)
(mk-scenery-type 't_amulet_4   "amulet" s_amulet_4)
(mk-scenery-type 't_amulet_5   "amulet" s_amulet_5)
(mk-scenery-type 't_amulet_6   "amulet" s_amulet_6)
(mk-scenery-type 't_amulet_7   "amulet" s_amulet_7)
(mk-scenery-type 't_amulet_8   "amulet" s_amulet_8)
(mk-scenery-type 't_amulet_9   "amulet" s_amulet_9)
(mk-scenery-type 't_amulet_10  "amulet" s_amulet_10)
(mk-scenery-type 't_amulet_11  "amulet" s_amulet_11)
(mk-scenery-type 't_amulet_12  "amulet" s_amulet_12)
(mk-scenery-type 't_amulet_13  "amulet" s_amulet_13)
(mk-scenery-type 't_amulet_14  "amulet" s_amulet_14)
(mk-scenery-type 't_amulet_15  "amulet" s_amulet_15)
(mk-scenery-type 't_amulet_16  "amulet" s_amulet_16)

(mk-scenery-type 't_ring_1   "ring" s_ring_1)
(mk-scenery-type 't_ring_2   "ring" s_ring_2)
(mk-scenery-type 't_ring_3   "ring" s_ring_3)
(mk-scenery-type 't_ring_4   "ring" s_ring_4)
(mk-scenery-type 't_ring_5   "ring" s_ring_5)
(mk-scenery-type 't_ring_6   "ring" s_ring_6)
(mk-scenery-type 't_ring_7   "ring" s_ring_7)
(mk-scenery-type 't_ring_8   "ring" s_ring_8)
(mk-scenery-type 't_ring_9   "ring" s_ring_9)
(mk-scenery-type 't_ring_10  "ring" s_ring_10)
(mk-scenery-type 't_ring_11  "ring" s_ring_11)
(mk-scenery-type 't_ring_12  "ring" s_ring_12)
(mk-scenery-type 't_ring_13  "ring" s_ring_13)
(mk-scenery-type 't_ring_14  "ring" s_ring_14)
(mk-scenery-type 't_ring_15  "ring" s_ring_15)
(mk-scenery-type 't_ring_16  "ring" s_ring_16)
(mk-scenery-type 't_ring_17  "ring" s_ring_17)
(mk-scenery-type 't_ring_18  "ring" s_ring_18)
(mk-scenery-type 't_ring_19  "ring" s_ring_19)
(mk-scenery-type 't_ring_20  "ring" s_ring_20)
(mk-scenery-type 't_ring_21  "ring" s_ring_21)
(mk-scenery-type 't_ring_22  "ring" s_ring_22)
(mk-scenery-type 't_ring_23  "ring" s_ring_23)
(mk-scenery-type 't_ring_24  "ring" s_ring_24)

(mk-scenery-type 't_cloak_1  "cloak" s_cloak_1)
(mk-scenery-type 't_cloak_2  "cloak" s_cloak_2)
(mk-scenery-type 't_cloak_3  "cloak" s_cloak_3)
(mk-scenery-type 't_cloak_4  "cloak" s_cloak_4)
(mk-scenery-type 't_cloak_5  "cloak" s_cloak_5)
(mk-scenery-type 't_cloak_6  "cloak" s_cloak_6)
(mk-scenery-type 't_cloak_7  "cloak" s_cloak_7)
(mk-scenery-type 't_cloak_8  "cloak" s_cloak_8)
(mk-scenery-type 't_cloak_9  "cloak" s_cloak_9)

(mk-scenery-type 't_robe_1    "robe" s_robe_1)
(mk-scenery-type 't_robe_2    "robe" s_robe_2)
(mk-scenery-type 't_robe_3    "robe" s_robe_3)
(mk-scenery-type 't_robe_4    "robe" s_robe_4)
(mk-scenery-type 't_robe_rags "robe" s_robe_rags)

(mk-scenery-type 't_gloves_green  "gloves" s_gloves_green)
(mk-scenery-type 't_gloves_tan    "gloves" s_gloves_tan)
(mk-scenery-type 't_gloves_brown  "gloves" s_gloves_brown)
(mk-scenery-type 't_gloves_grey   "gloves" s_gloves_grey)
(mk-scenery-type 't_gloves_yellow "gloves" s_gloves_yellow)
(mk-scenery-type 't_gloves_blue   "gloves" s_gloves_blue)

(mk-scenery-type 't_boots_green  "boots" s_boots_green)
(mk-scenery-type 't_boots_tan    "boots" s_boots_tan)
(mk-scenery-type 't_boots_brown  "boots" s_boots_brown)
(mk-scenery-type 't_boots_metal  "boots" s_boots_metal)
(mk-scenery-type 't_boots_yellow "boots" s_boots_yellow)

(mk-scenery-type 't_shield_pattern_1  "shield" s_shield_pattern_1)
(mk-scenery-type 't_shield_pattern_2  "shield" s_shield_pattern_2)
(mk-scenery-type 't_shield_pattern_3  "shield" s_shield_pattern_3)
(mk-scenery-type 't_shield_pattern_4  "shield" s_shield_pattern_4)
(mk-scenery-type 't_shield_pattern_5  "shield" s_shield_pattern_5)
(mk-scenery-type 't_shield_pattern_6  "shield" s_shield_pattern_6)
(mk-scenery-type 't_shield_pattern_7  "shield" s_shield_pattern_7)
(mk-scenery-type 't_shield_pattern_blank_gold "shield" s_shield_blank_gold)

(mk-scenery-type 't_shield_blank_wooden_1  "shield" s_shield_blank_wooden_1)
(mk-scenery-type 't_shield_blank_wooden_2  "shield" s_shield_blank_wooden_2)
(mk-scenery-type 't_shield_blank_round_1   "shield" s_shield_blank_round_1)
(mk-scenery-type 't_shield_blank_round_2   "shield" s_shield_blank_round_2)
(mk-scenery-type 't_shield_blank_round_3   "shield" s_shield_blank_round_3)
(mk-scenery-type 't_shield_blank_heater_1  "shield" s_shield_blank_heater_1)
(mk-scenery-type 't_shield_blank_heater_2  "shield" s_shield_blank_heater_2)

(mk-scenery-type 't_breastplate_dragon_1 "breastplate" s_breastplate_dragon_1)
(mk-scenery-type 't_breastplate_dragon_2 "breastplate" s_breastplate_dragon_2)
(mk-scenery-type 't_breastplate_dragon_3 "breastplate" s_breastplate_dragon_3)
(mk-scenery-type 't_breastplate_dragon_4 "breastplate" s_breastplate_dragon_4)
(mk-scenery-type 't_breastplate_dragon_5 "breastplate" s_breastplate_dragon_5)
(mk-scenery-type 't_breastplate_dragon_6 "breastplate" s_breastplate_dragon_6)

(mk-scenery-type 't_shield_symbol_crown        "shield" s_shield_symbol_crown)
(mk-scenery-type 't_shield_symbol_unicorn_1    "shield" s_shield_symbol_unicorn_1)
(mk-scenery-type 't_shield_symbol_unicorn_2    "shield" s_shield_symbol_unicorn_2)
(mk-scenery-type 't_shield_symbol_lion_rampant "shield" s_shield_symbol_lion_rampant)
(mk-scenery-type 't_shield_symbol_skull        "shield" s_shield_symbol_skull)

(mk-scenery-type 't_armor_leather_1  "leather armor" s_armor_leather_1)
(mk-scenery-type 't_armor_leather_2  "leather armor" s_armor_leather_2)
(mk-scenery-type 't_armor_leather_3  "leather armor" s_armor_leather_3)
(mk-scenery-type 't_armor_leather_4  "leather armor" s_armor_leather_4)
(mk-scenery-type 't_armor_leather_5  "leather armor" s_armor_leather_5)

(mk-scenery-type 't_armor_golden_1   "golden armor" s_armor_golden_1)
(mk-scenery-type 't_armor_green_1    "green armor"  s_armor_green_1)

(mk-scenery-type 't_armor_chain_1    "chain armor" s_armor_chain_1)
(mk-scenery-type 't_armor_chain_2    "chain armor" s_armor_chain_2)
(mk-scenery-type 't_armor_chain_3    "chain armor" s_armor_chain_3)
(mk-scenery-type 't_armor_chain_4    "chain armor" s_armor_chain_4)
(mk-scenery-type 't_armor_chain_5    "chain armor" s_armor_chain_5)
(mk-scenery-type 't_armor_chain_6    "chain armor" s_armor_chain_6)
(mk-scenery-type 't_armor_chain_7    "chain armor" s_armor_chain_7)
(mk-scenery-type 't_armor_chain_8    "chain armor" s_armor_chain_8)

(mk-scenery-type 't_armor_plate_1    "plate armor" s_armor_plate_1)
(mk-scenery-type 't_armor_plate_2    "plate armor" s_armor_plate_2)
(mk-scenery-type 't_armor_plate_3    "plate armor" s_armor_plate_3)
(mk-scenery-type 't_armor_plate_4    "plate armor" s_armor_plate_4)
(mk-scenery-type 't_armor_plate_5    "plate armor" s_armor_plate_5)

(mk-scenery-type 't_armor_dragon_1   "dragon armor" s_armor_dragon_1)
(mk-scenery-type 't_armor_dragon_2   "dragon armor" s_armor_dragon_2)
(mk-scenery-type 't_armor_dragon_3   "dragon armor" s_armor_dragon_3)
(mk-scenery-type 't_armor_dragon_4   "dragon armor" s_armor_dragon_4)
(mk-scenery-type 't_armor_dragon_5   "dragon armor" s_armor_dragon_5)
(mk-scenery-type 't_armor_dragon_6   "dragon armor" s_armor_dragon_6)
(mk-scenery-type 't_armor_dragon_7   "dragon armor" s_armor_dragon_7)
(mk-scenery-type 't_armor_dragon_8   "dragon armor" s_armor_dragon_8)
(mk-scenery-type 't_armor_dragon_9   "dragon armor" s_armor_dragon_9)
(mk-scenery-type 't_armor_dragon_10  "dragon armor" s_armor_dragon_10)
(mk-scenery-type 't_armor_dragon_11  "dragon armor" s_armor_dragon_11)
(mk-scenery-type 't_armor_dragon_12  "dragon armor" s_armor_dragon_12)
(mk-scenery-type 't_armor_dragon_13  "dragon armor" s_armor_dragon_13)
(mk-scenery-type 't_armor_dragon_14  "dragon armor" s_armor_dragon_14)
(mk-scenery-type 't_armor_dragon_15  "dragon armor" s_armor_dragon_15)
(mk-scenery-type 't_armor_dragon_16  "dragon armor" s_armor_dragon_16)


;; ss_dg_weapons
(mk-scenery-type 't_sword_broken_1 "broken sword" s_sword_broken_1)
(mk-scenery-type 't_sword_broken_2 "broken sword" s_sword_broken_2)
(mk-scenery-type 't_sword_broken_3 "broken sword" s_sword_broken_3)
(mk-scenery-type 't_sword_broken_4 "broken sword" s_sword_broken_4)

(mk-scenery-type 't_dagger_1 "dagger" s_dagger_1)
(mk-scenery-type 't_dagger_2 "dagger" s_dagger_2)
(mk-scenery-type 't_dagger_3 "dagger" s_dagger_3)

(mk-scenery-type 't_sword_short_1 "short sword" s_sword_short_1)
(mk-scenery-type 't_sword_short_2 "short sword" s_sword_short_2)
(mk-scenery-type 't_sword_short_3 "short sword" s_sword_short_3)

(mk-scenery-type 't_rapier_1   "rapier"  s_rapier_1)
(mk-scenery-type 't_rapier_2   "rapier"  s_rapier_2)
(mk-scenery-type 't_saber_1    "saber"   s_saber_1)
(mk-scenery-type 't_saber_2    "saber"   s_saber_2)
(mk-scenery-type 't_cutlass_1  "cutlass" s_cutlass_1)
(mk-scenery-type 't_cutlass_2  "cutlass" s_cutlass_2)
(mk-scenery-type 't_falchion_1 "falcion" s_falchion_1)

(mk-scenery-type 't_sword_long_1 "long sword" s_sword_long_1)
(mk-scenery-type 't_sword_long_2 "long sword" s_sword_long_2)
(mk-scenery-type 't_sword_long_3 "long sword" s_sword_long_3)

(mk-scenery-type 't_sword_bastard "bastard sword" s_sword_bastard)
(mk-scenery-type 't_sword_katana  "katana"        s_sword_katana)

(mk-scenery-type 't_sword_zweihander "zweihander"   s_sword_zweihander)
(mk-scenery-type 't_sword_vorpal     "vorpal sword" s_sword_vorpal)

(mk-scenery-type 't_sword_eldritch "eldritch sword" s_sword_eldritch)
(mk-scenery-type 't_sword_mystic   "mystic sword"   s_sword_mystic)
(mk-scenery-type 't_sword_flaming  "flaming sword"  s_sword_flaming)

(mk-scenery-type 't_mace_1       "mace" s_mace_1)
(mk-scenery-type 't_mace_2       "mace" s_mace_2)
(mk-scenery-type 't_mace_3       "mace" s_mace_3)
(mk-scenery-type 't_mace_4       "mace" s_mace_4)
(mk-scenery-type 't_mace_magical "mace" s_mace_magical)

(mk-scenery-type 't_hammer_golden       "hammer" s_hammer_golden)
(mk-scenery-type 't_hammer_warhammer    "hammer" s_hammer_warhammer)
(mk-scenery-type 't_hammer_sledgehammer "hammer" s_hammer_sledgehammer)
(mk-scenery-type 't_hammer_giant        "hammer" s_hammer_giant)

(mk-scenery-type 't_flail_1 "flail" s_flail_1)
(mk-scenery-type 't_flail_2 "flail" s_flail_2)
(mk-scenery-type 't_flail_3 "flail" s_flail_3)
(mk-scenery-type 't_flail_4 "flail" s_flail_4)
(mk-scenery-type 't_flail_5 "flail" s_flail_5)
(mk-scenery-type 't_nunchaku_1 "nunchaku" s_nunchaku_1)
(mk-scenery-type 't_nunchaku_2 "nunchaku" s_nunchaku_2)

(mk-scenery-type 't_whip "whip" s_whip)

(mk-scenery-type 't_axe_1 "axe" s_axe_1)
(mk-scenery-type 't_axe_2 "axe" s_axe_2)
(mk-scenery-type 't_axe_3 "axe" s_axe_3)
(mk-scenery-type 't_axe_4 "axe" s_axe_4)
(mk-scenery-type 't_axe_5 "axe" s_axe_5)

(mk-scenery-type 't_scythe_1 "scythe" s_scythe_1)
(mk-scenery-type 't_scythe_2 "scythe" s_scythe_2)

(mk-scenery-type 't_spear_1   "spear"   s_spear_1)
(mk-scenery-type 't_spear_2   "spear"   s_spear_2)
(mk-scenery-type 't_spear_3   "spear"   s_spear_3)
(mk-scenery-type 't_trident_1 "trident" s_trident_1)
(mk-scenery-type 't_trident_2 "trident" s_trident_2)
(mk-scenery-type 't_trident_3 "trident" s_trident_3)
(mk-scenery-type 't_lance     "lance"   s_lance)

(mk-scenery-type 't_quarterstaff_1 "quarterstaff" s_quarterstaff_1)
(mk-scenery-type 't_quarterstaff_2 "quarterstaff" s_quarterstaff_2)

(mk-scenery-type 't_halberd_1 "halberd" s_halberd_1)
(mk-scenery-type 't_halberd_2 "halberd" s_halberd_2)
(mk-scenery-type 't_halberd_3 "halberd" s_halberd_3)

(mk-scenery-type 't_shortbow   "shortbow" s_shortbow)
(mk-scenery-type 't_longbow_1  "longbow"  s_longbow_1)
(mk-scenery-type 't_longbow_2  "longbow"  s_longbow_2)
(mk-scenery-type 't_crossbow_1 "crossbow" s_crossbow_1)
(mk-scenery-type 't_crossbow_2 "crossbow" s_crossbow_2)
(mk-scenery-type 't_crossbow_3 "crossbow" s_crossbow_3)

(mk-scenery-type 't_sling "sling" s_sling)
(mk-scenery-type 't_sling_bullet "sling bullet" s_sling_bullet)
(mk-scenery-type 't_sling_stones "sling stones" s_sling_stones)

(mk-scenery-type 't_dart_red            "red dart"   s_dart_red)
(mk-scenery-type 't_dart_green_dripping "green dart" s_dart_green_dripping)
(mk-scenery-type 't_dart_blue_dripping  "blue dart"  s_dart_blue_dripping)
(mk-scenery-type 't_shuriken            "shuriken"   s_shuriken)
(mk-scenery-type 't_shuriken_spinning   "shuriken"   s_shuriken_spinning)

(mk-scenery-type 't_arrow_wooden "wooden arrow" s_arrow_wooden)
(mk-scenery-type 't_arrow_metal  "metal arrow"  s_arrow_metal)
(mk-scenery-type 't_arrow_white  "white arrow"  s_arrow_white)
(mk-scenery-type 't_arrow_gold   "golden arrow" s_arrow_gold)

(mk-scenery-type 't_arrow_glowing_red   "glowing red arrow"   s_arrow_glowing_red)
(mk-scenery-type 't_arrow_glowing_green "glowing green arrow" s_arrow_glowing_green) ;; fix sprite

(mk-scenery-type 't_arrow_wooden_flaming "wooden flaming arrow" s_arrow_wooden_flaming)
(mk-scenery-type 't_arrow_metal_flaming  "metal flaming arrow"  s_arrow_metal_flaming)
(mk-scenery-type 't_arrow_wooden_acid    "wooden acid arrow"    s_arrow_wooden_acid)
(mk-scenery-type 't_arrow_metal_acid     "metal acid arrow"     s_arrow_metal_acid)
(mk-scenery-type 't_arrow_wooden_frost   "wooden frost arrow"   s_arrow_wooden_frost)
(mk-scenery-type 't_arrow_metal_frost    "metal frost arrow"    s_arrow_metal_frost)

(mk-scenery-type 't_arrow_glowing_blue   "glowing blue arrow"   s_arrow_glowing_blue)
(mk-scenery-type 't_arrow_glowing_purple "glowing purple arrow" s_arrow_glowing_purple)

(mk-scenery-type 't_bolt_wooden "wooden bolt" s_bolt_wooden)
(mk-scenery-type 't_bolt_metal  "metal bolt"  s_bolt_metal)
(mk-scenery-type 't_bolt_white  "white bolt"  s_bolt_white)
(mk-scenery-type 't_bolt_gold   "golden bolt" s_bolt_gold)

(mk-scenery-type 't_bolt_glowing_red    "glowing red bolt"    s_bolt_glowing_red)
(mk-scenery-type 't_bolt_glowing_green  "glowing green bolt"  s_bolt_glowing_green)

(mk-scenery-type 't_bolt_wooden_flaming "wooden flaming bolt" s_bolt_wooden_flaming)
(mk-scenery-type 't_bolt_metal_flaming  "metal flaming bolt"  s_bolt_metal_flaming)
(mk-scenery-type 't_bolt_wooden_acid    "wooden acid bolt"    s_bolt_wooden_acid)
(mk-scenery-type 't_bolt_metal_acid     "metal acid bolt"     s_bolt_metal_acid)
(mk-scenery-type 't_bolt_wooden_frost   "wooden frost bolt"   s_bolt_wooden_frost)
(mk-scenery-type 't_bolt_metal_frost    "metal frost bolt"    s_bolt_metal_frost)

(mk-scenery-type 't_bolt_glowing_blue   "glowing blue bolt"   s_bolt_glowing_blue)   ;; fix sprite
(mk-scenery-type 't_bolt_glowing_purple "glowing purple bolt" s_bolt_glowing_purple) ;; fix sprite


;; ss_dg_tools
(mk-scenery-type 't_chest_small_wooden_closed   "small wooden chest (closed)"  s_chest_small_wooden_closed)
(mk-scenery-type 't_chest_large_wooden_closed   "large wooden chest (closed)"  s_chest_large_wooden_closed)
(mk-scenery-type 't_chest_small_metal_1_closed  "small metal chest (closed)"   s_chest_small_metal_1_closed)
(mk-scenery-type 't_chest_large_metal_1_closed  "large metal chest (closed)"   s_chest_large_metal_1_closed)
(mk-scenery-type 't_chest_small_metal_2_closed  "small metal chest (closed)"   s_chest_small_metal_2_closed)
(mk-scenery-type 't_chest_small_metal_2_closed  "small metal chest (closed)"   s_chest_small_metal_2_closed)
(mk-scenery-type 't_chest_wooden_broken         "broken wooden chest"          s_chest_wooden_broken)

(mk-scenery-type 't_metal_spike   "metal spike" s_metal_spike)

(mk-scenery-type 't_pickaxe_1     "pickaxe" s_pickaxe_1)
(mk-scenery-type 't_pickaxe_2     "pickaxe" s_pickaxe_2)
(mk-scenery-type 't_pickaxe_3     "pickaxe" s_pickaxe_3)
(mk-scenery-type 't_pickaxe_4     "pickaxe" s_pickaxe_4)

(mk-scenery-type 't_shovel_1      "shovel"  s_shovel_1)
(mk-scenery-type 't_shovel_2      "shovel"  s_shovel_2)
(mk-scenery-type 't_shovel_3      "shovel"  s_shovel_3)
(mk-scenery-type 't_shovel_4      "shovel"  s_shovel_4)

(mk-scenery-type 't_lamp_1_unlit  "lamp (unlit)"  s_lamp_1_unlit)
(mk-scenery-type 't_lamp_1_lit    "lamp (lit)"    s_lamp_1_lit)
(mk-scenery-type 't_lamp_2_unlit  "lamp (unlit)"  s_lamp_2_unlit)
(mk-scenery-type 't_lamp_2_lit    "lamp (lit)"    s_lamp_2_lit)
(mk-scenery-type 't_torch_unlit   "torch (unlit)" s_torch_unlit)
(mk-scenery-type 't_torch_lit     "torch (lit)"   s_torch_lit)

(mk-scenery-type 't_rod_1  "rod" s_rod_1)
(mk-scenery-type 't_rod_2  "rod" s_rod_2)
(mk-scenery-type 't_rod_3  "rod" s_rod_3)
(mk-scenery-type 't_rod_4  "rod" s_rod_4)
(mk-scenery-type 't_rod_5  "rod" s_rod_5)
(mk-scenery-type 't_rod_6  "rod" s_rod_6)
(mk-scenery-type 't_rod_7  "rod" s_rod_7)
(mk-scenery-type 't_rod_8  "rod" s_rod_8)
(mk-scenery-type 't_rod_9  "rod" s_rod_9)

(mk-scenery-type 't_wand_1  "wand" s_wand_1)
(mk-scenery-type 't_wand_2  "wand" s_wand_2)
(mk-scenery-type 't_wand_3  "wand" s_wand_3)
(mk-scenery-type 't_wand_4  "wand" s_wand_4)
(mk-scenery-type 't_wand_5  "wand" s_wand_5)
(mk-scenery-type 't_wand_6  "wand" s_wand_6)
(mk-scenery-type 't_wand_7  "wand" s_wand_7)
(mk-scenery-type 't_wand_8  "wand" s_wand_8)
(mk-scenery-type 't_wand_9  "wand" s_wand_9)

(mk-scenery-type 't_staff_1  "staff" s_staff_1)
(mk-scenery-type 't_staff_2  "staff" s_staff_2)
(mk-scenery-type 't_staff_3  "staff" s_staff_3)
(mk-scenery-type 't_staff_4  "staff" s_staff_4)
(mk-scenery-type 't_staff_5  "staff" s_staff_5)
(mk-scenery-type 't_staff_6  "staff" s_staff_6)
(mk-scenery-type 't_staff_7  "staff" s_staff_7)


;; ss_dg_readable
(mk-scenery-type 't_scroll_magic_1  "scroll"       s_scroll_magic_1)
(mk-scenery-type 't_scroll_magic_2  "scroll"       s_scroll_magic_2)
(mk-scenery-type 't_scroll_magic_3  "scroll"       s_scroll_magic_3)
(mk-scenery-type 't_scroll_magic_4  "scroll"       s_scroll_magic_4)
(mk-scenery-type 't_scroll_magic_5  "scroll"       s_scroll_magic_5)
(mk-scenery-type 't_scroll_magic_6  "scroll"       s_scroll_magic_6)
(mk-scenery-type 't_scroll_magic_7  "scroll"       s_scroll_magic_7)
(mk-scenery-type 't_scroll_magic_8  "scroll"       s_scroll_magic_8)

(mk-scenery-type 't_scroll_spell_1  "spell scroll" s_scroll_spell_1)
(mk-scenery-type 't_scroll_spell_2  "spell scroll" s_scroll_spell_2)
(mk-scenery-type 't_scroll_spell_3  "spell scroll" s_scroll_spell_3)
(mk-scenery-type 't_scroll_spell_4  "spell scroll" s_scroll_spell_4)
(mk-scenery-type 't_scroll_spell_5  "spell scroll" s_scroll_spell_5)
(mk-scenery-type 't_scroll_spell_6  "spell scroll" s_scroll_spell_6)
(mk-scenery-type 't_scroll_spell_7  "spell scroll" s_scroll_spell_7)
(mk-scenery-type 't_scroll_spell_8  "spell scroll" s_scroll_spell_8)
(mk-scenery-type 't_scroll_spell_9  "spell scroll" s_scroll_spell_9)
(mk-scenery-type 't_scroll_spell_10 "spell scroll" s_scroll_spell_10)
(mk-scenery-type 't_scroll_spell_11 "spell scroll" s_scroll_spell_11)
(mk-scenery-type 't_scroll_spell_12 "spell scroll" s_scroll_spell_12)
(mk-scenery-type 't_scroll_spell_13 "spell scroll" s_scroll_spell_13)
(mk-scenery-type 't_scroll_spell_14 "spell scroll" s_scroll_spell_14)
(mk-scenery-type 't_scroll_spell_15 "spell scroll" s_scroll_spell_15)
(mk-scenery-type 't_scroll_spell_16 "spell scroll" s_scroll_spell_16)

(mk-scenery-type 't_scroll_spell_17 "spell scroll" s_scroll_spell_17)
(mk-scenery-type 't_scroll_spell_18 "spell scroll" s_scroll_spell_18)
(mk-scenery-type 't_scroll_spell_19 "spell scroll" s_scroll_spell_19)
(mk-scenery-type 't_scroll_spell_20 "spell scroll" s_scroll_spell_20)
(mk-scenery-type 't_scroll_spell_21 "spell scroll" s_scroll_spell_21)
(mk-scenery-type 't_scroll_spell_22 "spell scroll" s_scroll_spell_22)
(mk-scenery-type 't_scroll_spell_23 "spell scroll" s_scroll_spell_23)
(mk-scenery-type 't_scroll_spell_24 "spell scroll" s_scroll_spell_24)
(mk-scenery-type 't_scroll_spell_25 "spell scroll" s_scroll_spell_25)
(mk-scenery-type 't_scroll_spell_26 "spell scroll" s_scroll_spell_26)
(mk-scenery-type 't_scroll_spell_27 "spell scroll" s_scroll_spell_27)
(mk-scenery-type 't_scroll_spell_28 "spell scroll" s_scroll_spell_28)
(mk-scenery-type 't_scroll_spell_29 "spell scroll" s_scroll_spell_29)
(mk-scenery-type 't_scroll_spell_30 "spell scroll" s_scroll_spell_30)
(mk-scenery-type 't_scroll_spell_31 "spell scroll" s_scroll_spell_31)
(mk-scenery-type 't_scroll_spell_32 "spell scroll" s_scroll_spell_32)

(mk-scenery-type 't_scroll_spell_33 "spell scroll" s_scroll_spell_33)
(mk-scenery-type 't_scroll_spell_34 "spell scroll" s_scroll_spell_34)
(mk-scenery-type 't_scroll_spell_35 "spell scroll" s_scroll_spell_35)
(mk-scenery-type 't_scroll_spell_36 "spell scroll" s_scroll_spell_36)
(mk-scenery-type 't_scroll_spell_37 "spell scroll" s_scroll_spell_37)
(mk-scenery-type 't_scroll_spell_38 "spell scroll" s_scroll_spell_38)
(mk-scenery-type 't_scroll_spell_39 "spell scroll" s_scroll_spell_39)
(mk-scenery-type 't_scroll_spell_40 "spell scroll" s_scroll_spell_40)
(mk-scenery-type 't_scroll_spell_41 "spell scroll" s_scroll_spell_41)
(mk-scenery-type 't_scroll_spell_42 "spell scroll" s_scroll_spell_42)

(mk-scenery-type 't_book_red_1 "book" s_book_red_1)
(mk-scenery-type 't_book_red_2 "book" s_book_red_2)
(mk-scenery-type 't_book_red_3 "book" s_book_red_3)
(mk-scenery-type 't_book_red_4 "book" s_book_red_4)

(mk-scenery-type 't_book_red_glowing_1 "magical book" s_book_red_glowing_1)
(mk-scenery-type 't_book_red_glowing_2 "magical book" s_book_red_glowing_2)
(mk-scenery-type 't_book_red_glowing_3 "magical book" s_book_red_glowing_3)
(mk-scenery-type 't_book_red_glowing_4 "magical book" s_book_red_glowing_4)
(mk-scenery-type 't_book_red_glowing_5 "magical book" s_book_red_glowing_5)

(mk-scenery-type 't_book_grey_1 "book" s_book_grey_1)
(mk-scenery-type 't_book_grey_2 "book" s_book_grey_2)
(mk-scenery-type 't_book_grey_3 "book" s_book_grey_3)
(mk-scenery-type 't_book_grey_4 "book" s_book_grey_4)

(mk-scenery-type 't_book_grey_glowing_1 "magical book" s_book_grey_glowing_1)
(mk-scenery-type 't_book_grey_glowing_2 "magical book" s_book_grey_glowing_2)
(mk-scenery-type 't_book_grey_glowing_3 "magical book" s_book_grey_glowing_3)
(mk-scenery-type 't_book_grey_glowing_4 "magical book" s_book_grey_glowing_4)
(mk-scenery-type 't_book_grey_glowing_5 "magical book" s_book_grey_glowing_5)

(mk-scenery-type 't_book_blue_1 "book" s_book_blue_1)
(mk-scenery-type 't_book_blue_2 "book" s_book_blue_2)
(mk-scenery-type 't_book_blue_3 "book" s_book_blue_3)
(mk-scenery-type 't_book_blue_4 "book" s_book_blue_4)

(mk-scenery-type 't_book_blue_glowing_1 "magical book" s_book_blue_glowing_1)
(mk-scenery-type 't_book_blue_glowing_2 "magical book" s_book_blue_glowing_2)
(mk-scenery-type 't_book_blue_glowing_3 "magical book" s_book_blue_glowing_3)
(mk-scenery-type 't_book_blue_glowing_4 "magical book" s_book_blue_glowing_4)
(mk-scenery-type 't_book_blue_glowing_5 "magical book" s_book_blue_glowing_5)

(mk-scenery-type 't_book_green_1 "book" s_book_green_1)
(mk-scenery-type 't_book_green_2 "book" s_book_green_2)
(mk-scenery-type 't_book_green_3 "book" s_book_green_3)
(mk-scenery-type 't_book_green_4 "book" s_book_green_4)

(mk-scenery-type 't_book_green_glowing_1 "magical book" s_book_green_glowing_1)
(mk-scenery-type 't_book_green_glowing_2 "magical book" s_book_green_glowing_2)
(mk-scenery-type 't_book_green_glowing_3 "magical book" s_book_green_glowing_3)
(mk-scenery-type 't_book_green_glowing_4 "magical book" s_book_green_glowing_4)
(mk-scenery-type 't_book_green_glowing_5 "magical book" s_book_green_glowing_5)

(mk-scenery-type 't_book_orange_1 "book" s_book_orange_1)
(mk-scenery-type 't_book_orange_2 "book" s_book_orange_2)
(mk-scenery-type 't_book_orange_3 "book" s_book_orange_3)
(mk-scenery-type 't_book_orange_4 "book" s_book_orange_4)

(mk-scenery-type 't_book_orange_glowing_1 "magical book" s_book_orange_glowing_1)
(mk-scenery-type 't_book_orange_glowing_2 "magical book" s_book_orange_glowing_2)
(mk-scenery-type 't_book_orange_glowing_3 "magical book" s_book_orange_glowing_3)
(mk-scenery-type 't_book_orange_glowing_4 "magical book" s_book_orange_glowing_4)
(mk-scenery-type 't_book_orange_glowing_5 "magical book" s_book_orange_glowing_5)

(mk-scenery-type 't_book_lite_blue_1 "book" s_book_lite_blue_1)
(mk-scenery-type 't_book_lite_blue_2 "book" s_book_lite_blue_2)
(mk-scenery-type 't_book_lite_blue_3 "book" s_book_lite_blue_3)
(mk-scenery-type 't_book_lite_blue_4 "book" s_book_lite_blue_4)

(mk-scenery-type 't_book_lite_blue_glowing_1 "magical book" s_book_lite_blue_glowing_1)
(mk-scenery-type 't_book_lite_blue_glowing_2 "magical book" s_book_lite_blue_glowing_2)
(mk-scenery-type 't_book_lite_blue_glowing_3 "magical book" s_book_lite_blue_glowing_3)
(mk-scenery-type 't_book_lite_blue_glowing_4 "magical book" s_book_lite_blue_glowing_4)
(mk-scenery-type 't_book_lite_blue_glowing_5 "magical book" s_book_lite_blue_glowing_5)

(mk-scenery-type 't_book_pink_1 "book" s_book_pink_1)
(mk-scenery-type 't_book_pink_2 "book" s_book_pink_2)
(mk-scenery-type 't_book_pink_3 "book" s_book_pink_3)
(mk-scenery-type 't_book_pink_4 "book" s_book_pink_4)

(mk-scenery-type 't_book_pink_glowing_1 "magical book" s_book_pink_glowing_1)
(mk-scenery-type 't_book_pink_glowing_2 "magical book" s_book_pink_glowing_2)
(mk-scenery-type 't_book_pink_glowing_3 "magical book" s_book_pink_glowing_3)
(mk-scenery-type 't_book_pink_glowing_4 "magical book" s_book_pink_glowing_4)
(mk-scenery-type 't_book_pink_glowing_5 "magical book" s_book_pink_glowing_5)


;; ss_dg_commodities
(mk-scenery-type 't_dg_biscuit    "biscuit"    s_dg_biscuit)
(mk-scenery-type 't_dg_bread      "bread"      s_dg_bread)
(mk-scenery-type 't_dg_jerky      "jerky"      s_dg_jerky)
(mk-scenery-type 't_dg_ham        "ham"        s_dg_ham)
(mk-scenery-type 't_dg_chicken    "chicken"    s_dg_chicken)
(mk-scenery-type 't_dg_moldy_meat "moldy meat" s_dg_moldy_meat)

(mk-scenery-type 't_dg_booze_jug  "jug of booze"  s_dg_booze_jug)
(mk-scenery-type 't_dg_beer_mug   "mug of beer"   s_dg_beer_mug)
(mk-scenery-type 't_dg_wine_flask "flask of wine" s_dg_wine_flask)

(mk-scenery-type 't_dg_mushroom_black      "mushroom" s_dg_mushroom_black)
(mk-scenery-type 't_dg_mushroom_white      "mushroom" s_dg_mushroom_white)
(mk-scenery-type 't_dg_mushroom_grey       "mushroom" s_dg_mushroom_grey)
(mk-scenery-type 't_dg_mushroom_orange     "mushroom" s_dg_mushroom_orange)
(mk-scenery-type 't_dg_mushroom_red        "mushroom" s_dg_mushroom_red)
(mk-scenery-type 't_dg_mushroom_green      "mushroom" s_dg_mushroom_green)
(mk-scenery-type 't_dg_mushroom_blue       "mushroom" s_dg_mushroom_blue)
(mk-scenery-type 't_dg_mushroom_brown      "mushroom" s_dg_mushroom_brown)
(mk-scenery-type 't_dg_mushroom_grey_2     "mushroom" s_dg_mushroom_grey_2)
(mk-scenery-type 't_dg_mushroom_white_2    "mushroom" s_dg_mushroom_white_2)
(mk-scenery-type 't_dg_mushroom_purple     "mushroom" s_dg_mushroom_purple)
(mk-scenery-type 't_dg_mushroom_yellow_2   "mushroom" s_dg_mushroom_yellow_2)
(mk-scenery-type 't_dg_mushroom_red_2      "mushroom" s_dg_mushroom_red_2)
(mk-scenery-type 't_dg_mushroom_green_2    "mushroom" s_dg_mushroom_green_2)
(mk-scenery-type 't_dg_mushroom_light_blue "mushroom" s_dg_mushroom_light_blue)
(mk-scenery-type 't_dg_mushroom_tan        "mushroom" s_dg_mushroom_tan)

(mk-scenery-type 't_dg_mushroom_bunch_grey   "mushrooms" s_dg_mushroom_bunch_grey)
(mk-scenery-type 't_dg_mushroom_bunch_green  "mushrooms" s_dg_mushroom_bunch_green)
(mk-scenery-type 't_dg_mushroom_bunch_tan    "mushrooms" s_dg_mushroom_bunch_tan)
(mk-scenery-type 't_dg_mushroom_bunch_pink   "mushrooms" s_dg_mushroom_bunch_pink)
(mk-scenery-type 't_dg_mushroom_bunch_purple "mushrooms" s_dg_mushroom_bunch_purple)
(mk-scenery-type 't_dg_mushroom_bunch_black  "mushrooms" s_dg_mushroom_bunch_black)
(mk-scenery-type 't_dg_mushroom_bunch_glowing_green "glowing mushrooms" s_dg_mushroom_bunch_glowing_green)

(mk-scenery-type 't_coins_copper    "coins"    s_coins_copper)
(mk-scenery-type 't_coins_silver    "coins"    s_coins_silver)
(mk-scenery-type 't_coins_gold      "coins"    s_coins_gold)
(mk-scenery-type 't_coins_blue_1    "coins"    s_coins_blue_1)
(mk-scenery-type 't_coins_blue_2    "coins"    s_coins_blue_2)
(mk-scenery-type 't_crystals_green  "crystals" s_crystals_green)
(mk-scenery-type 't_crystals_blue   "crystals" s_crystals_blue)
(mk-scenery-type 't_crystals_purple "crystals" s_crystals_purple)
(mk-scenery-type 't_gems_red        "gems"     s_gems_red)
(mk-scenery-type 't_gems_blue       "gems"     s_gems_blue)
(mk-scenery-type 't_gems_assorted   "gems"     s_gems_assorted)


;; ss_kg_potions_1 (empty flasks, bubbling potions)
(mk-scenery-type 't_kg_potion_empty_1 "empty flask" s_kg_potion_empty_1)
(mk-scenery-type 't_kg_potion_empty_2 "empty flask" s_kg_potion_empty_2)
(mk-scenery-type 't_kg_potion_empty_3 "empty flask" s_kg_potion_empty_3)
(mk-scenery-type 't_kg_potion_empty_4 "empty flask" s_kg_potion_empty_4)
(mk-scenery-type 't_kg_potion_empty_5 "empty flask" s_kg_potion_empty_5)
(mk-scenery-type 't_kg_potion_empty_6 "empty flask" s_kg_potion_empty_6)

(mk-scenery-type 't_kg_potion_bubbling_pink   "bubbling potion" s_kg_potion_bubbling_pink)
(mk-scenery-type 't_kg_potion_bubbling_red    "bubbling potion" s_kg_potion_bubbling_red)
(mk-scenery-type 't_kg_potion_bubbling_purple "bubbling potion" s_kg_potion_bubbling_purple)
(mk-scenery-type 't_kg_potion_bubbling_yellow "bubbling potion" s_kg_potion_bubbling_yellow)
(mk-scenery-type 't_kg_potion_bubbling_green  "bubbling potion" s_kg_potion_bubbling_green)
(mk-scenery-type 't_kg_potion_bubbling_blue   "bubbling potion" s_kg_potion_bubbling_blue)


;; ss_kg_potions_2 (6 shapes, 7 colors, full/partial/dregs, plus dull colors)
; pink
(mk-scenery-type 't_kg_potion_pink_f33_1  "potion (3/3)" s_kg_potion_pink_f33_1)
(mk-scenery-type 't_kg_potion_pink_f23_1  "potion (2/3)" s_kg_potion_pink_f23_1)
(mk-scenery-type 't_kg_potion_pink_f13_1  "potion (1/3)" s_kg_potion_pink_f13_1)

(mk-scenery-type 't_kg_potion_pink_f33_2  "potion (3/3)" s_kg_potion_pink_f33_2)
(mk-scenery-type 't_kg_potion_pink_f23_2  "potion (2/3)" s_kg_potion_pink_f23_2)
(mk-scenery-type 't_kg_potion_pink_f13_2  "potion (1/3)" s_kg_potion_pink_f13_2)

(mk-scenery-type 't_kg_potion_pink_f33_3  "potion (3/3)" s_kg_potion_pink_f33_3)
(mk-scenery-type 't_kg_potion_pink_f23_3  "potion (2/3)" s_kg_potion_pink_f23_3)
(mk-scenery-type 't_kg_potion_pink_f13_3  "potion (1/3)" s_kg_potion_pink_f13_3)

(mk-scenery-type 't_kg_potion_pink_f33_4  "potion (3/3)" s_kg_potion_pink_f33_4)
(mk-scenery-type 't_kg_potion_pink_f23_4  "potion (2/3)" s_kg_potion_pink_f23_4)
(mk-scenery-type 't_kg_potion_pink_f13_4  "potion (1/3)" s_kg_potion_pink_f13_4)

(mk-scenery-type 't_kg_potion_pink_f33_5  "potion (3/3)" s_kg_potion_pink_f33_5)
(mk-scenery-type 't_kg_potion_pink_f23_5  "potion (2/3)" s_kg_potion_pink_f23_5)
(mk-scenery-type 't_kg_potion_pink_f13_5  "potion (1/3)" s_kg_potion_pink_f13_5)

(mk-scenery-type 't_kg_potion_pink_f33_6  "potion (3/3)" s_kg_potion_pink_f33_6)
(mk-scenery-type 't_kg_potion_pink_f23_6  "potion (2/3)" s_kg_potion_pink_f23_6)
(mk-scenery-type 't_kg_potion_pink_f13_6  "potion (1/3)" s_kg_potion_pink_f13_6)

; red
(mk-scenery-type 't_kg_potion_red_f33_1  "potion (3/3)" s_kg_potion_red_f33_1)
(mk-scenery-type 't_kg_potion_red_f23_1  "potion (2/3)" s_kg_potion_red_f23_1)
(mk-scenery-type 't_kg_potion_red_f13_1  "potion (1/3)" s_kg_potion_red_f13_1)

(mk-scenery-type 't_kg_potion_red_f33_2  "potion (3/3)" s_kg_potion_red_f33_2)
(mk-scenery-type 't_kg_potion_red_f23_2  "potion (2/3)" s_kg_potion_red_f23_2)
(mk-scenery-type 't_kg_potion_red_f13_2  "potion (1/3)" s_kg_potion_red_f13_2)

(mk-scenery-type 't_kg_potion_red_f33_3  "potion (3/3)" s_kg_potion_red_f33_3)
(mk-scenery-type 't_kg_potion_red_f23_3  "potion (2/3)" s_kg_potion_red_f23_3)
(mk-scenery-type 't_kg_potion_red_f13_3  "potion (1/3)" s_kg_potion_red_f13_3)

(mk-scenery-type 't_kg_potion_red_f33_4  "potion (3/3)" s_kg_potion_red_f33_4)
(mk-scenery-type 't_kg_potion_red_f23_4  "potion (2/3)" s_kg_potion_red_f23_4)
(mk-scenery-type 't_kg_potion_red_f13_4  "potion (1/3)" s_kg_potion_red_f13_4)

(mk-scenery-type 't_kg_potion_red_f33_5  "potion (3/3)" s_kg_potion_red_f33_5)
(mk-scenery-type 't_kg_potion_red_f23_5  "potion (2/3)" s_kg_potion_red_f23_5)
(mk-scenery-type 't_kg_potion_red_f13_5  "potion (1/3)" s_kg_potion_red_f13_5)

(mk-scenery-type 't_kg_potion_red_f33_6  "potion (3/3)" s_kg_potion_red_f33_6)
(mk-scenery-type 't_kg_potion_red_f23_6  "potion (2/3)" s_kg_potion_red_f23_6)
(mk-scenery-type 't_kg_potion_red_f13_6  "potion (1/3)" s_kg_potion_red_f13_6)

; green
(mk-scenery-type 't_kg_potion_green_f33_1  "potion (3/3)" s_kg_potion_green_f33_1)
(mk-scenery-type 't_kg_potion_green_f23_1  "potion (2/3)" s_kg_potion_green_f23_1)
(mk-scenery-type 't_kg_potion_green_f13_1  "potion (1/3)" s_kg_potion_green_f13_1)

(mk-scenery-type 't_kg_potion_green_f33_2  "potion (3/3)" s_kg_potion_green_f33_2)
(mk-scenery-type 't_kg_potion_green_f23_2  "potion (2/3)" s_kg_potion_green_f23_2)
(mk-scenery-type 't_kg_potion_green_f13_2  "potion (1/3)" s_kg_potion_green_f13_2)

(mk-scenery-type 't_kg_potion_green_f33_3  "potion (3/3)" s_kg_potion_green_f33_3)
(mk-scenery-type 't_kg_potion_green_f23_3  "potion (2/3)" s_kg_potion_green_f23_3)
(mk-scenery-type 't_kg_potion_green_f13_3  "potion (1/3)" s_kg_potion_green_f13_3)

(mk-scenery-type 't_kg_potion_green_f33_4  "potion (3/3)" s_kg_potion_green_f33_4)
(mk-scenery-type 't_kg_potion_green_f23_4  "potion (2/3)" s_kg_potion_green_f23_4)
(mk-scenery-type 't_kg_potion_green_f13_4  "potion (1/3)" s_kg_potion_green_f13_4)

(mk-scenery-type 't_kg_potion_green_f33_5  "potion (3/3)" s_kg_potion_green_f33_5)
(mk-scenery-type 't_kg_potion_green_f23_5  "potion (2/3)" s_kg_potion_green_f23_5)
(mk-scenery-type 't_kg_potion_green_f13_5  "potion (1/3)" s_kg_potion_green_f13_5)

(mk-scenery-type 't_kg_potion_green_f33_6  "potion (3/3)" s_kg_potion_green_f33_6)
(mk-scenery-type 't_kg_potion_green_f23_6  "potion (2/3)" s_kg_potion_green_f23_6)
(mk-scenery-type 't_kg_potion_green_f13_6  "potion (1/3)" s_kg_potion_green_f13_6)

; deep_blue
(mk-scenery-type 't_kg_potion_deep_blue_f33_1  "potion (3/3)" s_kg_potion_deep_blue_f33_1)
(mk-scenery-type 't_kg_potion_deep_blue_f23_1  "potion (2/3)" s_kg_potion_deep_blue_f23_1)
(mk-scenery-type 't_kg_potion_deep_blue_f13_1  "potion (1/3)" s_kg_potion_deep_blue_f13_1)

(mk-scenery-type 't_kg_potion_deep_blue_f33_2  "potion (3/3)" s_kg_potion_deep_blue_f33_2)
(mk-scenery-type 't_kg_potion_deep_blue_f23_2  "potion (2/3)" s_kg_potion_deep_blue_f23_2)
(mk-scenery-type 't_kg_potion_deep_blue_f13_2  "potion (1/3)" s_kg_potion_deep_blue_f13_2)

(mk-scenery-type 't_kg_potion_deep_blue_f33_3  "potion (3/3)" s_kg_potion_deep_blue_f33_3)
(mk-scenery-type 't_kg_potion_deep_blue_f23_3  "potion (2/3)" s_kg_potion_deep_blue_f23_3)
(mk-scenery-type 't_kg_potion_deep_blue_f13_3  "potion (1/3)" s_kg_potion_deep_blue_f13_3)

(mk-scenery-type 't_kg_potion_deep_blue_f33_4  "potion (3/3)" s_kg_potion_deep_blue_f33_4)
(mk-scenery-type 't_kg_potion_deep_blue_f23_4  "potion (2/3)" s_kg_potion_deep_blue_f23_4)
(mk-scenery-type 't_kg_potion_deep_blue_f13_4  "potion (1/3)" s_kg_potion_deep_blue_f13_4)

(mk-scenery-type 't_kg_potion_deep_blue_f33_5  "potion (3/3)" s_kg_potion_deep_blue_f33_5)
(mk-scenery-type 't_kg_potion_deep_blue_f23_5  "potion (2/3)" s_kg_potion_deep_blue_f23_5)
(mk-scenery-type 't_kg_potion_deep_blue_f13_5  "potion (1/3)" s_kg_potion_deep_blue_f13_5)

(mk-scenery-type 't_kg_potion_deep_blue_f33_6  "potion (3/3)" s_kg_potion_deep_blue_f33_6)
(mk-scenery-type 't_kg_potion_deep_blue_f23_6  "potion (2/3)" s_kg_potion_deep_blue_f23_6)
(mk-scenery-type 't_kg_potion_deep_blue_f13_6  "potion (1/3)" s_kg_potion_deep_blue_f13_6)

; light_blue
(mk-scenery-type 't_kg_potion_light_blue_f33_1  "potion (3/3)" s_kg_potion_light_blue_f33_1)
(mk-scenery-type 't_kg_potion_light_blue_f23_1  "potion (2/3)" s_kg_potion_light_blue_f23_1)
(mk-scenery-type 't_kg_potion_light_blue_f13_1  "potion (1/3)" s_kg_potion_light_blue_f13_1)

(mk-scenery-type 't_kg_potion_light_blue_f33_2  "potion (3/3)" s_kg_potion_light_blue_f33_2)
(mk-scenery-type 't_kg_potion_light_blue_f23_2  "potion (2/3)" s_kg_potion_light_blue_f23_2)
(mk-scenery-type 't_kg_potion_light_blue_f13_2  "potion (1/3)" s_kg_potion_light_blue_f13_2)

(mk-scenery-type 't_kg_potion_light_blue_f33_3  "potion (3/3)" s_kg_potion_light_blue_f33_3)
(mk-scenery-type 't_kg_potion_light_blue_f23_3  "potion (2/3)" s_kg_potion_light_blue_f23_3)
(mk-scenery-type 't_kg_potion_light_blue_f13_3  "potion (1/3)" s_kg_potion_light_blue_f13_3)

(mk-scenery-type 't_kg_potion_light_blue_f33_4  "potion (3/3)" s_kg_potion_light_blue_f33_4)
(mk-scenery-type 't_kg_potion_light_blue_f23_4  "potion (2/3)" s_kg_potion_light_blue_f23_4)
(mk-scenery-type 't_kg_potion_light_blue_f13_4  "potion (1/3)" s_kg_potion_light_blue_f13_4)

(mk-scenery-type 't_kg_potion_light_blue_f33_5  "potion (3/3)" s_kg_potion_light_blue_f33_5)
(mk-scenery-type 't_kg_potion_light_blue_f23_5  "potion (2/3)" s_kg_potion_light_blue_f23_5)
(mk-scenery-type 't_kg_potion_light_blue_f13_5  "potion (1/3)" s_kg_potion_light_blue_f13_5)

(mk-scenery-type 't_kg_potion_light_blue_f33_6  "potion (3/3)" s_kg_potion_light_blue_f33_6)
(mk-scenery-type 't_kg_potion_light_blue_f23_6  "potion (2/3)" s_kg_potion_light_blue_f23_6)
(mk-scenery-type 't_kg_potion_light_blue_f13_6  "potion (1/3)" s_kg_potion_light_blue_f13_6)

; yellow
(mk-scenery-type 't_kg_potion_yellow_f33_1  "potion (3/3)" s_kg_potion_yellow_f33_1)
(mk-scenery-type 't_kg_potion_yellow_f23_1  "potion (2/3)" s_kg_potion_yellow_f23_1)
(mk-scenery-type 't_kg_potion_yellow_f13_1  "potion (1/3)" s_kg_potion_yellow_f13_1)

(mk-scenery-type 't_kg_potion_yellow_f33_2  "potion (3/3)" s_kg_potion_yellow_f33_2)
(mk-scenery-type 't_kg_potion_yellow_f23_2  "potion (2/3)" s_kg_potion_yellow_f23_2)
(mk-scenery-type 't_kg_potion_yellow_f13_2  "potion (1/3)" s_kg_potion_yellow_f13_2)

(mk-scenery-type 't_kg_potion_yellow_f33_3  "potion (3/3)" s_kg_potion_yellow_f33_3)
(mk-scenery-type 't_kg_potion_yellow_f23_3  "potion (2/3)" s_kg_potion_yellow_f23_3)
(mk-scenery-type 't_kg_potion_yellow_f13_3  "potion (1/3)" s_kg_potion_yellow_f13_3)

(mk-scenery-type 't_kg_potion_yellow_f33_4  "potion (3/3)" s_kg_potion_yellow_f33_4)
(mk-scenery-type 't_kg_potion_yellow_f23_4  "potion (2/3)" s_kg_potion_yellow_f23_4)
(mk-scenery-type 't_kg_potion_yellow_f13_4  "potion (1/3)" s_kg_potion_yellow_f13_4)

(mk-scenery-type 't_kg_potion_yellow_f33_5  "potion (3/3)" s_kg_potion_yellow_f33_5)
(mk-scenery-type 't_kg_potion_yellow_f23_5  "potion (2/3)" s_kg_potion_yellow_f23_5)
(mk-scenery-type 't_kg_potion_yellow_f13_5  "potion (1/3)" s_kg_potion_yellow_f13_5)

(mk-scenery-type 't_kg_potion_yellow_f33_6  "potion (3/3)" s_kg_potion_yellow_f33_6)
(mk-scenery-type 't_kg_potion_yellow_f23_6  "potion (2/3)" s_kg_potion_yellow_f23_6)
(mk-scenery-type 't_kg_potion_yellow_f13_6  "potion (1/3)" s_kg_potion_yellow_f13_6)

; blue
(mk-scenery-type 't_kg_potion_blue_f33_1  "potion (3/3)" s_kg_potion_blue_f33_1)
(mk-scenery-type 't_kg_potion_blue_f23_1  "potion (2/3)" s_kg_potion_blue_f23_1)
(mk-scenery-type 't_kg_potion_blue_f13_1  "potion (1/3)" s_kg_potion_blue_f13_1)

(mk-scenery-type 't_kg_potion_blue_f33_2  "potion (3/3)" s_kg_potion_blue_f33_2)
(mk-scenery-type 't_kg_potion_blue_f23_2  "potion (2/3)" s_kg_potion_blue_f23_2)
(mk-scenery-type 't_kg_potion_blue_f13_2  "potion (1/3)" s_kg_potion_blue_f13_2)

(mk-scenery-type 't_kg_potion_blue_f33_3  "potion (3/3)" s_kg_potion_blue_f33_3)
(mk-scenery-type 't_kg_potion_blue_f23_3  "potion (2/3)" s_kg_potion_blue_f23_3)
(mk-scenery-type 't_kg_potion_blue_f13_3  "potion (1/3)" s_kg_potion_blue_f13_3)

(mk-scenery-type 't_kg_potion_blue_f33_4  "potion (3/3)" s_kg_potion_blue_f33_4)
(mk-scenery-type 't_kg_potion_blue_f23_4  "potion (2/3)" s_kg_potion_blue_f23_4)
(mk-scenery-type 't_kg_potion_blue_f13_4  "potion (1/3)" s_kg_potion_blue_f13_4)

(mk-scenery-type 't_kg_potion_blue_f33_5  "potion (3/3)" s_kg_potion_blue_f33_5)
(mk-scenery-type 't_kg_potion_blue_f23_5  "potion (2/3)" s_kg_potion_blue_f23_5)
(mk-scenery-type 't_kg_potion_blue_f13_5  "potion (1/3)" s_kg_potion_blue_f13_5)

(mk-scenery-type 't_kg_potion_blue_f33_6  "potion (3/3)" s_kg_potion_blue_f33_6)
(mk-scenery-type 't_kg_potion_blue_f23_6  "potion (2/3)" s_kg_potion_blue_f23_6)
(mk-scenery-type 't_kg_potion_blue_f13_6  "potion (1/3)" s_kg_potion_blue_f13_6)

; dull purple
(mk-scenery-type 't_kg_potion_dull_purple_1 "potion" s_kg_potion_dull_purple_1)
(mk-scenery-type 't_kg_potion_dull_purple_2 "potion" s_kg_potion_dull_purple_2)
(mk-scenery-type 't_kg_potion_dull_purple_3 "potion" s_kg_potion_dull_purple_3)
(mk-scenery-type 't_kg_potion_dull_purple_4 "potion" s_kg_potion_dull_purple_4)
(mk-scenery-type 't_kg_potion_dull_purple_5 "potion" s_kg_potion_dull_purple_5)
(mk-scenery-type 't_kg_potion_dull_purple_6 "potion" s_kg_potion_dull_purple_6)
; brown
(mk-scenery-type 't_kg_potion_brown_1 "potion" s_kg_potion_brown_1)
(mk-scenery-type 't_kg_potion_brown_2 "potion" s_kg_potion_brown_2)
(mk-scenery-type 't_kg_potion_brown_3 "potion" s_kg_potion_brown_3)
(mk-scenery-type 't_kg_potion_brown_4 "potion" s_kg_potion_brown_4)
(mk-scenery-type 't_kg_potion_brown_5 "potion" s_kg_potion_brown_5)
(mk-scenery-type 't_kg_potion_brown_6 "potion" s_kg_potion_brown_6)
; dull green
(mk-scenery-type 't_kg_potion_dull_green_1 "potion" s_kg_potion_dull_green_1)
(mk-scenery-type 't_kg_potion_dull_green_2 "potion" s_kg_potion_dull_green_2)
(mk-scenery-type 't_kg_potion_dull_green_3 "potion" s_kg_potion_dull_green_3)
(mk-scenery-type 't_kg_potion_dull_green_4 "potion" s_kg_potion_dull_green_4)
(mk-scenery-type 't_kg_potion_dull_green_5 "potion" s_kg_potion_dull_green_5)
(mk-scenery-type 't_kg_potion_dull_green_6 "potion" s_kg_potion_dull_green_6)
; dull dark blue
(mk-scenery-type 't_kg_potion_dull_dark_blue_1 "potion" s_kg_potion_dull_dark_blue_1)
(mk-scenery-type 't_kg_potion_dull_dark_blue_2 "potion" s_kg_potion_dull_dark_blue_2)
(mk-scenery-type 't_kg_potion_dull_dark_blue_3 "potion" s_kg_potion_dull_dark_blue_3)
(mk-scenery-type 't_kg_potion_dull_dark_blue_4 "potion" s_kg_potion_dull_dark_blue_4)
(mk-scenery-type 't_kg_potion_dull_dark_blue_5 "potion" s_kg_potion_dull_dark_blue_5)
(mk-scenery-type 't_kg_potion_dull_dark_blue_6 "potion" s_kg_potion_dull_dark_blue_6)
; dull light blue
(mk-scenery-type 't_kg_potion_dull_light_blue_1 "potion" s_kg_potion_dull_light_blue_1)
(mk-scenery-type 't_kg_potion_dull_light_blue_2 "potion" s_kg_potion_dull_light_blue_2)
(mk-scenery-type 't_kg_potion_dull_light_blue_3 "potion" s_kg_potion_dull_light_blue_3)
(mk-scenery-type 't_kg_potion_dull_light_blue_4 "potion" s_kg_potion_dull_light_blue_4)
(mk-scenery-type 't_kg_potion_dull_light_blue_5 "potion" s_kg_potion_dull_light_blue_5)
(mk-scenery-type 't_kg_potion_dull_light_blue_6 "potion" s_kg_potion_dull_light_blue_6)
; dull yellow
(mk-scenery-type 't_kg_potion_dull_yellow_1 "potion" s_kg_potion_dull_yellow_1)
(mk-scenery-type 't_kg_potion_dull_yellow_2 "potion" s_kg_potion_dull_yellow_2)
(mk-scenery-type 't_kg_potion_dull_yellow_3 "potion" s_kg_potion_dull_yellow_3)
(mk-scenery-type 't_kg_potion_dull_yellow_4 "potion" s_kg_potion_dull_yellow_4)
(mk-scenery-type 't_kg_potion_dull_yellow_5 "potion" s_kg_potion_dull_yellow_5)
(mk-scenery-type 't_kg_potion_dull_yellow_6 "potion" s_kg_potion_dull_yellow_6)
; dull blue
(mk-scenery-type 't_kg_potion_dull_blue_1 "potion" s_kg_potion_dull_blue_1)
(mk-scenery-type 't_kg_potion_dull_blue_2 "potion" s_kg_potion_dull_blue_2)
(mk-scenery-type 't_kg_potion_dull_blue_3 "potion" s_kg_potion_dull_blue_3)
(mk-scenery-type 't_kg_potion_dull_blue_4 "potion" s_kg_potion_dull_blue_4)
(mk-scenery-type 't_kg_potion_dull_blue_5 "potion" s_kg_potion_dull_blue_5)
(mk-scenery-type 't_kg_potion_dull_blue_6 "potion" s_kg_potion_dull_blue_6)






;; eof
