
;;;;;;;;;;;;;;;;;;;;;;;;;;
; Deeps template maps

(kern-mk-map 'm_deeptempl_wall 19 19 pal_expanded
	(list
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn r8 r8 rn r8 rn rn r8 r8 rn rn rn rn rn rn "
		"rn rn rn rn r4 .. .. re .. ra rc {4 {{ r2 rn rn rn rn rn "
		"rn rn rn r8 rc .. .. .. .. bb .. .. .. .. ra r8 rn rn rn "
		"rn rn r8 {{ {2 .. .. {8 .. .. .. .. {8 .. {4 {{ r8 rn rn "
		"rn r4 .. {1 {8 .. rf {{ {2 {8 .. {4 {{ rf .. {1 .. r2 rn "
		"rn rn rd {4 {{ {6 {{ rb r5 {{ {a .. {1 .. .. .. .. ra rn "
		"rn rc .. .. {1 .. {5 {{ r2 r5 {{ rf .. .. {8 .. {4 {{ r2 "
		"r4 .. bb .. .. .. .. {1 ra rn rd {8 .. bb {{ {2 .. r3 rn "
		"r4 .. .. .. .. rf .. {8 .. r6 {{ {{ {2 .. {1 .. rb rn rn "
		"rn rd .. .. {4 {{ rf {{ r3 r8 r9 rd .. .. .. .. bb ra rn "
		"r4 .. .. .. .. {1 .. {9 r6 {{ {6 {{ rf .. .. .. .. .. r2 "
		"rn r5 {8 .. bb .. {4 {{ re {1 .. {1 .. .. .. .. .. .. r2 "
		"rn r4 {{ .. .. .. .. rf .. {8 .. .. .. .. bb {8 .. r3 rn "
		"rn rn r1 .. rf .. .. .. {4 {{ bb .. .. .. {4 {{ r1 rn rn "
		"rn rn rn r5 {{ {2 .. .. .. {1 .. .. .. .. .. r3 rn rn rn "
		"rn rn rn rn r4 {{ {2 .. {c {{ {{ {2 bb r2 rn rn rn rn rn "
		"rn rn rn rn rn r5 .. r7 {{ r3 r5 .. r3 rn rn rn rn rn rn "
		"rn rn rn rn rn rn r1 rn r1 rn rn r1 rn rn rn rn rn rn rn "
	)
)
 
(kern-mk-map 'm_deeptempl_passage 19 19 pal_expanded
	(list
		"rn rn rn rn rn r4 .. .. .. .. {4 {{ {2 .. r2 rn rn rn rn "
		"rn rn rn rn rn rc .. .. .. .. .. {1 .. rb rn rn rn rn rn "
		"rn rn rn rn r4 .. .. .. .. .. .. .. .. .. r2 rn rn rn rn "
		"rn rn rn {{ {2 .. .. .. .. .. .. .. .. .. {4 {{ rn rn rn "
		"r8 rn r8 {1 .. .. {8 .. .. .. .. .. .. .. .. rb r8 r8 rn "
		".. re .. .. .. {4 {{ {2 .. .. .. .. .. .. {8 .. .. {8 ra "
		".. {8 .. .. .. .. {1 .. .. {8 .. .. .. {4 {{ {2 {4 {{ {2 "
		"{4 {{ {2 .. .. .. .. .. {4 {{ {2 .. .. .. {1 .. .. {1 .. "
		".. {1 .. .. .. .. .. bb .. {1 .. .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. .. .. .. {8 .. .. .. .. .. .. .. "
		".. .. bb .. .. .. .. .. .. .. {4 {{ {2 .. .. .. .. .. .. "
		".. .. .. .. .. .. .. {8 .. .. .. {1 .. .. .. .. .. .. .. "
		"r5 .. .. .. .. .. {4 {{ {2 .. .. .. .. .. .. .. .. r7 .. "
		"rn r1 r1 .. {8 .. .. {1 .. .. .. .. .. .. .. .. r1 rn r1 "
		"rn rn rn r5 {{ {2 .. .. .. .. .. .. .. .. .. bb rn rn rn "
		"rn rn rn rn r4 .. .. .. .. {8 .. .. .. r2 rn rn rn rn rn "
		"rn rn rn rn rn rd .. .. {4 {{ {a .. .. ra rn rn rn rn rn "
		"rn rn rn rn r4 .. .. .. .. {5 {{ {2 .. .. r2 rn rn rn rn "
	)
)
	
 
(kern-mk-map 'm_deeptempl_water 19 19 pal_expanded
	(list
		"rn rn rn rn rn rc ~~ ~~ ~~ ~~ ~~ ~~ ~~ ~~ r2 rn rn rn rn "
		"rn rn rn rn r4 ~b ~8 ~8 ~~ ~~ ~~ ~8 ~~ ~4 r2 rn rn rn rn "
		"rn rn rn rn r4 .. .. .. ~% ~6 %c .. ~% ~e r2 rn rn rn rn "
		"rn rn rn rn rc .. .. .. .. .. .. .. .. .. ra r8 rn rn rn "
		"r8 r8 r8 rc .. .. .. .. .. .. .. .. .. .. .. .. r8 r8 r8 "
		"~~ ~5 .. .. .. .. ~C ~7 ~A .. .. bb .. .. .. .. .. ~b ~~ "
		"~~ ~c .. .. .. .. ~3 -- ~d .. .. .. .. .. .. .. .. bb ~~ "
		"~~ %c bb .. .. .. ~a ~~ {G {2 .. .. .. .. .. .. .. ~3 ~~ "
		"~4 .. .. .. .. .. %a ~e {1 .. .. .. .. .. .. .. .. ~2 ~~ "
		"~~ ~A .. .. .. .. .. .. .. .. .. ~7 .. .. .. .. .. ~a ~~ "
		"~~ ~d .. .. .. .. .. .. .. .. %3 ~~ ~5 ~A .. .. .. ~D ~~ "
		"~~ %c .. .. .. ~C ~7 ~A .. .. ~3 -- -- ~d .. .. .. ~3 ~~ "
		"~4 .. .. .. .. ~3 -- ~d .. ~b ~~ -- ~c ~# .. .. .. ~2 ~~ "
		"~c .. .. .. .. ~a ~c ~# .. .. %a ~e ~# .. .. .. .. ~e r3 "
		"r1 r1 r1 .. .. .. .. .. .. .. .. .. .. .. bb .. r1 r1 rn "
		"rn rn rn r1 r5 .. .. .. .. .. .. .. .. .. r3 r1 rn rn rn "
		"rn rn rn rn r4 .. ~C ~7 ~A .. .. ~C ~3 ~d r2 rn rn rn rn "
		"rn rn rn rn rn rd ~3 ~~ ~~ ~5 ~E ~3 ~~ rb rn rn rn rn rn "
		"rn rn rn rn r4 ~3 ~~ ~~ ~~ ~~ ~~ ~~ ~~ ~5 r2 rn rn rn rn "
	)
)
	
	
(kern-mk-map 'm_deeptempl_hole 19 19 pal_expanded
	(list
		"rn rn rn rn rn rc vv vv vv vv vv vv vv *c r2 rn rn rn rn "
		"rn rn rn rn r4 *b vv vv *8 *c .i *e .g rb rn rn rn rn rn "
		"rn rn rn rn r4 .h *e .g .. .. .. .. .. .. r2 rn rn rn rn "
		"rn rn rn .. .. .. {8 .. .. .. .. .. .. .. .. .. rn rn rn "
		"r8 rn r8 .. .. *7 {j .. .. .. .. .. {8 .. .. .. rn r8 r8 "
		"*5 re .. .. .. *a vv *5 .j .. .. {4 {{ {a .. .. re .. *3 "
		"vv *5 .. .. .. .. .h vv *5 .j .. .. bb {{ {2 .. .. .l vv "
		"vv *4 .. .. .. .. .. *a vv *5 .j .. .. {1 .. .. *b vv vv "
		"vv *c .. .. .. .. {4 {h vv vv *5 .j .. .. .. .. .h *a vv "
		"vv .g .. .. .. {8 .. .. *2 vv vv *d .. .. .. .. .. .m vv "
		"vv .j .. .. {c {{ {2 .. *a vv vv .g .. .. {8 .. .. *b vv "
		"vv *d .. {4 {{ rf .. .. rf *a vv {j {2 {4 {{ {2 .. .m vv "
		"vv .k .. .. {1 .. .. .. .. .h *a *5 .j .. {1 .. .. *3 vv "
		"vv *d .. .. .. .. .. .. .. .. .h *a *5 .. .. .. .. *e r3 "
		"r1 r1 r1 .. .. .. .. .. .. .. {4 {h *e .. .. .. r1 r1 rn "
		"rn rn rn .. .. .. .. .. .. .. .. {1 .. .. .. .. rn rn rn "
		"rn rn rn rn r4 .. .. .. .. .. *7 .j .. .. r2 rn rn rn rn "
		"rn rn rn rn r4 *7 .n *3 *5 .n vv *5 .n *7 r2 rn rn rn rn "
		"rn rn rn rn r4 vv vv vv vv vv vv vv vv vv r2 rn rn rn rn "
	)
)

(kern-mk-map 'm_deeptempl_lava 19 19 pal_expanded
	(list
		"rn rn rn rn rn r4 !_ !_ !_ !_ !_ !_ !_ ra rn rn rn rn rn "
		"rn rn rn rn rn rc !! !! !! !! !! !! !_ !! r2 rn rn rn rn "
		"rn rn rn rn r4 !! !c .. .. .. bb !a !c .. r2 rn rn rn rn "
		"rn rn rn bb re .. .. .. .. .. .. .. .. .. {4 {{ rn rn rn "
		"rn r8 r8 .. .. .. .. .. .. .. .. .. .. .. .. {1 r8 rn rn "
		"rc !! !! .. .. .. rf .. .. .. .. !3 !! !5 .. .. !! ra r8 "
		"!_ !_ !c .. .. .. .. {8 .. .. .. !! !_ !c .. .. !! !_ !_ "
		"!_ !! {# .. .. .. {4 {{ {2 .. .. !a !c .. {8 .. !a !! !_ "
		"!_ !! {1 .. bb .. .. {1 .. .. .. .. .. {4 {{ {2 .. !! !_ "
		"!_ !! .. .. .. .. .. !7 .. .. .. .. .. .. {1 .. .. !! !_ "
		"!_ !! .. .. .. .. !3 !! !5 .. .. .. .. .. .. .. .. !! !_ "
		"!_ !! .. .. .. !3 !_ !! !c .. .. .. bb .. .. .. .. !! !_ "
		"!_ !! !5 .. .. !a !c .. .. .. .. !3 !5 .. .. .. {8 !! !_ "
		"!_ r7 !! .. .. .. .. .. .. .. .. !a !c .. .. .. {{ r7 !_ "
		"r1 rn r1 .. {8 .. .. .. .. .. .. .. .. .. .. rb r1 rn r1 "
		"rn rn rn r5 {{ {2 .. .. .. .. .. .. .. .. .. bb rn rn rn "
		"rn rn rn rn r4 .. .. !7 bb .. .. !3 !! !! r2 rn rn rn rn "
		"rn rn rn rn r4 !! !! !! !! !! !! !! !_ rb rn rn rn rn rn "
		"rn rn rn rn rn r5 !_ !_ !_ !_ !_ !_ !_ !_ r2 rn rn rn rn "
	)
)
	
(kern-mk-map 'm_deeptempl_swamp 19 19 pal_expanded
	(list
		"rn rn rn rn r4 %a %% %% %% %% %% %% ~f %% r2 rn rn rn rn "
		"rn rn rn rn r4 {% %a %c {4 {% %% %% %% %c r2 rn rn rn rn "
		"rn rn rn rn rn r5 .. .. .. {1 %% %% {# {2 r2 rn rn rn rn "
		"rn rn rn .. re %% .. .. bb .. %% %% %% %% %c r2 rn rn rn "
		"rn r8 r8 .. %b %% %5 .. %3 %% %% %c {8 .. .. ra r8 r8 rn "
		"rc {{ {2 .. .. %a %% %% %% %c .. {4 {{ {2 .. .. {{ %7 ra "
		"%% %5 .. .. bb .. .. %% %% .. .. .. {1 .. .. .. {1 %% %% "
		"%% ~f %% .. .. .. %3 %% %% %5 .. {8 .. %7 .. .. %% %% ~f "
		"%% %% %% %% %5 .. %% ~b ~d %% %d {{ %3 %% %% %% %% %% %% "
		"%% %% .. .. %a %% %% %% %% %c rb rd %% %% %c .. .. .. %% "
		"%% %% bb .. .. %a %% %% %% .. %3 ~e %% .. .. .. .. {8 %% "
		"%% %c .. .. .. .. %% .. %a %% %% %% %c .. {8 .. {4 {C %% "
		"%% .. .. .. .. %3 %% .. .. %a %% %% .. {4 {{ {2 .. %b %% "
		"%c r7 .. .. .. %% ~f %5 .. .. .. %% .. .. {1 .. .. r7 %a "
		"r1 rn r1 .. .. %% %% %c .. .. .. %% %5 .. .. r3 r1 rn r1 "
		"rn rn rn .. r7 %% %% .. .. bb .. %% %% %% %5 r2 rn rn rn "
		"rn rn rn rn r4 .. {8 .. .. .. %% %% %% {{ r2 rn rn rn rn "
		"rn rn rn rn rn rd {C %3 %% %% %% %% %% rb rn rn rn rn rn "
		"rn rn rn rn r4 %3 %% %% %% %% %% ~f %% %5 r2 rn rn rn rn "
	)
)
	
(kern-mk-map 'm_deeptempl_break 19 19 pal_expanded
	(list
		"rn rn rn rn rn rn rn r4 bb .. .. r2 rn rn rn rn rn rn rn "
		"rn rn rn rn rn r8 r8 r4 .. .. bb ra r8 rn rn rn rn rn rn "
		"rn rn rn rn r4 .. .. re .. .. rf {4 {{ r2 rn rn rn rn rn "
		"rn rn rn r8 rc .. .. .. .. bb .. .. .. .. ra r8 rn rn rn "
		"rn rn r8 {{ {2 .. .. {8 .. .. .. .. {8 .. {4 {{ r8 rn rn "
		"rn r4 .. {1 {8 .. rf {{ {2 {8 .. {4 {{ rf .. {1 .. r2 rn "
		"rn rn rd {4 {{ {6 {{ rb r5 {{ {a .. {1 .. .. .. .. ra rn "
		"r8 rc .. .. {1 .. {5 {{ r2 r5 {{ rf .. .. {8 .. {4 {{ ra "
		"bb .. bb .. .. .. .. {1 ra rn rd {8 .. bb {{ {2 .. {1 bb "
		".. .. .. .. .. rf .. {8 .. r6 {{ {{ {2 .. {1 .. rf .. .. "
		".. bb .. .. {4 {{ rf {{ r3 r8 r9 rd .. .. .. .. bb .. .. "
		"r5 .. .. .. .. {1 .. {9 r6 {{ {6 {{ rf .. .. .. .. .. r3 "
		"rn r5 {8 .. bb .. {4 {{ re {1 .. {1 .. .. .. .. .. .. r2 "
		"rn r4 {{ .. .. .. .. rf .. {8 .. .. .. .. bb {8 .. r3 rn "
		"rn rn r1 .. rf .. .. .. {4 {{ bb .. .. .. {4 {{ r1 rn rn "
		"rn rn rn r5 {{ {2 .. .. .. {1 .. .. .. .. .. r3 rn rn rn "
		"rn rn rn rn r4 {{ {2 .. .. .. .. .. bb r2 rn rn rn rn rn "
		"rn rn rn rn rn r5 .. r7 .. .. bb .. r3 rn rn rn rn rn rn "
		"rn rn rn rn rn rn r1 r4 bb .. .. r3 rn rn rn rn rn rn rn "
	)
)
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Deeps random map


;probability for edge terrains... out of 83
(define deep-terrain-edges
	(list
		(list 20 'm_deeptempl_wall #f)
		(list 25 'm_deeptempl_water #f)
		(list 30 'm_deeptempl_hole #f)
		(list 35 'm_deeptempl_lava #f)
		(list 40 'm_deeptempl_swamp #t)		
		(list 100 'm_deeptempl_passage #t)
	))

;probability for area terrains... out of 149
(define deep-terrain-area
	(list
		(list 30 'm_deeptempl_wall)
		(list 45 'm_deeptempl_water)
		(list 65 'm_deeptempl_hole)		
		(list 75 'm_deeptempl_lava)		
		(list 80 'm_deeptempl_swamp)		
		(list 150 'm_deeptempl_passage)
	))

;map areas replaced by the various blitting ops
(define deep-room-blitstats
	(prmap-mk-blitstats 19 19 3 4 3))


;parameters to random number generators
(define (deep-rno) (+ (kern-dice-roll "1d70" 33)))
(define deep-random-type-ew (prmap-mk-prng-params (deep-rno) (deep-rno) 0 (deep-rno) 83))
(define deep-random-type-ns (prmap-mk-prng-params (deep-rno) (deep-rno) 0 (deep-rno) 83))
(define deep-random-type-area (prmap-mk-prng-params (deep-rno) (deep-rno) 0 (deep-rno) 149))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; critter lists

(define deep-monster-types
	(list 
		(list 
			(list 100 'bat)
		)
		(list
			(list 100 'rat)
			(list 200 'bat)
		)
		(list
			(list 100 'giant-spider)
			(list 150 'queen-spider)
		)
		(list
			(list 100 'cave-goblin-slinger)
			(list 200 'cave-goblin-berserker)
			(list 250 'cave-goblin-priest)
		)
		(list
			(list 50 'cave-goblin-slinger-m)
			(list 100 'cave-goblin-berserker-m)
			(list 300 'trog-m)
			(list 350 'trog-geomancer-m)
		)
		(list
			(list 100 'green-slime)
			(list 200 'yellow-slime)
		)	
		(list
			(list 100 'zorn)
		)
		(list
			(list 20 'ghast)
			(list 200 'demon)
		)
		(list
			(list 50 'cave-goblin-slinger-m)
			(list 100 'cave-goblin-berserker-m)
			(list 150 'trog-m)
			(list 350 'gint-warrior-m)
			(list 400 'gint-mage-m)
		)
		(list
			(list 50 'cave-goblin-slinger-m)
			(list 100 'headless)
			(list 150 'cave-goblin-berserker-m)
			(list 200 'trog-m)
			(list 250 'gint-warrior-m)
			(list 350 'gazer)
		)
		(list
			(list 25 'cave-goblin-slinger-m)
			(list 50 'cave-goblin-berserker-m)
			(list 300 'dragon)
		)
		(list
			(list 20 'ghast)
			(list 70 'skeletal-warrior)
			(list 120 'skeletal-spear-thrower)
			(list 150 'craven-archer)
			(list 300 'death-knight)
			(list 350 'demon)
		)
		(list
			(list 100 'skeletal-warrior)
			(list 200 'skeletal-spear-thrower)
			(list 250 'lich)
		)
		(list 
			(list 100 'headless)
			(list 150 'skeletal-warrior)
			(list 200 'skeletal-spear-thrower)
			(list 220 'craven-archer)
			(list 250 'death-knight)
			(list 260 'demon)
			(list 330 'warlock)
		)
	)
)

(define deep-group-types
	(list
		(list 10 0 100 "1d4+3") ;bats
		(list 20 1 100 "1d4+3") ;rats
		(list 30 1 200 "1d6+4") ;bats n rats
		(list 40 5 100 "1d3+2") ;slime
		(list 50 2 100 "1d4+3") ;spiders
		(list 60 3 100 "1d3+1") ;goblins
		(list 70 2 110 "1d4+3") ;spiders 1q
		(list 80 13 100 "1d6+4") ;headless
		(list 90 2 150 "1d6+4") ;spiders +qs
		(list 100 5 200 "1d6+3") ;slime+
		(list 110 3 200 "1d6+4") ;goblin war
		(list 120 7 20 "1d6+1")  ;ghost
		(list 130 11 120 "1d6+4") ;skels
		(list 140 4 300 "1d6+3") ;trogs
		(list 150 6 100 "1d2")   ;zorn
		(list 160 8 350 "1d6+3") ;gint
		(list 170 7 22 "1d6+1")  ;ghost + d
		(list 180 11 300 "2d4+4") ;deathknights
		(list 190 11 310 "2d4+4") ;deathknights +d
		(list 200 3 210 "1d6+5") ;goblin war +p
		(list 210 7 200 "1d3")   ;demons
		(list 220 3 250 "2d4+4") ;goblin tribe
		(list 230 4 350 "1d6+5") ;trogs +m
		(list 240 8 400 "2d4+4") ;gint + m
		(list 250 10 300 "1d4")  ;dragon
		(list 260 10 80 "1d6+3") ;dragon + gob	
		(list 270 9 260 "1d6+3") ;gazer
		(list 280 13 330 "2d4+4") ;warlock		
		(list 290 12 205 "2d4+4") ;lich	
		(list 300 9 320 "2d4+4") ;gazers
	)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; handles

(define (deeps-link-factory x y z map dir)
		(list 'm_deeptempl_break nil)
		)

(define (deeps-init-cohesion mapdata)
	(if (list-ref mapdata 10)
		(begin
			;;(kern-log-msg "begin cohesion check")
			(prmap-ensure-cohesion mapdata -5 6 -6 5 0 deeps-link-factory)
			;;(kern-log-msg "end cohesion check")
			(mutable-list-set mapdata 10 #f)
		)))
		
(define (deeps-room-handle-deeps kplace kplayer)
	(let* (
		(roomdata (get-roomdata kplace))
		(mapdata (prmap-get-mapdata (eval 'p_deeps_1)))
		)
		(prmap-room-freeze-current mapdata)
		(prmap-room-init-neighbors kplace roomdata)
		(prmap-room-init-links kplace roomdata mapdata)
		(prmap-room-cleanout kplace)
		(prmap-room-thaw kplace mapdata)		
		(prmap-room-blit-map kplace roomdata mapdata)
		(prmap-room-init-contents kplace roomdata)
	))

(define (deeps-room-handle-garrison kplace kplayer)
	(let* (
		(roomdata (get-roomdata kplace))
		(mapdata (prmap-get-mapdata (eval 'p_deeps_1)))
		)
		(deeps-init-cohesion mapdata)
		(prmap-room-freeze-current mapdata)
		(prmap-room-init-neighbors kplace roomdata)
		(prmap-room-init-links kplace roomdata mapdata)
	))	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Plot type stuff

(mk-reusable-item 
 't_garrison_log "Garrison Log" s_lexicon v-hard
 (lambda (klexicon kuser)
   (kern-ui-page-text
   "Garrison Log"
   ""
   (string-append
	"The log details events at the garrison "
	"while it was still in operation. Early "
	"entries detail several attempts to "
	"clear the surrounding caverns.")
   ""
   (string-append
   "However, the paladins were "
   "unable to even determine how "
   "large the dungeon is, and "
   "eventually settled on a policy "
   "of containment by fortifying "
   "this bottleneck position.")
   )))

