; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt %s -instsimplify -S | FileCheck %s

; Here we add unsigned two values, check that addition did not underflow AND
; that the result is non-zero. This can be simplified just to a comparison
; between the base and negated offset.

; If we are checking that the result is not null or no underflow happened,
; it is tautological (always-true).
define i1 @t1(i8 %x, i8 %y) {
; CHECK-LABEL: @t1(
; CHECK-NEXT:    ret i1 true
;
  %not_null = icmp ne i8 %y, 0
  %no_underflow = icmp ule i8 %y, %x
  %r = or i1 %not_null, %no_underflow
  ret i1 %r
}
define i1 @t2_commutative(i8 %x, i8 %y) {
; CHECK-LABEL: @t2_commutative(
; CHECK-NEXT:    ret i1 true
;
  %not_null = icmp ne i8 %y, 0
  %no_underflow = icmp uge i8 %x, %y ; swapped
  %r = or i1 %not_null, %no_underflow
  ret i1 %r
}

define i1 @t3_commutative(i8 %x, i8 %y) {
; CHECK-LABEL: @t3_commutative(
; CHECK-NEXT:    ret i1 true
;
  %not_null = icmp ne i8 %y, 0
  %no_underflow = icmp ule i8 %y, %x
  %r = or i1 %no_underflow, %not_null ; swapped
  ret i1 %r
}
define i1 @t4_commutative(i8 %x, i8 %y) {
; CHECK-LABEL: @t4_commutative(
; CHECK-NEXT:    ret i1 true
;
  %not_null = icmp ne i8 %y, 0
  %no_underflow = icmp uge i8 %x, %y ; swapped
  %r = or i1 %no_underflow, %not_null ; swapped
  ret i1 %r
}

; If we are checking that the result is null and underflow happened,
; it is tautological (always-false).
define i1 @t5(i8 %x, i8 %y) {
; CHECK-LABEL: @t5(
; CHECK-NEXT:    ret i1 false
;
  %not_null = icmp eq i8 %y, 0
  %no_underflow = icmp ugt i8 %y, %x
  %r = and i1 %not_null, %no_underflow
  ret i1 %r
}
define i1 @t6_commutative(i8 %x, i8 %y) {
; CHECK-LABEL: @t6_commutative(
; CHECK-NEXT:    ret i1 false
;
  %not_null = icmp eq i8 %y, 0
  %no_underflow = icmp ult i8 %x, %y ; swapped
  %r = and i1 %not_null, %no_underflow
  ret i1 %r
}

; We only need to know that any of the 'add' operands is non-zero,
; not necessarily the one used in the comparison.
define i1 @t7(i8 %x, i8 %y) {
; CHECK-LABEL: @t7(
; CHECK-NEXT:    ret i1 true
;
  %cmp = icmp slt i8 %y, 0
  %not_null = icmp ne i8 %y, 0
  %no_underflow = icmp ule i8 %y, %x
  %r = or i1 %not_null, %no_underflow
  ret i1 %r
}

; If we check that no underflow happened and that the result is null,
; we can just check for null.
define i1 @t8(i8 %x, i8 %y) {
; CHECK-LABEL: @t8(
; CHECK-NEXT:    [[NOT_NULL:%.*]] = icmp eq i8 [[Y:%.*]], 0
; CHECK-NEXT:    ret i1 [[NOT_NULL]]
;
  %not_null = icmp eq i8 %y, 0
  %no_underflow = icmp ule i8 %y, %x
  %r = and i1 %not_null, %no_underflow
  ret i1 %r
}
; Likewise, if we check that result is non-null or underflow happened,
; we can just check for null.
define i1 @t9(i8 %x, i8 %y) {
; CHECK-LABEL: @t9(
; CHECK-NEXT:    [[NOT_NULL:%.*]] = icmp ne i8 [[Y:%.*]], 0
; CHECK-NEXT:    ret i1 [[NOT_NULL]]
;
  %not_null = icmp ne i8 %y, 0
  %no_underflow = icmp ugt i8 %y, %x
  %r = or i1 %not_null, %no_underflow
  ret i1 %r
}

; If we check that no underflow happened or that the result is not null,
; we can just check for lack of underflow.
define i1 @t10(i8 %x, i8 %y) {
; CHECK-LABEL: @t10(
; CHECK-NEXT:    [[NO_UNDERFLOW:%.*]] = icmp ule i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[NO_UNDERFLOW]]
;
  %not_null = icmp eq i8 %y, 0
  %no_underflow = icmp ule i8 %y, %x
  %r = or i1 %not_null, %no_underflow
  ret i1 %r
}
; Likewise, if we check that underflow happened and that the result is not null,
; we can just check for lack of underflow.
define i1 @t11(i8 %x, i8 %y) {
; CHECK-LABEL: @t11(
; CHECK-NEXT:    [[NO_UNDERFLOW:%.*]] = icmp ugt i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[NO_UNDERFLOW]]
;
  %not_null = icmp ne i8 %y, 0
  %no_underflow = icmp ugt i8 %y, %x
  %r = and i1 %not_null, %no_underflow
  ret i1 %r
}
